package tv.twitch.android.player;

public class Size {
    public final int width;
    public final int height;

    public Size(int width, int height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Size) {
            Size size = (Size) obj;
            return width == size.width && height == size.height;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return width * 31 + height;
    }

    @Override
    public String toString() {
        return width + "x" + height;
    }

    @SuppressWarnings("SuspiciousNameCombination")
    public Size flip() {
        return new Size(height, width);
    }
}
