package tv.twitch.android.player;

import android.media.MediaCodec;
import android.view.Surface;

@SuppressWarnings("unused") // called from native
interface VideoRenderer extends MediaRenderer {
    interface VideoSizeListener {
        void onSizeChange(int width, int height);
    }

    interface SurfaceChangeListener {
        void onSurfaceChange(Surface surface);
    }

    void render(MediaCodec codec, int index, long presentationTimeUs);
    int getDroppedFrames();
    int getRenderedFrames();
    Size getVideoSize();
    void setMediaTime(long time);
    Surface getSurface();
    void setSurface(Surface surface);
    void setSurfaceChangeListener(SurfaceChangeListener listener);
}
