package tv.twitch.android.player.http;

import java.nio.ByteBuffer;

@SuppressWarnings("unused") // called from native
class NativeReadCallback implements ReadCallback {

    private final long ptr;

    public NativeReadCallback(long ptr) {
        this.ptr = ptr;
    }

    @Override
    public boolean onBuffer(ByteBuffer buffer, int read, boolean endOfStream) {
        return onBuffer(ptr, buffer, read, endOfStream);
    }

    @Override
    public void onError(Exception e) {
        onError(ptr, e);
    }

    @Override
    public int getTimeout() {
        return getTimeout(ptr);
    }

    private native int getTimeout(long ptr);
    private native boolean onBuffer(long ptr, ByteBuffer buffer, int size, boolean endOfStream);
    private native void onError(long ptr, Exception e);
}
