package tv.twitch.android.player.http;

@SuppressWarnings("unused") // called from native
class NativeResponseCallback implements ResponseCallback {

    private final long ptr;

    public NativeResponseCallback(long ptr) {
        this.ptr = ptr;
    }

    @Override
    public void onResponse(Response response) {
        onResponse(ptr, response);
    }

    @Override
    public void onError(Exception e) {
        onError(ptr, e);
    }

    private native void onResponse(long ptr, Response response);
    private native void onError(long ptr, Exception e);
}
