package tv.twitch.android.player.http;

import java.nio.ByteBuffer;

@SuppressWarnings("unused") // called from native
class NativeWriteCallback implements WriteCallback {

    private final long ptr;

    public NativeWriteCallback(long ptr) {
        this.ptr = ptr;
    }

    @Override
    public void onBuffer(ByteBuffer buffer, int size) {
        onBuffer(ptr, buffer, size);
    }

    @Override
    public void onError(Exception e) {
        e.printStackTrace();
    }

    private native void onBuffer(long ptr, ByteBuffer buffer, int size);
}
