package tv.twitch.android.player.http;

import java.util.LinkedHashMap;
import java.util.Map;

public class Response {

    private final int status;
    private final Map<String, String> headers = new LinkedHashMap<>();
    private StreamConsumer consumer;

    Response(int status) {
        this.status = status;
    }

    public int getStatus() {
        return status;
    }

    public void setConsumer(StreamConsumer consumer) {
        this.consumer = consumer;
    }

    public Map<String, String> getHeaders() {
        return headers;
    }

    public String getHeader(String key) {
        return headers.get(key);
    }

    public void readContent(ReadCallback callback) {
        consumer.consume(callback);
    }
}
