#include "ASLog.hpp"
#include "platform/NativePlatform.hpp"

#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdeprecated-declarations" // replaced with os_log on iOS 10

namespace twitch {

ASLog::ASLog(const char* name)
    : m_handle(asl_open(name, NULL, ASL_OPT_STDERR))
{
}

ASLog::~ASLog()
{
    asl_close(m_handle);
}

int aslLevel(Log::Level level)
{
    int aslLevel;

    switch (level) {
    case Log::Level::Info:
        aslLevel = ASL_LEVEL_INFO;
        break;

    case Log::Level::Debug:
        aslLevel = ASL_LEVEL_DEBUG;
        break;

    case Log::Level::Warning:
        aslLevel = ASL_LEVEL_WARNING;
        break;

    case Log::Level::Error:
        aslLevel = ASL_LEVEL_ERR;
        break;
    }
    return aslLevel;
}

void ASLog::log(Level level, const char* format, va_list args) const
{
    if (NativePlatform::getLogMessageHandler()) {
        const int MaxLength = 1024;
        char buf[MaxLength] = { '\0' };
        std::vsnprintf(buf, MaxLength, format, args);
        std::string line = buf;
        NativePlatform::getLogMessageHandler()(level, line);
    }
    else {
        asl_vlog(m_handle, NULL, aslLevel(level), format, args);
    }
}

void ASLog::setLevel(Level level)
{
    asl_set_filter(m_handle, ASL_FILTER_MASK_UPTO(aslLevel(level)));
}
}

#pragma clang diagnostic pop
