#pragma once

#include "playercore/Log.hpp"
#include <asl.h>

namespace twitch {
/** Logs to Apple System Log (can be replaced with os_log on iOS 10) */
class ASLog : public Log {
public:
    ASLog(const char* name = "Twitch");
    virtual ~ASLog();
    void log(Level level, const char* format, va_list args) const override;
    void setLevel(Level level) override;

private:
    asl_object_t m_handle;
};
}
