#pragma once

#include "TTVAVPlayerObserver.h"
#include "TTVLoopbackResourceLoaderDelegate.h"
#include "media/FragmentSample.hpp"
#include "player/ScopedScheduler.hpp"
#include "playercore/MediaSink.hpp"
#include "playercore/platform/NativePlatform.hpp"
#import <AVFoundation/AVFoundation.h>
#include <map>
#include <vector>

namespace twitch {
class AVPlayerSink : public MediaSink,
                     private ScopedScheduler {
public:
    AVPlayerSink(MediaSink::Listener& listener, std::shared_ptr<Scheduler> scheduler);
    ~AVPlayerSink() override;
    AVPlayerSink(const AVPlayerSink&) = delete;
    const AVPlayerSink& operator=(const AVPlayerSink&) = delete;

    void configure(int track, std::shared_ptr<MediaFormat> format) override;
    void endOfStream() override { m_ended = true; }
    void enqueue(int track, std::shared_ptr<MediaSampleBuffer> sample) override;
    void flush() override {}
    void play() override;
    void prepare() override;
    void pause() override;
    void remove(const TimeRange& range) override { (void)range; }
    void reset() override;
    void seekTo(MediaTime time) override;
    void setPlaybackRate(float rate) override;
    void setSurface(void* surface) override;
    void setVolume(float volume) override;
    bool isEnded() { return m_ended; }
    void init();
    void enqueueSampleBuffer(std::shared_ptr<media::FragmentSample> sample);
    std::shared_ptr<MediaFormat> getFormat() { return m_format; }
    const std::vector<std::shared_ptr<media::FragmentSample>>& getSamples(int sequence);
    std::string generatePlaylist(const std::string& baseUrl);
    AVPlayer* getPlayer() { return m_player; };
    bool isAirPlayEnabled();
    bool isPassthroughMode() { return m_isPassthrough; };
    std::vector<uint8_t> readSegmentData(int sequence);

private:
    MediaSink::Listener& m_listener;
    std::shared_ptr<Scheduler> m_scheduler;
    Mutex m_mutex;
    std::map<int, std::vector<std::shared_ptr<media::FragmentSample>>> m_segments;
    TTVLoopbackResourceLoaderDelegate* m_delegate;
    TTVAVPlayerObserver* m_observer;
    AVPlayer* m_player;
    bool m_paused;
    int m_sequenceNum;
    bool m_ended;
    std::shared_ptr<MediaFormat> m_format;
    bool m_isPassthrough;
    std::map<int, size_t> m_currentIndexes;
};
}
