#pragma once

#include "media/FileReaderFactory.hpp"
#include "playercore/platform/ios/IOSPlatform.hpp"
#include <MacTypes.h>

namespace twitch {
class ApplePlatform : public IOSPlatform {
public:
    ApplePlatform();
    virtual ~ApplePlatform() = default;
    std::unique_ptr<MediaDecoder> createDecoder(std::shared_ptr<const MediaFormat> format) override;
    std::unique_ptr<MediaRenderer> createRenderer(const ReferenceClock& clock, std::shared_ptr<const MediaFormat> format) override;
    std::unique_ptr<MediaSource> createSource(const std::string& path, const MediaType& mediaType,
        MediaSource::Listener& listener, std::shared_ptr<Scheduler> scheduler) override;
    std::unique_ptr<MediaSink> createSink(MediaSink::Listener& listener, std::shared_ptr<Scheduler> scheduler) override;
    std::shared_ptr<Log> getLog() const override { return m_log; }
    std::shared_ptr<HttpClient> getHttpClient() const override { return m_client; }
    std::shared_ptr<MediaReaderFactory> getMediaReaderFactory() const override { return m_readerFactory; }
    const std::string& getName() const override { return m_name; }
    const std::string& getTempPath() const override { return m_tempPath; }
    const Capabilities& getCapabilities() const override { return m_capabilities; }
    const std::set<MediaType>& getSupportedMediaTypes() const override;
    const std::set<std::vector<uint8_t>>& getSupportedProtectionSystems() const override;
    void setCurrentThreadName(const std::string& name) override;
    void setPassthroughMode(bool enabled) override;

    static UInt32 getAudioSessionSampleRate();

private:
    std::string m_name;
    std::string m_tempPath;
    Capabilities m_capabilities;
    std::shared_ptr<HttpClient> m_client;
    std::shared_ptr<media::FileReaderFactory> m_readerFactory;
    std::shared_ptr<Log> m_log;
    bool m_passthroughMode;
};
}
