//
//  AudioConverterDecoder.hpp
//  player-core
//
//  Created by Purushe, Nikhil on 11/1/16.
//
//

#pragma once

#include "ApplePlatform.h"
#include "playercore/Log.hpp"
#include "playercore/MediaDecoder.hpp"
#include "playercore/MediaRenderer.hpp"
#include <AudioToolbox/AudioToolbox.h>
#include <CoreMedia/CoreMedia.h>
#include <queue>
#include <thread>

namespace twitch {
class AudioConverterDecoder : public MediaDecoder {
public:
    AudioConverterDecoder(std::shared_ptr<Log> log);
    virtual ~AudioConverterDecoder();
    MediaResult configure(const MediaFormat& input, MediaFormat& output) override;
    MediaResult decode(const MediaSampleBuffer& input) override;
    MediaResult hasOutput(bool& hasOutput) override;
    MediaResult getOutput(std::shared_ptr<MediaSample>& output) override;
    MediaResult flush() override;
    MediaResult reset() override;

private:
    static OSStatus inputCallback(AudioConverterRef inAudioConverter,
        UInt32* ioNumberDataPackets,
        AudioBufferList* ioData,
        AudioStreamPacketDescription** outDataPacketDescription,
        void* inUserData);
    void createAudioBufferList(AudioBufferList& list);
    void freeAudioBufferList(AudioBufferList& list);
    void setOutputFormat(MediaFormat& output);
    MediaResult check(OSStatus status, const char* message);

    std::shared_ptr<Log> m_log;
    AudioConverterRef m_audioConverter;
    AudioBufferList m_inputBuffers;
    AudioBufferList m_outputBuffers;
    AudioStreamBasicDescription m_inputDescription;
    AudioStreamBasicDescription m_outputDescription;
    AudioStreamPacketDescription m_outputPacketDescription;
    UInt32 m_outputFrameSize;
    MediaTime m_sampleTime;
};
}
