#pragma once

#include "AudioConverterDecoder.hpp"
#include "playercore/Log.hpp"
#include "playercore/MediaRenderer.hpp"
#include <AudioToolbox/AudioToolbox.H>

namespace twitch {
class AudioQueueRenderer : public AudioRenderer {
public:
    AudioQueueRenderer(std::shared_ptr<Log> log);
    virtual ~AudioQueueRenderer();
    MediaResult configure(const MediaFormat& format) override;
    MediaResult render(std::shared_ptr<const MediaSample> input) override;
    MediaResult getRenderedPresentationTime(MediaTime& time) override;
    MediaResult start() override;
    MediaResult stop() override;
    MediaResult flush() override;
    MediaResult setPlaybackRate(float rate) override;
    MediaResult setVolume(float volume) override;

private:
    void disposeQueue();
    void resetState();
    void fillBuffer(AudioQueueBufferRef inBuffer);
    MediaResult check(OSStatus status, const char* message);
    static void outputCallback(void* inUserData, AudioQueueRef inAQ, AudioQueueBufferRef inBuffer);
    static void propertyListenerCallback(void* inUserData, AudioQueueRef inAQ, AudioQueuePropertyID inID);
    static const int AudioBufferCount = 3;
    std::shared_ptr<Log> m_log;
    AudioStreamBasicDescription m_description;
    AudioQueueRef m_audioQueue;
    AudioQueueBufferRef m_buffers[AudioBufferCount];
    std::queue<std::shared_ptr<const MediaSample>> m_inputQueue;
    std::mutex m_mutex;
    int m_bufferIndex;
    bool m_started;
    bool m_primed;
    MediaTime m_initialSampleTime;
    AudioTimeStamp m_audioTimestamp;
    std::condition_variable m_bufferAvailable;
    float m_playbackRate;
    float m_volume;
    MediaTime m_lastPresentationTime;
};
}
