#pragma once

#include "playercore/MediaSample.hpp"
#include "playercore/MediaTime.hpp"
#include <CoreMedia/CoreMedia.h>

namespace twitch {
template <typename T>
struct CFRef {
    CFRef(T cf)
        : ref(cf)
    {
        if (ref) {
            CFRetain(ref);
        }
    }
    virtual ~CFRef()
    {
        if (ref) {
            CFRelease(ref);
        }
    }
    T ref;
};

struct CMSampleBufferSample : public MediaSample, public CFRef<CMSampleBufferRef> {
    CMSampleBufferSample(CMSampleBufferRef sampleBuffer, CMTime presentationTime, CMTime duration)
        : CFRef(sampleBuffer)
    {
        this->presentationTime = MediaTime(presentationTime.value, presentationTime.timescale);
        this->duration = MediaTime(duration.value, duration.timescale);
    }
    virtual ~CMSampleBufferSample() = default;
};
}
