#pragma once

#import "TTVURLSessionDelegate.h"
#include "playercore/platform/HttpClient.hpp"
#import <Foundation/Foundation.h>

namespace twitch {
class CocoaHttpClient : public HttpClient {
public:
    CocoaHttpClient();
    ~CocoaHttpClient();

    std::shared_ptr<HttpRequest> createRequest(const std::string& url, HttpMethod method = HttpMethod::GET) override;
    void send(std::shared_ptr<HttpRequest> request, ResponseHandler onResponse, ErrorHandler onError) override;

private:
    NSURLSession* m_session;
    TTVURLSessionDelegate* m_delegate;
};
}
