#import "CocoaHttpClient.h"
#import "CocoaHttpRequest.h"

namespace twitch {
CocoaHttpClient::CocoaHttpClient()
{
    NSURLSessionConfiguration* configuration = [NSURLSessionConfiguration defaultSessionConfiguration];
    m_delegate = [[TTVURLSessionDelegate alloc] init];
    m_session = [NSURLSession sessionWithConfiguration:configuration delegate:m_delegate delegateQueue:nil];
}

CocoaHttpClient::~CocoaHttpClient()
{
    [m_session invalidateAndCancel];
    m_delegate = nil;
}

std::shared_ptr<HttpRequest> CocoaHttpClient::createRequest(const std::string& url, HttpMethod method)
{
    return std::make_shared<CocoaHttpRequest>(url, method);
}

void CocoaHttpClient::send(std::shared_ptr<HttpRequest> request, ResponseHandler onResponse, ErrorHandler onError)
{
    auto iosRequest = std::static_pointer_cast<CocoaHttpRequest>(request);
    if (iosRequest != nil) {
        NSURLSessionTask* task = iosRequest->send(m_session, onResponse, onError);
        [m_delegate addRequestWithIdentifier:[task taskIdentifier]:iosRequest];
        [task resume];
    }
}
}
