#pragma once

#import "TTVURLSessionDelegate.h"
#include "playercore/platform/HttpClient.hpp"
#include "playercore/platform/HttpRequest.hpp"
#import <Foundation/Foundation.h>

namespace twitch {
class CocoaHttpResponse;
class CocoaHttpRequest : public HttpRequest {
public:
    CocoaHttpRequest(const std::string& url, HttpMethod method);
    ~CocoaHttpRequest() { cancel(); }
    bool isCancelled() const { return m_cancelled; }
    void cancel() override;
    void setHeader(const std::string& key, const std::string& value) override;
    void setContent(const std::vector<uint8_t>& content) override;
    NSURLSessionTask* send(NSURLSession* session, HttpClient::ResponseHandler onResponse, HttpClient::ErrorHandler onError);
    void onCompletedWithError(NSError* error);
    void onResponse(std::shared_ptr<CocoaHttpResponse> response);
    void onData(const uint8_t* data, size_t size, bool endOfStream);

private:
    NSMutableURLRequest* m_urlRequest;
    NSURLSessionTask* m_task;
    NSURLSessionStreamTask* m_streamTask;
    bool m_cancelled;
    std::shared_ptr<CocoaHttpResponse> m_response;
    HttpClient::ResponseHandler m_onResponse;
    HttpClient::ErrorHandler m_onError;
};
}
