#pragma once

#import "TTVURLSessionDelegate.h"
#include "playercore/platform/HttpResponse.hpp"
#import <Foundation/Foundation.h>

namespace twitch {
class CocoaHttpResponse : public HttpResponse {
public:
    CocoaHttpResponse(NSHTTPURLResponse* response, void (^completionHandler)(NSURLSessionResponseDisposition disposition), int status);
    ~CocoaHttpResponse() = default;
    void read(ContentHandler onBuffer, ErrorHandler onError) override;
    std::string getHeader(const std::string& key) const override;
    const ErrorHandler& getErrorHandler() const { return m_errorHandler; }
    void onData(const uint8_t* data, size_t size, bool endOfStream);
private:
    NSHTTPURLResponse* m_response;
    ContentHandler m_contentHandler;
    ErrorHandler m_errorHandler;
    void (^m_completionHandler)(NSURLSessionResponseDisposition disposition);
};
}
