#import "CocoaHttpResponse.h"

namespace twitch {
CocoaHttpResponse::CocoaHttpResponse(NSHTTPURLResponse* response, void (^completionHandler)(NSURLSessionResponseDisposition disposition), int status)
    : HttpResponse(status)
    , m_response(response)
    , m_completionHandler(completionHandler)
{
}

void CocoaHttpResponse::read(ContentHandler onBuffer, ErrorHandler onError)
{
    m_contentHandler = onBuffer;
    m_errorHandler = onError;
    m_completionHandler(NSURLSessionResponseAllow);
}

std::string CocoaHttpResponse::getHeader(const std::string& key) const
{
    if (m_response) {
        NSDictionary* allHeaders = [m_response allHeaderFields];
        NSString* keyString = [NSString stringWithUTF8String:key.c_str()];
        NSString* value = allHeaders[keyString];
        if (value) {
            return std::string([value UTF8String]);
        }
    }
    return "";
}

void CocoaHttpResponse::onData(const uint8_t* data, size_t size, bool endOfStream)
{
    m_contentHandler(data, size, endOfStream);
}
}
