//
//  DisplayLayerRenderer
//  player-core
//
//  Created by Purushe, Nikhil on 11/1/16.
//
//

#pragma once

#include "playercore/ReferenceClock.hpp"
#include "playercore/platform/VideoRenderer.hpp"
#include <AVFoundation/AVFoundation.h>

namespace twitch {
class DisplayLayerRenderer : public VideoRenderer {
public:
    DisplayLayerRenderer(const ReferenceClock& clock);
    virtual ~DisplayLayerRenderer() = default;
    MediaResult configure(const MediaFormat& format) override;
    MediaResult render(std::shared_ptr<const MediaSample> input) override;
    MediaResult getDroppedFrames(int& count) override;
    MediaResult getRenderedFrames(int& count) override;
    MediaResult getRenderedPresentationTime(MediaTime& time) override;
    MediaResult start() override;
    MediaResult stop() override;
    MediaResult flush() override;
    MediaResult setPlaybackRate(float rate) override;
    MediaResult setSurface(void* surface) override;

private:
    const ReferenceClock& m_clock;
    float m_playbackRate;
    MediaTime m_startTime;
    MediaTime m_mediaTime;
    AVSampleBufferDisplayLayer* m_layer;
    CMTime m_lastPresentationTimeStamp;
    int m_droppedFrames;
    int m_renderedFrames;
};
}
