#pragma once

#include "player/ScopedScheduler.hpp"
#include "playercore/MediaSample.hpp"
#include "playercore/MediaSink.hpp"
#include <AVFoundation/AVFoundation.h>
#import <UIKit/UIKit.h>
#include <deque>

namespace twitch {
class AVPlayerSink;
class ScopedScheduler;
}

@interface TTVAVPlayerObserver : NSObject
- (TTVAVPlayerObserver* _Nonnull)initWithPlayer:(AVPlayer* _Nonnull)player
                                               :(twitch::MediaSink::Listener* _Nonnull)listener
                                               :(std::shared_ptr<twitch::Scheduler>)scheduler
                                               :(twitch::AVPlayerSink* _Nonnull)AVplayerSink;
- (void)enqueueFormat:(std::shared_ptr<twitch::MediaFormat>)format;
- (void)enqueueSample:(std::shared_ptr<twitch::MediaSampleBuffer>)sample;
- (void)seekTo:(CMTime)time;
- (void)timeObserved:(CMTime)time;
- (void)observeItem:(AVPlayerItem* _Nullable)item;
- (void)unobserveItem:(AVPlayerItem* _Nullable)item;

@end
