#pragma once

#import "GCDWebServer.h"
#import "GCDWebServerDataResponse.h"
#import "GCDWebServerStreamedResponse.h"
#include "hls/MediaPlaylist.hpp"
#include "playercore/MediaSample.hpp"
#include <AVFoundation/AVFoundation.h>
#include <vector>

namespace twitch {
class AVPlayerSink;
}

@interface TTVLoopbackResourceLoaderDelegate : NSObject <AVAssetResourceLoaderDelegate> {
    twitch::AVPlayerSink* playerSink;
@public
    GCDWebServer* server;
}

- (TTVLoopbackResourceLoaderDelegate*)init:(twitch::AVPlayerSink*)AVplayerSink;
- (void)writeSegmentData:(int)sequence
                        :(GCDWebServerBodyReaderCompletionBlock)block;

@end
