
#import "TTVLoopbackResourceLoaderDelegate.h"
#import "AVPlayerSink.h"

static NSString* customPlaylistScheme = @"twitch";
@implementation TTVLoopbackResourceLoaderDelegate

//Create loopback Server using GCDWebServer
- (TTVLoopbackResourceLoaderDelegate*)init:(twitch::AVPlayerSink*)AVplayerSink
{
    self = [super init];
    TTVLoopbackResourceLoaderDelegate __weak* weakSelf = self;
    self->playerSink = AVplayerSink;

    server = [[GCDWebServer alloc] init];
    // Add a handler to respond to GET requests on any URL
    [server addDefaultHandlerForMethod:@"GET"
                          requestClass:[GCDWebServerRequest class]
                     asyncProcessBlock:^(GCDWebServerRequest* request, GCDWebServerCompletionBlock completionBlock) {
                         NSString* requestPath = [[request.path stringByReplacingOccurrencesOfString:@"/" withString:@""] stringByDeletingPathExtension];
                         int sequence = [requestPath intValue];

                         GCDWebServerStreamedResponse* response =
                             [GCDWebServerStreamedResponse responseWithContentType:@"application/octet-stream"
                                                                  asyncStreamBlock:^(GCDWebServerBodyReaderCompletionBlock completionBlock) {

                                                                      if (!weakSelf) {
                                                                          NSError* error = [NSError errorWithDomain:NSURLErrorDomain code:0 userInfo:nil];
                                                                          completionBlock([NSData data], error);
                                                                          return;
                                                                      }

                                                                      [weakSelf writeSegmentData:sequence:completionBlock];
                                                                  }];

                         completionBlock(response);
                     }];

    // Start server on local host and disable automatic background suspension for PictureinPicture support
    NSMutableDictionary* options = [NSMutableDictionary dictionary];
    [options setObject:@YES forKey:GCDWebServerOption_BindToLocalhost];
    [options setObject:@"" forKey:GCDWebServerOption_BonjourName];
    [options setObject:@NO forKey:GCDWebServerOption_AutomaticallySuspendInBackground];

    NSError* error = nil;
    [server startWithOptions:options error:&error];

    return self;
}

- (void)dealloc
{
    if (server.isRunning) {
        [server stop];
    }
}

- (void)writeSegmentData:(int)sequence
                        :(GCDWebServerBodyReaderCompletionBlock)block
{
    std::vector<uint8_t> buffer = self->playerSink->readSegmentData(sequence);
    if (!buffer.empty()) {
        block([NSData dataWithBytesNoCopy:buffer.data() length:buffer.size() freeWhenDone:NO], nil);
    } else {
        block([NSData data], nil);
    }
}

/*!
 *  AVARLDelegate's implementation of the protocol.
 *  Generate custom playlist
 */
- (BOOL)resourceLoader:(AVAssetResourceLoader*)resourceLoader shouldWaitForLoadingOfRequestedResource:(AVAssetResourceLoadingRequest*)loadingRequest
{
    (void)resourceLoader;
    NSString* scheme = [[[loadingRequest request] URL] scheme];

    if (server && server.isRunning && [customPlaylistScheme isEqualToString:scheme]) {
        std::string baseUrl([server.serverURL.absoluteString UTF8String]);
        std::string playlist = self->playerSink->generatePlaylist(baseUrl);
        NSString* playlistString = [NSString stringWithCString:playlist.c_str() encoding:[NSString defaultCStringEncoding]];
        //NSLog(@"playlist is %@", playlistString);

        NSData* data = [playlistString dataUsingEncoding:NSUTF8StringEncoding];
        [loadingRequest.dataRequest respondWithData:data];
        [loadingRequest finishLoading];
        return YES;
    }

    return NO;
}

@end
