#import <CoreMedia/CoreMedia.h>
#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@protocol TTVObserver
- (void)update:(CMTime)current;
- (void)reset;
@end

@interface TTVPeriodicObserver : NSObject <TTVObserver>
@property (nonatomic, strong) dispatch_queue_t _Nullable queue;
@property (nonatomic, strong) void (^_Nonnull block)(CMTime);
@property (nonatomic) CMTime interval;
@property (nonatomic) CMTime timer;
@end

@interface TTVBoundaryObserver : NSObject <TTVObserver>
- (instancetype _Nonnull)init NS_UNAVAILABLE;
- (instancetype _Nonnull)initWithValues:(unsigned long)size;
@property (nonatomic, strong) dispatch_queue_t _Nullable queue;
@property (nonatomic, strong) void (^_Nonnull block)();
@property (nonatomic, strong) NSArray<NSValue*>* times;
@end

NS_ASSUME_NONNULL_END
