#import "TTVObserver.h"
#import <AVFoundation/AVFoundation.h>
#import <vector>

@implementation TTVPeriodicObserver
- (instancetype _Nonnull)init
{
    self = [super init];
    _queue = nil;
    return self;
}

- (void)dispatch:(CMTime)current
{
    if (_queue == nil) {
        dispatch_async(dispatch_get_main_queue(), ^{
            _block(current);
        });
    } else {
        dispatch_async(_queue, ^{
            _block(current);
        });
    }
}

- (void)update:(CMTime)current
{
    if (CMTimeCompare(_timer, current) != -1) {
        return;
    }
    [self dispatch:current];
    // fast forward
    // timer is behind more than one interval from the current playback position.
    if (CMTimeCompare(_interval, kCMTimeZero) == 1) {
        while (CMTimeCompare(_timer, current) != 1) {
            _timer = CMTimeAdd(_timer, _interval);
        }
    }
}

- (void)reset
{
    _timer = _interval;
}
@end

@implementation TTVBoundaryObserver
- (instancetype _Nonnull)initWithValues:(unsigned long)size
{
    self = [super init];
    _queue = nil;
    m_visited.resize(size);
    return self;
}

- (void)dispatch
{
    if (_queue == nil) {
        dispatch_async(dispatch_get_main_queue(), ^{
            _block();
        });
    } else {
        dispatch_async(_queue, ^{
            _block();
        });
    }
}

- (void)update:(CMTime)current
{
    unsigned long count = [_times count];
    for (unsigned long i = 0; i < count; ++i) {
        if (m_visited[i] == false) {
            NSValue* val = [_times objectAtIndex:i];
            CMTime cmt = [val CMTimeValue];
            if (CMTimeCompare(cmt, current) != 1) {
                [self dispatch];
                m_visited[i] = true;
            }
        }
    }
}

- (void)reset
{
    for (size_t i = 0; i < m_visited.size(); ++i) {
        m_visited[i] = false;
    }
}

std::vector<bool> m_visited;
@end
