#import "TTVPlayerLayer.h"
#import <AVFoundation/AVFoundation.h>
#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@class TTVPlayer;
@protocol TTVPlayerDelegate <NSObject>
/*!
 @method     onAnalyticsEvent:
 @abstract   indicates the duration of the media has changed.
 @param      sender player instance
 */
- (void)onAnalyticsEvent:(TTVPlayer*)sender
                        :(NSString*)name
                        :(NSDictionary*)dictionary;

/*!
    @method     onDurationChanged:
    @abstract	indicates the duration of the media has changed.
    @param		sender player instance
 */
- (void)onDurationChanged:(TTVPlayer*)sender;

/*!
    @method     onStateChanged:
    @abstract	indicates the state of the player has changed.
    @param		sender player instance
 */
- (void)onStateChanged:(TTVPlayer*)sender;

/*!
    @method     onError:
    @abstract	indicates the player has errored.
    @param      sender player instance
    @param      error error instance
 */
- (void)onError:(TTVPlayer*)sender
               :(NSError*)error;

/*!
    @method     onQualityChanged:
    @abstract	indicates the playing quality has changed.
    @param		sender player instance
    @param      quality name
 */
- (void)onQualityChanged:(TTVPlayer*)sender
                        :(NSString*)name;

/*!
 @method     onMetadata:
 @abstract   indicates timed metadata in the playback stream
 @param      sender player instance
 @param      type media type of the metadata e.g. "application/json"
 @param      content binary content, the type of content depends on the media type
 */
- (void)onMetadata:(TTVPlayer*)sender
                  :(NSString*)type
                  :(NSData*)content;

/*!
 @method     onSeekCompleted:
 @abstract   indicates a seek operation completed
 @param      sender player instance
 @param      time time that was seeked to
 */
- (void)onSeekCompleted:(TTVPlayer*)sender
                       :(CMTime)time;

/*!
 @method     onExternalPlaybackChanged:
 @abstract   indicates if the external playback has changed.
 @param      sender player instance
 */
- (void)onExternalPlaybackChanged:(TTVPlayer*)sender;

/*!
 @method     onPlayerItemChanged:
 @abstract   indicates if the player item has changed.
 @param      changed playerItem
 */
- (void)onPlayerItemChanged:(TTVPlayer*)sender
                           :(AVPlayerItem*)playerItem;

@end

NS_ASSUME_NONNULL_END
