#import <AVFoundation/AVBase.h>
#import <AVFoundation/AVSampleBufferDisplayLayer.h>
#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@interface TTVPlayerLayer : AVSampleBufferDisplayLayer

@property (nonatomic, readonly, getter=isReadyForDisplay) BOOL readyForDisplay;
@property (nonatomic, readonly) CGRect videoRect;
@property (nonatomic, copy, nullable) NSDictionary<NSString*, id>* pixelBufferAttributes;

@property (nonatomic) NSString* caption;
- (void)setCaption:(NSString*)caption;
- (void)setCaptionON:(BOOL)captionON;

@end

NS_ASSUME_NONNULL_END
