#import "TTVPlayerLayer.h"
#import <UIKit/UIKit.h>

@interface TTVPlayerLayer () {
    UILabel* _captionView;
}
@property (nonatomic) BOOL captionON;
@end

@implementation TTVPlayerLayer

- (void)setFrame:(CGRect)frame
{
    [super setFrame:frame];
    const int captionHeight = 300;
    frame.origin.y = frame.size.height - captionHeight;
    frame.size.height = captionHeight;
    self->_captionView = [[UILabel alloc] initWithFrame:frame];
    self->_captionView.backgroundColor = [UIColor colorWithRed:0.0 green:0.0 blue:0.0 alpha:0.3];
    self->_captionView.textColor = [UIColor whiteColor];
    self->_captionView.numberOfLines = 7;
    self->_captionView.textAlignment = NSTextAlignmentCenter;
    [self->_captionView setHidden:YES];
    [self addSublayer:self->_captionView.layer];
}

- (void)setCaption:(NSString*)caption
{
    if (caption == self->_caption) {
        return;
    }
    [self->_captionView setText:caption];
    self->_caption = caption;
}

- (void)setCaptionON:(BOOL)captionON
{
    [self->_captionView setHidden:!captionON];
    self->_captionON = captionON;
}

@end
