#pragma once

#include "CMSampleBufferSample.hpp"
#include "playercore/Log.hpp"
#include "playercore/MediaDecoder.hpp"
#include <CoreMedia/CoreMedia.h>
#include <VideoToolbox/VideoToolbox.h>
#include <queue>

namespace twitch {
class VTDecoder : public MediaDecoder {
public:
    VTDecoder(std::shared_ptr<Log> log);
    virtual ~VTDecoder();
    MediaResult configure(const MediaFormat& input, MediaFormat& output) override;
    MediaResult decode(const MediaSampleBuffer& input) override;
    MediaResult hasOutput(bool& hasOutput) override;
    MediaResult getOutput(std::shared_ptr<MediaSample>& output) override;
    MediaResult flush() override;
    MediaResult reset() override;

private:
    MediaResult check(OSStatus status, const char* message);
    void decompressionOutput(OSStatus status, VTDecodeInfoFlags infoFlags,
        CVImageBufferRef imageBuffer,
        CMTime presentationTimeStamp,
        CMTime presentationDuration);
    void releaseFormatDescription(CMVideoFormatDescriptionRef& formatDescription);
    void releaseSession();

    static void decompressionOutputCallback(void* decompressionOutputRefCon,
        void* sourceFrameRefCon,
        OSStatus status, VTDecodeInfoFlags infoFlags,
        CVImageBufferRef imageBuffer,
        CMTime presentationTimeStamp,
        CMTime presentationDuration);
    std::shared_ptr<Log> m_log;
    CMVideoFormatDescriptionRef m_formatDescription;
    CMVideoFormatDescriptionRef m_outputDescription;
    VTDecompressionSessionRef m_decompressionSession;
    OSStatus m_decodeStatus;
    std::queue<std::shared_ptr<CMSampleBufferSample>> m_outputBuffers;
    std::mutex m_outputMutex;
    int m_droppedFrames;
};
}
