#pragma once

#include "CurlHttpRequest.hpp"
#include "CurlHttpResponse.hpp"
#include "playercore/platform/HttpClient.hpp"
#include <atomic>
#include <curl/curl.h>
#include <mutex>
#include <string>

namespace twitch {
struct CurlContext : public std::enable_shared_from_this<CurlContext> {
    CurlContext();
    virtual ~CurlContext();
    CURLcode perform(CurlHttpRequest::State& current, CurlHttpRequest::State next, std::chrono::seconds timeout);

    CURLM* getHandle() { return m_multi; }

private:
    CURLM* m_multi;
    std::atomic<bool> m_canceled;
};
}
