#include "CurlHttpClient.hpp"
#include "CurlContext.hpp"
#include "CurlHttpRequest.hpp"
#include "debug/trace.hpp"
#include <curl/curl.h>

namespace twitch {
CurlHttpClient::CurlHttpClient()
{
    curl_global_init(CURL_GLOBAL_ALL);
    m_context = std::make_shared<CurlContext>();
}

CurlHttpClient::~CurlHttpClient()
{
    curl_global_cleanup();
}

std::shared_ptr<HttpRequest> CurlHttpClient::createRequest(const std::string& url, HttpMethod method)
{
    return std::make_shared<CurlHttpRequest>(url, method);
}

void CurlHttpClient::send(std::shared_ptr<HttpRequest> request, ResponseHandler onResponse, ErrorHandler onError)
{
    auto curlRequest = std::static_pointer_cast<CurlHttpRequest>(request);
    curlRequest->setContext(m_context);
    curlRequest->send(onResponse, onError);
}
}
