#pragma once

#include "playercore/platform/HttpClient.hpp"
#include <mutex>
#include <string>

namespace twitch {
struct CurlContext;

class CurlHttpClient : public HttpClient {
public:
    CurlHttpClient();
    ~CurlHttpClient() override;

    std::shared_ptr<HttpRequest> createRequest(const std::string& url, HttpMethod method = HttpMethod::GET) override;

    void send(std::shared_ptr<HttpRequest> request, ResponseHandler onResponse, ErrorHandler onError) override;

private:
    std::shared_ptr<CurlContext> m_context;
};
}
