#pragma once

#include "playercore/platform/HttpClient.hpp"
#include <atomic>
#include <curl/curl.h>
#include <mutex>
#include <string>

namespace twitch {
struct CurlContext;
class CurlHttpResponse;

class CurlHttpRequest : public HttpRequest, public std::enable_shared_from_this<CurlHttpRequest> {
public:
    CurlHttpRequest(const std::string& url, HttpMethod method);
    ~CurlHttpRequest() override;

    void cancel() override;
    bool isCancelled() { return m_cancelled; }
    void setHeader(const std::string& key, const std::string& value) override;
    void setContent(const std::vector<uint8_t>& content) override;
    void setContext(std::shared_ptr<CurlContext> context);

    CURLcode resume(std::chrono::seconds timeout);
    void send(const HttpClient::ResponseHandler& onResponse, const HttpClient::ErrorHandler& onError);

    enum class State {
        SEND_REQUEST,
        HAVE_RESPONSE,
        READ_RESPONSE_BODY,
    };

private:
    static size_t readFunction(char* buffer, size_t size, size_t nmemb, CurlHttpRequest* request);
    static size_t writeFunction(char* buffer, size_t size, size_t nmemb, CurlHttpRequest* request);
    static size_t headerFunction(char* buffer, size_t size, size_t nmemb, CurlHttpRequest* request);

    CURL* m_easy;
    State m_state;
    struct curl_slist* m_curlHeaders;
    std::mutex m_contextMutex;
    std::shared_ptr<CurlContext> m_context;
    std::atomic<bool> m_cancelled;
    HttpHeaderMap m_headers;
    std::vector<uint8_t> m_content;
    size_t m_contentPosition;
    std::weak_ptr<CurlHttpResponse> m_response;
};
}
