#include "CurlHttpResponse.hpp"
#include "CurlContext.hpp"
#include "debug/trace.hpp"
#include <cassert>

namespace twitch {
CurlHttpResponse::CurlHttpResponse(std::shared_ptr<CurlHttpRequest> request, int status)
    : HttpResponse(status)
    , m_request(std::move(request))
    , m_canceled(false)
{
}

CurlHttpResponse::~CurlHttpResponse()
{
    cancel();
}

void CurlHttpResponse::cancel()
{
    m_canceled = true;
}

void CurlHttpResponse::handleContent(const uint8_t* buffer, size_t size, bool endOfStream)
{
    if (m_canceled) {
        return;
    }

    m_contentHandler(buffer, size, endOfStream);
}

void CurlHttpResponse::handleError(int error)
{
    if (!m_canceled && m_errorHandler) {
        m_errorHandler(error);
    }
}

void CurlHttpResponse::read(ContentHandler onBuffer, ErrorHandler onError)
{
    m_contentHandler = onBuffer;
    m_errorHandler = onError;

    // resume curl to read the response body
    CURLcode code = m_request->resume(getReadTimeout());

    if (code == CURLE_OK) {
        handleContent(nullptr, 0, true);
    } else {
        handleError(static_cast<int>(code));
    }
}

std::string CurlHttpResponse::getHeader(const std::string& key) const
{
    auto iter = m_headers.find(key);
    return (iter == m_headers.end()) ? "" : iter->second;
}

void CurlHttpResponse::setHeader(const std::string& key, const std::string& value)
{
    m_headers[key] = value;
}
}
