#pragma once

#include "playercore/platform/HttpClient.hpp"
#include <atomic>
#include <mutex>
#include <string>

namespace twitch {
class CurlHttpRequest;

class CurlHttpResponse : public HttpResponse {
public:
    CurlHttpResponse(std::shared_ptr<CurlHttpRequest> request, int status);
    ~CurlHttpResponse() override;

    void cancel();

    void handleContent(const uint8_t* buffer, size_t size, bool endOfStream);
    void handleError(int error);

    void read(ContentHandler onBuffer, ErrorHandler onError) override;

    std::string getHeader(const std::string& key) const override;
    void setHeader(const std::string& key, const std::string& value);

private:
    std::shared_ptr<CurlHttpRequest> m_request;
    std::atomic<bool> m_canceled;
    ContentHandler m_contentHandler;
    ErrorHandler m_errorHandler;
    twitch::HttpHeaderMap m_headers;
};
}
