#pragma once
#include "media/mp4/fmp4.hpp"
#include "playercore/MediaSink.hpp"
#include "playercore/platform/Scheduler.hpp"
#include <memory>

namespace twitch {
class MP4Sink : public MediaSink {
public:
    MP4Sink(MediaSink::Listener& listener, std::shared_ptr<Scheduler> scheduler, bool flushGops, const std::string& file);
    ~MP4Sink() override = default;

    void configure(int track, std::shared_ptr<MediaFormat> format) override;
    void endOfStream() override;
    void enqueue(int track, std::shared_ptr<MediaSampleBuffer> sample) override;
    void flush() override{};
    void play() override;
    void prepare() override {}
    void pause() override;
    void remove(const TimeRange& range) override;
    void reset() override;
    void seekTo(MediaTime time) override;
    void setPlaybackRate(float rate) override;
    void setSurface(void* surface) override { (void)surface; };
    void setVolume(float volume) override;

private:
    void processVideoSample(const MediaSampleBuffer& sample);
    void processAudioSample(const MediaSampleBuffer& sample);
    void flushInit();
    void flushMedia();
    void flushManifest();

    int m_audioID;
    int m_videoID;
    MediaTime m_currentTime;
    MediaSink::Listener& m_listener;
    std::shared_ptr<Scheduler> m_scheduler;
    std::shared_ptr<Cancellable> m_outstandingPlay;

    std::string m_mp4FileName;
    std::string m_manifestName;
    std::FILE* m_mp4file;
    std::FILE* m_manifest;

    media::fmp4 m_mp4;
    size_t m_fragOffset;
    double m_fragDuration;
    std::shared_ptr<media::fmp4track_aac> m_audioTrack;
    std::shared_ptr<media::fmp4track_avc> m_videoTrack;
    bool m_flushGops;
};

} //namespace twitch
