#pragma once

#include "playercore/platform/NativePlatform.hpp"

namespace twitch {
class PosixPlatform : public NativePlatform {
public:
    explicit PosixPlatform(bool flushGops = false, const std::string& file = std::string());
    ~PosixPlatform() override = default;
    std::unique_ptr<MediaSink> createSink(MediaSink::Listener& listener, std::shared_ptr<Scheduler>) override;
    std::unique_ptr<MediaDecoder> createDecoder(std::shared_ptr<const MediaFormat>) override;
    std::unique_ptr<MediaRenderer> createRenderer(const ReferenceClock& clock, std::shared_ptr<const MediaFormat>) override;
    std::shared_ptr<Log> getLog() const override { return m_log; }
    std::shared_ptr<HttpClient> getHttpClient() const override { return m_httpClient; }
    const std::string& getName() const override { return m_name; }
    const std::string& getTempPath() const override { return m_tempPath; }
    const Capabilities& getCapabilities() const override { return m_capabilities; }
    void onThreadCreated(std::thread::id id, const std::string& name) override;
    void setCurrentThreadName(const std::string& name) override;

private:
    std::string m_name;
    std::string m_tempPath;
    Capabilities m_capabilities;
    std::shared_ptr<Log> m_log;
    std::shared_ptr<HttpClient> m_httpClient;
    bool m_flushGops;
    std::string m_output;
};
}
