#pragma once
#include <app_content.h>
#include <memory>
#include <string>

namespace twitch {
namespace ps4 {
    class AdditionalContent {
    public:
        static int getLastError() { return m_lastError; }
        static bool initialize();
        static bool isInitialized() { return m_initialized; }

    private:
        static bool m_initialized;
        static int m_lastError;
    };

    class TempDirMount {
    public:
        // @return TempDirMount instance if successful, otherwise nullptr
        static std::unique_ptr<TempDirMount> mount();

        ~TempDirMount();

        const std::string& getTempPath() const { return m_tempPath; }

    private:
        TempDirMount(SceAppContentMountPoint&& mountPoint);

        SceAppContentMountPoint	m_mountPoint;
        std::string m_tempPath;
    };
}
}
