#include "AudioClock.hpp"
#include <cassert>

namespace twitch {
namespace ps4 {

MediaTime AudioClock::elapsedPts() const
{
    std::lock_guard<Mutex> lock(m_mutex);
    if (m_sampleRate == 0) {
        return MediaTime::zero();
    }

    return MediaTime(m_numSamplesRendered, m_sampleRate) + m_initialPts;
}

void AudioClock::initialize(MediaTime initialPtsTime, size_t sampleRate)
{
	assert(sampleRate > 0);
	std::lock_guard<Mutex> lock(m_mutex);
	m_initialPts = initialPtsTime;
	m_sampleRate = sampleRate;
}

bool AudioClock::isInitialized() const
{
    std::lock_guard<Mutex> lock(m_mutex);
    return m_sampleRate != 0;
}

void AudioClock::reset()
{
    std::lock_guard<Mutex> lock(m_mutex);
    m_initialPts = MediaTime::zero();
    m_numSamplesRendered = 0;
    m_sampleRate = 0;
}

void AudioClock::update(size_t samplesRendered)
{
    assert(samplesRendered > 0);
    std::lock_guard<Mutex> lock(m_mutex);
    m_numSamplesRendered += samplesRendered;
}

}
}
