#pragma once

#include "playercore/MediaTime.hpp"
#include "util/Concurrency.hpp"
#include <chrono>

namespace twitch {
namespace ps4 {
    class AudioClock {
    public:
        AudioClock() = default;

        MediaTime elapsedPts() const;
		void initialize(MediaTime initialPtsTime, size_t sampleRate);
        bool isInitialized() const;
        void reset();
        void update(size_t samplesRendered);

    private:
        mutable Mutex m_mutex;
        MediaTime m_initialPts = MediaTime::zero();
        size_t m_numSamplesRendered = 0;
        size_t m_sampleRate = 0;
    };
}
}
