#pragma once

#include "playercore/MediaDecoder.hpp"
#include <audiodec.h>
#include <memory>
#include <queue>
#include <vector>

namespace twitch {
namespace ps4 {
    class AudioResampler;
    class OutputStream;

    class AudioDecoder : public MediaDecoder {
    public:
        AudioDecoder();
        ~AudioDecoder() override;

        MediaResult configure(const MediaFormat& input, MediaFormat& output) override;
        MediaResult decode(const MediaSampleBuffer& input) override;
        MediaResult hasOutput(bool& hasOutput) override;
        MediaResult getOutput(std::shared_ptr<MediaSample>& output) override;
        MediaResult flush() override;
        MediaResult reset() override;

        uint32_t getSampleRate() const { return m_sampleRate; }
        uint32_t getNumChannels() const { return m_numChannels; }

        static const int MaxChannels = SCE_AUDIODEC_M4AAC_MAX_CHANNELS_FOR_8CH;
        static const int MaxPcmSize = sizeof(float) * MaxChannels * SCE_AUDIODEC_M4AAC_MAX_FRAME_SAMPLES;

    protected:
    private:
        void addDecodedOutput(const MediaSampleBuffer& input, MediaSampleBuffer::BufferType& sampleBuffer);
        void deleteDecoder();
        bool shouldReconfigure(uint32_t sampleRate, uint32_t numChannels) const;

        bool fixupSampleBuffer(float decodedTime, float expectedTime, MediaSampleBuffer::BufferType& sampleBuffer);

        static bool isValidFrequency(int freq);
        static int frequencyToIndex(int freq);
        void dumpAACFrameInfo(const MediaSampleBuffer& input) const;

        int m_audioHandle = 0;

        // all kind of fun structures used by the Audiodec library
        SceAudiodecCtrl m_audiodecCtrl;
        SceAudiodecParamM4aacEx m_param;
        SceAudiodecM4aacInfo m_info;
        SceAudiodecAuInfo m_au;
        SceAudiodecPcmItem m_pcm;

        uint32_t m_sampleRate;
        uint32_t m_numChannels;
        uint32_t m_inputChannels;

        std::queue<std::shared_ptr<MediaSampleBuffer>> m_outputSamples;
        std::unique_ptr<AudioResampler> m_resampler;
    };
}
}
