#pragma once

#include "AudioOutputStream.hpp"
#include "AudioSample.hpp"
#include "playercore/MediaRenderer.hpp"

namespace twitch {
namespace ps4 {
    class AudioResampler;
    class AudioClock;

    class AudioRenderer : public twitch::AudioRenderer {
    public:
        AudioRenderer();
        virtual ~AudioRenderer() = default;
        MediaResult configure(const MediaFormat& format) override;
        MediaResult render(std::shared_ptr<const MediaSample> sample) override;
        MediaResult getRenderedPresentationTime(MediaTime& time) override;
        MediaResult flush() override;
        MediaResult start() override;
        MediaResult stop() override;
        MediaResult setPlaybackRate(float rate) override;

        MediaResult setVolume(float volume) override;

        static const int SupportedOutputSampleRate = 48000;

    protected:
    private:
        std::shared_ptr<AudioClock> m_clock;
        std::unique_ptr<AudioOutputStream> m_output;

        int m_inputNumChannels;
        int m_inputSampleRate;
        int m_inputSampleSize;
        int m_outputNumChannels;

        float m_volume;
    };
}
}
