#include "AudioSample.hpp"
#include <cassert>

namespace twitch {
namespace ps4 {

template <>
void AudioSample<MonoSample>::appendToBuffer(SampleBuffer& destination, const void * buffer, size_t bufferSize)
{
    assert(bufferSize % sizeof(MonoSample) == 0);

    const size_t currentSize = destination.size();
    const size_t sizeAdded = bufferSize / sizeof(MonoSample);
    const size_t newSize = currentSize + sizeAdded;

    destination.resize(newSize);
    for (size_t i = 0; i < sizeAdded; ++i) {
        destination[i + currentSize].mono = reinterpret_cast<const float*>(buffer)[i];
    }
}

template <>
void AudioSample<FiveDotOneSample>::appendToBuffer(SampleBuffer& destination, const void * buffer, size_t bufferSize)
{
    const int inputSampleSize = 6 * sizeof(float);
    assert(bufferSize % inputSampleSize == 0);

    const size_t currentSize = destination.size();
    const size_t sizeAdded = bufferSize / inputSampleSize;
    const size_t newSize = currentSize + sizeAdded;

    destination.resize(newSize);
    for (size_t i = 0; i < sizeAdded; ++i) {
        destination[i + currentSize].l = reinterpret_cast<const float*>(buffer)[i * 6];
        destination[i + currentSize].r = reinterpret_cast<const float*>(buffer)[i * 6 + 1];
        destination[i + currentSize].c = reinterpret_cast<const float*>(buffer)[i * 6 + 2];
        destination[i + currentSize].lfe = reinterpret_cast<const float*>(buffer)[i * 6 + 3];
        destination[i + currentSize].lsurround = reinterpret_cast<const float*>(buffer)[i * 6 + 4];
        destination[i + currentSize].rsurround = reinterpret_cast<const float*>(buffer)[i * 6 + 5];
    }
}

template <>
void AudioSample<SevenDotOneSample>::appendToBuffer(SampleBuffer& destination, const void * buffer, size_t bufferSize)
{
    const int inputSampleSize = 8 * sizeof(float);
    assert(bufferSize % inputSampleSize == 0);

    const size_t currentSize = destination.size();
    const size_t sizeAdded = bufferSize / inputSampleSize;
    const size_t newSize = currentSize + sizeAdded;

    destination.resize(newSize);
    for (size_t i = 0; i < sizeAdded; ++i) {
        destination[i + currentSize].l = reinterpret_cast<const float*>(buffer)[i * 8];
        destination[i + currentSize].r = reinterpret_cast<const float*>(buffer)[i * 8 + 1];
        destination[i + currentSize].c = reinterpret_cast<const float*>(buffer)[i * 8 + 2];
        destination[i + currentSize].lfe = reinterpret_cast<const float*>(buffer)[i * 8 + 3];
        destination[i + currentSize].lsurround = reinterpret_cast<const float*>(buffer)[i * 8 + 4];
        destination[i + currentSize].rsurround = reinterpret_cast<const float*>(buffer)[i * 8 + 5];
        destination[i + currentSize].lextend = reinterpret_cast<const float*>(buffer)[i * 8 + 6];
        destination[i + currentSize].rextend = reinterpret_cast<const float*>(buffer)[i * 8 + 7];
    }
}

template <>
void AudioSample<StereoSample>::appendToBuffer(SampleBuffer& destination, const void * buffer, size_t bufferSize)
{
    assert(bufferSize % sizeof(StereoSample) == 0);

    const size_t currentSize = destination.size();
    const size_t sizeAdded = bufferSize / sizeof(StereoSample);
    const size_t newSize = currentSize + sizeAdded;

    destination.resize(newSize);
    for (size_t i = 0; i < sizeAdded; ++i) {
        destination[i + currentSize].left = reinterpret_cast<const float*>(buffer)[i * 2];
        destination[i + currentSize].right = reinterpret_cast<const float*>(buffer)[i * 2 + 1];
    }
}


}
}
