#pragma once
#include <vector>

namespace twitch {
namespace ps4 {
    template <typename T>
    class AudioSample {
    public:
        using SampleBuffer = std::vector<T>;
        static void appendToBuffer(SampleBuffer& destination, const void * buffer, size_t bufferSize);
    };

    struct FiveDotOneSample : public AudioSample<FiveDotOneSample> {
        float l, r, c, lfe, lsurround, rsurround;
    };

    struct MonoSample : public AudioSample<MonoSample> {
        float mono;
    };

    struct SevenDotOneSample : public AudioSample<SevenDotOneSample> {
        float l, r, c, lfe, lsurround, rsurround, lextend, rextend;
    };

    struct StereoSample : public AudioSample<StereoSample> {
        float left;
        float right;
    };
}
}
