// Code based on PS4 3.500 SDK Sony Samples
#pragma once

#include "playercore/MediaTime.hpp"
#include <atomic>
#include <memory>

namespace twitch {
namespace ps4 {
    class AudioClock;
    class AudioSystem {
    public:
        AudioSystem();
        ~AudioSystem();

        void init();

        static int32_t param(uint32_t numChannels);
        static uint32_t numChannels(int32_t param);

    protected:
    private:
        void setError(int error);
        int m_lastError;
    };

    class AudioOutput {
    public:
        AudioOutput(const std::shared_ptr<AudioClock>& rendererClock);
        ~AudioOutput(void);
        int open(int32_t grain, int32_t sampleRate, int32_t param, float volume);
        int close(void);
        int output(const void* p);
        int flush();
        MediaTime getLastRenderedSampleTime() const;
        uint32_t outputSamplesSize(void) const { return sizeof(float) * m_numChannels * m_grain; }

        int32_t getSampleRate() const { return m_sampleRate; }
        uint32_t getNumChannels() const { return m_numChannels; }

        void resetLastRenderedSampleTime();

        int setVolume(float volume);

    private:
        std::shared_ptr<AudioClock> m_rendererClock;

        AudioSystem s_system;
        int32_t m_handle;
        int32_t m_grain;
        int32_t m_sampleRate;
        int32_t m_param;
        uint32_t m_numChannels;
    };
}
}
