#include "Concurrency.hpp"

namespace twitch {
namespace ps4 {

    ConditionVariable::ConditionVariable()
    {
        int id = m_nextId++;

        char buf[32];
        sprintf_s(buf, sizeof(buf), "PC_CondVariable_%d", id);
        int ret = scePthreadCondInit(&m_condition, NULL, buf);
        assert(ret >= 0);
        (void)ret;

    }
    ConditionVariable::~ConditionVariable()
    {
        int ret = scePthreadCondDestroy(&m_condition);
        assert(ret >= 0);
        (void)ret;
    }

    void ConditionVariable::wait(std::unique_lock<Mutex>& lock)
    {
        int ret = scePthreadCondWait(&m_condition, lock.mutex()->getMutex());
        assert(ret >= 0);
        (void)ret;
    }

    void ConditionVariable::notify_one()
    {
        int ret = scePthreadCondSignal(&m_condition);
        assert(ret >= 0);
        (void)ret;
    }

    void ConditionVariable::notify_all()
    {
        int ret = scePthreadCondBroadcast(&m_condition);
        assert(ret >= 0);
        (void)ret;
    }

    std::atomic_int64_t ConditionVariable::m_nextId(1);

    Mutex::Mutex()
    {
        int id = m_nextId++;

        char buf[32];
        sprintf_s(buf, sizeof(buf), "PC_Mutex_%d", id);

        int ret = scePthreadMutexInit(&m_mutex, NULL, buf);
        assert(ret >= 0);
        (void)ret;
    }

    Mutex::~Mutex()
    {
        int ret = scePthreadMutexDestroy(&m_mutex);
        assert(ret >= 0);
        (void)ret;
    }

    void Mutex::lock()
    {
        int ret = scePthreadMutexLock(&m_mutex);
        assert(ret >= 0);
        (void)ret;
    }

    void Mutex::unlock()
    {
        int ret = scePthreadMutexUnlock(&m_mutex);
        assert(ret >= 0);
        (void)ret;
    }

    ScePthreadMutex* Mutex::getMutex() { return &m_mutex; }

    std::atomic_int64_t Mutex::m_nextId(1);

    RecursiveMutex::RecursiveMutex()
    {
        int id = m_nextId++;

        char buf[32];
        sprintf_s(buf, sizeof(buf), "PC_RecursiveMutex_%d", id);

        ScePthreadMutexattr attr;
        int ret = scePthreadMutexattrInit(&attr);
        assert(ret >= 0);
        ret = scePthreadMutexattrSettype(&attr, SCE_PTHREAD_MUTEX_RECURSIVE);
        assert(ret >= 0);
        ret = scePthreadMutexInit(&m_mutex, &attr, buf);
        assert(ret >= 0);
        ret = scePthreadMutexattrDestroy(&attr);
        assert(ret >= 0);
        (void)ret;
    }

    RecursiveMutex::~RecursiveMutex()
    {
        int ret = scePthreadMutexDestroy(&m_mutex);
        assert(ret >= 0);
        (void)ret;
    }

    void RecursiveMutex::lock()
    {
        int ret = scePthreadMutexLock(&m_mutex);
        assert(ret >= 0);
        (void)ret;
    }

    void RecursiveMutex::unlock()
    {
        int ret = scePthreadMutexUnlock(&m_mutex);
        assert(ret >= 0);
        (void)ret;
    }

    ScePthreadMutex* RecursiveMutex::getMutex() { return &m_mutex; }

    std::atomic_int64_t RecursiveMutex::m_nextId(1);
}
}
