﻿#pragma once

#include <memory>
#include <queue>
#include <vector>

#include "util/Concurrency.hpp"
#include "MediaFrameBuffer.hpp"

namespace twitch {
namespace ps4 {

    class FrameBufferPool {
    public:
        FrameBufferPool(int width, int height, int numBuffers);
        ~FrameBufferPool();

        std::shared_ptr<MediaFrameBufferInfo> getFrameBuffer();

        int getLastError() const { return m_lastError; }

        void stop();

    protected:
    private:
        FrameBufferPool(const FrameBufferPool& rhs) = delete;
        FrameBufferPool& operator=(const FrameBufferPool& rhs) = delete;

        void releaseFrameBuffer(MediaFrameBufferInfo* bufferInfo);
        void waitForEmptyBuffer();

        int m_lastError = 0;
        bool m_stopped = false;

        void* m_alloc_ptr;

        std::vector<MediaFrameBufferInfo> m_nodes;
        std::queue<MediaFrameBufferInfo*> m_free;

        Mutex m_mutex;
        ConditionVariable m_condition;

        uint32_t m_total_size;
        int64_t m_alloc_offset;
    };
}
}
