#include "Net.hpp"
#include "debug/trace.hpp"
#include <libssl.h>
#include <net.h>

//using namespace twitch;
using namespace twitch::ps4;

Net::Net()
    : m_netPoolId(-1)
    , m_sslContext(-1)
{
}

// return internal error code (< 0) in case of failure
int Net::init(int poolSize)
{
    int pool = sceNetPoolCreate("PlayerCore NetPool", Net_PoolSize, 0);

    if (pool < 0) {
        TRACE_ERROR("sceNetPoolCreate with pool size: %d, failed with 0x%08x", Net_PoolSize, pool);
        return pool;
    }

    int context = sceSslInit(poolSize);

    if (context < 0) {
        TRACE_ERROR("sceSslInit(%d) failed with 0x%08x", poolSize, pool);
        int ret = sceNetPoolDestroy(pool);
        if (ret < 0) {
            TRACE_ERROR("sceNetPoolDestroy failed with error 0x%08x", ret);
        }

        return context;
    }

    m_netPoolId = pool;
    m_sslContext = context;
    return 0;
}

int Net::deinit()
{
    if (isInitialized()) {
        int ret = sceNetPoolDestroy(m_netPoolId);
        if (ret < 0) {
            TRACE_ERROR("sceNetPoolDestroy failed with error 0x%08x", ret);
        }

        ret = sceSslTerm(m_sslContext);
        if (ret < 0) {
            TRACE_ERROR("sceSslTerm failed with error 0x%08x", ret);
        }

        m_netPoolId = -1;
        m_sslContext = -1;
        return 0;
    }

    return -1;
}
