#include <map>

using namespace twitch;

// Note: This mapping is based on C:\Program Files (x86)\SCE\ORBIS SDKs\3.500\host_tools\debugging\error_code\error_table.csv
using Ps4ErrorMap = std::map<unsigned int, std::pair<std::string, std::string>>;
Ps4ErrorMap ps4Errors = {
    //{ 0x80020001,{ "SCE_KERNEL_ERROR_EPERM",  "Operation not permitted" } },
    //{ 0x80020002,{ "SCE_KERNEL_ERROR_ENOENT", "No such file or directory" } },
    //{ 0x80020003,{ "SCE_KERNEL_ERROR_ESRCH",  "No such process" } },
    //{ 0x80020004,{ "SCE_KERNEL_ERROR_EINTR",  "Interrupted system call" } },
    //{ 0x80020005,{ "SCE_KERNEL_ERROR_EIO",    "Input/output error" } },
    //{ 0x80020006,{ "SCE_KERNEL_ERROR_ENXIO",  "Device not configured" } },
    //{ 0x80020007,{ "SCE_KERNEL_ERROR_E2BIG",  "Argument list too long" } },
    //{ 0x80020008,{ "SCE_KERNEL_ERROR_ENOEXEC",    "Exec format error" } },
    //{ 0x80020009,{ "SCE_KERNEL_ERROR_EBADF",  "Bad file descriptor" } },
    //{ 0x8002000A,{ "SCE_KERNEL_ERROR_ECHILD", "No child processes" } },
    //{ 0x8002000B,{ "SCE_KERNEL_ERROR_EDEADLK",    "Resource deadlock avoided" } },
    //{ 0x8002000C,{ "SCE_KERNEL_ERROR_ENOMEM", "Cannot allocate memory" } },
    //{ 0x8002000D,{ "SCE_KERNEL_ERROR_EACCES", "Permission denied" } },
    //{ 0x8002000E,{ "SCE_KERNEL_ERROR_EFAULT", "Bad address" } },
    //{ 0x8002000F,{ "SCE_KERNEL_ERROR_ENOTBLK",    "Block device required" } },
    //{ 0x80020010,{ "SCE_KERNEL_ERROR_EBUSY",  "Device busy" } },
    //{ 0x80020011,{ "SCE_KERNEL_ERROR_EEXIST", "File exists" } },
    //{ 0x80020012,{ "SCE_KERNEL_ERROR_EXDEV",  "Cross-device link" } },
    //{ 0x80020013,{ "SCE_KERNEL_ERROR_ENODEV", "Operation not supported by device" } },
    //{ 0x80020014,{ "SCE_KERNEL_ERROR_ENOTDIR",    "Not a directory" } },
    //{ 0x80020015,{ "SCE_KERNEL_ERROR_EISDIR", "Is a directory" } },
    //{ 0x80020016,{ "SCE_KERNEL_ERROR_EINVAL", "Invalid argument" } },
    //{ 0x80020017,{ "SCE_KERNEL_ERROR_ENFILE", "Too many open files in system" } },
    //{ 0x80020018,{ "SCE_KERNEL_ERROR_EMFILE", "Too many open files" } },
    //{ 0x80020019,{ "SCE_KERNEL_ERROR_ENOTTY", "Inappropriate ioctl for device" } },
    //{ 0x8002001A,{ "SCE_KERNEL_ERROR_ETXTBSY",    "Text file busy" } },
    //{ 0x8002001B,{ "SCE_KERNEL_ERROR_EFBIG",  "File too large" } },
    //{ 0x8002001C,{ "SCE_KERNEL_ERROR_ENOSPC", "No space left on device" } },
    //{ 0x8002001D,{ "SCE_KERNEL_ERROR_ESPIPE", "Illegal seek" } },
    //{ 0x8002001E,{ "SCE_KERNEL_ERROR_EROFS",  "Read-only filesystem" } },
    //{ 0x8002001F,{ "SCE_KERNEL_ERROR_EMLINK", "Too many links" } },
    //{ 0x80020020,{ "SCE_KERNEL_ERROR_EPIPE",  "Broken pipe" } },
    //{ 0x80020021,{ "SCE_KERNEL_ERROR_EDOM",   "Numerical argument out of domain" } },
    //{ 0x80020022,{ "SCE_KERNEL_ERROR_ERANGE", "Result too large" } },
    //{ 0x80020023,{ "SCE_KERNEL_ERROR_EAGAIN", "Resource temporarily unavailable" } },
    //{ 0x80020023,{ "SCE_KERNEL_ERROR_EWOULDBLOCK",    "Operation would block (SCE_KERNEL_ERROR_EAGAIN)" } },
    //{ 0x80020024,{ "SCE_KERNEL_ERROR_EINPROGRESS",    "Operation now in progress" } },
    //{ 0x80020025,{ "SCE_KERNEL_ERROR_EALREADY",   "Operation already in progress" } },
    //{ 0x80020026,{ "SCE_KERNEL_ERROR_ENOTSOCK",   "Socket operation on non-socket" } },
    //{ 0x80020027,{ "SCE_KERNEL_ERROR_EDESTADDRREQ",   "Destination address required" } },
    //{ 0x80020028,{ "SCE_KERNEL_ERROR_EMSGSIZE",   "Message too long" } },
    //{ 0x80020029,{ "SCE_KERNEL_ERROR_EPROTOTYPE", "Protocol wrong type for socket" } },
    //{ 0x8002002A,{ "SCE_KERNEL_ERROR_ENOPROTOOPT",    "Protocol not available" } },
    //{ 0x8002002B,{ "SCE_KERNEL_ERROR_EPROTONOSUPPORT",    "Protocol not supported" } },
    //{ 0x8002002C,{ "SCE_KERNEL_ERROR_ESOCKTNOSUPPORT",    "Socket type not supported" } },
    //{ 0x8002002D,{ "SCE_KERNEL_ERROR_ENOTSUP",    "Operation not supported (SCE_KERNEL_ERROR_EOPNOTSUPP)" } },
    //{ 0x8002002D,{ "SCE_KERNEL_ERROR_EOPNOTSUPP", "Operation not supported" } },
    //{ 0x8002002E,{ "SCE_KERNEL_ERROR_EPFNOSUPPORT",   "Protocol family not supported" } },
    //{ 0x8002002F,{ "SCE_KERNEL_ERROR_EAFNOSUPPORT",   "Address family not supported by protocol family" } },
    //{ 0x80020030,{ "SCE_KERNEL_ERROR_EADDRINUSE", "Address already in use" } },
    //{ 0x80020031,{ "SCE_KERNEL_ERROR_EADDRNOTAVAIL",  "Can't assign requested address" } },
    //{ 0x80020032,{ "SCE_KERNEL_ERROR_ENETDOWN",   "Network is down" } },
    //{ 0x80020033,{ "SCE_KERNEL_ERROR_ENETUNREACH",    "Network is unreachable" } },
    //{ 0x80020034,{ "SCE_KERNEL_ERROR_ENETRESET",  "Network dropped connection on reset" } },
    //{ 0x80020035,{ "SCE_KERNEL_ERROR_ECONNABORTED",   "Software caused connection abort" } },
    //{ 0x80020036,{ "SCE_KERNEL_ERROR_ECONNRESET", "Connection reset by peer" } },
    //{ 0x80020037,{ "SCE_KERNEL_ERROR_ENOBUFS",    "No buffer space available" } },
    //{ 0x80020038,{ "SCE_KERNEL_ERROR_EISCONN",    "Socket is already connected" } },
    //{ 0x80020039,{ "SCE_KERNEL_ERROR_ENOTCONN",   "Socket is not connected" } },
    //{ 0x8002003A,{ "SCE_KERNEL_ERROR_ESHUTDOWN",  "Can't send after socket shutdown" } },
    //{ 0x8002003B,{ "SCE_KERNEL_ERROR_ETOOMANYREFS",   "Too many references: can't splice" } },
    //{ 0x8002003C,{ "SCE_KERNEL_ERROR_ETIMEDOUT",  "Operation timed out" } },
    //{ 0x8002003D,{ "SCE_KERNEL_ERROR_ECONNREFUSED",   "Connection refused" } },
    //{ 0x8002003E,{ "SCE_KERNEL_ERROR_ELOOP",  "Too many levels of symbolic links" } },
    //{ 0x8002003F,{ "SCE_KERNEL_ERROR_ENAMETOOLONG",   "File name too long" } },
    //{ 0x80020040,{ "SCE_KERNEL_ERROR_EHOSTDOWN",  "Host is down" } },
    //{ 0x80020041,{ "SCE_KERNEL_ERROR_EHOSTUNREACH",   "No route to host" } },
    //{ 0x80020042,{ "SCE_KERNEL_ERROR_ENOTEMPTY",  "Directory not empty" } },
    //{ 0x80020043,{ "SCE_KERNEL_ERROR_EPROCLIM",   "Too many processes" } },
    //{ 0x80020044,{ "SCE_KERNEL_ERROR_EUSERS", "Too many users" } },
    //{ 0x80020045,{ "SCE_KERNEL_ERROR_EDQUOT", "Disc quota exceeded" } },
    //{ 0x80020046,{ "SCE_KERNEL_ERROR_ESTALE", "Stale NFS file handle" } },
    //{ 0x80020047,{ "SCE_KERNEL_ERROR_EREMOTE",    "Too many levels of remote in path" } },
    //{ 0x80020048,{ "SCE_KERNEL_ERROR_EBADRPC",    "RPC struct is bad" } },
    //{ 0x80020049,{ "SCE_KERNEL_ERROR_ERPCMISMATCH",   "RPC version wrong" } },
    //{ 0x8002004A,{ "SCE_KERNEL_ERROR_EPROGUNAVAIL",   "RPC prog. not avail" } },
    //{ 0x8002004B,{ "SCE_KERNEL_ERROR_EPROGMISMATCH",  "Program version wrong" } },
    //{ 0x8002004C,{ "SCE_KERNEL_ERROR_EPROCUNAVAIL",   "Bad procedure for program" } },
    //{ 0x8002004D,{ "SCE_KERNEL_ERROR_ENOLCK", "No locks available" } },
    //{ 0x8002004E,{ "SCE_KERNEL_ERROR_ENOSYS", "Function not implemented" } },
    //{ 0x8002004F,{ "SCE_KERNEL_ERROR_EFTYPE", "Inappropriate file type or format" } },
    //{ 0x80020050,{ "SCE_KERNEL_ERROR_EAUTH",  "Authentication error" } },
    //{ 0x80020051,{ "SCE_KERNEL_ERROR_ENEEDAUTH",  "Need authenticator" } },
    //{ 0x80020052,{ "SCE_KERNEL_ERROR_EIDRM",  "Identifier removed" } },
    //{ 0x80020053,{ "SCE_KERNEL_ERROR_ENOMSG", "No message of desired type" } },
    //{ 0x80020054,{ "SCE_KERNEL_ERROR_EOVERFLOW",  "Value too large to be stored in data type" } },
    //{ 0x80020055,{ "SCE_KERNEL_ERROR_ECANCELED",  "Operation canceled" } },
    //{ 0x80020056,{ "SCE_KERNEL_ERROR_EILSEQ", "Illegal byte sequence" } },
    //{ 0x80020057,{ "SCE_KERNEL_ERROR_ENOATTR",    "Attribute not found" } },
    //{ 0x80020058,{ "SCE_KERNEL_ERROR_EDOOFUS",    "Programming error" } },
    //{ 0x80020059,{ "SCE_KERNEL_ERROR_EBADMSG",    "Bad message" } },
    //{ 0x8002005A,{ "SCE_KERNEL_ERROR_EMULTIHOP",  "Multihop attempted" } },
    //{ 0x8002005B,{ "SCE_KERNEL_ERROR_ENOLINK",    "Link has been severed" } },
    //{ 0x8002005C,{ "SCE_KERNEL_ERROR_EPROTO", "Protocol error" } },
    //{ 0x8002005D,{ "SCE_KERNEL_ERROR_ENOTCAPABLE",    "Capabilities insufficient" } },
    //{ 0x8002005E,{ "SCE_KERNEL_ERROR_ECAPMODE",   "Not permitted in capability mode" } },
    //{ 0x8002005F,{ "SCE_KERNEL_ERROR_ENOBLK", "Block not ready" } },
    //{ 0x80020060,{ "SCE_KERNEL_ERROR_EICV",   "Integrity check error" } },
    //{ 0x80020061,{ "SCE_KERNEL_ERROR_ENOPLAYGOENT",   "File not found in PlayGo chunk definition" } },
    //{ 0x80020062,{ "SCE_KERNEL_ERROR_EREVOKE",    "File is revoked" } },
    //{ 0x80020063,{ "SCE_KERNEL_ERROR_ESDKVERSION",    "SDK version of a binary file is invalid" } },
    //{ 0x80080800,{ "SCE_DECI4H_ERROR_UNKNOWN",    "Undefined error" } },
    //{ 0x80080801,{ "SCE_DECI4H_ERROR_ALREADYUSE_PROTOCOL",    "Protocol number is already being used" } },
    //{ 0x80080802,{ "SCE_DECI4H_ERROR_ILLEGAL_SID",    "Invalid socket ID" } },
    //{ 0x80080804,{ "SCE_DECI4H_ERROR_INVALID_ARGUMENT",   "Invalid argument" } },
    //{ 0x80080806,{ "SCE_DECI4H_ERROR_ILLEGAL_PROTOCOL",   "Invalid protocol number" } },
    //{ 0x80080809,{ "SCE_DECI4H_ERROR_TOOMANY_PROTOCOL",   "Exceeded the maximum number of usable sockets" } },
    //{ 0x8008080C,{ "SCE_DECI4H_ERROR_INTERRUPTED",    "Transfer interrupted" } },
    //{ 0x8008080E,{ "SCE_DECI4H_ERROR_NO_CONNECTED",   "Host PC is not connected" } },
    //{ 0x80080820,{ "SCE_DECI4H_ERROR_HOST_PROCESS_DISABLED",  "Invalid host PC settings" } },
    //{ 0x80080821,{ "SCE_DECI4H_ERROR_HOST_CREATE_PROCESS",    "Process creation in host PC failed" } },
    //{ 0x80080822,{ "SCE_DECI4H_ERROR_HOST_TOOMANY_PROCESS",   "Number of processes being created is too many" } },
    //{ 0x80120001,{ "SCE_SYSFILE_ERROR_NOMEM", "out of memory" } },
    //{ 0x80120002,{ "SCE_SYSFILE_ERROR_IO",    "file IO error" } },
    //{ 0x80120003,{ "SCE_SYSFILE_ERROR_INVAL", "invalid parameters" } },
    //{ 0x80120004,{ "SCE_SYSFILE_ERROR_BADMAGIC",  "invalid MAGIC code(system file broken)" } },
    //{ 0x80120005,{ "SCE_SYSFILE_ERROR_KEYNOTFOUND",   "key's not found(system file broken)" } },
    //{ 0x80120006,{ "SCE_SYSFILE_ERROR_KEYDUPLICATION",    "duplication of key(system file broken)" } },
    //{ 0x80120007,{ "SCE_SYSFILE_ERROR_BADVERSION",    "invalid version(system file broken)" } },
    //{ 0x80120008,{ "SCE_SYSFILE_ERROR_OVER_DATABUFSIZE",  "invalid data size(system file broken)" } },
    //{ 0x80240001,{ "SCE_USBD_ERROR_IO",   "I/O error" } },
    //{ 0x80240002,{ "SCE_USBD_ERROR_INVALID_ARG",  "invalid argument" } },
    //{ 0x80240003,{ "SCE_USBD_ERROR_ACCESS",   "permission denied" } },
    //{ 0x80240004,{ "SCE_USBD_ERROR_NO_DEVICE",    "no such device" } },
    //{ 0x80240005,{ "SCE_USBD_ERROR_NOT_FOUND",    "resource not found" } },
    //{ 0x80240006,{ "SCE_USBD_ERROR_BUSY", "resource busy" } },
    //{ 0x80240007,{ "SCE_USBD_ERROR_TIMEOUT",  "timer expired" } },
    //{ 0x80240008,{ "SCE_USBD_ERROR_OVERFLOW", "value too large to be stored in data type" } },
    //{ 0x80240009,{ "SCE_USBD_ERROR_PIPE", "broken pipe" } },
    //{ 0x8024000A,{ "SCE_USBD_ERROR_INTERRUPTED",  "interrupted system call" } },
    //{ 0x8024000B,{ "SCE_USBD_ERROR_NO_MEM",   "not enough core" } },
    //{ 0x8024000C,{ "SCE_USBD_ERROR_NOT_SUPPORTED",    "operation not supported" } },
    //{ 0x802400FF,{ "SCE_USBD_ERROR_FATAL",    "fatal error" } },
    //{ 0x80260001,{ "SCE_AUDIO_OUT_ERROR_NOT_OPENED",  "Tried to perform an operation (play, release or get number of remaining samples) for the port not opened" } },
    //{ 0x80260002,{ "SCE_AUDIO_OUT_ERROR_BUSY",    "Tried to output while outputting audio" } },
    //{ 0x80260003,{ "SCE_AUDIO_OUT_ERROR_INVALID_PORT",    "Invalid port number" } },
    //{ 0x80260004,{ "SCE_AUDIO_OUT_ERROR_INVALID_POINTER", "Invalid pointer" } },
    //{ 0x80260005,{ "SCE_AUDIO_OUT_ERROR_PORT_FULL",   "Cannot reserve a port(channel) any more" } },
    //{ 0x80260006,{ "SCE_AUDIO_OUT_ERROR_INVALID_SIZE",    "Invalid sample length specified" } },
    //{ 0x80260007,{ "SCE_AUDIO_OUT_ERROR_INVALID_FORMAT",  "Invalid audio format" } },
    //{ 0x80260008,{ "SCE_AUDIO_OUT_ERROR_INVALID_SAMPLE_FREQ", "Invalid sampling frequency" } },
    //{ 0x80260009,{ "SCE_AUDIO_OUT_ERROR_INVALID_VOLUME",  "Invalid volume value" } },
    //{ 0x8026000A,{ "SCE_AUDIO_OUT_ERROR_INVALID_PORT_TYPE",   "Invalid port type" } },
    //{ 0x8026000C,{ "SCE_AUDIO_OUT_ERROR_INVALID_CONF_TYPE",   "Invalid config type" } },
    //{ 0x8026000D,{ "SCE_AUDIO_OUT_ERROR_OUT_OF_MEMORY",   "Not enough memory" } },
    //{ 0x8026000E,{ "SCE_AUDIO_OUT_ERROR_ALREADY_INIT",    "already initialized" } },
    //{ 0x8026000F,{ "SCE_AUDIO_OUT_ERROR_NOT_INIT",    "not initialized" } },
    //{ 0x80260010,{ "SCE_AUDIO_OUT_ERROR_MEMORY",  "memory handling error" } },
    //{ 0x80260011,{ "SCE_AUDIO_OUT_ERROR_SYSTEM_RESOURCE", "system resourc error" } },
    //{ 0x80260012,{ "SCE_AUDIO_OUT_ERROR_TRANS_EVENT", "transfer event send error" } },
    //{ 0x80260013,{ "SCE_AUDIO_OUT_ERROR_INVALID_FLAG",    "Invalid volume flag value" } },
    //{ 0x80260014,{ "SCE_AUDIO_OUT_ERROR_INVALID_MIXLEVEL",    "Invalid mix level value" } },
    //{ 0x80260015,{ "SCE_AUDIO_OUT_ERROR_INVALID_ARG", "Invalid argument" } },
    //{ 0x80260016,{ "SCE_AUDIO_OUT_ERROR_INVALID_PARAM",   "Invalid parameter" } },
    //{ 0x80260100,{ "SCE_AUDIO_IN_ERROR_FATAL",    "undefined error" } },
    //{ 0x80260101,{ "SCE_AUDIO_IN_ERROR_INVALID_HANDLE",   "Bad value of handle" } },
    //{ 0x80260102,{ "SCE_AUDIO_IN_ERROR_INVALID_SIZE", "Invalid sample length" } },
    //{ 0x80260103,{ "SCE_AUDIO_IN_ERROR_INVALID_FREQ", "Invalid sampling frequency" } },
    //{ 0x80260104,{ "SCE_AUDIO_IN_ERROR_INVALID_TYPE", "Invalid bus type" } },
    //{ 0x80260105,{ "SCE_AUDIO_IN_ERROR_INVALID_POINTER",  "Invalid pointer value" } },
    //{ 0x80260106,{ "SCE_AUDIO_IN_ERROR_INVALID_PARAM",    "Invalid port parameter" } },
    //{ 0x80260107,{ "SCE_AUDIO_IN_ERROR_PORT_FULL",    "Cannot open port any more" } },
    //{ 0x80260108,{ "SCE_AUDIO_IN_ERROR_OUT_OF_MEMORY",    "Not enough memory" } },
    //{ 0x80260109,{ "SCE_AUDIO_IN_ERROR_NOT_OPENED",   "This port is not opened" } },
    //{ 0x8026010A,{ "SCE_AUDIO_IN_ERROR_BUSY", "Tried to input while inputting" } },
    //{ 0x8026010B,{ "SCE_AUDIO_IN_ERROR_SYSTEM_MEMORY",    "Error due to relate of the system memory access" } },
    //{ 0x8026010C,{ "SCE_AUDIO_IN_ERROR_SYSTEM_IPC",   "Error due to the system IPC" } },
    //{ 0x80260200,{ "SCE_AUDIO_OUT_ERROR_MASTERING_FATAL", "FATAL ERROR." } },
    //{ 0x80260201,{ "SCE_AUDIO_OUT_ERROR_MASTERING_INVALID_API_PARAM", "Invalid mastering API parameter." } },
    //{ 0x80260202,{ "SCE_AUDIO_OUT_ERROR_MASTERING_INVALID_CONFIG",    "Mastering parameter structure is invaild." } },
    //{ 0x80260203,{ "SCE_AUDIO_OUT_ERROR_MASTERING_NOT_INITIALIZED",   "Mastering is not initialized." } },
    //{ 0x80260204,{ "SCE_AUDIO_OUT_ERROR_MASTERING_INVALID_STATES_ID", "Mastering state ID is invalid." } },
    //{ 0x80260205,{ "SCE_AUDIO_OUT_ERROR_MASTERING_INVALID_FLAGS", "specified flags is invalid." } },
    //{ 0x80260300,{ "SCE_AUDIO_LATENCY_ESTIMATION_ERROR_FATAL",    "undefined error" } },
    //{ 0x80260301,{ "SCE_AUDIO_LATENCY_ESTIMATION_ERROR_INVALID_HANDLE",   "Bad value of handle" } },
    //{ 0x80260302,{ "SCE_AUDIO_LATENCY_ESTIMATION_ERROR_INVALID_POINTER",  "Invalid pointer value" } },
    //{ 0x80290001,{ "SCE_VIDEO_OUT_ERROR_INVALID_VALUE",   "invalid argument" } },
    //{ 0x80290002,{ "SCE_VIDEO_OUT_ERROR_INVALID_ADDRESS", "invalid address" } },
    //{ 0x80290003,{ "SCE_VIDEO_OUT_ERROR_INVALID_PIXEL_FORMAT",    "invalid pixel format argument" } },
    //{ 0x80290004,{ "SCE_VIDEO_OUT_ERROR_INVALID_PITCH",   "invalid pitch argument" } },
    //{ 0x80290005,{ "SCE_VIDEO_OUT_ERROR_INVALID_RESOLUTION",  "invalid width,height argument" } },
    //{ 0x80290006,{ "SCE_VIDEO_OUT_ERROR_INVALID_FLIP_MODE",   "invalid flip mode argument" } },
    //{ 0x80290007,{ "SCE_VIDEO_OUT_ERROR_INVALID_TILING_MODE", "invalid tiling mode argument" } },
    //{ 0x80290008,{ "SCE_VIDEO_OUT_ERROR_INVALID_ASPECT_RATIO",    "invalid aspect ratio argument" } },
    //{ 0x80290009,{ "SCE_VIDEO_OUT_ERROR_RESOURCE_BUSY",   "the resource is in use" } },
    //{ 0x8029000A,{ "SCE_VIDEO_OUT_ERROR_INVALID_INDEX",   "invalid index" } },
    //{ 0x8029000B,{ "SCE_VIDEO_OUT_ERROR_INVALID_HANDLE",  "invalid handle" } },
    //{ 0x8029000C,{ "SCE_VIDEO_OUT_ERROR_INVALID_EVENT_QUEUE", "invalid event queue" } },
    //{ 0x8029000D,{ "SCE_VIDEO_OUT_ERROR_INVALID_EVENT",   "invalid event" } },
    //{ 0x8029000F,{ "SCE_VIDEO_OUT_ERROR_NO_EMPTY_SLOT",   "no empty slot found" } },
    //{ 0x80290010,{ "SCE_VIDEO_OUT_ERROR_SLOT_OCCUPIED",   "the specified slot is already occupied" } },
    //{ 0x80290012,{ "SCE_VIDEO_OUT_ERROR_FLIP_QUEUE_FULL", "flip queue is already full" } },
    //{ 0x80290013,{ "SCE_VIDEO_OUT_ERROR_INVALID_MEMORY",  "invalid memory" } },
    //{ 0x80290014,{ "SCE_VIDEO_OUT_ERROR_MEMORY_NOT_PHYSICALLY_CONTIGUOUS",    "the buffer memory is not physically contiguous" } },
    //{ 0x80290015,{ "SCE_VIDEO_OUT_ERROR_MEMORY_INVALID_ALIGNMENT",    "invalid memory alignment for the buffer" } },
    //{ 0x80290016,{ "SCE_VIDEO_OUT_ERROR_UNSUPPORTED_OUTPUT_MODE", "unsupported output mode" } },
    //{ 0x80290017,{ "SCE_VIDEO_OUT_ERROR_OVERFLOW",    "overflow" } },
    //{ 0x80290018,{ "SCE_VIDEO_OUT_ERROR_NO_DEVICE",   "device does not exist" } },
    //{ 0x80290019,{ "SCE_VIDEO_OUT_ERROR_UNAVAILABLE_OUTPUT_MODE", "unavailable output mode now" } },
    //{ 0x8029001A,{ "SCE_VIDEO_OUT_ERROR_INVALID_OPTION",  "invalid option argument" } },
    //{ 0x8029001B,{ "SCE_VIDEO_OUT_ERROR_PORT_UNSUPPORTED_FUNCTION",   "unsupported function with the speficied port" } },
    //{ 0x8029001C,{ "SCE_VIDEO_OUT_ERROR_UNSUPPORTED_OPERATION",   "unsupported operation" } },
    //{ 0x802900FE,{ "SCE_VIDEO_OUT_ERROR_UNKNOWN", "unknown error" } },
    //{ 0x802900FF,{ "SCE_VIDEO_OUT_ERROR_FATAL",   "internal error" } },
    //{ 0x8029100C,{ "SCE_VIDEO_OUT_ERROR_ENOMEM",  "Cannot allocate memory" } },
    //{ 0x802E0000,{ "SCE_CAMERA_ERROR_PARAM",  "Parameter is invalid" } },
    //{ 0x802E0001,{ "SCE_CAMERA_ERROR_ALREADY_INIT",   "Already initialized" } },
    //{ 0x802E0002,{ "SCE_CAMERA_ERROR_NOT_INIT",   "Not initialized" } },
    //{ 0x802E0003,{ "SCE_CAMERA_ERROR_ALREADY_OPEN",   "Camera is already open" } },
    //{ 0x802E0004,{ "SCE_CAMERA_ERROR_NOT_OPEN",   "Camera is not open" } },
    //{ 0x802E0005,{ "SCE_CAMERA_ERROR_ALREADY_START",  "Streaming has started" } },
    //{ 0x802E0006,{ "SCE_CAMERA_ERROR_NOT_START",  "Streaming has not yet started" } },
    //{ 0x802E0007,{ "SCE_CAMERA_ERROR_FORMAT_UNKNOWN", "Cannot start with specified format" } },
    //{ 0x802E0008,{ "SCE_CAMERA_ERROR_RESOLUTION_UNKNOWN", "Cannot start with specified resolution" } },
    //{ 0x802E0009,{ "SCE_CAMERA_ERROR_BAD_FRAMERATE",  "Cannot open with specified frame rate" } },
    //{ 0x802E000A,{ "SCE_CAMERA_ERROR_TIMEOUT",    "Function timed out" } },
    //{ 0x802E000B,{ "SCE_CAMERA_ERROR_ATTRIBUTE_UNKNOWN",  "Unknown attribute" } },
    //{ 0x802E000C,{ "SCE_CAMERA_ERROR_BUSY",   "The camera is busy." } },
    //{ 0x802E000D,{ "SCE_CAMERA_ERROR_UNKNOWN_CONFIG", "Unknown Configration" } },
    //{ 0x802E000F,{ "SCE_CAMERA_ERROR_ALREADY_READ",   "The frame has already been read." } },
    //{ 0x802E0010,{ "SCE_CAMERA_ERROR_NOT_CONNECTED",  "The Camera is not connected." } },
    //{ 0x802E0011,{ "SCE_CAMERA_ERROR_NOT_SUPPORTED",  "The Function is not supported." } },
    //{ 0x802E0013,{ "SCE_CAMERA_ERROR_INVALID_CONFIG", "Attribute cannot specify under this Configration." } },
    //{ 0x802E0014,{ "SCE_CAMERA_ERROR_MAX_HANDLE", "Number of processes reached maximum." } },
    //{ 0x802E00FB,{ "SCE_CAMERA_ERROR_MAX_PROCESS",    "Number of processes reached maximum." } },
    //{ 0x802E00FC,{ "SCE_CAMERA_ERROR_COPYOUT_FAILED", "Copyout failed." } },
    //{ 0x802E00FD,{ "SCE_CAMERA_ERROR_COPYIN_FAILED",  "Copyin failed." } },
    //{ 0x802E00FE,{ "SCE_CAMERA_ERROR_KPROC_CREATE",   "Process create failed." } },
    //{ 0x802E00FF,{ "SCE_CAMERA_ERROR_FATAL",  "Fatal error occurred" } },
    //{ 0x803B0101,{ "SCE_HID_ERROR_ALREADY_LOGGED_OUT",    "this user already logged out" } },
    //{ 0x80410101,{ "SCE_NET_ERROR_EPERM", "Invalid Net library ID specified" } },
    //{ 0x80410102,{ "SCE_NET_ERROR_ENOENT",    "No resources are in wait state" } },
    //{ 0x80410103,{ "SCE_NET_ERROR_ESRCH", "Internal error" } },
    //{ 0x80410104,{ "SCE_NET_ERROR_EINTR", "Blocking canceled by abort function" } },
    //{ 0x80410105,{ "SCE_NET_ERROR_EIO",   "Internal error" } },
    //{ 0x80410106,{ "SCE_NET_ERROR_ENXIO", "Internal error" } },
    //{ 0x80410107,{ "SCE_NET_ERROR_E2BIG", "Internal error" } },
    //{ 0x80410108,{ "SCE_NET_ERROR_ENOEXEC",   "Internal error" } },
    //{ 0x80410109,{ "SCE_NET_ERROR_EBADF", "Invalid libnet ID specified" } },
    //{ 0x8041010A,{ "SCE_NET_ERROR_ECHILD",    "Internal error" } },
    //{ 0x8041010B,{ "SCE_NET_ERROR_EDEADLK",   "Internal error" } },
    //{ 0x8041010C,{ "SCE_NET_ERROR_ENOMEM",    "Insufficient memory (kernel)" } },
    //{ 0x8041010D,{ "SCE_NET_ERROR_EACCES",    "Attempted to use an area reserved by the system" } },
    //{ 0x8041010E,{ "SCE_NET_ERROR_EFAULT",    "Invalid argument specified" } },
    //{ 0x8041010F,{ "SCE_NET_ERROR_ENOTBLK",   "Abort process called while target is not in wait state" } },
    //{ 0x80410110,{ "SCE_NET_ERROR_EBUSY", "libnet already initialized" } },
    //{ 0x80410111,{ "SCE_NET_ERROR_EEXIST",    "SCE_NET_EPOLL_CTL_ADD specified to previously associated Net library ID" } },
    //{ 0x80410112,{ "SCE_NET_ERROR_EXDEV", "Internal error" } },
    //{ 0x80410113,{ "SCE_NET_ERROR_ENODEV",    "Target device does not exist" } },
    //{ 0x80410114,{ "SCE_NET_ERROR_ENOTDIR",   "Internal error" } },
    //{ 0x80410115,{ "SCE_NET_ERROR_EISDIR",    "Internal error" } },
    //{ 0x80410116,{ "SCE_NET_ERROR_EINVAL",    "Invalid argument specified" } },
    //{ 0x80410117,{ "SCE_NET_ERROR_ENFILE",    "Insufficient space in socket table" } },
    //{ 0x80410118,{ "SCE_NET_ERROR_EMFILE",    "Insufficient space in table" } },
    //{ 0x80410119,{ "SCE_NET_ERROR_ENOTTY",    "Internal error" } },
    //{ 0x8041011A,{ "SCE_NET_ERROR_ETXTBSY",   "Internal error" } },
    //{ 0x8041011B,{ "SCE_NET_ERROR_EFBIG", "Internal error" } },
    //{ 0x8041011C,{ "SCE_NET_ERROR_ENOSPC",    "Size specified with dst is too small to store string" } },
    //{ 0x8041011D,{ "SCE_NET_ERROR_ESPIPE",    "Internal error" } },
    //{ 0x8041011E,{ "SCE_NET_ERROR_EROFS", "Internal error" } },
    //{ 0x8041011F,{ "SCE_NET_ERROR_EMLINK",    "Internal error" } },
    //{ 0x80410120,{ "SCE_NET_ERROR_EPIPE", "Writing side of socket already closed" } },
    //{ 0x80410121,{ "SCE_NET_ERROR_EDOM",  "Internal error" } },
    //{ 0x80410122,{ "SCE_NET_ERROR_ERANGE",    "Internal error" } },
    //{ 0x80410123,{ "SCE_NET_ERROR_EWOULDBLOCK",   "same as SCE_NET_ERROR_EAGAIN" } },
    //{ 0x80410123,{ "SCE_NET_ERROR_EAGAIN",    "Socket is in blocking state (when non-blocking)" } },
    //{ 0x80410124,{ "SCE_NET_ERROR_EINPROGRESS",   "Attempting to establish a connection" } },
    //{ 0x80410125,{ "SCE_NET_ERROR_EALREADY",  "Socket is already in use" } },
    //{ 0x80410126,{ "SCE_NET_ERROR_ENOTSOCK",  "Internal error" } },
    //{ 0x80410127,{ "SCE_NET_ERROR_EDESTADDRREQ",  "Invalid send request (sceNetSendto() should be used)" } },
    //{ 0x80410128,{ "SCE_NET_ERROR_EMSGSIZE",  "Message size is too large" } },
    //{ 0x80410129,{ "SCE_NET_ERROR_EPROTOTYPE",    "Unsupported protocol type was specified" } },
    //{ 0x8041012A,{ "SCE_NET_ERROR_ENOPROTOOPT",   "Option is not supported" } },
    //{ 0x8041012B,{ "SCE_NET_ERROR_EPROTONOSUPPORT",   "Invalid protocol family" } },
    //{ 0x8041012C,{ "SCE_NET_ERROR_ESOCKTNOSUPPORT",   "Internal error" } },
    //{ 0x8041012D,{ "SCE_NET_ERROR_EOPNOTSUPP",    "Invalid call for that socket" } },
    //{ 0x8041012D,{ "SCE_NET_ERROR_ENOTSUP",   "Invalid call for that socket" } },
    //{ 0x8041012E,{ "SCE_NET_ERROR_EPFNOSUPPORT",  "Unsupported protocol family was specified" } },
    //{ 0x8041012F,{ "SCE_NET_ERROR_EAFNOSUPPORT",  "Value of specified address family is not supported by socket protocol family" } },
    //{ 0x80410130,{ "SCE_NET_ERROR_EADDRINUSE",    "Attempted to bind to bound port" } },
    //{ 0x80410131,{ "SCE_NET_ERROR_EADDRNOTAVAIL", "Invalid address specified" } },
    //{ 0x80410132,{ "SCE_NET_ERROR_ENETDOWN",  "Interface is down" } },
    //{ 0x80410133,{ "SCE_NET_ERROR_ENETUNREACH",   "Destination is unreachable" } },
    //{ 0x80410134,{ "SCE_NET_ERROR_ENETRESET", "Internal error" } },
    //{ 0x80410135,{ "SCE_NET_ERROR_ECONNABORTED",  "Connection was aborted" } },
    //{ 0x80410136,{ "SCE_NET_ERROR_ECONNRESET",    "Connection was reset" } },
    //{ 0x80410137,{ "SCE_NET_ERROR_ENOBUFS",   "Memory limited" } },
    //{ 0x80410138,{ "SCE_NET_ERROR_EISCONN",   "Specified connection is already established" } },
    //{ 0x80410139,{ "SCE_NET_ERROR_ENOTCONN",  "Specified connection does not exist" } },
    //{ 0x8041013A,{ "SCE_NET_ERROR_ESHUTDOWN", "Shutdown in progress" } },
    //{ 0x8041013B,{ "SCE_NET_ERROR_ETOOMANYREFS",  "Too many multicast addresses specified" } },
    //{ 0x8041013C,{ "SCE_NET_ERROR_ETIMEDOUT", "Timeout occurred (indicates a protocol timeout, unlike SCE_NET_EAGAIN)" } },
    //{ 0x8041013D,{ "SCE_NET_ERROR_ECONNREFUSED",  "Connection request was denied" } },
    //{ 0x8041013E,{ "SCE_NET_ERROR_ELOOP", "Internal error" } },
    //{ 0x8041013F,{ "SCE_NET_ERROR_ENAMETOOLONG",  "Specified name is too long" } },
    //{ 0x80410140,{ "SCE_NET_ERROR_EHOSTDOWN", "Did not reach other side" } },
    //{ 0x80410141,{ "SCE_NET_ERROR_EHOSTUNREACH",  "Network unreachable" } },
    //{ 0x80410142,{ "SCE_NET_ERROR_ENOTEMPTY", "Memory is in use" } },
    //{ 0x80410143,{ "SCE_NET_ERROR_EPROCLIM",  "Internal error" } },
    //{ 0x80410144,{ "SCE_NET_ERROR_EUSERS",    "Internal error" } },
    //{ 0x80410145,{ "SCE_NET_ERROR_EDQUOT",    "Internal error" } },
    //{ 0x80410146,{ "SCE_NET_ERROR_ESTALE",    "Internal error" } },
    //{ 0x80410147,{ "SCE_NET_ERROR_EREMOTE",   "Internal error" } },
    //{ 0x80410148,{ "SCE_NET_ERROR_EBADRPC",   "Internal error" } },
    //{ 0x80410149,{ "SCE_NET_ERROR_ERPCMISMATCH",  "Internal error" } },
    //{ 0x8041014A,{ "SCE_NET_ERROR_EPROGUNAVAIL",  "Internal error" } },
    //{ 0x8041014B,{ "SCE_NET_ERROR_EPROGMISMATCH", "Internal error" } },
    //{ 0x8041014C,{ "SCE_NET_ERROR_EPROCUNAVAIL",  "Internal error" } },
    //{ 0x8041014D,{ "SCE_NET_ERROR_ENOLCK",    "Internal error" } },
    //{ 0x8041014E,{ "SCE_NET_ERROR_ENOSYS",    "Internal error" } },
    //{ 0x8041014F,{ "SCE_NET_ERROR_EFTYPE",    "Internal error" } },
    //{ 0x80410150,{ "SCE_NET_ERROR_EAUTH", "Internal error" } },
    //{ 0x80410151,{ "SCE_NET_ERROR_ENEEDAUTH", "Internal error" } },
    //{ 0x80410152,{ "SCE_NET_ERROR_EIDRM", "Internal error" } },
    //{ 0x80410153,{ "SCE_NET_ERROR_ENOMS", "Internal error" } },
    //{ 0x80410154,{ "SCE_NET_ERROR_EOVERFLOW", "Internal error" } },
    //{ 0x80410155,{ "SCE_NET_ERROR_ECANCELED", "Termination process of Net library ID in use was executed" } },
    //{ 0x8041015C,{ "SCE_NET_ERROR_EPROTO",    "Socket that is bound to any port was connected to the server" } },
    //{ 0x804101A0,{ "SCE_NET_ERROR_EADHOC",    "UDP or TCP was attempted in the ad hoc communication mode" } },
    //{ 0x804101A1,{ "SCE_NET_ERROR_ERESERVED161",  "Internal error" } },
    //{ 0x804101A2,{ "SCE_NET_ERROR_ERESERVED162",  "Internal error" } },
    //{ 0x804101A3,{ "SCE_NET_ERROR_EINACTIVEDISABLED", "Network disconnection occurred owing to releasing an IP address" } },
    //{ 0x804101A4,{ "SCE_NET_ERROR_ENODATA",   "Internal error" } },
    //{ 0x804101A5,{ "SCE_NET_ERROR_EDESC", "Internal error" } },
    //{ 0x804101A6,{ "SCE_NET_ERROR_EDESCTIMEDOUT", "Internal error" } },
    //{ 0x804101A7,{ "SCE_NET_ERROR_ENETINTR",  "Internal error" } },
    //{ 0x804101C8,{ "SCE_NET_ERROR_ENOTINIT",  "libnet not initialized" } },
    //{ 0x804101C9,{ "SCE_NET_ERROR_ENOLIBMEM", "Insufficient memory (library)" } },
    //{ 0x804101CA,{ "SCE_NET_ERROR_ERESERVED202",  "Internal error" } },
    //{ 0x804101CB,{ "SCE_NET_ERROR_ECALLBACK", "Internal error" } },
    //{ 0x804101CC,{ "SCE_NET_ERROR_EINTERNAL", "Internal error" } },
    //{ 0x804101CD,{ "SCE_NET_ERROR_ERETURN",   "libnetctl error was returned" } },
    //{ 0x804101CE,{ "SCE_NET_ERROR_ENOALLOCMEM",   "Insufficient memory (library)" } },
    //{ 0x804101DC,{ "SCE_NET_ERROR_RESOLVER_EINTERNAL",    "Internal error" } },
    //{ 0x804101DD,{ "SCE_NET_ERROR_RESOLVER_EBUSY",    "Resolver was in use" } },
    //{ 0x804101DE,{ "SCE_NET_ERROR_RESOLVER_ENOSPACE", "Insufficient memory (library)" } },
    //{ 0x804101DF,{ "SCE_NET_ERROR_RESOLVER_EPACKET",  "Invalid DNS response" } },
    //{ 0x804101E0,{ "SCE_NET_ERROR_RESOLVER_ERESERVED224", "Internal error" } },
    //{ 0x804101E1,{ "SCE_NET_ERROR_RESOLVER_ENODNS",   "DNS server not specified" } },
    //{ 0x804101E2,{ "SCE_NET_ERROR_RESOLVER_ETIMEDOUT",    "Timeout occurred" } },
    //{ 0x804101E3,{ "SCE_NET_ERROR_RESOLVER_ENOSUPPORT",   "Unsupported function requested by server" } },
    //{ 0x804101E4,{ "SCE_NET_ERROR_RESOLVER_EFORMAT",  "Invalid response from server" } },
    //{ 0x804101E5,{ "SCE_NET_ERROR_RESOLVER_ESERVERFAILURE",   "Temporary error from server" } },
    //{ 0x804101E6,{ "SCE_NET_ERROR_RESOLVER_ENOHOST",  "Inquired host name does not exist" } },
    //{ 0x804101E7,{ "SCE_NET_ERROR_RESOLVER_ENOTIMPLEMENTED",  "Inquired function is not implemented" } },
    //{ 0x804101E8,{ "SCE_NET_ERROR_RESOLVER_ESERVERREFUSED",   "Inquiry denied" } },
    //{ 0x804101E9,{ "SCE_NET_ERROR_RESOLVER_ENORECORD",    "Inquired record does not exist" } },
    //{ 0x804101EA,{ "SCE_NET_ERROR_RESOLVER_EALIGNMENT",   "Invalid alignment" } },
    //{ 0x80412101,{ "SCE_NET_CTL_ERROR_NOT_INITIALIZED",   "NetCtl library not initialized." } },
    //{ 0x80412103,{ "SCE_NET_CTL_ERROR_CALLBACK_MAX",  "Over maximum number of callback registered." } },
    //{ 0x80412104,{ "SCE_NET_CTL_ERROR_ID_NOT_FOUND",  "Specified ID is not found." } },
    //{ 0x80412105,{ "SCE_NET_CTL_ERROR_INVALID_ID",    "Specified ID is not found." } },
    //{ 0x80412106,{ "SCE_NET_CTL_ERROR_INVALID_CODE",  "Invalid code specified." } },
    //{ 0x80412107,{ "SCE_NET_CTL_ERROR_INVALID_ADDR",  "Invalid address specified." } },
    //{ 0x80412108,{ "SCE_NET_CTL_ERROR_NOT_CONNECTED", "Network not connected." } },
    //{ 0x80412109,{ "SCE_NET_CTL_ERROR_NOT_AVAIL", "Information not available." } },
    //{ 0x8041210D,{ "SCE_NET_CTL_ERROR_NETWORK_DISABLED",  "Network disabled." } },
    //{ 0x8041210E,{ "SCE_NET_CTL_ERROR_DISCONNECT_REQ",    "Disconnect event occured by disconnect request." } },
    //{ 0x8041210F,{ "SCE_NET_CTL_ERROR_INVALID_TYPE",  "The specified type is invalid." } },
    //{ 0x80412111,{ "SCE_NET_CTL_ERROR_INVALID_SIZE",  "Structure size specified in size member of the structure is invalid." } },
    //{ 0x80412115,{ "SCE_NET_CTL_ERROR_ETHERNET_PLUGOUT",  "Ethernet cable is unplugged." } },
    //{ 0x80412116,{ "SCE_NET_CTL_ERROR_WIFI_DEAUTHED", "Deauthorized by access point." } },
    //{ 0x80412117,{ "SCE_NET_CTL_ERROR_WIFI_BEACON_LOST",  "Could not receive beacon from access point." } },
    //{ 0x80412183,{ "SCE_NET_CTL_ERROR_IPCINT_OUT_OF_MEMORY",  "Could not allocate memory." } },
    //{ 0x80412187,{ "SCE_NET_CTL_ERROR_IPCINT_BUSY",   "Not executed due to processing of connect or scan." } },
    //{ 0x80412190,{ "SCE_NET_CTL_ERROR_IPCINT_INVALID_SSID",   "The specified SSID is invalid." } },
    //{ 0x80412191,{ "SCE_NET_CTL_ERROR_IPCINT_INVALID_SSIDS_NUM",  "The specified number of SSIDs is invalid." } },
    //{ 0x80412199,{ "SCE_NET_CTL_ERROR_IPCINT_SCANINFO_LOCKED",    "Could not get scan information due to processing of scan." } },
    //{ 0x8041219D,{ "SCE_NET_CTL_ERROR_IPCINT_INVALID_SCANINFO_BSSID", "The specified BSSID for getting scan information is invalid." } },
    //{ 0x8041219E,{ "SCE_NET_CTL_ERROR_IPCINT_INVALID_SIZE",   "The value of size member variable of specified structure is invalid." } },
    //{ 0x8041219F,{ "SCE_NET_CTL_ERROR_IPCINT_NO_SCANINFO",    "There is no scan result." } },
    //{ 0x804121A1,{ "SCE_NET_CTL_ERROR_IPCINT_PROHIBITED", "Prohibited function call." } },
    //{ 0x80412801,{ "SCE_GAME_UPDATE_ERROR_NOT_INITIALIZED",   "GameUpdate library not initialized." } },
    //{ 0x80412802,{ "SCE_GAME_UPDATE_ERROR_ALREADY_INITIALIZED",   "GameUpdate library already initialized." } },
    //{ 0x80412803,{ "SCE_GAME_UPDATE_ERROR_INVALID_ARG",   "Invalid argument." } },
    //{ 0x80412804,{ "SCE_GAME_UPDATE_ERROR_INVALID_SIZE",  "Specified size is invalid." } },
    //{ 0x80412805,{ "SCE_GAME_UPDATE_ERROR_REQUEST_NOT_FOUND", "Specified request is not found." } },
    //{ 0x80412806,{ "SCE_GAME_UPDATE_ERROR_TOO_MANY_REQUESTS", "Cannot create more requests." } },
    //{ 0x80412807,{ "SCE_GAME_UPDATE_ERROR_ABORTED",   "Patch check is canceled." } },
    //{ 0x80412808,{ "SCE_GAME_UPDATE_ERROR_BUSY",  "Patch check is in execution." } },
    //{ 0x8041280A,{ "SCE_GAME_UPDATE_ERROR_NO_SUCH_TITLE", "Specified title ID is not found." } },
    //{ 0x80412901,{ "SCE_NET_CTL_AP_ERROR_INVALID_OPTSTR", "The specified optStr is invalid." } },
    //{ 0x80412902,{ "SCE_NET_CTL_AP_ERROR_APP_PROCESS_SUSPEND",    "AP is stopped due to app process suspend." } },
    //{ 0x80412903,{ "SCE_NET_CTL_AP_ERROR_IPADDR_CONFLICT",    "PS4 attempts to assign an IP address as an client which causes collision with AP's LAN address." } },
    //{ 0x80412904,{ "SCE_NET_CTL_AP_ERROR_FREQ_BAND_CONFLICT", "Frequency band used for PS4 connecting to an AP conflicts with the one for AP." } },
    //{ 0x80412981,{ "SCE_NET_APCTL_ERROR_VSH_NOT_INITIALIZED", "NetApctl library is not initialized." } },
    //{ 0x80412982,{ "SCE_NET_APCTL_ERROR_VSH_NOT_TERMINATED",  "NetApctl library is not terminated." } },
    //{ 0x80412983,{ "SCE_NET_APCTL_ERROR_VSH_INVALID_ADDR",    "The specified pointer address is invalid." } },
    //{ 0x80412984,{ "SCE_NET_APCTL_ERROR_VSH_CALLBACK_MAX",    "Over max number of callback function." } },
    //{ 0x80412985,{ "SCE_NET_APCTL_ERROR_VSH_INVALID_ID",  "The specified ID is invalid." } },
    //{ 0x80412986,{ "SCE_NET_APCTL_ERROR_VSH_BUSY",    "Not executed due to already processing." } },
    //{ 0x80412987,{ "SCE_NET_APCTL_ERROR_VSH_UNKNOWN_WIFI_SECURITY",   "The specified wifi_security is invalid." } },
    //{ 0x80412988,{ "SCE_NET_APCTL_ERROR_VSH_INVALID_WIFI_SECURITY_KEY_LEN",   "The length of specified wifi_security_key is invalid." } },
    //{ 0x80412989,{ "SCE_NET_APCTL_ERROR_VSH_UNKNOWN_IP_CONFIG",   "The specified ip_config is invalid." } },
    //{ 0x8041298A,{ "SCE_NET_APCTL_ERROR_VSH_INVALID_IPADDR",  "The specified IP address is invalid. (sceNetInetPton(), sceNetInetNtop() return error.)" } },
    //{ 0x8041298B,{ "SCE_NET_APCTL_ERROR_VSH_INVALID_SSID",    "The specified SSID is invalid." } },
    //{ 0x8041298C,{ "SCE_NET_APCTL_ERROR_VSH_INVALID_WIFI_SECURITY_KEY",   "The string of specified wifi_security_key is invalid." } },
    //{ 0x8041298D,{ "SCE_NET_APCTL_ERROR_VSH_INVALID_SIZE",    "The value of size member variable of specified structure is invalid." } },
    //{ 0x8041298E,{ "SCE_NET_CTL_AP_ERROR_AP_DISABLED",    "AP disabled." } },
    //{ 0x8041298F,{ "SCE_NET_CTL_AP_ERROR_NOT_STARTED",    "AP not started." } },
    //{ 0x80412990,{ "SCE_NET_CTL_AP_ERROR_INVALID_TYPE",   "specified type is invalid." } },
    //{ 0x80412991,{ "SCE_NET_CTL_AP_ERROR_INVALID_ADDR",   "The specified pointer address is invalid." } },
    //{ 0x80412992,{ "SCE_NET_CTL_AP_ERROR_CHANNEL_CONFLICT",   "PS4 attempts to connect to an AP with different channel during AP enabled." } },
    //{ 0x80412993,{ "SCE_NET_CTL_AP_ERROR_STOP_REQ",   "Stop API is called." } },
    //{ 0x80412994,{ "SCE_NET_CTL_AP_ERROR_NOT_INITIALIZED",    "NetCtlAp library is not initialized." } },
    //{ 0x80412995,{ "SCE_NET_CTL_AP_ERROR_CALLBACK_MAX",   "Over max number of callback function." } },
    //{ 0x80412996,{ "SCE_NET_CTL_AP_ERROR_INVALID_ID", "The specified ID is invalid." } },
    //{ 0x80412997,{ "SCE_NET_CTL_AP_ERROR_ID_NOT_FOUND",   "The specified ID is not found." } },
    //{ 0x80412998,{ "SCE_NET_CTL_AP_ERROR_INVALID_SIZE",   "size member in specified structure is invalid." } },
    //{ 0x8041299A,{ "SCE_NET_CTL_AP_ERROR_OWNER_CHANGED",  "AP is disconnected because high priority AP instance started." } },
    //{ 0x8041299B,{ "SCE_NET_CTL_AP_ERROR_VSH_INVALID_OPTSTR", "The specified optStr is invalid." } },
    //{ 0x80431001,{ "SCE_HTTP_ERROR_BEFORE_INIT",  "Before library initialization" } },
    //{ 0x80431020,{ "SCE_HTTP_ERROR_ALREADY_INITED",   "Library is already initialized" } },
    //{ 0x80431021,{ "SCE_HTTP_ERROR_BUSY", "The specified resource is under use" } },
    //{ 0x80431022,{ "SCE_HTTP_ERROR_OUT_OF_MEMORY",    "Insufficient free memory space" } },
    //{ 0x80431025,{ "SCE_HTTP_ERROR_NOT_FOUND",    "The specified element does not exist" } },
    //{ 0x80431061,{ "SCE_HTTP_ERROR_UNKNOWN_SCHEME",   "Invalid scheme was specified" } },
    //{ 0x80431063,{ "SCE_HTTP_ERROR_NETWORK",  "Unused" } },
    //{ 0x80431064,{ "SCE_HTTP_ERROR_BAD_RESPONSE", "Response is invalid" } },
    //{ 0x80431065,{ "SCE_HTTP_ERROR_BEFORE_SEND",  "The specified request has not been sent yet" } },
    //{ 0x80431066,{ "SCE_HTTP_ERROR_AFTER_SEND",   "Request API was called after request transmission" } },
    //{ 0x80431068,{ "SCE_HTTP_ERROR_TIMEOUT",  "Timed out" } },
    //{ 0x80431069,{ "SCE_HTTP_ERROR_UNKNOWN_AUTH_TYPE",    "The specified authentication type unknown" } },
    //{ 0x8043106A,{ "SCE_HTTP_ERROR_INVALID_VERSION",  "Invalid version was specified" } },
    //{ 0x8043106B,{ "SCE_HTTP_ERROR_UNKNOWN_METHOD",   "The value specified in method is invalid" } },
    //{ 0x8043106F,{ "SCE_HTTP_ERROR_READ_BY_HEAD_METHOD",  "The specified request is for the HEAD method" } },
    //{ 0x80431070,{ "SCE_HTTP_ERROR_NOT_IN_COM",   "Internal error" } },
    //{ 0x80431071,{ "SCE_HTTP_ERROR_NO_CONTENT_LENGTH",    "Acquisition API was called by the transaction in which Content-Length is not contained" } },
    //{ 0x80431072,{ "SCE_HTTP_ERROR_CHUNK_ENC",    "Acquisition API was called by the transaction in which Content-Length is not contained" } },
    //{ 0x80431073,{ "SCE_HTTP_ERROR_TOO_LARGE_RESPONSE_HEADER",    "Too large a response header was received" } },
    //{ 0x80431075,{ "SCE_HTTP_ERROR_SSL",  "Failed to SSL communication" } },
    //{ 0x80431076,{ "SCE_HTTP_ERROR_INSUFFICIENT_STACKSIZE",   "insufficient stack size" } },
    //{ 0x80431080,{ "SCE_HTTP_ERROR_ABORTED",  "Interruption API is called" } },
    //{ 0x80431081,{ "SCE_HTTP_ERROR_UNKNOWN",  "Internal error" } },
    //{ 0x80431082,{ "SCE_HTTP_ERROR_EAGAIN",   "Request is in blocking state" } },
    //{ 0x80431084,{ "SCE_HTTP_ERROR_PROXY",    "Failed to establish the connection to the HTTP Proxy" } },
    //{ 0x80431085,{ "SCE_HTTP_ERROR_BROKEN",   "Internal error" } },
    //{ 0x80431100,{ "SCE_HTTP_ERROR_INVALID_ID",   "Invalid object ID was specified" } },
    //{ 0x80431104,{ "SCE_HTTP_ERROR_OUT_OF_SIZE",  "The buffer size is insufficient" } },
    //{ 0x804311FE,{ "SCE_HTTP_ERROR_INVALID_VALUE",    "Invalid value was specified" } },
    //{ 0x80432025,{ "SCE_HTTP_ERROR_PARSE_HTTP_NOT_FOUND", "The specified header field does not exist" } },
    //{ 0x80432060,{ "SCE_HTTP_ERROR_PARSE_HTTP_INVALID_RESPONSE",  "The specified header field does not exist" } },
    //{ 0x804321FE,{ "SCE_HTTP_ERROR_PARSE_HTTP_INVALID_VALUE", "The specified header field does not exist" } },
    //{ 0x80433060,{ "SCE_HTTP_ERROR_INVALID_URL",  "Invalid URL was specified" } },
    //{ 0x80435060,{ "SCE_HTTPS_ERROR_CERT",    "Server certificate is invalid" } },
    //{ 0x80435061,{ "SCE_HTTPS_ERROR_HANDSHAKE",   "Failed to SSL handshake" } },
    //{ 0x80435062,{ "SCE_HTTPS_ERROR_IO",  "Some communication error occurred during SSL communication" } },
    //{ 0x80435063,{ "SCE_HTTPS_ERROR_INTERNAL",    "Internal Ssl library error" } },
    //{ 0x80435064,{ "SCE_HTTPS_ERROR_PROXY",   "HTTP PROXY server returned an error before SSL communication" } },
    //{ 0x8043506B,{ "SCE_HTTPS_ERROR_PROHIBITED",  "called API with prohibited options" } },
    //{ 0x80436001,{ "SCE_HTTP_ERROR_RESOLVER_EPACKET", "Invalid DNS response" } },
    //{ 0x80436002,{ "SCE_HTTP_ERROR_RESOLVER_ENODNS",  "DNS server not specified" } },
    //{ 0x80436003,{ "SCE_HTTP_ERROR_RESOLVER_ETIMEDOUT",   "Timeout occurred" } },
    //{ 0x80436004,{ "SCE_HTTP_ERROR_RESOLVER_ENOSUPPORT",  "Unsupported function requested by server" } },
    //{ 0x80436005,{ "SCE_HTTP_ERROR_RESOLVER_EFORMAT", "Invalid response from server" } },
    //{ 0x80436006,{ "SCE_HTTP_ERROR_RESOLVER_ESERVERFAILURE",  "Temporary error from server" } },
    //{ 0x80436007,{ "SCE_HTTP_ERROR_RESOLVER_ENOHOST", "Inquired host name does not exist" } },
    //{ 0x80436008,{ "SCE_HTTP_ERROR_RESOLVER_ENOTIMPLEMENTED", "Inquired function is not implemented" } },
    //{ 0x80436009,{ "SCE_HTTP_ERROR_RESOLVER_ESERVERREFUSED",  "Inquiry denied" } },
    //{ 0x8043600A,{ "SCE_HTTP_ERROR_RESOLVER_ENORECORD",   "Inquired record does not exist" } },
    //{ 0x80460001,{ "SCE_FONT_ERROR_FATAL",    "Fatal error" } },
    //{ 0x80460002,{ "SCE_FONT_ERROR_INVALID_PARAMETER",    "Invalid argument value detected" } },
    //{ 0x80460003,{ "SCE_FONT_ERROR_INVALID_MEMORY",   "Invalid SceFontMemory detected" } },
    //{ 0x80460004,{ "SCE_FONT_ERROR_INVALID_LIBRARY",  "Invalid SceFontLibrary detected" } },
    //{ 0x80460005,{ "SCE_FONT_ERROR_INVALID_FONT_HANDLE",  "Invalid SceFontHandle detected" } },
    //{ 0x80460006,{ "SCE_FONT_ERROR_INVALID_GLYPH",    "Invalid SceFontGlyph detected" } },
    //{ 0x80460007,{ "SCE_FONT_ERROR_INVALID_RENDERER", "Invalid SceFontRenderer detected" } },
    //{ 0x80460008,{ "SCE_FONT_ERROR_INVALID_TEXT_SOURCE",  "Invalid SceFontTextSource detected" } },
    //{ 0x80460009,{ "SCE_FONT_ERROR_INVALID_STRING",   "Invalid SceFontString detected" } },
    //{ 0x8046000A,{ "SCE_FONT_ERROR_INVALID_WRITING",  "Invalid SceFontWriting/SceFontWrintingLine detected" } },
    //{ 0x80460010,{ "SCE_FONT_ERROR_ALLOCATION_FAILED",    "Memory allocation failed" } },
    //{ 0x80460011,{ "SCE_FONT_ERROR_FS_OPEN_FAILED",   "File open failed" } },
    //{ 0x80460018,{ "SCE_FONT_ERROR_NO_SUPPORT_LIBRARY",   "Unsupported library" } },
    //{ 0x80460019,{ "SCE_FONT_ERROR_NO_SUPPORT_FORMAT",    "Unsupported format" } },
    //{ 0x80460020,{ "SCE_FONT_ERROR_NO_SUPPORT_FUNCTION",  "Unsupported function" } },
    //{ 0x80460021,{ "SCE_FONT_ERROR_ALREADY_SPECIFIED",    "Already specified" } },
    //{ 0x80460022,{ "SCE_FONT_ERROR_ALREADY_ATTACHED", "Already attached" } },
    //{ 0x80460023,{ "SCE_FONT_ERROR_ALREADY_OPENED",   "Already opened font detected" } },
    //{ 0x80460025,{ "SCE_FONT_ERROR_NOT_ATTACHED_CACHE_BUFFER",    "No cache buffer" } },
    //{ 0x80460031,{ "SCE_FONT_ERROR_NO_SUPPORT_FONTSET",   "Unsupported font set" } },
    //{ 0x80460033,{ "SCE_FONT_ERROR_FONT_OPEN_MAX",    "Exceeding maximum number of font opens" } },
    //{ 0x80460036,{ "SCE_FONT_ERROR_FONT_OPEN_FAILED", "Failed in font opening process" } },
    //{ 0x80460037,{ "SCE_FONT_ERROR_FONT_CLOSE_FAILED",    "Failed in font closing process" } },
    //{ 0x80460040,{ "SCE_FONT_ERROR_NO_SUPPORT_TYPOGRAPHY",    "Unsupported typography" } },
    //{ 0x80460041,{ "SCE_FONT_ERROR_NO_SUPPORT_CODE",  "Unsupported code" } },
    //{ 0x80460042,{ "SCE_FONT_ERROR_NO_SUPPORT_GLYPH", "Glyph could not be found" } },
    //{ 0x80460043,{ "SCE_FONT_ERROR_NO_SUPPORT_SCRIPT",    "Unsupported script" } },
    //{ 0x80460044,{ "SCE_FONT_ERROR_NO_SUPPORT_LANGUAGE",  "Unsupported language" } },
    //{ 0x80460050,{ "SCE_FONT_ERROR_NO_SUPPORT_SURFACE",   "Unsupported surface" } },
    //{ 0x80460058,{ "SCE_FONT_ERROR_UNSET_PARAMETER",  "Unset parameter" } },
    //{ 0x80460060,{ "SCE_FONT_ERROR_ALREADY_BOUND_RENDERER",   "Renderer is already bound" } },
    //{ 0x80460061,{ "SCE_FONT_ERROR_NOT_BOUND_RENDERER",   "Renderer is not bound" } },
    //{ 0x80460063,{ "SCE_FONT_ERROR_RENDERER_ALLOCATION_FAILED",   "Renderer could not allocate memory" } },
    //{ 0x80460065,{ "SCE_FONT_ERROR_RENDERER_RENDER_FAILED",   "Render failed to render" } },
    //{ 0x80480100,{ "SCE_MD5_ERROR_INVALID_POINTER",   "invalid pointer argument" } },
    //{ 0x80480101,{ "SCE_MD5_ERROR_INVALID_STATE", "invalid state" } },
    //{ 0x80480102,{ "SCE_MD5_ERROR_UNINITIALIZED_CONTEXT", "uninitialized context" } },
    //{ 0x80480200,{ "SCE_SHA0_ERROR_INVALID_POINTER",  "invalid pointer argument" } },
    //{ 0x80480201,{ "SCE_SHA0_ERROR_INVALID_STATE",    "invalid state" } },
    //{ 0x80480202,{ "SCE_SHA0_ERROR_UNINITIALIZED_CONTEXT",    "uninitialized context" } },
    //{ 0x80480300,{ "SCE_SHA1_ERROR_INVALID_POINTER",  "invalid pointer argument" } },
    //{ 0x80480301,{ "SCE_SHA1_ERROR_INVALID_STATE",    "invalid state" } },
    //{ 0x80480302,{ "SCE_SHA1_ERROR_UNINITIALIZED_CONTEXT",    "uninitialized context" } },
    //{ 0x80480400,{ "SCE_SHA224_ERROR_INVALID_POINTER",    "invalid pointer argument" } },
    //{ 0x80480401,{ "SCE_SHA224_ERROR_INVALID_STATE",  "invalid state" } },
    //{ 0x80480402,{ "SCE_SHA224_ERROR_UNINITIALIZED_CONTEXT",  "uninitialized context" } },
    //{ 0x80480500,{ "SCE_SHA256_ERROR_INVALID_POINTER",    "invalid pointer argument" } },
    //{ 0x80480501,{ "SCE_SHA256_ERROR_INVALID_STATE",  "invalid state" } },
    //{ 0x80480502,{ "SCE_SHA256_ERROR_UNINITIALIZED_CONTEXT",  "uninitialized context" } },
    //{ 0x80480600,{ "SCE_SHA384_ERROR_INVALID_POINTER",    "invalid pointer argument" } },
    //{ 0x80480601,{ "SCE_SHA384_ERROR_INVALID_STATE",  "invalid state" } },
    //{ 0x80480602,{ "SCE_SHA384_ERROR_UNINITIALIZED_CONTEXT",  "uninitialized context" } },
    //{ 0x80480700,{ "SCE_SHA512_ERROR_INVALID_POINTER",    "invalid pointer argument" } },
    //{ 0x80480701,{ "SCE_SHA512_ERROR_INVALID_STATE",  "invalid state" } },
    //{ 0x80480702,{ "SCE_SHA512_ERROR_UNINITIALIZED_CONTEXT",  "uninitialized context" } },
    //{ 0x80480800,{ "SCE_SHA512T_ERROR_INVALID_POINTER",   "invalid pointer argument" } },
    //{ 0x80480801,{ "SCE_SHA512T_ERROR_INVALID_STATE", "invalid state" } },
    //{ 0x80480802,{ "SCE_SHA512T_ERROR_INVALID_DIGEST_SIZE",   "invalid digest size" } },
    //{ 0x80480803,{ "SCE_SHA512T_ERROR_UNINITIALIZED_CONTEXT", "uninitialized context" } },
    //{ 0x80481000,{ "SCE_HMAC_ERROR_INVALID_POINTER",  "invalid pointer argument" } },
    //{ 0x80481002,{ "SCE_HMAC_ERROR_INVALID_DIGEST_SIZE",  "invalid digest size" } },
    //{ 0x80490100,{ "SCE_MT19937_ERROR_INVALID_POINTER",   "invalid pointer argument" } },
    //{ 0x80490200,{ "SCE_SFMT607_ERROR_INVALID_POINTER",   "invalid pointer argument" } },
    //{ 0x80490201,{ "SCE_SFMT607_ERROR_INVALID_STATE", "invalid state" } },
    //{ 0x80490202,{ "SCE_SFMT607_ERROR_INVALID_SIZE",  "invalid size" } },
    //{ 0x80490300,{ "SCE_SFMT1279_ERROR_INVALID_POINTER",  "invalid pointer argument" } },
    //{ 0x80490301,{ "SCE_SFMT1279_ERROR_INVALID_STATE",    "invalid state" } },
    //{ 0x80490302,{ "SCE_SFMT1279_ERROR_INVALID_SIZE", "invalid size" } },
    //{ 0x80490400,{ "SCE_SFMT2281_ERROR_INVALID_POINTER",  "invalid pointer argument" } },
    //{ 0x80490401,{ "SCE_SFMT2281_ERROR_INVALID_STATE",    "invalid state" } },
    //{ 0x80490402,{ "SCE_SFMT2281_ERROR_INVALID_SIZE", "invalid size" } },
    //{ 0x80490500,{ "SCE_SFMT4253_ERROR_INVALID_POINTER",  "invalid pointer argument" } },
    //{ 0x80490501,{ "SCE_SFMT4253_ERROR_INVALID_STATE",    "invalid state" } },
    //{ 0x80490502,{ "SCE_SFMT4253_ERROR_INVALID_SIZE", "invalid size" } },
    //{ 0x80490600,{ "SCE_SFMT11213_ERROR_INVALID_POINTER", "invalid pointer argument" } },
    //{ 0x80490601,{ "SCE_SFMT11213_ERROR_INVALID_STATE",   "invalid state" } },
    //{ 0x80490602,{ "SCE_SFMT11213_ERROR_INVALID_SIZE",    "invalid size" } },
    //{ 0x80490700,{ "SCE_SFMT19937_ERROR_INVALID_POINTER", "invalid pointer argument" } },
    //{ 0x80490701,{ "SCE_SFMT19937_ERROR_INVALID_STATE",   "invalid state" } },
    //{ 0x80490702,{ "SCE_SFMT19937_ERROR_INVALID_SIZE",    "invalid size" } },
    //{ 0x80490800,{ "SCE_SFMT44497_ERROR_INVALID_POINTER", "invalid pointer argument" } },
    //{ 0x80490801,{ "SCE_SFMT44497_ERROR_INVALID_STATE",   "invalid state" } },
    //{ 0x80490802,{ "SCE_SFMT44497_ERROR_INVALID_SIZE",    "invalid size" } },
    //{ 0x80490900,{ "SCE_SFMT86243_ERROR_INVALID_POINTER", "invalid pointer argument" } },
    //{ 0x80490901,{ "SCE_SFMT86243_ERROR_INVALID_STATE",   "invalid state" } },
    //{ 0x80490902,{ "SCE_SFMT86243_ERROR_INVALID_SIZE",    "invalid size" } },
    //{ 0x80490A00,{ "SCE_SFMT132049_ERROR_INVALID_POINTER",    "invalid pointer argument" } },
    //{ 0x80490A01,{ "SCE_SFMT132049_ERROR_INVALID_STATE",  "invalid state" } },
    //{ 0x80490A02,{ "SCE_SFMT132049_ERROR_INVALID_SIZE",   "invalid size" } },
    //{ 0x80490B00,{ "SCE_SFMT216091_ERROR_INVALID_POINTER",    "invalid pointer argument" } },
    //{ 0x80490B01,{ "SCE_SFMT216091_ERROR_INVALID_STATE",  "invalid state" } },
    //{ 0x80490B02,{ "SCE_SFMT216091_ERROR_INVALID_SIZE",   "invalid size" } },
    //{ 0x804A0001,{ "SCE_NGS2_ERROR_FAIL", "fatal error" } },
    //{ 0x804A0050,{ "SCE_NGS2_ERROR_INVALID_MAX_GRAIN_SAMPLES",    "specified max grain samples is invalid" } },
    //{ 0x804A0051,{ "SCE_NGS2_ERROR_INVALID_NUM_GRAIN_SAMPLES",    "specified grain samples is invalid" } },
    //{ 0x804A0052,{ "SCE_NGS2_ERROR_INVALID_NUM_CHANNELS", "the specified number of channel is invalid" } },
    //{ 0x804A0053,{ "SCE_NGS2_ERROR_INVALID_OUT_ADDRESS",  "specified out address is invalid" } },
    //{ 0x804A0054,{ "SCE_NGS2_ERROR_INVALID_OUT_SIZE", "specified out size is invalid" } },
    //{ 0x804A0080,{ "SCE_NGS2_ERROR_INVALID_OPTION_ADDRESS",   "specified option address is invalid" } },
    //{ 0x804A0081,{ "SCE_NGS2_ERROR_INVALID_OPTION_SIZE",  "specified option size is invalid" } },
    //{ 0x804A0082,{ "SCE_NGS2_ERROR_INVALID_OPTION_FLAG",  "specified system option flag is invalid" } },
    //{ 0x804A0100,{ "SCE_NGS2_ERROR_INVALID_MAX_MATRICES", "specified max matricies is invalid" } },
    //{ 0x804A0101,{ "SCE_NGS2_ERROR_INVALID_MAX_PORTS",    "specified max ports is invalid" } },
    //{ 0x804A0102,{ "SCE_NGS2_ERROR_INVALID_MAX_INPUT_DELAY_BLOCKS",   "specified max input delay blocks is invalid" } },
    //{ 0x804A0103,{ "SCE_NGS2_ERROR_INVALID_MAX_VOICES",   "specified max voices is invalid" } },
    //{ 0x804A0104,{ "SCE_NGS2_ERROR_INVALID_MAX_CHANNELS", "specified max channels is invalid" } },
    //{ 0x804A0105,{ "SCE_NGS2_ERROR_INVALID_MAX_CHANNEL_WORKS",    "specified max channels is invalid" } },
    //{ 0x804A0106,{ "SCE_NGS2_ERROR_INVALID_MAX_WAVEFORM_BLOCKS",  "specified max waveform blocks is invalid" } },
    //{ 0x804A0107,{ "SCE_NGS2_ERROR_INVALID_MAX_ENVELOPE_POINTS",  "specified max envelope points is invalid" } },
    //{ 0x804A0108,{ "SCE_NGS2_ERROR_INVALID_MAX_FILTERS",  "specified max filters is invalid" } },
    //{ 0x804A0109,{ "SCE_NGS2_ERROR_INVALID_MAX_CODEC_CACHES", "specified max codec caches is invalid" } },
    //{ 0x804A010A,{ "SCE_NGS2_ERROR_INVALID_MAX_ATRAC9_DECODERS",  "specified max atrac9 decoders is invalid" } },
    //{ 0x804A010B,{ "SCE_NGS2_ERROR_INVALID_MAX_ATRAC9_CHANNEL_WORKS", "specified max atrac9 channel works is invalid" } },
    //{ 0x804A010C,{ "SCE_NGS2_ERROR_INVALID_MAX_INPUTS",   "specified max inputs is invalid" } },
    //{ 0x804A0150,{ "SCE_NGS2_ERROR_INVALID_NUM_MATRIX_LEVELS",    "the specified number of matrix level is invalid" } },
    //{ 0x804A0151,{ "SCE_NGS2_ERROR_INVALID_NUM_WAVEFORM_BLOCKS",  "the specified number of waveform block is invalid" } },
    //{ 0x804A0152,{ "SCE_NGS2_ERROR_INVALID_NUM_ENVELOPE_POINTS",  "the specified number of envelope points is invalid" } },
    //{ 0x804A0153,{ "SCE_NGS2_ERROR_INVALID_MATRIX_LEVEL_ADDRESS", "the specified matrix level address is invalid" } },
    //{ 0x804A0154,{ "SCE_NGS2_ERROR_INVALID_WAVEFORM_BLOCK_ADDRESS",   "the specified waveform block address is invalid" } },
    //{ 0x804A0155,{ "SCE_NGS2_ERROR_INVALID_ENVELOPE_POINT_ADDRESS",   "the specified envelope point address is invalid" } },
    //{ 0x804A0156,{ "SCE_NGS2_ERROR_INVALID_NUM_PEAKMETER_BLOCKS", "the specified number of peak meter block is invalid" } },
    //{ 0x804A0200,{ "SCE_NGS2_ERROR_INVALID_HANDLE",   "specified handle is invalid" } },
    //{ 0x804A0201,{ "SCE_NGS2_ERROR_INVALID_SAMPLE_RATE",  "specified sample rate is invalid" } },
    //{ 0x804A0202,{ "SCE_NGS2_ERROR_INVALID_REPORT_TYPE",  "specified report type is invalid" } },
    //{ 0x804A0203,{ "SCE_NGS2_ERROR_INVALID_REPORT_HANDLER",   "specified report handler is invalid" } },
    //{ 0x804A0204,{ "SCE_NGS2_ERROR_INVALID_REPORT_HANDLE",    "specified report handle is invalid" } },
    //{ 0x804A0205,{ "SCE_NGS2_ERROR_EMPTY_REPORT_HANDLE",  "report handle can not be registered" } },
    //{ 0x804A0206,{ "SCE_NGS2_ERROR_INVALID_BUFFER_INFO",  "specified buffer info is invalid" } },
    //{ 0x804A0207,{ "SCE_NGS2_ERROR_INVALID_BUFFER_ADDRESS",   "specified buffer address is invalid" } },
    //{ 0x804A0208,{ "SCE_NGS2_ERROR_INVALID_BUFFER_ALIGN", "specified buffer alignment is invalid" } },
    //{ 0x804A0209,{ "SCE_NGS2_ERROR_INVALID_BUFFER_SIZE",  "specified buffer size is invalid" } },
    //{ 0x804A020A,{ "SCE_NGS2_ERROR_INVALID_BUFFER_ALLOCATOR", "specified buffer allocator is invalid" } },
    //{ 0x804A020B,{ "SCE_NGS2_ERROR_BUFFER_BROKEN",    "system buffer is broken" } },
    //{ 0x804A020C,{ "SCE_NGS2_ERROR_EMPTY_BUFFER", "buffer is lack" } },
    //{ 0x804A0230,{ "SCE_NGS2_ERROR_INVALID_SYSTEM_HANDLE",    "specified system handle is invalid" } },
    //{ 0x804A0260,{ "SCE_NGS2_ERROR_INVALID_RACK_ID",  "specified Rack ID is invalid" } },
    //{ 0x804A0261,{ "SCE_NGS2_ERROR_INVALID_RACK_HANDLE",  "specified Rack handle is invalid" } },
    //{ 0x804A0300,{ "SCE_NGS2_ERROR_INVALID_VOICE_HANDLE", "specified voice handle is invalid" } },
    //{ 0x804A0301,{ "SCE_NGS2_ERROR_UNINIT_VOICE", "specified voice is uninitialized" } },
    //{ 0x804A0302,{ "SCE_NGS2_ERROR_INVALID_VOICE_INDEX",  "specified voice index is invalid" } },
    //{ 0x804A0303,{ "SCE_NGS2_ERROR_INVALID_EVENT_TYPE",   "specified voice event is invalid" } },
    //{ 0x804A0304,{ "SCE_NGS2_ERROR_INVALID_PORT_INDEX",   "specified port index is invalid" } },
    //{ 0x804A0305,{ "SCE_NGS2_ERROR_INVALID_PATCH",    "specified patch parameter is invalid" } },
    //{ 0x804A0306,{ "SCE_NGS2_ERROR_EMPTY_CHANNEL_WORK",   "channel work is lack" } },
    //{ 0x804A0307,{ "SCE_NGS2_ERROR_EMPTY_CODEC_DECODER",  "voice resource is lack" } },
    //{ 0x804A0308,{ "SCE_NGS2_ERROR_INVALID_VOICE_CONTROL_ID", "specified voice control ID is invalid" } },
    //{ 0x804A0309,{ "SCE_NGS2_ERROR_INVALID_VOICE_CONTROL_ADDRESS",    "specified voice control address is invalid" } },
    //{ 0x804A030A,{ "SCE_NGS2_ERROR_INVALID_VOICE_CONTROL_SIZE",   "specified voice control size is invalid" } },
    //{ 0x804A030B,{ "SCE_NGS2_ERROR_DETECTED_CIRCULAR_VOICE_CONTROL",  "detected cicular voice control" } },
    //{ 0x804A030C,{ "SCE_NGS2_ERROR_UNABLE_CALLBACK",  "the rack unable to set callback" } },
    //{ 0x804A030D,{ "SCE_NGS2_ERROR_INVALID_CALLBACK_FLAG",    "specified callback flag is invalid" } },
    //{ 0x804A030E,{ "SCE_NGS2_ERROR_INVALID_CALLBACK_HANDLER", "specified callback handler is invalid" } },
    //{ 0x804A030F,{ "SCE_NGS2_ERROR_INVALID_OPERATION",    "Invalid operation" } },
    //{ 0x804A0400,{ "SCE_NGS2_ERROR_INVALID_WAVEFORM_FORMAT",  "voice resource is lack" } },
    //{ 0x804A0401,{ "SCE_NGS2_ERROR_UNKNOWN_WAVEFORM_FORMAT",  "the specified data format of wave form is invalid" } },
    //{ 0x804A0402,{ "SCE_NGS2_ERROR_INVALID_WAVEFORM_TYPE",    "the specified type of wave form is invalid" } },
    //{ 0x804A0403,{ "SCE_NGS2_ERROR_INVALID_WAVEFORM_CONFIG",  "the specified config data of wave form is invalid" } },
    //{ 0x804A0404,{ "SCE_NGS2_ERROR_INVALID_WAVEFORM_SAMPLE_RATE", "the specified sample rate of wave form is invalid" } },
    //{ 0x804A0405,{ "SCE_NGS2_ERROR_INVALID_WAVEFORM_FRAME",   "the specified frame offset or frame mergin is invalid" } },
    //{ 0x804A0406,{ "SCE_NGS2_ERROR_INVALID_WAVEFORM_ADDRESS", "the specified address of wave form is invalid" } },
    //{ 0x804A0407,{ "SCE_NGS2_ERROR_INVALID_WAVEFORM_SIZE",    "the specified size of wave form is invalid" } },
    //{ 0x804A0408,{ "SCE_NGS2_ERROR_INVALID_WAVEFORM_DATA",    "the specified wave form data is invalid" } },
    //{ 0x804A0409,{ "SCE_NGS2_ERROR_INVALID_WAVEFORM_BLOCK_NUM_REPEATS",   "the specified repeat count of wave form block is invalid" } },
    //{ 0x804A0500,{ "SCE_NGS2_ERROR_INVALID_ENVELOPE_CURVE",   "the specified curve of envelope is invalid" } },
    //{ 0x804A0510,{ "SCE_NGS2_ERROR_INVALID_PEAKMETER_FLAG",   "the specified flag of peak meter is invalid" } },
    //{ 0x804A0520,{ "SCE_NGS2_ERROR_INVALID_MAX_CHORUS_PHASES",    "the specified max chorus phases is invalid" } },
    //{ 0x804A0521,{ "SCE_NGS2_ERROR_INVALID_NUM_CHORUS_PHASES",    "the specified number of chorus phases is invalid" } },
    //{ 0x804A0530,{ "SCE_NGS2_ERROR_INVALID_MAX_DELAY_LENGTH", "the specified max delay lenght is invalid" } },
    //{ 0x804A0531,{ "SCE_NGS2_ERROR_INVALID_MAX_DELAY_TAPS",   "the specified max delay taps is invalid" } },
    //{ 0x804A0532,{ "SCE_NGS2_ERROR_INVALID_DELAY_TYPE",   "the specified delay type is invalid" } },
    //{ 0x804A0533,{ "SCE_NGS2_ERROR_INVALID_NUM_DELAY_TAPS",   "the specified number of delay tap is invalid" } },
    //{ 0x804A0534,{ "SCE_NGS2_ERROR_INVALID_DELAY_TAP_INFO",   "the specified delay tap information is invalid" } },
    //{ 0x804A0540,{ "SCE_NGS2_ERROR_INVALID_PITCH_SHIFT_QUALITY",  "the specified quality of pitch shift is invalid" } },
    //{ 0x804A0600,{ "SCE_NGS2_ERROR_INVALID_FILTER_INDEX", "the specified curve of envelope is invalid" } },
    //{ 0x804A0601,{ "SCE_NGS2_ERROR_INVALID_FILTER_TYPE",  "the specified type of filter is invalid" } },
    //{ 0x804A0602,{ "SCE_NGS2_ERROR_INVALID_FILTER_LOCATION",  "the specified location of filter is invalid" } },
    //{ 0x804A0603,{ "SCE_NGS2_ERROR_INVALID_LFE_FC",   "the specified cutoff frequency of filter is invalid" } },
    //{ 0x804A0650,{ "SCE_NGS2_ERROR_INVALID_USER_FX_PARAM_SIZE",   "the specified parameter size of user fx is invalid" } },
    //{ 0x804A0700,{ "SCE_NGS2_ERROR_INVALID_MATRIX_INDEX", "the specified index of matrix is invalid" } },
    //{ 0x804A0800,{ "SCE_NGS2_ERROR_CODEC_UNKNOWN_WAVEFORM",   "the codec of specified wavefrom  is invalid" } },
    //{ 0x804A0801,{ "SCE_NGS2_ERROR_CODEC_EMPTY_INSTANCE", "the codec instance is not empty" } },
    //{ 0x804A0802,{ "SCE_NGS2_ERROR_CODEC_EMPTY_CHANNEL",  "the channel work of codec is not empty" } },
    //{ 0x804A0803,{ "SCE_NGS2_ERROR_CODEC_SETUP_FAIL", "failed to setup decoder" } },
    //{ 0x804A0804,{ "SCE_NGS2_ERROR_CODEC_RESET_FAIL", "failed to reset decoder" } },
    //{ 0x804A0805,{ "SCE_NGS2_ERROR_CODEC_DECODE_FAIL",    "failed to decode" } },
    //{ 0x804A0900,{ "SCE_NGS2_ERROR_INVALID_REVERB_SIZE",  "the sepecified reveb size is invalid" } },
    //{ 0x804A0910,{ "SCE_NGS2_ERROR_INVALID_PAN_UNIT_ANGLE",   "the sepecified unit angle is invalid" } },
    //{ 0x804A0911,{ "SCE_NGS2_ERROR_INVALID_PAN_SPEAKER",  "the sepecified speaker angle is invalid" } },
    //{ 0x804A0912,{ "SCE_NGS2_ERROR_INVALID_PAN_MATRIX_FORMAT",    "the sepecified pan matrix formar is invalid" } },
    //{ 0x804A0913,{ "SCE_NGS2_ERROR_INVALID_PAN_WORK", "the sepecified pan work is invalid" } },
    //{ 0x804A0914,{ "SCE_NGS2_ERROR_INVALID_PAN_PARAM",    "the sepecified pan param is invalid" } },
    //{ 0x804A0920,{ "SCE_NGS2_ERROR_INVALID_GEOM_DISTANCE",    "the sepecified distance is invalid" } },
    //{ 0x804A0921,{ "SCE_NGS2_ERROR_INVALID_GEOM_LISTENER_ADDRESS",    "the sepecified listerner  is invalid" } },
    //{ 0x804A0922,{ "SCE_NGS2_ERROR_INVALID_GEOM_SOURCE_ADDRESS",  "the sepecified source is invalid" } },
    //{ 0x804A0923,{ "SCE_NGS2_ERROR_INVALID_GEOM_FLAG",    "the sepecified flag is invalid" } },
    //{ 0x804A0924,{ "SCE_NGS2_ERROR_INVALID_GEOM_CONE",    "the sepecified cone is invalid" } },
    //{ 0x804A0A00,{ "SCE_NGS2_ERROR_INVALID_MODULE_ID",    "the sepecified module ID is invalid" } },
    //{ 0x804A0A01,{ "SCE_NGS2_ERROR_INVALID_NUM_MODULES",  "the sepecified number of module is invalid" } },
    //{ 0x804A0A02,{ "SCE_NGS2_ERROR_INVALID_NUM_MODULE_BUFFERS",   "the sepecified number of module buffer is invalid" } },
    //{ 0x804A0A03,{ "SCE_NGS2_ERROR_INVALID_MODULE_BUFFER_ID", "the sepecified module buffer ID is invalid" } },
    //{ 0x804A0A04,{ "SCE_NGS2_ERROR_INVALID_MODULE_STATE_OFFSET",  "the sepecified module state offset is invalid" } },
    //{ 0x804A0A05,{ "SCE_NGS2_ERROR_INVALID_MODULE_STATE_SIZE",    "the sepecified module state size is invalid" } },
    //{ 0x804A0A06,{ "SCE_NGS2_ERROR_INVALID_VOICE_STATE_SIZE", "the sepecified voice state size is invalid" } },
    //{ 0x804A0B00,{ "SCE_NGS2_ERROR_INVALID_MODULE_INDEX", "the sepecified module index is invalid" } },
    //{ 0x804A0B01,{ "SCE_NGS2_ERROR_INVALID_MODULE_INFO_SIZE", "the sepecified module info size is invalid" } },
    //{ 0x804D0001,{ "SCE_SULPHA_ERROR_ALREADY_INITIALIZED",    "The system has already initialized" } },
    //{ 0x804D0002,{ "SCE_SULPHA_ERROR_UNINITIALIZED",  "The system has not been initialized" } },
    //{ 0x804D0003,{ "SCE_SULPHA_ERROR_INVALID_ARG",    "An argument is invalid" } },
    //{ 0x804D0004,{ "SCE_SULPHA_ERROR_INVALID_ALIGNMENT",  "The alignment of a parameter is invalid" } },
    //{ 0x804D0005,{ "SCE_SULPHA_ERROR_OUT_OF_MEMORY",  "The system ran out of memory" } },
    //{ 0x804D0006,{ "SCE_SULPHA_ERROR_UNSUPPORTED",    "The feature is unsupported" } },
    //{ 0x804D0007,{ "SCE_SULPHA_ERROR_CONNECTION", "A network error occurred" } },
    //{ 0x804D0008,{ "SCE_SULPHA_ERROR_NETWORK_OWNERSHIP",  "The network is not owned by this system" } },
    //{ 0x804D0009,{ "SCE_SULPHA_ERROR_INVALID_AGENT",  "An agent has the incorrect definition" } },
    //{ 0x804D000A,{ "SCE_SULPHA_ERROR_NOT_CONNECTED",  "The server is not connected" } },
    //{ 0x804D000B,{ "SCE_SULPHA_ERROR_CAPTURE_STARTED",    "A capture is already in progress" } },
    //{ 0x804D000C,{ "SCE_SULPHA_ERROR_OUT_OF_BOOKMARKS",   "The server has run out of bookmarks to allocate" } },
    //{ 0x804D000D,{ "SCE_SULPHA_ERROR_CONNECTION_TIMEOUT", "The server connection has timed out" } },
    //{ 0x804E0801,{ "SCE_VOICE_ERROR_LIBVOICE_NOT_INIT",   "The voice library has not been initialized." } },
    //{ 0x804E0802,{ "SCE_VOICE_ERROR_LIBVOICE_INITIALIZED",    "The voice library has already been initialized." } },
    //{ 0x804E0803,{ "SCE_VOICE_ERROR_GENERAL", "Errors that belong to non-voice APIs." } },
    //{ 0x804E0804,{ "SCE_VOICE_ERROR_PORT_INVALID",    "Invalid port." } },
    //{ 0x804E0805,{ "SCE_VOICE_ERROR_ARGUMENT_INVALID",    "Invalid argument." } },
    //{ 0x804E0806,{ "SCE_VOICE_ERROR_CONTAINER_INVALID",   "Invalid memory block." } },
    //{ 0x804E0807,{ "SCE_VOICE_ERROR_TOPOLOGY",    "Topology error." } },
    //{ 0x804E0808,{ "SCE_VOICE_ERROR_RESOURCE_INSUFFICIENT",   "Insufficient resources." } },
    //{ 0x804E080A,{ "SCE_VOICE_ERROR_SERVICE_DETACHED",    "Library internal voice service is detached." } },
    //{ 0x804E080B,{ "SCE_VOICE_ERROR_SERVICE_ATTACHED",    "Library internal voice service is attached." } },
    //{ 0x804E0901,{ "SCE_VOICE_ERROR_LIBVOICEQOS_NOT_INIT",    "The VoiceQoS library has not been initialized." } },
    //{ 0x804E0902,{ "SCE_VOICE_ERROR_LIBVOICEQOS_ARGUMENT_INVALID",    "An invalid argument was given to a VoiceQoS library function." } },
    //{ 0x804E0903,{ "SCE_VOICE_ERROR_LIBVOICEQOS_PACKET_INVALID",  "An invalid packet was given to a VoiceQoS library function." } },
    //{ 0x804E0904,{ "SCE_VOICE_ERROR_LIBVOICEQOS_INTERNAL_UNRECOVERABLE",  "An unrecoverable internal error occurred in the VoiceQoS library." } },
    //{ 0x804E0905,{ "SCE_VOICE_ERROR_LIBVOICEQOS_INITIALIZED", "The VoiceQoS library has already been initialized." } },
    //{ 0x804E0906,{ "SCE_VOICE_ERROR_LIBVOICEQOS_SYSTEM",  "A system error occurred in the VoiceQoS library." } },
    //{ 0x804E0907,{ "SCE_VOICE_ERROR_LIBVOICEQOS_RESOURCE_USED",   "A resource limit error occurred in the VoiceQoS library." } },
    //{ 0x80550001,{ "SCE_NP_ERROR_ALREADY_INITIALIZED",    "Library has already been initialized" } },
    //{ 0x80550002,{ "SCE_NP_ERROR_NOT_INITIALIZED",    "Library not initialized" } },
    //{ 0x80550003,{ "SCE_NP_ERROR_INVALID_ARGUMENT",   "Any argument is invalid" } },
    //{ 0x80550004,{ "SCE_NP_ERROR_UNKNOWN_PLATFORM_TYPE",  "Undefined platform" } },
    //{ 0x80550005,{ "SCE_NP_ERROR_OUT_OF_MEMORY",  "There is not enough memory" } },
    //{ 0x80550006,{ "SCE_NP_ERROR_SIGNED_OUT", "Called in the not signed-out state" } },
    //{ 0x80550007,{ "SCE_NP_ERROR_USER_NOT_FOUND", "There is no such user." } },
    //{ 0x80550008,{ "SCE_NP_ERROR_CALLBACK_ALREADY_REGISTERED",    "Callback has already been registered" } },
    //{ 0x80550009,{ "SCE_NP_ERROR_CALLBACK_NOT_REGISTERED",    "Callback has not been registered" } },
    //{ 0x8055000A,{ "SCE_NP_ERROR_NOT_SIGNED_UP",  "Called in the not signed-up state" } },
    //{ 0x8055000B,{ "SCE_NP_ERROR_AGE_RESTRICTION",    "Applicable to age restriction" } },
    //{ 0x8055000C,{ "SCE_NP_ERROR_LOGOUT", "Called in the log out state" } },
    //{ 0x8055000D,{ "SCE_NP_ERROR_LATEST_SYSTEM_SOFTWARE_EXIST",   "A new version system software update file exists" } },
    //{ 0x8055000E,{ "SCE_NP_ERROR_LATEST_SYSTEM_SOFTWARE_EXIST_FOR_TITLE", "A new version system software update file exists" } },
    //{ 0x8055000F,{ "SCE_NP_ERROR_LATEST_PATCH_PKG_EXIST", "A new version update file exists" } },
    //{ 0x80550010,{ "SCE_NP_ERROR_LATEST_PATCH_PKG_DOWNLOADED",    "A new version downloaded update file exists" } },
    //{ 0x80550011,{ "SCE_NP_ERROR_INVALID_SIZE",   "Structure size specified in size member of the structure is invalid." } },
    //{ 0x80550012,{ "SCE_NP_ERROR_ABORTED",    "Operations were aborted" } },
    //{ 0x80550013,{ "SCE_NP_ERROR_REQUEST_MAX",    "Created more than maximum number of requests at one time." } },
    //{ 0x80550014,{ "SCE_NP_ERROR_REQUEST_NOT_FOUND",  "There is no such request." } },
    //{ 0x80550015,{ "SCE_NP_ERROR_INVALID_ID", "Specified ID is invalid." } },
    //{ 0x80550016,{ "SCE_NP_ERROR_NP_TITLE_DAT_NOT_FOUND", "There is no nptitle.dat file." } },
    //{ 0x80550017,{ "SCE_NP_ERROR_INCONSISTENT_NP_TITLE_ID",   "nptitle.dat contains inconsistent NpTitleId." } },
    //{ 0x80550018,{ "SCE_NP_ERROR_PATCH_NOT_CHECKED",  "Could not checked if a new version update file is available." } },
    //{ 0x80550019,{ "SCE_NP_ERROR_TITLE_IS_BANNED",    "Application is banned to access to NP." } },
    //{ 0x8055001A,{ "SCE_NP_ERROR_TIMEOUT",    "Operations were timeed out" } },
    //{ 0x8055001B,{ "SCE_NP_ERROR_TITLE_ID_IN_PARAM_SFO_NOT_MATCHED_TO_NP_TITLE_ID",   "Title ID in param.sfo doesn't match to NP Title ID in nptitle.dat or set by sceNpSetNpTitleId()." } },
    //{ 0x8055001C,{ "SCE_NP_ERROR_TITLE_ID_IN_PARAM_SFO_NOT_EXIST",    "Title ID in param.sfo doesn't exist." } },
    //{ 0x80550301,{ "SCE_NP_AUTH_ERROR_INVALID_ARGUMENT",  "Any argument is invalid" } },
    //{ 0x80550302,{ "SCE_NP_AUTH_ERROR_INVALID_SIZE",  "Structure size specified in size member of the structure is invalid." } },
    //{ 0x80550303,{ "SCE_NP_AUTH_ERROR_OUT_OF_MEMORY", "There is not enough memory" } },
    //{ 0x80550304,{ "SCE_NP_AUTH_ERROR_ABORTED",   "Operations were aborted" } },
    //{ 0x80550305,{ "SCE_NP_AUTH_ERROR_REQUEST_MAX",   "Created more than maximum number of requests at one time." } },
    //{ 0x80550306,{ "SCE_NP_AUTH_ERROR_REQUEST_NOT_FOUND", "There is no such request." } },
    //{ 0x80550307,{ "SCE_NP_AUTH_ERROR_INVALID_ID",    "Specified ID is invalid." } },
    //{ 0x80550400,{ "SCE_NP_AUTH_ERROR_SERVICE_END",   "PlayStation(TM)Network services have been permanently terminated" } },
    //{ 0x80550401,{ "SCE_NP_AUTH_ERROR_SERVICE_DOWN",  "PlayStation(TM)Network services are temporarily unavailable" } },
    //{ 0x80550402,{ "SCE_NP_AUTH_ERROR_SERVICE_BUSY",  "PlayStation(TM)Network services are busy" } },
    //{ 0x80550403,{ "SCE_NP_AUTH_ERROR_SERVER_MAINTENANCE",    "Server is under maintenance" } },
    //{ 0x80550410,{ "SCE_NP_AUTH_ERROR_S_INVALID_DATA_LENGTH", "Data length is invalid" } },
    //{ 0x80550411,{ "SCE_NP_AUTH_ERROR_S_INVALID_USER_AGENT",  "User agent is invalid" } },
    //{ 0x80550412,{ "SCE_NP_AUTH_ERROR_S_INVALID_VERSION", "Version is invalid" } },
    //{ 0x80550420,{ "SCE_NP_AUTH_ERROR_S_INVALID_SERVICE_ID",  "Service ID is invalid" } },
    //{ 0x80550421,{ "SCE_NP_AUTH_ERROR_S_INVALID_CREDENTIAL",  "Sign-in ID or password is invalid" } },
    //{ 0x80550422,{ "SCE_NP_AUTH_ERROR_S_INVALID_ENTITLEMENT_ID",  "Entitlement ID is invalid" } },
    //{ 0x80550423,{ "SCE_NP_AUTH_ERROR_S_INVALID_CONSUMED_COUNT",  "Consumption count is invalid" } },
    //{ 0x80550424,{ "SCE_NP_AUTH_ERROR_INVALID_CONSOLE_ID",    "Client console ID is invalid" } },
    //{ 0x80550427,{ "SCE_NP_AUTH_ERROR_CONSOLE_ID_SUSPENDED",  "Use of the client console is temporarily suspended" } },
    //{ 0x80550430,{ "SCE_NP_AUTH_ERROR_ACCOUNT_CLOSED",    "Account has been closed" } },
    //{ 0x80550431,{ "SCE_NP_AUTH_ERROR_ACCOUNT_SUSPENDED", "Account has been temporarily suspended" } },
    //{ 0x80550432,{ "SCE_NP_AUTH_ERROR_ACCOUNT_RENEW_EULA",    "User must renew EULA" } },
    //{ 0x80550440,{ "SCE_NP_AUTH_ERROR_ACCOUNT_RENEW_ACCOUNT1",    "Account cannot be logged into" } },
    //{ 0x80550441,{ "SCE_NP_AUTH_ERROR_ACCOUNT_RENEW_ACCOUNT2",    "Account cannot be logged into" } },
    //{ 0x80550442,{ "SCE_NP_AUTH_ERROR_ACCOUNT_RENEW_ACCOUNT3",    "Account cannot be logged into" } },
    //{ 0x80550443,{ "SCE_NP_AUTH_ERROR_ACCOUNT_RENEW_ACCOUNT4",    "Account cannot be logged into" } },
    //{ 0x80550444,{ "SCE_NP_AUTH_ERROR_ACCOUNT_RENEW_ACCOUNT5",    "Account cannot be logged into" } },
    //{ 0x80550445,{ "SCE_NP_AUTH_ERROR_ACCOUNT_RENEW_ACCOUNT6",    "Account cannot be logged into" } },
    //{ 0x80550446,{ "SCE_NP_AUTH_ERROR_ACCOUNT_RENEW_ACCOUNT7",    "Account cannot be logged into" } },
    //{ 0x80550447,{ "SCE_NP_AUTH_ERROR_ACCOUNT_RENEW_ACCOUNT8",    "Account cannot be logged into" } },
    //{ 0x80550448,{ "SCE_NP_AUTH_ERROR_ACCOUNT_RENEW_ACCOUNT9",    "Account cannot be logged into" } },
    //{ 0x80550449,{ "SCE_NP_AUTH_ERROR_ACCOUNT_RENEW_ACCOUNT10",   "Account cannot be logged into" } },
    //{ 0x8055044A,{ "SCE_NP_AUTH_ERROR_ACCOUNT_RENEW_ACCOUNT11",   "Account cannot be logged into" } },
    //{ 0x8055044B,{ "SCE_NP_AUTH_ERROR_ACCOUNT_RENEW_ACCOUNT12",   "Account cannot be logged into" } },
    //{ 0x8055044C,{ "SCE_NP_AUTH_ERROR_ACCOUNT_RENEW_ACCOUNT13",   "Account cannot be logged into" } },
    //{ 0x8055044D,{ "SCE_NP_AUTH_ERROR_ACCOUNT_RENEW_ACCOUNT14",   "Account cannot be logged into" } },
    //{ 0x8055044E,{ "SCE_NP_AUTH_ERROR_ACCOUNT_RENEW_ACCOUNT15",   "Account cannot be logged into" } },
    //{ 0x8055044F,{ "SCE_NP_AUTH_ERROR_SUB_ACCOUNT_RENEW_EULA",    "Account cannot be logged into" } },
    //{ 0x8055044F,{ "SCE_NP_AUTH_ERROR_ACCOUNT_RENEW_ACCOUNT16",   "Account cannot be logged into" } },
    //{ 0x80550480,{ "SCE_NP_AUTH_ERROR_UNKNOWN",   "Account cannot be logged into" } },
    //{ 0x80550601,{ "SCE_NP_UTIL_ERROR_INVALID_ARGUMENT",  "Any argument is invalid" } },
    //{ 0x80550602,{ "SCE_NP_UTIL_ERROR_INSUFFICIENT",  "Provided data is insufficient" } },
    //{ 0x80550603,{ "SCE_NP_UTIL_ERROR_PARSER_FAILED", "Failed to parse data" } },
    //{ 0x80550604,{ "SCE_NP_UTIL_ERROR_INVALID_PROTOCOL_ID",   "NP ID with an invalid internal structure was provided." } },
    //{ 0x80550605,{ "SCE_NP_UTIL_ERROR_INVALID_NP_ID", "Specified NP ID is invalid" } },
    //{ 0x80550606,{ "SCE_NP_UTIL_ERROR_INVALID_NP_ENV",    "Obsolete error code." } },
    //{ 0x80550608,{ "SCE_NP_UTIL_ERROR_INVALID_CHARACTER", "Specified data includes an invalid character" } },
    //{ 0x80550609,{ "SCE_NP_UTIL_ERROR_NOT_MATCH", "The two NP IDs that were compared were different values" } },
    //{ 0x8055060A,{ "SCE_NP_UTIL_ERROR_INVALID_TITLEID",   "Specified NP Communication ID is invalid" } },
    //{ 0x8055060E,{ "SCE_NP_UTIL_ERROR_UNKNOWN",   "Internal error" } },
    //{ 0x80550701,{ "SCE_NP_COMMUNITY_ERROR_ALREADY_INITIALIZED",  "Already initialized" } },
    //{ 0x80550702,{ "SCE_NP_COMMUNITY_ERROR_NOT_INITIALIZED",  "Library is not initialized" } },
    //{ 0x80550703,{ "SCE_NP_COMMUNITY_ERROR_OUT_OF_MEMORY",    "Insufficient memory - memory could not be allocated" } },
    //{ 0x80550704,{ "SCE_NP_COMMUNITY_ERROR_INVALID_ARGUMENT", "Invalid argument was specified" } },
    //{ 0x80550705,{ "SCE_NP_COMMUNITY_ERROR_NO_LOGIN", "Error occurred at login processing." } },
    //{ 0x80550706,{ "SCE_NP_COMMUNITY_ERROR_TOO_MANY_OBJECTS", "Too many contexts have been created" } },
    //{ 0x80550707,{ "SCE_NP_COMMUNITY_ERROR_ABORTED",  "Communications processing was aborted" } },
    //{ 0x80550708,{ "SCE_NP_COMMUNITY_ERROR_BAD_RESPONSE", "Response from the server is invalid" } },
    //{ 0x80550709,{ "SCE_NP_COMMUNITY_ERROR_BODY_TOO_LARGE",   "Size of Response from the server is invalid" } },
    //{ 0x8055070A,{ "SCE_NP_COMMUNITY_ERROR_HTTP_SERVER",  "Response returned with the HTTP protocol is invalid" } },
    //{ 0x8055070B,{ "SCE_NP_COMMUNITY_ERROR_INVALID_SIGNATURE",    "Server response signature is invalid, or SceNpCommunicationPassphrase is incorrect" } },
    //{ 0x8055070C,{ "SCE_NP_COMMUNITY_ERROR_INSUFFICIENT_ARGUMENT",    "Insufficient argument" } },
    //{ 0x8055070D,{ "SCE_NP_COMMUNITY_ERROR_UNKNOWN_TYPE", "Unknown type set" } },
    //{ 0x8055070E,{ "SCE_NP_COMMUNITY_ERROR_INVALID_ID",   "Invalid ID" } },
    //{ 0x8055070F,{ "SCE_NP_COMMUNITY_ERROR_INVALID_ONLINE_ID",    "User with the specified Online ID is not signed-in" } },
    //{ 0x80550711,{ "SCE_NP_COMMUNITY_ERROR_INVALID_TYPE", "Invalid type set" } },
    //{ 0x80550712,{ "SCE_NP_COMMUNITY_ERROR_TRANSACTION_ALREADY_END",  "Specified communications processing has already ended" } },
    //{ 0x80550713,{ "SCE_NP_COMMUNITY_ERROR_INVALID_PARTITION",    "Invalid type set" } },
    //{ 0x80550714,{ "SCE_NP_COMMUNITY_ERROR_INVALID_ALIGNMENT",    "Invalid structure size" } },
    //{ 0x80550715,{ "SCE_NP_COMMUNITY_ERROR_CLIENT_HANDLE_ALREADY_EXISTS", "Client with the specified Online ID has already been created" } },
    //{ 0x80550716,{ "SCE_NP_COMMUNITY_ERROR_NO_RESOURCE",  "Response of server is insufficient" } },
    //{ 0x80550717,{ "SCE_NP_COMMUNITY_ERROR_REQUEST_BEFORE_END",   "Specified communications processing has not ended" } },
    //{ 0x80550718,{ "SCE_NP_COMMUNITY_ERROR_TOO_MANY_SLOTID",  "Too many slot IDs have been specified" } },
    //{ 0x80550719,{ "SCE_NP_COMMUNITY_ERROR_TOO_MANY_NPID",    "Too many NP IDs have been specified" } },
    //{ 0x8055071A,{ "SCE_NP_COMMUNITY_ERROR_SCORE_INVALID_SAVEDATA_OWNER", "Application functions are restricted because the save data is owned by another user." } },
    //{ 0x8055071B,{ "SCE_NP_COMMUNITY_ERROR_TUS_INVALID_SAVEDATA_OWNER",   "Application functions are restricted because the save data is owned by another user." } },
    //{ 0x80550801,{ "SCE_NP_COMMUNITY_SERVER_ERROR_BAD_REQUEST",   "Invalid request" } },
    //{ 0x80550802,{ "SCE_NP_COMMUNITY_SERVER_ERROR_INVALID_TICKET",    "Authentication failed" } },
    //{ 0x80550803,{ "SCE_NP_COMMUNITY_SERVER_ERROR_INVALID_SIGNATURE", "Authentication failed" } },
    //{ 0x80550805,{ "SCE_NP_COMMUNITY_SERVER_ERROR_INVALID_NPID",  "Specified NP ID is invalid" } },
    //{ 0x80550806,{ "SCE_NP_COMMUNITY_SERVER_ERROR_FORBIDDEN", "Invalid request.Specified player character ID or slot ID is invalid." } },
    //{ 0x80550807,{ "SCE_NP_COMMUNITY_SERVER_ERROR_INTERNAL_SERVER_ERROR", "Internal error" } },
    //{ 0x80550808,{ "SCE_NP_COMMUNITY_SERVER_ERROR_VERSION_NOT_SUPPORTED", "Internal error" } },
    //{ 0x80550809,{ "SCE_NP_COMMUNITY_SERVER_ERROR_SERVICE_UNAVAILABLE",   "Internal error" } },
    //{ 0x8055080A,{ "SCE_NP_COMMUNITY_SERVER_ERROR_PLAYER_BANNED", "Player is banned" } },
    //{ 0x8055080B,{ "SCE_NP_COMMUNITY_SERVER_ERROR_CENSORED",  "Request includes inappropriate text" } },
    //{ 0x8055080C,{ "SCE_NP_COMMUNITY_SERVER_ERROR_RANKING_RECORD_FORBIDDEN",  "Obsolete" } },
    //{ 0x8055080D,{ "SCE_NP_COMMUNITY_SERVER_ERROR_USER_PROFILE_NOT_FOUND",    "Profile of specified player does not exist" } },
    //{ 0x8055080E,{ "SCE_NP_COMMUNITY_SERVER_ERROR_UPLOADER_DATA_NOT_FOUND",   "Internal error" } },
    //{ 0x8055080F,{ "SCE_NP_COMMUNITY_SERVER_ERROR_QUOTA_MASTER_NOT_FOUND",    "Internal error" } },
    //{ 0x80550810,{ "SCE_NP_COMMUNITY_SERVER_ERROR_RANKING_TITLE_NOT_FOUND",   "Specified title does not exist in the ranking server" } },
    //{ 0x80550811,{ "SCE_NP_COMMUNITY_SERVER_ERROR_BLACKLISTED_USER_ID",   "Player is registered on the blacklist for prohibiting score registration" } },
    //{ 0x80550812,{ "SCE_NP_COMMUNITY_SERVER_ERROR_GAME_RANKING_NOT_FOUND",    "Specified ranking information does not exist" } },
    //{ 0x80550814,{ "SCE_NP_COMMUNITY_SERVER_ERROR_RANKING_STORE_NOT_FOUND",   "Score could not be found (when registering data attachment)" } },
    //{ 0x80550815,{ "SCE_NP_COMMUNITY_SERVER_ERROR_NOT_BEST_SCORE",    "Score cannot be registered because it is not the best score (depends on scoreboard settings)" } },
    //{ 0x80550816,{ "SCE_NP_COMMUNITY_SERVER_ERROR_LATEST_UPDATE_NOT_FOUND",   "Ranking update processing has not been performed" } },
    //{ 0x80550817,{ "SCE_NP_COMMUNITY_SERVER_ERROR_RANKING_BOARD_MASTER_NOT_FOUND",    "Specified scoreboard does not exist" } },
    //{ 0x80550818,{ "SCE_NP_COMMUNITY_SERVER_ERROR_RANKING_GAME_DATA_MASTER_NOT_FOUND",    "Game data of the specified player does not exist" } },
    //{ 0x80550819,{ "SCE_NP_COMMUNITY_SERVER_ERROR_INVALID_ANTICHEAT_DATA",    "Invalid passphrase" } },
    //{ 0x8055081A,{ "SCE_NP_COMMUNITY_SERVER_ERROR_TOO_LARGE_DATA",    "Data size is too large" } },
    //{ 0x8055081B,{ "SCE_NP_COMMUNITY_SERVER_ERROR_NO_SUCH_USER_NPID", "User does not exist" } },
    //{ 0x8055081D,{ "SCE_NP_COMMUNITY_SERVER_ERROR_INVALID_ENVIRONMENT",   "Internal error" } },
    //{ 0x8055081F,{ "SCE_NP_COMMUNITY_SERVER_ERROR_INVALID_ONLINE_NAME_CHARACTER", "Obsolete" } },
    //{ 0x80550820,{ "SCE_NP_COMMUNITY_SERVER_ERROR_INVALID_ONLINE_NAME_LENGTH",    "Internal error" } },
    //{ 0x80550821,{ "SCE_NP_COMMUNITY_SERVER_ERROR_INVALID_ABOUT_ME_CHARACTER",    "Obsolete" } },
    //{ 0x80550822,{ "SCE_NP_COMMUNITY_SERVER_ERROR_INVALID_ABOUT_ME_LENGTH",   "Internal error" } },
    //{ 0x80550823,{ "SCE_NP_COMMUNITY_SERVER_ERROR_INVALID_SCORE", "Invalid score" } },
    //{ 0x80550824,{ "SCE_NP_COMMUNITY_SERVER_ERROR_OVER_THE_RANKING_LIMIT",    "Internal error" } },
    //{ 0x80550826,{ "SCE_NP_COMMUNITY_SERVER_ERROR_FAIL_TO_CREATE_SIGNATURE",  "Internal error" } },
    //{ 0x80550827,{ "SCE_NP_COMMUNITY_SERVER_ERROR_RANKING_MASTER_INFO_NOT_FOUND", "Internal error" } },
    //{ 0x80550828,{ "SCE_NP_COMMUNITY_SERVER_ERROR_OVER_THE_GAME_DATA_LIMIT",  "Data size is too large" } },
    //{ 0x8055082A,{ "SCE_NP_COMMUNITY_SERVER_ERROR_SELF_DATA_NOT_FOUND",   "Self data does not exist" } },
    //{ 0x8055082B,{ "SCE_NP_COMMUNITY_SERVER_ERROR_USER_NOT_ASSIGNED", "Storage area of specified user has not been created" } },
    //{ 0x8055082C,{ "SCE_NP_COMMUNITY_SERVER_ERROR_GAME_DATA_ALREADY_EXISTS",  "Specified score already has data attached" } },
    //{ 0x8055082D,{ "SCE_NP_COMMUNITY_SERVER_ERROR_TOO_MANY_RESULTS",  "The result exceeds the specified maximum limit" } },
    //{ 0x8055082E,{ "SCE_NP_COMMUNITY_SERVER_ERROR_NOT_RECORDABLE_VERSION",    "The application version of the title is less than the minimum version set to the server (because the minimum version must be set to the server, this error does not usually occur in normal operation)" } },
    //{ 0x80550848,{ "SCE_NP_COMMUNITY_SERVER_ERROR_USER_STORAGE_TITLE_MASTER_NOT_FOUND",   "Specified NP Communication ID is not set to the title user storage server database" } },
    //{ 0x80550849,{ "SCE_NP_COMMUNITY_SERVER_ERROR_INVALID_VIRTUAL_USER",  "Specified virtual user does not exist" } },
    //{ 0x8055084A,{ "SCE_NP_COMMUNITY_SERVER_ERROR_USER_STORAGE_DATA_NOT_FOUND",   "Specified data has not been registered" } },
    //{ 0x8055085D,{ "SCE_NP_COMMUNITY_SERVER_ERROR_NON_PLUS_MEMBER",   "This function is only for members of PS Plus." } },
    //{ 0x8055085E,{ "SCE_NP_COMMUNITY_SERVER_ERROR_UNMATCH_SEQUENCE",  "Since the save data of the same title was uploaded to PS plus's cloud save from two or more hardware, the latter became an error by the conflict." } },
    //{ 0x8055085F,{ "SCE_NP_COMMUNITY_SERVER_ERROR_SAVEDATA_NOT_FOUND",    "Specified save data has not been registered" } },
    //{ 0x80550860,{ "SCE_NP_COMMUNITY_SERVER_ERROR_TOO_MANY_SAVEDATA_FILES",   "Too many save data have been uploaded" } },
    //{ 0x80550861,{ "SCE_NP_COMMUNITY_SERVER_ERROR_TOO_MUCH_TOTAL_SAVEDATA_SIZE",  "Too many save data have been uploaded" } },
    //{ 0x80550862,{ "SCE_NP_COMMUNITY_SERVER_ERROR_NOT_YET_DOWNLOADABLE",  "The uploaded copy prohibition save data is not downloadable yet. At present, it does not return at PS4" } },
    //{ 0x80550868,{ "SCE_NP_COMMUNITY_SERVER_ERROR_BLACKLISTED_TITLE", "The save data of the specified title is specified as the upload prohibition title for some problem" } },
    //{ 0x80550869,{ "SCE_NP_COMMUNITY_SERVER_ERROR_TOO_LARGE_ICONDATA",    "Icon size is too large" } },
    //{ 0x8055086A,{ "SCE_NP_COMMUNITY_SERVER_ERROR_TOO_LARGE_SAVEDATA",    "Data size is too large" } },
    //{ 0x8055086B,{ "SCE_NP_COMMUNITY_SERVER_ERROR_UNMATCH_SIGNATURE", "Authentication failed" } },
    //{ 0x8055086C,{ "SCE_NP_COMMUNITY_SERVER_ERROR_UNMATCH_MD5SUM",    "Authentication failed" } },
    //{ 0x8055086D,{ "SCE_NP_COMMUNITY_SERVER_ERROR_TOO_MUCH_SAVEDATA_SIZE",    "Data size is too large" } },
    //{ 0x8055086E,{ "SCE_NP_COMMUNITY_SERVER_ERROR_RECORD_DATE_IS_NEWER_THAN_COMP_DATE",   "A score newer than the specified date was registered." } },
    //{ 0x80550873,{ "SCE_NP_COMMUNITY_SERVER_ERROR_CONDITIONS_NOT_SATISFIED",  "The specified conditions were not satisfied" } },
    //{ 0x80550878,{ "SCE_NP_COMMUNITY_SERVER_ERROR_UNSUPPORTED_PLATFORM",  "Invalid platform type is set" } },
    //{ 0x80550889,{ "SCE_NP_COMMUNITY_SERVER_ERROR_EXPIRED_SIGNATURE", "expired signature" } },
    //{ 0x8055088A,{ "SCE_NP_COMMUNITY_SERVER_ERROR_SAVEDATA_UPDATED",  "Since the save data of the same title was uploaded to PS plus's cloud save from two or more hardware, the latter became an error by the conflict." } },
    //{ 0x805508A0,{ "SCE_NP_COMMUNITY_SERVER_ERROR_MATCHING_BEFORE_SERVICE",   "Matching service has not yet started" } },
    //{ 0x805508A1,{ "SCE_NP_COMMUNITY_SERVER_ERROR_MATCHING_END_OF_SERVICE",   "Matching service has ended" } },
    //{ 0x805508A2,{ "SCE_NP_COMMUNITY_SERVER_ERROR_MATCHING_MAINTENANCE",  "Matching service is under maintenance" } },
    //{ 0x805508A3,{ "SCE_NP_COMMUNITY_SERVER_ERROR_RANKING_BEFORE_SERVICE",    "Ranking period has not started" } },
    //{ 0x805508A4,{ "SCE_NP_COMMUNITY_SERVER_ERROR_RANKING_END_OF_SERVICE",    "Ranking period has ended" } },
    //{ 0x805508A5,{ "SCE_NP_COMMUNITY_SERVER_ERROR_RANKING_MAINTENANCE",   "Ranking server is under maintenance" } },
    //{ 0x805508A6,{ "SCE_NP_COMMUNITY_SERVER_ERROR_NO_SUCH_TITLE", "Server of the specified title does not exist" } },
    //{ 0x805508AA,{ "SCE_NP_COMMUNITY_SERVER_ERROR_TITLE_USER_STORAGE_BEFORE_SERVICE", "Title user storage service has not yet started" } },
    //{ 0x805508AB,{ "SCE_NP_COMMUNITY_SERVER_ERROR_TITLE_USER_STORAGE_END_OF_SERVICE", "Title user storage service has ended" } },
    //{ 0x805508AC,{ "SCE_NP_COMMUNITY_SERVER_ERROR_TITLE_USER_STORAGE_MAINTENANCE",    "Title user storage server is under maintenance" } },
    //{ 0x805508AD,{ "SCE_NP_COMMUNITY_SERVER_ERROR_FSR_BEFORE_SERVICE",    "At present, it does not return at PS4" } },
    //{ 0x805508AE,{ "SCE_NP_COMMUNITY_SERVER_ERROR_FSR_END_OF_SERVICE",    "At present, it does not return at PS4" } },
    //{ 0x805508AF,{ "SCE_NP_COMMUNITY_SERVER_ERROR_FSR_MAINTENANCE",   "At present, it does not return at PS4" } },
    //{ 0x805508B0,{ "SCE_NP_COMMUNITY_SERVER_ERROR_UBS_BEFORE_SERVICE",    "PS plus cloud save server has not yet started" } },
    //{ 0x805508B1,{ "SCE_NP_COMMUNITY_SERVER_ERROR_UBS_END_OF_SERVICE",    "PS plus cloud save server has ended" } },
    //{ 0x805508B2,{ "SCE_NP_COMMUNITY_SERVER_ERROR_UBS_MAINTENANCE",   "PS plus cloud save server is under maintenance" } },
    //{ 0x805508B3,{ "SCE_NP_COMMUNITY_SERVER_ERROR_BASIC_BLACKLISTED_USER_ID", "Player is registered on the blacklist" } },
    //{ 0x805508FF,{ "SCE_NP_COMMUNITY_SERVER_ERROR_UNSPECIFIED",   "Internal error" } },
    //{ 0x80550C01,{ "SCE_NP_MATCHING2_ERROR_OUT_OF_MEMORY",    "There is not enough memory" } },
    //{ 0x80550C02,{ "SCE_NP_MATCHING2_ERROR_ALREADY_INITIALIZED",  "Library has already been initialized" } },
    //{ 0x80550C03,{ "SCE_NP_MATCHING2_ERROR_NOT_INITIALIZED",  "Library not initialized" } },
    //{ 0x80550C04,{ "SCE_NP_MATCHING2_ERROR_CONTEXT_MAX",  "Cannot create more contexts" } },
    //{ 0x80550C05,{ "SCE_NP_MATCHING2_ERROR_CONTEXT_ALREADY_EXISTS",   "The context already exists" } },
    //{ 0x80550C06,{ "SCE_NP_MATCHING2_ERROR_CONTEXT_NOT_FOUND",    "Context not found" } },
    //{ 0x80550C07,{ "SCE_NP_MATCHING2_ERROR_CONTEXT_ALREADY_STARTED",  "Context already started" } },
    //{ 0x80550C08,{ "SCE_NP_MATCHING2_ERROR_CONTEXT_NOT_STARTED",  "Context not started" } },
    //{ 0x80550C09,{ "SCE_NP_MATCHING2_ERROR_SERVER_NOT_FOUND", "Server not found" } },
    //{ 0x80550C0A,{ "SCE_NP_MATCHING2_ERROR_INVALID_ARGUMENT", "Invalid argument" } },
    //{ 0x80550C0B,{ "SCE_NP_MATCHING2_ERROR_INVALID_CONTEXT_ID",   "Invalid context ID" } },
    //{ 0x80550C0C,{ "SCE_NP_MATCHING2_ERROR_INVALID_SERVER_ID",    "Invalid server ID" } },
    //{ 0x80550C0D,{ "SCE_NP_MATCHING2_ERROR_INVALID_WORLD_ID", "Invalid world ID" } },
    //{ 0x80550C0E,{ "SCE_NP_MATCHING2_ERROR_INVALID_LOBBY_ID", "Invalid lobby ID" } },
    //{ 0x80550C0F,{ "SCE_NP_MATCHING2_ERROR_INVALID_ROOM_ID",  "Invalid room ID" } },
    //{ 0x80550C10,{ "SCE_NP_MATCHING2_ERROR_INVALID_MEMBER_ID",    "Invalid member ID" } },
    //{ 0x80550C11,{ "SCE_NP_MATCHING2_ERROR_INVALID_ATTRIBUTE_ID", "Invalid attribute ID" } },
    //{ 0x80550C12,{ "SCE_NP_MATCHING2_ERROR_INVALID_CASTTYPE", "Invalid cast type" } },
    //{ 0x80550C13,{ "SCE_NP_MATCHING2_ERROR_INVALID_SORT_METHOD",  "Invalid sort method" } },
    //{ 0x80550C14,{ "SCE_NP_MATCHING2_ERROR_INVALID_MAX_SLOT", "Invalid max slot" } },
    //{ 0x80550C16,{ "SCE_NP_MATCHING2_ERROR_INVALID_MATCHING_SPACE",   "Invalid search space" } },
    //{ 0x80550C17,{ "SCE_NP_MATCHING2_ERROR_INVALID_BLOCK_KICK_FLAG",  "Invalid block kick flag" } },
    //{ 0x80550C18,{ "SCE_NP_MATCHING2_ERROR_INVALID_MESSAGE_TARGET",   "Invalid message target" } },
    //{ 0x80550C19,{ "SCE_NP_MATCHING2_ERROR_RANGE_FILTER_MAX", "The range filter max specified is bigger than allowed" } },
    //{ 0x80550C1A,{ "SCE_NP_MATCHING2_ERROR_INSUFFICIENT_BUFFER",  "Insufficient buffer" } },
    //{ 0x80550C1B,{ "SCE_NP_MATCHING2_ERROR_DESTINATION_DISAPPEARED",  "Request destination disappeared" } },
    //{ 0x80550C1C,{ "SCE_NP_MATCHING2_ERROR_REQUEST_TIMEOUT",  "Timeout" } },
    //{ 0x80550C1D,{ "SCE_NP_MATCHING2_ERROR_INVALID_ALIGNMENT",    "Invalid alignment" } },
    //{ 0x80550C1E,{ "SCE_NP_MATCHING2_ERROR_CONNECTION_CLOSED_BY_SERVER",  "Server closed the connection" } },
    //{ 0x80550C1F,{ "SCE_NP_MATCHING2_ERROR_SSL_VERIFY_FAILED",    "SSL verification failure" } },
    //{ 0x80550C20,{ "SCE_NP_MATCHING2_ERROR_SSL_HANDSHAKE",    "SSL error" } },
    //{ 0x80550C21,{ "SCE_NP_MATCHING2_ERROR_SSL_SEND", "SSL send error" } },
    //{ 0x80550C22,{ "SCE_NP_MATCHING2_ERROR_SSL_RECV", "SSL receive error" } },
    //{ 0x80550C23,{ "SCE_NP_MATCHING2_ERROR_JOINED_SESSION_MAX",   "Cannot join more sessions" } },
    //{ 0x80550C24,{ "SCE_NP_MATCHING2_ERROR_ALREADY_JOINED",   "Already joined" } },
    //{ 0x80550C25,{ "SCE_NP_MATCHING2_ERROR_INVALID_SESSION_TYPE", "Invalid session type" } },
    //{ 0x80550C26,{ "SCE_NP_MATCHING2_ERROR_NP_SIGNED_OUT",    "Signout state" } },
    //{ 0x80550C27,{ "SCE_NP_MATCHING2_ERROR_BUSY", "Busy error" } },
    //{ 0x80550C28,{ "SCE_NP_MATCHING2_ERROR_SERVER_NOT_AVAILABLE", "Server is not available. Try another server." } },
    //{ 0x80550C29,{ "SCE_NP_MATCHING2_ERROR_NOT_ALLOWED",  "No permission to performed operation." } },
    //{ 0x80550C2A,{ "SCE_NP_MATCHING2_ERROR_ABORTED",  "Request was aborted." } },
    //{ 0x80550C2B,{ "SCE_NP_MATCHING2_ERROR_REQUEST_NOT_FOUND",    "Request not found." } },
    //{ 0x80550C2C,{ "SCE_NP_MATCHING2_ERROR_SESSION_DESTROYED",    "Session got destroyed" } },
    //{ 0x80550C2D,{ "SCE_NP_MATCHING2_ERROR_CONTEXT_STOPPED",  "Context stopped." } },
    //{ 0x80550C2E,{ "SCE_NP_MATCHING2_ERROR_INVALID_REQUEST_PARAMETER",    "Invalid request parameter." } },
    //{ 0x80550C2F,{ "SCE_NP_MATCHING2_ERROR_NOT_NP_SIGN_IN",   "Not signed in" } },
    //{ 0x80550C30,{ "SCE_NP_MATCHING2_ERROR_ROOM_NOT_FOUND",   "Room not found." } },
    //{ 0x80550C31,{ "SCE_NP_MATCHING2_ERROR_ROOM_MEMBER_NOT_FOUND",    "Member not found." } },
    //{ 0x80550C32,{ "SCE_NP_MATCHING2_ERROR_LOBBY_NOT_FOUND",  "Lobby not found." } },
    //{ 0x80550C33,{ "SCE_NP_MATCHING2_ERROR_LOBBY_MEMBER_NOT_FOUND",   "Member not found." } },
    //{ 0x80550C34,{ "SCE_NP_MATCHING2_ERROR_KEEPALIVE_TIMEOUT",    "Connection error" } },
    //{ 0x80550C35,{ "SCE_NP_MATCHING2_ERROR_TIMEOUT_TOO_SHORT",    "Specified timeout is too short." } },
    //{ 0x80550C36,{ "SCE_NP_MATCHING2_ERROR_TIMEDOUT", "Timeout" } },
    //{ 0x80550C37,{ "SCE_NP_MATCHING2_ERROR_INVALID_SLOTGROUP",    "Invalid slot group" } },
    //{ 0x80550C38,{ "SCE_NP_MATCHING2_ERROR_INVALID_ATTRIBUTE_SIZE",   "Invalid attribute size." } },
    //{ 0x80550C39,{ "SCE_NP_MATCHING2_ERROR_CANNOT_ABORT", "Cannot abort request." } },
    //{ 0x80550C3A,{ "SCE_NP_MATCHING2_ERROR_SESSION_NOT_FOUND",    "Session nto found." } },
    //{ 0x80550D01,{ "SCE_NP_MATCHING2_SERVER_ERROR_BAD_REQUEST",   "Bad request." } },
    //{ 0x80550D02,{ "SCE_NP_MATCHING2_SERVER_ERROR_SERVICE_UNAVAILABLE",   "Server unavailable due to maintenence, etc." } },
    //{ 0x80550D03,{ "SCE_NP_MATCHING2_SERVER_ERROR_BUSY",  "Server overload" } },
    //{ 0x80550D04,{ "SCE_NP_MATCHING2_SERVER_ERROR_END_OF_SERVICE",    "Service has ended" } },
    //{ 0x80550D05,{ "SCE_NP_MATCHING2_SERVER_ERROR_INTERNAL_SERVER_ERROR", "Server internal error" } },
    //{ 0x80550D06,{ "SCE_NP_MATCHING2_SERVER_ERROR_PLAYER_BANNED", "Banned user" } },
    //{ 0x80550D07,{ "SCE_NP_MATCHING2_SERVER_ERROR_FORBIDDEN", "The operation is forbidden" } },
    //{ 0x80550D08,{ "SCE_NP_MATCHING2_SERVER_ERROR_BLOCKED",   "Blocked user" } },
    //{ 0x80550D09,{ "SCE_NP_MATCHING2_SERVER_ERROR_UNSUPPORTED_NP_ENV",    "Unsupported NP environment" } },
    //{ 0x80550D0A,{ "SCE_NP_MATCHING2_SERVER_ERROR_INVALID_TICKET",    "Invalid ticket" } },
    //{ 0x80550D0B,{ "SCE_NP_MATCHING2_SERVER_ERROR_INVALID_SIGNATURE", "Invalid signature" } },
    //{ 0x80550D0C,{ "SCE_NP_MATCHING2_SERVER_ERROR_EXPIRED_TICKET",    "Ticket has expired" } },
    //{ 0x80550D0D,{ "SCE_NP_MATCHING2_SERVER_ERROR_ENTITLEMENT_REQUIRED",  "EntitleId is needed to use the world" } },
    //{ 0x80550D0E,{ "SCE_NP_MATCHING2_SERVER_ERROR_NO_SUCH_CONTEXT",   "Context does not exist" } },
    //{ 0x80550D0F,{ "SCE_NP_MATCHING2_SERVER_ERROR_CLOSED",    "The session is closed" } },
    //{ 0x80550D10,{ "SCE_NP_MATCHING2_SERVER_ERROR_NO_SUCH_TITLE", "No such title" } },
    //{ 0x80550D11,{ "SCE_NP_MATCHING2_SERVER_ERROR_NO_SUCH_WORLD", "No such world" } },
    //{ 0x80550D12,{ "SCE_NP_MATCHING2_SERVER_ERROR_NO_SUCH_LOBBY", "The lobby doesn't exist" } },
    //{ 0x80550D13,{ "SCE_NP_MATCHING2_SERVER_ERROR_NO_SUCH_ROOM",  "The room doesn't exist" } },
    //{ 0x80550D14,{ "SCE_NP_MATCHING2_SERVER_ERROR_NO_SUCH_LOBBY_INSTANCE",    "The lobby doesn't exist" } },
    //{ 0x80550D15,{ "SCE_NP_MATCHING2_SERVER_ERROR_NO_SUCH_ROOM_INSTANCE", "The room doesn't exist" } },
    //{ 0x80550D17,{ "SCE_NP_MATCHING2_SERVER_ERROR_PASSWORD_MISMATCH", "The password specified is wrong" } },
    //{ 0x80550D18,{ "SCE_NP_MATCHING2_SERVER_ERROR_LOBBY_FULL",    "The lobby is full" } },
    //{ 0x80550D19,{ "SCE_NP_MATCHING2_SERVER_ERROR_ROOM_FULL", "The room is full" } },
    //{ 0x80550D1B,{ "SCE_NP_MATCHING2_SERVER_ERROR_GROUP_FULL",    "Group is full" } },
    //{ 0x80550D1C,{ "SCE_NP_MATCHING2_SERVER_ERROR_NO_SUCH_USER",  "No such user" } },
    //{ 0x80550D1D,{ "SCE_NP_MATCHING2_SERVER_ERROR_GROUP_PASSWORD_MISMATCH",   "Group password is wrong" } },
    //{ 0x80550D1E,{ "SCE_NP_MATCHING2_SERVER_ERROR_TITLE_PASSPHRASE_MISMATCH", "Title passphrase is wrong" } },
    //{ 0x80550D25,{ "SCE_NP_MATCHING2_SERVER_ERROR_LOBBY_ALREADY_EXIST",   "Lobby already exists" } },
    //{ 0x80550D26,{ "SCE_NP_MATCHING2_SERVER_ERROR_ROOM_ALREADY_EXIST",    "Room already exists" } },
    //{ 0x80550D28,{ "SCE_NP_MATCHING2_SERVER_ERROR_CONSOLE_BANNED",    "Banned console" } },
    //{ 0x80550D29,{ "SCE_NP_MATCHING2_SERVER_ERROR_NO_ROOMGROUP",  "Room group must be specified" } },
    //{ 0x80550D2A,{ "SCE_NP_MATCHING2_SERVER_ERROR_NO_SUCH_GROUP", "No such group" } },
    //{ 0x80550D2B,{ "SCE_NP_MATCHING2_SERVER_ERROR_NO_PASSWORD",   "Password must be specified" } },
    //{ 0x80550D2C,{ "SCE_NP_MATCHING2_SERVER_ERROR_INVALID_GROUP_SLOT_NUM",    "Invalid group slot num" } },
    //{ 0x80550D2D,{ "SCE_NP_MATCHING2_SERVER_ERROR_INVALID_PASSWORD_SLOT_MASK",    "Invalid password slot mask" } },
    //{ 0x80550D2E,{ "SCE_NP_MATCHING2_SERVER_ERROR_DUPLICATE_GROUP_LABEL", "Duplicate group label" } },
    //{ 0x80550D2F,{ "SCE_NP_MATCHING2_SERVER_ERROR_REQUEST_OVERFLOW",  "Request overflow" } },
    //{ 0x80550D30,{ "SCE_NP_MATCHING2_SERVER_ERROR_ALREADY_JOINED",    "Already joined" } },
    //{ 0x80550D31,{ "SCE_NP_MATCHING2_SERVER_ERROR_NAT_TYPE_MISMATCH", "Could not join due to NAT type issue" } },
    //{ 0x80550D32,{ "SCE_NP_MATCHING2_SERVER_ERROR_ROOM_INCONSISTENCY",    "Temporary error" } },
    //{ 0x80550D33,{ "SCE_NP_MATCHING2_SERVER_ERROR_BLOCKED_USER_IN_ROOM",  "A user in your block list is in the room" } },
    //{ 0x80550E01,{ "SCE_NP_MATCHING2_SIGNALING_ERROR_NOT_INITIALIZED",    "---" } },
    //{ 0x80550E02,{ "SCE_NP_MATCHING2_SIGNALING_ERROR_ALREADY_INITIALIZED",    "---" } },
    //{ 0x80550E03,{ "SCE_NP_MATCHING2_SIGNALING_ERROR_OUT_OF_MEMORY",  "---" } },
    //{ 0x80550E04,{ "SCE_NP_MATCHING2_SIGNALING_ERROR_CTXID_NOT_AVAILABLE",    "---" } },
    //{ 0x80550E05,{ "SCE_NP_MATCHING2_SIGNALING_ERROR_CTX_NOT_FOUND",  "---" } },
    //{ 0x80550E06,{ "SCE_NP_MATCHING2_SIGNALING_ERROR_REQID_NOT_AVAILABLE",    "---" } },
    //{ 0x80550E07,{ "SCE_NP_MATCHING2_SIGNALING_ERROR_REQ_NOT_FOUND",  "---" } },
    //{ 0x80550E08,{ "SCE_NP_MATCHING2_SIGNALING_ERROR_PARSER_CREATE_FAILED",   "---" } },
    //{ 0x80550E09,{ "SCE_NP_MATCHING2_SIGNALING_ERROR_PARSER_FAILED",  "---" } },
    //{ 0x80550E0A,{ "SCE_NP_MATCHING2_SIGNALING_ERROR_INVALID_NAMESPACE",  "---" } },
    //{ 0x80550E0B,{ "SCE_NP_MATCHING2_SIGNALING_ERROR_NETINFO_NOT_AVAILABLE",  "---" } },
    //{ 0x80550E0C,{ "SCE_NP_MATCHING2_SIGNALING_ERROR_PEER_NOT_RESPONDING",    "---" } },
    //{ 0x80550E0D,{ "SCE_NP_MATCHING2_SIGNALING_ERROR_CONNID_NOT_AVAILABLE",   "---" } },
    //{ 0x80550E0E,{ "SCE_NP_MATCHING2_SIGNALING_ERROR_CONN_NOT_FOUND", "---" } },
    //{ 0x80550E0F,{ "SCE_NP_MATCHING2_SIGNALING_ERROR_PEER_UNREACHABLE",   "---" } },
    //{ 0x80550E10,{ "SCE_NP_MATCHING2_SIGNALING_ERROR_TERMINATED_BY_PEER", "---" } },
    //{ 0x80550E11,{ "SCE_NP_MATCHING2_SIGNALING_ERROR_TIMEOUT",    "---" } },
    //{ 0x80550E12,{ "SCE_NP_MATCHING2_SIGNALING_ERROR_CTX_MAX",    "---" } },
    //{ 0x80550E13,{ "SCE_NP_MATCHING2_SIGNALING_ERROR_RESULT_NOT_FOUND",   "---" } },
    //{ 0x80550E14,{ "SCE_NP_MATCHING2_SIGNALING_ERROR_CONN_IN_PROGRESS",   "---" } },
    //{ 0x80550E15,{ "SCE_NP_MATCHING2_SIGNALING_ERROR_INVALID_ARGUMENT",   "---" } },
    //{ 0x80550E16,{ "SCE_NP_MATCHING2_SIGNALING_ERROR_OWN_NP_ID",  "---" } },
    //{ 0x80550E17,{ "SCE_NP_MATCHING2_SIGNALING_ERROR_TOO_MANY_CONN",  "---" } },
    //{ 0x80550E18,{ "SCE_NP_MATCHING2_SIGNALING_ERROR_TERMINATED_BY_MYSELF",   "---" } },
    //{ 0x80550E19,{ "SCE_NP_MATCHING2_SIGNALING_ERROR_MATCHING2_PEER_NOT_FOUND",   "---" } },
    //{ 0x80551600,{ "SCE_NP_TROPHY_ERROR_UNKNOWN", "Internal error" } },
    //{ 0x80551601,{ "SCE_NP_TROPHY_ERROR_NOT_INITIALIZED", "NpTrophy library is not initialized." } },
    //{ 0x80551602,{ "SCE_NP_TROPHY_ERROR_ALREADY_INITIALIZED", "NpTrophy library is already initialized." } },
    //{ 0x80551603,{ "SCE_NP_TROPHY_ERROR_OUT_OF_MEMORY",   "Not enough memory" } },
    //{ 0x80551604,{ "SCE_NP_TROPHY_ERROR_INVALID_ARGUMENT",    "invalid argument" } },
    //{ 0x80551605,{ "SCE_NP_TROPHY_ERROR_INSUFFICIENT_BUFFER", "insufficient buffer to continue processing." } },
    //{ 0x80551606,{ "SCE_NP_TROPHY_ERROR_EXCEEDS_MAX", "exceeded the maximum value." } },
    //{ 0x80551607,{ "SCE_NP_TROPHY_ERROR_ABORT",   "Handle is aborted." } },
    //{ 0x80551608,{ "SCE_NP_TROPHY_ERROR_INVALID_HANDLE",  "Invalid handle" } },
    //{ 0x80551609,{ "SCE_NP_TROPHY_ERROR_INVALID_CONTEXT", "Invalid context" } },
    //{ 0x8055160A,{ "SCE_NP_TROPHY_ERROR_INVALID_TROPHY_ID",   "Invalid trophy id." } },
    //{ 0x8055160B,{ "SCE_NP_TROPHY_ERROR_INVALID_GROUP_ID",    "Invalid group id." } },
    //{ 0x8055160C,{ "SCE_NP_TROPHY_ERROR_TROPHY_ALREADY_UNLOCKED", "Trophy has already been unlocked" } },
    //{ 0x8055160D,{ "SCE_NP_TROPHY_ERROR_PLATINUM_CANNOT_UNLOCK",  "Platinum trophy cannot be unlocked." } },
    //{ 0x8055160E,{ "SCE_NP_TROPHY_ERROR_ACCOUNTID_NOT_MATCH", "Account id does not match" } },
    //{ 0x8055160F,{ "SCE_NP_TROPHY_ERROR_NOT_REGISTERED",  "Context is not registered." } },
    //{ 0x80551610,{ "SCE_NP_TROPHY_ERROR_ALREADY_REGISTERED",  "Context is already registered." } },
    //{ 0x80551611,{ "SCE_NP_TROPHY_ERROR_BROKEN_DATA", "Trophy data is corrupted" } },
    //{ 0x80551612,{ "SCE_NP_TROPHY_ERROR_INSUFFICIENT_SPACE",  "There is not enough available space on the internal hdd." } },
    //{ 0x80551613,{ "SCE_NP_TROPHY_ERROR_CONTEXT_ALREADY_EXISTS",  "Context is already exists." } },
    //{ 0x80551614,{ "SCE_NP_TROPHY_ERROR_ICON_FILE_NOT_FOUND", "Icon file not found." } },
    //{ 0x80551616,{ "SCE_NP_TROPHY_ERROR_INVALID_TRP_FILE_FORMAT", "Invalid trophy pack file format." } },
    //{ 0x80551617,{ "SCE_NP_TROPHY_ERROR_UNSUPPORTED_TRP_FILE",    "Unsupported trophy pack file." } },
    //{ 0x80551618,{ "SCE_NP_TROPHY_ERROR_INVALID_TROPHY_CONF_FORMAT",  "Invalid trophy configuration." } },
    //{ 0x80551619,{ "SCE_NP_TROPHY_ERROR_UNSUPPORTED_TROPHY_CONF", "Unspoorted trophy configuration." } },
    //{ 0x8055161A,{ "SCE_NP_TROPHY_ERROR_TROPHY_NOT_UNLOCKED", "Trophy has not been unlocked." } },
    //{ 0x8055161C,{ "SCE_NP_TROPHY_ERROR_USER_NOT_FOUND",  "User not found" } },
    //{ 0x8055161D,{ "SCE_NP_TROPHY_ERROR_USER_NOT_LOGGED_IN",  "user is not logged in." } },
    //{ 0x8055161E,{ "SCE_NP_TROPHY_ERROR_CONTEXT_USER_LOGOUT", "context is inavlid due to user linked to context logging out." } },
    //{ 0x8055161F,{ "SCE_NP_TROPHY_ERROR_USE_TRP_FOR_DEVELOPMENT", "trophy pack file with the For Development flag cannot used in release mode." } },
    //{ 0x80551620,{ "SCE_NP_TROPHY_ERROR_INVALID_NP_TITLE_ID", "invalid NpTitleId." } },
    //{ 0x80551621,{ "SCE_NP_TROPHY_ERROR_INVALID_NP_SERVICE_LABEL",    "Invalid NpServiceLabel" } },
    //{ 0x80551622,{ "SCE_NP_TROPHY_ERROR_NOT_SUPPORTED",   "feature is not supported" } },
    //{ 0x80551623,{ "SCE_NP_TROPHY_ERROR_CONTEXT_EXCEEDS_MAX", "Maximum number of contexts has been exceeded." } },
    //{ 0x80551624,{ "SCE_NP_TROPHY_ERROR_HANDLE_EXCEEDS_MAX",  "Maximum number of handles has been exceeded." } },
    //{ 0x80551625,{ "SCE_NP_TROPHY_ERROR_INVALID_USER_ID", "user id is invalid" } },
    //{ 0x80551626,{ "SCE_NP_TROPHY_ERROR_TITLE_CONF_NOT_INSTALLED",    "title configration is not installed." } },
    //{ 0x80551627,{ "SCE_NP_TROPHY_ERROR_BROKEN_TITLE_CONF",   "installed trophy configration data is corrupted." } },
    //{ 0x80551628,{ "SCE_NP_TROPHY_ERROR_INCONSISTENT_TITLE_CONF", "installing inconsistent trophy-set." } },
    //{ 0x80551629,{ "SCE_NP_TROPHY_ERROR_TITLE_BACKGROUND",    "A function unavailable in BG state was used in BG state." } },
    //{ 0x8055162A,{ "SCE_NP_TROPHY_ERROR_UNSUPPORTED_TITLE",   "The function is not supported for the title." } },
    //{ 0x805516B7,{ "SCE_NP_TROPHY_ERROR_TITLE_PARAM_FILE_NOT_FOUND",  "TitleParamFile is not found" } },
    //{ 0x805516F7,{ "SCE_NP_TROPHY_ERROR_SERVICE_LABEL_NOT_MATCH", "service label is not matched." } },
    //{ 0x80551F02,{ "SCE_NP_BANDWIDTH_TEST_ERROR_NOT_INITIALIZED", "Not initialized NP bandwidth test library." } },
    //{ 0x80551F03,{ "SCE_NP_BANDWIDTH_TEST_ERROR_BAD_RESPONSE",    "Communication error occured during communication with server." } },
    //{ 0x80551F04,{ "SCE_NP_BANDWIDTH_TEST_ERROR_OUT_OF_MEMORY",   "Could not allocate enough memory." } },
    //{ 0x80551F05,{ "SCE_NP_BANDWIDTH_TEST_ERROR_INVALID_ARGUMENT",    "The specified argument is invalid." } },
    //{ 0x80551F06,{ "SCE_NP_BANDWIDTH_TEST_ERROR_INVALID_SIZE",    "Structure size specified in size member of the structure is invalid." } },
    //{ 0x80551F07,{ "SCE_NP_BANDWIDTH_TEST_ERROR_CONTEXT_NOT_AVAILABLE",   "Context not abailable." } },
    //{ 0x80552501,{ "SCE_NP_PARTY_ERROR_UNKNOWN",  "The error is not defined." } },
    //{ 0x80552502,{ "SCE_NP_PARTY_ERROR_ALREADY_INITIALIZED",  "The NpParty library is already initialized." } },
    //{ 0x80552503,{ "SCE_NP_PARTY_ERROR_NOT_INITIALIZED",  "The NpParty library is not initialized." } },
    //{ 0x80552504,{ "SCE_NP_PARTY_ERROR_INVALID_ARGUMENT", "An inappropriate parameter was supplied to the function." } },
    //{ 0x80552505,{ "SCE_NP_PARTY_ERROR_OUT_OF_MEMORY",    "The operation ran out of memory." } },
    //{ 0x80552506,{ "SCE_NP_PARTY_ERROR_NOT_IN_PARTY", "The party member is not in a party." } },
    //{ 0x80552507,{ "SCE_NP_PARTY_ERROR_VOICE_NOT_ENABLED",    "The SceNpPartyVoiceEventHandler event handler was not registered." } },
    //{ 0x80552508,{ "SCE_NP_PARTY_ERROR_MEMBER_NOT_FOUND", "The party member with the specified ID was not found." } },
    //{ 0x80552509,{ "SCE_NP_PARTY_ERROR_SEND_BUSY",    "The network is either busy or you have exceeded the allowable bandwidth." } },
    //{ 0x80552510,{ "SCE_NP_PARTY_ERROR_SEND_OUT_OF_CONTEXT",  "The binary message could not be sent because the party member has an incompatible SceNpTitleId." } },
    //{ 0x80552511,{ "SCE_NP_PARTY_ERROR_INVALID_STATE",    "An API call was made in an invalid state." } },
    //{ 0x80552512,{ "SCE_NP_PARTY_ERROR_INVALID_LOCAL_PARTY_MEMBER",   "An API call was made for a user on this console who does not exist." } },
    //{ 0x80552513,{ "SCE_NP_PARTY_ERROR_INVALID_PROCESS_TYPE", "The calling process type is not a game process." } },
    //{ 0x80552514,{ "SCE_NP_PARTY_ERROR_GAME_SESSION_NOT_ENABLED", "The SceNpPartyGameSessionEventHandler event handler was not registered." } },
    //{ 0x80552601,{ "SCE_NP_SNS_FACEBOOK_ERROR_UNKNOWN",   "Internal error" } },
    //{ 0x80552602,{ "SCE_NP_SNS_FACEBOOK_ERROR_INVALID_ARGUMENT",  "Any argument is invalid" } },
    //{ 0x80552603,{ "SCE_NP_SNS_FACEBOOK_ERROR_OUT_OF_MEMORY", "There is not enough memory" } },
    //{ 0x80552604,{ "SCE_NP_SNS_FACEBOOK_ERROR_EXCEEDS_MAX",   "Created more than maximum number of requests at one time." } },
    //{ 0x80552605,{ "SCE_NP_SNS_FACEBOOK_ERROR_UGM_RESTRICTION",   "Obsolete error code." } },
    //{ 0x80552606,{ "SCE_NP_SNS_FACEBOOK_ERROR_ABORTED",   "Operations were aborted" } },
    //{ 0x80552607,{ "SCE_NP_SNS_FACEBOOK_ERROR_ACCOUNT_NOT_BOUND", "The Facebook account has not been registered" } },
    //{ 0x80552608,{ "SCE_NP_SNS_FACEBOOK_ERROR_CANCELED_BY_SYSTEM",    "Communication has been forcibly canceled by the system. This occurs when an application is suspended, etc." } },
    //{ 0x80552609,{ "SCE_NP_SNS_FACEBOOK_ERROR_SUB_ACCOUNT",   "Facebook coordination functionalities cannot be used because the account is sub-account." } },
    //{ 0x80552701,{ "SCE_NP_SIGNALING_ERROR_NOT_INITIALIZED",  "Library is not initialized" } },
    //{ 0x80552702,{ "SCE_NP_SIGNALING_ERROR_ALREADY_INITIALIZED",  "Libirary is already initialized." } },
    //{ 0x80552703,{ "SCE_NP_SIGNALING_ERROR_OUT_OF_MEMORY",    "Out of memory" } },
    //{ 0x80552704,{ "SCE_NP_SIGNALING_ERROR_CTXID_NOT_AVAILABLE",  "Context ID is not available" } },
    //{ 0x80552705,{ "SCE_NP_SIGNALING_ERROR_CTX_NOT_FOUND",    "Context is not found" } },
    //{ 0x80552706,{ "SCE_NP_SIGNALING_ERROR_REQID_NOT_AVAILABLE",  "Request ID is not available" } },
    //{ 0x80552707,{ "SCE_NP_SIGNALING_ERROR_REQ_NOT_FOUND",    "Request is not found" } },
    //{ 0x80552708,{ "SCE_NP_SIGNALING_ERROR_PARSER_CREATE_FAILED", "Internal error in parse" } },
    //{ 0x80552709,{ "SCE_NP_SIGNALING_ERROR_PARSER_FAILED",    "Internal error in parse" } },
    //{ 0x8055270A,{ "SCE_NP_SIGNALING_ERROR_INVALID_NAMESPACE",    "Invalid namespace" } },
    //{ 0x8055270B,{ "SCE_NP_SIGNALING_ERROR_NETINFO_NOT_AVAILABLE",    "NetInfo is not available" } },
    //{ 0x8055270C,{ "SCE_NP_SIGNALING_ERROR_PEER_NOT_RESPONDING",  "Peer is not responding" } },
    //{ 0x8055270D,{ "SCE_NP_SIGNALING_ERROR_CONNID_NOT_AVAILABLE", "Can not obtain a connection id" } },
    //{ 0x8055270E,{ "SCE_NP_SIGNALING_ERROR_CONN_NOT_FOUND",   "The Specified connection does not exist" } },
    //{ 0x8055270F,{ "SCE_NP_SIGNALING_ERROR_PEER_UNREACHABLE", "Peer is not unreachable" } },
    //{ 0x80552710,{ "SCE_NP_SIGNALING_ERROR_TERMINATED_BY_PEER",   "Connection was terminated by peer" } },
    //{ 0x80552711,{ "SCE_NP_SIGNALING_ERROR_TIMEOUT",  "timeout" } },
    //{ 0x80552712,{ "SCE_NP_SIGNALING_ERROR_CTX_MAX",  "Can not create more context" } },
    //{ 0x80552713,{ "SCE_NP_SIGNALING_ERROR_RESULT_NOT_FOUND", "Specified result does not exist" } },
    //{ 0x80552714,{ "SCE_NP_SIGNALING_ERROR_CONN_IN_PROGRESS", "Making connection now in progress" } },
    //{ 0x80552715,{ "SCE_NP_SIGNALING_ERROR_INVALID_ARGUMENT", "Invalid argument" } },
    //{ 0x80552716,{ "SCE_NP_SIGNALING_ERROR_OWN_NP_ID",    "Specified own NP ID" } },
    //{ 0x80552717,{ "SCE_NP_SIGNALING_ERROR_TOO_MANY_CONN",    "too many connection" } },
    //{ 0x80552718,{ "SCE_NP_SIGNALING_ERROR_TERMINATED_BY_MYSELF", "terminated connection by myself" } },
    //{ 0x80552719,{ "SCE_NP_SIGNALING_ERROR_PROHIBITED_TO_USE",    "It is prohibited to use NpSignaling library." } },
    //{ 0x8055271A,{ "SCE_NP_SIGNALING_ERROR_EXCEED_RATE_LIMIT",    "Exceeded rate limit" } },
    //{ 0x80552901,{ "SCE_NP_WEBAPI_ERROR_OUT_OF_MEMORY",   "Memory is not enough" } },
    //{ 0x80552902,{ "SCE_NP_WEBAPI_ERROR_INVALID_ARGUMENT",    "Invalid argument" } },
    //{ 0x80552903,{ "SCE_NP_WEBAPI_ERROR_INVALID_LIB_CONTEXT_ID",  "Invalid library context id" } },
    //{ 0x80552904,{ "SCE_NP_WEBAPI_ERROR_LIB_CONTEXT_NOT_FOUND",   "Library context does not exist" } },
    //{ 0x80552905,{ "SCE_NP_WEBAPI_ERROR_USER_CONTEXT_NOT_FOUND",  "User context does not exist" } },
    //{ 0x80552906,{ "SCE_NP_WEBAPI_ERROR_REQUEST_NOT_FOUND",   "Request does not exist" } },
    //{ 0x80552907,{ "SCE_NP_WEBAPI_ERROR_NOT_SIGNED_IN",   "Called api which requirs user to be signed in when not be signed in." } },
    //{ 0x80552908,{ "SCE_NP_WEBAPI_ERROR_INVALID_CONTENT_PARAMETER",   "Invalid content parameter" } },
    //{ 0x80552909,{ "SCE_NP_WEBAPI_ERROR_ABORTED", "Process was aborted" } },
    //{ 0x8055290A,{ "SCE_NP_WEBAPI_ERROR_USER_CONTEXT_ALREADY_EXIST",  "The specified user's user context already exists" } },
    //{ 0x8055290B,{ "SCE_NP_WEBAPI_ERROR_PUSH_EVENT_FILTER_NOT_FOUND", "Push event filter corresponding to the filter id does not exist" } },
    //{ 0x8055290C,{ "SCE_NP_WEBAPI_ERROR_PUSH_EVENT_CALLBACK_NOT_FOUND",   "Push event callback corresponding to the id does not exist" } },
    //{ 0x8055290D,{ "SCE_NP_WEBAPI_ERROR_HANDLE_NOT_FOUND",    "Handle corresponding to the id does not exist" } },
    //{ 0x8055290E,{ "SCE_NP_WEBAPI_ERROR_SERVICE_PUSH_EVENT_FILTER_NOT_FOUND", "Service push event filter corresponding to the filter id does not exist" } },
    //{ 0x8055290F,{ "SCE_NP_WEBAPI_ERROR_SERVICE_PUSH_EVENT_CALLBACK_NOT_FOUND",   "Service push event callback corresponding to the id does not exist" } },
    //{ 0x80552910,{ "SCE_NP_WEBAPI_ERROR_SIGNED_IN_USER_NOT_FOUND",    "No users signed in" } },
    //{ 0x80552911,{ "SCE_NP_WEBAPI_ERROR_LIB_CONTEXT_BUSY",    "Can not delete a liburary context when it is in use" } },
    //{ 0x80552912,{ "SCE_NP_WEBAPI_ERROR_USER_CONTEXT_BUSY",   "Can not delete an user context when it is in use" } },
    //{ 0x80552913,{ "SCE_NP_WEBAPI_ERROR_REQUEST_BUSY",    "Can not delete a request when it is in use" } },
    //{ 0x80552914,{ "SCE_NP_WEBAPI_ERROR_INVALID_HTTP_STATUS_CODE",    "Specified the invalid http status code to sceNpWebApiGetErrorCode()." } },
    //{ 0x80552915,{ "SCE_NP_WEBAPI_ERROR_PROHIBITED_HTTP_HEADER",  "Specified a prohibited http header" } },
    //{ 0x80552916,{ "SCE_NP_WEBAPI_ERROR_PROHIBITED_FUNCTION_CALL",    "Called a prohibited function" } },
    //{ 0x80552917,{ "SCE_NP_WEBAPI_ERROR_MULTIPART_PART_NOT_FOUND",    "Multipart part corresponding to the part index does not exist" } },
    //{ 0x80552918,{ "SCE_NP_WEBAPI_ERROR_PARAMETER_TOO_LONG",  "Parameter is too long" } },
    //{ 0x80552919,{ "SCE_NP_WEBAPI_ERROR_HANDLE_BUSY", "Can not delete a handle when it is in use" } },
    //{ 0x8055291A,{ "SCE_NP_WEBAPI_ERROR_LIB_CONTEXT_MAX", "Number of library context reached max" } },
    //{ 0x8055291B,{ "SCE_NP_WEBAPI_ERROR_USER_CONTEXT_MAX",    "Number of user context reached max" } },
    //{ 0x8055291C,{ "SCE_NP_WEBAPI_ERROR_EXTD_PUSH_EVENT_FILTER_NOT_FOUND",    "Extended push event filter corresponding to the filter id does not exist" } },
    //{ 0x8055291D,{ "SCE_NP_WEBAPI_ERROR_EXTD_PUSH_EVENT_CALLBACK_NOT_FOUND",  "Extended push event callback corresponding to the id does not exist" } },
    //{ 0x8055291E,{ "SCE_NP_WEBAPI_ERROR_AFTER_SEND",  "Sending process already started." } },
    //{ 0x8055291F,{ "SCE_NP_WEBAPI_ERROR_TIMEOUT", "Process was timed out" } },
    //{ 0x80552A00,{ "SCE_NP_AUTH_SERVER_ERROR_UNKNOWN",    "An unknown error was received from the server" } },
    //{ 0x80552A01,{ "SCE_NP_AUTH_SERVER_ERROR_INVALID_REQUEST",    "The request is missing a required parameter, includes an invalid parameter value." } },
    //{ 0x80552A02,{ "SCE_NP_AUTH_SERVER_ERROR_UNAUTHORIZED_CLIENT",    "The client is not authorized to request an authorization code using this method." } },
    //{ 0x80552A03,{ "SCE_NP_AUTH_SERVER_ERROR_ACCESS_DENIED",  "The resource owner or authorization server denied the request." } },
    //{ 0x80552A04,{ "SCE_NP_AUTH_SERVER_ERROR_UNSUPPORTED_RESPONSE_TYPE",  "The authorization server does not support obtaining an authorization code using this method." } },
    //{ 0x80552A05,{ "SCE_NP_AUTH_SERVER_ERROR_OBSOLETE_05",    "obsolete error code" } },
    //{ 0x80552A06,{ "SCE_NP_AUTH_SERVER_ERROR_SERVER_ERROR",   "Internal server error." } },
    //{ 0x80552A07,{ "SCE_NP_AUTH_SERVER_ERROR_TEMPORARILY_UNAVAILABLE",    "The authorization server is currently unable to handle the request due to a temporary overloading or maintenance of the server." } },
    //{ 0x80552A08,{ "SCE_NP_AUTH_SERVER_ERROR_OBSOLETE_08",    "obsolete error code" } },
    //{ 0x80552A09,{ "SCE_NP_AUTH_SERVER_ERROR_INVALID_GRANT",  "The provided authorization grant is invalid." } },
    //{ 0x80552A0A,{ "SCE_NP_AUTH_SERVER_ERROR_OBSOLETE_0A",    "obsolete error code" } },
    //{ 0x80552A10,{ "SCE_NP_AUTH_SERVER_ERROR_OBSOLETE_10",    "obsolete error code" } },
    //{ 0x80552A11,{ "SCE_NP_AUTH_SERVER_ERROR_OBSOLETE_11",    "obsolete error code" } },
    //{ 0x80552A12,{ "SCE_NP_AUTH_SERVER_ERROR_OBSOLETE_12",    "obsolete error code" } },
    //{ 0x80552A13,{ "SCE_NP_AUTH_SERVER_ERROR_OBSOLETE_13",    "obsolete error code" } },
    //{ 0x80552A14,{ "SCE_NP_AUTH_SERVER_ERROR_OBSOLETE_14",    "obsolete error code" } },
    //{ 0x80552A15,{ "SCE_NP_AUTH_SERVER_ERROR_OBSOLETE_15",    "obsolete error code" } },
    //{ 0x80552A16,{ "SCE_NP_AUTH_SERVER_ERROR_OBSOLETE_16",    "obsolete error code" } },
    //{ 0x80552A17,{ "SCE_NP_AUTH_SERVER_ERROR_OBSOLETE_17",    "obsolete error code" } },
    //{ 0x80552A18,{ "SCE_NP_AUTH_SERVER_ERROR_OBSOLETE_18",    "obsolete error code" } },
    //{ 0x80552A19,{ "SCE_NP_AUTH_SERVER_ERROR_OBSOLETE_19",    "obsolete error code" } },
    //{ 0x80552A1A,{ "SCE_NP_AUTH_SERVER_ERROR_OBSOLETE_1A",    "obsolete error code" } },
    //{ 0x80552A1B,{ "SCE_NP_AUTH_SERVER_ERROR_OBSOLETE_1B",    "obsolete error code" } },
    //{ 0x80552A1C,{ "SCE_NP_AUTH_SERVER_ERROR_OBSOLETE_1C",    "obsolete error code" } },
    //{ 0x80552A1D,{ "SCE_NP_AUTH_SERVER_ERROR_OBSOLETE_1D",    "obsolete error code" } },
    //{ 0x80552A80,{ "SCE_NP_AUTH_SERVER_ERROR_OBSOLETE_80",    "obsolete error code" } },
    //{ 0x80552A81,{ "SCE_NP_AUTH_SERVER_ERROR_OBSOLETE_81",    "obsolete error code" } },
    //{ 0x80552A82,{ "SCE_NP_AUTH_SERVER_ERROR_OBSOLETE_82",    "obsolete error code" } },
    //{ 0x80552A83,{ "SCE_NP_AUTH_SERVER_ERROR_OBSOLETE_83",    "obsolete error code" } },
    //{ 0x80552B01,{ "SCE_NP_IN_GAME_MESSAGE_ERROR_OUT_OF_MEMORY",  "Memory is not enough" } },
    //{ 0x80552B02,{ "SCE_NP_IN_GAME_MESSAGE_ERROR_INVALID_ARGUMENT",   "Invalid argument" } },
    //{ 0x80552B03,{ "SCE_NP_IN_GAME_MESSAGE_ERROR_LIB_CONTEXT_NOT_FOUND",  "Library context corresponding to the specified library context id does not exist" } },
    //{ 0x80552B04,{ "SCE_NP_IN_GAME_MESSAGE_ERROR_NOT_SIGNED_IN",  "Called api which requir user to be signed in when user isn't signed in." } },
    //{ 0x80552B05,{ "SCE_NP_IN_GAME_MESSAGE_ERROR_HANDLE_NOT_FOUND",   "Handle corresponding to the id does not exist" } },
    //{ 0x80552B06,{ "SCE_NP_IN_GAME_MESSAGE_ERROR_ABORTED",    "Process was aborted" } },
    //{ 0x80552B07,{ "SCE_NP_IN_GAME_MESSAGE_ERROR_SIGNED_IN_USER_NOT_FOUND",   "No users are signed in" } },
    //{ 0x80552B08,{ "SCE_NP_IN_GAME_MESSAGE_ERROR_NOT_PREPARED",   "Not yet call sceNpInGameMessagePrepare()" } },
    //{ 0x80552B09,{ "SCE_NP_IN_GAME_MESSAGE_ERROR_EXCEED_RATE_LIMIT",  "Exceeded rate limit" } },
    //{ 0x80552C00,{ "SCE_TOOLKIT_NP_ERROR_INVALID_POINTER",    "An error occurred because an invalid pointer was passed as an argument." } },
    //{ 0x80552C01,{ "SCE_TOOLKIT_NP_ERROR_OUT_OF_MEMORY",  "An error occurred because memory allocation failed." } },
    //{ 0x80552C02,{ "SCE_TOOLKIT_NP_ERROR_INVALID_ARGUMENT",   "An error occurred because an argument to a method was incorrect." } },
    //{ 0x80552C03,{ "SCE_TOOLKIT_NP_ERROR_INVALID_USER",   "An error occurred because the user given is not valid." } },
    //{ 0x80552C04,{ "SCE_TOOLKIT_NP_ERROR_INVALID_WEBAPI_RESPONSE",    "An error occurred because an invalid response was received from the SEN server." } },
    //{ 0x80552C05,{ "SCE_TOOLKIT_NP_ERROR_RETRIEVING_USER_CONTEXT",    "An error occurred because a service could not be obtained for the user." } },
    //{ 0x80552C06,{ "SCE_TOOLKIT_NP_ERROR_INIT",   "An error was caused during the execution of initialization code." } },
    //{ 0x80552C07,{ "SCE_TOOLKIT_NP_ERROR_INIT_INVALID_MEM_MANAGER",   "An error occurred because the memory manager passed as an argument that was invalid." } },
    //{ 0x80552C08,{ "SCE_TOOLKIT_NP_ERROR_FAILED_ALLOCATE",    "An error occurred because the ToolkitNp library failed to allocate memory for an object." } },
    //{ 0x80552C09,{ "SCE_TOOLKIT_NP_ERROR_ALREADY_INITIALISED",    "An error occurred because the ToolkitNp library has already been initialized." } },
    //{ 0x80552C0A,{ "SCE_TOOLKIT_NP_ERROR_INIT_START_THREAD",  "An error occurred because the thread starting function failed. This was most likely due to locking errors." } },
    //{ 0x80552C0B,{ "SCE_TOOLKIT_NP_ERROR_TERMINATED", "An error occurred because the ToolkitNp library has been terminated." } },
    //{ 0x80552C0C,{ "SCE_TOOLKIT_NP_ERROR_FUTURE_IS_IN_USE",   "An error occurred because the <c>Future</c> object passed as an argument is already in use." } },
    //{ 0x80552C0D,{ "SCE_TOOLKIT_NP_ERROR_GENERIC",    "A generic ToolkitNp library error." } },
    //{ 0x80552C0E,{ "SCE_TOOLKIT_NP_ERROR_INVALID_MODULE", "An error occurred because the module specified was an invalid ID." } },
    //{ 0x80552C0F,{ "SCE_TOOLKIT_NP_ERROR_MODULE_NOT_OWNED",   "An error occurred because a module was not owned by ToolkitNp library and therefore could not be loaded or unloaded." } },
    //{ 0x80552C10,{ "SCE_TOOLKIT_NP_ERROR_NOT_INITIALISED",    "An error occurred because the ToolkitNp library was not initialized." } },
    //{ 0x80552C11,{ "SCE_TOOLKIT_NP_ERROR_OUT_OF_DISKSPACE",   "An error occurred because there was no more disk space." } },
    //{ 0x80552C12,{ "SCE_TOOLKIT_NP_ERROR_NETWORK",    "A network error occurred during execution of an operation." } },
    //{ 0x80552C13,{ "SCE_TOOLKIT_NP_ERROR_OFFLINE",    "A network error occurred as the network was unavailable." } },
    //{ 0x80552C14,{ "SCE_TOOLKIT_NP_ERROR_OPERATION_IN_PROGRESS",  "An error occurred because two operations that cannot be performed concurrently were requested. For example- clashing system utilities." } },
    //{ 0x80552C15,{ "SCE_TOOLKIT_NP_ERROR_NOT_IMPLEMENTED",    "An error occurred because the method is not implemented." } },
    //{ 0x80552C16,{ "SCE_TOOLKIT_NP_ERROR_SERVICE_ID_NOT_OVERRIDEN",   "An error occurred because the service could not override the ID required." } },
    //{ 0x80552C17,{ "SCE_TOOLKIT_NP_ERROR_SERVICE_OFFLINE",    "An error occurred because the ToolkitNp library tried to bring the service up while offline." } },
    //{ 0x80552C18,{ "SCE_TOOLKIT_NP_ERROR_TERMINATION_NOT_SUPPORTED",  "An error occurred because termination of the requested service is not supported." } },
    //{ 0x80552C19,{ "SCE_TOOLKIT_NP_ERROR_SERVICE_NOT_INITIALISED",    "An error occurred because the ToolkitNp library tried to perform an action on a service which has not been initialized." } },
    //{ 0x80552C1A,{ "SCE_TOOLKIT_NP_ERROR_PRESENCE_STRING_TOO_LONG",   "An error occurred because the string passed into the ToolkitNp library was too long for setting presence details." } },
    //{ 0x80552C1B,{ "SCE_TOOLKIT_NP_ERROR_PRESENCE_DATA_TOO_BIG",  "An error occurred because the data passed into <c>PresenceInterface::setPresence()</c> was too big." } },
    //{ 0x80552C1C,{ "SCE_TOOLKIT_NP_ERROR_PRESENCE_NO_TOKENS", "An error occurred because all the presence tokens had been used up." } },
    //{ 0x80552C1D,{ "SCE_TOOLKIT_NP_ERROR_MESSAGE_USER_CANCEL",    "An error occurred because the user canceled the sending of a message." } },
    //{ 0x80552C1E,{ "SCE_TOOLKIT_NP_ERROR_MESSAGE_DATA_TOO_LARGE", "An error occurred because the attachment data was too large." } },
    //{ 0x80552C1F,{ "SCE_TOOLKIT_NP_ERROR_MESSAGE_TYPE_MISMATCH",  "An error occurred because the message specification was invalid." } },
    //{ 0x80552C20,{ "SCE_TOOLKIT_NP_ERROR_MESSAGE_NO_DATA",    "An error occurred because there was no waiting data attachment." } },
    //{ 0x80552C21,{ "SCE_TOOLKIT_NP_ERROR_MESSAGE_INVALID_ID", "An error occurred because a message ID was invalid." } },
    //{ 0x80552C30,{ "SCE_TOOLKIT_NP_ERROR_RANKING_SLOT_FULL",  "An error occurred because the transaction ID slots are full. There are only 6 slots available." } },
    //{ 0x80552C31,{ "SCE_TOOLKIT_NP_ERROR_RANKING_NO_MATCHING_BOARD",  "An error occurred because there is no ranking board in the cache." } },
    //{ 0x80552C32,{ "SCE_TOOLKIT_NP_ERROR_RANKING_NOT_HIGH_SCORE", "An error occurred because the user's score was not the high score." } },
    //{ 0x80552C33,{ "SCE_TOOLKIT_NP_ERROR_RANKING_NO_FRIEND_CACHE",    "An error occurred because there was no cache for a friend." } },
    //{ 0x80552C34,{ "SCE_TOOLKIT_NP_ERROR_RANKING_NO_MATCHING_SCORE",  "An error occurred because the same score was not found in the write cache." } },
    //{ 0x80552C35,{ "SCE_TOOLKIT_NP_ERROR_RANKING_FRIEND_LIST_EMPTY",  "An error occurred because there was no friends rank in the leaderboard." } },
    //{ 0x80552C36,{ "SCE_TOOLKIT_NP_ERROR_RANKING_NO_RANK_IN_READ_CACHE",  "An error occurred because there was no previous score in the read cache." } },
    //{ 0x80552C37,{ "SCE_TOOLKIT_NP_ERROR_RANKING_RANGE_INVALID",  "An error occurred because there the range specified was too big." } },
    //{ 0x80552C38,{ "SCE_TOOLKIT_NP_ERROR_RANKING_REQUEST_ABORTED",    "An error occurred because the ranking request has been aborted." } },
    //{ 0x80552C39,{ "SCE_TOOLKIT_NP_ERROR_RANKING_NOT_INITIALISED",    "An error occurred because an attempt was made to execute ranking services without initializing them first." } },
    //{ 0x80552C3A,{ "SCE_TOOLKIT_NP_ERROR_RANKING_NO_FRIEND_RANK", "An error occurred because there was no previous score in the friend cache." } },
    //{ 0x80552C3B,{ "SCE_TOOLKIT_NP_ERROR_RANKING_NO_SCORES",  "An error occurred because there was no previous score in the write cache." } },
    //{ 0x80552C3C,{ "SCE_TOOLKIT_NP_ERROR_RANKING_INVALID_BOARD",  "An error occurred because an invalid board ID was passed into ranking functions." } },
    //{ 0x80552C3D,{ "SCE_TOOLKIT_NP_ERROR_RANKING_NO_OUTSTANDING", "An error occurred because all the outstanding scores had been registered from the log." } },
    //{ 0x80552C3E,{ "SCE_TOOLKIT_NP_ERROR_RANKING_ALREADY_INITED", "An error occurred because the ranking service is already initialized." } },
    //{ 0x80552C3F,{ "SCE_TOOLKIT_NP_ERROR_RANKING_NOT_TERMINATED", "An error occurred because the ranking service has not been terminated." } },
    //{ 0x80552C40,{ "SCE_TOOLKIT_NP_ERROR_MATCHING_INVALID_SESSION_DESC",  "An error occurred because a create session descriptor was invalid." } },
    //{ 0x80552C41,{ "SCE_TOOLKIT_NP_ERROR_MATCHING_SESSION_CREATION_FAILED",   "An error occurred during creation of a session." } },
    //{ 0x80552C42,{ "SCE_TOOLKIT_NP_ERROR_MATCHING_CALLBACK_FAILURE",  "An error occurred because there an internal failure during processing of a request." } },
    //{ 0x80552C43,{ "SCE_TOOLKIT_NP_ERROR_MATCHING_SERVICE_BUSY",  "An error occurred because the previous operation requested by the application was still being processed." } },
    //{ 0x80552C44,{ "SCE_TOOLKIT_NP_ERROR_MATCHING_SESSION_ALREADY_ACTIVE",    "An error occurred because a session can be created or joined when the user is already in a session." } },
    //{ 0x80552C45,{ "SCE_TOOLKIT_NP_ERROR_MATCHING_INVALID_PARAMETERS",    "An error occurred because invalid parameters were passed in when registering session attributes." } },
    //{ 0x80552C46,{ "SCE_TOOLKIT_NP_ERROR_MATCHING_INVALID_SEARCH_CRITERIA",   "An error occurred because invalid search criteria were passed in." } },
    //{ 0x80552C47,{ "SCE_TOOLKIT_NP_ERROR_MATCHING_SEARCH_FAILED", "An error occurred while searching for a session" } },
    //{ 0x80552C48,{ "SCE_TOOLKIT_NP_ERROR_MATCHING_INVALID_JOIN_DESCRIPTOR",   "An error occurred because the join descriptor parameters are invalid." } },
    //{ 0x80552C49,{ "SCE_TOOLKIT_NP_ERROR_MATCHING_JOIN_FAILED",   "An error occurred because the operation failed to join a session." } },
    //{ 0x80552C4A,{ "SCE_TOOLKIT_NP_ERROR_MATCHING_FAIL_TO_REGISTER_ATTRIBUTES",   "An error occurred because the operation failed to register session attributes." } },
    //{ 0x80552C4B,{ "SCE_TOOLKIT_NP_ERROR_MATCHING_INVALID_ROOM_ID",   "An error occurred because an invalid room ID was passed in." } },
    //{ 0x80552C4C,{ "SCE_TOOLKIT_NP_ERROR_MATCHING_LEAVING_FAILED",    "An error occurred because the operation failed to leave a session." } },
    //{ 0x80552C4D,{ "SCE_TOOLKIT_NP_ERROR_MATCHING_NO_SESSION_TO_JOIN",    "An error occurred because there was no session to join." } },
    //{ 0x80552C4E,{ "SCE_TOOLKIT_NP_ERROR_SESSION_ATTRIBUTE_NOT_REGISTERED",   "An error occurred because the session attribute are not registered." } },
    //{ 0x80552C4F,{ "SCE_TOOLKIT_NP_ERROR_INVALID_NUM_SESSION_ATTRIBUTES", "An error occurred because there was an invalid number of session attributes. The maximum is 64." } },
    //{ 0x80552C50,{ "SCE_TOOLKIT_NP_ERROR_MATCHING_SESSION_DOES_NOT_EXIST",    "An error occurred because the session does not exist." } },
    //{ 0x80552C51,{ "SCE_TOOLKIT_NP_ERROR_MATCHING_SESSION_ROOM_DESTROYED",    "An error occurred because the session has been destroyed." } },
    //{ 0x80552C52,{ "SCE_TOOLKIT_NP_ERROR_MATCHING_SESSION_KICKEDOUT", "An error occurred because the user has been kicked out of the current session." } },
    //{ 0x80552C53,{ "SCE_TOOLKIT_NP_ERROR_MATCHING_SESSION_UPDATE_FAILED", "An error occurred because the operation failed to update the current session." } },
    //{ 0x80552C54,{ "SCE_TOOLKIT_NP_ERROR_MATCHING_INVALID_MODIFY_ATTRIBUTES", "An error occurred because the operation failed to modify the current session attributes." } },
    //{ 0x80552C55,{ "SCE_TOOLKIT_NP_ERROR_MATCHING_NO_SESSION_ACTIVE", "An error occurred because the operation failed to modify the current session as the session you trying to update is not active." } },
    //{ 0x80552C56,{ "SCE_TOOLKIT_NP_ERROR_MATCHING_ATTRIBUTES_ALREADY_REGISTERED", "An error occurred because the session attributes where already registered." } },
    //{ 0x80552C57,{ "SCE_TOOLKIT_NP_ERROR_MATCHING_INVALID_ROOM_MESSAGE",  "An error occurred because the wrong message flag was specified." } },
    //{ 0x80552C58,{ "SCE_TOOLKIT_NP_ERROR_MATCHING_INVALID_SLOTS_INFORMATION", "An error occurred because the wrong combination of slots information was provided for the session." } },
    //{ 0x80552C60,{ "SCE_TOOLKIT_NP_ERROR_TSS_NO_DATA",    "An error occurred because there was no data on the TSS server." } },
    //{ 0x80552C61,{ "SCE_TOOLKIT_NP_ERROR_TSS_BUFFER_TOO_SMALL",   "An error occurred because the buffer passed in was too small." } },
    //{ 0x80552C62,{ "SCE_TOOLKIT_NP_ERROR_TUS_NO_VARS",    "An error occurred because an invalid parameter which contained no variables was passed into a function." } },
    //{ 0x80552C63,{ "SCE_TOOLKIT_NP_ERROR_TUS_NO_DATA",    "An error occurred because there was no data on the TUS server." } },
    //{ 0x80552C64,{ "SCE_TOOLKIT_NP_ERROR_AUTH_NO_VALID_CACHED_TICKET",    "An error occurred because there was no valid cached ticket." } },
    //{ 0x80552C65,{ "SCE_TOOLKIT_NP_ERROR_AUTH_CLIENT_ID_NOT_SET", "An error occurred because there was no valid cached ticket." } },
    //{ 0x80552C66,{ "SCE_TOOLKIT_NP_ERROR_USER_PROFILE_INFORMATION_NOT_CACHED",    "< An error occurred because the user profile information was not cached." } },
    //{ 0x80552C67,{ "SCE_TOOLKIT_NP_ERROR_WEBAPI_HTTP_ERROR_NULL_VALUE",   "An error occurred because the WebAPI request had a <c>NULL</c> value." } },
    //{ 0x80552C70,{ "SCE_TOOLKIT_NP_ERROR_WEBAPI_HTTP_INVALID_REQUEST_BODY",   "An error occurred because the body of the request was invalid." } },
    //{ 0x80552C71,{ "SCE_TOOLKIT_NP_ERROR_WEBAPI_HTTP_INVALID_QUERY_STRING",   "An error occurred because the query string was invalid." } },
    //{ 0x80552C72,{ "SCE_TOOLKIT_NP_ERROR_WEBAPI_HTTP_INVALID_ENVIRONMENT",    "An error occurred because the NP environment name is invalid." } },
    //{ 0x80552C73,{ "SCE_TOOLKIT_NP_ERROR_WEBAPI_HTTP_LARGE_BODY", "An error occurred because the request body was too long." } },
    //{ 0x80552C74,{ "SCE_TOOLKIT_NP_ERROR_WEBAPI_HTTP_UNSUPPORTED_API",    "An error occurred because the API is unsupported." } },
    //{ 0x80552C75,{ "SCE_TOOLKIT_NP_ERROR_WEBAPI_HTTP_INVALID_ONLINE_ID",  "An error occurred because the Online ID was invalid." } },
    //{ 0x80552C76,{ "SCE_TOOLKIT_NP_ERROR_WEBAPI_HTTP_ACCESS_DENIED_RESOURCE", "An error occurred because access to a resource was attempted by a non-owner." } },
    //{ 0x80552C77,{ "SCE_TOOLKIT_NP_ERROR_WEBAPI_HTTP_INVALID_FIELDS_PARAM",   "An error occurred because a query string value is invalid." } },
    //{ 0x80552C78,{ "SCE_TOOLKIT_NP_ERROR_WEBAPI_HTTP_BAD_REQUEST",    "An error occurred because an invalid value was included in the request." } },
    //{ 0x80552C79,{ "SCE_TOOLKIT_NP_ERROR_WEBAPI_HTTP_INVALID_PARAM_COMBINATION",  "An error occurred because the query value in the query string was invalid." } },
    //{ 0x80552C7A,{ "SCE_TOOLKIT_NP_ERROR_WEBAPI_HTTP_INVALID_PLATFORM",   "An error occurred because the platform was invalid." } },
    //{ 0x80552C7B,{ "SCE_TOOLKIT_NP_ERROR_WEBAPI_HTTP_NO_SUCH_USER",   "An error occurred because the target user does not exist." } },
    //{ 0x80552C7C,{ "SCE_TOOLKIT_NP_ERROR_WEBAPI_HTTP_RESOURCE_NOT_FOUND", "An error occurred because the resource could not be found." } },
    //{ 0x80552C7D,{ "SCE_TOOLKIT_NP_ERROR_WEBAPI_HTTP_INVALID_ACCESS_TOKEN",   "An error occurred because the access token was invalid." } },
    //{ 0x80552C7E,{ "SCE_TOOLKIT_NP_ERROR_WEBAPI_HTTP_NOT_AUTHORISED", "An error occurred because the request was not authorised." } },
    //{ 0x80552C7F,{ "SCE_TOOLKIT_NP_ERROR_WEBAPI_HTTP_TITLE_MISMATCH", "An error occurred because the titles do not match." } },
    //{ 0x80552C80,{ "SCE_TOOLKIT_NP_ERROR_WEBAPI_HTTP_ACCESS_DENIED_PRIVACY",  "An error occurred because the access was denied." } },
    //{ 0x80552C81,{ "SCE_TOOLKIT_NP_ERROR_WEBAPI_HTTP_EXCEEDED_RATE_LIMIT",    "An error occurred because the API rate limit was exceeded." } },
    //{ 0x80552C82,{ "SCE_TOOLKIT_NP_ERROR_WEBAPI_HTTP_NOT_AUTHORISED_TITLE",   "An error occurred because the title cannot be used for this service." } },
    //{ 0x80552C83,{ "SCE_TOOLKIT_NP_ERROR_WEBAPI_HTTP_INTERNAL_SERVER",    "An error occurred because an internal server error occurred." } },
    //{ 0x80552C84,{ "SCE_TOOLKIT_NP_ERROR_WEBAPI_HTTP_SERVER_BUSY",    "An error occurred because the server is overloaded." } },
    //{ 0x80552C85,{ "SCE_TOOLKIT_NP_ERROR_WEBAPI_HTTP_UNDER_MAINTENANCE",  "An error occurred because the server is undergoing maintenance." } },
    //{ 0x80552C86,{ "SCE_TOOLKIT_NP_ERROR_WEBAPI_HTTP_SERVICE_CLOSED", "An error occurred because the service has been temporarily suspended." } },
    //{ 0x80552C87,{ "SCE_TOOLKIT_NP_ERROR_WEBAPI_HTTP_UNEXPECTED", "An error occurred because an unexpected error occurred." } },
    //{ 0x80552C88,{ "SCE_TOOLKIT_NP_ERROR_WEBAPI_HTTP_EXPIRED_ACCESS_TOKEN",   "An error occurred because the access token has expired." } },
    //{ 0x80552C89,{ "SCE_TOOLKIT_NP_ERROR_WEBAPI_HTTP_INVALID_LIMIT_PARAM",    "An error occurred because the limit parameter was invalid." } },
    //{ 0x80552C8A,{ "SCE_TOOLKIT_NP_ERROR_WEBAPI_HTTP_INVALID_OFFSET_PARAM",   "An error occurred because the offset parameter was invalid." } },
    //{ 0x80552C8B,{ "SCE_TOOLKIT_NP_ERROR_WEBAPI_HTTP_NOT_ALLOWED_OFFLINE",    "An error occurred because the operation is not allowed offline." } },
    //{ 0x80552C8C,{ "SCE_TOOLKIT_NP_ERROR_WEBAPI_HTTP_INVALID_ORDERBY_PARAM",  "An error occurred because the orderby parameter was invalid." } },
    //{ 0x80552C8D,{ "SCE_TOOLKIT_NP_ERROR_WEBAPI_HTTP_INVALID_SESSION_PLATFORM",   "An error occurred because the session target platform was invalid." } },
    //{ 0x80552C8E,{ "SCE_TOOLKIT_NP_ERROR_WEBAPI_HTTP_INVALID_SESSION_IMAGE",  "An error occurred because the session image was invalid." } },
    //{ 0x80552C8F,{ "SCE_TOOLKIT_NP_ERROR_WEBAPI_HTTP_INVALID_SESSION_DATA",   "An error occurred because the session data was invalid." } },
    //{ 0x80552C90,{ "SCE_TOOLKIT_NP_ERROR_WEBAPI_HTTP_NOT_PERMITTED_SESSION_ACCESS",   "An error occurred because the session access was not permitted." } },
    //{ 0x80552C91,{ "SCE_TOOLKIT_NP_ERROR_WEBAPI_HTTP_SESSION_FULL",   "An error occurred because the session was full." } },
    //{ 0x80552C92,{ "SCE_TOOLKIT_NP_ERROR_WEBAPI_HTTP_SESSION_DATA_REQUIRED",  "An error occurred because the session data was not supplied." } },
    //{ 0x80552C93,{ "SCE_TOOLKIT_NP_ERROR_WEBAPI_HTTP_SESSION_IMAGE_REQUIRED", "An error occurred because the session image was not supplied." } },
    //{ 0x80552C94,{ "SCE_TOOLKIT_NP_ERROR_WEBAPI_HTTP_INVALID_SESSION_TYPE",   "An error occurred because the session type was invalid." } },
    //{ 0x80552C95,{ "SCE_TOOLKIT_NP_ERROR_WEBAPI_HTTP_INVALID_SESSION_PRIVACY",    "An error occurred because the session privacy value was invalid." } },
    //{ 0x80552C96,{ "SCE_TOOLKIT_NP_ERROR_WEBAPI_HTTP_INVALID_SESSION_MAX_USER",   "An error occurred because the session max user value was invalid." } },
    //{ 0x80552C97,{ "SCE_TOOLKIT_NP_ERROR_WEBAPI_HTTP_INVALID_SESSION_NAME",   "An error occurred because the session name was invalid." } },
    //{ 0x80552C98,{ "SCE_TOOLKIT_NP_ERROR_WEBAPI_HTTP_INVALID_SESSION_STATUS", "An error occurred because the session status was invalid." } },
    //{ 0x80552C99,{ "SCE_TOOLKIT_NP_ERROR_WEBAPI_HTTP_SESSION_ONLY_MEMBER_PERMITTED",  "An error occurred because only session members are permitted to perform this operation." } },
    //{ 0x80552C9A,{ "SCE_TOOLKIT_NP_ERROR_WEBAPI_HTTP_SESSION_ONLY_CREATOR_PERMITTED", "An error occurred because only the session creator is permitted to perform this operation." } },
    //{ 0x80552C9B,{ "SCE_TOOLKIT_NP_ERROR_WEBAPI_HTTP_PROFILE_INVALID_AVATAR_SIZE",    "An error occurred because the avatar size was invalid." } },
    //{ 0x80552C9C,{ "SCE_TOOLKIT_NP_ERROR_WEBAPI_HTTP_FRIEND_INVALID_STATUS",  "An error occurred because the friend status was invalid." } },
    //{ 0x80552C9D,{ "SCE_TOOLKIT_NP_ERROR_WEBAPI_HTTP_PRESENCE_INVALID_PLATFORM",  "An error occurred because the presence platform was invalid." } },
    //{ 0x80552C9E,{ "SCE_TOOLKIT_NP_ERROR_WEBAPI_HTTP_PRESENCE_INVALID_TYPE",  "An error occurred because the presence type was invalid." } },
    //{ 0x80552CA0,{ "SCE_TOOLKIT_NP_ERROR_WEBAPI_HTTP_PRESENCE_NON_FRIEND_ACCESS", "An error occurred because access was attempted by a non-owner or non-friend." } },
    //{ 0x80552CA1,{ "SCE_TOOLKIT_NP_ERROR_WEBAPI_HTTP_PRESENCE_TOO_LONG_STATUS",   "An error occurred because the presence status was too long." } },
    //{ 0x80552CA2,{ "SCE_TOOLKIT_NP_ERROR_WEBAPI_HTTP_PRESENCE_TOO_LONG_DATA", "An error occurred because the presence data was too long." } },
    //{ 0x80552CA3,{ "SCE_TOOLKIT_NP_ERROR_WEBAPI_HTTP_PRESENCE_INVALID_TITLE_ID",  "An error occurred because the presence Title ID was too long." } },
    //{ 0x80552CA4,{ "SCE_TOOLKIT_NP_ERROR_WEBAPI_HTTP_PRESENCE_INVALID_COMMS_ID",  "An error occurred because the presence Communication ID was too long." } },
    //{ 0x80552CA5,{ "SCE_TOOLKIT_NP_ERROR_WEBAPI_HTTP_BASEURL_INVALID_API_GROUP",  "An error occurred because the base URL API group was invalid." } },
    //{ 0x80552CA6,{ "SCE_TOOLKIT_NP_ERROR_WEBAPI_HTTP_BASEURL_UNKNOWN_CLIENT_ID",  "An error occurred because the base URL Client ID was unknown." } },
    //{ 0x80552CA7,{ "SCE_TOOLKIT_NP_ERROR_WEBAPI_HTTP_RESPONSE",   "An error occurred because an HTTP error response was received." } },
    //{ 0x80552CA8,{ "SCE_TOOLKIT_NP_ERROR_WEBAPI_HTTP_INVALID_FILTER_PARAM",   "An error occurred because there was an invalid filter parameter." } },
    //{ 0x80552CAA,{ "SCE_TOOLKIT_NP_ERROR_WEBAPI_HTTP_GAME_CUSTOM_DATA_EXPIRED",   "An error occurred because there was an invalid filter parameter." } },
    //{ 0x80552CAB,{ "SCE_TOOLKIT_NP_ERROR_WEBAPI_HTTP_GAME_CUSTOM_DATA_ALREADY_USED",  "An error occurred because there was an invalid filter parameter." } },
    //{ 0x80552CD0,{ "SCE_TOOLKIT_NP_ERROR_INFORMATION_NOT_CACHED", "An error occurred because the user profile information was not cached." } },
    //{ 0x80552CD1,{ "SCE_TOOLKIT_NP_ERROR_INFORMATION_CACHE_NOT_IMPL", "An error occurred because user profile information was not cached." } },
    //{ 0x80552CD2,{ "SCE_TOOLKIT_NP_ERROR_TROPHY_NOT_INITIALISED", "An error occurred because the trophy service has not been initialized." } },
    //{ 0x80552CD3,{ "SCE_TOOLKIT_NP_ERROR_TROPHY_NOT_REGISTERED",  "An error occurred because the trophy set file has not been registered." } },
    //{ 0x80552CD4,{ "SCE_TOOLKIT_NP_ERROR_TROPHY_ABORT_FAIL",  "An error occurred because an attempt to abort a trophy registration failed." } },
    //{ 0x80552CD5,{ "SCE_TOOLKIT_NP_ERROR_TROPHY_BUSY",    "An error occurred because the trophy service is processing a long request." } },
    //{ 0x80552CD6,{ "SCE_TOOLKIT_NP_ERROR_TROPHY_ALREADY_REGISTERED",  "An error occurred because the trophy sets are already registered." } },
    //{ 0x80552CD7,{ "SCE_TOOLKIT_NP_ERROR_TROPHY_NOT_TERMINATED",  "An error occurred because the trophy service is not terminated." } },
    //{ 0x80552CD8,{ "SCE_TOOLKIT_NP_ERROR_TROPHY_UPDATE_ERROR",    "An error occurred because the trophy list cache cannot be updated." } },
    //{ 0x80552CD9,{ "SCE_TOOLKIT_NP_ERROR_TROPHY_REGISTERING", "An error occurred because an attempt to register another trophy is still processing." } },
    //{ 0x80552CDA,{ "SCE_TOOLKIT_NP_ERROR_TROPHY_SETUP_DIALOG_ALREADY_RUNNING",    "An error occurred because an attempt was made invoke more than one setup dialog at the same time." } },
    //{ 0x80552CDB,{ "SCE_TOOLKIT_NP_ERROR_TROPHY_ALREADY_INITIALISED", "An error occurred because the trophy service is already initialized." } },
    //{ 0x80552CDC,{ "SCE_TOOLKIT_NP_ERROR_TROPHY_NOT_ENOUGH_SPACE",    "An error occurred because there is not enough space to install the trophy set." } },
    //{ 0x80552CDD,{ "SCE_TOOLKIT_NP_ERROR_MESSAGE_ATTACHMENT_INVALID", "An error occurred because the attachment is invalid." } },
    //{ 0x80552CDE,{ "SCE_TOOLKIT_NP_ERROR_MESSAGE_TYPE_INVALID",   "An error occurred because the message type is invalid." } },
    //{ 0x80552CDF,{ "SCE_TOOLKIT_NP_ERROR_MESSAGE_SERVICE_BUSY",   "An error occurred because the messaging service is processing a previous request." } },
    //{ 0x80552CE0,{ "SCE_TOOLKIT_NP_ERROR_MESSAGE_ARGUMENTS_INVALID",  "An error occurred because invalid arguments were passed." } },
    //{ 0x80552CE1,{ "SCE_TOOLKIT_NP_ERROR_COMMERCE_NO_PRODUCTS",   "There are no products available for this user on the Store." } },
    //{ 0x80552CE2,{ "SCE_TOOLKIT_NP_ERROR_WORD_FILTER_SLOT_FULL",  "An error occurred because more than 32 requests have been made to the word filter service." } },
    //{ 0x80552CE3,{ "SCE_TOOLKIT_NP_ERROR_WORD_FILTER_REQUEST_ABORTED",    "An error occurred because the word filter request has been aborted." } },
    //{ 0x80552CE4,{ "SCE_TOOLKIT_NP_ERROR_SNS_ACCESS_TOKEN_ERROR", "An error occurred while retrieving an access token from Facebook(R)." } },
    //{ 0x80552CE5,{ "SCE_TOOLKIT_NP_ERROR_SNS_INVALID_MESSAGE",    "An error occurred because the contents of a Facebook(R) message were invalid." } },
    //{ 0x80552CE6,{ "SCE_TOOLKIT_NP_ERROR_SNS_MESSAGE_POST_FAILED",    "An error occurred because an attempt to post a message to Facebook(R) failed." } },
    //{ 0x80552CE7,{ "SCE_TOOLKIT_NP_ERROR_ABORT_FAILED_TO_FIND_REQUEST",   "Failed to find request to abort." } },
    //{ 0x80552CE8,{ "SCE_TOOLKIT_NP_ERROR_ABORT_FAILED_TO_ADD_ABORT_REQ",  "Failed to add abort request to list." } },
    //{ 0x80552CE9,{ "SCE_TOOLKIT_NP_ERROR_LOCK_ERROR_ALREADY_OWNED",   "The lock is already owned by another thread." } },
    //{ 0x80552CEA,{ "SCE_TOOLKIT_NP_ERROR_METHOD_DOES_EXIST",  "A generic ToolkitNp library error." } },
    //{ 0x80552CEB,{ "SCE_TOOLKIT_NP_ERROR_LOCK_ERRORS",    "General Locking Errors. Hopefully platform generic." } },
    //{ 0x80552CEC,{ "SCE_TOOLKIT_NP_ERROR_LOCK_ERROR_TIMEOUT", "A lock timed out. Locks are indefinite currently so this should not happen." } },
    //{ 0x80552CED,{ "SCE_TOOLKIT_NP_ERROR_LOCK_ERROR_UNKNOWN", "Other Errors" } },
    //{ 0x80552CEE,{ "SCE_TOOLKIT_NP_ERROR_LOCK_ERROR_OUT_OF_IDS",  "No more Lock Ids could be allocated." } },
    //{ 0x80552CEF,{ "SCE_TOOLKIT_NP_ERROR_LOCK_ERROR_COND_EXISTS", "A condition variable still exists related to this Mutex." } },
    //{ 0x80552CF0,{ "SCE_TOOLKIT_NP_ERROR_LOCK_ERROR_NOT_RECURSIVE",   "Can not recursively own Mutexes." } },
    //{ 0x80552CF1,{ "SCE_TOOLKIT_NP_ERROR_LOCK_ERROR_ID_INVALID",  "An Id for a mutex has become invalid somehow." } },
    //{ 0x80552CF2,{ "SCE_TOOLKIT_NP_ERROR_FUTURE_RESET",   "An error indicating that this future has been reset." } },
    //{ 0x80552CF3,{ "SCE_TOOLKIT_NP_ERROR_CHALLENGES_NOT_A_CHALLENGE", "An error occurred because the requested item is not a challenge." } },
    //{ 0x80552CF4,{ "SCE_TOOLKIT_NP_ERROR_CUSTOM_STL_ALLOCATOR_NOT_IMPLEMENTED",   "An error occurred because Custom STL Allocator was not provided." } },
    //{ 0x80552D01,{ "SCE_NP_SNS_YOUTUBE_ERROR_INTERNAL",   "Internal error" } },
    //{ 0x80552D02,{ "SCE_NP_SNS_YOUTUBE_ERROR_INVALID_ARGUMENT",   "Any argument is invalid" } },
    //{ 0x80552D03,{ "SCE_NP_SNS_YOUTUBE_ERROR_OUT_OF_MEMORY",  "There is not enough memory" } },
    //{ 0x80552D04,{ "SCE_NP_SNS_YOUTUBE_ERROR_EXCEEDS_MAX",    "Created more than maximum number of requests at one time." } },
    //{ 0x80552D06,{ "SCE_NP_SNS_YOUTUBE_ERROR_ABORTED",    "Operations were aborted" } },
    //{ 0x80552D07,{ "SCE_NP_SNS_YOUTUBE_ERROR_ACCOUNT_NOT_BOUND",  "The YouTube account has not been registered" } },
    //{ 0x80552D08,{ "SCE_NP_SNS_YOUTUBE_ERROR_CANCELED_BY_SYSTEM", "Communication has been forcibly canceled by the system. This occurs when an application is suspended, etc." } },
    //{ 0x80552D09,{ "SCE_NP_SNS_YOUTUBE_ERROR_SUB_ACCOUNT",    "YouTube coordination functionalities cannot be used because the account is sub-account." } },
    //{ 0x80552D0A,{ "SCE_NP_SNS_YOUTUBE_ERROR_PROMPT_FOR_PERMISSIONS", "The client must display a permissions prompt prior to requesting the access token." } },
    //{ 0x80552D0B,{ "SCE_NP_SNS_YOUTUBE_ERROR_BAD_RESPONSE",   "received invalid response from the server." } },
    //{ 0x80552D0C,{ "SCE_NP_SNS_YOUTUBE_ERROR_REFRESH_MASTER_TOKEN_WITH_CODE_FAILED",  "Error was returned for refreshing Master Token." } },
    //{ 0x80559B01,{ "SCE_NP_MANAGER_ERROR_BAD_RESPONSE",   "An error was received from the server" } },
    //{ 0x80559B05,{ "SCE_NP_MANAGER_ERROR_ACCOUNT_ID_NOT_MATCHED", "Specified account ID is not matched." } },
    //{ 0x80559E09,{ "SCE_NP_EXT_ERROR_OUT_OF_MEMORY",  "Not enough memory" } },
    //{ 0x80559E19,{ "SCE_NP_EXT_ERROR_FILE_NOT_FOUND", "File is not found." } },
    //{ 0x80559E2A,{ "SCE_NP_EXT_ERROR_USER_NOT_FOUND", "user is not found." } },
    //{ 0x80559F04,{ "SCE_NP_WEB_SOCKET_ERROR_OUT_OF_MEMORY",   "There is not enough memory" } },
    //{ 0x8055A004,{ "SCE_NP_PUSH_ERROR_OUT_OF_MEMORY", "There is not enough memory" } },
    //{ 0x8055A007,{ "SCE_NP_PUSH_ERROR_FIELD_NOT_FOUND",   "Failed to get required field from push packet." } },
    //{ 0x8055A00C,{ "SCE_NP_PUSH_ERROR_INVALID_SESSION_STATE", "push session state is invalid" } },
    //{ 0x8055A010,{ "SCE_NP_PUSH_ERROR_ABORTED",   "operation for push connection was aborted." } },
    //{ 0x8055A01A,{ "SCE_NP_PUSH_ERROR_SESSION_NOT_ESTABLISHED",   "Push session is not established." } },
    //{ 0x8055A01F,{ "SCE_NP_PUSH_ERROR_QUERY_RESPONSE_CLIENT_ERROR",   "error occured on the peer client." } },
    //{ 0x8055A029,{ "SCE_NP_PUSH_ERROR_DISCONNECTED_INVALID_MSG",  "Push connection is disconnected." } },
    //{ 0x8055A03C,{ "SCE_NP_PUSH_ERROR_DISCONNECTED_CLOSED",   "Push connection is disconnected." } },
    //{ 0x8055A03D,{ "SCE_NP_PUSH_ERROR_DISCONNECTED_CLOSED_KEEPALIVE_TIMEOUT", "Push connection is disconnected." } },
    //{ 0x8055A03E,{ "SCE_NP_PUSH_ERROR_DISCONNECTED_CLOSED_BIND_TIMEOUT",  "Push connection is disconnected." } },
    //{ 0x8055A285,{ "SCE_NP_ASM_CLIENT_ERROR_OUT_OF_MEMORY",   "Memory is not enough" } },
    //{ 0x8055A287,{ "SCE_NP_ASM_CLIENT_ERROR_ABORTED", "Communication with a server was aborted" } },
    //{ 0x8055A289,{ "SCE_NP_ASM_CLIENT_ERROR_NP_SERVICE_LAVEL_NOT_MATCH",  "Specified NP service label does not match" } },
    //{ 0x8055A28A,{ "SCE_NP_ASM_CLIENT_ERROR_NP_TITLE_ID_NOT_SET", "NP Title ID is not set" } },
    //{ 0x80590001,{ "SCE_FIBER_ERROR_NULL",    "The specified pointer is NULL." } },
    //{ 0x80590002,{ "SCE_FIBER_ERROR_ALIGNMENT",   "There is an alignment error in the specified pointer." } },
    //{ 0x80590003,{ "SCE_FIBER_ERROR_RANGE",   "The specified value is not within the accepted range." } },
    //{ 0x80590004,{ "SCE_FIBER_ERROR_INVALID", "The specified parameter is invalid." } },
    //{ 0x80590005,{ "SCE_FIBER_ERROR_PERMISSION",  "The caller is attempting to perform an unauthorized operation." } },
    //{ 0x80590006,{ "SCE_FIBER_ERROR_STATE",   "The fiber state does not allow that operation." } },
    //{ 0x805A1000,{ "SCE_SYSMODULE_ERROR_INVALID_VALUE",   "Tried to load an unknown PRX" } },
    //{ 0x805A1001,{ "SCE_SYSMODULE_ERROR_UNLOADED",    "Tried to unload a PRX that is already unloaded, or the module is not loaded" } },
    //{ 0x805A10FF,{ "SCE_SYSMODULE_ERROR_FATAL",   "Function call failed" } },
    //{ 0x805C0001,{ "SCE_CES_ERROR_INVALID_PARAMETER", "Specified argument value is invalid" } },
    //{ 0x805C0004,{ "SCE_CES_ERROR_INVALID_PROFILE",   "Specified profile is invalid" } },
    //{ 0x805C0010,{ "SCE_CES_ERROR_INVALID_SRC_BUFFER",    "Specified source buffer is invalid" } },
    //{ 0x805C0011,{ "SCE_CES_ERROR_SRC_BUFFER_END",    "Specified source buffer is insufficient" } },
    //{ 0x805C0014,{ "SCE_CES_ERROR_INVALID_ENCODE",    "Source encoding determined to be invalid" } },
    //{ 0x805C0015,{ "SCE_CES_ERROR_ILLEGAL_CODE",  "Illegal character code detected in source character code" } },
    //{ 0x805C0020,{ "SCE_CES_ERROR_UNASSIGNED_CODE",   "Code points in output destination encoding scheme are not defined" } },
    //{ 0x805C0024,{ "SCE_CES_ERROR_OUT_OF_CODE_RANGE", "Character outside the representable code range of the output destination encoding scheme is detected" } },
    //{ 0x805C0030,{ "SCE_CES_ERROR_INVALID_DST_BUFFER",    "Output destination buffer is invalid" } },
    //{ 0x805C0031,{ "SCE_CES_ERROR_DST_BUFFER_END",    "Output destination buffer is insufficient" } },
    //{ 0x80650001,{ "SCE_JPEG_DEC_ERROR_INVALID_ADDR", "Specified memory address is invalid" } },
    //{ 0x80650002,{ "SCE_JPEG_DEC_ERROR_INVALID_SIZE", "Specified memory size is invalid" } },
    //{ 0x80650003,{ "SCE_JPEG_DEC_ERROR_INVALID_PARAM",    "Specified parameter is invalid" } },
    //{ 0x80650004,{ "SCE_JPEG_DEC_ERROR_INVALID_HANDLE",   "Specified handle is invalid" } },
    //{ 0x80650005,{ "SCE_JPEG_DEC_ERROR_INVALID_COEF_MEMORY",  "Specified coefficient memory is invalid" } },
    //{ 0x80650006,{ "SCE_JPEG_DEC_ERROR_INVALID_WORK_MEMORY",  "Work memory in the decoder is invalid" } },
    //{ 0x80650010,{ "SCE_JPEG_DEC_ERROR_INVALID_DATA", "Invalid JPEG image (non-standard)" } },
    //{ 0x80650011,{ "SCE_JPEG_DEC_ERROR_UNSUPPORT_DATA",   "JPEG image is not supported by the decoder" } },
    //{ 0x80650012,{ "SCE_JPEG_DEC_ERROR_DECODE_ERROR", "Decoding error" } },
    //{ 0x80650020,{ "SCE_JPEG_DEC_ERROR_FATAL",    "Internal error" } },
    //{ 0x80650101,{ "SCE_JPEG_ENC_ERROR_INVALID_ADDR", "Specified memory address is invalid" } },
    //{ 0x80650102,{ "SCE_JPEG_ENC_ERROR_INVALID_SIZE", "Specified memory size is invalid" } },
    //{ 0x80650103,{ "SCE_JPEG_ENC_ERROR_INVALID_PARAM",    "Specified parameter is invalid" } },
    //{ 0x80650104,{ "SCE_JPEG_ENC_ERROR_INVALID_HANDLE",   "Specified handle is invalid" } },
    //{ 0x80650110,{ "SCE_JPEG_ENC_ERROR_DATA_OVERFLOW",    "Encoding was aborted due to an overflow upon outputting the JPEG image" } },
    //{ 0x80650120,{ "SCE_JPEG_ENC_ERROR_FATAL",    "Internal error" } },
    //{ 0x80690001,{ "SCE_PNG_DEC_ERROR_INVALID_ADDR",  "Specified memory address is invalid" } },
    //{ 0x80690002,{ "SCE_PNG_DEC_ERROR_INVALID_SIZE",  "Specified memory size is invalid" } },
    //{ 0x80690003,{ "SCE_PNG_DEC_ERROR_INVALID_PARAM", "Specified parameter is invalid" } },
    //{ 0x80690004,{ "SCE_PNG_DEC_ERROR_INVALID_HANDLE",    "Specified handle is invalid" } },
    //{ 0x80690005,{ "SCE_PNG_DEC_ERROR_INVALID_WORK_MEMORY",   "Work memory in the decoder is invalid" } },
    //{ 0x80690010,{ "SCE_PNG_DEC_ERROR_INVALID_DATA",  "Invalid PNG image (non-standard)" } },
    //{ 0x80690011,{ "SCE_PNG_DEC_ERROR_UNSUPPORT_DATA",    "PNG image is not supported by the decoder" } },
    //{ 0x80690012,{ "SCE_PNG_DEC_ERROR_DECODE_ERROR",  "Decoding error" } },
    //{ 0x80690020,{ "SCE_PNG_DEC_ERROR_FATAL", "Internal error" } },
    //{ 0x80690101,{ "SCE_PNG_ENC_ERROR_INVALID_ADDR",  "Specified memory address is invalid" } },
    //{ 0x80690102,{ "SCE_PNG_ENC_ERROR_INVALID_SIZE",  "Specified memory size is invalid" } },
    //{ 0x80690103,{ "SCE_PNG_ENC_ERROR_INVALID_PARAM", "Specified parameter is invalid" } },
    //{ 0x80690104,{ "SCE_PNG_ENC_ERROR_INVALID_HANDLE",    "Specified handle is invalid" } },
    //{ 0x80690110,{ "SCE_PNG_ENC_ERROR_DATA_OVERFLOW", "Encoding was aborted due to an overflow upon outputting the PNG image" } },
    //{ 0x80690120,{ "SCE_PNG_ENC_ERROR_FATAL", "Internal error" } },
    //{ 0x806A0001,{ "SCE_AVPLAYER_ERROR_INVALID_PARAMS",   "invalid parameter specified" } },
    //{ 0x806A0002,{ "SCE_AVPLAYER_ERROR_OPERATION_FAILED", "the requested operation has failed" } },
    //{ 0x806A0003,{ "SCE_AVPLAYER_ERROR_NO_MEMORY",    "memory allocation has failed" } },
    //{ 0x806A0004,{ "SCE_AVPLAYER_ERROR_NOT_SUPPORTED",    "requested operation is not supported" } },
    //{ 0x806A00A0,{ "SCE_AVPLAYER_ERROR_WAR_FILE_NONINTERLEAVED",  "event notification that the file is non-interleaved" } },
    //{ 0x806A00A1,{ "SCE_AVPLAYER_ERROR_WAR_LOOPING_BACK", "event notification that the stream is looping back" } },
    //{ 0x806A00A3,{ "SCE_AVPLAYER_ERROR_WAR_JUMP_COMPLETE",    "event notification that the jump was completed" } },
    //{ 0x806A00B0,{ "SCE_AVPLAYER_ERROR_INFO_MARLIN_ENCRY",    "event notification of stream encrypted using Marlin" } },
    //{ 0x806A00B4,{ "SCE_AVPLAYER_ERROR_INFO_PLAYREADY_ENCRY", "event notification of stream encrypted using PlayReady" } },
    //{ 0x806A00B5,{ "SCE_AVPLAYER_ERROR_INFO_AES_ENCRY",   "event notification of stream encrypted using AES" } },
    //{ 0x806A00BF,{ "SCE_AVPLAYER_ERROR_INFO_OTHER_ENCRY", "event notification of stream encrypted using other encryption technology" } },
    //{ 0x80770001,{ "SCE_RUDP_ERROR_NOT_INITIALIZED",  "Library was not initialized" } },
    //{ 0x80770002,{ "SCE_RUDP_ERROR_ALREADY_INITIALIZED",  "Library has already been initialized" } },
    //{ 0x80770003,{ "SCE_RUDP_ERROR_INVALID_CONTEXT_ID",   "Context ID is invalid" } },
    //{ 0x80770004,{ "SCE_RUDP_ERROR_INVALID_ARGUMENT", "Any argument is invalid" } },
    //{ 0x80770005,{ "SCE_RUDP_ERROR_INVALID_OPTION",   "Option argument is invalid" } },
    //{ 0x80770006,{ "SCE_RUDP_ERROR_INVALID_MUXMODE",  "Mux mode argument is invalid" } },
    //{ 0x80770007,{ "SCE_RUDP_ERROR_MEMORY",   "There is not enough memory" } },
    //{ 0x80770008,{ "SCE_RUDP_ERROR_INTERNAL", "Internal RUDP error" } },
    //{ 0x80770009,{ "SCE_RUDP_ERROR_CONN_RESET",   "RUDP connection was reset" } },
    //{ 0x8077000A,{ "SCE_RUDP_ERROR_CONN_REFUSED", "A connection request arrives but the pending connection queue is full" } },
    //{ 0x8077000B,{ "SCE_RUDP_ERROR_CONN_TIMEOUT", "Timeout occurred before connection establishment" } },
    //{ 0x8077000C,{ "SCE_RUDP_ERROR_CONN_VERSION_MISMATCH",    "Rudp protocol version is different between the peers" } },
    //{ 0x8077000D,{ "SCE_RUDP_ERROR_CONN_TRANSPORT_TYPE_MISMATCH", "Transport type is different between the peers" } },
    //{ 0x8077000E,{ "SCE_RUDP_ERROR_CONN_QUALITY_LEVEL_MISMATCH",  "Packet with a different quality level was received" } },
    //{ 0x8077000F,{ "SCE_RUDP_ERROR_THREAD",   "Thread related error occurred" } },
    //{ 0x80770010,{ "SCE_RUDP_ERROR_THREAD_IN_USE",    "Internal I/O thread already in use" } },
    //{ 0x80770011,{ "SCE_RUDP_ERROR_NOT_ACCEPTABLE",   "Operation not acceptable" } },
    //{ 0x80770012,{ "SCE_RUDP_ERROR_MSG_TOO_LARGE",    "Message too large to be sent on this context" } },
    //{ 0x80770013,{ "SCE_RUDP_ERROR_NOT_BOUND",    "The context has not been bound yet" } },
    //{ 0x80770014,{ "SCE_RUDP_ERROR_CANCELLED",    "Blocking operation cancelled" } },
    //{ 0x80770015,{ "SCE_RUDP_ERROR_INVALID_VPORT",    "Invalid vport was used in sceRudpBind" } },
    //{ 0x80770016,{ "SCE_RUDP_ERROR_WOULDBLOCK",   "Blocking operation timed out" } },
    //{ 0x80770017,{ "SCE_RUDP_ERROR_VPORT_IN_USE", "An already used vport was used in sceRudpBind" } },
    //{ 0x80770018,{ "SCE_RUDP_ERROR_VPORT_EXHAUSTED",  "Internal vport resources are exhausted" } },
    //{ 0x80770019,{ "SCE_RUDP_ERROR_INVALID_SOCKET",   "Socket related error" } },
    //{ 0x8077001A,{ "SCE_RUDP_ERROR_BUFFER_TOO_SMALL", "Buffer too small" } },
    //{ 0x8077001B,{ "SCE_RUDP_ERROR_MSG_MALFORMED",    "Received data is not an RUDP packet or is corrupted" } },
    //{ 0x8077001C,{ "SCE_RUDP_ERROR_ADDR_IN_USE",  "There is another context that has the same socket connected to the same remote address" } },
    //{ 0x8077001D,{ "SCE_RUDP_ERROR_ALREADY_BOUND",    "Socket is already bound" } },
    //{ 0x8077001E,{ "SCE_RUDP_ERROR_ALREADY_EXISTS",   "Polling for this context already exists" } },
    //{ 0x8077001F,{ "SCE_RUDP_ERROR_INVALID_POLL_ID",  "Poll ID is invalid" } },
    //{ 0x80770020,{ "SCE_RUDP_ERROR_TOO_MANY_CONTEXTS",    "Too many contexts" } },
    //{ 0x80770021,{ "SCE_RUDP_ERROR_IN_PROGRESS",  "Operation is in progress" } },
    //{ 0x80770022,{ "SCE_RUDP_ERROR_NO_EVENT_HANDLER", "Common event handler has not been registered" } },
    //{ 0x80770023,{ "SCE_RUDP_ERROR_PAYLOAD_TOO_LARGE",    "Payload is too large when setting SCE_RUDP_OPTION_MAX_PAYLOAD option" } },
    //{ 0x80770024,{ "SCE_RUDP_ERROR_END_OF_DATA",  "No more data to read from the peer" } },
    //{ 0x80770025,{ "SCE_RUDP_ERROR_ALREADY_ESTABLISHED",  "Connection is already established between the peers" } },
    //{ 0x80770026,{ "SCE_RUDP_ERROR_KEEP_ALIVE_FAILURE",   "Connection was closed due to keep-alive timeout" } },
    //{ 0x807700FF,{ "SCE_RUDP_ERROR_MEMLEAK",  "Rudp didn't free all of its allocated memory" } },
    //{ 0x807F0000,{ "SCE_AUDIODEC_ERROR_API_FAIL", "internal error" } },
    //{ 0x807F0001,{ "SCE_AUDIODEC_ERROR_INVALID_TYPE", "Specified codec type is invalid" } },
    //{ 0x807F0002,{ "SCE_AUDIODEC_ERROR_ARG",  "Specified argument is invalid" } },
    //{ 0x807F0003,{ "SCE_AUDIODEC_ERROR_INVALID_SIZE", "size of structure is invalid" } },
    //{ 0x807F0004,{ "SCE_AUDIODEC_ERROR_INVALID_PARAM_SIZE",   "size of SceAudiodecParam*** structure is invalid" } },
    //{ 0x807F0005,{ "SCE_AUDIODEC_ERROR_INVALID_BSI_INFO_SIZE",    "size of SceAudiodec***Info structure is invalid" } },
    //{ 0x807F0006,{ "SCE_AUDIODEC_ERROR_INVALID_AU_INFO_SIZE", "size of SceAudiodecAuInfo structure is invalid" } },
    //{ 0x807F0007,{ "SCE_AUDIODEC_ERROR_INVALID_PCM_ITEM_SIZE",    "size of SceAudiodecPcmItem structure is invalid" } },
    //{ 0x807F0008,{ "SCE_AUDIODEC_ERROR_INVALID_CTRL_POINTER", "Specified invalid pointer of SceAudiodecCtrl" } },
    //{ 0x807F0009,{ "SCE_AUDIODEC_ERROR_INVALID_PARAM_POINTER",    "Specified invalid pointer of pParam" } },
    //{ 0x807F000A,{ "SCE_AUDIODEC_ERROR_INVALID_BSI_INFO_POINTER", "Specified invalid pointer of pBsiInfo" } },
    //{ 0x807F000B,{ "SCE_AUDIODEC_ERROR_INVALID_AU_INFO_POINTER",  "Specified invalid pointer of pAuInfo" } },
    //{ 0x807F000C,{ "SCE_AUDIODEC_ERROR_INVALID_PCM_ITEM_POINTER", "Specified invalid pointer of pPcmItem" } },
    //{ 0x807F000D,{ "SCE_AUDIODEC_ERROR_INVALID_AU_POINTER",   "Specified invalid pAuAddr" } },
    //{ 0x807F000E,{ "SCE_AUDIODEC_ERROR_INVALID_PCM_POINTER",  "Specified invalid pPcmAddr" } },
    //{ 0x807F000F,{ "SCE_AUDIODEC_ERROR_INVALID_HANDLE",   "Specified invalid handle" } },
    //{ 0x807F0010,{ "SCE_AUDIODEC_ERROR_INVALID_WORD_LENGTH",  "Specified invalid word length" } },
    //{ 0x807F0011,{ "SCE_AUDIODEC_ERROR_INVALID_AU_SIZE",  "Specified invalid uiAuSize" } },
    //{ 0x807F0012,{ "SCE_AUDIODEC_ERROR_INVALID_PCM_SIZE", "Specified invalid uiPcmSize" } },
    //{ 0x807F0300,{ "SCE_AUDIODEC_ERROR_M4AAC_INVALID_SAMPLING_FREQ",  "Specified invalid raw data output sampling frequency of MPEG4-AAC" } },
    //{ 0x807F0302,{ "SCE_AUDIODEC_ERROR_M4AAC_INVALID_ENABLE_HEAAC",   "Specified invalid HE-AAC decoding flag of MPEG4-AAC" } },
    //{ 0x807F0303,{ "SCE_AUDIODEC_ERROR_M4AAC_INVALID_CONFIG_NUMBER",  "Specified invalid header type of MPEG4-AAC" } },
    //{ 0x807F0304,{ "SCE_AUDIODEC_ERROR_M4AAC_INVALID_MAX_CHANNELS",   "Specified invalid maximum number of channels of MPEG4-AAC" } },
    //{ 0x807F0305,{ "SCE_AUDIODEC_ERROR_M4AAC_INVALID_ENABLE_NONDELAY_OUTPUT", "Specified invalid nondelay PCM output flag of MPEG4-AAC" } },
    //{ 0x807F0306,{ "SCE_AUDIODEC_ERROR_M4AAC_INVALID_SURROUND_CHANNEL_INTERLEAVE_ORDER",  "Specified invalid PCM output channel order mode of MPEG4-AAC" } },
    //{ 0x807F0400,{ "SCE_AUDIODEC_ERROR_AC3_INVALID_KARAOKE_CAPABLE_REPRODUCTION_MODE",    "Specified invalid karaoke capable reproduction mode of Dolby(TM) Digital" } },
    //{ 0x807F0401,{ "SCE_AUDIODEC_ERROR_AC3_INVALID_DYNAMIC_RANGE_COMPRESSION_MODE",   "Specified invalid dynamic range compression mode of Dolby(TM) Digital" } },
    //{ 0x807F0402,{ "SCE_AUDIODEC_ERROR_AC3_INVALID_LFE_CHANNEL_OUTPUT_MODE",  "Specified invalid LFE channel output mode of Dolby(TM) Digital" } },
    //{ 0x807F0403,{ "SCE_AUDIODEC_ERROR_AC3_INVALID_OUTPUT_CHANNEL_CONFIGRATION",  "Specified invalid output channel configuration of Dolby(TM) Digital" } },
    //{ 0x807F0404,{ "SCE_AUDIODEC_ERROR_AC3_INVALID_NUMBER_OF_OUTPUT_CHANNELS",    "Specified invalid number of output channels of Dolby(TM) Digital" } },
    //{ 0x807F0405,{ "SCE_AUDIODEC_ERROR_AC3_INVALID_OUTPUT_PCM_SAMPLES_SCALE_FACTOR",  "Specified invalid output PCM samples scale factor of Dolby(TM) Digital" } },
    //{ 0x807F0406,{ "SCE_AUDIODEC_ERROR_AC3_INVALID_STEREO_MODE",  "Specified invalid stereo mode of Dolby(TM) Digital" } },
    //{ 0x807F0407,{ "SCE_AUDIODEC_ERROR_AC3_INVALID_DUAL_MONO_REPRODUCTION_MODE",  "Specified invalid dual mono reproduction mode of Dolby(TM) Digital" } },
    //{ 0x807F0408,{ "SCE_AUDIODEC_ERROR_AC3_INVALID_HIGH_FREQUENCY_DYNAMIC_CUT_SCALE_FACTOR",  "Specified invalid high frequency dynamic cut scale factor of Dolby(TM) Digital" } },
    //{ 0x807F0409,{ "SCE_AUDIODEC_ERROR_AC3_INVALID_LOW_FREQUENCY_DYNAMIC_BOOST_SCALE_FACTOR", "Specified invalid low frequency dynamic boost scale factor of Dolby(TM) Digital" } },
    //{ 0x807F040A,{ "SCE_AUDIODEC_ERROR_AC3_INVALID_OUTPUT_CHANNEL_ROUTING",   "Specified invalid output channel routing of Dolby(TM) Digital" } },
    //{ 0x807F0A00,{ "SCE_AUDIODEC_ERROR_M2BC_INVALID_DOWNMIX", "Specified invalid downmix flag of MPEG2-BC" } },
    //{ 0x807F0A01,{ "SCE_AUDIODEC_ERROR_M2BC_INVALID_SURROUND_CHANNEL_INTERLEAVE_ORDER",   "Specified invalid surround interleave order of MPEG2-BC" } },
    //{ 0x807F1000,{ "SCE_AUDIODEC_ERROR_AT9_INVALID_CONFIG_DATA",  "Specified invalid ConfigData of ATRAC9(TM)" } },
    //{ 0x807F1100,{ "SCE_AUDIODEC_ERROR_VORBIS_INVALID_RAW_STREAM_MODE",   "Specified invalid raw stream mode of Vorbis" } },
    //{ 0x807F1200,{ "SCE_AUDIODEC_ERROR_OPUS_CELT_INVALID_SAMPLE_RATE",    "invalid sample rate of Opus CELT" } },
    //{ 0x807F1201,{ "SCE_AUDIODEC_ERROR_OPUS_CELT_INVALID_IN_BAND_FORWARD_ERROR_CORRECTION",   "invalid in-band forward error correction of Opus CELT" } },
    //{ 0x807F1202,{ "SCE_AUDIODEC_ERROR_OPUS_CELT_INVALID_GAIN_ADJUSTMENT",    "invalid gain of Opus CELT" } },
    //{ 0x807F1203,{ "SCE_AUDIODEC_ERROR_OPUS_CELT_INVALID_PACKET_LOSS",    "invalid packet loss of Opus CELT" } },
    //{ 0x807F1204,{ "SCE_AUDIODEC_ERROR_OPUS_CELT_INVALID_RESET_STATE",    "invalid reset state of Opus CELT" } },
    //{ 0x807F1205,{ "SCE_AUDIODEC_ERROR_OPUS_CELT_INVALID_MAX_CHANNELS",   "invalid max channel number of Opus CELT" } },
    //{ 0x807F1206,{ "SCE_AUDIODEC_ERROR_OPUS_CELT_INVALID_ACCESS_UNIT_FORMAT", "invalid access unit format of Opus CELT" } },
    //{ 0x807F2000,{ "SCE_AUDIODEC_ERROR_TRHD_INVALID_PRESENTATION_MODE",   "Specified invalid presentationMode of Dolby TrueHD" } },
    //{ 0x807F2001,{ "SCE_AUDIODEC_ERROR_TRHD_INVALID_LOSSLESS",    "Specified invalid lossless of Dolby TrueHD" } },
    //{ 0x807F2002,{ "SCE_AUDIODEC_ERROR_TRHD_INVALID_DRC_ENABLE",  "Specified invalid drcEnable of Dolby TrueHD" } },
    //{ 0x807F2003,{ "SCE_AUDIODEC_ERROR_TRHD_INVALID_DRC_CUT", "Specified invalid drcCut of Dolby TrueHD" } },
    //{ 0x807F2004,{ "SCE_AUDIODEC_ERROR_TRHD_INVALID_DRC_BOOST",   "Specified invalid drcBoost of Dolby TrueHD" } },
    //{ 0x807F2005,{ "SCE_AUDIODEC_ERROR_TRHD_INVALID_NFRAME_DECODE",   "Specified invalid nFrameDecode of Dolby TrueHD" } },
    //{ 0x80810001,{ "SCE_ULT_ERROR_NULL",  "The specified pointer is NULL." } },
    //{ 0x80810002,{ "SCE_ULT_ERROR_ALIGNMENT", "The alignment restrictions are not met." } },
    //{ 0x80810003,{ "SCE_ULT_ERROR_RANGE", "The specified value is out of range." } },
    //{ 0x80810004,{ "SCE_ULT_ERROR_INVALID",   "The specified argument value is invalid." } },
    //{ 0x80810005,{ "SCE_ULT_ERROR_PERMISSION",    "This is an unauthorized operation." } },
    //{ 0x80810006,{ "SCE_ULT_ERROR_STATE", "The current state does not allow application of this operation." } },
    //{ 0x80810007,{ "SCE_ULT_ERROR_BUSY",  "The resource cannot be used." } },
    //{ 0x80810008,{ "SCE_ULT_ERROR_AGAIN", "Execution of this operation is temporarily not possible." } },
    //{ 0x80810009,{ "SCE_ULT_ERROR_FATAL", "A fatal error occurred." } },
    //{ 0x8081000A,{ "SCE_ULT_ERROR_NOT_INITIALIZE",    "This library is not initialized." } },
    //{ 0x80820000,{ "SCE_FIOS_ERROR_UNIMPLEMENTED",    "Not implemented" } },
    //{ 0x80820001,{ "SCE_FIOS_ERROR_CANT_ALLOCATE_OP", "Out of memory in opStorage" } },
    //{ 0x80820002,{ "SCE_FIOS_ERROR_CANT_ALLOCATE_FH", "Out of memory in fhStorage" } },
    //{ 0x80820003,{ "SCE_FIOS_ERROR_CANT_ALLOCATE_DH", "Out of memory in dhStorage" } },
    //{ 0x80820004,{ "SCE_FIOS_ERROR_CANT_ALLOCATE_CHUNK",  "Out of memory in chunkStorage" } },
    //{ 0x80820005,{ "SCE_FIOS_ERROR_BAD_PATH", "File not found" } },
    //{ 0x80820006,{ "SCE_FIOS_ERROR_BAD_PTR",  "An invalid pointer was given as an argument" } },
    //{ 0x80820007,{ "SCE_FIOS_ERROR_BAD_OFFSET",   "An invalid offset was given as an argument" } },
    //{ 0x80820008,{ "SCE_FIOS_ERROR_BAD_SIZE", "An invalid size was given as an argument" } },
    //{ 0x80820009,{ "SCE_FIOS_ERROR_BAD_IOVCNT",   "An invalid iovcnt was given as an argument" } },
    //{ 0x8082000A,{ "SCE_FIOS_ERROR_BAD_OP",   "An invalid SceFiosOp was given as an argument" } },
    //{ 0x8082000B,{ "SCE_FIOS_ERROR_BAD_FH",   "An invalid SceFiosFH was given as an argument" } },
    //{ 0x8082000C,{ "SCE_FIOS_ERROR_BAD_DH",   "An invalid SceFiosDH was given as an argument" } },
    //{ 0x8082000D,{ "SCE_FIOS_ERROR_BAD_ALIGNMENT",    "Invalid alignment on a pointer argument" } },
    //{ 0x8082000E,{ "SCE_FIOS_ERROR_NOT_A_FILE",   "Attempted a file operation, but target was a directory" } },
    //{ 0x8082000F,{ "SCE_FIOS_ERROR_NOT_A_DIRECTORY",  "Attempted a directory operation, but target was a file" } },
    //{ 0x80820010,{ "SCE_FIOS_ERROR_EOF",  "End-of-file reached" } },
    //{ 0x80820011,{ "SCE_FIOS_ERROR_TIMEOUT",  "Timeout occurred" } },
    //{ 0x80820012,{ "SCE_FIOS_ERROR_CANCELLED",    "Operation was cancelled" } },
    //{ 0x80820013,{ "SCE_FIOS_ERROR_ACCESS",   "Insufficient access privileges" } },
    //{ 0x80820014,{ "SCE_FIOS_ERROR_DECOMPRESSION",    "Decompression failed" } },
    //{ 0x80820015,{ "SCE_FIOS_ERROR_READ_ONLY",    "Attempted to write to read-only filehandle or media" } },
    //{ 0x80820016,{ "SCE_FIOS_ERROR_WRITE_ONLY",   "Attempted to read from write-only filehandle" } },
    //{ 0x80820017,{ "SCE_FIOS_ERROR_MEDIA_GONE",   "Media has been removed, unplugged, or otherwise detached" } },
    //{ 0x80820018,{ "SCE_FIOS_ERROR_PATH_TOO_LONG",    "Path does not fit in buffer" } },
    //{ 0x80820019,{ "SCE_FIOS_ERROR_TOO_MANY_OVERLAYS",    "Too many overlays" } },
    //{ 0x8082001A,{ "SCE_FIOS_ERROR_BAD_OVERLAY",  "An invalid overlay was given as an argument" } },
    //{ 0x8082001B,{ "SCE_FIOS_ERROR_BAD_ORDER",    "An invalid order was given as an argument" } },
    //{ 0x8082001C,{ "SCE_FIOS_ERROR_BAD_INDEX",    "An invalid index was given. Either out of range, or already in use" } },
    //{ 0x8082001D,{ "SCE_FIOS_ERROR_EVENT_NOT_HANDLED",    "Callback did not handle the event" } },
    //{ 0x8082001E,{ "SCE_FIOS_ERROR_BUSY", "A sceFiosDHRead is already pending on this SceFiosDH" } },
    //{ 0x8082001F,{ "SCE_FIOS_ERROR_BAD_ARCHIVE",  "Badly-formed or unsupported PSARC archive" } },
    //{ 0x80820020,{ "SCE_FIOS_ERROR_BAD_RESOLVE_TYPE", "An invalid Resolve Type was given when resolving overlays" } },
    //{ 0x80820021,{ "SCE_FIOS_ERROR_BAD_FLAGS",    "Invalid flags were given as an argument" } },
    //{ 0x80820022,{ "SCE_FIOS_ERROR_UNKNOWN",  "An unknown, platform-specific error occurred" } },
    //{ 0x80820023,{ "SCE_FIOS_ERROR_ALREADY_EXISTS",   "The file or directory already exists" } },
    //{ 0x80848101,{ "SCE_JSON_ERROR_PARSE_INVALID_CHAR",   "Invalid Charactor" } },
    //{ 0x80848102,{ "SCE_JSON_ERROR_NOMEM",    "No Memory" } },
    //{ 0x80848103,{ "SCE_JSON_ERROR_NOFILE",   "File Not Found" } },
    //{ 0x80848104,{ "SCE_JSON_ERROR_NOROOT",   "Set Value No Root" } },
    //{ 0x80848105,{ "SCE_JSON_ERROR_NOBUF",    "No Buffer" } },
    //{ 0x80848110,{ "SCE_JSON_ERROR_NOINIT",   "Not Initialize" } },
    //{ 0x80848111,{ "SCE_JSON_ERROR_MULTIPLEINIT", "Multiple Init" } },
    //{ 0x80850000,{ "SCE_XML_ERROR_GENERIC_ERROR", "Generic error" } },
    //{ 0x80850001,{ "SCE_XML_ERROR_NO_MEMORY", "Failed to assign memory" } },
    //{ 0x80850002,{ "SCE_XML_ERROR_NOT_INITIALIZED",   "Not initialized yet" } },
    //{ 0x80850003,{ "SCE_XML_ERROR_INVALID_ARGUMENT",  "Invalid argument" } },
    //{ 0x80850004,{ "SCE_XML_ERROR_NOT_SUPPORTED", "Not Supported" } },
    //{ 0x80850005,{ "SCE_XML_ERROR_INITIALIZE_FAILED", "Initialize Failed" } },
    //{ 0x80850006,{ "SCE_XML_ERROR_INVALID_BIN_XML",   "Inbalid Binary Data" } },
    //{ 0x80850007,{ "SCE_XML_ERROR_PARSER_BUSY",   "Busy Parser" } },
    //{ 0x80850008,{ "SCE_XML_ERROR_XML_UNEXPEXTED_EO_F",   "Unxpexted EOF" } },
    //{ 0x80850009,{ "SCE_XML_ERROR_XML_SYNTAX_ERROR",  "Syntax Eroor XML" } },
    //{ 0x8085000A,{ "SCE_XML_ERROR_XML_END_TAG_MISMATCH",  "Mismatch End Tag" } },
    //{ 0x8085000B,{ "SCE_XML_ERROR_XML_INVALID_CHAR",  "Invalid Charactor" } },
    //{ 0x8085000C,{ "SCE_XML_ERROR_XML_INVALID_DEC_VALUE", "Invalid DEC Value" } },
    //{ 0x8085000D,{ "SCE_XML_ERROR_XML_INVALID_HEX_VALUE", "Invalid HEX Value" } },
    //{ 0x8085000E,{ "SCE_XML_ERROR_XML_CLOSING_ANGLE_BRACKET_CHAR_NOT_FOUND",  "Closing Angle Bracket Char Not Found" } },
    //{ 0x8085000F,{ "SCE_XML_ERROR_XML_EQUALITY_CHAR_NOT_FOUND",   "Equality Char Not Found" } },
    //{ 0x80850010,{ "SCE_XML_ERROR_XML_SEMI_COLON_CHAR_NOT_FOUND", "Semicolon Char Not Found" } },
    //{ 0x80850011,{ "SCE_XML_ERROR_XML_QUOTE_CHAR_NOT_FOUND",  "Quote Char Not Found" } },
    //{ 0x80850012,{ "SCE_XML_ERROR_XML_END_OF_COMMENT_NOT_FOUND",  "Comment Not Found" } },
    //{ 0x80850013,{ "SCE_XML_ERROR_XML_END_OF_CD_SECT_NOT_FOUND",  "End Of CDATA Not Found" } },
    //{ 0x80850014,{ "SCE_XML_ERROR_XML_END_OF_DTD_NOT_FOUND",  "End Of DTD Not Found" } },
    //{ 0x80850015,{ "SCE_XML_ERROR_XML_UNKNOWN_ENCODING",  "Unknown Encoding" } },
    //{ 0x80850016,{ "SCE_XML_ERROR_XML_HANDLER_NOT_SET",   "Not Set Hamdler" } },
    //{ 0x80850017,{ "SCE_XML_ERROR_XML_INVALID_PI",    "Invalid PI" } },
    //{ 0x80850018,{ "SCE_XML_ERROR_XML_INVALID_DOCUMENT_ELEMENT",  "Invalid Document Element" } },
    //{ 0x80850019,{ "SCE_XML_ERROR_XML_DOCUMENT_ELEMENT_NOT_FOUND",    "Document Element Not Found" } },
    //{ 0x8085001A,{ "SCE_XML_ERROR_XML_DUPLICATE_ATTR_NAME",   "Duplicate Attr Name" } },
    //{ 0x80850200,{ "SCE_XML_ERROR_DOM_ERROR", "DOM Error" } },
    //{ 0x80850201,{ "SCE_XML_ERROR_DOM_NODE_NOT_FOUND",    "DOM Node Not Found" } },
    //{ 0x80850202,{ "SCE_XML_ERROR_DOM_READ_ONLY_ERROR",   "DOM Read Only" } },
    //{ 0x80850203,{ "SCE_XML_ERROR_DOM_MAX_UNIQUE_ELEMENT_ERROR",  "DOM Max Unique Element" } },
    //{ 0x80850204,{ "SCE_XML_ERROR_DOM_MAX_UNIQUE_ATTR_ERROR", "DOM Max Unique Attribute" } },
    //{ 0x80850205,{ "SCE_XML_ERROR_DOM_MAX_NUM_OF_ATTR_ERROR", "DOM Max Num of Attribute" } },
    //{ 0x80850206,{ "SCE_XML_ERROR_DOM_MAX_SIZE_OF_ELEMENT_NAME_ERROR",    "DOM Max Size of Element Name" } },
    //{ 0x80850207,{ "SCE_XML_ERROR_DOM_MAX_SIZE_OF_ATTR_NAME_ERROR",   "DOM Max Size of Attribute Name" } },
    //{ 0x80850208,{ "SCE_XML_ERROR_DOM_MAX_SIZE_OF_ATTR_VALUE_ERROR",  "DOM Max Size of Attribute Value" } },
    //{ 0x80850209,{ "SCE_XML_ERROR_DOM_INVALID_ENITITY",   "DOM Invalid Entity" } },
    //{ 0x8085020A,{ "SCE_XML_ERROR_DOM_INVALID_NODE_TYPE", "DOM Invalid Node Type" } },
    //{ 0x80890001,{ "SCE_SYSTEM_GESTURE_ERROR_INVALID_ARGUMENT",   "invalid argument" } },
    //{ 0x80890002,{ "SCE_SYSTEM_GESTURE_ERROR_NOT_SUPPORTED_GESTURE",  "not supported gesture" } },
    //{ 0x80890003,{ "SCE_SYSTEM_GESTURE_ERROR_NOT_INITIALIZED",    "library uninitialized" } },
    //{ 0x80890004,{ "SCE_SYSTEM_GESTURE_ERROR_INDEX_OUT_OF_ARRAY", "specified index was out of array" } },
    //{ 0x80890005,{ "SCE_SYSTEM_GESTURE_ERROR_EVENT_DATA_NOT_FOUND",   "event data was not found" } },
    //{ 0x80890006,{ "SCE_SYSTEM_GESTURE_ERROR_INVALID_HANDLE", "invalid gesture handle" } },
    //{ 0x80890007,{ "SCE_SYSTEM_GESTURE_ERROR_INVALID_TOUCH_AREA", "invalid touch area information" } },
    //{ 0x80890008,{ "SCE_SYSTEM_GESTURE_ERROR_NO_TOUCH_AREA_INFORMATION",  "does not have touch area information" } },
    //{ 0x80890009,{ "SCE_SYSTEM_GESTURE_ERROR_OUT_OF_RECOGNIZER",  "gesture recognizer exceeded the maximum number" } },
    //{ 0x8089000A,{ "SCE_SYSTEM_GESTURE_ERROR_ALREADY_OPENED", "already opened the gesture handle" } },
    //{ 0x808B0001,{ "SCE_FACE_ERROR_NO_MEMORY",    "Not enough memory to run" } },
    //{ 0x808B0002,{ "SCE_FACE_ERROR_INVALID_PARAM",    "Parameter is invalid" } },
    //{ 0x808B0003,{ "SCE_FACE_ERROR_INVALID_DICT", "Dictionary data is invalid" } },
    //{ 0x808B0004,{ "SCE_FACE_ERROR_IMPERF_PARTS", "Parts are incomplete" } },
    //{ 0x808B0005,{ "SCE_FACE_ERROR_OUT_OF_RANGE", "Face angle is out of range" } },
    //{ 0x808B0006,{ "SCE_FACE_ERROR_IMPERF_SHAPE", "Face shape is imperfect" } },
    //{ 0x808C0000,{ "SCE_SMART_ERROR_UNINITIALIZED",   "Error code indicating that sceSmart is not initialized yet." } },
    //{ 0x808C0001,{ "SCE_SMART_ERROR_ALREADY_INITIALIZED", "Error code indicating that sceSmart failed to allocate memory." } },
    //{ 0x808C0002,{ "SCE_SMART_ERROR_OUT_OF_MEMORY",   "Error code indicating that sceSmart is already initialized." } },
    //{ 0x808C0003,{ "SCE_SMART_ERROR_NOT_STOPPED", "Error code indicating that sceSmart is not stoped yet." } },
    //{ 0x808C0004,{ "SCE_SMART_ERROR_NOT_EMPTY",   "Error code indicating that some of the resources are not yet" } },
    //{ 0x808C0005,{ "SCE_SMART_ERROR_INVALID_VALUE",   "Error code indicating that the given value is invalid." } },
    //{ 0x808C0006,{ "SCE_SMART_ERROR_INVALID_POINTER", "Error code indicating that the given pointer is invalid." } },
    //{ 0x808C0007,{ "SCE_SMART_ERROR_ALREADY_REGISTERED",  "Error code indicating that the input is already registered." } },
    //{ 0x808C0008,{ "SCE_SMART_ERROR_NOT_REGISTERED",  "Error code indicating that the input is not yet registered." } },
    //{ 0x808C0009,{ "SCE_SMART_ERROR_ALREADY_STARTED", "Error code indicating that sceSmart is already started." } },
    //{ 0x808C000A,{ "SCE_SMART_ERROR_NOT_STARTED", "Error code indicating that sceSmart is not started yet." } },
    //{ 0x808C000B,{ "SCE_SMART_ERROR_NOT_REQUIRED",    "Error code indicating that sceSmart is not ready for the request." } },
    //{ 0x808C000C,{ "SCE_SMART_ERROR_VERSION_MISSMATCH",   "Error code indicating that the given value/file is not" } },
    //{ 0x808C000D,{ "SCE_SMART_ERROR_NO_DICTIONARY",   "Error code indicating that no target has been registered yet." } },
    //{ 0x808C000E,{ "SCE_SMART_ERROR_BUSY",    "Error code indicating that sceSmart is locked by other threads." } },
    //{ 0x808C000F,{ "SCE_SMART_ERROR_NO_TARGET_PACK",  "Error code indicating that no target pack has been registered yet." } },
    //{ 0x808C0010,{ "SCE_SMART_ERROR_ALREADY_REACHED_THE_LIMIT",   "Already reached the limit." } },
    //{ 0x808C0011,{ "SCE_SMART_ERROR_BAD_IMAGE",   "Error code indicating that the input image is bad." } },
    //{ 0x80910001,{ "SCE_SHADER_BINARY_ERROR_INVALID_ADDR",    "Specified memory address is invalid" } },
    //{ 0x80910002,{ "SCE_SHADER_BINARY_ERROR_INVALID_SIZE",    "Specified memory size is invalid" } },
    //{ 0x80920001,{ "SCE_PAD_ERROR_INVALID_ARG",   "invalid argument" } },
    //{ 0x80920002,{ "SCE_PAD_ERROR_INVALID_PORT",  "invalid port" } },
    //{ 0x80920003,{ "SCE_PAD_ERROR_INVALID_HANDLE",    "invalid handle" } },
    //{ 0x80920004,{ "SCE_PAD_ERROR_ALREADY_OPENED",    "already opned the port." } },
    //{ 0x80920005,{ "SCE_PAD_ERROR_NOT_INITIALIZED",   "library uninitialized." } },
    //{ 0x80920006,{ "SCE_PAD_ERROR_INVALID_LIGHTBAR_SETTING",  "invalid light bar setting." } },
    //{ 0x80920007,{ "SCE_PAD_ERROR_DEVICE_NOT_CONNECTED",  "device is not connected of the handle." } },
    //{ 0x80920008,{ "SCE_PAD_ERROR_NO_HANDLE", "There is no handle." } },
    //{ 0x809200FF,{ "SCE_PAD_ERROR_FATAL", "fatal error" } },
    //{ 0x80920101,{ "SCE_PAD_ERROR_NOT_PERMITTED", "not permitted API call" } },
    //{ 0x80920102,{ "SCE_PAD_ERROR_INVALID_BUFFER_LENGTH", "invalid buffer length" } },
    //{ 0x80920103,{ "SCE_PAD_ERROR_INVALID_REPORT_LENGTH", "invalid report length" } },
    //{ 0x80920104,{ "SCE_PAD_ERROR_INVALID_REPORT_ID", "not permitted report ID." } },
    //{ 0x80920105,{ "SCE_PAD_ERROR_SEND_AGAIN",    "dropped sent report." } },
    //{ 0x80930001,{ "SCE_AJM_ERROR_UNKNOWN",   "Unknown error. This value should not be used." } },
    //{ 0x80930002,{ "SCE_AJM_ERROR_INVALID_CONTEXT",   "The specified AJM context does not exist." } },
    //{ 0x80930003,{ "SCE_AJM_ERROR_INVALID_INSTANCE",  "The specified AJM instance does not exist." } },
    //{ 0x80930004,{ "SCE_AJM_ERROR_INVALID_BATCH", "The specified AJM batch does not exist." } },
    //{ 0x80930005,{ "SCE_AJM_ERROR_INVALID_PARAMETER", "An invalid parameter was passed." } },
    //{ 0x80930006,{ "SCE_AJM_ERROR_OUT_OF_MEMORY", "Not enough memory to perform the operation." } },
    //{ 0x80930007,{ "SCE_AJM_ERROR_OUT_OF_RESOURCES",  "Not enough resources to perform the operation." } },
    //{ 0x80930008,{ "SCE_AJM_ERROR_CODEC_NOT_SUPPORTED",   "The specified codec is not supported." } },
    //{ 0x80930009,{ "SCE_AJM_ERROR_CODEC_ALREADY_REGISTERED",  "The specified codec is already registered in the context." } },
    //{ 0x8093000A,{ "SCE_AJM_ERROR_CODEC_NOT_REGISTERED",  "The specified codec is not registered in the context." } },
    //{ 0x8093000B,{ "SCE_AJM_ERROR_WRONG_REVISION_FLAG",   "The revision passed in the flags is not supported." } },
    //{ 0x8093000C,{ "SCE_AJM_ERROR_FLAG_NOT_SUPPORTED",    "One of the flags is not supported by the codec." } },
    //{ 0x8093000D,{ "SCE_AJM_ERROR_BUSY",  "The entity (instance, codec...) is currently in use." } },
    //{ 0x8093000E,{ "SCE_AJM_ERROR_BAD_PRIORITY",  "The specified priority is invalid." } },
    //{ 0x8093000F,{ "SCE_AJM_ERROR_IN_PROGRESS",   "The specified batch has not completed yet." } },
    //{ 0x80930010,{ "SCE_AJM_ERROR_RETRY", "The operation cannot be performed at the moment." } },
    //{ 0x80930011,{ "SCE_AJM_ERROR_MALFORMED_BATCH",   "The specified batch contains error." } },
    //{ 0x80930012,{ "SCE_AJM_ERROR_JOB_CREATION",  "One or more jobs failed to be added to the batch." } },
    //{ 0x80930013,{ "SCE_AJM_ERROR_INVALID_OPCODE",    "The batch contains an invalid opcode." } },
    //{ 0x80930014,{ "SCE_AJM_ERROR_PRIORITY_VIOLATION",    "The batch references an instance that is already being processed in a batch of a different priority." } },
    //{ 0x80930015,{ "SCE_AJM_ERROR_BUFFER_TOO_BIG",    "The batch references a buffer that exceeds the allowed size." } },
    //{ 0x80930016,{ "SCE_AJM_ERROR_INVALID_ADDRESS",   "The batch references a buffer that is not accessible within this process." } },
    //{ 0x80930017,{ "SCE_AJM_ERROR_CANCELLED", "The batch was successfully cancelled, and none of the output data should be referenced." } },
    //{ 0x809516A8,{ "SCE_SSL_ERROR_ERR_RTOS",  "internal error" } },
    //{ 0x809516A9,{ "SCE_SSL_ERROR_ERR_RTOS_THREAD_CREATE",    "internal error" } },
    //{ 0x809516AA,{ "SCE_SSL_ERROR_ERR_RTOS_MUTEX_CREATE", "failed mutex creation" } },
    //{ 0x809516AB,{ "SCE_SSL_ERROR_ERR_RTOS_MUTEX_WAIT",   "failed mutex wait" } },
    //{ 0x809516AC,{ "SCE_SSL_ERROR_ERR_RTOS_MUTEX_RELEASE",    "failed mutex release" } },
    //{ 0x809516AD,{ "SCE_SSL_ERROR_ERR_RTOS_MUTEX_FREE",   "failed mutex destruction" } },
    //{ 0x809516AE,{ "SCE_SSL_ERROR_ERR_RTOS_GMT_TIME_NOT_AVAILABLE",   "internal error" } },
    //{ 0x809516AF,{ "SCE_SSL_ERROR_ERR_RTOS_WRAP_MUTEX_WAIT",  "internal error" } },
    //{ 0x809516B0,{ "SCE_SSL_ERROR_ERR_RTOS_WRAP_MUTEX_RELEASE",   "internal error" } },
    //{ 0x8095170C,{ "SCE_SSL_ERROR_ERR_TCP",   "protocol error" } },
    //{ 0x8095170D,{ "SCE_SSL_ERROR_SOCKET_CLOSED", "Socket was closed while handshaking" } },
    //{ 0x8095170E,{ "SCE_SSL_ERROR_ERR_TCP_READ_ERROR",    "protocol error" } },
    //{ 0x8095170F,{ "SCE_SSL_ERROR_ERR_TCP_READ_BLOCK_FAIL",   "protocol error" } },
    //{ 0x80951710,{ "SCE_SSL_ERROR_READ_TIMEOUT",  "Read timeout occurred" } },
    //{ 0x80951711,{ "SCE_SSL_ERROR_ERR_TCP_WRITE_ERROR",   "protocol error" } },
    //{ 0x80951712,{ "SCE_SSL_ERROR_ERR_TCP_WRITE_BLOCK_FAIL",  "protocol error" } },
    //{ 0x80951713,{ "SCE_SSL_ERROR_ERR_TCP_INIT_FAIL", "protocol error" } },
    //{ 0x80951714,{ "SCE_SSL_ERROR_ERR_TCP_LISTEN_SOCKET_ERROR",   "protocol error" } },
    //{ 0x80951715,{ "SCE_SSL_ERROR_ERR_TCP_LISTEN_BIND_ERROR", "protocol error" } },
    //{ 0x80951716,{ "SCE_SSL_ERROR_ERR_TCP_LISTEN_ERROR",  "protocol error" } },
    //{ 0x80951717,{ "SCE_SSL_ERROR_ERR_TCP_ACCEPT_ERROR",  "protocol error" } },
    //{ 0x80951718,{ "SCE_SSL_ERROR_ERR_TCP_SOCKOPT_ERROR", "protocol error" } },
    //{ 0x80951719,{ "SCE_SSL_ERROR_ERR_TCP_CONNECT_CREATE",    "protocol error" } },
    //{ 0x8095171A,{ "SCE_SSL_ERROR_ERR_TCP_CONNECT_ERROR", "protocol error" } },
    //{ 0x8095171B,{ "SCE_SSL_ERROR_ERR_TCP_SOCKET_SHARE",  "protocol error" } },
    //{ 0x8095171C,{ "SCE_SSL_ERROR_ERR_TCP_GETSOCKNAME",   "protocol error" } },
    //{ 0x8095171D,{ "SCE_SSL_ERROR_ERR_TCP_ACCEPT_CREATE", "protocol error" } },
    //{ 0x8095171E,{ "SCE_SSL_ERROR_ERR_TCP_LISTEN_ADDRINFO",   "protocol error" } },
    //{ 0x8095171F,{ "SCE_SSL_ERROR_ERR_TCP_TOO_MANY_SOCKETS",  "protocol error" } },
    //{ 0x80951720,{ "SCE_SSL_ERROR_ERR_TCP_NO_SUCH_SOCKET",    "protocol error" } },
    //{ 0x80951721,{ "SCE_SSL_ERROR_ERR_TCP_END_OF_SOCKET_LIST",    "protocol error" } },
    //{ 0x80951722,{ "SCE_SSL_ERROR_ERR_TCP_SELECT_ERROR",  "protocol error" } },
    //{ 0x80951723,{ "SCE_SSL_ERROR_ERR_TCP_CONNECT_EALREADY",  "protocol error" } },
    //{ 0x80951724,{ "SCE_SSL_ERROR_ERR_TCP_CONNECT_INPROGRESS",    "protocol error" } },
    //{ 0x80951725,{ "SCE_SSL_ERROR_ERR_TCP_WOULDBLOCK",    "protocol error" } },
    //{ 0x80951770,{ "SCE_SSL_ERROR_ERR_GENERAL",   "protocol error" } },
    //{ 0x80951771,{ "SCE_SSL_ERROR_ERR_NULL_POINTER",  "protocol error" } },
    //{ 0x80951772,{ "SCE_SSL_ERROR_ERR_DIVIDE_BY_ZERO",    "protocol error" } },
    //{ 0x80951773,{ "SCE_SSL_ERROR_BAD_LENGTH",    "Invalid certificate is specified or invalid record is received" } },
    //{ 0x80951774,{ "SCE_SSL_ERROR_ERR_BAD_MODULO",    "protocol error" } },
    //{ 0x80951775,{ "SCE_SSL_ERROR_ERR_EVEN_NUMBER",   "protocol error" } },
    //{ 0x80951776,{ "SCE_SSL_ERROR_ERR_MISSING_STATE_CHANGE",  "protocol error" } },
    //{ 0x80951777,{ "SCE_SSL_ERROR_ERR_BUFFER_OVERFLOW",   "protocol error" } },
    //{ 0x80951778,{ "SCE_SSL_ERROR_INDEX_OOB", "Invalid certificate is specified" } },
    //{ 0x80951779,{ "SCE_SSL_ERROR_ERR_NOT_FOUND", "protocol error" } },
    //{ 0x8095177A,{ "SCE_SSL_ERROR_INVALID_ARG",   "Invalid certificate or value is specified" } },
    //{ 0x8095177B,{ "SCE_SSL_ERROR_ERR_FALSE", "protocol error" } },
    //{ 0x8095177C,{ "SCE_SSL_ERROR_EOF",   "Invalid certificate is specified" } },
    //{ 0x8095177D,{ "SCE_SSL_ERROR_BAD_EXPONENT",  "Invalid certificate is specified" } },
    //{ 0x8095177E,{ "SCE_SSL_ERROR_INCOMPLETE_SEARCH", "Invalid certificate is specified" } },
    //{ 0x8095177F,{ "SCE_SSL_ERROR_INTERNAL_ERROR",    "Unknown error" } },
    //{ 0x809517D4,{ "SCE_SSL_ERROR_ERR_MEM",   "internal error" } },
    //{ 0x809517D5,{ "SCE_SSL_ERROR_OUT_OF_MEMORY", "out of memory" } },
    //{ 0x809517D6,{ "SCE_SSL_ERROR_ERR_MEM_ALLOC_PTR", "internal error" } },
    //{ 0x809517D7,{ "SCE_SSL_ERROR_ERR_MEM_ALLOC_SIZE",    "internal error" } },
    //{ 0x809517D8,{ "SCE_SSL_ERROR_ERR_MEM_FREE_PTR",  "internal error" } },
    //{ 0x80951838,{ "SCE_SSL_ERROR_ERR_PAYLOAD",   "protocol error" } },
    //{ 0x80951839,{ "SCE_SSL_ERROR_ERR_PAYLOAD_EMPTY", "protocol error" } },
    //{ 0x8095183A,{ "SCE_SSL_ERROR_ERR_PAYLOAD_TOO_LARGE", "protocol error" } },
    //{ 0x80951900,{ "SCE_SSL_ERROR_ERR_AUTH",  "protocol error" } },
    //{ 0x80951901,{ "SCE_SSL_ERROR_ERR_AUTH_MESG_FRAGMENTED",  "protocol error" } },
    //{ 0x80951902,{ "SCE_SSL_ERROR_ERR_AUTH_UNEXPECTED_MESG",  "protocol error" } },
    //{ 0x80951903,{ "SCE_SSL_ERROR_ERR_AUTH_FAILED",   "protocol error" } },
    //{ 0x80951904,{ "SCE_SSL_ERROR_ERR_AUTH_BAD_SIGNATURE",    "protocol error" } },
    //{ 0x80951905,{ "SCE_SSL_ERROR_ERR_AUTH_MISCONFIGURED",    "protocol error" } },
    //{ 0x80951906,{ "SCE_SSL_ERROR_ERR_AUTH_MISCONFIGURED_PROMPTS",    "protocol error" } },
    //{ 0x80951907,{ "SCE_SSL_ERROR_ERR_AUTH_UNKNOWN_METHOD",   "protocol error" } },
    //{ 0x80951964,{ "SCE_SSL_ERROR_ERR_BASE64",    "protocol error" } },
    //{ 0x80951965,{ "SCE_SSL_ERROR_ERR_BASE64_BAD_INPUT",  "protocol error" } },
    //{ 0x80951966,{ "SCE_SSL_ERROR_ERR_BASE64_NOT_INITIALIZED",    "protocol error" } },
    //{ 0x809519C8,{ "SCE_SSL_ERROR_ERR_BLOWFISH",  "protocol error" } },
    //{ 0x809519C9,{ "SCE_SSL_ERROR_ERR_BLOWFISH_BAD_LENGTH",   "protocol error" } },
    //{ 0x80951A2C,{ "SCE_SSL_ERROR_ERR_DES",   "protocol error" } },
    //{ 0x80951A2D,{ "SCE_SSL_ERROR_ERR_DES_BAD_LENGTH",    "protocol error" } },
    //{ 0x80951A2E,{ "SCE_SSL_ERROR_ERR_DES_BAD_KEY_LENGTH",    "protocol error" } },
    //{ 0x80951A2F,{ "SCE_SSL_ERROR_ERR_DES_CIPHER_FAILED", "protocol error" } },
    //{ 0x80951A90,{ "SCE_SSL_ERROR_ERR_3DES",  "protocol error" } },
    //{ 0x80951A91,{ "SCE_SSL_ERROR_ERR_3DES_BAD_LENGTH",   "protocol error" } },
    //{ 0x80951A92,{ "SCE_SSL_ERROR_ERR_3DES_BAD_KEY_LENGTH",   "protocol error" } },
    //{ 0x80951A93,{ "SCE_SSL_ERROR_ERR_3DES_CIPHER_FAILED",    "protocol error" } },
    //{ 0x80951B58,{ "SCE_SSL_ERROR_ERR_KEY_EXCHANGE",  "protocol error" } },
    //{ 0x80951B59,{ "SCE_SSL_ERROR_ERR_BAD_CLIENT_E",  "protocol error" } },
    //{ 0x80951BBC,{ "SCE_SSL_ERROR_ERR_RAND",  "protocol error" } },
    //{ 0x80951BBD,{ "SCE_SSL_ERROR_ERR_RAND_SEED_TOO_LARGE",   "protocol error" } },
    //{ 0x80951BBE,{ "SCE_SSL_ERROR_ERR_RAND_CTX_NOT_INITIALIZED",  "protocol error" } },
    //{ 0x80951BBF,{ "SCE_SSL_ERROR_ERR_RAND_TERMINATE_THREADS",    "protocol error" } },
    //{ 0x80951C84,{ "SCE_SSL_ERROR_ERR_SESSION",   "protocol error" } },
    //{ 0x80951C85,{ "SCE_SSL_ERROR_ERR_SESSION_BAD_PAYLOAD",   "protocol error" } },
    //{ 0x80951C86,{ "SCE_SSL_ERROR_ERR_SESSION_NOT_OPEN",  "protocol error" } },
    //{ 0x80951CE8,{ "SCE_SSL_ERROR_ERR_KEY",   "protocol error" } },
    //{ 0x80951CE9,{ "SCE_SSL_ERROR_ERR_BAD_KEY",   "protocol error" } },
    //{ 0x80951CEA,{ "SCE_SSL_ERROR_ERR_BAD_KEY_BLOB",  "protocol error" } },
    //{ 0x80951CEB,{ "SCE_SSL_ERROR_ERR_BAD_KEY_TYPE",  "protocol error" } },
    //{ 0x80951CEC,{ "SCE_SSL_ERROR_ERR_BAD_KEY_BLOB_VERSION",  "protocol error" } },
    //{ 0x80951D4C,{ "SCE_SSL_ERROR_ERR_SSL",   "protocol error" } },
    //{ 0x80951D4D,{ "SCE_SSL_ERROR_ERR_SSL_TOO_MANY_CONNECTIONS",  "protocol error" } },
    //{ 0x80951D4E,{ "SCE_SSL_ERROR_ERR_SSL_INIT_CONNECTION",   "protocol error" } },
    //{ 0x80951D4F,{ "SCE_SSL_ERROR_ERR_SSL_BAD_ID",    "protocol error" } },
    //{ 0x80951D50,{ "SCE_SSL_ERROR_ERR_SSL_DISABLED",  "protocol error" } },
    //{ 0x80951D51,{ "SCE_SSL_ERROR_ERR_SSL_CONFIG",    "protocol error" } },
    //{ 0x80951D52,{ "SCE_SSL_ERROR_PROTOCOL",  "Received invalid record" } },
    //{ 0x80951D53,{ "SCE_SSL_ERROR_ERR_SSL_INVALID_PRESECRET", "protocol error" } },
    //{ 0x80951D54,{ "SCE_SSL_ERROR_ERR_SSL_INVALID_PADDING",   "protocol error" } },
    //{ 0x80951D55,{ "SCE_SSL_ERROR_ERR_SSL_INVALID_MAC",   "protocol error" } },
    //{ 0x80951D56,{ "SCE_SSL_ERROR_ERR_SSL_BAD_STATE", "protocol error" } },
    //{ 0x80951D57,{ "SCE_SSL_ERROR_ERR_SSL_NOT_OPEN",  "protocol error" } },
    //{ 0x80951D58,{ "SCE_SSL_ERROR_ERR_SSL_NO_CIPHER_MATCH",   "protocol error" } },
    //{ 0x80951D59,{ "SCE_SSL_ERROR_ERR_SSL_CERT_VALIDATION_FAILED",    "protocol error" } },
    //{ 0x80951D5A,{ "SCE_SSL_ERROR_ERR_SSL_UNABLE_TO_RSVP",    "protocol error" } },
    //{ 0x80951D5B,{ "SCE_SSL_ERROR_ERR_SSL_UNSUPPORTED_DIGEST",    "protocol error" } },
    //{ 0x80951D5C,{ "SCE_SSL_ERROR_ERR_SSL_BAD_RECORD_SIZE",   "protocol error" } },
    //{ 0x80951D5D,{ "SCE_SSL_ERROR_ERR_SSL_UNKNOWN_CERTIFICATE_AUTHORITY", "protocol error" } },
    //{ 0x80951D5E,{ "SCE_SSL_ERROR_ERR_SSL_NO_SELF_SIGNED_CERTIFICATES",   "protocol error" } },
    //{ 0x80951D5F,{ "SCE_SSL_ERROR_ERR_SSL_MUTUAL_AUTHENTICATION_DISABLED",    "protocol error" } },
    //{ 0x80951D60,{ "SCE_SSL_ERROR_ERR_SSL_MUTUAL_AUTHENTICATION_FAILED",  "protocol error" } },
    //{ 0x80951D61,{ "SCE_SSL_ERROR_ERR_SSL_MUTUAL_AUTHENTICATION_NOT_REQUESTED",   "protocol error" } },
    //{ 0x80951D62,{ "SCE_SSL_ERROR_ERR_SSL_MUTUAL_AUTHENTICATION_REQUEST_IGNORED", "protocol error" } },
    //{ 0x80951D63,{ "SCE_SSL_ERROR_ERR_SSL_MUTUAL_AUTHENTICATION_REQUIRED",    "protocol error" } },
    //{ 0x80951D64,{ "SCE_SSL_ERROR_ERR_SSL_INVALID_CERT_VERIFY_MSG_SIZE",  "protocol error" } },
    //{ 0x80951D65,{ "SCE_SSL_ERROR_ERR_SSL_INVALID_CERT_REQUEST_MSG_SIZE", "protocol error" } },
    //{ 0x80951D66,{ "SCE_SSL_ERROR_ERR_SSL_INVALID_MSG_SIZE",  "protocol error" } },
    //{ 0x80951D67,{ "SCE_SSL_ERROR_ERR_SSL_INVALID_SIGNATURE", "protocol error" } },
    //{ 0x80951D68,{ "SCE_SSL_ERROR_ERR_SSL_CLIENT_KEY_SIZE_TOO_LONG",  "protocol error" } },
    //{ 0x80951D69,{ "SCE_SSL_ERROR_ERR_SSL_IOCTL_FAILED",  "protocol error" } },
    //{ 0x80951D6A,{ "SCE_SSL_ERROR_ERR_SSL_SERVER_VERSION_UNKNOWN",    "protocol error" } },
    //{ 0x80951D6B,{ "SCE_SSL_ERROR_ERR_SSL_SERVER_VERSION_SSL3",   "protocol error" } },
    //{ 0x80951D6C,{ "SCE_SSL_ERROR_ERR_SSL_CLIENT_START",  "protocol error" } },
    //{ 0x80951D6D,{ "SCE_SSL_ERROR_PROTOCOL_RECEIVE_RECORD",   "Received invalid record" } },
    //{ 0x80951D6E,{ "SCE_SSL_ERROR_ERR_SSL_PROTOCOL_PROCESS_FINISHED", "protocol error" } },
    //{ 0x80951D6F,{ "SCE_SSL_ERROR_ERR_SSL_PROTOCOL_PROCESS_CERTIFICATE",  "protocol error" } },
    //{ 0x80951D70,{ "SCE_SSL_ERROR_ERR_SSL_PROTOCOL_PROCESS_CLIENT_HELLO", "protocol error" } },
    //{ 0x80951D71,{ "SCE_SSL_ERROR_ERR_SSL_PROTOCOL_PROCESS_SERVER_HELLO", "protocol error" } },
    //{ 0x80951D72,{ "SCE_SSL_ERROR_ERR_SSL_PROTOCOL_BAD_LENGTH",   "protocol error" } },
    //{ 0x80951D73,{ "SCE_SSL_ERROR_ERR_SSL_PROTOCOL_BAD_STATE",    "protocol error" } },
    //{ 0x80951D74,{ "SCE_SSL_ERROR_ERR_SSL_PROTOCOL_SERVER",   "protocol error" } },
    //{ 0x80951D75,{ "SCE_SSL_ERROR_ERR_SSL_PSK_BAD_CONFIG",    "protocol error" } },
    //{ 0x80951D76,{ "SCE_SSL_ERROR_ERR_SSL_PSK_BAD_LENGTH",    "protocol error" } },
    //{ 0x80951D77,{ "SCE_SSL_ERROR_ERR_SSL_PSK_CALLBACK_OVERFLOW_BUF", "protocol error" } },
    //{ 0x80951D78,{ "SCE_SSL_ERROR_PROTOCOL_VERSION",  "Received invalid version record" } },
    //{ 0x80951D79,{ "SCE_SSL_ERROR_ERR_SSL_CRYPT_BLOCK_SIZE",  "protocol error" } },
    //{ 0x80951D7A,{ "SCE_SSL_ERROR_ERR_SSL_FATAL_ALERT",   "protocol error" } },
    //{ 0x80951D7B,{ "SCE_SSL_ERROR_ERR_SSL_INVALID_CERT_LENGTH",   "protocol error" } },
    //{ 0x80951D7C,{ "SCE_SSL_ERROR_ERR_SSL_NO_DATA_TO_SEND",   "protocol error" } },
    //{ 0x80951D7D,{ "SCE_SSL_ERROR_ERR_SSL_NO_DATA_TO_RECEIVE",    "protocol error" } },
    //{ 0x80951D7E,{ "SCE_SSL_ERROR_ERR_SSL_EAP_DATA_SEND", "protocol error" } },
    //{ 0x80951D7F,{ "SCE_SSL_ERROR_ERR_SSL_EXTENSION_DUPLICATE",   "protocol error" } },
    //{ 0x80951D80,{ "SCE_SSL_ERROR_ERR_SSL_EXTENSION_LENGTH",  "protocol error" } },
    //{ 0x80951D81,{ "SCE_SSL_ERROR_ERR_SSL_EXTENSION_SERVER_LIST_LENGTH",  "protocol error" } },
    //{ 0x80951D82,{ "SCE_SSL_ERROR_ERR_SSL_EXTENSION_SERVER_NAME_LENGTH",  "protocol error" } },
    //{ 0x80951D83,{ "SCE_SSL_ERROR_ERR_SSL_EXTENSION_UNSOLICITED_OFFER",   "protocol error" } },
    //{ 0x80951D84,{ "SCE_SSL_ERROR_ERR_SSL_EXTENSION_UNRECOGNIZED_NAME",   "protocol error" } },
    //{ 0x80951D85,{ "SCE_SSL_ERROR_ERR_SSL_TICKET_INIT",   "protocol error" } },
    //{ 0x80951D86,{ "SCE_SSL_ERROR_ERR_SSL_UNSUPPORTED_ALGORITHM", "protocol error" } },
    //{ 0x80951D87,{ "SCE_SSL_ERROR_ERR_SSL_INVALID_KEY_TYPE",  "protocol error" } },
    //{ 0x80951D88,{ "SCE_SSL_ERROR_ERR_SSL_EXTENSION_UNKNOWN_FORMAT",  "protocol error" } },
    //{ 0x80951D89,{ "SCE_SSL_ERROR_ERR_SSL_UNSUPPORTED_CURVE", "protocol error" } },
    //{ 0x80951D8A,{ "SCE_SSL_ERROR_ERR_SSL_NO_CIPHERSUITE",    "protocol error" } },
    //{ 0x80951D8B,{ "SCE_SSL_ERROR_ERR_SSL_WARNING_ALERT", "protocol error" } },
    //{ 0x80951D8C,{ "SCE_SSL_ERROR_ERR_SSL_INNER_APP_VERIFY_DATA", "protocol error" } },
    //{ 0x80951D8D,{ "SCE_SSL_ERROR_ERR_SSL_INVALID_INNER_TYPE",    "protocol error" } },
    //{ 0x80951D8E,{ "SCE_SSL_ERROR_ERR_SSL_TOO_MANY_REHANDSHAKES", "protocol error" } },
    //{ 0x80951D8F,{ "SCE_SSL_ERROR_ERR_SSL_BAD_HEADER_VERSION",    "protocol error" } },
    //{ 0x80951D90,{ "SCE_SSL_ERROR_ERR_DTLS_BAD_HELLO_COOKIE", "protocol error" } },
    //{ 0x80951D91,{ "SCE_SSL_ERROR_ERR_DTLS_CONNECT_TIMED_WAIT",   "protocol error" } },
    //{ 0x80951D92,{ "SCE_SSL_ERROR_ERR_DTLS_SRTP_CALLBACK_MISSING",    "protocol error" } },
    //{ 0x80951D93,{ "SCE_SSL_ERROR_ERR_DTLS_SRTP_NO_PROFILE_MATCH",    "protocol error" } },
    //{ 0x80951D94,{ "SCE_SSL_ERROR_ERR_DTLS_SRTP_EXTENSION_FAILURE",   "protocol error" } },
    //{ 0x80951D95,{ "SCE_SSL_ERROR_ERR_SSL_UNABLE_TO_SIGN_CERTIFICATE_VERIFY", "protocol error" } },
    //{ 0x80951D96,{ "SCE_SSL_ERROR_ERR_DTLS_RETRANSMISSION_BUFFERS_FULL",  "protocol error" } },
    //{ 0x80951D97,{ "SCE_SSL_ERROR_ERR_DTLS_SEND_BUFFER",  "protocol error" } },
    //{ 0x80951D98,{ "SCE_SSL_ERROR_ERR_DTLS_DROP_REPLAY_RECORD",   "protocol error" } },
    //{ 0x80951D99,{ "SCE_SSL_ERROR_ERR_DTLS_MTU_TOO_SMALL",    "protocol error" } },
    //{ 0x80951D9A,{ "SCE_SSL_ERROR_ERR_DTLS_DEFRAG_INVALID_HOLE_DESCRIPTOR",   "protocol error" } },
    //{ 0x80951D9B,{ "SCE_SSL_ERROR_ERR_DTLS_DEFRAG_HOLE_SIZE_TOO_SMALL",   "protocol error" } },
    //{ 0x80951D9C,{ "SCE_SSL_ERROR_ERR_SSL_SERVER_RENEGOTIATE_LENGTH", "protocol error" } },
    //{ 0x80951D9D,{ "SCE_SSL_ERROR_ERR_SSL_SERVER_RENEGOTIATE_CLIENT_VERIFY",  "protocol error" } },
    //{ 0x80951D9E,{ "SCE_SSL_ERROR_ERR_SSL_SERVER_RENEGOTIATE_NOT_ALLOWED",    "protocol error" } },
    //{ 0x80951D9F,{ "SCE_SSL_ERROR_ERR_SSL_SERVER_RENEGOTIATE_ILLEGAL_SCSV",   "protocol error" } },
    //{ 0x80951DA0,{ "SCE_SSL_ERROR_ERR_SSL_SERVER_RENEGOTIATE_ILLEGAL_EXTENSION",  "protocol error" } },
    //{ 0x80951DA1,{ "SCE_SSL_ERROR_ERR_SSL_CLIENT_RENEGOTIATE_LENGTH", "protocol error" } },
    //{ 0x80951DA2,{ "SCE_SSL_ERROR_ERR_SSL_CLIENT_RENEGOTIATE_CLIENT_VERIFY",  "protocol error" } },
    //{ 0x80951DA3,{ "SCE_SSL_ERROR_ERR_SSL_CLIENT_RENEGOTIATE_SERVER_VERIFY",  "protocol error" } },
    //{ 0x80951DA4,{ "SCE_SSL_ERROR_ERR_SSL_CLIENT_RENEGOTIATE_NOT_ALLOWED",    "protocol error" } },
    //{ 0x80951DA5,{ "SCE_SSL_ERROR_ERR_SSL_CLIENT_RENEGOTIATE_ILLEGAL_EXTENSION",  "protocol error" } },
    //{ 0x80951DA6,{ "SCE_SSL_ERROR_ERR_SSL_EXTENSION_DUPLICATE_NAMETYPE_SNI",  "protocol error" } },
    //{ 0x80951DA7,{ "SCE_SSL_ERROR_ERR_SSL_EXTENSION_CERTIFICATE_STATUS_UNSOLICITED",  "protocol error" } },
    //{ 0x80951DA8,{ "SCE_SSL_ERROR_ERR_SSL_EXTENSION_CERTIFICATE_STATUS_LENGTH",   "protocol error" } },
    //{ 0x80951DA9,{ "SCE_SSL_ERROR_ERR_SSL_EXTENSION_CERTIFICATE_STATUS_RESPONSE", "protocol error" } },
    //{ 0x80951DAA,{ "SCE_SSL_ERROR_ERR_SSL_EXTENSION_ELLIPTIC_CURVE_NOT_RECEIVED", "protocol error" } },
    //{ 0x80951DAB,{ "SCE_SSL_ERROR_ERR_SSL_CONNECTION_BUSY",   "protocol error" } },
    //{ 0x80951DB0,{ "SCE_SSL_ERROR_ERR_CERT",  "protocol error" } },
    //{ 0x80951DB1,{ "SCE_SSL_ERROR_ERR_CERT_BUFFER_OVERFLOW",  "protocol error" } },
    //{ 0x80951DB2,{ "SCE_SSL_ERROR_ERR_CERT_STRING_TOO_LONG",  "protocol error" } },
    //{ 0x80951DB3,{ "SCE_SSL_ERROR_ERR_CERT_INVALID_STRUCT",   "protocol error" } },
    //{ 0x80951DB4,{ "SCE_SSL_ERROR_ERR_CERT_NOT_EXPECTED_OID", "protocol error" } },
    //{ 0x80951DB5,{ "SCE_SSL_ERROR_ERR_CERT_RSA_EXPONENT_TOO_BIG", "protocol error" } },
    //{ 0x80951DB6,{ "SCE_SSL_ERROR_ERR_CERT_EXPIRED",  "protocol error" } },
    //{ 0x80951DB7,{ "SCE_SSL_ERROR_ERR_CERT_BAD_COMMON_NAME",  "protocol error" } },
    //{ 0x80951DB8,{ "SCE_SSL_ERROR_ERR_CERT_INVALID_PARENT_CERTIFICATE",   "protocol error" } },
    //{ 0x80951DB9,{ "SCE_SSL_ERROR_ERR_CERT_INVALID_SIGNATURE",    "protocol error" } },
    //{ 0x80951DBA,{ "SCE_SSL_ERROR_ERR_CERT_INVALID_INTERMEDIATE_CERTIFICATE", "protocol error" } },
    //{ 0x80951DBB,{ "SCE_SSL_ERROR_ERR_CERT_INVALID_CERT_POLICY",  "protocol error" } },
    //{ 0x80951DBC,{ "SCE_SSL_ERROR_ERR_CERT_UNSUPPORTED_DIGEST",   "protocol error" } },
    //{ 0x80951DBD,{ "SCE_SSL_ERROR_ERR_CERT_DNE_STRING_TOO_LONG",  "protocol error" } },
    //{ 0x80951DBE,{ "SCE_SSL_ERROR_ERR_CERT_CHAIN_NOT_VERIFIED",   "protocol error" } },
    //{ 0x80951DBF,{ "SCE_SSL_ERROR_ERR_CERT_STACK_OVERFLOW",   "protocol error" } },
    //{ 0x80951DC0,{ "SCE_SSL_ERROR_ERR_CERT_REVOKED",  "protocol error" } },
    //{ 0x80951DC1,{ "SCE_SSL_ERROR_ERR_CERT_HASH_TOO_LONG",    "protocol error" } },
    //{ 0x80951DC2,{ "SCE_SSL_ERROR_ERR_CERT_KEYUSAGE_MISSING", "protocol error" } },
    //{ 0x80951DC3,{ "SCE_SSL_ERROR_ERR_CERT_UNKNOWN_CRITICAL_EXTENSION",   "protocol error" } },
    //{ 0x80951DC4,{ "SCE_SSL_ERROR_ERR_CERT_UNSUPPORTED_SIGNATURE_ALGO",   "protocol error" } },
    //{ 0x80951DC5,{ "SCE_SSL_ERROR_ERR_CERT_RSA_MODULUS_TOO_BIG",  "protocol error" } },
    //{ 0x80951DC6,{ "SCE_SSL_ERROR_ERR_CERT_BAD_SUBJECT_NAME", "protocol error" } },
    //{ 0x80951DC7,{ "SCE_SSL_ERROR_ERR_CERT_KEY_SIGNATURE_OID_MISMATCH",   "protocol error" } },
    //{ 0x80951DC8,{ "SCE_SSL_ERROR_ERR_CERT_INVALID_KEYUSAGE", "protocol error" } },
    //{ 0x80951DC9,{ "SCE_SSL_ERROR_ERR_CERT_START_TIME_VALID_IN_FUTURE",   "protocol error" } },
    //{ 0x80951DCA,{ "SCE_SSL_ERROR_ERR_CERT_INVALID_EXTENDED_KEYUSAGE",    "protocol error" } },
    //{ 0x80951DCB,{ "SCE_SSL_ERROR_ERR_CERT_UNRECOGNIZED_OID", "protocol error" } },
    //{ 0x80951DCC,{ "SCE_SSL_ERROR_ERR_CERT_BASIC_CONSTRAINT_EXTENSION_NOT_FOUND", "protocol error" } },
    //{ 0x80951E14,{ "SCE_SSL_ERROR_ERR_RSA",   "protocol error" } },
    //{ 0x80951E15,{ "SCE_SSL_ERROR_ERR_RSA_INVALID_KEY",   "protocol error" } },
    //{ 0x80951E16,{ "SCE_SSL_ERROR_ERR_RSA_DECRYPTION",    "protocol error" } },
    //{ 0x80951E17,{ "SCE_SSL_ERROR_ERR_RSA_INVALID_PKCS1", "protocol error" } },
    //{ 0x80951E18,{ "SCE_SSL_ERROR_ERR_RSA_INVALID_PKCS1_VERSION", "protocol error" } },
    //{ 0x80951E19,{ "SCE_SSL_ERROR_ERR_RSA_INVALID_PKCS8", "protocol error" } },
    //{ 0x80951E1A,{ "SCE_SSL_ERROR_ERR_RSA_INVALID_EXPONENT",  "protocol error" } },
    //{ 0x80951E1B,{ "SCE_SSL_ERROR_ERR_RSA_INVALID_MODULUS",   "protocol error" } },
    //{ 0x80951E1C,{ "SCE_SSL_ERROR_ERR_RSA_KEY_NOT_READY", "protocol error" } },
    //{ 0x80951E1D,{ "SCE_SSL_ERROR_ERR_RSA_DISABLED",  "protocol error" } },
    //{ 0x80951E1E,{ "SCE_SSL_ERROR_ERR_RSA_KEY_LENGTH_TOO_SMALL",  "protocol error" } },
    //{ 0x80951E1F,{ "SCE_SSL_ERROR_ERR_RSA_BAD_SIGNATURE", "protocol error" } },
    //{ 0x80951E20,{ "SCE_SSL_ERROR_ERR_RSA_UNKNOWN_PKCS5_ALGO",    "protocol error" } },
    //{ 0x80951E21,{ "SCE_SSL_ERROR_ERR_RSA_UNKNOWN_PKCS8_ALGOID",  "protocol error" } },
    //{ 0x80951E22,{ "SCE_SSL_ERROR_ERR_RSA_UNSUPPORTED_PKCS8_OPTION",  "protocol error" } },
    //{ 0x80951E23,{ "SCE_SSL_ERROR_ERR_RSA_BUILT_WITH_NO_PKCS8_DECRYPTION",    "protocol error" } },
    //{ 0x80951E24,{ "SCE_SSL_ERROR_ERR_RSA_UNSUPPORTED_PKCS8_ALGO",    "protocol error" } },
    //{ 0x80951EDC,{ "SCE_SSL_ERROR_ERR_AES",   "protocol error" } },
    //{ 0x80951EDD,{ "SCE_SSL_ERROR_ERR_AES_BAD_PAD_LENGTH",    "protocol error" } },
    //{ 0x80951EDE,{ "SCE_SSL_ERROR_ERR_AES_BAD_LENGTH",    "protocol error" } },
    //{ 0x80951EDF,{ "SCE_SSL_ERROR_ERR_AES_BAD_OPERATION", "protocol error" } },
    //{ 0x80951EE0,{ "SCE_SSL_ERROR_ERR_AES_BAD_KEY_LENGTH",    "protocol error" } },
    //{ 0x80951EE1,{ "SCE_SSL_ERROR_ERR_AES_BAD_KEY_DIR",   "protocol error" } },
    //{ 0x80951EE2,{ "SCE_SSL_ERROR_ERR_AES_BAD_KEY_MATERIAL",  "protocol error" } },
    //{ 0x80951EE3,{ "SCE_SSL_ERROR_ERR_AES_BAD_CIPHER_MODE",   "protocol error" } },
    //{ 0x80951EE4,{ "SCE_SSL_ERROR_ERR_AES_CIPHER_FAILED", "protocol error" } },
    //{ 0x80951EE5,{ "SCE_SSL_ERROR_ERR_AES_CCM_AUTH_FAIL", "protocol error" } },
    //{ 0x80951EE6,{ "SCE_SSL_ERROR_ERR_AES_BAD_ARG",   "protocol error" } },
    //{ 0x80951F40,{ "SCE_SSL_ERROR_ERR_TREE",  "protocol error" } },
    //{ 0x80951F41,{ "SCE_SSL_ERROR_ERR_TREE_LINKEDCHILD",  "protocol error" } },
    //{ 0x80951FA4,{ "SCE_SSL_ERROR_ERR_ASN",   "protocol error" } },
    //{ 0x80951FA5,{ "SCE_SSL_ERROR_ERR_ASN_ZERO_LENGTH",   "protocol error" } },
    //{ 0x80951FA6,{ "SCE_SSL_ERROR_ERR_ASN_UNRECOGNIZED_PRIMITIVE",    "protocol error" } },
    //{ 0x80951FA7,{ "SCE_SSL_ERROR_ERR_ASN_INCONSISTENT_LENGTH",   "protocol error" } },
    //{ 0x80951FA8,{ "SCE_SSL_ERROR_ERR_ASN_INVALID_DATA",  "protocol error" } },
    //{ 0x80951FA9,{ "SCE_SSL_ERROR_ERR_ASN_BAD_LENGTH_FIELD",  "protocol error" } },
    //{ 0x80951FAA,{ "SCE_SSL_ERROR_ERR_ASN_NULL_FUNC_PTR", "protocol error" } },
    //{ 0x80951FAB,{ "SCE_SSL_ERROR_ERR_ASN_BAD_INT_LENGTH_FIELD",  "protocol error" } },
    //{ 0x80951FAC,{ "SCE_SSL_ERROR_ERR_ASN_UNEXPECTED_END",    "protocol error" } },
    //{ 0x80952008,{ "SCE_SSL_ERROR_ERR_PRIME", "protocol error" } },
    //{ 0x80952009,{ "SCE_SSL_ERROR_ERR_PRIME_EXPECTED",    "protocol error" } },
    //{ 0x809520D0,{ "SCE_SSL_ERROR_ERR_CERT_AUTH", "protocol error" } },
    //{ 0x809520D1,{ "SCE_SSL_ERROR_BAD_SIGN_ALGO", "Invalid certificate is specified" } },
    //{ 0x809520D2,{ "SCE_SSL_ERROR_BAD_CERT_LENGTH",   "Invalid certificate is specified" } },
    //{ 0x809520D3,{ "SCE_SSL_ERROR_MISMATCH_PUBLIC_KEYS",  "Invalid certificate is specified" } },
    //{ 0x809520D4,{ "SCE_SSL_ERROR_KEY_BLOB_CORRUPT",  "Invalid certificate is specified" } },
    //{ 0x80952134,{ "SCE_SSL_ERROR_ERR_URI",   "protocol error" } },
    //{ 0x80952135,{ "SCE_SSL_ERROR_ERR_URI_INVALID_FORMAT",    "protocol error" } },
    //{ 0x809521FC,{ "SCE_SSL_ERROR_ERR_PEM",   "protocol error" } },
    //{ 0x809521FD,{ "SCE_SSL_ERROR_ERR_PEM_STRUCTURE", "protocol error" } },
    //{ 0x80952292,{ "SCE_SSL_ERROR_ERR_SPD_BAD_ID",    "protocol error" } },
    //{ 0x80952293,{ "SCE_SSL_ERROR_ERR_SPD_BAD_INDEX", "protocol error" } },
    //{ 0x80952294,{ "SCE_SSL_ERROR_ERR_SPD_INVALID_MODE",  "protocol error" } },
    //{ 0x80952295,{ "SCE_SSL_ERROR_ERR_SPD_INVALID_BUNDLE",    "protocol error" } },
    //{ 0x80952296,{ "SCE_SSL_ERROR_ERR_SPD_INVALID_ID_INFO",   "protocol error" } },
    //{ 0x80952297,{ "SCE_SSL_ERROR_ERR_SPD_UNACCEPTABLE_TS",   "protocol error" } },
    //{ 0x80952298,{ "SCE_SSL_ERROR_ERR_SPD_UNMATCHED_ALGOS",   "protocol error" } },
    //{ 0x80952328,{ "SCE_SSL_ERROR_ERR_CRYPTO",    "protocol error" } },
    //{ 0x80952329,{ "SCE_SSL_ERROR_ERR_CRYPTO_DH_UNSUPPORTED_GROUP",   "protocol error" } },
    //{ 0x8095232A,{ "SCE_SSL_ERROR_ERR_CRYPTO_BAD_PAD",    "protocol error" } },
    //{ 0x8095232B,{ "SCE_SSL_ERROR_ERR_CRYPTO_BAD_KEY_TYPE",   "protocol error" } },
    //{ 0x8095232C,{ "SCE_SSL_ERROR_ERR_CRYPTO_ECC_DISABLED",   "protocol error" } },
    //{ 0x8095232D,{ "SCE_SSL_ERROR_ERR_CRYPTO_RSA_DISABLED",   "protocol error" } },
    //{ 0x8095232E,{ "SCE_SSL_ERROR_ERR_CRYPTO_DSA_DISABLED",   "protocol error" } },
    //{ 0x8095232F,{ "SCE_SSL_ERROR_ERR_CRYPTO_DSA_SIGN_VERIFY_RS_TEST",    "protocol error" } },
    //{ 0x80952330,{ "SCE_SSL_ERROR_ERR_CRYPTO_AEAD_FAIL",  "protocol error" } },
    //{ 0x80952331,{ "SCE_SSL_ERROR_ERR_CRYPTO_FAILURE",    "protocol error" } },
    //{ 0x80952332,{ "SCE_SSL_ERROR_ERR_CRYPTO_BAD_HASH",   "protocol error" } },
    //{ 0x809523F0,{ "SCE_SSL_ERROR_ERR_UDP",   "protocol error" } },
    //{ 0x809523F1,{ "SCE_SSL_ERROR_ERR_UDP_INTERFACE_NOT_FOUND",   "protocol error" } },
    //{ 0x809523F2,{ "SCE_SSL_ERROR_ERR_UDP_BIND",  "protocol error" } },
    //{ 0x809523F3,{ "SCE_SSL_ERROR_ERR_UDP_BAD_ADDRESS",   "protocol error" } },
    //{ 0x809523F4,{ "SCE_SSL_ERROR_ERR_UDP_SOCKET",    "protocol error" } },
    //{ 0x809523F5,{ "SCE_SSL_ERROR_ERR_UDP_CONNECT",   "protocol error" } },
    //{ 0x809523F6,{ "SCE_SSL_ERROR_ERR_UDP_IOCTL", "protocol error" } },
    //{ 0x809523F7,{ "SCE_SSL_ERROR_ERR_UDP_WRITE", "protocol error" } },
    //{ 0x809523F8,{ "SCE_SSL_ERROR_ERR_UDP_READ",  "protocol error" } },
    //{ 0x809523F9,{ "SCE_SSL_ERROR_ERR_UDP_HOSTNAME_NOT_FOUND",    "protocol error" } },
    //{ 0x809523FA,{ "SCE_SSL_ERROR_ERR_UDP_WRITE_LEN", "protocol error" } },
    //{ 0x809523FB,{ "SCE_SSL_ERROR_ERR_UDP_NO_FREE_PORTS", "protocol error" } },
    //{ 0x809523FC,{ "SCE_SSL_ERROR_ERR_UDP_PORT_IN_USE",   "protocol error" } },
    //{ 0x809523FD,{ "SCE_SSL_ERROR_ERR_UDP_BAD_CONTEXT",   "protocol error" } },
    //{ 0x809523FE,{ "SCE_SSL_ERROR_ERR_UDP_GETSOCKNAME",   "protocol error" } },
    //{ 0x809523FF,{ "SCE_SSL_ERROR_ERR_UDP_READ_TIMEOUT",  "protocol error" } },
    //{ 0x80952400,{ "SCE_SSL_ERROR_ERR_UDP_BIND_CTX",  "protocol error" } },
    //{ 0x80952401,{ "SCE_SSL_ERROR_ERR_UDP_GETADDR",   "protocol error" } },
    //{ 0x809524B8,{ "SCE_SSL_ERROR_ERR_ARC4",  "protocol error" } },
    //{ 0x809524B9,{ "SCE_SSL_ERROR_ERR_ARC4_BAD_LENGTH",   "protocol error" } },
    //{ 0x8095251C,{ "SCE_SSL_ERROR_ERR_MEM_POOL",  "protocol error" } },
    //{ 0x8095251D,{ "SCE_SSL_ERROR_ERR_MEM_POOL_NULL_PTR", "protocol error" } },
    //{ 0x8095251E,{ "SCE_SSL_ERROR_ERR_MEM_POOL_CREATE",   "protocol error" } },
    //{ 0x8095251F,{ "SCE_SSL_ERROR_ERR_MEM_POOL_COUNT_ZERO",   "protocol error" } },
    //{ 0x80952520,{ "SCE_SSL_ERROR_ERR_MEM_POOL_GET_POOL_EMPTY",   "protocol error" } },
    //{ 0x80952521,{ "SCE_SSL_ERROR_ERR_MEM_POOL_BAD_PUT_POOL_OBJ", "protocol error" } },
    //{ 0x809525E4,{ "SCE_SSL_ERROR_ERR_FF",    "protocol error" } },
    //{ 0x809525E5,{ "SCE_SSL_ERROR_ERR_FF_DIFFERENT_FIELDS",   "protocol error" } },
    //{ 0x809525E6,{ "SCE_SSL_ERROR_ERR_FF_INVALID_PT_STRING",  "protocol error" } },
    //{ 0x809525E7,{ "SCE_SSL_ERROR_ERR_FF_UNSUPPORTED_PT_REPRESENTATION",  "protocol error" } },
    //{ 0x80952648,{ "SCE_SSL_ERROR_ERR_EC",    "protocol error" } },
    //{ 0x80952649,{ "SCE_SSL_ERROR_ERR_EC_UNUSED", "protocol error" } },
    //{ 0x8095264A,{ "SCE_SSL_ERROR_ERR_EC_UNSUPPORTED_CURVE",  "protocol error" } },
    //{ 0x8095264B,{ "SCE_SSL_ERROR_ERR_EC_INVALID_KEY_FILE_FORMAT",    "protocol error" } },
    //{ 0x8095264C,{ "SCE_SSL_ERROR_ERR_EC_UNKNOWN_KEY_FILE_VERSION",   "protocol error" } },
    //{ 0x8095264D,{ "SCE_SSL_ERROR_ERR_EC_INCOMPLETE_KEY_FILE",    "protocol error" } },
    //{ 0x8095264E,{ "SCE_SSL_ERROR_ERR_EC_INVALID_KEY_TYPE",   "protocol error" } },
    //{ 0x8095264F,{ "SCE_SSL_ERROR_ERR_EC_PUBLIC_KEY", "protocol error" } },
    //{ 0x80952650,{ "SCE_SSL_ERROR_ERR_EC_INFINITE_RESULT",    "protocol error" } },
    //{ 0x80952651,{ "SCE_SSL_ERROR_ERR_EC_DIFFERENT_CURVE",    "protocol error" } },
    //{ 0x80952774,{ "SCE_SSL_ERROR_ERR_RC2",   "protocol error" } },
    //{ 0x80952775,{ "SCE_SSL_ERROR_ERR_RC2_BAD_LENGTH",    "protocol error" } },
    //{ 0x809527D8,{ "SCE_SSL_ERROR_ERR_PKCS7", "protocol error" } },
    //{ 0x809527D9,{ "SCE_SSL_ERROR_ERR_PKCS7_INVALID_STRUCT",  "protocol error" } },
    //{ 0x809527DA,{ "SCE_SSL_ERROR_ERR_PKCS7_UNSUPPORTED_ENCRYPTALGO", "protocol error" } },
    //{ 0x809527DB,{ "SCE_SSL_ERROR_ERR_PKCS7_UNSUPPORTED_DIGESTALGO",  "protocol error" } },
    //{ 0x809527DC,{ "SCE_SSL_ERROR_ERR_PKCS7_INVALID_SIGNATURE",   "protocol error" } },
    //{ 0x809527DD,{ "SCE_SSL_ERROR_ERR_PKCS7_HASH_TOO_LONG",   "protocol error" } },
    //{ 0x809527DE,{ "SCE_SSL_ERROR_ERR_PKCS7_NO_CERT_FOR_SIGNER",  "protocol error" } },
    //{ 0x809527DF,{ "SCE_SSL_ERROR_ERR_PKCS7_NO_RECIPIENT_KEY_MATCH",  "protocol error" } },
    //{ 0x809527E0,{ "SCE_SSL_ERROR_ERR_PKCS7_NO_CONTENT",  "protocol error" } },
    //{ 0x809527E1,{ "SCE_SSL_ERROR_ERR_PKCS7_UNSUPPORTED_KDF", "protocol error" } },
    //{ 0x809527E2,{ "SCE_SSL_ERROR_ERR_PKCS7_UNSUPPORTED_KEY_WRAP",    "protocol error" } },
    //{ 0x809527E3,{ "SCE_SSL_ERROR_ERR_PKCS7_UNSUPPORTED_CONTENT_TYPE",    "protocol error" } },
    //{ 0x809527E4,{ "SCE_SSL_ERROR_ERR_PKCS7_NO_ENCRYPTED_CONTENT",    "protocol error" } },
    //{ 0x809527E5,{ "SCE_SSL_ERROR_ERR_PKCS7_INVALID_ENCRYPTED_LENGTH",    "protocol error" } },
    //{ 0x809527E6,{ "SCE_SSL_ERROR_ERR_PKCS7_WRONG_CALLBACK",  "protocol error" } },
    //{ 0x809527E7,{ "SCE_SSL_ERROR_ERR_PKCS7_INVALID_TYPE_FOR_OP", "protocol error" } },
    //{ 0x809527E8,{ "SCE_SSL_ERROR_ERR_PKCS7_DIGEST_DONT_MATCH",   "protocol error" } },
    //{ 0x809527E9,{ "SCE_SSL_ERROR_ERR_PKCS7_DETACHED_DATA",   "protocol error" } },
    //{ 0x809527EA,{ "SCE_SSL_ERROR_ERR_PKCS7_NOT_DETACHED_SIGNATURE",  "protocol error" } },
    //{ 0x809527EB,{ "SCE_SSL_ERROR_ERR_PKCS7_DETACHED_DATA_ALREADY_SET",   "protocol error" } },
    //{ 0x809527EC,{ "SCE_SSL_ERROR_ERR_PKCS7_ALREADY_STREAMING",   "protocol error" } },
    //{ 0x809527ED,{ "SCE_SSL_ERROR_ERR_PKCS7_CONTEXT_COMPLETED",   "protocol error" } },
    //{ 0x809527EE,{ "SCE_SSL_ERROR_ERR_PKCS7_RNG_FUN_REQUIRED_FOR_ECC",    "protocol error" } },
    //{ 0x809527EF,{ "SCE_SSL_ERROR_ERR_PKCS7_INVALID_TAG_VALUE",   "protocol error" } },
    //{ 0x809527F0,{ "SCE_SSL_ERROR_ERR_PKCS7_INVALID_ITEM_VALUE",  "protocol error" } },
    //{ 0x809527F1,{ "SCE_SSL_ERROR_ERR_PKCS7_CONTEXT_NOT_COMPLETED",   "protocol error" } },
    //{ 0x809527F2,{ "SCE_SSL_ERROR_ERR_PKCS7_NO_RECEIPT_REQUEST",  "protocol error" } },
    //{ 0x809527F3,{ "SCE_SSL_ERROR_ERR_PKCS7_MISSING_AUTH_ATTRIBUTE",  "protocol error" } },
    //{ 0x809527F4,{ "SCE_SSL_ERROR_ERR_PKCS7_MISMATCH_SIG_HASH_ALGO",  "protocol error" } },
    //{ 0x8095283C,{ "SCE_SSL_ERROR_ERR_PKCS12",    "protocol error" } },
    //{ 0x8095283D,{ "SCE_SSL_ERROR_ERR_PKCS12_WRONG_VERSION",  "protocol error" } },
    //{ 0x8095283E,{ "SCE_SSL_ERROR_ERR_PKCS12_INVALID_STRUCT", "protocol error" } },
    //{ 0x8095283F,{ "SCE_SSL_ERROR_ERR_PKCS12_NOT_EXPECTED_OID",   "protocol error" } },
    //{ 0x80952840,{ "SCE_SSL_ERROR_ERR_PKCS12_PASSWORD_NEEDED",    "protocol error" } },
    //{ 0x80952841,{ "SCE_SSL_ERROR_ERR_PKCS12_INTEGRITY_CHECK_FAILED", "protocol error" } },
    //{ 0x80952842,{ "SCE_SSL_ERROR_ERR_PKCS12_NO_KNOWN_SIGNERS",   "protocol error" } },
    //{ 0x80952843,{ "SCE_SSL_ERROR_ERR_PKCS12_UNSUPPORTED_ALGO",   "protocol error" } },
    //{ 0x80952844,{ "SCE_SSL_ERROR_ERR_PKCS12_UNKNOWN_BAGTYPE",    "protocol error" } },
    //{ 0x80952845,{ "SCE_SSL_ERROR_ERR_PKCS12_INVALID_ENCRYPT_ARG",    "protocol error" } },
    //{ 0x80952846,{ "SCE_SSL_ERROR_ERR_PKCS12_INVALID_PRIVACY_MODE",   "protocol error" } },
    //{ 0x80952847,{ "SCE_SSL_ERROR_ERR_PKCS12_INVALID_INTEGRITY_MODE", "protocol error" } },
    //{ 0x80952848,{ "SCE_SSL_ERROR_ERR_PKCS12_DECRYPT_CALLBACK_NOT_SET",   "protocol error" } },
    //{ 0x80952849,{ "SCE_SSL_ERROR_ERR_PKCS12_NOT_PRINTABLE_PASSWORD", "protocol error" } },
    //{ 0x80952968,{ "SCE_SSL_ERROR_ERR_DER_ENCODER",   "protocol error" } },
    //{ 0x80952969,{ "SCE_SSL_ERROR_ERR_DER_ENCODER_NOT_SERIALIZED",    "protocol error" } },
    //{ 0x8095296A,{ "SCE_SSL_ERROR_ERR_DER_ENCODER_OPAQUE",    "protocol error" } },
    //{ 0x8095296B,{ "SCE_SSL_ERROR_ERR_DER_PARENT_NOT_BER",    "protocol error" } },
    //{ 0x8095296C,{ "SCE_SSL_ERROR_ERR_DER_BER_NOT_TERMINATED",    "protocol error" } },
    //{ 0x80952A94,{ "SCE_SSL_ERROR_ERR_BITMAP",    "protocol error" } },
    //{ 0x80952A95,{ "SCE_SSL_ERROR_ERR_BITMAP_CREATE_FAIL",    "protocol error" } },
    //{ 0x80952A96,{ "SCE_SSL_ERROR_ERR_BITMAP_TABLE_FULL", "protocol error" } },
    //{ 0x80952A97,{ "SCE_SSL_ERROR_ERR_BITMAP_BIT_IS_SET", "protocol error" } },
    //{ 0x80952A98,{ "SCE_SSL_ERROR_ERR_BITMAP_BAD_RANGE",  "protocol error" } },
    //{ 0x80952AF8,{ "SCE_SSL_ERROR_ERR_MEM_PART",  "protocol error" } },
    //{ 0x80952AF9,{ "SCE_SSL_ERROR_ERR_MEM_PART_NULL_PTR", "protocol error" } },
    //{ 0x80952AFA,{ "SCE_SSL_ERROR_ERR_MEM_PART_CREATE",   "protocol error" } },
    //{ 0x80952AFB,{ "SCE_SSL_ERROR_ERR_MEM_PART_BAD_LENGTH",   "protocol error" } },
    //{ 0x80952AFC,{ "SCE_SSL_ERROR_ERR_MEM_PART_ALLOC_FAIL",   "protocol error" } },
    //{ 0x80952AFD,{ "SCE_SSL_ERROR_ERR_MEM_PART_FREE_LIST_DAMAGED",    "protocol error" } },
    //{ 0x80952AFE,{ "SCE_SSL_ERROR_ERR_MEM_PART_BAD_ADDRESS",  "protocol error" } },
    //{ 0x80952B5C,{ "SCE_SSL_ERROR_ERR_TIMER", "protocol error" } },
    //{ 0x80952B5D,{ "SCE_SSL_ERROR_ERR_TIMER_SEMINIT_FAILED",  "protocol error" } },
    //{ 0x80952B5E,{ "SCE_SSL_ERROR_ERR_TIMER_NO_CALLBACKFN",   "protocol error" } },
    //{ 0x80952B5F,{ "SCE_SSL_ERROR_ERR_TIMER_INVALID_TIMEOUT", "protocol error" } },
    //{ 0x80952B60,{ "SCE_SSL_ERROR_ERR_TIMER_NO_CONTBL",   "protocol error" } },
    //{ 0x80952B61,{ "SCE_SSL_ERROR_ERR_TIMER_INVALID_TIMER",   "protocol error" } },
    //{ 0x80952B62,{ "SCE_SSL_ERROR_ERR_TIMER_TIMERS_IN_USE",   "protocol error" } },
    //{ 0x80952BC0,{ "SCE_SSL_ERROR_ERR_ID",    "protocol error" } },
    //{ 0x80952BC1,{ "SCE_SSL_ERROR_ERR_ID_CREATE_MAP_FAILED",  "protocol error" } },
    //{ 0x80952BC2,{ "SCE_SSL_ERROR_ERR_ID_ADD_RANGE_FAILED",   "protocol error" } },
    //{ 0x80952BC3,{ "SCE_SSL_ERROR_ERR_ID_ALLOC_FAILED",   "protocol error" } },
    //{ 0x80952BC4,{ "SCE_SSL_ERROR_ERR_ID_INIT_FAILED",    "protocol error" } },
    //{ 0x80952C24,{ "SCE_SSL_ERROR_ERR_RBTREE",    "protocol error" } },
    //{ 0x80952C25,{ "SCE_SSL_ERROR_ERR_RBTREE_INSERT_FAILED",  "protocol error" } },
    //{ 0x80952C26,{ "SCE_SSL_ERROR_ERR_RBTREE_DUPLICATE_NODE", "protocol error" } },
    //{ 0x80952C27,{ "SCE_SSL_ERROR_ERR_RBTREE_CREATE_FAILED",  "protocol error" } },
    //{ 0x809532C8,{ "SCE_SSL_ERROR_ERR_PKCS5", "protocol error" } },
    //{ 0x809532C9,{ "SCE_SSL_ERROR_ERR_PKCS5_BAD_ITERATION_COUNT", "protocol error" } },
    //{ 0x809532CA,{ "SCE_SSL_ERROR_ERR_PKCS5_INVALID_HASH_FUNCTION",   "protocol error" } },
    //{ 0x809532CB,{ "SCE_SSL_ERROR_ERR_PKCS5_DKLEN_TOO_LONG",  "protocol error" } },
    //{ 0x809532CC,{ "SCE_SSL_ERROR_ERR_PKCS5_DKLEN_TOO_SHORT", "protocol error" } },
    //{ 0x80953390,{ "SCE_SSL_ERROR_ERR_INTHASH",   "protocol error" } },
    //{ 0x80953391,{ "SCE_SSL_ERROR_ERR_INTHASH_BAD_TYPE",  "protocol error" } },
    //{ 0x80953392,{ "SCE_SSL_ERROR_ERR_INTHASH_BAD_OFFSET",    "protocol error" } },
    //{ 0x80953393,{ "SCE_SSL_ERROR_ERR_INTHASH_BAD_TABLE", "protocol error" } },
    //{ 0x80953394,{ "SCE_SSL_ERROR_ERR_INTHASH_ELEM_NOT_FOUND",    "protocol error" } },
    //{ 0x80953395,{ "SCE_SSL_ERROR_ERR_INTHASH_MUTEX_INIT",    "protocol error" } },
    //{ 0x80953396,{ "SCE_SSL_ERROR_ERR_INTHASH_BAD_TABLEIDX",  "protocol error" } },
    //{ 0x809533F4,{ "SCE_SSL_ERROR_ERR_STRHASH",   "protocol error" } },
    //{ 0x809533F5,{ "SCE_SSL_ERROR_ERR_STRHASH_NODE_NOT_FOUND",    "protocol error" } },
    //{ 0x809533F6,{ "SCE_SSL_ERROR_ERR_STRHASH_NODE_EXISTS",   "protocol error" } },
    //{ 0x809533F7,{ "SCE_SSL_ERROR_ERR_STRHASH_NULL_DATUM",    "protocol error" } },
    //{ 0x809533F8,{ "SCE_SSL_ERROR_ERR_STRHASH_INVALID_FUNC",  "protocol error" } },
    //{ 0x809533F9,{ "SCE_SSL_ERROR_ERR_STRHASH_NOTEMPTY",  "protocol error" } },
    //{ 0x809533FA,{ "SCE_SSL_ERROR_ERR_STRHASH_NOMATCH",   "protocol error" } },
    //{ 0x809534BC,{ "SCE_SSL_ERROR_ERR_CERT_STORE",    "protocol error" } },
    //{ 0x809534BD,{ "SCE_SSL_ERROR_ERR_CERT_STORE_UNKNOWN_KEY_TYPE",   "protocol error" } },
    //{ 0x809534BE,{ "SCE_SSL_ERROR_ERR_CERT_STORE_CERT_KEY_MISMATCH",  "protocol error" } },
    //{ 0x809534BF,{ "SCE_SSL_ERROR_ERR_CERT_STORE_LOCKED_STORE",   "protocol error" } },
    //{ 0x809534C0,{ "SCE_SSL_ERROR_ERR_CERT_STORE_UNSUPPORTED_SIGNALGO",   "protocol error" } },
    //{ 0x809534C1,{ "SCE_SSL_ERROR_ERR_CERT_STORE_UNSUPPORTED_ECCURVE",    "protocol error" } },
    //{ 0x80953520,{ "SCE_SSL_ERROR_ERR_HASH_VALUE",    "protocol error" } },
    //{ 0x80953584,{ "SCE_SSL_ERROR_ERR_HASH_TABLE",    "protocol error" } },
    //{ 0x80953585,{ "SCE_SSL_ERROR_ERR_HASH_TABLE_BAD_SIZE",   "protocol error" } },
    //{ 0x809535E8,{ "SCE_SSL_ERROR_ERR_SOCKET",    "protocol error" } },
    //{ 0x809535E9,{ "SCE_SSL_ERROR_ERR_SOCKET_NULL_REPLY", "protocol error" } },
    //{ 0x809535EA,{ "SCE_SSL_ERROR_ERR_SOCKET_INVALID_LEN",    "protocol error" } },
    //{ 0x809535EB,{ "SCE_SSL_ERROR_ERR_SOCKET_INVALID_MSG",    "protocol error" } },
    //{ 0x809535EC,{ "SCE_SSL_ERROR_ERR_SOCKET_NULL_PARAMS",    "protocol error" } },
    //{ 0x80953778,{ "SCE_SSL_ERROR_ERR_DEBUG_CONSOLE", "protocol error" } },
    //{ 0x80953779,{ "SCE_SSL_ERROR_ERR_DEBUG_CONSOLE_CHANNEL", "protocol error" } },
    //{ 0x809538A4,{ "SCE_SSL_ERROR_ERR_REDBLACK",  "protocol error" } },
    //{ 0x809538A5,{ "SCE_SSL_ERROR_ERR_REDBLACK_NULL_DATUM",   "protocol error" } },
    //{ 0x80953908,{ "SCE_SSL_ERROR_ERR_CIRCQ", "protocol error" } },
    //{ 0x80953909,{ "SCE_SSL_ERROR_ERR_CIRCQ_FULL",    "protocol error" } },
    //{ 0x8095390A,{ "SCE_SSL_ERROR_ERR_CIRCQ_EMPTY",   "protocol error" } },
    //{ 0x809539D0,{ "SCE_SSL_ERROR_ERR_MOC_IPV4_ERROR",    "protocol error" } },
    //{ 0x80953A34,{ "SCE_SSL_ERROR_ERR_CC_CRAWL",  "protocol error" } },
    //{ 0x80953A35,{ "SCE_SSL_ERROR_ERR_CC_CRAWL_PAST_END_BUFFER",  "protocol error" } },
    //{ 0x80953A98,{ "SCE_SSL_ERROR_ERR_OCSP",  "protocol error" } },
    //{ 0x80953A99,{ "SCE_SSL_ERROR_ERR_OCSP_MISSING_SIGNER_CERT",  "protocol error" } },
    //{ 0x80953A9A,{ "SCE_SSL_ERROR_ERR_OCSP_MISSING_SIGNER_KEY",   "protocol error" } },
    //{ 0x80953A9B,{ "SCE_SSL_ERROR_ERR_OCSP_MISSING_ISSUER_CERT",  "protocol error" } },
    //{ 0x80953A9C,{ "SCE_SSL_ERROR_ERR_OCSP_INVALID_STRUCT",   "protocol error" } },
    //{ 0x80953A9D,{ "SCE_SSL_ERROR_ERR_OCSP_MISSING_SIGNATURE",    "protocol error" } },
    //{ 0x80953A9E,{ "SCE_SSL_ERROR_ERR_OCSP_INVALID_SIGNATURE",    "protocol error" } },
    //{ 0x80953A9F,{ "SCE_SSL_ERROR_ERR_OCSP_RESPONDER_CHECK",  "protocol error" } },
    //{ 0x80953AA0,{ "SCE_SSL_ERROR_ERR_OCSP_UNKNOWN_RESPONSE_STATUS",  "protocol error" } },
    //{ 0x80953AA1,{ "SCE_SSL_ERROR_ERR_OCSP_UNSUPPORTED_RESPONSE_TYPE",    "protocol error" } },
    //{ 0x80953AA2,{ "SCE_SSL_ERROR_ERR_OCSP_MISSING_RSIGNER_CERTS",    "protocol error" } },
    //{ 0x80953AA3,{ "SCE_SSL_ERROR_ERR_OCSP_INIT_FAIL",    "protocol error" } },
    //{ 0x80953AA4,{ "SCE_SSL_ERROR_ERR_OCSP_ILLEGAL_STATE",    "protocol error" } },
    //{ 0x80953AA5,{ "SCE_SSL_ERROR_ERR_OCSP_NO_MORE_RESPONSE", "protocol error" } },
    //{ 0x80953AA6,{ "SCE_SSL_ERROR_ERR_OCSP_BAD_ALGO", "protocol error" } },
    //{ 0x80953AA7,{ "SCE_SSL_ERROR_ERR_OCSP_EXPIRED_RESPONSE", "protocol error" } },
    //{ 0x80953AA8,{ "SCE_SSL_ERROR_ERR_OCSP_NONCE_CHECK_FAIL", "protocol error" } },
    //{ 0x80953AA9,{ "SCE_SSL_ERROR_ERR_OCSP_BAD_REQUEST",  "protocol error" } },
    //{ 0x80953AAA,{ "SCE_SSL_ERROR_ERR_OCSP_INVALID_INPUT",    "protocol error" } },
    //{ 0x80953AAB,{ "SCE_SSL_ERROR_ERR_OCSP_BAD_AIA",  "protocol error" } },
    //{ 0x80953AAC,{ "SCE_SSL_ERROR_ERR_OCSP_REQUEST_RESPONSE_MISMATCH",    "protocol error" } },
    //{ 0x80953AAD,{ "SCE_SSL_ERROR_ERR_OCSP_FIND_PEER_ADDR_FAILED",    "protocol error" } },
    //{ 0x80953AAE,{ "SCE_SSL_ERROR_ERR_OCSP_RESPONDER_CONNECT_FAILED", "protocol error" } },
    //{ 0x80953CF0,{ "SCE_SSL_ERROR_ERR_OTP",   "protocol error" } },
    //{ 0x80953CF1,{ "SCE_SSL_ERROR_ERR_OTP_INVALID_CHALLENGE", "protocol error" } },
    //{ 0x80953CF2,{ "SCE_SSL_ERROR_ERR_OTP_INVALID_ALGORITHM", "protocol error" } },
    //{ 0x80953CF3,{ "SCE_SSL_ERROR_ERR_OTP_UNSUPPORTED_ALGORITHM", "protocol error" } },
    //{ 0x80953CF4,{ "SCE_SSL_ERROR_ERR_OTP_INVALID_SEED",  "protocol error" } },
    //{ 0x80953E80,{ "SCE_SSL_ERROR_ERR_MTLS",  "protocol error" } },
    //{ 0x80953E81,{ "SCE_SSL_ERROR_ERR_MTLS_BAD_PAYLOAD_LENGTH",   "protocol error" } },
    //{ 0x80953E82,{ "SCE_SSL_ERROR_ERR_MTLS_UNKNOWN_MESSAGE_TYPE", "protocol error" } },
    //{ 0x80953E83,{ "SCE_SSL_ERROR_ERR_MTLS_FIND_CHANNEL_RECEIVER_FAILED", "protocol error" } },
    //{ 0x80953E84,{ "SCE_SSL_ERROR_ERR_MTLS_BAD_CALLBACK_CONFIG",  "protocol error" } },
    //{ 0x80953EE4,{ "SCE_SSL_ERROR_ERR_PKI",   "protocol error" } },
    //{ 0x80953F48,{ "SCE_SSL_ERROR_ERR_CMP",   "protocol error" } },
    //{ 0x80953F49,{ "SCE_SSL_ERROR_ERR_CMP_INVALID_CONTEXT",   "protocol error" } },
    //{ 0x80953F4A,{ "SCE_SSL_ERROR_ERR_CMP_INVALID_PARAMETER", "protocol error" } },
    //{ 0x80953F4B,{ "SCE_SSL_ERROR_ERR_CMP_INVALID_VERSION",   "protocol error" } },
    //{ 0x80953F4C,{ "SCE_SSL_ERROR_ERR_CMP_INVALID_IP_RESPONSE",   "protocol error" } },
    //{ 0x80953F4D,{ "SCE_SSL_ERROR_ERR_CMP_ALGORITHM_NOT_SUPPORTED",   "protocol error" } },
    //{ 0x80953F4E,{ "SCE_SSL_ERROR_ERR_CMP_MISSING_TRANSACTION_ID",    "protocol error" } },
    //{ 0x80953F4F,{ "SCE_SSL_ERROR_ERR_CMP_MISSING_RECIPIENT_NONCE",   "protocol error" } },
    //{ 0x80953F50,{ "SCE_SSL_ERROR_ERR_CMP_INVALID_STATE", "protocol error" } },
    //{ 0x80953F51,{ "SCE_SSL_ERROR_ERR_CMP_SUBJECT_NAME_REQUIRED", "protocol error" } },
    //{ 0x80953F52,{ "SCE_SSL_ERROR_ERR_CMP_KEY_REQUIRED",  "protocol error" } },
    //{ 0x80953F53,{ "SCE_SSL_ERROR_ERR_CMP_CERTIFICATE_NOT_FOUND", "protocol error" } },
    //{ 0x80953F54,{ "SCE_SSL_ERROR_ERR_CMP_POPTYPE_MISMATCH",  "protocol error" } },
    //{ 0x80953F55,{ "SCE_SSL_ERROR_ERR_CMP_INVALID_CALL_FOR_CERT", "protocol error" } },
    //{ 0x80953F56,{ "SCE_SSL_ERROR_ERR_CMP_INVALID_CALL_FOR_STATUS",   "protocol error" } },
    //{ 0x80953F57,{ "SCE_SSL_ERROR_ERR_CMP_MISSING_CREDENTIALS",   "protocol error" } },
    //{ 0x80953F58,{ "SCE_SSL_ERROR_ERR_CMP_RESPONSE_TYPE_MISMATCH",    "protocol error" } },
    //{ 0x80953F59,{ "SCE_SSL_ERROR_ERR_CMP_SENDER_KID",    "protocol error" } },
    //{ 0x80953F5A,{ "SCE_SSL_ERROR_ERR_CMP_PROTECTION_ERROR",  "protocol error" } },
    //{ 0x80953F5B,{ "SCE_SSL_ERROR_ERR_CMP_NAME_MISMATCH", "protocol error" } },
    //{ 0x80953F5C,{ "SCE_SSL_ERROR_ERR_CMP_TRANSACTION_ID_MISMATCH",   "protocol error" } },
    //{ 0x80953F5D,{ "SCE_SSL_ERROR_ERR_CMP_RECIPIENT_NONCE_MISMATCH",  "protocol error" } },
    //{ 0x80953FAC,{ "SCE_SSL_ERROR_ERR_CRMF",  "protocol error" } },
    //{ 0x80953FAD,{ "SCE_SSL_ERROR_ERR_CRMF_MISSING_SIGNER_KEY",   "protocol error" } },
    //{ 0x80953FAE,{ "SCE_SSL_ERROR_ERR_CRMF_INVALID_ARG",  "protocol error" } },
    //{ 0x80954074,{ "SCE_SSL_ERROR_ERR_FIPS",  "protocol error" } },
    //{ 0x80954075,{ "SCE_SSL_ERROR_ERR_FIPS_DSA_FAIL", "protocol error" } },
    //{ 0x80954076,{ "SCE_SSL_ERROR_ERR_FIPS_DSA_SIGN_VERIFY_FAIL", "protocol error" } },
    //{ 0x80954077,{ "SCE_SSL_ERROR_ERR_FIPS_ECDSA_FAIL",   "protocol error" } },
    //{ 0x80954078,{ "SCE_SSL_ERROR_ERR_FIPS_ECDSA_SIGN_VERIFY_FAIL",   "protocol error" } },
    //{ 0x80954079,{ "SCE_SSL_ERROR_ERR_FIPS_RSA_FAIL", "protocol error" } },
    //{ 0x8095407A,{ "SCE_SSL_ERROR_ERR_FIPS_RSA_SIGN_VERIFY_FAIL", "protocol error" } },
    //{ 0x8095407B,{ "SCE_SSL_ERROR_ERR_FIPS_RNG_FAIL", "protocol error" } },
    //{ 0x8095407C,{ "SCE_SSL_ERROR_ERR_FIPS_SELF_TEST_INCOMPLETE", "protocol error" } },
    //{ 0x8095407D,{ "SCE_SSL_ERROR_ERR_FIPS_RNG_KAT",  "protocol error" } },
    //{ 0x8095407E,{ "SCE_SSL_ERROR_ERR_FIPS_HASH_KAT_NULL",    "protocol error" } },
    //{ 0x8095407F,{ "SCE_SSL_ERROR_ERR_FIPS_HASH_KAT_FAILED",  "protocol error" } },
    //{ 0x80954080,{ "SCE_SSL_ERROR_ERR_FIPS_HASH_KAT_LEN_FAILED",  "protocol error" } },
    //{ 0x80954081,{ "SCE_SSL_ERROR_ERR_FIPS_HMAC_HASH_KAT_NULL",   "protocol error" } },
    //{ 0x80954082,{ "SCE_SSL_ERROR_ERR_FIPS_HMAC_HASH_KAT_FAILED", "protocol error" } },
    //{ 0x80954083,{ "SCE_SSL_ERROR_ERR_FIPS_HMAC_HASH_KAT_LEN_FAILED", "protocol error" } },
    //{ 0x80954084,{ "SCE_SSL_ERROR_ERR_FIPS_SYM_KAT_NULL", "protocol error" } },
    //{ 0x80954085,{ "SCE_SSL_ERROR_ERR_FIPS_SYM_KAT_FAILED",   "protocol error" } },
    //{ 0x80954086,{ "SCE_SSL_ERROR_ERR_FIPS_SYM_KAT_LEN_FAILED",   "protocol error" } },
    //{ 0x80954087,{ "SCE_SSL_ERROR_ERR_FIPS_RSA_PCT_FAILED",   "protocol error" } },
    //{ 0x80954088,{ "SCE_SSL_ERROR_ERR_FIPS_ECDSA_PCT_FAILED", "protocol error" } },
    //{ 0x80954089,{ "SCE_SSL_ERROR_ERR_FIPS_ECDH_PCT_FAILED",  "protocol error" } },
    //{ 0x8095408A,{ "SCE_SSL_ERROR_ERR_FIPS_DH_PCT_FAILED",    "protocol error" } },
    //{ 0x8095408B,{ "SCE_SSL_ERROR_ERR_FIPS_INTEGRITY_FAILED", "protocol error" } },
    //{ 0x8095408C,{ "SCE_SSL_ERROR_ERR_FIPS_NISTRNG_KAT_FAILED",   "protocol error" } },
    //{ 0x8095408D,{ "SCE_SSL_ERROR_ERR_FIPS_CTRDRBG_FAIL", "protocol error" } },
    //{ 0x8095408E,{ "SCE_SSL_ERROR_ERR_FIPS_ECDRBG_FAIL",  "protocol error" } },
    //{ 0x8095413C,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT",    "protocol error" } },
    //{ 0x8095413D,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_REQUEST_TIMEOUT",    "protocol error" } },
    //{ 0x8095413E,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_CERT_REVOKED",   "protocol error" } },
    //{ 0x8095413F,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_CERT_EXPIRED",   "protocol error" } },
    //{ 0x80954140,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_CDPS_MISSING",   "protocol error" } },
    //{ 0x80954141,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_ISSUER_INVALID", "protocol error" } },
    //{ 0x80954142,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_ISSUER_EXPIRED", "protocol error" } },
    //{ 0x80954143,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_ISSUER_MISSING", "protocol error" } },
    //{ 0x80954144,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_CERT_PATH",  "protocol error" } },
    //{ 0x80954145,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_CRL_NOT_AVAILABLE",  "protocol error" } },
    //{ 0x80954146,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_TOO_MANY_REQUESTS",  "protocol error" } },
    //{ 0x80954147,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_PENDING_CERTPATH_CHECK", "protocol error" } },
    //{ 0x80954148,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_PENDING_CRL_CHECK",  "protocol error" } },
    //{ 0x80954149,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_INVALID_CALLBACK_TYPE",  "protocol error" } },
    //{ 0x8095414A,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_NOT_FOUND",  "protocol error" } },
    //{ 0x8095414B,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_INVALID_ARGUMENT",   "protocol error" } },
    //{ 0x8095414C,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_PROFILE_FAILURE",    "protocol error" } },
    //{ 0x8095414D,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_NO_SUCH_SESSION",    "protocol error" } },
    //{ 0x8095414E,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_TOO_MANY_SESSIONS",  "protocol error" } },
    //{ 0x8095414F,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_CRL_SIGNATURE_VERIFICATION", "protocol error" } },
    //{ 0x80954150,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_MISSING_CA_URL_INFO",    "protocol error" } },
    //{ 0x80954151,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_MISSING_CERT_URL_INFO",  "protocol error" } },
    //{ 0x80954152,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_WRONG_CERTTYPE", "protocol error" } },
    //{ 0x80954153,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_DB_INIT",    "protocol error" } },
    //{ 0x80954154,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_DB_CREATE",  "protocol error" } },
    //{ 0x80954155,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_DB_TXN_FAILED",  "protocol error" } },
    //{ 0x80954156,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_DB_EXTND_CERT_NOT_FOUND",    "protocol error" } },
    //{ 0x80954157,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_DB_EXTND_CERT_ADD_FAILED",   "protocol error" } },
    //{ 0x80954158,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_DB_EXTND_CERT_DEL_FAILED",   "protocol error" } },
    //{ 0x80954159,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_DB_TMP_KEY_ADD_FAILED",  "protocol error" } },
    //{ 0x8095415A,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_DB_CERT_ADD_FAILED", "protocol error" } },
    //{ 0x8095415B,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_DB_CERT_NOT_FOUND",  "protocol error" } },
    //{ 0x8095415C,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_DB_CERT_DEL_FAILED", "protocol error" } },
    //{ 0x8095415D,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_DB_CDP_ENTRY_ADD_FAILED",    "protocol error" } },
    //{ 0x8095415E,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_DB_CDP_ENTRY_NOT_FOUND", "protocol error" } },
    //{ 0x8095415F,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_DB_CRL_NOT_FOUND",   "protocol error" } },
    //{ 0x80954160,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_DB_URL_ADD_FAILED",  "protocol error" } },
    //{ 0x80954161,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_DB_URL_NOT_FOUND",   "protocol error" } },
    //{ 0x80954162,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_DB_CRL_TRUNCATE_FAILED", "protocol error" } },
    //{ 0x80954163,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_DB_CERT_SNO_NOT_FOUND",  "protocol error" } },
    //{ 0x80954164,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_DB_FG_TO_BG_MSG_FAILED", "protocol error" } },
    //{ 0x80954165,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_DB_BG_TO_FG_MSG_FAILED", "protocol error" } },
    //{ 0x80954166,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_DB_EXTND_CERT_SESINST_NOT_FOUND",    "protocol error" } },
    //{ 0x80954178,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_DB_EXTND_CERT_SESINST_CUR_FAILED",   "protocol error" } },
    //{ 0x80954179,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_DB_CERT_ISSUER_CUR_FAILED",  "protocol error" } },
    //{ 0x8095417A,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_DB_CERT_SNO_CUR_FAILED", "protocol error" } },
    //{ 0x8095417B,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_DB_CRL_ISSUER_CUR_FAILED",   "protocol error" } },
    //{ 0x8095417C,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_DB_CRL_SNO_CUR_FAILED",  "protocol error" } },
    //{ 0x8095417D,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_DB_URL_CUR_FAILED",  "protocol error" } },
    //{ 0x8095417E,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_DB_CDP_ENTRY_CUR_FAILED",    "protocol error" } },
    //{ 0x8095417F,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_CRL_PARSE_ERROR",    "protocol error" } },
    //{ 0x80954180,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_NO_RESULT_OBTAINED", "protocol error" } },
    //{ 0x80954181,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_CERT_NOT_AVAILABLE", "protocol error" } },
    //{ 0x80954182,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_TOO_MANY_FOREGROUND_PROCESS",    "protocol error" } },
    //{ 0x80954183,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_FOREGROUND_PROCESS_NOT_FOUND",   "protocol error" } },
    //{ 0x80954184,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_FOREGROUND_FAILED_TO_REGISTER",  "protocol error" } },
    //{ 0x80954185,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_BACKGROUND_NOT_READY",   "protocol error" } },
    //{ 0x80954186,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_SET_CRL_CHECKING_MODE_FAILED",   "protocol error" } },
    //{ 0x80954187,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_UNEXPECTED_ASN1_STRUCTURE",  "protocol error" } },
    //{ 0x80954188,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_STALE_CRL_RECEIVED", "protocol error" } },
    //{ 0x80954189,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_PENDING_OCSP_CHECK", "protocol error" } },
    //{ 0x8095418A,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_OCSP_INVALID",   "protocol error" } },
    //{ 0x8095418B,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_OCSP_STATUS_UNKNOWN",    "protocol error" } },
    //{ 0x8095418C,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_OCSP_RESPONSE",  "protocol error" } },
    //{ 0x8095418D,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_OCSP_SIGNING_CERT_INFO_MISSING", "protocol error" } },
    //{ 0x8095418E,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_OCSP_RESPONDER_URL_MISSING", "protocol error" } },
    //{ 0x8095418F,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_PRIVATE_KEY_NOT_FOUND",  "protocol error" } },
    //{ 0x80954190,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_SCEP_RENEW_CERT_NOT_SUPPORTED",  "protocol error" } },
    //{ 0x80954191,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_SCEP_MAX_POLL_RETRY_COUNT_RCHD", "protocol error" } },
    //{ 0x80954192,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_CRL_CHECKING_DISABLED",  "protocol error" } },
    //{ 0x80954193,{ "SCE_SSL_ERROR_ERR_PKI_CLIENT_SCEP_NO_HTTP_RESP_CONTENT",  "protocol error" } },
    //{ 0x809541A0,{ "SCE_SSL_ERROR_ERR_STACK", "protocol error" } },
    //{ 0x809541A1,{ "SCE_SSL_ERROR_ERR_STACK_UNDERFLOW",   "protocol error" } },
    //{ 0x809541A2,{ "SCE_SSL_ERROR_ERR_STACK_OVERFLOW",    "protocol error" } },
    //{ 0x80954204,{ "SCE_SSL_ERROR_ERR_INSTANCE",  "protocol error" } },
    //{ 0x80954205,{ "SCE_SSL_ERROR_ERR_INSTANCE_TABLE_TOO_BIG",    "protocol error" } },
    //{ 0x80954206,{ "SCE_SSL_ERROR_ERR_INSTANCE_BAD_ID",   "protocol error" } },
    //{ 0x80954207,{ "SCE_SSL_ERROR_ERR_INSTANCE_CLOSED",   "protocol error" } },
    //{ 0x80954208,{ "SCE_SSL_ERROR_ERR_INSTANCE_STALE_ID", "protocol error" } },
    //{ 0x80954209,{ "SCE_SSL_ERROR_ERR_INSTANCE_FREE_LIST_EMPTY",  "protocol error" } },
    //{ 0x8095420A,{ "SCE_SSL_ERROR_ERR_INSTANCE_PASSED_END_LIST_REACHED",  "protocol error" } },
    //{ 0x809542CC,{ "SCE_SSL_ERROR_ERR_NIST_KDF",  "protocol error" } },
    //{ 0x809542CD,{ "SCE_SSL_ERROR_ERR_NIST_KDF_INVALID_COUNTER_SIZE", "protocol error" } },
    //{ 0x809542CE,{ "SCE_SSL_ERROR_ERR_NIST_KDF_COUNTER_KEY_SIZES",    "protocol error" } },
    //{ 0x80954330,{ "SCE_SSL_ERROR_ERR_NIST_RNG",  "protocol error" } },
    //{ 0x80954331,{ "SCE_SSL_ERROR_ERR_NIST_RNG_HASH_DF_BAD_OUTPUT_LEN",   "protocol error" } },
    //{ 0x80954332,{ "SCE_SSL_ERROR_ERR_NIST_RNG_UNSUPPORTED_CURVE",    "protocol error" } },
    //{ 0x80954333,{ "SCE_SSL_ERROR_ERR_NIST_RNG_EC_DRBG_ARG_TOO_LONG", "protocol error" } },
    //{ 0x80954334,{ "SCE_SSL_ERROR_ERR_NIST_RNG_EC_DBRG_INVALID_HASH_ID",  "protocol error" } },
    //{ 0x80954335,{ "SCE_SSL_ERROR_ERR_NIST_RNG_DBRG_RESEED_NEEDED",   "protocol error" } },
    //{ 0x80954336,{ "SCE_SSL_ERROR_ERR_NIST_RNG_BLOCK_CIPHER_DF_BAD_OUTPUT_LEN",   "protocol error" } },
    //{ 0x80954337,{ "SCE_SSL_ERROR_ERR_NIST_RNG_CTR_INVALID_KEY_LENGTH",   "protocol error" } },
    //{ 0x80954338,{ "SCE_SSL_ERROR_ERR_NIST_RNG_CTR_INVALID_OUTPUT_LENGTH",    "protocol error" } },
    //{ 0x80954339,{ "SCE_SSL_ERROR_ERR_NIST_RNG_DRBG_TOO_MANY_BITS",   "protocol error" } },
    //{ 0x8095433A,{ "SCE_SSL_ERROR_ERR_NIST_RNG_CTR_BAD_ENTROPY_INPUT_LEN",    "protocol error" } },
    //{ 0x8095433B,{ "SCE_SSL_ERROR_ERR_NIST_RNG_EC_ENTROPY_OR_NONCE_TOO_SHORT",    "protocol error" } },
    //{ 0x8095433C,{ "SCE_SSL_ERROR_ERR_NIST_RNG_CTR_BAD_PERSO_STR_LEN",    "protocol error" } },
    //{ 0x809543F8,{ "SCE_SSL_ERROR_ERR_XML_PARSE_NO_BEGIN_TAG",    "protocol error" } },
    //{ 0x809543F9,{ "SCE_SSL_ERROR_ERR_XML_PARSE_NO_END_TAG",  "protocol error" } },
    //{ 0x809543FA,{ "SCE_SSL_ERROR_ERR_XML_PARSE_END_TAG_TOO_EARLY",   "protocol error" } },
    //{ 0x809543FB,{ "SCE_SSL_ERROR_ERR_XML_PARSE_VALUE_NOT_FOUND", "protocol error" } },
    //{ 0x8095445C,{ "SCE_SSL_ERROR_ERR_LWIP_UNSUPPORTED_FUNCTION", "protocol error" } },
    //{ 0x809544C0,{ "SCE_SSL_ERROR_ERR_ENTROPY_UNINITIALIZED", "protocol error" } },
    //{ 0x80954524,{ "SCE_SSL_ERROR_ERR_GARBAGE_COLLECTOR", "internal error" } },
    //{ 0x80954525,{ "SCE_SSL_ERROR_ERR_GARBAGE_COLLECTOR_BADMODID",    "internal error" } },
    //{ 0x80954526,{ "SCE_SSL_ERROR_ERR_GARBAGE_COLLECTOR_BADID",   "internal error" } },
    //{ 0x80954527,{ "SCE_SSL_ERROR_ERR_GARBAGE_COLLECTOR_MODIDNOTREGISTERED",  "internal error" } },
    //{ 0x80954528,{ "SCE_SSL_ERROR_ERR_GARBAGE_COLLECTOR_INVALID_ARGS",    "internal error" } },
    //{ 0x80954529,{ "SCE_SSL_ERROR_ERR_GARBAGE_COLLECTOR_RESOURCE_NOT_FOUND",  "internal error" } },
    //{ 0x8095452A,{ "SCE_SSL_ERROR_ERR_GARBAGE_COLLECTOR_AGAINMODIDREG",   "internal error" } },
    //{ 0x8095F001,{ "SCE_SSL_ERROR_BEFORE_INIT",   "Library not initialized" } },
    //{ 0x8095F002,{ "SCE_SSL_ERROR_ALREADY_INITED",    "Library has already been initialized" } },
    //{ 0x8095F003,{ "SCE_SSL_ERROR_BROKEN",    "Specified data is broken" } },
    //{ 0x8095F004,{ "SCE_SSL_ERROR_NOT_FOUND", "Could not find specified element" } },
    //{ 0x8095F005,{ "SCE_SSL_ERROR_INVALID_FORMAT",    "The format of the specified parameter was not appropriate" } },
    //{ 0x8095F006,{ "SCE_SSL_ERROR_INVALID_ID",    "Specified ID was not appropriate" } },
    //{ 0x8095F007,{ "SCE_SSL_ERROR_INVALID_VALUE", "Specified parameter was not appropriate" } },
    //{ 0x8095F008,{ "SCE_SSL_ERROR_OUT_OF_SIZE",   "The size is out of predefined range" } },
    //{ 0x8095F009,{ "SCE_SSL_ERROR_INTERNAL",  "Unknown error" } },
    //{ 0x8095F00A,{ "SCE_SSL_ERROR_INVALID_CERT",  "Invalid certificate is specified" } },
    //{ 0x8095F00B,{ "SCE_SSL_ERROR_CN_CHECK",  "Common name check of server certificate failed" } },
    //{ 0x8095F00C,{ "SCE_SSL_ERROR_UNKNOWN_CA",    "Does not have certificate of RootCA that issued server certificate" } },
    //{ 0x8095F00D,{ "SCE_SSL_ERROR_NOT_AFTER_CHECK",   "certificate validity period expired" } },
    //{ 0x8095F00E,{ "SCE_SSL_ERROR_NOT_BEFORE_CHECK",  "Before certificate validity period" } },
    //{ 0x8095F00F,{ "SCE_SSL_ERROR_EAGAIN",    "Socket is in blocking state" } },
    //{ 0x8095F010,{ "SCE_SSL_ERROR_FATAL_ALERT",   "Received a fatal alert message from server" } },
    //{ 0x8095F011,{ "SCE_SSL_ERROR_PROHIBITED",    "called API with prohibited options" } },
    //{ 0x8095F012,{ "SCE_SSL_ERROR_BUSY",  "The requested operation is busy" } },
    //{ 0x80960001,{ "SCE_USER_SERVICE_ERROR_INTERNAL", "Internal error" } },
    //{ 0x80960002,{ "SCE_USER_SERVICE_ERROR_NOT_INITIALIZED",  "Not initialized" } },
    //{ 0x80960003,{ "SCE_USER_SERVICE_ERROR_ALREADY_INITIALIZED",  "Already initialized" } },
    //{ 0x80960004,{ "SCE_USER_SERVICE_ERROR_NO_MEMORY",    "Cannot allocate memory" } },
    //{ 0x80960005,{ "SCE_USER_SERVICE_ERROR_INVALID_ARGUMENT", "Invalid argument" } },
    //{ 0x80960006,{ "SCE_USER_SERVICE_ERROR_OPERATION_NOT_SUPPORTED",  "Operation not supported" } },
    //{ 0x80960007,{ "SCE_USER_SERVICE_ERROR_NO_EVENT", "No events are available" } },
    //{ 0x80960009,{ "SCE_USER_SERVICE_ERROR_NOT_LOGGED_IN",    "Not logged in" } },
    //{ 0x8096000A,{ "SCE_USER_SERVICE_ERROR_BUFFER_TOO_SHORT", "Insufficient buffer space to store information." } },
    //{ 0x80990008,{ "SCE_BGFT_ERROR_INTERNAL", "Internal error occurred" } },
    //{ 0x80990045,{ "SCE_BGFT_ERROR_HTTP_NOT_CONNECTED",   "Network connection error (runtime error)" } },
    //{ 0x80991400,{ "SCE_BGFT_ERROR_HTTP_STATUS_CODE_400_BAD_REQUEST", "An error occurred on the server. (HTTP status code: 400)" } },
    //{ 0x80991401,{ "SCE_BGFT_ERROR_HTTP_STATUS_CODE_401_UNAUTHORIZED",    "An error occurred on the server. (HTTP status code: 401)" } },
    //{ 0x80991402,{ "SCE_BGFT_ERROR_HTTP_STATUS_CODE_402_PAYMENT_REQUIRED",    "An error occurred on the server. (HTTP status code: 402)" } },
    //{ 0x80991403,{ "SCE_BGFT_ERROR_HTTP_STATUS_CODE_403_FORBIDDEN",   "An error occurred on the server. (HTTP status code: 403)" } },
    //{ 0x80991404,{ "SCE_BGFT_ERROR_HTTP_STATUS_CODE_404_NOT_FOUND",   "An error occurred on the server. (HTTP status code: 404)" } },
    //{ 0x80991405,{ "SCE_BGFT_ERROR_HTTP_STATUS_CODE_405_METHOD_NOT_ALLOWED",  "An error occurred on the server. (HTTP status code: 405)" } },
    //{ 0x80991500,{ "SCE_BGFT_ERROR_HTTP_STATUS_CODE_500_INTERNAL_SERVER_ERROR",   "An internal error occurred on the server. (HTTP status code: 500)" } },
    //{ 0x80991501,{ "SCE_BGFT_ERROR_HTTP_STATUS_CODE_501_NOT_IMPLEMENTED", "An error occurred on the server. (HTTP status code: 501)" } },
    //{ 0x80991502,{ "SCE_BGFT_ERROR_HTTP_STATUS_CODE_502_BAD_GATEWAY", "An error occurred on the server. (HTTP status code: 502)" } },
    //{ 0x80991503,{ "SCE_BGFT_ERROR_HTTP_STATUS_CODE_503_SERVICE_UNAVAILABLE", "An error occurred on the server. (HTTP status code: 503)" } },
    //{ 0x80991504,{ "SCE_BGFT_ERROR_HTTP_STATUS_CODE_504_GATEWAY_TIMEOUT", "An error occurred on the server. (HTTP status code: 504)" } },
    //{ 0x809B0001,{ "SCE_DEVICE_SERVICE_ERROR_INVALID_USER",   "invalid userId argument" } },
    //{ 0x809B0002,{ "SCE_DEVICE_SERVICE_ERROR_INVALID_DEVICE_TYPE",    "invalid device type argument" } },
    //{ 0x809B0003,{ "SCE_DEVICE_SERVICE_ERROR_INVALID_INDEX",  "invalid index argument" } },
    //{ 0x809B0004,{ "SCE_DEVICE_SERVICE_ERROR_MEMORY", "failed to allocate memory" } },
    //{ 0x809B0005,{ "SCE_DEVICE_SERVICE_ERROR_INVALID_DEVICE_ID",  "invalid index argument" } },
    //{ 0x809B000B,{ "SCE_DEVICE_SERVICE_ERROR_INVALID_STATE",  "invalid state" } },
    //{ 0x809B0080,{ "SCE_DEVICE_SERVICE_ERROR_INVALID_PARAM",  "invalid argument" } },
    //{ 0x809B0081,{ "SCE_DEVICE_SERVICE_ERROR_USER_NOT_LOGIN", "user is not login" } },
    //{ 0x809B0082,{ "SCE_DEVICE_SERVICE_ERROR_USER_OVER_MAX",  "exceed max number of users" } },
    //{ 0x809B0083,{ "SCE_DEVICE_SERVICE_ERROR_DRIVER_OVER_MAX",    "exceed max number of drivers" } },
    //{ 0x809B0084,{ "SCE_DEVICE_SERVICE_ERROR_DEVICE_OVER_MAX",    "exceed max number of users" } },
    //{ 0x809B0085,{ "SCE_DEVICE_SERVICE_ERROR_BUS_OVER_MAX",   "exceed max number of users" } },
    //{ 0x809B0086,{ "SCE_DEVICE_SERVICE_ERROR_PORT_OVER_MAX",  "exceed max number of users" } },
    //{ 0x809B00FF,{ "SCE_DEVICE_SERVICE_ERROR_INTERNAL",   "fatal internal error" } },
    //{ 0x809D1001,{ "SCE_CONTENT_SEARCH_ERROR_NOT_INITIALIZED",    "No Initialize" } },
    //{ 0x809D1002,{ "SCE_CONTENT_SEARCH_ERROR_ALREADY_INITIALIZED",    "Multiple Initialize" } },
    //{ 0x809D1003,{ "SCE_CONTENT_SEARCH_ERROR_INVALID_PARAM",  "Invalid parameter" } },
    //{ 0x809D1004,{ "SCE_CONTENT_SEARCH_ERROR_NOMEM",  "No memory." } },
    //{ 0x809D1005,{ "SCE_CONTENT_SEARCH_ERROR_INVALID_SEARCH_LOGICAL_CONNECTOR",   "Invalid search logical connector" } },
    //{ 0x809D1006,{ "SCE_CONTENT_SEARCH_ERROR_INVALID_SEARCH_COLUMN",  "Invalid search column" } },
    //{ 0x809D1007,{ "SCE_CONTENT_SEARCH_ERROR_INVALID_SEARCH_COLUMN_VALUE_OPERATOR",   "Invalid search column value operator" } },
    //{ 0x809D1008,{ "SCE_CONTENT_SEARCH_ERROR_INVALID_ORDERBY_CONDITION",  "Invalid Order by condition" } },
    //{ 0x809D1009,{ "SCE_CONTENT_SEARCH_ERROR_INVALID_AGGREGATED_CONDITION",   "Invalid Aggregated condition" } },
    //{ 0x809D100A,{ "SCE_CONTENT_SEARCH_ERROR_LIMIT_TOO_BIG",  "limit too big" } },
    //{ 0x809D100B,{ "SCE_CONTENT_SEARCH_ERROR_SEARCH_PARAMETER_TOO_MANY",  "Search parameter too many." } },
    //{ 0x809D100C,{ "SCE_CONTENT_SEARCH_ERROR_DB_BUSY",    "Database is Busy" } },
    //{ 0x809D100D,{ "SCE_CONTENT_SEARCH_ERROR_DB_FATAL",   "Database error" } },
    //{ 0x809D100E,{ "SCE_CONTENT_SEARCH_ERROR_TOO_MANY_METADATA",  "opened metadata over the limit" } },
    //{ 0x809D100F,{ "SCE_CONTENT_SEARCH_ERROR_NOT_SUPPORT_MIME_TYPE",  "not supported MIME type" } },
    //{ 0x809D1010,{ "SCE_CONTENT_SEARCH_ERROR_NOT_EXIST_FIELD",    "Field does not exist." } },
    //{ 0x809D1011,{ "SCE_CONTENT_SEARCH_ERROR_INVALID_CONTENTS_FILE_FORMAT",   "invalid format of the contents file" } },
    //{ 0x809D1012,{ "SCE_CONTENT_SEARCH_ERROR_NOT_EXIST_FILE", "File does not exist." } },
    //{ 0x809D2001,{ "SCE_CONTENT_BINDER_ERROR_INVALID_PARAM",  "Invalid parameter" } },
    //{ 0x809D2002,{ "SCE_CONTENT_BINDER_ERROR_DIFFERENCE_UPDATED", "Content was added/updated/deleted during a session" } },
    //{ 0x809D2003,{ "SCE_CONTENT_BINDER_ERROR_ALREADY_STARTED",    "Already started" } },
    //{ 0x809D2004,{ "SCE_CONTENT_BINDER_ERROR_NOT_STARTED",    "Not started" } },
    //{ 0x809D2005,{ "SCE_CONTENT_BINDER_ERROR_NOT_ENDED",  "Not ended" } },
    //{ 0x809D2006,{ "SCE_CONTENT_BINDER_ERROR_NOT_INITIALIZED",    "Not initialized" } },
    //{ 0x809D2007,{ "SCE_CONTENT_BINDER_ERROR_ALREADY_INITIALIZED",    "Already initialized" } },
    //{ 0x809D3001,{ "SCE_CONTENT_EXPORT_ERROR_CANCELED",   "Canceled" } },
    //{ 0x809D3002,{ "SCE_CONTENT_EXPORT_ERROR_NOTACCEPT",  "Not Accept" } },
    //{ 0x809D3003,{ "SCE_CONTENT_EXPORT_ERROR_BUSY",   "Busy" } },
    //{ 0x809D3004,{ "SCE_CONTENT_EXPORT_ERROR_NOINIT", "No Initialize" } },
    //{ 0x809D3005,{ "SCE_CONTENT_EXPORT_ERROR_MULTIPLEINIT",   "Multiple Initialize" } },
    //{ 0x809D3006,{ "SCE_CONTENT_EXPORT_ERROR_NOMEM",  "No Memory" } },
    //{ 0x809D3011,{ "SCE_CONTENT_EXPORT_ERROR_FILE_NOT_FOUND", "File Not Found" } },
    //{ 0x809D3012,{ "SCE_CONTENT_EXPORT_ERROR_NOT_SUPPORTED_FORMAT",   "Not Supported Format" } },
    //{ 0x809D3013,{ "SCE_CONTENT_EXPORT_ERROR_LARGE_TITLE",    "Large Title (unused)" } },
    //{ 0x809D3015,{ "SCE_CONTENT_EXPORT_ERROR_LARGE_COMMENT",  "Large Comment (unused)" } },
    //{ 0x809D3016,{ "SCE_CONTENT_EXPORT_ERROR_INVALDPARAM",    "Invalid Parameter" } },
    //{ 0x809D3017,{ "SCE_CONTENT_EXPORT_ERROR_DISKFULL",   "Disk Full" } },
    //{ 0x809D3018,{ "SCE_CONTENT_EXPORT_ERROR_EXECUTION_MAX",  "over the limit of the executable unit" } },
    //{ 0x809D3019,{ "SCE_CONTENT_EXPORT_ERROR_NOT_SUPPORT_FORMAT_THUMBNAIL",   "invalid format of the thumbnail" } },
    //{ 0x809D3019,{ "SCE_CONTENT_EXPORT_ERROR_NOT_SUPPORT_FORMAT_THUNBNAIL",   "invalid format of the thumbnail" } },
    //{ 0x809D3FFF,{ "SCE_CONTENT_EXPORT_ERROR_NOT_IMPLEMENTED",    "Not Implemented" } },
    //{ 0x809D5001,{ "SCE_CONTENT_DELETE_ERROR_INVALID_PARAM",  "Invalid Parameter" } },
    //{ 0x809D5002,{ "SCE_CONTENT_DELETE_ERROR_NOT_INITIALIZED",    "Not initialized" } },
    //{ 0x809D5003,{ "SCE_CONTENT_DELETE_ERROR_ALREADY_INITIALIZED",    "Multiple Initialize" } },
    //{ 0x809D5004,{ "SCE_CONTENT_DELETE_ERROR_NOMEM",  "No Memory" } },
    //{ 0x809D5005,{ "SCE_CONTENT_DELETE_ERROR_FILE_NOT_FOUND", "File Not Found" } },
    //{ 0x809D5006,{ "SCE_CONTENT_DELETE_ERROR_NO_PERMISSION",  "No Permission" } },
    //{ 0x809F0000,{ "SCE_SAVE_DATA_ERROR_PARAMETER",   "set the wrong parameter" } },
    //{ 0x809F0001,{ "SCE_SAVE_DATA_ERROR_NOT_INITIALIZED", "not initialized save data library yet" } },
    //{ 0x809F0002,{ "SCE_SAVE_DATA_ERROR_OUT_OF_MEMORY",   "out of memory" } },
    //{ 0x809F0003,{ "SCE_SAVE_DATA_ERROR_BUSY",    "save data directory has already been mounted/save data memory setup has alraedy done." } },
    //{ 0x809F0004,{ "SCE_SAVE_DATA_ERROR_NOT_MOUNTED", "save data directory is not mounted" } },
    //{ 0x809F0005,{ "SCE_SAVE_DATA_ERROR_NO_PERMISSION",   "permission denied" } },
    //{ 0x809F0006,{ "SCE_SAVE_DATA_ERROR_FINGERPRINT_MISMATCH",    "fingerprint mismatch" } },
    //{ 0x809F0007,{ "SCE_SAVE_DATA_ERROR_EXISTS",  "savedata already exists" } },
    //{ 0x809F0008,{ "SCE_SAVE_DATA_ERROR_NOT_FOUND",   "savedata not found" } },
    //{ 0x809F000A,{ "SCE_SAVE_DATA_ERROR_NO_SPACE_FS", "not enough space for mounting savedata at file system" } },
    //{ 0x809F000B,{ "SCE_SAVE_DATA_ERROR_INTERNAL",    "internal error" } },
    //{ 0x809F000C,{ "SCE_SAVE_DATA_ERROR_MOUNT_FULL",  "reached mount max" } },
    //{ 0x809F000D,{ "SCE_SAVE_DATA_ERROR_BAD_MOUNTED", "not mounted for writing" } },
    //{ 0x809F000E,{ "SCE_SAVE_DATA_ERROR_FILE_NOT_FOUND",  "file not found" } },
    //{ 0x809F000F,{ "SCE_SAVE_DATA_ERROR_BROKEN",  "save data broken" } },
    //{ 0x809F0011,{ "SCE_SAVE_DATA_ERROR_INVALID_LOGIN_USER",  "invalid login user" } },
    //{ 0x809F0012,{ "SCE_SAVE_DATA_ERROR_MEMORY_NOT_READY",    "not ready save data memory" } },
    //{ 0x809F0013,{ "SCE_SAVE_DATA_ERROR_BACKUP_BUSY", "backup now" } },
    //{ 0x809F0015,{ "SCE_SAVE_DATA_ERROR_NOT_REGIST_CALLBACK", "not regist callback API" } },
    //{ 0x809F0016,{ "SCE_SAVE_DATA_ERROR_BUSY_FOR_SAVING", "save data memory is busy because the target save data is saving." } },
    //{ 0x809F0017,{ "SCE_SAVE_DATA_ERROR_LIMITATION_OVER", "save data memory is limitation over" } },
    //{ 0x809F0018,{ "SCE_SAVE_DATA_ERROR_EVENT_BUSY",  "wait conditions are not met" } },
    //{ 0x809F0019,{ "SCE_SAVE_DATA_ERROR_PARAMSFO_TRANSFER_TITLE_ID_NOT_FOUND",    "transferring title id not found in param.sfo" } },
    //{ 0x80A00001,{ "SCE_GAME_LIVE_STREAMING_ERROR_UNKNOWN",   "Unknown error" } },
    //{ 0x80A00002,{ "SCE_GAME_LIVE_STREAMING_ERROR_INVALID_PARAM", "Invalid parameter" } },
    //{ 0x80A00003,{ "SCE_GAME_LIVE_STREAMING_ERROR_INVALID_STATUS",    "Not callable status" } },
    //{ 0x80A00004,{ "SCE_GAME_LIVE_STREAMING_ERROR_NOT_INITIALIZED",   "Not initialized" } },
    //{ 0x80A00005,{ "SCE_GAME_LIVE_STREAMING_ERROR_ENCODER",   "Encoder error" } },
    //{ 0x80A00006,{ "SCE_GAME_LIVE_STREAMING_ERROR_OUT_OF_MEMORY", "Out of memory" } },
    //{ 0x80A00007,{ "SCE_GAME_LIVE_STREAMING_ERROR_NOT_FOUND", "not found." } },
    //{ 0x80A00008,{ "SCE_GAME_LIVE_STREAMING_ERROR_NOT_SUPPORTED", "not supported" } },
    //{ 0x80A00009,{ "SCE_GAME_LIVE_STREAMING_ERROR_MESSAGE_FILTER",    "invalid message filter function" } },
    //{ 0x80A10001,{ "SCE_SYSTEM_SERVICE_ERROR_INTERNAL",   "Unexpected internal error occurs." } },
    //{ 0x80A10002,{ "SCE_SYSTEM_SERVICE_ERROR_UNAVAILABLE",    "The system service is not available." } },
    //{ 0x80A10003,{ "SCE_SYSTEM_SERVICE_ERROR_PARAMETER",  "Parameter is invalid." } },
    //{ 0x80A10004,{ "SCE_SYSTEM_SERVICE_ERROR_NO_EVENT",   "There's no event to receive." } },
    //{ 0x80A10005,{ "SCE_SYSTEM_SERVICE_ERROR_REJECTED",   "The function is rejected." } },
    //{ 0x80A10006,{ "SCE_SYSTEM_SERVICE_ERROR_NEED_DISPLAY_SAFE_AREA_SETTINGS",    "Safe area information have not adjusted." } },
    //{ 0x80A10007,{ "SCE_SYSTEM_SERVICE_ERROR_INVALID_URI_LEN",    "URI length is invalid." } },
    //{ 0x80A10008,{ "SCE_SYSTEM_SERVICE_ERROR_INVALID_URI_SCHEME", "URI scheme is invalid." } },
    //{ 0x80A10009,{ "SCE_SYSTEM_SERVICE_ERROR_NO_APP_INFO",    "No application information" } },
    //{ 0x80A30001,{ "SCE_APP_INSTALLER_ERROR_UNKNOWN", "Unknown error" } },
    //{ 0x80A30002,{ "SCE_APP_INSTALLER_ERROR_NOSPACE", "No disk space" } },
    //{ 0x80A30003,{ "SCE_APP_INSTALLER_ERROR_PARAM",   "Invalid parameter" } },
    //{ 0x80A30004,{ "SCE_APP_INSTALLER_ERROR_APP_NOT_FOUND",   "The application is not found" } },
    //{ 0x80A30005,{ "SCE_APP_INSTALLER_ERROR_DISC_NOT_INSERTED",   "The disc is not inserted" } },
    //{ 0x80A30006,{ "SCE_APP_INSTALLER_ERROR_PKG_INVALID_DRM_TYPE",    "The pkg is invalid drm type" } },
    //{ 0x80A30007,{ "SCE_APP_INSTALLER_ERROR_OUT_OF_MEMORY",   "Out of memory" } },
    //{ 0x80A30008,{ "SCE_APP_INSTALLER_ERROR_APP_BROKEN",  "The application is broken" } },
    //{ 0x80A30009,{ "SCE_APP_INSTALLER_ERROR_PKG_INVALID_CONTENT_TYPE",    "The pkg is invalid content type" } },
    //{ 0x80A3000A,{ "SCE_APP_INSTALLER_ERROR_USED_APP_NOT_FOUND",  "Application is not found" } },
    //{ 0x80A3000B,{ "SCE_APP_INSTALLER_ERROR_ADDCONT_BROKEN",  "Additional content is broken" } },
    //{ 0x80A3000C,{ "SCE_APP_INSTALLER_ERROR_APP_IS_RUNNING",  "Application is running." } },
    //{ 0x80A3000D,{ "SCE_APP_INSTALLER_ERROR_SYSTEM_VERSION",  "Need system update." } },
    //{ 0x80A3000E,{ "SCE_APP_INSTALLER_ERROR_NOT_INSTALL", "Not install." } },
    //{ 0x80A3000F,{ "SCE_APP_INSTALLER_ERROR_CONTENT_ID_DISAGREE", "The CONTENT_ID of pkg and param.sfo disagree." } },
    //{ 0x80A30010,{ "SCE_APP_INSTALLER_ERROR_NOSPACE_KERNEL",  "No disk space (by kernel)" } },
    //{ 0x80A30011,{ "SCE_APP_INSTALLER_ERROR_APP_VER", "APP_VER check error." } },
    //{ 0x80A30012,{ "SCE_APP_INSTALLER_ERROR_DB_DISABLE",  "Database disable" } },
    //{ 0x80A30013,{ "SCE_APP_INSTALLER_ERROR_CANCELED",    "Execution is canceled" } },
    //{ 0x80A30014,{ "SCE_APP_INSTALLER_ERROR_ENTRYDIGEST", "Entry digest error." } },
    //{ 0x80A30015,{ "SCE_APP_INSTALLER_ERROR_BUSY",    "Contents is under using." } },
    //{ 0x80A30016,{ "SCE_APP_INSTALLER_ERROR_DLAPP_ALREADY_INSTALLED", "The same application is already installed." } },
    //{ 0x80A30017,{ "SCE_APP_INSTALLER_ERROR_NEED_ADDCONT_INSTALL",    "Need addcontent install." } },
    //{ 0x80A30018,{ "SCE_APP_INSTALLER_ERROR_APP_MOUNTED_BY_HOST_TOOL",    "Application is mounted by host tool." } },
    //{ 0x80A30019,{ "SCE_APP_INSTALLER_ERROR_INVALID_PATCH_PKG",   "The patch pkg is invalid." } },
    //{ 0x80A30020,{ "SCE_APP_INSTALLER_ERROR_NEED_ADDCONT_INSTALL_NO_CHANGE_TYPE", "Need addcontent install." } },
    //{ 0x80A30021,{ "SCE_APP_INSTALLER_ERROR_ADDCONT_IS_INSTALLING",   "Addcontent is installing." } },
    //{ 0x80A30022,{ "SCE_APP_INSTALLER_ERROR_ADDCONT_ALREADY_INSTALLED",   "Addcontent is already installed." } },
    //{ 0x80A30023,{ "SCE_APP_INSTALLER_ERROR_CANNOT_READ_DISC",    "The disc cannot be read." } },
    //{ 0x80A30024,{ "SCE_APP_INSTALLER_ERROR_DATA_DISC_NOT_INSTALLED", "The data disc is not installed." } },
    //{ 0x80A30025,{ "SCE_APP_INSTALLER_ERROR_NOT_TRANSFER_DISC_VERSION",   "Not transfer the disc version." } },
    //{ 0x80A30026,{ "SCE_APP_INSTALLER_ERROR_NO_SLOT_SPACE",   "Not enough slot space to install the package on the target." } },
    //{ 0x80A30027,{ "SCE_APP_INSTALLER_ERROR_NO_SLOT_INFORMATION", "This application doesn't have slot information." } },
    //{ 0x80A30028,{ "SCE_APP_INSTALLER_ERROR_INSTALL_MAIN_MISSING",    "The slot ID where main is missing is specified. (User tried to set blank slot as primary application.)" } },
    //{ 0x80A31000,{ "SCE_APP_INST_UTIL_ERROR_NOT_INITIALIZED", "Not initialized" } },
    //{ 0x80A31001,{ "SCE_APP_INST_UTIL_ERROR_OUT_OF_MEMORY",   "Out of memory" } },
    //{ 0x80A40001,{ "SCE_PROCESS_STARTER_ERROR_INVALID_ARGUMENT",  "Invalid argument." } },
    //{ 0x80A40002,{ "SCE_PROCESS_STARTER_ERROR_NO_GAME_RUNNING",   "Game is not running." } },
    //{ 0x80A40003,{ "SCE_PROCESS_STARTER_ERROR_OUT_OF_MEMORY", "The operation ran out of memory." } },
    //{ 0x80A40004,{ "SCE_PROCESS_STARTER_ERROR_KEY_NOT_FOUND", "No such key exists." } },
    //{ 0x80A40005,{ "SCE_PROCESS_STARTER_ERROR_NOT_GAME_MINIAPP_APPRICATION",  "The application is not Game and MiniApp." } },
    //{ 0x80A40006,{ "SCE_PROCESS_STARTER_ERROR_INSUFFICIENT_BUFFER",   "Specified buffer size is too small." } },
    //{ 0x80A40007,{ "SCE_PROCESS_STARTER_ERROR_MOUNT_FULL",    "Reached mount max." } },
    //{ 0x80A40008,{ "SCE_PROCESS_STARTER_ERROR_APPLICATION_ALLREADY_RUNNING",  "The application allready running." } },
    //{ 0x80A40009,{ "SCE_PROCESS_STARTER_ERROR_NO_DISC_INSERT",    "No disc inserted." } },
    //{ 0x80A4000A,{ "SCE_PROCESS_STARTER_ERROR_UNSUPPORTED_DATA",  "This data is not supported by the PS4." } },
    //{ 0x80A4000B,{ "SCE_PROCESS_STARTER_ERROR_BD_DATA_CORRUPTED", "The data is corrupted." } },
    //{ 0x80A4000C,{ "SCE_PROCESS_STARTER_ERROR_HDD_DATA_CORRUPTED",    "The data is corrupted." } },
    //{ 0x80A4000D,{ "SCE_PROCESS_STARTER_ERROR_REGION_RESTRICTION",    "Cannot start the application due to region restrictions." } },
    //{ 0x80A4000E,{ "SCE_PROCESS_STARTER_ERROR_PARENTAL",  "The use of this application is not allowed due to parental controls." } },
    //{ 0x80A4000F,{ "SCE_PROCESS_STARTER_ERROR_LOGOUT_LAUNCH_USER",    "The launch user logged out." } },
    //{ 0x80A40010,{ "SCE_PROCESS_STARTER_ERROR_NO_SPACE",  "There is not enough free space." } },
    //{ 0x80A40011,{ "SCE_PROCESS_STARTER_ERROR_NEED_SYSTEM_UPDATE",    "Need system update." } },
    //{ 0x80A40012,{ "SCE_PROCESS_STARTER_ERROR_UNDER_CONSTRUCTION",    "The application is under construction." } },
    //{ 0x80A40013,{ "SCE_PROCESS_STARTER_ERROR_UNDER_UPDATING",    "The application is under updating." } },
    //{ 0x80A40014,{ "SCE_PROCESS_STARTER_ERROR_REQUIRED_PATCH_IS_DOWNLOADING", "The required patch is under downloading." } },
    //{ 0x80A40015,{ "SCE_PROCESS_STARTER_ERROR_NO_REQUIRED_PATCH_DOWNLOADED",  "The no required patch was allready downloaded." } },
    //{ 0x80A40016,{ "SCE_PROCESS_STARTER_ERROR_REQUIRED_PATCH_DOWNLOADED", "The required patch was allready downloaded." } },
    //{ 0x80A40017,{ "SCE_PROCESS_STARTER_ERROR_FS_MOUNT",  "Mount error." } },
    //{ 0x80A40018,{ "SCE_PROCESS_STARTER_ERROR_ALLREADY_MOUNTED",  "Allready mounted." } },
    //{ 0x80A40019,{ "SCE_PROCESS_STARTER_ERROR_INVALID_SERVICE_LABEL", "Invalid service label." } },
    //{ 0x80A40020,{ "SCE_PROCESS_STARTER_ERROR_REQIRED_PSN_SIGNUP",    "Reqired psn signup." } },
    //{ 0x80A40021,{ "SCE_PROCESS_STARTER_ERROR_NOT_MOUNTED",   "Not mounted." } },
    //{ 0x80A40022,{ "SCE_PROCESS_STARTER_ERROR_APPLICATION_NOT_FOUND", "The application is not found." } },
    //{ 0x80A40023,{ "SCE_PROCESS_STARTER_ERROR_IN_PATCH_INSTALL",  "In patch install." } },
    //{ 0x80A40024,{ "SCE_PROCESS_STARTER_ERROR_SKU_FLAG",  "Unmatch sku flag." } },
    //{ 0x80A40025,{ "SCE_PROCESS_STARTER_ERROR_IN_DATA_INSTALL",   "In data install." } },
    //{ 0x80A40026,{ "SCE_PROCESS_STARTER_ERROR_HOST_OVERLAY_MOUNT",    "Mount of /hostapp/app is failed." } },
    //{ 0x80A40027,{ "SCE_PROCESS_STARTER_ERROR_OTHER_DISC_INSERTED",   "Other disc inserted." } },
    //{ 0x80A40028,{ "SCE_PROCESS_STARTER_ERROR_IN_DISC_LOAD",  "In disc load." } },
    //{ 0x80A40029,{ "SCE_PROCESS_STARTER_ERROR_ALREADY_INSTALLED", "The same application already installed." } },
    //{ 0x80A4002A,{ "SCE_PROCESS_STARTER_ERROR_ACTIVATE_DISC_PLAYER",  "Activate of disc player is failed." } },
    //{ 0x80A4002B,{ "SCE_PROCESS_STARTER_ERROR_SYSTEM_UPDATE_IS_FOUND",    "The system update is found." } },
    //{ 0x80A4002C,{ "SCE_PROCESS_STARTER_ERROR_AREA_SETTING",  "The area setting is not initialized." } },
    //{ 0x80A4002D,{ "SCE_PROCESS_STARTER_ERROR_INVALID_ACCOUNT",   "Invalid account." } },
    //{ 0x80A4002E,{ "SCE_PROCESS_STARTER_ERROR_3DTV_DETECTED", "3dtv detected." } },
    //{ 0x80A4002F,{ "SCE_PROCESS_STARTER_ERROR_LAUNCH_PS_CLOUD_BETA_SERVICE",  "Launch PS Cloud beta service content." } },
    //{ 0x80A40030,{ "SCE_PROCESS_STARTER_ERROR_LAUNCH_PS_CLOUD_SERVICE",   "Launch PS Cloud service content." } },
    //{ 0x80A40031,{ "SCE_PROCESS_STARTER_ERROR_UNOPENED",  "Unopened content." } },
    //{ 0x80A40032,{ "SCE_PROCESS_STARTER_ERROR_START_TIME_VALID_IN_FUTURE",    "Start time valid in future." } },
    //{ 0x80A40033,{ "SCE_PROCESS_STARTER_ERROR_NO_ENTITLEMENT",    "No entitlement." } },
    //{ 0x80A40034,{ "SCE_PROCESS_STARTER_ERROR_REQUIRED_HDCP", "Required HDCP On." } },
    //{ 0x80A40035,{ "SCE_PROCESS_STARTER_ERROR_FATAL_FILESYSTEM",  "Fatal error on file system." } },
    //{ 0x80A40036,{ "SCE_PROCESS_STARTER_ERROR_UPDATE",    "Update is failed." } },
    //{ 0x80A40037,{ "SCE_PROCESS_STARTER_ERROR_LAUNCH_SHARE_PLAY_LINK",    "Launch share play link content." } },
    //{ 0x80A40038,{ "SCE_PROCESS_STARTER_ERROR_PERMISSION",    "Permission error." } },
    //{ 0x80A40039,{ "SCE_PROCESS_STARTER_ERROR_ASM_ACCESS_ERROR",  "ASM access error." } },
    //{ 0x80A4003A,{ "SCE_PROCESS_STARTER_ERROR_NEED_SYSTEM_UPDATE_DISC",   "Need system update (disc game)." } },
    //{ 0x80A4003B,{ "SCE_PROCESS_STARTER_ERROR_PARENTAL_PSNOW",    "The use of this PS Now application is not allowed due to parental controls." } },
    //{ 0x80A4003C,{ "SCE_PROCESS_STARTER_ERROR_MANDATORY_PATCH_IS_DOWNLOADING",    "The mandatory patch is under downloading." } },
    //{ 0x80A4003D,{ "SCE_PROCESS_STARTER_ERROR_MANDATORY_PATCH_IS_DOWNLOADING_IN_RESUME",  "The mandatory patch is under downloading in resume." } },
    //{ 0x80A4003E,{ "SCE_PROCESS_STARTER_ERROR_MANDATORY_PATCH_IS_DOWNLOADING_WITH_SYSTEM_UPDATE", "The mandatory patch is under downloading." } },
    //{ 0x80A4003F,{ "SCE_PROCESS_STARTER_ERROR_INVALID_HDD_PKG_SIZE",  "Invalid pkg size." } },
    //{ 0x80A40040,{ "SCE_PROCESS_STARTER_ERROR_INVALID_BD_PKG_SIZE",   "Invalid pkg size." } },
    //{ 0x80A40041,{ "SCE_PROCESS_STARTER_ERROR_FINGERPRINT_MISMATCH",  "Fingerprint mismatch." } },
    //{ 0x80A40042,{ "SCE_PROCESS_STARTER_ERROR_ALREADY_MOUNTED_BY_HOST_TOOLS", "Already mounted by host tools." } },
    //{ 0x80A40043,{ "SCE_PROCESS_STARTER_ERROR_TUTORIAL_PS2EMU",   "Required tutorial of ps2emu." } },
    //{ 0x80A40044,{ "SCE_PROCESS_STARTER_ERROR_REQUIRED_PATCH_IS_DOWNLOADING_WITH_SYSTEM_UPDATE",  "The required patch is under downloading." } },
    //{ 0x80A40045,{ "SCE_PROCESS_STARTER_ERROR_INSTALLING_AC_FROM_DISC_FOR_DISC_CONTENT",  "The AC is under installing from disc for disc content." } },
    //{ 0x80A40046,{ "SCE_PROCESS_STARTER_ERROR_INSTALLING_AC_FROM_DISC_FOR_HDD_CONTENT",   "The AC is under installing from disc for hdd content." } },
    //{ 0x80A40047,{ "SCE_PROCESS_STARTER_ERROR_NO_REQUIRED_PATCH_IS_DOWNLOADING_WITH_SYSTEM_UPDATE",   "The no required patch is under downloading." } },
    //{ 0x80A40048,{ "SCE_PROCESS_STARTER_ERROR_PATCH_SIZE_TOO_LARGE",  "The patch size is too large." } },
    //{ 0x80A40049,{ "SCE_PROCESS_STARTER_ERROR_PATCH_FINALIZED",   "The finalized patch pkg." } },
    //{ 0x80A40050,{ "SCE_PROCESS_STARTER_ERROR_PATCH_FAKE",    "The fake patch pkg." } },
    //{ 0x80A40051,{ "SCE_PROCESS_STARTER_ERROR_CANNOT_READ_DISC",  "The disc cannot be read." } },
    //{ 0x80A40052,{ "SCE_PROCESS_STARTER_ERROR_CANNOT_READ_DISC_IN_RESUME",    "The disc cannot be read in resume." } },
    //{ 0x80A40053,{ "SCE_PROCESS_STARTER_ERROR_FREEMIUM_SKU_FLAG", "Unmatch freemium sku flag." } },
    //{ 0x80A40054,{ "SCE_PROCESS_STARTER_ERROR_OTHER_DISC_INSERTED_IN_RESUME", "Other disc inserted in resume." } },
    //{ 0x80A40055,{ "SCE_PROCESS_STARTER_ERROR_IN_AC_INSTALL", "In add content install." } },
    //{ 0x80A40056,{ "SCE_PROCESS_STARTER_ERROR_NOT_NESTED_IMAGE",  "Not nested image." } },
    //{ 0x80A40057,{ "SCE_PROCESS_STARTER_ERROR_DISAGREE_DISC_VERSION", "Disagree disc version." } },
    //{ 0x80A40058,{ "SCE_PROCESS_STARTER_ERROR_DISAGREE_EKC_VERSION",  "Disagree EKc version." } },
    //{ 0x80A40059,{ "SCE_PROCESS_STARTER_ERROR_NECESSARY_TO_SELECT_VR_MODE",   "Necessary to select VR Mode." } },
    //{ 0x80A4005A,{ "SCE_PROCESS_STARTER_ERROR_DATA_DISC_NOT_INSTALLED",   "The data disc is not installed." } },
    //{ 0x80A4005B,{ "SCE_PROCESS_STARTER_ERROR_NEED_PLAY_DISC",    "Need play disc for launch." } },
    //{ 0x80A4005C,{ "SCE_PROCESS_STARTER_ERROR_IN_LANGUAGE_DATA_INSTALL",  "In launguage data install." } },
    //{ 0x80A4005D,{ "SCE_PROCESS_STARTER_ERROR_NEED_LANGUAGE_DATA",    "Need launguage data." } },
    //{ 0x80A4005E,{ "SCE_PROCESS_STARTER_ERROR_NEED_LANGUAGE_DATA_FOR_SYSTEM_SETTING", "Need launguage data for system setting." } },
    //{ 0x80A4005F,{ "SCE_PROCESS_STARTER_ERROR_DEV_FLAG",  "This pkg includes dev flag." } },
    //{ 0x80A70001,{ "SCE_VSH_AVCAP_ERROR_EINVAL",  "Invalid argument" } },
    //{ 0x80A70002,{ "SCE_VSH_AVCAP_ERROR_EAGAIN",  "Resource temporarily unavailable" } },
    //{ 0x80A70003,{ "SCE_VSH_AVCAP_ERROR_ENOMEM",  "Not enough core" } },
    //{ 0x80A70004,{ "SCE_VSH_AVCAP_ERROR_ERESET",  "Resource reset" } },
    //{ 0x80A70005,{ "SCE_VSH_AVCAP_ERROR_ENOSPC",  "No space left on device" } },
    //{ 0x80A70006,{ "SCE_VSH_AVCAP_ERROR_EEMPTY",  "No data is available" } },
    //{ 0x80A70007,{ "SCE_VSH_AVCAP_ERROR_ENFILE",  "File table overflow" } },
    //{ 0x80A70008,{ "SCE_VSH_AVCAP_ERROR_EBUSY",   "Device busy" } },
    //{ 0x80A70009,{ "SCE_VSH_AVCAP_ERROR_EINTR",   "Process Interrupted" } },
    //{ 0x80A7000A,{ "SCE_VSH_AVCAP_ERROR_ENOTSUP", "Operation not supported" } },
    //{ 0x80A80001,{ "SCE_VIDEO_RECORDING_ERROR_OUT_OF_MEMORY", "Insufficient memory" } },
    //{ 0x80A80002,{ "SCE_VIDEO_RECORDING_ERROR_FATAL", "Fatal error" } },
    //{ 0x80A80003,{ "SCE_VIDEO_RECORDING_ERROR_INVALID_VALUE", "Specified parameter is not appropriate" } },
    //{ 0x80A80004,{ "SCE_VIDEO_RECORDING_ERROR_FILE_OPEN", "File open error" } },
    //{ 0x80A80005,{ "SCE_VIDEO_RECORDING_ERROR_FILE_WRITE",    "File write error" } },
    //{ 0x80A80006,{ "SCE_VIDEO_RECORDING_ERROR_INVALID_STATE", "Function not called in a proper state" } },
    //{ 0x80A80007,{ "SCE_VIDEO_RECORDING_ERROR_INTERRUPTED",   "Recording is interrupted" } },
    //{ 0x80A80008,{ "SCE_VIDEO_RECORDING_ERROR_UNSUPPORTED",   "Recording is not supported" } },
    //{ 0x80A80009,{ "SCE_VIDEO_RECORDING_ERROR_NO_SPACE",  "Storage has no space" } },
    //{ 0x80A8000A,{ "SCE_VIDEO_RECORDING_ERROR_FILE_NO_DATA",  "Playable data is not contained" } },
    //{ 0x80A90000,{ "SCE_M4AAC_ENC_ERROR_INTERNAL_ERROR",  "internal error" } },
    //{ 0x80A90001,{ "SCE_M4AAC_ENC_ERROR_INVALID_HANDLE",  "invalid handle" } },
    //{ 0x80A90002,{ "SCE_M4AAC_ENC_ERROR_INVALID_PTR", "invalid pointer" } },
    //{ 0x80A90003,{ "SCE_M4AAC_ENC_ERROR_INVALID_CHANNEL", "invalid channel" } },
    //{ 0x80A90004,{ "SCE_M4AAC_ENC_ERROR_INVALID_SAMPLING_RATE",   "invalid sampling rate" } },
    //{ 0x80A90005,{ "SCE_M4AAC_ENC_ERROR_INVALID_BIT_RATE",    "invalid bit rate" } },
    //{ 0x80A90006,{ "SCE_M4AAC_ENC_ERROR_INVALID_INPUT_FORMAT",    "invalid input format" } },
    //{ 0x80A90007,{ "SCE_M4AAC_ENC_ERROR_INVALID_OUTPUT_FORMAT",   "invalid output format" } },
    //{ 0x80A90008,{ "SCE_M4AAC_ENC_ERROR_INVALID_INPUT_SIZE",  "invalid input size" } },
    //{ 0x80A90009,{ "SCE_M4AAC_ENC_ERROR_INVALID_PREVIOUS_INPUT_SIZE", "invalid previous input size" } },
    //{ 0x80AD0001,{ "SCE_COMPANION_UTIL_ERROR_UNKNOWN",    "Undefined error" } },
    //{ 0x80AD0002,{ "SCE_COMPANION_UTIL_ERROR_FATAL",  "Unpredictable error occurrence" } },
    //{ 0x80AD0003,{ "SCE_COMPANION_UTIL_ERROR_NOMEM",  "Failure in memory allocation" } },
    //{ 0x80AD0004,{ "SCE_COMPANION_UTIL_ERROR_INVALID_PARAM",  "Improper parameter" } },
    //{ 0x80AD0005,{ "SCE_COMPANION_UTIL_ERROR_INVALID_OPERATION",  "Incorrect processing executed" } },
    //{ 0x80AD0006,{ "SCE_COMPANION_UTIL_ERROR_NOT_INITIALIZED",    "Library uninitialized" } },
    //{ 0x80AD0007,{ "SCE_COMPANION_UTIL_ERROR_ALREADY_INITIALIZED",    "Already initialized" } },
    //{ 0x80AD0008,{ "SCE_COMPANION_UTIL_ERROR_NO_EVENT",   "No event to get" } },
    //{ 0x80B20001,{ "SCE_PLAYGO_ERROR_UNKNOWN",    "Undefined error other than the following" } },
    //{ 0x80B20002,{ "SCE_PLAYGO_ERROR_FATAL",  "Unexpected error occurred" } },
    //{ 0x80B20003,{ "SCE_PLAYGO_ERROR_NO_MEMORY",  "Could not allocate memory" } },
    //{ 0x80B20004,{ "SCE_PLAYGO_ERROR_INVALID_ARGUMENT",   "Specified parameter is inappropriate" } },
    //{ 0x80B20005,{ "SCE_PLAYGO_ERROR_NOT_INITIALIZED",    "Library is not initialized" } },
    //{ 0x80B20006,{ "SCE_PLAYGO_ERROR_ALREADY_INITIALIZED",    "Already initialized" } },
    //{ 0x80B20007,{ "SCE_PLAYGO_ERROR_ALREADY_STARTED",    "Package is already open" } },
    //{ 0x80B20008,{ "SCE_PLAYGO_ERROR_NOT_STARTED",    "Package is not open" } },
    //{ 0x80B20009,{ "SCE_PLAYGO_ERROR_BAD_HANDLE", "Specified PlayGo handle is invalid" } },
    //{ 0x80B2000A,{ "SCE_PLAYGO_ERROR_BAD_POINTER",    "Specified variable value is NULL" } },
    //{ 0x80B2000B,{ "SCE_PLAYGO_ERROR_BAD_SIZE",   "Specified size value is invalid" } },
    //{ 0x80B2000C,{ "SCE_PLAYGO_ERROR_BAD_CHUNK_ID",   "Specified chunk ID value is invalid" } },
    //{ 0x80B2000D,{ "SCE_PLAYGO_ERROR_BAD_SPEED",  "Specified speed value is invalid" } },
    //{ 0x80B2000E,{ "SCE_PLAYGO_ERROR_NOT_SUPPORT_PLAYGO", "Application does not support PlayGo" } },
    //{ 0x80B2000F,{ "SCE_PLAYGO_ERROR_EPERM",  "This operation is not permitted" } },
    //{ 0x80B20010,{ "SCE_PLAYGO_ERROR_BAD_LOCUS",  "Specified locus value is invalid" } },
    //{ 0x80B20011,{ "SCE_PLAYGO_ERROR_NEED_DATA_DISC", "Need to install chunks on DataDisc" } },
    //{ 0x80B40001,{ "SCE_S3D_CONVERSION_ERROR_Q_ARG_ATTR_NULL",    "pAttr is NULL for sceS3dConversionQueryAttr()" } },
    //{ 0x80B40002,{ "SCE_S3D_CONVERSION_ERROR_O_ARG_RSRC_NULL",    "pRsrc is NULL for sceS3dConversionOpen()" } },
    //{ 0x80B40003,{ "SCE_S3D_CONVERSION_ERROR_O_ARG_RSRC_INVALID", "<*pRsrc> setting is invalid for sceS3dConversionOpen()" } },
    //{ 0x80B40004,{ "SCE_S3D_CONVERSION_ERROR_O_ARG_HDL_NULL", "pHandle is NULL for sceS3dConversionOpen()" } },
    //{ 0x80B40005,{ "SCE_S3D_CONVERSION_ERROR_O_ARG_RSRCMEM_INVALID",  "Allocated memory is invalid for sceS3dConversionOpen()" } },
    //{ 0x80B40006,{ "SCE_S3D_CONVERSION_ERROR_C_ARG_HDL_NULL", "handle is NULL for sceS3dConversionClose()" } },
    //{ 0x80B40007,{ "SCE_S3D_CONVERSION_ERROR_C_ARG_HDL_INVALID",  "<*handle> is invalid for sceS3dConversionClose()" } },
    //{ 0x80B40008,{ "SCE_S3D_CONVERSION_ERROR_C_SEQ",  "Converting and cannot close with sceS3dConversionClose()" } },
    //{ 0x80B4000A,{ "SCE_S3D_CONVERSION_ERROR_E_ARG_HDL_NULL", "handle is NULL for sceS3dConversionExec()" } },
    //{ 0x80B4000B,{ "SCE_S3D_CONVERSION_ERROR_E_ARG_HDL_INVALID",  "<*handle> is invalid for sceS3dConversionExec()" } },
    //{ 0x80B4000C,{ "SCE_S3D_CONVERSION_ERROR_E_ARG_INPICINFO_NULL",   "pInPicInfo is NULL for sceS3dConversionExec()" } },
    //{ 0x80B4000D,{ "SCE_S3D_CONVERSION_ERROR_E_ARG_INPICINFO_INVALID",    "<*pInPicInfo> setting is invalid for sceS3dConversionExec()" } },
    //{ 0x80B4000E,{ "SCE_S3D_CONVERSION_ERROR_E_ARG_CTRL_NULL",    "pCtrl is NULL for sceS3dConversionExec()" } },
    //{ 0x80B4000F,{ "SCE_S3D_CONVERSION_ERROR_E_ARG_CTRL_INVALID", "<*pCtrl> setting is invalid for sceS3dConversionExec()" } },
    //{ 0x80B40010,{ "SCE_S3D_CONVERSION_ERROR_E_ARG_OUTPICINFO_NULL",  "pOutInfoL and pOutInfoR are NULL for sceS3dConversionExec()" } },
    //{ 0x80B40012,{ "SCE_S3D_CONVERSION_ERROR_E_ARG_LEFTPICINFO_INVALID",  "<*pOutInfoL> setting is invalid for sceS3dConversionExec()" } },
    //{ 0x80B40013,{ "SCE_S3D_CONVERSION_ERROR_E_ARG_RIGHTPICINFO_INVALID", "<*pOutInfoR> setting is invalid for sceS3dConversionExec()" } },
    //{ 0x80B40014,{ "SCE_S3D_CONVERSION_ERROR_E_ARG_LEFT_RENDERTARGET_NULL",   "pOutInfoL->target is NULL for sceS3dConversionExec()" } },
    //{ 0x80B40015,{ "SCE_S3D_CONVERSION_ERROR_E_ARG_LEFT_RENDERTARGET_INVALID",    "<*OutInfoL->target> setting is invalid for sceS3dConversionExec()" } },
    //{ 0x80B40016,{ "SCE_S3D_CONVERSION_ERROR_E_ARG_RIGHT_RENDERTARGET_NULL",  "pOutInfoR->target is NULL for sceS3dConversionExec()" } },
    //{ 0x80B40017,{ "SCE_S3D_CONVERSION_ERROR_E_ARG_RIGHT_RENDERTARGET_INVALID",   "<*OutInfoR->target> setting is invalid for sceS3dConversionExec()" } },
    //{ 0x80B40018,{ "SCE_S3D_CONVERSION_ERROR_E_SEQ",  "Error during command generation for sceS3dConversionExec()" } },
    //{ 0x80B40019,{ "SCE_S3D_CONVERSION_ERROR_E_ARG_RSRC_NULL",    "pContextRsrc is NULL for sceS3dConversionExec()" } },
    //{ 0x80B4001A,{ "SCE_S3D_CONVERSION_ERROR_E_ARG_RSRC_INVALID", "<*pContextRsrc> setting is invalid for sceS3dConversionExec()" } },
    //{ 0x80B4001B,{ "SCE_S3D_CONVERSION_ERROR_E_ARG_RSRCMEM_INVALID",  "Allocated memory is invalid for sceS3dConversionExec()" } },
    //{ 0x80B50001,{ "SCE_RTC_ERROR_NOT_INITIALIZED",   "Not initialized" } },
    //{ 0x80B50002,{ "SCE_RTC_ERROR_INVALID_POINTER",   "invalid pointer" } },
    //{ 0x80B50003,{ "SCE_RTC_ERROR_INVALID_VALUE", "invalid value" } },
    //{ 0x80B50004,{ "SCE_RTC_ERROR_INVALID_ARG",   "invalid argument" } },
    //{ 0x80B50005,{ "SCE_RTC_ERROR_NOT_SUPPORTED", "The feature is not supported" } },
    //{ 0x80B50006,{ "SCE_RTC_ERROR_NO_CLOCK",  "The clock is not available" } },
    //{ 0x80B50007,{ "SCE_RTC_ERROR_BAD_PARSE", "error occured in parsing" } },
    //{ 0x80B50008,{ "SCE_RTC_ERROR_INVALID_YEAR",  "The year value is invalid" } },
    //{ 0x80B50009,{ "SCE_RTC_ERROR_INVALID_MONTH", "The month value is invalid" } },
    //{ 0x80B5000A,{ "SCE_RTC_ERROR_INVALID_DAY",   "The day value is invalid" } },
    //{ 0x80B5000B,{ "SCE_RTC_ERROR_INVALID_HOUR",  "The hour value is invalid" } },
    //{ 0x80B5000C,{ "SCE_RTC_ERROR_INVALID_MINUTE",    "The minute value is invalid" } },
    //{ 0x80B5000D,{ "SCE_RTC_ERROR_INVALID_SECOND",    "The second value is invalid" } },
    //{ 0x80B5000E,{ "SCE_RTC_ERROR_INVALID_MICROSECOND",   "The microsecond value is invalid" } },
    //{ 0x80B80001,{ "SCE_COMMON_DIALOG_ERROR_NOT_SYSTEM_INITIALIZED",  "sceCommonDialogInitialize is not running" } },
    //{ 0x80B80002,{ "SCE_COMMON_DIALOG_ERROR_ALREADY_SYSTEM_INITIALIZED",  "sceCommonDialogInitialize is already running" } },
    //{ 0x80B80003,{ "SCE_COMMON_DIALOG_ERROR_NOT_INITIALIZED", "The Common Dialog has not been initialized" } },
    //{ 0x80B80004,{ "SCE_COMMON_DIALOG_ERROR_ALREADY_INITIALIZED", "The Common dialog is already initialized." } },
    //{ 0x80B80005,{ "SCE_COMMON_DIALOG_ERROR_NOT_FINISHED",    "The Common Dialog is not finished" } },
    //{ 0x80B80006,{ "SCE_COMMON_DIALOG_ERROR_INVALID_STATE",   "It's the state that is unable to call the API." } },
    //{ 0x80B80007,{ "SCE_COMMON_DIALOG_ERROR_RESULT_NONE", "As a result of the common dialog does not exist" } },
    //{ 0x80B80008,{ "SCE_COMMON_DIALOG_ERROR_BUSY",    "Another Common Dialog is in use" } },
    //{ 0x80B80009,{ "SCE_COMMON_DIALOG_ERROR_OUT_OF_MEMORY",   "here is not enough memory" } },
    //{ 0x80B8000A,{ "SCE_COMMON_DIALOG_ERROR_PARAM_INVALID",   "It is an invalid parameter" } },
    //{ 0x80B8000B,{ "SCE_COMMON_DIALOG_ERROR_NOT_RUNNING", "The Common Dialog is not running." } },
    //{ 0x80B8000C,{ "SCE_COMMON_DIALOG_ERROR_ALREADY_CLOSE",   "The Common dialog is already closed." } },
    //{ 0x80B8000D,{ "SCE_COMMON_DIALOG_ERROR_ARG_NULL",    "Invalid NULL pointer has been specified in argument" } },
    //{ 0x80B8000E,{ "SCE_COMMON_DIALOG_ERROR_UNEXPECTED_FATAL",    "Unexpected fatal error occurred" } },
    //{ 0x80B8000F,{ "SCE_COMMON_DIALOG_ERROR_NOT_SUPPORTED",   "you use unsupported features." } },
    //{ 0x80B80010,{ "SCE_COMMON_DIALOG_ERROR_INHIBIT_SHAREPLAY_CLIENT",    "Display of feature dialog not permitted for display to visitors during usage of the \"Playing Game with Host\" feature was attempted." } },
    //{ 0x80B90001,{ "SCE_HAND_ERROR_NO_MEMORY",    "Not enough memory to run" } },
    //{ 0x80B90002,{ "SCE_HAND_ERROR_INVALID_PARAM",    "Parameter is invalid" } },
    //{ 0x80B90003,{ "SCE_HAND_ERROR_INVALID_DICT", "Dictionary data is invalid" } },
    //{ 0x80B90005,{ "SCE_HAND_ERROR_OUT_OF_RANGE", "Hand angle is out of range" } },
    //{ 0x80BA000E,{ "SCE_SHELL_UTIL_ERROR_NEED_SYSTEM_UPDATE", "Need system update." } },
    //{ 0x80BB0000,{ "SCE_DEPTH_ERROR_INVALID_PARAMETER",   "Parameter is invalid" } },
    //{ 0x80BB0001,{ "SCE_DEPTH_ERROR_INVALID_UPDATE_MODE", "updateMode is invalid" } },
    //{ 0x80BB0002,{ "SCE_DEPTH_ERROR_INVALID_EXECUTION_MODE",  "executionMode is invalid" } },
    //{ 0x80BB0003,{ "SCE_DEPTH_ERROR_INVALID_PIXEL_FORMAT",    "pixelFormat is invalid" } },
    //{ 0x80BB0004,{ "SCE_DEPTH_ERROR_INVALID_IMAGE_TYPE",  "imageType is invalid" } },
    //{ 0x80BB0005,{ "SCE_DEPTH_ERROR_INVALID_HANDLE",  "handle is invalid" } },
    //{ 0x80BB0006,{ "SCE_DEPTH_ERROR_INVALID_MEMORY_ALIGNMENT",    "memory alignment is invalid" } },
    //{ 0x80BB0007,{ "SCE_DEPTH_ERROR_INVALID_ASPECT",  "aspect is invalid" } },
    //{ 0x80BB0008,{ "SCE_DEPTH_ERROR_INVALID_SIZE_PARAMETER",  "size parameter is invalid" } },
    //{ 0x80BB0009,{ "SCE_DEPTH_ERROR_INVALID_RESERVED_PARAMETER",  "reserved parameter is invalid" } },
    //{ 0x80BB000A,{ "SCE_DEPTH_ERROR_INVALID_POINTER_ADDRESS", "pointer address is invalid" } },
    //{ 0x80BB000B,{ "SCE_DEPTH_ERROR_INVALID_RESOLUTION_PARAMETER",    "resolution parameter is invalid" } },
    //{ 0x80BB000C,{ "SCE_DEPTH_ERROR_INVALID_CAMERA_TYPE", "camera type is invalid" } },
    //{ 0x80BB000D,{ "SCE_DEPTH_ERROR_INVALID_PARAMETER_RANGE", "parameter range is invalid" } },
    //{ 0x80BB000E,{ "SCE_DEPTH_ERROR_INVALID_PROCESSING_ORDER",    "processing order is invalid" } },
    //{ 0x80BB000F,{ "SCE_DEPTH_ERROR_INVALID_TERMINATION", "termination is invalid" } },
    //{ 0x80BB0010,{ "SCE_DEPTH_ERROR_INVALID_ACCESS",  "instance access error" } },
    //{ 0x80BB0011,{ "SCE_DEPTH_ERROR_INVALID_DEPTH_MAP_SIZE_TYPE", "depthMapSizeType is invalid" } },
    //{ 0x80BB0012,{ "SCE_DEPTH_ERROR_INVALID_PROFILE", "depthProfile is invalid" } },
    //{ 0x80BB0012,{ "SCE_DEPTH_ERROR_INVALID_DEPTH_MAP_GENERATOR_TYPE",    "depthProfile is invalid" } },
    //{ 0x80BB0100,{ "SCE_DEPTH_ERROR_NOT_ENOUGH_MEMORY",   "Not enough memory" } },
    //{ 0x80BB0101,{ "SCE_DEPTH_ERROR_COULD_NOT_CREATED_INSTANCE",  "Could not created instance" } },
    //{ 0x80BBFF00,{ "SCE_DEPTH_ERROR_CALIBRATION_IS_NECESSARY",    "Calibration is necessary" } },
    //{ 0x80BBFFFF,{ "SCE_DEPTH_ERROR_FATAL",   "Fatal error occurred" } },
    //{ 0x80BC0001,{ "SCE_IME_ERROR_BUSY",  "Already running IME" } },
    //{ 0x80BC0002,{ "SCE_IME_ERROR_NOT_OPENED",    "Processing is not started" } },
    //{ 0x80BC0003,{ "SCE_IME_ERROR_NO_MEMORY", "Memory is insufficient" } },
    //{ 0x80BC0004,{ "SCE_IME_ERROR_CONNECTION_FAILED", "Connection with IME has failed" } },
    //{ 0x80BC0005,{ "SCE_IME_ERROR_TOO_MANY_REQUESTS", "Too many requests for IME" } },
    //{ 0x80BC0006,{ "SCE_IME_ERROR_INVALID_TEXT",  "Content of text is invalid" } },
    //{ 0x80BC0007,{ "SCE_IME_ERROR_EVENT_OVERFLOW",    "Event is overflowed" } },
    //{ 0x80BC0008,{ "SCE_IME_ERROR_NOT_ACTIVE",    "Application is not active" } },
    //{ 0x80BC0009,{ "SCE_IME_ERROR_IME_SUSPENDING",    "IME is suspending" } },
    //{ 0x80BC000A,{ "SCE_IME_ERROR_DEVICE_IN_USE", "The device is in use" } },
    //{ 0x80BC0010,{ "SCE_IME_ERROR_INVALID_USER_ID",   "User ID value is invalid" } },
    //{ 0x80BC0011,{ "SCE_IME_ERROR_INVALID_TYPE",  "type value is invalid" } },
    //{ 0x80BC0012,{ "SCE_IME_ERROR_INVALID_SUPPORTED_LANGUAGES",   "supportedLanguages value is invalid" } },
    //{ 0x80BC0013,{ "SCE_IME_ERROR_INVALID_ENTER_LABEL",   "enterLabel value is invalid" } },
    //{ 0x80BC0014,{ "SCE_IME_ERROR_INVALID_INPUT_METHOD",  "inputMethod value is invalid" } },
    //{ 0x80BC0015,{ "SCE_IME_ERROR_INVALID_OPTION",    "option value is invalid" } },
    //{ 0x80BC0016,{ "SCE_IME_ERROR_INVALID_MAX_TEXT_LENGTH",   "maxTextLength value is invalid" } },
    //{ 0x80BC0017,{ "SCE_IME_ERROR_INVALID_INPUT_TEXT_BUFFER", "inputTextBuffer value is invalid" } },
    //{ 0x80BC0018,{ "SCE_IME_ERROR_INVALID_POSX",  "posx value is invalid" } },
    //{ 0x80BC0019,{ "SCE_IME_ERROR_INVALID_POSY",  "poxy value is invalid" } },
    //{ 0x80BC001A,{ "SCE_IME_ERROR_INVALID_HORIZONTAL_ALIGNMENT",  "horizontalAlignment value is invalid" } },
    //{ 0x80BC001B,{ "SCE_IME_ERROR_INVALID_VERTICAL_ALIGNMENT",    "verticalAlignment value is invalid" } },
    //{ 0x80BC001C,{ "SCE_IME_ERROR_INVALID_EXTENDED",  "extended value is invalid" } },
    //{ 0x80BC001D,{ "SCE_IME_ERROR_INVALID_KEYBOARD_TYPE", "keyboardType value is invalid" } },
    //{ 0x80BC0020,{ "SCE_IME_ERROR_INVALID_WORK",  "work value is invalid" } },
    //{ 0x80BC0021,{ "SCE_IME_ERROR_INVALID_ARG",   "arg value is invalid" } },
    //{ 0x80BC0022,{ "SCE_IME_ERROR_INVALID_HANDLER",   "handler value is invalid" } },
    //{ 0x80BC0023,{ "SCE_IME_ERROR_NO_RESOURCE_ID",    "no resource ID" } },
    //{ 0x80BC0024,{ "SCE_IME_ERROR_INVALID_MODE",  "mode value is invalid" } },
    //{ 0x80BC0030,{ "SCE_IME_ERROR_INVALID_PARAM", "An invalid parameter has been specified" } },
    //{ 0x80BC0031,{ "SCE_IME_ERROR_INVALID_ADDRESS",   "An invalid address has been specified" } },
    //{ 0x80BC0032,{ "SCE_IME_ERROR_INVALID_RESERVED",  "reserved value is invalid" } },
    //{ 0x80BC0033,{ "SCE_IME_ERROR_INVALID_TIMING",    "The execution timing is invalid" } },
    //{ 0x80BC00FF,{ "SCE_IME_ERROR_INTERNAL",  "internal error" } },
    //{ 0x80BC0101,{ "SCE_IME_DIALOG_ERROR_INVALID_TITLE",  "title value is invalid" } },
    //{ 0x80BC0105,{ "SCE_IME_DIALOG_ERROR_NOT_RUNNING",    "Called during a period other than SCE_IME_DIALOG_STATUS_RUNNING" } },
    //{ 0x80BC0106,{ "SCE_IME_DIALOG_ERROR_NOT_FINISHED",   "Called during a period other than SCE_IME_DIALOG_STATUS_FINISHED" } },
    //{ 0x80BC0107,{ "SCE_IME_DIALOG_ERROR_NOT_IN_USE", "sceImeDialogInit() is not called" } },
    //{ 0x80BC1001,{ "SCE_IME_BACKEND_ERROR_BUSY",  "ImeBackend library is already running" } },
    //{ 0x80BC1002,{ "SCE_IME_BACKEND_ERROR_NOT_OPENED",    "Processing has not started" } },
    //{ 0x80BC1003,{ "SCE_IME_BACKEND_ERROR_NOT_ACTIVE",    "Application is not active" } },
    //{ 0x80BC1004,{ "SCE_IME_BACKEND_ERROR_INVALID_STATE", "The internal state in ImeBackend library is invalid" } },
    //{ 0x80BC1010,{ "SCE_IME_BACKEND_ERROR_INVALID_USER_ID",   "userId value is invalid" } },
    //{ 0x80BC1011,{ "SCE_IME_BACKEND_ERROR_INVALID_LANGUAGE",  "language value is invalid" } },
    //{ 0x80BC1012,{ "SCE_IME_BACKEND_ERROR_INVALID_OPTION",    "option value is invalid" } },
    //{ 0x80BC1013,{ "SCE_IME_BACKEND_ERROR_DICTIONARY_OPEN",   "Dictionary open error" } },
    //{ 0x80BC1014,{ "SCE_IME_BACKEND_ERROR_INVALID_EXTENDED",  "extended value or content is invalid" } },
    //{ 0x80BC1030,{ "SCE_IME_BACKEND_ERROR_PARAM", "param value is invalid" } },
    //{ 0x80BC1031,{ "SCE_IME_BACKEND_ERROR_INVALID_ADDRESS",   "Address is invalid" } },
    //{ 0x80BC1032,{ "SCE_IME_BACKEND_ERROR_INVALID_RESERVED",  "reserved value is invalid" } },
    //{ 0x80BC1033,{ "SCE_IME_BACKEND_ERROR_INVALID_TIMING",    "Execution timing is invalid" } },
    //{ 0x80BC1034,{ "SCE_IME_BACKEND_ERROR_INVALID_PATH",  "File path is invalid" } },
    //{ 0x80BC10FF,{ "SCE_IME_BACKEND_ERROR_OTHER", "other errors, internal error" } },
    //{ 0x80BE0001,{ "SCE_SCREENSHOT_ERROR_INVALID_ARGUMENT",   "Parameter error" } },
    //{ 0x80BE0002,{ "SCE_SCREENSHOT_ERROR_NO_MEMORY",  "Insufficient memory" } },
    //{ 0x80BE0003,{ "SCE_SCREENSHOT_ERROR_FILE_NOT_FOUND", "File not found" } },
    //{ 0x80BE0004,{ "SCE_SCREENSHOT_ERROR_NOT_SUPPORTED_FORMAT",   "Invalid file format" } },
    //{ 0x80BE0005,{ "SCE_SCREENSHOT_ERROR_MEDIA_FULL", "Insufficient storage capacity" } },
    //{ 0x80BE0006,{ "SCE_SCREENSHOT_ERROR_INTERNAL",   "Other internal error" } },
    //{ 0x80BE000E,{ "SCE_SCREENSHOT_ERROR_NOT_SUPPORTED_DATA", "Invalid data" } },
    //{ 0x80C10000,{ "SCE_VIDEODEC_ERROR_API_FAIL", "decoder API failed" } },
    //{ 0x80C10001,{ "SCE_VIDEODEC_ERROR_CODEC_TYPE",   "invalid codec type" } },
    //{ 0x80C10002,{ "SCE_VIDEODEC_ERROR_STRUCT_SIZE",  "invalid struct size" } },
    //{ 0x80C10003,{ "SCE_VIDEODEC_ERROR_HANDLE",   "invalid decoder handle" } },
    //{ 0x80C10004,{ "SCE_VIDEODEC_ERROR_CPU_MEMORY_SIZE",  "invalid size of CPU memory" } },
    //{ 0x80C10005,{ "SCE_VIDEODEC_ERROR_CPU_MEMORY_POINTER",   "invalid pointer for CPU memory" } },
    //{ 0x80C10006,{ "SCE_VIDEODEC_ERROR_CPU_GPU_MEMORY_SIZE",  "invalid size of CPU/GPU memory" } },
    //{ 0x80C10007,{ "SCE_VIDEODEC_ERROR_CPU_GPU_MEMORY_POINTER",   "invalid pointer for CPU/GPU memory" } },
    //{ 0x80C10008,{ "SCE_VIDEODEC_ERROR_SHADER_CONTEXT_POINTER",   "invalid pointer for shader context" } },
    //{ 0x80C10009,{ "SCE_VIDEODEC_ERROR_AU_SIZE",  "invalid access unit size" } },
    //{ 0x80C1000A,{ "SCE_VIDEODEC_ERROR_AU_POINTER",   "invalid pointer for access unit" } },
    //{ 0x80C1000B,{ "SCE_VIDEODEC_ERROR_FRAME_BUFFER_SIZE",    "invalid frame buffer size" } },
    //{ 0x80C1000C,{ "SCE_VIDEODEC_ERROR_FRAME_BUFFER_POINTER", "invalid pointer for frame buffer" } },
    //{ 0x80C1000D,{ "SCE_VIDEODEC_ERROR_FRAME_BUFFER_ALIGNMENT",   "invalid frame buffer alignment" } },
    //{ 0x80C1000E,{ "SCE_VIDEODEC_ERROR_CONFIG_INFO",  "invalid value in SceVideodecConfigInfo" } },
    //{ 0x80C1000F,{ "SCE_VIDEODEC_ERROR_ARGUMENT_POINTER", "invalid argument pointer" } },
    //{ 0x80C40001,{ "SCE_PAD_TRACKER_ERROR_NOT_INIT",  "Not initialized." } },
    //{ 0x80C40002,{ "SCE_PAD_TRACKER_ERROR_ALREADY_INIT",  "Already initialized." } },
    //{ 0x80C40003,{ "SCE_PAD_TRACKER_ERROR_INVALID_ARG",   "Invalid argument." } },
    //{ 0x80C40004,{ "SCE_PAD_TRACKER_ERROR_INVALID_HANDLE",    "Invalid Pad library handle." } },
    //{ 0x80D11000,{ "SCE_GNM_ERROR_SUBMISSION_FAILED_INVALID_ARGUMENT",    "Invalid arguments passed to the submit function." } },
    //{ 0x80D11001,{ "SCE_GNM_ERROR_SUBMISSION_NOT_ENOUGH_RESOURCES",   "Not enough resources to submit the command buffers; try to split reduced the number of DCB/CCB to submit at once." } },
    //{ 0x80D11080,{ "SCE_GNM_ERROR_SUBMISSION_AND_FLIP_FAILED_INVALID_COMMAND_BUFFER", "prepareFlip() hasn't been called." } },
    //{ 0x80D11081,{ "SCE_GNM_ERROR_SUBMISSION_AND_FLIP_FAILED_INVALID_QUEUE_FULL", "Flip queue full." } },
    //{ 0x80D11082,{ "SCE_GNM_ERROR_SUBMISSION_AND_FLIP_FAILED_REQUEST_FAILED", "Flip request failed." } },
    //{ 0x80D110FF,{ "SCE_GNM_ERROR_SUBMISSION_FAILED_INTERNAL_ERROR",  "Internal Error." } },
    //{ 0x80D12000,{ "SCE_GNM_ERROR_VALIDATION_WARNING",    "Gnm Validate warning detected." } },
    //{ 0x80D12001,{ "SCE_GNM_ERROR_VALIDATION_WARNING_RWBUFFER_ROTYPE",    "A RW buffer or texture was used when the memory type was set to read-only via setResourceMemoryType(). This is determined by checking RWResource inputs to shaders against the RO bit set in the V# or T#." } },
    //{ 0x80D12002,{ "SCE_GNM_ERROR_VALIDATION_WARNING_BLENDING",   "Blending parameters are invalid for current render target binding." } },
    //{ 0x80D12003,{ "SCE_GNM_ERROR_VALIDATION_WARNING_DRAW_CU_MASK",   "CU mask configuration could lead to GPU hangs." } },
    //{ 0x80D12004,{ "SCE_GNM_ERROR_VALIDATION_WARNING_MRT_SETUP",  "Render target binding is inconsistent with current render state settings for draw call, this may lead to undefined results." } },
    //{ 0x80D12005,{ "SCE_GNM_ERROR_VALIDATION_WARNING_DEPTH_RT_SETUP", "Depth render target binding is inconsistent with current render state settings for draw call, this may lead to undefined results." } },
    //{ 0x80D1200F,{ "SCE_GNM_ERROR_VALIDATION_WARNING_PS_AND_MRT_FORMAT",  "Pixel Shader output and bound render target formats are incompatible, this may lead to undefined results." } },
    //{ 0x80D13000,{ "SCE_GNM_ERROR_VALIDATION_ERROR",  "Gnm Validate error detected." } },
    //{ 0x80D13001,{ "SCE_GNM_ERROR_VALIDATION_VSHARP", "The address of a V# is invalid." } },
    //{ 0x80D13002,{ "SCE_GNM_ERROR_VALIDATION_TSHARP", "The address of a T# is invalid." } },
    //{ 0x80D13003,{ "SCE_GNM_ERROR_VALIDATION_RESOURCE",   "The address of either a T# or a V# is invalid." } },
    //{ 0x80D13004,{ "SCE_GNM_ERROR_VALIDATION_TABLE_MEMORY",   "The address of a resource, sampler, constant buffer, or global table is invalid." } },
    //{ 0x80D13005,{ "SCE_GNM_ERROR_VALIDATION_WRITE_EVENT_OP", "A Gnm::writeAtEndOfPipe() function was called with an invalid EndOfPipeEventType." } },
    //{ 0x80D13006,{ "SCE_GNM_ERROR_VALIDATION_INDEX_BUFFER",   "The address of the index buffer is invalid." } },
    //{ 0x80D13007,{ "SCE_GNM_ERROR_VALIDATION_TESS_FACTOR_BUFFER", "The tessellation factor buffer is invalid." } },
    //{ 0x80D13008,{ "SCE_GNM_ERROR_VALIDATION_SCRATCH_RING",   "The scratch ring is invalid." } },
    //{ 0x80D13009,{ "SCE_GNM_ERROR_VALIDATION_PRIMITIVE_TYPE", "The primitive type is not set before a draw call." } },
    //{ 0x80D1300A,{ "SCE_GNM_ERROR_VALIDATION_INDEX_SIZE", "The index size is not set before an indexed draw call." } },
    //{ 0x80D1300B,{ "SCE_GNM_ERROR_VALIDATION_INLINE_DRAW_SIZE",   "The size of the inlined buffer of a drawIndexInline() call is incorrect." } },
    //{ 0x80D1300C,{ "SCE_GNM_ERROR_VALIDATION_NUM_INPUT_PATCHES",  "In order to use patches, the number of patches must be set via the Gnm::TessellationRegisters." } },
    //{ 0x80D1300D,{ "SCE_GNM_ERROR_VALIDATION_GS_MODE",    "Gnm::DrawCommandBuffer::setGsMode() is called with GsMode kGsModeDisable when Gnm::DrawCommandBuffer::setActiveShaderStages() has the GS stage disabled." } },
    //{ 0x80D1300E,{ "SCE_GNM_ERROR_VALIDATION_SHADER_ADDRESS", "An enabled shader has an invalid address." } },
    //{ 0x80D1300F,{ "SCE_GNM_ERROR_VALIDATION_BORDER_COLOR_TABLE", "The address of border color table is invalid." } },
    //{ 0x80D13010,{ "SCE_GNM_ERROR_VALIDATION_SSHARP", "S# has invalid data." } },
    //{ 0x80D13011,{ "SCE_GNM_ERROR_VALIDATION_DISPATCH_DRAW",  "Incorrect setting detected for Dispatch Draw." } },
    //{ 0x80D13012,{ "SCE_GNM_ERROR_VALIDATION_ACTIVE_SHADER_STAGE",    "Incorrect active shader stage has been set for draw type." } },
    //{ 0x80D13013,{ "SCE_GNM_ERROR_VALIDATION_DCB",    "DCB error detected while validating command buffer." } },
    //{ 0x80D13014,{ "SCE_GNM_ERROR_VALIDATION_MISMATCH_SHADER_STAGE",  "Shader binary is bound to an incorrect shader stage." } },
    //{ 0x80D13015,{ "SCE_GNM_ERROR_VALIDATION_MRT_SETUP",  "Render target binding is inconsistent with current render state settings for draw call." } },
    //{ 0x80D13016,{ "SCE_GNM_ERROR_VALIDATION_BAD_OP_CODE",    "Invalid opcode found in command buffer." } },
    //{ 0x80D13017,{ "SCE_GNM_ERROR_VALIDATION_DEPTH_RT_SETUP", "Depth render target binding is inconsistent with current render state settings for draw call." } },
    //{ 0x80D13018,{ "SCE_GNM_ERROR_VALIDATION_NUM_INSTANCES",  "setNumInstances() call is required prior to draw call, after indirect-draw call has been called." } },
    //{ 0x80D13019,{ "SCE_GNM_ERROR_VALIDATION_SRT",    "SRT Binding is invalid." } },
    //{ 0x80D13FFD,{ "SCE_GNM_ERROR_VALIDATION_INVALID_ARGUMENT",   "An invalid argument was passed to Gnm validation module." } },
    //{ 0x80D13FFE,{ "SCE_GNM_ERROR_VALIDATION_FAILED_INTERNAL_ERROR",  "An internal error occurred in the Validation module and all subsequent validation passes will be skipped." } },
    //{ 0x80D13FFF,{ "SCE_GNM_ERROR_VALIDATION_NOT_ENABLED",    "Validation is not enabled. Please enable \"PA Debug\" in the target manager." } },
    //{ 0x80D15000,{ "SCE_GNM_ERROR_CAPTURE_FILE_IO",   "Cannot open the specified file for writing." } },
    //{ 0x80D15001,{ "SCE_GNM_ERROR_CAPTURE_RAZOR_NOT_LOADED",  "Cannot capture if Razor for PlayStation®4 (Razor) is not enabled." } },
    //{ 0x80D15002,{ "SCE_GNM_ERROR_CAPTURE_NOTHING_TO_CAPTURE",    "The command buffer being captured is empty." } },
    //{ 0x80D1500F,{ "SCE_GNM_ERROR_CAPTURE_FAILED_INTERNAL",   "Internal error." } },
    //{ 0x80D17000,{ "SCE_GNM_ERROR_COMPUTEQUEUE_INVALID_PIPE_ID",  "The pipe ID must between 0 or 3 (inclusive)." } },
    //{ 0x80D17001,{ "SCE_GNM_ERROR_COMPUTEQUEUE_INVALID_QUEUE_ID", "The queue ID must between 0 or 7 (inclusive)." } },
    //{ 0x80D17002,{ "SCE_GNM_ERROR_COMPUTEQUEUE_INVALID_RING_SIZE",    "Invalid Ring Size (must be multiple of DW and a power of 2)." } },
    //{ 0x80D17003,{ "SCE_GNM_ERROR_COMPUTEQUEUE_INVALID_RING_BASE_ADDR",   "The Ring Base Address must be 256 bytes aligned." } },
    //{ 0x80D17004,{ "SCE_GNM_ERROR_COMPUTEQUEUE_INVALID_READ_PTR_ADDR",    "The Read Ptr Address must be 4 bytes aligned." } },
    //{ 0x80D17005,{ "SCE_GNM_ERROR_COMPUTEQUEUE_INVALID_PIPE_PRIORITY",    "Invalid pipe priority." } },
    //{ 0x80D170FF,{ "SCE_GNM_ERROR_COMPUTEQUEUE_INTERNAL", "Internal error." } },
    //{ 0x80D19000,{ "SCE_GNM_ERROR_RESOURCE_REGISTRATION_INVALID_ARGUMENT",    "Invalid argument." } },
    //{ 0x80D19001,{ "SCE_GNM_ERROR_RESOURCE_REGISTRATION_INVALID_SHADER",  "The shader is invalid." } },
    //{ 0x80D19002,{ "SCE_GNM_ERROR_RESOURCE_REGISTRATION_STALE_HANDLE",    "The handle has been used after freeing." } },
    //{ 0x80D19003,{ "SCE_GNM_ERROR_RESOURCE_REGISTRATION_FULL",    "No space available." } },
    //{ 0x80D19004,{ "SCE_GNM_ERROR_RESOURCE_REGISTRATION_NOT_PERMITTED",   "The operation is not permitted." } },
    //{ 0x80D19005,{ "SCE_GNM_ERROR_RESOURCE_REGISTRATION_OUTPUT_ARGUMENT_IS_NULL", "The output argument is <c>NULL</c>." } },
    //{ 0x80D19006,{ "SCE_GNM_ERROR_RESOURCE_REGISTRATION_OWNER_HANDLE_INVALID",    "The owner handle is invalid." } },
    //{ 0x80D19007,{ "SCE_GNM_ERROR_RESOURCE_REGISTRATION_RESOURCE_HANDLE_INVALID", "The resource handle is invalid." } },
    //{ 0x80D19008,{ "SCE_GNM_ERROR_RESOURCE_REGISTRATION_RESOURCE_TYPE_INVALID",   "The resource type is invalid." } },
    //{ 0x80D19009,{ "SCE_GNM_ERROR_RESOURCE_REGISTRATION_GDS_RESOURCE_TYPE_INVALID",   "The GDS resource type is invalid." } },
    //{ 0x80D1900A,{ "SCE_GNM_ERROR_RESOURCE_REGISTRATION_RESOURCE_SIZE_INVALID",   "The resource size is invalid." } },
    //{ 0x80D1900B,{ "SCE_GNM_ERROR_RESOURCE_REGISTRATION_RESOURCE_ADDRESS_IS_NULL",    "The resource address is <c>NULL</c>." } },
    //{ 0x80D1900C,{ "SCE_GNM_ERROR_RESOURCE_REGISTRATION_GDS_OFFSET_INVALID",  "The GDS offset is invalid." } },
    //{ 0x80D1900D,{ "SCE_GNM_ERROR_RESOURCE_REGISTRATION_RESOURCE_NAME_IS_NULL",   "The resource name is <c>NULL</c>." } },
    //{ 0x80D1900E,{ "SCE_GNM_ERROR_RESOURCE_REGISTRATION_OWNER_NAME_IS_NULL",  "The owner name is <c>NULL</c>." } },
    //{ 0x80D1900F,{ "SCE_GNM_ERROR_RESOURCE_REGISTRATION_FIND_CALLBACK_IS_NULL",   "The find callback is <c>NULL</c>." } },
    //{ 0x80D19010,{ "SCE_GNM_ERROR_RESOURCE_REGISTRATION_RESOURCE_IS_NOT_SHADER",  "The resource is not a shader." } },
    //{ 0x80D19011,{ "SCE_GNM_ERROR_RESOURCE_REGISTRATION_USER_MEMORY_PARAM_IS_NULL",   "The user memory parameter is <c>NULL</c>." } },
    //{ 0x80D19012,{ "SCE_GNM_ERROR_RESOURCE_REGISTRATION_USER_MEMORY_PARAM_NOT_ALIGNED",   "The user memory parameter is not aligned." } },
    //{ 0x80D19013,{ "SCE_GNM_ERROR_RESOURCE_REGISTRATION_INVALID_NAME_LENGTH_PARAM",   "The name length parameter is invalid." } },
    //{ 0x80D19014,{ "SCE_GNM_ERROR_RESOURCE_REGISTRATION_INVALID_SIZE_PARAM",  "The size parameter is invalid." } },
    //{ 0x80D19015,{ "SCE_GNM_ERROR_RESOURCE_REGISTRATION_INVALID_NUM_RESOURCES_PARAM", "The number of resources param is invalid." } },
    //{ 0x80D19FFF,{ "SCE_GNM_ERROR_RESOURCE_REGISTRATION_INTERNAL",    "Internal error." } },
    //{ 0x80D1B000,{ "SCE_GNM_ERROR_GET_GPU_INFO_PARAMETER_NULL",   "any parameter is null." } },
    //{ 0x80D1B001,{ "SCE_GNM_ERROR_GET_GPU_INFO_FAILED",   "failed to get the information." } },
    //{ 0x80D1B002,{ "SCE_GNM_ERROR_GET_GPU_INFO_PARAMETER_INVALID",    "any parameter is invalid." } },
    //{ 0x80D21000,{ "SCE_GNMX_ERROR_DISPATCH_DRAW_INVALID_ARGUMENTS",  "Invalid Argument in Dispatch Draw." } },
    //{ 0x80D21001,{ "SCE_GNMX_ERROR_DISPATCH_DRAW_OUT_OF_SPACE_FOR_INDEX_DATA",    "Out of space for index data in Dispatch Draw." } },
    //{ 0x80D21002,{ "SCE_GNMX_ERROR_DISPATCH_DRAW_OUT_OF_SPACE_FOR_BLOCK_OFFSET",  "Out of space for block offset in Dispatch Draw." } },
    //{ 0x80D21003,{ "SCE_GNMX_ERROR_DISPATCH_DRAW_UNREPRESENTABLE_OFFSET", "Unrepresentable offset in Dispatch Draw." } },
    //{ 0x80D30000,{ "SCE_GPU_ADDRESS_ERROR_STATUS_INVALID_ARGUMENT",   "The operation failed due to an invalid argument." } },
    //{ 0x80D30001,{ "SCE_GPU_ADDRESS_ERROR_STATUS_INTERNAL_TILING",    "The operation failed due to an internal tiling error." } },
    //{ 0x80D70000,{ "SCE_TEXTURE_TOOL_ERROR_COMPUTE_COMPRESS_INVALID_FORMAT",  "Texture format isn't BC1 - BC7. Or vmBuffer is NULL." } },
    //{ 0x80D70001,{ "SCE_TEXTURE_TOOL_ERROR_COMPUTE_COMPRESS_INVALID_BC_ENCODER",  "BC Encoder is NULL." } },
    //{ 0x80D70002,{ "SCE_TEXTURE_TOOL_ERROR_COMPUTE_COMPRESS_BUFFER_SIZE", "kBlockEncoderBufferSize is too small we need to make it bigger." } },
    //{ 0x80D70003,{ "SCE_TEXTURE_TOOL_ERROR_COMPUTE_COMPRESS_INVALID_POINTER_OR_ENCODER",  "some pointers may be invalid and encoder may not be initialized." } },
    //{ 0x80D70004,{ "SCE_TEXTURE_TOOL_ERROR_COMPUTE_COMPRESS_INVALID_TEXTURE", "Texture dimentions should matche the srcTexture dimentions. Format should matche the encoder format" } },
    //{ 0x80D70005,{ "SCE_TEXTURE_TOOL_ERROR_COMPUTE_COMPRESS_ALLOCATE_FAILURE_FROM_DCB",   "not enough room for extendedUserData in dcb" } },
    //{ 0x80D70100,{ "SCE_TEXTURE_TOOL_ERROR_GNF_INVALID_POINTER",  "The operation failed because a NULL pointer was passed to write to." } },
    //{ 0x80D70101,{ "SCE_TEXTURE_TOOL_ERROR_GNF_NOT_GNF_FILE", "The operation failed because the file was not a valid GNF file." } },
    //{ 0x80D70102,{ "SCE_TEXTURE_TOOL_ERROR_GNF_CORRUPT_HEADER",   "The operation failed because the size value for the file header contents is not valid." } },
    //{ 0x80D70103,{ "SCE_TEXTURE_TOOL_ERROR_GNF_FILE_IS_TOO_SHORT",    "The operation failed because the file size is too small to contain the contents of the file." } },
    //{ 0x80D70104,{ "SCE_TEXTURE_TOOL_ERROR_GNF_VERSION_MISMATCH", "The operation failed because the GNF version does not match current GNF version in the Texture Library." } },
    //{ 0x80D70105,{ "SCE_TEXTURE_TOOL_ERROR_GNF_ALIGNMENT_OUT_OF_RANGE",   "The operation failed because the alignment value is out of range. It can range between 0 and 31." } },
    //{ 0x80D70106,{ "SCE_TEXTURE_TOOL_ERROR_GNF_CONTENTS_SIZE_MISMATCH",   "The operation failed because the size of the file contents, defined in the header, does not match the computed size of the file contents." } },
    //{ 0x80D70107,{ "SCE_TEXTURE_TOOL_ERROR_GNF_CANNOT_OPEN_FILE_FOR_READ",    "The operation failed because the GNF file could not be opened for reading/appending." } },
    //{ 0x80D70108,{ "SCE_TEXTURE_TOOL_ERROR_GNF_PIXEL_DATA_SIZE_MISMATCH", "The operation failed because the file size does not match the stream size of the GNF file contents" } },
    //{ 0x80D90001,{ "SCE_APP_CONTENT_ERROR_NOT_INITIALIZED",   "Not initialized." } },
    //{ 0x80D90002,{ "SCE_APP_CONTENT_ERROR_PARAMETER", "Invalid parameter." } },
    //{ 0x80D90003,{ "SCE_APP_CONTENT_ERROR_BUSY",  "Contents already mounted." } },
    //{ 0x80D90004,{ "SCE_APP_CONTENT_ERROR_NOT_MOUNTED",   "Contents not mounted." } },
    //{ 0x80D90005,{ "SCE_APP_CONTENT_ERROR_NOT_FOUND", "Contents not found." } },
    //{ 0x80D90006,{ "SCE_APP_CONTENT_ERROR_MOUNT_FULL",    "Reached mount max." } },
    //{ 0x80D90007,{ "SCE_APP_CONTENT_ERROR_DRM_NO_ENTITLEMENT",    "Contents no entitlement." } },
    //{ 0x80D90008,{ "SCE_APP_CONTENT_ERROR_NO_SPACE",  "Not enough space in HDD." } },
    //{ 0x80D90009,{ "SCE_APP_CONTENT_ERROR_NOT_SUPPORTED", "Not supported." } },
    //{ 0x80D9000A,{ "SCE_APP_CONTENT_ERROR_INTERNAL",  "Internal error." } },
    //{ 0x80D9000B,{ "SCE_APP_CONTENT_ERROR_DOWNLOAD_ENTRY_FULL",   "Reached the max of download entry." } },
    //{ 0x80D9000C,{ "SCE_APP_CONTENT_ERROR_INVALID_PKG",   "Invalid pkg." } },
    //{ 0x80D9000D,{ "SCE_APP_CONTENT_ERROR_OTHER_APPLICATION_PKG", "Other application pkg." } },
    //{ 0x80D9000E,{ "SCE_APP_CONTENT_ERROR_CREATE_FULL",   "Reached create data max." } },
    //{ 0x80D9000F,{ "SCE_APP_CONTENT_ERROR_MOUNT_OTHER_APP",   "Contents already mounted by other application." } },
    //{ 0x80D90010,{ "SCE_APP_CONTENT_ERROR_OF_MEMORY", "Out of memory." } },
    //{ 0x80D90011,{ "SCE_APP_CONTENT_ERROR_ADDCONT_SHRANK",    "Shrank additional content." } },
    //{ 0x80D90012,{ "SCE_APP_CONTENT_ERROR_ADDCONT_NO_IN_QUEUE",   "The additional content is not in download queue." } },
    //{ 0x80D90013,{ "SCE_APP_CONTENT_ERROR_NETWORK",   "Network error." } },
    //{ 0x80D90014,{ "SCE_APP_CONTENT_ERROR_SIGNED_OUT",    "Called in the signed-out state." } },
    //{ 0x80D91000,{ "SCE_APP_CONTENT_ERROR_GET_STORE_COUNTRY", "Failed to get information about store country." } },
    //{ 0x80DA0001,{ "SCE_DBG_KEYBOARD_ERROR_INVALID_ARG",  "invalid argument" } },
    //{ 0x80DA0002,{ "SCE_DBG_KEYBOARD_ERROR_INVALID_PORT", "invalid port" } },
    //{ 0x80DA0003,{ "SCE_DBG_KEYBOARD_ERROR_INVALID_HANDLE",   "invalid handle" } },
    //{ 0x80DA0004,{ "SCE_DBG_KEYBOARD_ERROR_ALREADY_OPENED",   "already opned the port." } },
    //{ 0x80DA0005,{ "SCE_DBG_KEYBOARD_ERROR_NOT_INITIALIZED",  "library uninitialized." } },
    //{ 0x80DA00FF,{ "SCE_DBG_KEYBOARD_ERROR_FATAL",    "fatal error" } },
    //{ 0x80DB0001,{ "SCE_NP_SNS_FACEBOOK_DIALOG_ERROR_INTERNAL",   "An internal error occurred in the utility." } },
    //{ 0x80DB0002,{ "SCE_NP_SNS_FACEBOOK_DIALOG_ERROR_NOT_SIGNIN", "Without signing in, the functionality of Facebook cannot be used." } },
    //{ 0x80DB0003,{ "SCE_NP_SNS_FACEBOOK_DIALOG_ERROR_ACCESS_NOT_ALLOWED", "User permissions could not be obtained" } },
    //{ 0x80DB0004,{ "SCE_NP_SNS_FACEBOOK_DIALOG_ERROR_UGM_RESTRICTION",    "Due to UGM restriction, the functionality of Facebook cannot be used." } },
    //{ 0x80DB0005,{ "SCE_NP_SNS_FACEBOOK_DIALOG_ERROR_CERTIFICATE_VERIFICATION",   "The certificate verification was failed on loading Web App" } },
    //{ 0x80DB0006,{ "SCE_NP_SNS_FACEBOOK_DIALOG_ERROR_WEB_APP_FATAL",  "A fatal error occured in Web App" } },
    //{ 0x80DC0001,{ "SCE_VIDEOCORE_ERROR_CODE_INVALID_PARAM",  "invalid argument" } },
    //{ 0x80DC0003,{ "SCE_VIDEOCORE_ERROR_CODE_INVALID_STATUS", "invalid status" } },
    //{ 0x80DC0004,{ "SCE_VIDEOCORE_ERROR_CODE_INVALID_STATUS_COREIF",  "invalid status（Core IF）" } },
    //{ 0x80DC0005,{ "SCE_VIDEOCORE_ERROR_CODE_STREAM_FULL",    "stream full" } },
    //{ 0x80DC0006,{ "SCE_VIDEOCORE_ERROR_CODE_NOT_EXIST_STREAMID", "not exist streamId" } },
    //{ 0x80DC000D,{ "SCE_VIDEOCORE_ERROR_CODE_NO_ALLOCATE_MEMORY", "can not allocate memory" } },
    //{ 0x80DC000E,{ "SCE_VIDEOCORE_ERROR_CODE_UNUSABLE_THIS_API",  "can not use this api. use other api" } },
    //{ 0x80DC0010,{ "SCE_VIDEOCORE_ERROR_CODE_RESULT_TIMEOUT", "timeout error" } },
    //{ 0x80DC0011,{ "SCE_VIDEOCORE_ERROR_CODE_REQUEST_FULL",   "request full" } },
    //{ 0x80DC0012,{ "SCE_VIDEOCORE_ERROR_CODE_NOT_EXIST_REQUESTID",    "not exist requestId" } },
    //{ 0x80DC0013,{ "SCE_VIDEOCORE_ERROR_CODE_REGISTERED_CALLBACK_FULL",   "registered callback full" } },
    //{ 0x80DC0014,{ "SCE_VIDEOCORE_ERROR_CODE_RESOURCE_HANDLE_FULL",   "resource handle full" } },
    //{ 0x80DC0015,{ "SCE_VIDEOCORE_ERROR_CODE_NOT_EXIST_RESOURCE_HANDLE",  "not exist resource handle" } },
    //{ 0x80DC0016,{ "SCE_VIDEOCORE_ERROR_CODE_NO_DECODER_RESOURCE",    "can not acquire decoder resource" } },
    //{ 0x80DC0017,{ "SCE_VIDEOCORE_ERROR_CODE_STREAM_SUSPENDED",   "stream suspended" } },
    //{ 0x80DC0018,{ "SCE_VIDEOCORE_ERROR_CODE_STREAM_ABORTED", "stream aborted" } },
    //{ 0x80DC0019,{ "SCE_VIDEOCORE_ERROR_CODE_BACKGROUND", "can not be processed at the back" } },
    //{ 0x80DC001B,{ "SCE_VIDEOCORE_ERROR_CODE_GENERATE_THUMBNAIL_BUSY",    "cannot generate thumbnail for game" } },
    //{ 0x80DC001C,{ "SCE_VIDEOCORE_ERROR_CODE_NOT_EXIST_SOURCEID", "not exist sourceId" } },
    //{ 0x80DC001D,{ "SCE_VIDEOCORE_ERROR_CODE_INPUT_BUFFER_FULL",  "InputBuffer is full" } },
    //{ 0x80DC001E,{ "SCE_VIDEOCORE_ERROR_CODE_PARSING_MEDIA_SEGMENT",  "parsing media segment" } },
    //{ 0x80DC001F,{ "SCE_VIDEOCORE_ERROR_CODE_SOURCE_FULL",    "source full" } },
    //{ 0x80DC0020,{ "SCE_VIDEOCORE_ERROR_CODE_NOT_MEDIA_SOURCE_EXTENSIONS",    "Not MediaSourceExtensions" } },
    //{ 0x80DC0021,{ "SCE_VIDEOCORE_ERROR_CODE_GENERATE_THUMBNAIL_TIMEOUT", "timeout of get thumbnail" } },
    //{ 0x80DC0100,{ "SCE_VIDEOCORE_ERROR_CODE_INVALID_PARAM_CORE", "invalid argument（Core）" } },
    //{ 0x80DC0300,{ "SCE_VIDEOCORE_ERROR_CODE_NOT_EXIST_STREAM",   "not exist stream" } },
    //{ 0x80DC0400,{ "SCE_VIDEOCORE_ERROR_CODE_NOPLAYABLE", "not playable" } },
    //{ 0x80DC0500,{ "SCE_VIDEOCORE_ERROR_CODE_STOP",   "error stop" } },
    //{ 0x80DC0900,{ "SCE_VIDEOCORE_ERROR_CODE_ENABLE_RAZOR",   "enable Razor setting" } },
    //{ 0x80DC0A00,{ "SCE_VIDEOCORE_ERROR_CODE_HTTP_NOT_FOUND", "detect HTTP 404 error" } },
    //{ 0x80DC0B00,{ "SCE_VIDEOCORE_ERROR_CODE_NOT_EXIST_SOURCE_BUFFER",    "not exist sourceBuffer" } },
    //{ 0x80DC0C00,{ "SCE_VIDEOCORE_ERROR_CODE_SOURCE_BUFFER_NOT_SUPPORTED",    "this source buffer is not supported" } },
    //{ 0x80DC0D00,{ "SCE_VIDEOCORE_ERROR_CODE_SOURCE_BUFFER_REACHED_LIMIT",    "reached sourceBuffer creation limit" } },
    //{ 0x80DC8002,{ "SCE_VIDEOCORE_ERROR_CODE_INVALID_PARAM_COREIF",   "invalid argument（Core IF）" } },
    //{ 0x80DC8008,{ "SCE_VIDEOCORE_ERROR_CODE_VIDEOCORE_FUNCTION", "not regist video core function" } },
    //{ 0x80DC8009,{ "SCE_VIDEOCORE_ERROR_CODE_SCE_FUNCTION",   "sce function error" } },
    //{ 0x80DC800A,{ "SCE_VIDEOCORE_ERROR_CODE_KERNEL_FUNCTION",    "kernel function error" } },
    //{ 0x80DC800B,{ "SCE_VIDEOCORE_ERROR_CODE_IPMI",   "ipmi inter process communication error" } },
    //{ 0x80DC800C,{ "SCE_VIDEOCORE_ERROR_CODE_IPMI_COREIF",    "ipmi inter process communication error（Core IF）" } },
    //{ 0x80DC80FF,{ "SCE_VIDEOCORE_ERROR_CODE_INTERNAL",   "internal program error" } },
    //{ 0x80DC8200,{ "SCE_VIDEOCORE_ERROR_CODE_INVALID_STATUS_CORE",    "invalid status（Core）" } },
    //{ 0x80DC8600,{ "SCE_VIDEOCORE_ERROR_CODE_SCE_FUNCTION_CORE",  "sce function error（Core）" } },
    //{ 0x80DC8700,{ "SCE_VIDEOCORE_ERROR_CODE_KERNEL_FUNCTION_CORE",   "kernel function error（Core）" } },
    //{ 0x80DC8800,{ "SCE_VIDEOCORE_ERROR_CODE_IPMI_CORE",  "ipmi inter process communication error（Core）" } },
    //{ 0x80DCFF00,{ "SCE_VIDEOCORE_ERROR_CODE_INTERNAL_CORE",  "internal program error（Core）" } },
    //{ 0x80DE0001,{ "SCE_PF_AUTH_CLIENT_ERROR_INVALID_ARGUMENT",   "Invalid argument" } },
    //{ 0x80DE0002,{ "SCE_PF_AUTH_CLIENT_ERROR_OUT_OF_MEMORY",  "No memory" } },
    //{ 0x80DE0003,{ "SCE_PF_AUTH_CLIENT_ERROR_ABORTED",    "Request is aborted" } },
    //{ 0x80DE0010,{ "SCE_PF_AUTH_CLIENT_ERROR_UNSUPPORTED_SYSTEM_SOFTWARE_VERSION",    "Invalid system software version" } },
    //{ 0x80DE0011,{ "SCE_PF_AUTH_CLIENT_ERROR_EMERGENT_SYSTEM_SOFTWARE_UPDATE_REQUIRED",   "Emergent system software update is required(Not used at Day1)" } },
    //{ 0x80DE0012,{ "SCE_PF_AUTH_CLIENT_ERROR_CONSOLE_BANNED", "Console is banned" } },
    //{ 0x80DE0013,{ "SCE_PF_AUTH_CLIENT_ERROR_AUTH_FAILED",    "Authentification is failed based on the client side problem" } },
    //{ 0x80DE0014,{ "SCE_PF_AUTH_CLIENT_ERROR_CONSOLE_TOKEN_BUFFER_SIZE_NOT_ENOUGH",   "The buffer size for console token is not enough to store the console token" } },
    //{ 0x80DE0015,{ "SCE_PF_AUTH_CLIENT_ERROR_SIGNATURE_NOT_VALID",    "The signature is not valid" } },
    //{ 0x80DE0030,{ "SCE_PF_AUTH_CLIENT_SERVER_ERROR_UNKNOWN", "Unknown server error" } },
    //{ 0x80DE0031,{ "SCE_PF_AUTH_CLIENT_SERVER_ERROR_NULL_VALUE_NOT_ALLOWED",  "NULL is set as wrongly" } },
    //{ 0x80DE0032,{ "SCE_PF_AUTH_CLIENT_SERVER_ERROR_INVALID_REQUEST_BODY",    "Invalid request body(English)" } },
    //{ 0x80DE0033,{ "SCE_PF_AUTH_CLIENT_SERVER_ERROR_INVALID_QUERY_STRING",    "Invalid query string(English)" } },
    //{ 0x80DE0034,{ "SCE_PF_AUTH_CLIENT_SERVER_ERROR_INVALID_NP_ENVIRONMENT",  "Invalid NP environment(English)" } },
    //{ 0x80DE0035,{ "SCE_PF_AUTH_CLIENT_SERVER_ERROR_TOOL_LARGE_BODY", "Body size is too big" } },
    //{ 0x80DE0036,{ "SCE_PF_AUTH_CLIENT_SERVER_ERROR_UNSUPPORTED_API_VERSION", "Unsupported API version" } },
    //{ 0x80DE0037,{ "SCE_PF_AUTH_CLIENT_SERVER_ERROR_BAD_REQUEST", "Bad request" } },
    //{ 0x80DE0042,{ "SCE_PF_AUTH_CLIENT_SERVER_ERROR_NOT_AUTHORIZED",  "Server authentification is failed" } },
    //{ 0x80DE0043,{ "SCE_PF_AUTH_CLIENT_SERVER_ERROR_RATE_LIMIT_EXCEEDED", "Rate limite excceeded" } },
    //{ 0x80DE0044,{ "SCE_PF_AUTH_CLIENT_SERVER_ERROR_INTERNAL_SERVER_ERROR",   "Internal server error" } },
    //{ 0x80DE0045,{ "SCE_PF_AUTH_CLIENT_SERVER_ERROR_SERVER_BUSY", "Server busy" } },
    //{ 0x80DE0046,{ "SCE_PF_AUTH_CLIENT_SERVER_ERROR_SERVER_MAINTENANCE",  "Server maintenance" } },
    //{ 0x80DE0047,{ "SCE_PF_AUTH_CLIENT_SERVER_ERROR_SERVICE_CLOSED",  "Service is closed" } },
    //{ 0x80DE0048,{ "SCE_PF_AUTH_CLIENT_SERVER_ERROR_UNEXPECTED_ERROR",    "Unexpected server error" } },
    //{ 0x80DE0049,{ "SCE_PF_AUTH_CLEINT_SERVER_ERROR_INVALID_REQUEST_BODY_SIZE",   "RequestBody size is invalid" } },
    //{ 0x80DE004A,{ "SCE_PF_AUTH_CLIENT_SERVER_ERROR_MESSAGE_FORMAT_SIGNATURE_VERIFICATION_FAILED",    "Message format signature verification is failed" } },
    //{ 0x80DE004B,{ "SCE_PF_AUTH_CLIENT_SERVER_ERROR_CERTPS_SIGNATURE_VERIFICATION_FAILED",    "CertPS signature verification is failed" } },
    //{ 0x80DE004C,{ "SCE_PF_AUTH_CLIENT_SERVER_ERROR_NO_C1_DATA",  "There is no C1 result on server (Invalid context)" } },
    //{ 0x80DE004D,{ "SCE_PF_AUTH_CLIENT_SERVER_ERROR_DPS_SIGNATURE_VERIFICATION_FAILED",   "D_ps signature verification is failed" } },
    //{ 0x80DE004E,{ "SCE_PF_AUTH_CLIENT_SERVER_ERROR_DPS_MATCHING_CONFIRMATION_FAILED",    "D_ps matching confirmation is failed" } },
    //{ 0x80DE004F,{ "SCE_PF_AUTH_CLIENT_SERVER_ERROR_KSES_HASH_MATCHING_FAILED",   "Kses hash matching is failed" } },
    //{ 0x80DE0050,{ "SCE_PF_AUTH_CLIENT_SERVER_ERROR_CREATED_CONSOLE_TOKEN_TOO_LARGE", "Publishing console token is failed because the size of created console token is bigger than determined max size(English)" } },
    //{ 0x80DE0051,{ "SCE_PF_AUTH_CLIENT_SERVER_ERROR_NOT_FULFILL_A_REQUESTED_VERSION", "Client does not fulfill a requested version for platform authentification(English)" } },
    //{ 0x80DE0052,{ "SCE_PF_AUTH_CLIENT_SERVER_ERROR_INVALID_HEADER_MAGIC",    "Header magic from client is invalid(English)" } },
    //{ 0x80DE0053,{ "SCE_PF_AUTH_CLIENT_SERVER_ERROR_INVALID_HEADER_PROTOCOL_VERSION", "Header protocl version from client is invalid(English)" } },
    //{ 0x80DE0054,{ "SCE_PF_AUTH_CLIENT_SERVER_ERROR_INVALID_HEADER_MSG_TYPE", "Header msg type from client is invalid(English)" } },
    //{ 0x80DE0070,{ "SCE_PF_AUTH_CLIENT_ERROR_SET_CLOCK_TIMEOUT",  "Timeout occurs when setting clock" } },
    //{ 0x80DF0001,{ "SCE_MOUSE_ERROR_INVALID_ARG", "invalid argument" } },
    //{ 0x80DF0002,{ "SCE_MOUSE_ERROR_INVALID_PORT",    "invalid port" } },
    //{ 0x80DF0003,{ "SCE_MOUSE_ERROR_INVALID_HANDLE",  "invalid handle" } },
    //{ 0x80DF0004,{ "SCE_MOUSE_ERROR_ALREADY_OPENED",  "already opned the port." } },
    //{ 0x80DF0005,{ "SCE_MOUSE_ERROR_NOT_INITIALIZED", "library uninitialized." } },
    //{ 0x80DF00FF,{ "SCE_MOUSE_ERROR_FATAL",   "fatal error" } },
    //{ 0x80E21001,{ "SCE_WEB_BROWSER_DIALOG_ERROR_NAVIGATION", "Navigation error" } },
    //{ 0x80E40001,{ "SCE_COMPANION_HTTPD_ERROR_UNKNOWN",   "Undefined error" } },
    //{ 0x80E40002,{ "SCE_COMPANION_HTTPD_ERROR_FATAL", "Unpredictable error occurrence" } },
    //{ 0x80E40003,{ "SCE_COMPANION_HTTPD_ERROR_NOMEM", "Failure in memory allocation" } },
    //{ 0x80E40004,{ "SCE_COMPANION_HTTPD_ERROR_INVALID_PARAM", "Improper parameter" } },
    //{ 0x80E40005,{ "SCE_COMPANION_HTTPD_ERROR_INVALID_OPERATION", "Incorrect processing executed" } },
    //{ 0x80E40006,{ "SCE_COMPANION_HTTPD_ERROR_NOT_INITIALIZED",   "Library uninitialized" } },
    //{ 0x80E40007,{ "SCE_COMPANION_HTTPD_ERROR_ALREADY_INITIALIZED",   "ALREADY initialized" } },
    //{ 0x80E40008,{ "SCE_COMPANION_HTTPD_ERROR_NO_EVENT",  "No events to obtain" } },
    //{ 0x80E40009,{ "SCE_COMPANION_HTTPD_ERROR_NOT_GENERATE_RESPONSE", "Perform default operations without setting an HTTP response" } },
    //{ 0x80E4000A,{ "SCE_COMPANION_HTTPD_ERROR_ALREADY_STARTED",   "HTTP server is already started" } },
    //{ 0x80E4000B,{ "SCE_COMPANION_HTTPD_ERROR_NOT_STARTED",   "HTTP server is not started" } },
    //{ 0x80E4000C,{ "SCE_COMPANION_HTTPD_ERROR_ALREADY_REGISTERED",    "Already registered" } },
    //{ 0x80E4000D,{ "SCE_COMPANION_HTTPD_ERROR_NOT_CONNECTED", "CompanionApp is not connected" } },
    //{ 0x80E4000E,{ "SCE_COMPANION_HTTPD_ERROR_USER_NOT_FOUND",    "User is not found" } },
    //{ 0x80E80001,{ "SCE_WEBVIEW_NETWORK_ERROR_UNSUPPORTED_PROTOCOL",  "Invalid scheme was specified" } },
    //{ 0x80E80002,{ "SCE_WEBVIEW_NETWORK_ERROR_FAILED_INIT",   "Very early initialization code failed. This is likely to be an internal error or problem." } },
    //{ 0x80E80003,{ "SCE_WEBVIEW_NETWORK_ERROR_URL_MALFORMAT", "Invalid URL format was specified" } },
    //{ 0x80E80005,{ "SCE_WEBVIEW_NETWORK_ERROR_COULDNT_RESOLVE_PROXY", "Could not connect to the proxy server." } },
    //{ 0x80E80006,{ "SCE_WEBVIEW_NETWORK_ERROR_COULDNT_RESOLVE_HOST",  "Could not connect to the server." } },
    //{ 0x80E80007,{ "SCE_WEBVIEW_NETWORK_ERROR_COULDNT_CONNECT",   "Failed to connect() to host or proxy." } },
    //{ 0x80E80009,{ "SCE_WEBVIEW_NETWORK_ERROR_REMOTE_ACCESS_DENIED",  "a service was denied by the server due to lack of access - when login fails this is not returned." } },
    //{ 0x80E80012,{ "SCE_WEBVIEW_NETWORK_ERROR_PARTIAL_FILE",  "A file transfer was shorter or larger than expected. This happens when the server first reports an expected transfer size, and then delivers data that doesn't match the previously given size." } },
    //{ 0x80E80015,{ "SCE_WEBVIEW_NETWORK_ERROR_QUOTE_ERROR",   "When sending custom \"QUOTE\" commands to the remote server, one of the commands returned an error code that was 400 or higher." } },
    //{ 0x80E80017,{ "SCE_WEBVIEW_NETWORK_ERROR_WRITE_ERROR",   "could not write file or socket" } },
    //{ 0x80E80019,{ "SCE_WEBVIEW_NETWORK_ERROR_UPLOAD_FAILED", "failed upload \"command\"" } },
    //{ 0x80E8001A,{ "SCE_WEBVIEW_NETWORK_ERROR_READ_ERROR",    "couldn't open/read from file" } },
    //{ 0x80E8001B,{ "SCE_WEBVIEW_NETWORK_ERROR_OUT_OF_MEMORY", "Out of memory. A memory allocation request failed. This is serious badness and things are severely screwed up if this ever occur." } },
    //{ 0x80E8001C,{ "SCE_WEBVIEW_NETWORK_ERROR_OPERATION_TIMEDOUT",    "Operation timeout. The specified time-out period was reached according to the conditions." } },
    //{ 0x80E80021,{ "SCE_WEBVIEW_NETWORK_ERROR_RANGE_ERROR",   "The HTTP server does not support or accept range requests." } },
    //{ 0x80E80022,{ "SCE_WEBVIEW_NETWORK_ERROR_HTTP_POST_ERROR",   "This is an odd error that mainly occurs due to internal confusion." } },
    //{ 0x80E80023,{ "SCE_WEBVIEW_NETWORK_ERROR_SSL_CONNECT_ERROR", "wrong when connecting with SSL" } },
    //{ 0x80E80024,{ "SCE_WEBVIEW_NETWORK_ERROR_BAD_DOWNLOAD_RESUME",   "Attempting FTP resume beyond file size." } },
    //{ 0x80E80025,{ "SCE_WEBVIEW_NETWORK_ERROR_FILE_COULDNT_READ_FILE",    "A file given with FILE:// couldn't be opened. Most likely because the file path doesn't identify an existing file. Did you check file permissions?" } },
    //{ 0x80E80029,{ "SCE_WEBVIEW_NETWORK_ERROR_FUNCTION_NOT_FOUND",    "Function not found. A required LDAP function was not found." } },
    //{ 0x80E8002A,{ "SCE_WEBVIEW_NETWORK_ERROR_ABORTED_BY_CALLBACK",   "Aborted by callback. A callback returned \"abort\" to libcurl." } },
    //{ 0x80E8002B,{ "SCE_WEBVIEW_NETWORK_ERROR_BAD_FUNCTION_ARGUMENT", "Internal error. A function was called with a bad parameter." } },
    //{ 0x80E8002D,{ "SCE_WEBVIEW_NETWORK_ERROR_INTERFACE_FAILED",  "Interface error. A specified outgoing interface could not be used. Set which interface to use for outgoing connections' source IP address with CURLOPT_INTERFACE." } },
    //{ 0x80E8002F,{ "SCE_WEBVIEW_NETWORK_ERROR_TOO_MANY_REDIRECTS",    "Too many redirects. When following redirects, libcurl hit the maximum amount. Set your limit with CURLOPT_MAXREDIRS." } },
    //{ 0x80E80030,{ "SCE_WEBVIEW_NETWORK_ERROR_UNKNOWN_OPTION",    "An option set with CURLOPT_TELNETOPTIONS was not recognized/known. Refer to the appropriate documentation." } },
    //{ 0x80E80033,{ "SCE_WEBVIEW_NETWORK_ERROR_PEER_FAILED_VERIFICATION",  "The remote server's SSL certificate was deemed not OK." } },
    //{ 0x80E80034,{ "SCE_WEBVIEW_NETWORK_ERROR_GOT_NOTHING",   "Nothing was returned from the server, and under the circumstances, getting nothing is considered an error." } },
    //{ 0x80E80037,{ "SCE_WEBVIEW_NETWORK_ERROR_SEND_ERROR",    "Failed sending network data." } },
    //{ 0x80E80038,{ "SCE_WEBVIEW_NETWORK_ERROR_RECV_ERROR",    "Failure with receiving network data." } },
    //{ 0x80E8003A,{ "SCE_WEBVIEW_NETWORK_ERROR_SSL_CERTPROBLEM",   "problem with the local certificate" } },
    //{ 0x80E8003B,{ "SCE_WEBVIEW_NETWORK_ERROR_SSL_CIPHER",    "couldn't use specified cipher" } },
    //{ 0x80E8003C,{ "SCE_WEBVIEW_NETWORK_ERROR_SSL_CACERT",    "problem with the CA cert (path?)" } },
    //{ 0x80E8003D,{ "SCE_WEBVIEW_NETWORK_ERROR_BAD_CONTENT_ENCODING",  "Unrecognized transfer encoding" } },
    //{ 0x80E8003F,{ "SCE_WEBVIEW_NETWORK_ERROR_FILESIZE_EXCEEDED", "Maximum file size exceeded" } },
    //{ 0x80E80041,{ "SCE_WEBVIEW_NETWORK_ERROR_SEND_FAIL_REWIND",  "When doing a send operation curl had to rewind the data to retransmit, but the rewinding operation failed" } },
    //{ 0x80E80042,{ "SCE_WEBVIEW_NETWORK_ERROR_SSL_ENGINE_INITFAILED", "failed to initialize SSL ENGINE" } },
    //{ 0x80E8004D,{ "SCE_WEBVIEW_NETWORK_ERROR_SSL_CACERT_BADFILE",    "could not load CACERT file, missing or wrong format" } },
    //{ 0x80E80050,{ "SCE_WEBVIEW_NETWORK_ERROR_SSL_SHUTDOWN_FAILED",   "failed to shutdown SSL ENGINE" } },
    //{ 0x80E80051,{ "SCE_WEBVIEW_NETWORK_ERROR_AGAIN", "Error when some network data is lost." } },
    //{ 0x80E80053,{ "SCE_WEBVIEW_NETWORK_ERROR_SSL_ISSUER_ERROR",  "Issuer check failed.  (Added in 7.19.0)" } },
    //{ 0x80E80058,{ "SCE_WEBVIEW_NETWORK_ERROR_CHUNK_FAILED",  "Error when CRC check error is detected." } },
    //{ 0x80E81002,{ "SCE_WEBVIEW_SSL_X509_ERROR_UNABLE_TO_GET_ISSUER_CERT", "" } },
    //{ 0x80E81003,{ "SCE_WEBVIEW_SSL_X509_ERROR_UNABLE_TO_GET_CR", "" } },
    //{ 0x80E81004,{ "SCE_WEBVIEW_SSL_X509_ERROR_UNABLE_TO_DECRYPT_CERT_SIGNATURE", "" } },
    //{ 0x80E81005,{ "SCE_WEBVIEW_SSL_X509_ERROR_UNABLE_TO_DECRYPT_CRL_SIGNATURE", "" } },
    //{ 0x80E81006,{ "SCE_WEBVIEW_SSL_X509_ERROR_UNABLE_TO_DECODE_ISSUER_PUBLIC_KEY", "" } },
    //{ 0x80E81007,{ "SCE_WEBVIEW_SSL_X509_ERROR_CERT_SIGNATURE_FAILURE", "" } },
    //{ 0x80E81008,{ "SCE_WEBVIEW_SSL_X509_ERROR_CRL_SIGNATURE_FAILURE", "" } },
    //{ 0x80E81009,{ "SCE_WEBVIEW_SSL_X509_ERROR_CERT_NOT_YET_VALID", "" } },
    //{ 0x80E8100A,{ "SCE_WEBVIEW_SSL_X509_ERROR_CERT_HAS_EXPIRED", "" } },
    //{ 0x80E8100B,{ "SCE_WEBVIEW_SSL_X509_ERROR_CRL_NOT_YET_VALID", "" } },
    //{ 0x80E8100C,{ "SCE_WEBVIEW_SSL_X509_ERROR_CRL_HAS_EXPIRED", "" } },
    //{ 0x80E8100D,{ "SCE_WEBVIEW_SSL_X509_ERROR_ERROR_IN_CERT_NOT_BEFORE_FIELD", "" } },
    //{ 0x80E8100E,{ "SCE_WEBVIEW_SSL_X509_ERROR_ERROR_IN_CERT_NOT_AFTER_FIELD", "" } },
    //{ 0x80E8100F,{ "SCE_WEBVIEW_SSL_X509_ERROR_ERROR_IN_CRL_LAST_UPDATE_FIELD", "" } },
    //{ 0x80E81010,{ "SCE_WEBVIEW_SSL_X509_ERROR_ERROR_IN_CRL_NEXT_UPDATE_FIELD", "" } },
    //{ 0x80E81011,{ "SCE_WEBVIEW_SSL_X509_ERROR_OUT_OF_MEM", "" } },
    //{ 0x80E81012,{ "SCE_WEBVIEW_SSL_X509_ERROR_DEPTH_ZERO_SELF_SIGNED_CERT", "" } },
    //{ 0x80E81013,{ "SCE_WEBVIEW_SSL_X509_ERROR_SELF_SIGNED_CERT_IN_CHAIN", "" } },
    //{ 0x80E81014,{ "SCE_WEBVIEW_SSL_X509_ERROR_UNABLE_TO_GET_ISSUER_CERT_LOCALLY", "" } },
    //{ 0x80E81015,{ "SCE_WEBVIEW_SSL_X509_ERROR_UNABLE_TO_VERIFY_LEAF_SIGNATURE", "" } },
    //{ 0x80E81016,{ "SCE_WEBVIEW_SSL_X509_ERROR_CERT_CHAIN_TOO_LONG", "" } },
    //{ 0x80E81017,{ "SCE_WEBVIEW_SSL_X509_ERROR_CERT_REVOKED", "" } },
    //{ 0x80E81018,{ "SCE_WEBVIEW_SSL_X509_ERROR_INVALID_CA", "" } },
    //{ 0x80E81019,{ "SCE_WEBVIEW_SSL_X509_ERROR_PATH_LENGTH_EXCEEDED", "" } },
    //{ 0x80E8101A,{ "SCE_WEBVIEW_SSL_X509_ERROR_INVALID_PURPOSE", "" } },
    //{ 0x80E8101B,{ "SCE_WEBVIEW_SSL_X509_ERROR_CERT_UNTRUSTED", "" } },
    //{ 0x80E8101C,{ "SCE_WEBVIEW_SSL_X509_ERROR_CERT_REJECTED", "" } },
    //{ 0x80E8101D,{ "SCE_WEBVIEW_SSL_X509_ERROR_SUBJECT_ISSUER_MISMATCH", "" } },
    //{ 0x80E8101E,{ "SCE_WEBVIEW_SSL_X509_ERROR_AKID_SKID_MISMATCH", "" } },
    //{ 0x80E8101F,{ "SCE_WEBVIEW_SSL_X509_ERROR_AKID_ISSUER_SERIAL_MISMATCH", "" } },
    //{ 0x80E81020,{ "SCE_WEBVIEW_SSL_X509_ERROR_KEYUSAGE_NO_CERTSIGN", "" } },
    //{ 0x80E81021,{ "SCE_WEBVIEW_SSL_X509_ERROR_UNABLE_TO_GET_CRL_ISSUER", "" } },
    //{ 0x80E81022,{ "SCE_WEBVIEW_SSL_X509_ERROR_UNHANDLED_CRITICAL_EXTENSION", "" } },
    //{ 0x80E81023,{ "SCE_WEBVIEW_SSL_X509_ERROR_KEYUSAGE_NO_CRL_SIGN", "" } },
    //{ 0x80E81024,{ "SCE_WEBVIEW_SSL_X509_ERROR_UNHANDLED_CRITICAL_CRL_EXTENSION", "" } },
    //{ 0x80E81025,{ "SCE_WEBVIEW_SSL_X509_ERROR_INVALID_NON_CA", "" } },
    //{ 0x80E81026,{ "SCE_WEBVIEW_SSL_X509_ERROR_PROXY_PATH_LENGTH_EXCEEDED", "" } },
    //{ 0x80E81027,{ "SCE_WEBVIEW_SSL_X509_ERROR_KEYUSAGE_NO_DIGITAL_SIGNATURE", "" } },
    //{ 0x80E81028,{ "SCE_WEBVIEW_SSL_X509_ERROR_PROXY_CERTIFICATES_NOT_ALLOWED", "" } },
    //{ 0x80E81029,{ "SCE_WEBVIEW_SSL_X509_ERROR_INVALID_EXTENSION", "" } },
    //{ 0x80E8102A,{ "SCE_WEBVIEW_SSL_X509_ERROR_INVALID_POLICY_EXTENSION", "" } },
    //{ 0x80E8102B,{ "SCE_WEBVIEW_SSL_X509_ERROR_NO_EXPLICIT_POLICY", "" } },
    //{ 0x80E8102C,{ "SCE_WEBVIEW_SSL_X509_ERROR_DIFFERENT_CRL_SCOPE", "" } },
    //{ 0x80E8102D,{ "SCE_WEBVIEW_SSL_X509_ERROR_UNSUPPORTED_EXTENSION_FEATURE", "" } },
    //{ 0x80E8102E,{ "SCE_WEBVIEW_SSL_X509_ERROR_UNNESTED_RESOURCE", "" } },
    //{ 0x80E8102F,{ "SCE_WEBVIEW_SSL_X509_ERROR_PERMITTED_VIOLATION", "" } },
    //{ 0x80E81030,{ "SCE_WEBVIEW_SSL_X509_ERROR_EXCLUDED_VIOLATION", "" } },
    //{ 0x80E81031,{ "SCE_WEBVIEW_SSL_X509_ERROR_SUBTREE_MINMAX", "" } },
    //{ 0x80E81032,{ "SCE_WEBVIEW_SSL_X509_ERROR_APPLICATION_VERIFICATION", "" } },
    //{ 0x80E81033,{ "SCE_WEBVIEW_SSL_X509_ERROR_UNSUPPORTED_CONSTRAINT_TYPE", "" } },
    //{ 0x80E81034,{ "SCE_WEBVIEW_SSL_X509_ERROR_UNSUPPORTED_CONSTRAINT_SYNTAX", "" } },
    //{ 0x80E81035,{ "SCE_WEBVIEW_SSL_X509_ERROR_UNSUPPORTED_NAME_SYNTAX", "" } },
    //{ 0x80E81036,{ "SCE_WEBVIEW_SSL_X509_ERROR_CRL_PATH_VALIDATION_ERROR", "" } },
    //{ 0x80E81064,{ "SCE_WEBVIEW_SSL_X509_ERROR_SSL_CN_CHECK", "" } },
    //{ 0x80E82000,{ "SCE_WEBVIEW_LOAD_ERROR_CANCELED", "Load cancelled" } },
    //{ 0x80E82001,{ "SCE_WEBVIEW_LOAD_ERROR_BLOCKED",  "Unsafe port access is detected." } },
    //{ 0x80E82002,{ "SCE_WEBVIEW_LOAD_ERROR_CANNOT_SHOW_URL",  "Cannot show url" } },
    //{ 0x80E82003,{ "SCE_WEBVIEW_LOAD_ERROR_INTERRUPTED_FOR_POLICY_CHANGE",    "Interrupted for policy change" } },
    //{ 0x80E82004,{ "SCE_WEBVIEW_LOAD_ERROR_CANNOT_SHOW_MIME_TYPE",    "Cannot show mime type" } },
    //{ 0x80E82005,{ "SCE_WEBVIEW_LOAD_ERROR_FILE_DOES_NOT_EXIST",  "File does not exist" } },
    //{ 0x80E82006,{ "SCE_WEBVIEW_LOAD_ERROR_PLUGIN_WILL_HANDLE_LOAD",  "Plugin will handle load" } },
    //{ 0x80EA0001,{ "SCE_AUDIO3D_ERROR_UNKNOWN",   "Unknown error. This value should not be used." } },
    //{ 0x80EA0002,{ "SCE_AUDIO3D_ERROR_INVALID_PORT",  "The specified port does not exist." } },
    //{ 0x80EA0003,{ "SCE_AUDIO3D_ERROR_INVALID_OBJECT",    "The specified object does not exist." } },
    //{ 0x80EA0004,{ "SCE_AUDIO3D_ERROR_INVALID_PARAMETER", "An invalid parameter was passed." } },
    //{ 0x80EA0005,{ "SCE_AUDIO3D_ERROR_OUT_OF_MEMORY", "Not enough memory to perform the operation." } },
    //{ 0x80EA0006,{ "SCE_AUDIO3D_ERROR_OUT_OF_RESOURCES",  "Not enough resources to perform the operation." } },
    //{ 0x80EA0007,{ "SCE_AUDIO3D_ERROR_NOT_READY", "The operation cannot be performed at the moment." } },
    //{ 0x80EA0008,{ "SCE_AUDIO3D_ERROR_NOT_SUPPORTED", "The operation is not supported." } },
    //{ 0x80ED0001,{ "SCE_ERROR_DIALOG_ERROR_NOT_INITIALIZED",  "The Dialog has not been initialized" } },
    //{ 0x80ED0002,{ "SCE_ERROR_DIALOG_ERROR_ALREADY_INITIALIZED",  "The dialog is already initialized." } },
    //{ 0x80ED0003,{ "SCE_ERROR_DIALOG_ERROR_PARAM_INVALID",    "It is an invalid parameter" } },
    //{ 0x80ED0004,{ "SCE_ERROR_DIALOG_ERROR_UNEXPECTED_FATAL", "Unexpected fatal error occurred" } },
    //{ 0x80ED0005,{ "SCE_ERROR_DIALOG_ERROR_INVALID_STATE",    "It's the state that is unable to call the API." } },
    //{ 0x80ED0006,{ "SCE_ERROR_DIALOG_ERROR_SERVICE_BUSY", "It's the service state that is unable to call the API." } },
    //{ 0x80ED0007,{ "SCE_ERROR_DIALOG_ERROR_INVALID_USER_ID",  "Invalid user ID was specified." } },
    //{ 0x80EE0001,{ "SCE_MOVE_ERROR_NOT_INIT", "Not initialized." } },
    //{ 0x80EE0002,{ "SCE_MOVE_ERROR_ALREADY_INIT", "Already initialized." } },
    //{ 0x80EE0003,{ "SCE_MOVE_ERROR_INVALID_ARG",  "Invalid argument." } },
    //{ 0x80EE0004,{ "SCE_MOVE_ERROR_INVALID_HANDLE",   "Invalid Move library handle." } },
    //{ 0x80EE0005,{ "SCE_MOVE_ERROR_MAX_CONTROLLERS_EXCEEDED", "Invalid Move library handle." } },
    //{ 0x80EE0006,{ "SCE_MOVE_ERROR_INVALID_PORT", "Invalid port." } },
    //{ 0x80EE0007,{ "SCE_MOVE_ERROR_ALREADY_OPENED",   "Already opened the port." } },
    //{ 0x80EE00FF,{ "SCE_MOVE_ERROR_FATAL",    "Fatal error." } },
    //{ 0x80EF0001,{ "SCE_MOVE_TRACKER_ERROR_NOT_INIT", "Not initialized." } },
    //{ 0x80EF0002,{ "SCE_MOVE_TRACKER_ERROR_ALREADY_INIT", "Already initialized." } },
    //{ 0x80EF0003,{ "SCE_MOVE_TRACKER_ERROR_INVALID_ARG",  "Invalid argument." } },
    //{ 0x80EF0004,{ "SCE_MOVE_TRACKER_ERROR_INVALID_HANDLE",   "Invalid Move library handle." } },
    //{ 0x80F00612,{ "SCE_NP_DRM_CONTENT_ERROR_ORIGINCHECK",    "Check that the original application package specified upon creating the patch package is installed on the Development Kit/Testing Kit." } },
    //{ 0x80F40001,{ "SCE_AUTO_MOUNTER_ERROR_NOMEM",    "Out of memory" } },
    //{ 0x80F40002,{ "SCE_AUTO_MOUNTER_ERROR_INVAL",    "Invlid Argument" } },
    //{ 0x80F40003,{ "SCE_AUTO_MOUNTER_ERROR_BUSY", "Device or resource busy" } },
    //{ 0x80F40004,{ "SCE_AUTO_MOUNTER_ERROR_NOENT",    "No such resource" } },
    //{ 0x80F40005,{ "SCE_AUTO_MOUNTER_ERROR_NOTSUP",   "Operation can't be processed because of wrong condition" } },
    //{ 0x80F40006,{ "SCE_AUTO_MOUNTER_ERROR_IO",   "I/O error" } },
    //{ 0x80F40007,{ "SCE_AUTO_MOUNTER_ERROR_NODEV",    "No such device" } },
    //{ 0x80F40008,{ "SCE_AUTO_MOUNTER_ERROR_SRCH", "useless operation" } },
    //{ 0x80F40009,{ "SCE_AUTO_MOUNTER_ERROR_STATUS",   "inappropriate status of module" } },
    //{ 0x80F4000A,{ "SCE_AUTO_MOUNTER_ERROR_NXIO", "No such device or address" } },
    //{ 0x80F4000B,{ "SCE_AUTO_MOUNTER_ERROR_IO_MNT",   "Mounting of device failed according to io error" } },
    //{ 0x80F4000C,{ "SCE_AUTO_MOUNTER_ERROR_INVAL_MNT",    "Mounting of device failed according to wrong image" } },
    //{ 0x80F4000D,{ "SCE_AUTO_MOUNTER_ERROR_LOGIC",    "Internal logic error" } },
    //{ 0x80F4000E,{ "SCE_AUTO_MOUNTER_ERROR_EXT_USB1", "Dummy error code to display USB1 on error dialog" } },
    //{ 0x80F4000F,{ "SCE_AUTO_MOUNTER_ERROR_EXT_USB2", "Dummy error code to display USB2 on error dialog" } },
    //{ 0x80F40010,{ "SCE_AUTO_MOUNTER_ERROR_EXT_USB3", "Dummy error code to display USB3 on error dialog" } },
    //{ 0x80F40011,{ "SCE_AUTO_MOUNTER_ERROR_EXT_USB4", "Dummy error code to display USB4 on error dialog" } },
    //{ 0x80F40012,{ "SCE_AUTO_MOUNTER_ERROR_EXT_USB7", "Dummy error code to display USB7 on error dialog" } },
    //{ 0x80F40013,{ "SCE_AUTO_MOUNTER_ERROR_EXT_USB9", "Dummy error code to display USB7 on error dialog" } },
    //{ 0x80F40014,{ "SCE_USB_STORAGE_ERROR_EACCES",    "Specified directory is not allowed to be a target of Map()." } },
    //{ 0x80F40015,{ "SCE_USB_STORAGE_ERROR_ENFILE",    "The number of directory which can be Map() at the same time is over limitation." } },
    //{ 0x80F70500,{ "SCE_AUDIODEC_CPU_ERROR_DDP_FAIL", "Specified internal error in Dolby Digital(TM) Plus" } },
    //{ 0x80F70501,{ "SCE_AUDIODEC_CPU_ERROR_DDP_ARG",  "Specified argument error in Dolby Digital(TM) Plus" } },
    //{ 0x80F70502,{ "SCE_AUDIODEC_CPU_ERROR_DDP_MEM_FAIL", "Specified memory size error in Dolby Digital(TM) Plus" } },
    //{ 0x80F70503,{ "SCE_AUDIODEC_CPU_ERROR_DDP_CREATE_DEC_FAIL",  "Specified internal error of creating deocder in Dolby Digital(TM) Plus" } },
    //{ 0x80F70504,{ "SCE_AUDIODEC_CPU_ERROR_DDP_DECODE_FAIL",  "Specified decoding error in Dolby Digital(TM) Plus" } },
    //{ 0x80F70505,{ "SCE_AUDIODEC_CPU_ERROR_DDP_CLEAR_CONTEXT_FAIL",   "Specified clear context error in Dolby Digital(TM) Plus" } },
    //{ 0x80F70C00,{ "SCE_AUDIODEC_CPU_ERROR_HEVAG_INVALID_CHANNELS",   "Specified invalid number of channels of HE-VAG" } },
    //{ 0x80F70C01,{ "SCE_AUDIODEC_CPU_ERROR_HEVAG_INVALID_SAMPLING_FREQ",  "Specified invalid output sampling frequency of HE-VAG" } },
    //{ 0x80F70C02,{ "SCE_AUDIODEC_CPU_ERROR_HEVAG_INVALID_VERSION",    "Specified invalid version of HE-VAG" } },
    //{ 0x80F70C03,{ "SCE_AUDIODEC_CPU_ERROR_HEVAG_INVALID_ID", "Specified invalid identification ID of HE-VAG" } },
    //{ 0x80F70C04,{ "SCE_AUDIODEC_CPU_ERROR_HEVAG_INVALID_DATA_SIZE",  "Specified invalid data size of HE-VAG" } },
    //{ 0x80F70C05,{ "SCE_AUDIODEC_CPU_ERROR_HEVAG_INVALID_DATA_NAME",  "Specified invalid data name of HE-VAG" } },
    //{ 0x80F70C06,{ "SCE_AUDIODEC_CPU_ERROR_HEVAG_INVALID_OUTPUT_FORMAT",  "Specified invalid output format of HE-VAG" } },
    //{ 0x80F70C07,{ "SCE_AUDIODEC_CPU_ERROR_HEVAG_NOT_FOUND_HEADER",   "Not found HE-VAG header" } },
    //{ 0x80F70C08,{ "SCE_AUDIODEC_CPU_ERROR_HEVAG_INVALID_LOOP_FLAG",  "Detected invalid loop flag of HE-VAG" } },
    //{ 0x80F90001,{ "SCE_PSVR_ERROR_CREATE_FAIL",  "scePsvrCreateFromUncompress() or scePsvrCreateFromCompress() failed." } },
    //{ 0x80F90002,{ "SCE_PSVR_ERROR_INVALID_OPTION",   "Invalid tuning options." } },
    //{ 0x80F90003,{ "SCE_PSVR_ERROR_MEMORY_FAIL",  "Memory operation failed." } },
    //{ 0x80F90004,{ "SCE_PSVR_ERROR_MEMORY_LEAK",  "Memory leak." } },
    //{ 0x80F90005,{ "SCE_PSVR_ERROR_SAVE_CPR_FAIL",    "Save compact CPR failed." } },
    //{ 0x80F90006,{ "SCE_PSVR_ERROR_COMPILE_FAIL", "Create compress CPR failed." } },
    //{ 0x80F90007,{ "SCE_PSVR_ERROR_GRAMMAR_FAIL", "Create GnD failed." } },
    //{ 0x80F90008,{ "SCE_PSVR_ERROR_START_FAIL",   "scePsvrStart() failed." } },
    //{ 0x80F90009,{ "SCE_PSVR_ERROR_INVALID_ARGUMENT", "Invalid argument." } },
    //{ 0x80F9000A,{ "SCE_PSVR_ERROR_RESOURCE_INSUFFICIENT",    "Insufficient resources." } },
    //{ 0x80F9000B,{ "SCE_PSVR_ERROR_NOT_INITIALIZED",  "PSVR library has not been initialized." } },
    //{ 0x80F9000C,{ "SCE_PSVR_ERROR_ALREADY_INITIALIZED",  "PSVR library has been initialized." } },
    //{ 0x80F9000D,{ "SCE_PSVR_ERROR_INVALID_RESULT",   "Invalid PSVR result." } },
    //{ 0x80F9000E,{ "SCE_PSVR_ERROR_INVALID_PSVR_POINTER", "Invalid PSVR pointer." } },
    //{ 0x80F9000F,{ "SCE_PSVR_ERROR_INVALID_ERROR_MESSAGE",    "Invalid PSVR error message." } },
    //{ 0x80F90010,{ "SCE_PSVR_ERROR_API_CONFLICT", "Encounter conflit PSVR API calls at the same time." } },
    //{ 0x80FC0001,{ "SCE_REMOTEPLAY_ERROR_INVALID_ARGS",   "invalid argument" } },
    //{ 0x80FC0002,{ "SCE_REMOTEPLAY_ERROR_OUT_OF_MEMORY",  "memory allocation error" } },
    //{ 0x80FC0003,{ "SCE_REMOTEPLAY_ERROR_ALREADY_INITIALIZED",    "this library is already initialized" } },
    //{ 0x80FC0004,{ "SCE_REMOTEPLAY_ERROR_NOT_INITIALIZED",    "this library isn't initialized" } },
    //{ 0x80FC0005,{ "SCE_REMOTEPLAY_ERROR_FATAL",  "fatal error" } },
    //{ 0x81000000,{ "SCE_SCREAM_SND_LOAD_ERROR_COULDNT_OPEN_FILE", "A file could not be opened" } },
    //{ 0x81000001,{ "SCE_SCREAM_SND_LOAD_ERROR_READING_FILE",  "A problem occurred reading a file" } },
    //{ 0x81000002,{ "SCE_SCREAM_SND_LOAD_ERROR_MEMORY",    "Memory could not be allocated to load a file" } },
    //{ 0x81000003,{ "SCE_SCREAM_SND_LOAD_ERROR_ALIGNMENT", "A Bank is not aligned on a 16-byte boundary" } },
    //{ 0x81000004,{ "SCE_SCREAM_SND_LOAD_ERROR_INVALID_FORMAT",    "A file has an invalid format" } },
    //{ 0x81000005,{ "SCE_SCREAM_SND_LOAD_ERROR_ALREADY_LOADED",    "A Bank at the specified memory address is already loaded" } },
    //{ 0x81000101,{ "SCE_SCREAM_SS_ERROR_SYSTEM_ALREADY_STARTED",  "Scream is already initialized or that initialization failed" } },
    //{ 0x81000102,{ "SCE_SCREAM_SS_ERROR_SYSTEM_NOT_STARTED",  "Scream is not currently running" } },
    //{ 0x81000103,{ "SCE_SCREAM_SS_ERROR_SYNTH_INIT_FAILED",   "Underlying synthesizer failed to initialize" } },
    //{ 0x81000104,{ "SCE_SCREAM_SS_ERROR_INVALID_PARAMETER",   "Invalid parameter detected" } },
    //{ 0x81000105,{ "SCE_SCREAM_SS_ERROR_UNSUPPORTED", "The requested operation is not supported" } },
    //{ 0x81000200,{ "SCE_SCREAM_SND_STREAM_INIT_ERROR_UNKNOWN",    "Unknown system error" } },
    //{ 0x81000201,{ "SCE_SCREAM_SND_STREAM_INIT_ERROR_MEMORY", "Unable to allocate memory" } },
    //{ 0x81000202,{ "SCE_SCREAM_SND_STREAM_INIT_ERROR_THREADS",    "Unable to create a thread" } },
    //{ 0x81000203,{ "SCE_SCREAM_SND_STREAM_INIT_ERROR_ALREADY_INITED", "Sndstream has already been initialized" } },
    //{ 0x81000204,{ "SCE_SCREAM_SND_STREAM_INIT_ERROR_INVALID_ARGS",   "Some specified parameter(s) are out of range" } },
    //{ 0x81000301,{ "SCE_SCREAM_SND_STREAM_ERROR_UNKNOWN", "An unknown error occurred" } },
    //{ 0x81000302,{ "SCE_SCREAM_SND_STREAM_ERROR_NOT_INITED",  "Sndstream has not been initialized" } },
    //{ 0x81000303,{ "SCE_SCREAM_SND_STREAM_ERROR_NOT_FOUND",   "A specified file was not found" } },
    //{ 0x81000304,{ "SCE_SCREAM_SND_STREAM_ERROR_CORRUPT", "A specified file was found but contained invalid data" } },
    //{ 0x81000305,{ "SCE_SCREAM_SND_STREAM_ERROR_UNSUPPORTED", "A specified file type is not supported" } },
    //{ 0x81000306,{ "SCE_SCREAM_SND_STREAM_ERROR_UNREADABLE",  "Sndstream failed to seek in or read from file" } },
    //{ 0x81000307,{ "SCE_SCREAM_SND_STREAM_ERROR_INTERNAL",    "An unexpected internal error" } },
    //{ 0x81000308,{ "SCE_SCREAM_SND_STREAM_ERROR_UNRECOGNIZED",    "The specified reference is not recognized" } },
    //{ 0x81000309,{ "SCE_SCREAM_SND_STREAM_ERROR_OUT_OF_RANGE",    "A parameter index is out of range" } },
    //{ 0x8100030A,{ "SCE_SCREAM_SND_STREAM_ERROR_NULL_POINTER",    "A specified address was NULL" } },
    //{ 0x8100030B,{ "SCE_SCREAM_SND_STREAM_ERROR_VERSION_MISMATCH",    "The version of a specified data structure is not supported" } },
    //{ 0x8100030C,{ "SCE_SCREAM_SND_STREAM_ERROR_ENDIANNESS",  "Data with incorrect endianness was used" } },
    //{ 0x8100030D,{ "SCE_SCREAM_SND_STREAM_ERROR_VOICE_UNAVAILABLE",   "A voice could not be allocated for this data" } },
    //{ 0x8100030E,{ "SCE_SCREAM_SND_STREAM_ERROR_ALLOCATION",  "A resource could not be allocated" } },
    //{ 0x8100030F,{ "SCE_SCREAM_SND_STREAM_ERROR_NOT_ACTIVE",  "The handle or other object is no longer active" } },
    //{ 0x81000310,{ "SCE_SCREAM_SND_STREAM_ERROR_NOT_BIG_ENOUGH",  "A buffer or other resource is not big enough" } },
    //{ 0x81000400,{ "SCE_SCREAM_SND_STREAM_CLOSE_ERROR_NOT_INITED",    "Sndstream has not been initialized" } },
    //{ 0x81000501,{ "SCE_SCREAM_SCREAMSERVER_ERROR_INIT_FAILURE",  "Server failed to initialize" } },
    //{ 0x81000502,{ "SCE_SCREAM_SCREAMSERVER_ERROR_INVALID_BANK",  "Invalid Bank pointer error" } },
    //{ 0x81000503,{ "SCE_SCREAM_SCREAMSERVER_ERROR_NOT_INITIALIZED",   "Operation requested before server initialization" } },
    //{ 0x81000600,{ "SCE_SCREAM_SND_STREAM_FILE_ERROR_PASS",   "The file I/O system passed on (omitted) a read request" } },
    //{ 0x81000601,{ "SCE_SCREAM_SND_STREAM_FILE_ERROR_UNKNOWN",    "An error of unknown origin occurred" } },
    //{ 0x81000602,{ "SCE_SCREAM_SND_STREAM_FILE_ERROR_OPEN",   "A file open error occurred" } },
    //{ 0x81000603,{ "SCE_SCREAM_SND_STREAM_FILE_ERROR_SEEK",   "A file seek error occurred" } },
    //{ 0x81000604,{ "SCE_SCREAM_SND_STREAM_FILE_ERROR_READ",   "A file read error occurred" } },
    //{ 0x81000605,{ "SCE_SCREAM_SND_STREAM_FILE_ERROR_CLOSE",  "A file close error occurred" } },
    //{ 0x810A0001,{ "SCE_INVITATION_DIALOG_ERROR_BLOCKED_ALL_PLAYERS", "If all of recipients are blocked players" } },
    //{ 0x810B0001,{ "SCE_GAME_CUSTOM_DATA_DIALOG_ERROR_BLOCKED_ALL_PLAYERS",   "If all of recipients are blocked players" } },
    //{ 0x810E0001,{ "SCE_SHARE_PLAY_ERROR_INVALID_ARGS",   "invalid argument" } },
    //{ 0x810E0002,{ "SCE_SHARE_PLAY_ERROR_OUT_OF_MEMORY",  "memory allocation error" } },
    //{ 0x810E0003,{ "SCE_SHARE_PLAY_ERROR_ALREADY_INITIALIZED",    "this library is already initialized" } },
    //{ 0x810E0004,{ "SCE_SHARE_PLAY_ERROR_NOT_INITIALIZED",    "this library isn't initialized" } },
    //{ 0x810E0005,{ "SCE_SHARE_PLAY_ERROR_FATAL",  "fatal error" } },
    //{ 0x81100001,{ "SCE_DISC_MAP_ERROR_INVALID_ARGUMENT", "Invalid argument" } },
    //{ 0x81100002,{ "SCE_DISC_MAP_ERROR_LOCATION_NOT_MAPPED",  "The path is not in a mapped location" } },
    //{ 0x81100003,{ "SCE_DISC_MAP_ERROR_FILE_NOT_FOUND",   "File not found" } },
    //{ 0x81100004,{ "SCE_DISC_MAP_ERROR_NO_BITMAP_INFO",   "There is no bitmap information" } },
    //{ 0x811000FF,{ "SCE_DISC_MAP_ERROR_FATAL",    "Fatal error" } },
    //{ 0x81110001,{ "SCE_HMD_ERROR_ALREADY_INITIALIZED",   "This library is already initialized." } },
    //{ 0x81110002,{ "SCE_HMD_ERROR_NOT_INITIALIZED",   "This library is not yet initialized." } },
    //{ 0x81110003,{ "SCE_HMD_ERROR_HANDLE_INVALID",    "This hnadle is invalid." } },
    //{ 0x81110004,{ "SCE_HMD_ERROR_DEVICE_DISCONNECTED",   "This device is disconnected." } },
    //{ 0x81110005,{ "SCE_HMD_ERROR_WRONG_ID",  "ID value is not correct" } },
    //{ 0x81110006,{ "SCE_HMD_ERROR_ALREADY_OPENED",    "This device is already opened." } },
    //{ 0x81110007,{ "SCE_HMD_ERROR_INSUFFICIENT_RESOURCE", "resource is not sufficient to use" } },
    //{ 0x81110008,{ "SCE_HMD_ERROR_PARAMETER_NULL",    "any parameter is null." } },
    //{ 0x81110009,{ "SCE_HMD_ERROR_PARAMETER_INVALID", "any parameter is invalid." } },
    //{ 0x8111000A,{ "SCE_HMD_ERROR_NO_2D_DISTORTION_MAP_MEMORY",   "no 2D distortion map memory." } },
    //{ 0x8111000B,{ "SCE_HMD_ERROR_2D_DISTORTION_MAP_INITIALIZATION_ERROR",    "can't initialize 2D distortion map." } },
    //{ 0x8111000C,{ "SCE_HMD_ERROR_REPROJECTION_NOT_INITIALIZED",  "reprojection is not ready." } },
    //{ 0x8111000D,{ "SCE_HMD_ERROR_REPROJECTION_ALREADY_INITIALIZED",  "reprojection is already initialized." } },
    //{ 0x8111000E,{ "SCE_HMD_ERROR_REPROJECTION_HMD_NOT_READY",    "HMD device status is not ready." } },
    //{ 0x8111000F,{ "SCE_HMD_ERROR_REPROJECTION_NO_DISPLAY_BUFFER",    "Display buffers are not set." } },
    //{ 0x81110010,{ "SCE_HMD_ERROR_REPROJECTION_WRONG_DISPLAY_BUFFER", "Wrong attribute of the display buffers." } },
    //{ 0x81110011,{ "SCE_HMD_ERROR_REPROJECTION_DISPLAY_BUFFER_BUSY",  "Specified display buffer is in use for video output" } },
    //{ 0x81110012,{ "SCE_HMD_ERROR_REPROJECTION_RESOURCE_ALREADY_SET", "The resource has already been set" } },
    //{ 0x81110013,{ "SCE_HMD_ERROR_REPROJECTION_RESOURCE_NOT_SET", "The resource is not set" } },
    //{ 0x81110014,{ "SCE_HMD_ERROR_REPROJECTION_THREAD_NOT_WORKING",   "The thread is not working" } },
    //{ 0x81110015,{ "SCE_HMD_ERROR_REPROJECTION_NEVER_PROCESSED",  "Reprojection process has never been done." } },
    //{ 0x81110016,{ "SCE_HMD_ERROR_UNSUPPORTED_FEATURE",   "The feature is unsupported" } },
    //{ 0x81120002,{ "SCE_ZLIB_ERROR_NOT_FOUND",    "Resource not found" } },
    //{ 0x8112000B,{ "SCE_ZLIB_ERROR_AGAIN",    "Try again" } },
    //{ 0x8112000E,{ "SCE_ZLIB_ERROR_FAULT",    "Bad address" } },
    //{ 0x81120016,{ "SCE_ZLIB_ERROR_INVALID",  "Invalid argument" } },
    //{ 0x8112001C,{ "SCE_ZLIB_ERROR_NOSPACE",  "No space left" } },
    //{ 0x81120025,{ "SCE_ZLIB_ERROR_NOT_SUPPORTED",    "Not supported format" } },
    //{ 0x81120027,{ "SCE_ZLIB_ERROR_TIMEDOUT", "Operation results timed out" } },
    //{ 0x81120032,{ "SCE_ZLIB_ERROR_NOT_INITIALIZED",  "Not initialized" } },
    //{ 0x81120033,{ "SCE_ZLIB_ERROR_ALREADY_INITIALIZED",  "Library has been initialized" } },
    //{ 0x811200FF,{ "SCE_ZLIB_ERROR_FATAL",    "Fatal error" } },
    //{ 0x81150001,{ "SCE_DBG_ERROR_INVALID_ARG",   "invalid argument" } },
    //{ 0x81150002,{ "SCE_DBG_ERROR_UNKNOWN",   "An unknown, platform-specific error occurred" } },
    //{ 0x81150003,{ "SCE_DBG_ERROR_BUFFER_FULL",   "The message was truncated" } },
    //{ 0x81170001,{ "SCE_SHARE_UTILITY_ERROR_UNKNOWN", "Internal error" } },
    //{ 0x81170002,{ "SCE_SHARE_UTILITY_ERROR_NOMEM",   "Insufficient memory" } },
    //{ 0x81170003,{ "SCE_SHARE_UTILITY_ERROR_INVALID_ARGUMENT",    "Invalid argument" } },
    //{ 0x81170004,{ "SCE_SHARE_UTILITY_ERROR_LARGE_SIZE",  "too large" } },
    //{ 0x81170005,{ "SCE_SHARE_UTILITY_ERROR_CREATE_RESOURCE", "failed to create resource" } },
    //{ 0x81170006,{ "SCE_SHARE_UTILITY_ERROR_DESTROY_RESOURCE",    "failed to destroy resource" } },
    //{ 0x81170007,{ "SCE_SHARE_UTILITY_ERROR_INITIALIZE_RESOURCE", "failed to initialize resource" } },
    //{ 0x81170008,{ "SCE_SHARE_UTILITY_ERROR_START_RESOURCE",  "failed to start resource" } },
    //{ 0x81170009,{ "SCE_SHARE_UTILITY_ERROR_END_RESOURCE",    "failed to end resource" } },
    //{ 0x8117000A,{ "SCE_SHARE_UTILITY_ERROR_RESOURCE",    "other error about resource" } },
    //{ 0x8117000B,{ "SCE_SHARE_UTILITY_ERROR_EXECUTE_FUNCTION",    "failed to execute share utility function" } },
    //{ 0x8117000C,{ "SCE_SHARE_UTILITY_ERROR_BUSY",    "busy" } },
    //{ 0x8117000D,{ "SCE_SHARE_UTILITY_ERROR_PARSE_JSON",  "failed to parse Json" } },
    //{ 0x8117000E,{ "SCE_SHARE_UTILITY_ERROR_ILLEGAL_CHARACTER",   "illegal character was included in Json" } },
    //{ 0x81170101,{ "SCE_SHARE_UTILITY_ERROR_ALREADY_INITILIZED",  "already initialized" } },
    //{ 0x81170101,{ "SCE_SHARE_UTILITY_ERROR_ALREADY_INITIALIZED", "already initialized" } },
    //{ 0x81170102,{ "SCE_SHARE_UTILITY_ERROR_NOT_INITILIZED",  "do not initialized yet" } },
    //{ 0x81170102,{ "SCE_SHARE_UTILITY_ERROR_NOT_INITIALIZED", "do not initialized yet" } },
    //{ 0x81170103,{ "SCE_SHARE_UTILITY_ERROR_TOO_MANY_APPLICATION",    "many application is using share utility" } },
    //{ 0x81170104,{ "SCE_SHARE_UTILITY_ERROR_GET_APP_INFORMATION", "failed to get information about application" } },
    //{ 0x81170105,{ "SCE_SHARE_UTILITY_ERROR_NOT_FLAG_IN_PARAM_SFO",   "no requisite flag in param.sfo" } },
    //{ 0x81170106,{ "SCE_SHARE_UTILITY_ERROR_GET_USER_ID_INFORMATION", "failed to get information about user id" } },
    //{ 0x81170201,{ "SCE_SHARE_UTILITY_ERROR_NOT_OPEN",    "can not open share menu" } },
    //{ 0x81170202,{ "SCE_SHARE_UTILITY_ERROR_NOT_OPEN_INVALID_FUNCTION_FLAG",  "can not open share menu because functionFlag is invalid" } },
    //{ 0x81180000,{ "SCE_COREDUMP_ERROR_PARAM",    "Error in the parameters" } },
    //{ 0x81180001,{ "SCE_COREDUMP_ERROR_NOT_REGISTERED",   "A core dump handler is not registered" } },
    //{ 0x81180002,{ "SCE_COREDUMP_ERROR_ALREADY_REGISTERED",   "A core dump handler is already registered" } },
    //{ 0x81180003,{ "SCE_COREDUMP_ERROR_NOT_IN_COREDUMP_HANDLER",  "Function was called from outside of the core dump handler" } },
    //{ 0x81180004,{ "SCE_COREDUMP_ERROR_THREAD_CREATE",    "Failed to create coredump handler thread" } },
    //{ 0x81180005,{ "SCE_COREDUMP_ERROR_STOP_INFO_UNAVAILABLE",    "Stop reason information is not available" } },
    //{ 0x81190001,{ "SCE_RT_SECOND_SCREEN_ERROR_NOT_INITIALIZED",  "An error occurred because the RtSecondScreen library has not been initialized." } },
    //{ 0x81190002,{ "SCE_RT_SECOND_SCREEN_ERROR_ALREADY_INITIALIZED",  "An error occurred because the RtSecondScreen library has already been initialized." } },
    //{ 0x81190003,{ "SCE_RT_SECOND_SCREEN_ERROR_INVALID_ARGUMENT", "An error occurred because a supplied argument was not valid." } },
    //{ 0x81190004,{ "SCE_RT_SECOND_SCREEN_ERROR_INVALID_CLIENT_HANDLE",    "An error occurred because the supplied companion device handle was not valid." } },
    //{ 0x81190005,{ "SCE_RT_SECOND_SCREEN_ERROR_OUT_OF_MEMORY",    "An error occurred because the internal memory allocator has run out of memory." } },
    //{ 0x81190006,{ "SCE_RT_SECOND_SCREEN_ERROR_NOT_SUPPORTED",    "An error occurred because the operation attempted is not currently supported." } },
    //{ 0x81190007,{ "SCE_RT_SECOND_SCREEN_ERROR_CANNOT_MAP_COMPUTE_QUEUE", "An error occurred because the selected compute queue could not be mapped." } },
    //{ 0x81190008,{ "SCE_RT_SECOND_SCREEN_ERROR_CANNOT_ACQUIRE_VIDEO_FRAME",   "An error occurred because the video encoder could not acquire a frame buffer." } },
    //{ 0x81190009,{ "SCE_RT_SECOND_SCREEN_ERROR_CANNOT_RELEASE_VIDEO_FRAME",   "An error occurred because the video encoder could not release a frame buffer." } },
    //{ 0x8119000A,{ "SCE_RT_SECOND_SCREEN_ERROR_CANNOT_ACQUIRE_AUDIO_FRAME",   "An error occurred because the audio encoder could not acquire a frame buffer." } },
    //{ 0x8119000B,{ "SCE_RT_SECOND_SCREEN_ERROR_CANNOT_RELEASE_AUDIO_FRAME",   "An error occurred because the audio encoder could not release a frame buffer." } },
    //{ 0x8119000C,{ "SCE_RT_SECOND_SCREEN_ERROR_CANNOT_SUBMIT_COMPUTE_JOB",    "An error occurred because the submission of an asynchronous compute job failed." } },
    //{ 0x8119000D,{ "SCE_RT_SECOND_SCREEN_ERROR_PCMDATA_SIZE_MISMATCH",    "An error occurred because the size of the PCM buffer provided by the application does not match with the audio settings." } },
    //{ 0x8119000E,{ "SCE_RT_SECOND_SCREEN_ERROR_NETWORK_COMM_FAILURE", "An error occurred because a corrupted/unexpected network packet has been received." } },
    //{ 0x8119000F,{ "SCE_RT_SECOND_SCREEN_ERROR_CLIENT_INFO_NOT_AVAILABLE",    "An error occurred because the remote companion device information is not currently available." } },
    //{ 0x81190010,{ "SCE_RT_SECOND_SCREEN_ERROR_PING_TIME_NOT_AVAILABLE",  "An error occurred because the network ping time is not currently available." } },
    //{ 0x81190011,{ "SCE_RT_SECOND_SCREEN_ERROR_MEMORY_LEAK_DETECTED", "An error occurred because a memory leak was detected by the internal memory allocator." } },
    //{ 0x81190012,{ "SCE_RT_SECOND_SCREEN_ERROR_FAIL_TO_ACQUIRE_ADDRESS",  "An error occurred because the IP address could not be acquired." } },
    //{ 0x81190013,{ "SCE_RT_SECOND_SCREEN_ERROR_INTERNAL_ASSERT",  "An error occurred because an internal assertion failed." } },
    //{ 0x811B0000,{ "SCE_HEAD_TRACKER_ERROR_PARAM",    "Parameter is invalid" } },
    //{ 0x811B0001,{ "SCE_HEAD_TRACKER_ERROR_NULL_POINTER", "Parameter is NULL pointer" } },
    //{ 0x811B0002,{ "SCE_HEAD_TRACKER_ERROR_INVALID_ALIGNMENNT",   "Memory alignment is invalid" } },
    //{ 0x811B0003,{ "SCE_HEAD_TRACKER_ERROR_INVALID_MEMORY_SIZE",  "Memory size is invalid" } },
    //{ 0x811B0004,{ "SCE_HEAD_TRACKER_ERROR_INVALID_INPUT_DEPTH_IMAGE_SIZE",   "Input depth image size is invalid" } },
    //{ 0x811B0005,{ "SCE_HEAD_TRACKER_ERROR_INSTANCE_NOT_IDLE",    "Instance is not idle" } },
    //{ 0x811B0006,{ "SCE_HEAD_TRACKER_ERROR_INSTANCE_NOT_RUNNING", "Instance is not running" } },
    //{ 0x811B0007,{ "SCE_HEAD_TRACKER_ERROR_FLEXIBLE_MEMORY_NOT_ENOUGH",   "Flexible memory is not enough" } },
    //{ 0x811B00FF,{ "SCE_HEAD_TRACKER_ERROR_FATAL",    "Fatal error occurred" } },
    //{ 0x811D0100,{ "SCE_VIDEODEC2_ERROR_API_FAIL",    "Failed to calling decoder API" } },
    //{ 0x811D0101,{ "SCE_VIDEODEC2_ERROR_STRUCT_SIZE", "Invalid struct size specified in thisSize" } },
    //{ 0x811D0102,{ "SCE_VIDEODEC2_ERROR_ARGUMENT_POINTER",    "Argument pointer is invalid" } },
    //{ 0x811D0103,{ "SCE_VIDEODEC2_ERROR_DECODER_INSTANCE",    "Decoder instance is invalid" } },
    //{ 0x811D0104,{ "SCE_VIDEODEC2_ERROR_MEMORY_SIZE", "Necessary memory size is insufficient" } },
    //{ 0x811D0105,{ "SCE_VIDEODEC2_ERROR_MEMORY_POINTER",  "Invalid memory pointer" } },
    //{ 0x811D0106,{ "SCE_VIDEODEC2_ERROR_FRAME_BUFFER_SIZE",   "Invalid frame buffer size" } },
    //{ 0x811D0107,{ "SCE_VIDEODEC2_ERROR_FRAME_BUFFER_POINTER",    "Invalid pointer for frame buffer" } },
    //{ 0x811D0108,{ "SCE_VIDEODEC2_ERROR_FRAME_BUFFER_ALIGNMENT",  "Invalid frame buffer alignment" } },
    //{ 0x811D0109,{ "SCE_VIDEODEC2_ERROR_NOT_ONION_MEMORY",    "Improper memory that must be WB Onion" } },
    //{ 0x811D010A,{ "SCE_VIDEODEC2_ERROR_NOT_GARLIC_MEMORY",   "Improper memory that must be WC Garlic" } },
    //{ 0x811D010B,{ "SCE_VIDEODEC2_ERROR_NOT_DIRECT_MEMORY",   "Improper memory that must be direct memory" } },
    //{ 0x811D010C,{ "SCE_VIDEODEC2_ERROR_MEMORY_INFO", "Error due to improper MemoryInfo setting" } },
    //{ 0x811D010D,{ "SCE_VIDEODEC2_ERROR_ACCESS_UNIT_SIZE",    "Invalid access unit size" } },
    //{ 0x811D010E,{ "SCE_VIDEODEC2_ERROR_ACCESS_UNIT_POINTER", "Invalid pointer for access unit" } },
    //{ 0x811D010F,{ "SCE_VIDEODEC2_ERROR_OUTPUT_INFO", "Error due to improper OutputInfo setting" } },
    //{ 0x811D0110,{ "SCE_VIDEODEC2_ERROR_COMPUTE_QUEUE",   "Invalid computeQueue" } },
    //{ 0x811D0111,{ "SCE_VIDEODEC2_ERROR_FATAL_STATE", "Decoder is fatal state needed to delete decoder" } },
    //{ 0x811D0112,{ "SCE_VIDEODEC2_ERROR_PRESET_VALUE",    "Invalid preset value" } },
    //{ 0x811D0200,{ "SCE_VIDEODEC2_ERROR_CONFIG_INFO", "Error due to improper ConfigInfo setting" } },
    //{ 0x811D0201,{ "SCE_VIDEODEC2_ERROR_COMPUTE_PIPE_ID", "Invalid computePipeId" } },
    //{ 0x811D0202,{ "SCE_VIDEODEC2_ERROR_COMPUTE_QUEUE_ID",    "Invalid computeQueueId" } },
    //{ 0x811D0203,{ "SCE_VIDEODEC2_ERROR_RESOURCE_TYPE",   "Invalid resourceType" } },
    //{ 0x811D0204,{ "SCE_VIDEODEC2_ERROR_CODEC_TYPE",  "Invalid codecType" } },
    //{ 0x811D0205,{ "SCE_VIDEODEC2_ERROR_PROFILE_LEVEL",   "Invalid profile or level" } },
    //{ 0x811D0206,{ "SCE_VIDEODEC2_ERROR_PIPELINE_DEPTH",  "Invalid decodePipelineDepth" } },
    //{ 0x811D0207,{ "SCE_VIDEODEC2_ERROR_AFFINITY_MASK",   "Invalid cpuAffinityMask" } },
    //{ 0x811D0208,{ "SCE_VIDEODEC2_ERROR_THREAD_PRIORITY", "Invalid cpuThreadPriority" } },
    //{ 0x811D0209,{ "SCE_VIDEODEC2_ERROR_DPB_FRAME_COUNT", "Invalid maxDpbFrameCount" } },
    //{ 0x811D020A,{ "SCE_VIDEODEC2_ERROR_FRAME_WIDTH_HEIGHT",  "Invalid maxFrameWidth or maxFrameHeight" } },
    //{ 0x811D020B,{ "SCE_VIDEODEC2_ERROR_EXTRA_CONFIG_INFO",   "Invalid extraConfigInfo" } },
    //{ 0x811D0300,{ "SCE_VIDEODEC2_ERROR_NEW_SEQUENCE",    "New sequence that needs to reset decoder" } },
    //{ 0x811D0301,{ "SCE_VIDEODEC2_ERROR_ACCESS_UNIT", "Decode error in an input access unit" } },
    //{ 0x811D0302,{ "SCE_VIDEODEC2_ERROR_OVERSIZE_DECODE", "Decode process is too big for the current instance" } },
    //{ 0x811D0303,{ "SCE_VIDEODEC2_ERROR_INVALID_SEQUENCE",    "No valid sequence found in input stream" } },
    //{ 0x811D0304,{ "SCE_VIDEODEC2_ERROR_FATAL_STREAM",    "Fatal stream that needs to reset decoder" } },
    //{ 0x81210000,{ "SCE_AT9_ENC_ERROR_INTERNAL_ERROR",    "internal error" } },
    //{ 0x81210001,{ "SCE_AT9_ENC_ERROR_INVALID_POINTER",   "invalid pointer" } },
    //{ 0x81210002,{ "SCE_AT9_ENC_ERROR_INVALID_WORK_MEM_SIZE", "invalid size of memory" } },
    //{ 0x81210003,{ "SCE_AT9_ENC_ERROR_OUTPUT_BUFFER_SIZE",    "invalid size of output buffer" } },
    //{ 0x81210004,{ "SCE_AT9_ENC_ERROR_INVALID_UISIZE",    "invalid size of ATRAC9 Encoder parameter structure" } },
    //{ 0x81210005,{ "SCE_AT9_ENC_ERROR_INVALID_BIT_RATE",  "invalid bit rate" } },
    //{ 0x81210006,{ "SCE_AT9_ENC_ERROR_INVALID_NUM_CHANNELS",  "invalid number of channels" } },
    //{ 0x81210007,{ "SCE_AT9_ENC_ERROR_INVALID_SAMPLE_RATE",   "invalid sample rate" } },
    //{ 0x81210008,{ "SCE_AT9_ENC_ERROR_INVALID_INPUT_FORMAT",  "invalid input format" } },
    //{ 0x81210009,{ "SCE_AT9_ENC_ERROR_INVALID_SUPERFRAME",    "invalid super frame" } },
    //{ 0x8121000A,{ "SCE_AT9_ENC_ERROR_INVALID_DUAL",  "invalid dual specification" } },
    //{ 0x8121000B,{ "SCE_AT9_ENC_ERROR_INVALID_SLC",   "invalid extremely low frequency wave ingredient cut specification of a LFE channel" } },
    //{ 0x8121000C,{ "SCE_AT9_ENC_ERROR_INVALID_WBAND", "invalid encoding specification of zone priority" } },
    //{ 0x8121000D,{ "SCE_AT9_ENC_ERROR_INVALID_NBANDS",    "invalid encoding band" } },
    //{ 0x8121000E,{ "SCE_AT9_ENC_ERROR_INVALID_ISBANDS",   "invalid intensity stereo start band" } },
    //{ 0x8121000F,{ "SCE_AT9_ENC_ERROR_INVALID_GRADMODE",  "invalid encoding mode" } },
    //{ 0x81210010,{ "SCE_AT9_ENC_ERROR_INVALID_PREVIOUS_INPUT_SIZE",   "invalid frame size" } },
    //{ 0x812201A1,{ "SCE_PS4LINK_RP_ERROR_NET_DISABLEDIF", "" } },
    //{ 0x81222C00,{ "SCE_PS4LINK_RP_ERROR_PS4_NOT_REGISTERED_FOR_INET", "" } },
    //{ 0x81222C02,{ "SCE_PS4LINK_RP_ERROR_FAILED_TO_SEND_WAKEUP_USER", "" } },
    //{ 0x81222C03,{ "SCE_PS4LINK_RP_ERROR_FAILED_TO_SEND_WAKEUP_DEVICE", "" } },
    //{ 0x81228D00,{ "SCE_PS4LINK_RP_ERROR_PS4_NOTFOUND",   "PS4 not found" } },
    //{ 0x81228D01,{ "SCE_PS4LINK_RP_ERROR_INVALID_RESPONSE",   "invalid response" } },
    //{ 0x81228D02,{ "SCE_PS4LINK_RP_ERROR_NP_ONLINE_ID",   "NP OnlineID error" } },
    //{ 0x81228D03,{ "SCE_PS4LINK_RP_ERROR_NETREG_FAIL",    "Net Registered Fail" } },
    //{ 0x81228D04,{ "SCE_PS4LINK_RP_ERROR_NETREG_TOO_MANY_REGISTERED", "" } },
    //{ 0x81228D05,{ "SCE_PS4LINK_RP_ERROR_NETREG_INVALID_VALUE", "" } },
    //{ 0x81228D06,{ "SCE_PS4LINK_RP_ERROR_NETWORK_ILLEGAL_DATA", "" } },
    //{ 0x81228D07,{ "SCE_PS4LINK_RP_ERROR_NETWORK_CLOSED", "" } },
    //{ 0x81228D08,{ "SCE_PS4LINK_RP_ERROR_NETWORK_TIMEOUT", "" } },
    //{ 0x81228D09,{ "SCE_PS4LINK_RP_ERROR_NETREG_PINCODE", "" } },
    //{ 0x81228D10,{ "SCE_PS4LINK_RP_ERROR_PS4_MAX_CONNECTION", "" } },
    //{ 0x81228D11,{ "SCE_PS4LINK_RP_ERROR_PS4_UPDATE", "" } },
    //{ 0x81228D12,{ "SCE_PS4LINK_RP_ERROR_PS4_SETTING", "" } },
    //{ 0x81228D13,{ "SCE_PS4LINK_RP_ERROR_PS4_NOT_CONNECT", "" } },
    //{ 0x81228D14,{ "SCE_PS4LINK_RP_ERROR_VITA_UPDATE", "" } },
    //{ 0x81228D15,{ "SCE_PS4LINK_RP_ERROR_PS4_NOT_CONNECT_DEMON_RESTART", "" } },
    //{ 0x81228D16,{ "SCE_PS4LINK_RP_ERROR_PS4_FOREGROUND_DISC_PLAYER", "" } },
    //{ 0x81228D20,{ "SCE_PS4LINK_RP_ERROR_GK_TESTFAILED", "" } },
    //{ 0x81228D21,{ "SCE_PS4LINK_RP_ERROR_BATDATA", "" } },
    //{ 0x81228D22,{ "SCE_PS4LINK_RP_ERROR_FAIL", "" } },
    //{ 0x81228D23,{ "SCE_PS4LINK_RP_ERROR_GK_SHUTTINGDOWN", "" } },
    //{ 0x81228D24,{ "SCE_PS4LINK_RP_ERROR_BROKE_HEARTBEAT", "" } },
    //{ 0x81228D25,{ "SCE_PS4LINK_RP_ERROR_CONNECTION_QUALITY", "" } },
    //{ 0x81228D26,{ "SCE_PS4LINK_RP_ERROR_GK_TESTRTT", "" } },
    //{ 0x81228D27,{ "SCE_PS4LINK_RP_ERROR_GK_TESTSTREAM", "" } },
    //{ 0x81228D28,{ "SCE_PS4LINK_RP_ERROR_OTHER_REASON", "" } },
    //{ 0x81228D30,{ "SCE_PS4LINK_RP_ERROR_OUT_OF_MEMORY", "" } },
    //{ 0x81228D31,{ "SCE_PS4LINK_RP_ERROR_FATAL", "" } },
    //{ 0x81228D32,{ "SCE_PS4LINK_RP_ERROR_INVALID_DATA", "" } },
    //{ 0x81228D33,{ "SCE_PS4LINK_RP_ERROR_TIMEOUT",    "timeout" } },
    //{ 0x81228D34,{ "SCE_PS4LINK_RP_ERROR_NET", "" } },
    //{ 0x81228D35,{ "SCE_PS4LINK_RP_ERROR_NET_TIMEOUT", "" } },
    //{ 0x81228D36,{ "SCE_PS4LINK_RP_ERROR_NET_AP", "" } },
    //{ 0x81228D37,{ "SCE_PS4LINK_RP_ERROR_NET_ECONNREFUSED", "" } },
    //{ 0x81228D38,{ "SCE_PS4LINK_RP_ERROR_M4VDEC", "" } },
    //{ 0x81228D39,{ "SCE_PS4LINK_RP_ERROR_AVCDEC", "" } },
    //{ 0x81228D3A,{ "SCE_PS4LINK_RP_ERROR_BASE64_INVALID_LENGTH", "" } },
    //{ 0x81228D3B,{ "SCE_PS4LINK_RP_ERROR_BASE64_INVALID_CHARACTER", "" } },
    //{ 0x81228D3C,{ "SCE_PS4LINK_RP_ERROR_THREAD", "" } },
    //{ 0x81228D3D,{ "SCE_PS4LINK_RP_ERROR_FILE", "" } },
    //{ 0x81228D3E,{ "SCE_PS4LINK_RP_ERROR_CRYPT", "" } },
    //{ 0x81228D3F,{ "SCE_PS4LINK_RP_ERROR_NP_SERVER", "" } },
    //{ 0x81228D40,{ "SCE_PS4LINK_RP_ERROR_NP_PS4_INFO_NOT_FOUND", "" } },
    //{ 0x81228D41,{ "SCE_PS4LINK_RP_ERROR_FORBIDDEN", "" } },
    //{ 0x81228D43,{ "SCE_PS4LINK_RP_ERROR_CONNECT", "" } },
    //{ 0x81228D44,{ "SCE_PS4LINK_RP_ERROR_ABORT", "" } },
    //{ 0x81228D45,{ "SCE_PS4LINK_RP_ERROR_NET_IF", "" } },
    //{ 0x81228D46,{ "SCE_PS4LINK_RP_ERROR_PS4_NOTFOUND_NET", "" } },
    //{ 0x81228D47,{ "SCE_PS4LINK_RP_ERROR_PS4_SHUTDOWN", "" } },
    //{ 0x81228D48,{ "SCE_PS4LINK_RP_ERROR_PS4_UNMATCHED_SIGNIN_ID", "" } },
    //{ 0x81228D49,{ "SCE_PS4LINK_RP_ERROR_NEED_DEVREG", "" } },
    //{ 0x81228D50,{ "SCE_PS4LINK_RP_ERROR_INVALID_PARAM", "" } },
    //{ 0x81228D51,{ "SCE_PS4LINK_RP_ERROR_BUF_OVERFLOW", "" } },
    //{ 0x81228D52,{ "SCE_PS4LINK_RP_ERROR_ABORT_COMPLETE", "" } },
    //{ 0x81228D53,{ "SCE_PS4LINK_RP_ERROR_PS4_DATA_OLD", "" } },
    //{ 0x81228D54,{ "SCE_PS4LINK_RP_ERROR_ENOBUFS", "" } },
    //{ 0x81228D55,{ "SCE_PS4LINK_RP_ERROR_CONTROLLER_DISCONNECT", "" } },
    //{ 0x81228D56,{ "SCE_PS4LINK_RP_ERROR_ALREADY_USED_RESOURCE", "" } },
    //{ 0x81228D70,{ "SCE_PS4LINK_RP_ERROR_LOGIN", "" } },
    //{ 0x81228D71,{ "SCE_PS4LINK_RP_ERROR_LOGIN_MAXIMUM", "" } },
    //{ 0x81228D80,{ "SCE_PS4LINK_RP_ERROR_SECOND_SCREEN", "" } },
    //{ 0x81228D90,{ "SCE_PS4LINK_RP_ERROR_SEARCH_FAILED", "" } },
    //{ 0x81228D91,{ "SCE_PS4LINK_RP_ERROR_SEARCH_PROCESS_ERROR", "" } },
    //{ 0x81228D92,{ "SCE_PS4LINK_RP_ERROR_SEARCH_STANDBY_PS4_DETECTED", "" } },
    //{ 0x81228DA0,{ "SCE_PS4LINK_RP_ERROR_INET_MATCH2_SERVER_UNAVAILABLE", "" } },
    //{ 0x81228DA1,{ "SCE_PS4LINK_RP_ERROR_INET_MATCH2_WORLD_ISSUE", "" } },
    //{ 0x81228DA2,{ "SCE_PS4LINK_RP_ERROR_INET_MATCH2_ROOM_ISSUE", "" } },
    //{ 0x81228DA3,{ "SCE_PS4LINK_RP_ERROR_INET_MATCH2_SIGNALING_ISSUE", "" } },
    //{ 0x81228DA4,{ "SCE_PS4LINK_RP_ERROR_INET_MATCH2_LEAVE_MEMBER", "" } },
    //{ 0x81228DA5,{ "SCE_PS4LINK_RP_ERROR_INET_MATCH2_PS4_CONNECT_FAIL", "" } },
    //{ 0x81228DA6,{ "SCE_PS4LINK_RP_ERROR_INET_MATCH2_FAILED", "" } },
    //{ 0x81228DB0,{ "SCE_PS4LINK_RP_ERROR_SP_MATCH2_SERVER_UNAVAILABLE", "" } },
    //{ 0x81228DB1,{ "SCE_PS4LINK_RP_ERROR_SP_MATCH2_ROOM_ISSUE", "" } },
    //{ 0x81228DB2,{ "SCE_PS4LINK_RP_ERROR_SP_MATCH2_SIGNALING_ISSUE", "" } },
    //{ 0x81228DB3,{ "SCE_PS4LINK_RP_ERROR_SP_MATCH2_LEAVE_MEMBER", "" } },
    //{ 0x81228DB4,{ "SCE_PS4LINK_RP_ERROR_SP_MATCH2_PS4_CONNECT_FAIL", "" } },
    //{ 0x81228DB5,{ "SCE_PS4LINK_RP_ERROR_SP_MATCH2_FAILED", "" } },
    //{ 0x81228DFF,{ "SCE_PS4LINK_RP_ERROR_GENERAL", "" }},
    //{ 0x81260801,{ "SCE_VR_TRACKER_ERROR_NOT_INIT",   "The libVrTracker library has not been initialized." } },
    //{ 0x81260802,{ "SCE_VR_TRACKER_ERROR_ALREADY_INITIALIZED",    "The libVrTracker library has already been initialized." } },
    //{ 0x81260803,{ "SCE_VR_TRACKER_ERROR_DEVICE_NOT_REGISTERED",  "This device is not registered with the VR tracker library." } },
    //{ 0x81260804,{ "SCE_VR_TRACKER_ERROR_DEVICE_ALREADY_REGISTERED",  "This device is already registered with the VR tracker library." } },
    //{ 0x81260805,{ "SCE_VR_TRACKER_ERROR_DEVICE_LIMIT",   "Maximum number of devices reached. The VR tracker library cannot track additional devices." } },
    //{ 0x81260806,{ "SCE_VR_TRACKER_ERROR_ARGUMENT_INVALID",   "Invalid argument presented to the VR tracker library." } },
    //{ 0x81260807,{ "SCE_VR_TRACKER_ERROR_INVALID_DEVICE_HANDLE",  "Invalid device handle" } },
    //{ 0x81260808,{ "SCE_VR_TRACKER_ERROR_BUSY",   "The VR Tracker library is busy. Please try later." } },
    //{ 0x81260809,{ "SCE_VR_TRACKER_ERROR_INTERNAL_ERROR", "There is a internal error" } },
    //{ 0x8126080A,{ "SCE_VR_TRACKER_ERROR_NO_MOTION_SENSOR_DATA",  "The motion sensor data is not available." } },
    //{ 0x8126080B,{ "SCE_VR_TRACKER_ERROR_DEVICE_NOT_ORIENTED",    "Camera has not yet located or oriented the VR device." } },
    //{ 0x8126080C,{ "SCE_VR_TRACKER_ERROR_TIMESTAMP_OUT_OF_RANGE", "Timestamp argument is invalid." } },
    //{ 0x8126080D,{ "SCE_VR_TRACKER_ERROR_CAMERA_ACCELEROMETER_INVALID_VALUE", "The accelerometer of camera is invalid." } },
    //{ 0x8126080E,{ "SCE_VR_TRACKER_ERROR_NOT_EXECUTE_GPU_PROCESS",    "sceVrTrackerGPUWaitAndCPUProcess() is not executed even once." } },
    //{ 0x8126080F,{ "SCE_VR_TRACKER_ERROR_NOT_ENOUGH_SENSOR_HISTORY",  "storing sensor data is not enough" } },
    //{ 0x81260810,{ "SCE_VR_TRACKER_ERROR_NOT_YET_DETECTING_FRONT_LED",    "Front LEDs of HMD has not detected yet" } },
    //{ 0x81260811,{ "SCE_VR_TRACKER_ERROR_ALREADY_PROCESSING_CAMERA_FRAME",    "timestamp of camera frame has already processed" } },
    //{ 0x81260812,{ "SCE_VR_TRACKER_ERROR_INVALID_CAMERA_CONFIGURATION",   "invalid camera configuration" } },
    //{ 0x81260813,{ "SCE_VR_TRACKER_ERROR_INVALID_STATUS_OF_CAMERA_FRAME", "status of camera frame is not SCE_CAMERA_STATUS_IS_ACTIVE" } },
    //{ 0x81260814,{ "SCE_VR_TRACKER_ERROR_PLAYSTATION_CAMERA_NOT_CONNECTED",   "Playstation Camera is not connected" } },
    //{ 0x81260815,{ "SCE_VR_TRACKER_ERROR_NOT_EXECUTE_GPU_SUBMIT", "sceVrTrackerGPUSubmit() is not executed." } },
    //{ 0x81260816,{ "SCE_VR_TRACKER_ERROR_NOT_EXECUTE_GPU_WAIT",   "sceVrTrackerGPUWait() is not executed." } },
    //{ 0x81260817,{ "SCE_VR_TRACKER_ERROR_UPDATE_HMD_MOTION_SENSOR_DATA",  "updating motion sensor data of hmd is failed" } },
    //{ 0x81260818,{ "SCE_VR_TRACKER_ERROR_UPDATE_DS4_MOTION_SENSOR_DATA",  "updating motion sensor data of dualshock4 is failed" } },
    //{ 0x81260819,{ "SCE_VR_TRACKER_ERROR_UPDATE_MOVE_MOTION_SENSOR_DATA", "updating motion sensor data of move is failed" } },
    //{ 0x8126081A,{ "SCE_VR_TRACKER_ERROR_CAMERA_ADJUSTMENT_IS_NECESSARY", "System Menu (Settings>Devices>PlayStation(R)Camera>Adjust PlayStation(R)Camera ) execution is necessary" } },
    //{ 0x8126081B,{ "SCE_VR_TRACKER_ERROR_NOT_EXECUTE_CPU_PROCESS",    "sceVrTrackerCPUProcess() is not executed." } },
    //{ 0x8126081C,{ "SCE_VR_TRACKER_ERROR_NOT_STARTED",    "Tracking is not started" } },
    //{ 0x8126081D,{ "SCE_VR_TRACKER_ERROR_INVALID_CPU_MODE",   "Invalid CPU mode" } },
    //{ 0x8126081E,{ "SCE_VR_TRACKER_ERROR_NOT_SUPPORTED",  "The Function is not supported" } },
    //{ 0x812608FF,{ "SCE_VR_TRACKER_ERROR_FATAL",  "The VR tracker library has encountered an unspecified error." } },
    //{ 0x81270001,{ "SCE_NP_SNS_YOUTUBE_DIALOG_ERROR_INTERNAL",    "An internal error occurred in the utility." } },
    //{ 0x81270002,{ "SCE_NP_SNS_YOUTUBE_DIALOG_ERROR_NOT_SIGNIN",  "Without signing in, the functionality of YouTube cannot be used." } },
    //{ 0x81270003,{ "SCE_NP_SNS_YOUTUBE_DIALOG_ERROR_ACCESS_NOT_ALLOWED",  "User permissions could not be obtained" } },
    //{ 0x81270004,{ "SCE_NP_SNS_YOUTUBE_DIALOG_ERROR_INCREASING_PERMISSION_FAILED",    "Increasing Permission was failed" } },
    //{ 0x81270005,{ "SCE_NP_SNS_YOUTUBE_DIALOG_ERROR_CERTIFICATE_VERIFICATION",    "The certificate verification was failed on loading Web App" } },
    //{ 0x81270006,{ "SCE_NP_SNS_YOUTUBE_DIALOG_ERROR_WEB_APP_FATAL",   "A fatal error occured in Web App" } },
    //{ 0x81270007,{ "SCE_NP_SNS_YOUTUBE_DIALOG_ERROR_ACCOUNT_LINK_PARENTAL_CONTROL",   "Internet Browser function is disabled by parental control on account linkage." } },
    //{ 0x812A0000,{ "SCE_FACE_TRACKER_ERROR_BASE", "face tracker error base" } },
    //{ 0x812A0001,{ "SCE_FACE_TRACKER_ERROR_INVALID_PARAM",    "Parameter is invalid" } },
    //{ 0x812A0002,{ "SCE_FACE_TRACKER_ERROR_INVALID_WORKAREA", "Working memory buffer is not set correctly." } },
    //{ 0x812A0003,{ "SCE_FACE_TRACKER_ERROR_NOT_INITIALIZED",  "Face tracker is not initialized." } },
    //{ 0x812A0004,{ "SCE_FACE_TRACKER_ERROR_ALREADY_INITIALIZED",  "Face tracker is already initialized." } },
    //{ 0x812A0005,{ "SCE_FACE_TRACKER_ERROR_ID_FULL",  "The IDs (trackId/userId) are full." } },
    //{ 0x812A0006,{ "SCE_FACE_TRACKER_ERROR_ID_NOT_EXIST", "The ID (trackId/userId) is not exist." } },
    //{ 0x812A0007,{ "SCE_FACE_TRACKER_ERROR_INVALID_TIMING",   "The function call timing is invalid." } },
    //{ 0x812A0008,{ "SCE_FACE_TRACKER_ERROR_INTERNAL_ERROR",   "Internal error." } },
    //{ 0x812A0009,{ "SCE_FACE_TRACKER_ERROR_THREAD_NOT_EXECUTED",  "Internal thread of face tracker is not excuted." } },
    //{ 0x812A000A,{ "SCE_FACE_TRACKER_ERROR_THREAD_FINISHED",  "Face tracker thread request to stop." } },
    //{ 0x812B0001,{ "SCE_HAND_TRACKER_ERROR_INVALID_PARAM",    "Parameter is invalid" } },
    //{ 0x812D0000,{ "SCE_USB_STORAGE_DIALOG_ERROR_DISCONNECTED",   "The connection to the USB storage device has been lost" } },
    //{ 0x812D0001,{ "SCE_USB_STORAGE_DIALOG_ERROR_NO_DEVICE",  "The USB storage device is not connected" } },
    //{ 0x812D0002,{ "SCE_USB_STORAGE_DIALOG_ERROR_USED_BY_ANOTHER_APP",    "The USB storage device cannot be used" } },
    //{ 0x812E8002,{ "SCE_CRASH_REPORTER_ERROR_UPLOAD_REGISTER_002",    "Failed to register upload file" } },
    //{ 0x812E8003,{ "SCE_CRASH_REPORTER_ERROR_UPLOAD_REGISTER_003",    "Failed to register upload file" } },
    //{ 0x812E8004,{ "SCE_CRASH_REPORTER_ERROR_UPLOAD_REGISTER_004",    "Failed to register upload file" } },
    //{ 0x812E8008,{ "SCE_CRASH_REPORTER_ERROR_UPLOAD_REGISTER_008",    "Failed to register upload file" } },
    //{ 0x812E8018,{ "SCE_CRASH_REPORTER_ERROR_UPLOAD_REGISTER_018",    "Too many save data have been uploaded" } },
    //{ 0x812E801A,{ "SCE_CRASH_REPORTER_ERROR_UPLOAD_FAILED",  "Failed to register upload file" } },
    //{ 0x812EFFFF,{ "SCE_CRASH_REPORTER_ERROR_EINVAL", "Invalid argument" } },
    //{ 0x812F0001,{ "SCE_MUSIC_PLAYER_SERVICE_ERROR_NOT_INITIALIZED",  "Not initialized" } },
    //{ 0x812F0002,{ "SCE_MUSIC_PLAYER_SERVICE_ERROR_ALREADY_INITIALIZED",  "Already initialized" } },
    //{ 0x812F0003,{ "SCE_MUSIC_PLAYER_SERVICE_ERROR_FATAL",    "Fatal error" } },
    //{ 0x812F0004,{ "SCE_MUSIC_PLAYER_SERVICE_ERROR_INVALID_ARGUMENT", "Invalid argument" } },
    //{ 0x812F0101,{ "SCE_MUSIC_PLAYER_SERVICE_ERROR_TOO_MANY_ENTRY",   "Max count over error" } },
    //{ 0x812F0102,{ "SCE_MUSIC_PLAYER_SERVICE_ERROR_NOT_EXIST",    "Data is not exist" } },
    //{ 0x812F0103,{ "SCE_MUSIC_PLAYER_SERVICE_ERROR_NOT_BEGIN_TRANSACTION",    "Not starting transaction" } },
    //{ 0x812F0104,{ "SCE_MUSIC_PLAYER_SERVICE_ERROR_ALREADY_BEGIN_TRANSACTION",    "Already begin transaction" } },
    //{ 0x812F0105,{ "SCE_MUSIC_PLAYER_SERVICE_ERROR_INACTIVE", "Music Service is inactive" } },
    //{ 0x812F0106,{ "SCE_MUSIC_PLAYER_SERVICE_ERROR_DATA_CORRUPTION_DETECTED", "Data corruption is detected" } },
    //{ 0x812F0107,{ "SCE_MUSIC_PLAYER_SERVICE_ERROR_PROHIBITED",   "Using MusicPlayerService is prohibited" } },
    //{ 0x812F0108,{ "SCE_MUSIC_PLAYER_SERVICE_ERROR_ALREADY_EXIST",    "Data is already exist" } },
    //{ 0x812F0109,{ "SCE_MUSIC_PLAYER_SERVICE_ERROR_ENOSPC",   "There is no space on the drive" } },
    //{ 0x812F010A,{ "SCE_MUSIC_PLAYER_SERVICE_ERROR_NO_EVENT", "No events are available" } },
    //{ 0x812F010B,{ "SCE_MUSIC_PLAYER_SERVICE_ERROR_OPERATION_NOT_SUPPORTED",  "Operation not supported" } },
    //{ 0x81340001,{ "SCE_LOGIN_DIALOG_ERROR_NOT_INITIALIZED",  "The Dialog has not been initialized" } },
    //{ 0x81340002,{ "SCE_LOGIN_DIALOG_ERROR_ALREADY_INITIALIZED",  "The dialog is already initialized." } },
    //{ 0x81340003,{ "SCE_LOGIN_DIALOG_ERROR_PARAM_INVALID",    "It is an invalid parameter" } },
    //{ 0x81340004,{ "SCE_LOGIN_DIALOG_ERROR_UNEXPECTED_FATAL", "Unexpected fatal error occurred" } },
    //{ 0x81340005,{ "SCE_LOGIN_DIALOG_ERROR_INVALID_STATE",    "It's the state that is unable to call the API." } },
    //{ 0x81340006,{ "SCE_LOGIN_DIALOG_ERROR_SERVICE_BUSY", "It's the service state that is unable to call the API." } },
    //{ 0x81340007,{ "SCE_LOGIN_DIALOG_ERROR_INVALID_USER_ID",  "Invalid user ID was specified." } },
    //{ 0x81350001,{ "SCE_SIGNIN_DIALOG_ERROR_NOT_INITIALIZED", "The Dialog has not been initialized" } },
    //{ 0x81350002,{ "SCE_SIGNIN_DIALOG_ERROR_ALREADY_INITIALIZED", "The dialog is already initialized." } },
    //{ 0x81350003,{ "SCE_SIGNIN_DIALOG_ERROR_PARAM_INVALID",   "It is an invalid parameter" } },
    //{ 0x81350004,{ "SCE_SIGNIN_DIALOG_ERROR_UNEXPECTED_FATAL",    "Unexpected fatal error occurred" } },
    //{ 0x81350005,{ "SCE_SIGNIN_DIALOG_ERROR_INVALID_STATE",   "It's the state that is unable to call the API." } },
    //{ 0x81350006,{ "SCE_SIGNIN_DIALOG_ERROR_SERVICE_BUSY",    "It's the service state that is unable to call the API." } },
    //{ 0x81350007,{ "SCE_SIGNIN_DIALOG_ERROR_INVALID_USER_ID", "Invalid user ID was specified." } },
    //{ 0x81360001,{ "SCE_NP_SNS_DAILYMOTION_DIALOG_ERROR_INTERNAL",    "An internal error occurred in the utility." } },
    //{ 0x81360002,{ "SCE_NP_SNS_DAILYMOTION_DIALOG_ERROR_NOT_SIGNIN",  "Without signing in, the functionality of DailyMotion cannot be used." } },
    //{ 0x81360003,{ "SCE_NP_SNS_DAILYMOTION_DIALOG_ERROR_CERTIFICATE_VERIFICATION",    "The certificate verification was failed on loading Web App" } },
    //{ 0x81360004,{ "SCE_NP_SNS_DAILYMOTION_DIALOG_ERROR_WEB_APP_FATAL",   "A fatal error occured in Web App" } },
    //{ 0x81360005,{ "SCE_NP_SNS_DAILYMOTION_DIALOG_ERROR_SUB_ACCOUNT", "DailyMotion coordination functionalities cannot be used because the account is sub-account." } },
    //{ 0x81360006,{ "SCE_NP_SNS_DAILYMOTION_DIALOG_ERROR_ACCOUNT_LINK_PARENTAL_CONTROL",   "Internet Browser function is disabled by parental control on account linkage." } },
    //{ 0x81380001,{ "SCE_CUSTOM_MUSIC_CORE_ERROR_INVALID_PARAM",   "It is an invalid parameter" } },
    //{ 0x81380002,{ "SCE_CUSTOM_MUSIC_CORE_ERROR_NO_MEMORY",   "There are not enough memory" } },
    //{ 0x81380003,{ "SCE_CUSTOM_MUSIC_CORE_ERROR_FATAL",   "Unexpected fatal error occurs" } },
    //{ 0x81380004,{ "SCE_CUSTOM_MUSIC_CORE_ERROR_BUSY",    "Cannot execute because CustomMusicCore is running another processing." } },
    //{ 0x81380005,{ "SCE_CUSTOM_MUSIC_CORE_ERROR_ALREADY_STARTED", "Already Started." } },
    //{ 0x81380006,{ "SCE_CUSTOM_MUSIC_CORE_ERROR_NOT_STARTED", "Not Started." } },
    //{ 0x81380101,{ "SCE_CUSTOM_MUSIC_CORE_ERROR_CANNOT_OPEN_BGM_PORT",    "Can not open BGM output port" } },
    //{ 0x81380102,{ "SCE_CUSTOM_MUSIC_CORE_ERROR_BGM_PORT_NOT_OPENED", "BGM output port is not opened yet" } },
    //{ 0x81380103,{ "SCE_CUSTOM_MUSIC_CORE_ERROR_CANNOT_ACCESS_BGM_VOLUME",    "Can not access BGM volume value" } },
    //{ 0x81380201,{ "SCE_CUSTOM_MUSIC_CORE_ERROR_INVALID_FUNCTION_TABLE",  "Function table is invalid" } },
    //{ 0x81380202,{ "SCE_CUSTOM_MUSIC_CORE_ERROR_INSUFFICIENT_FUNCTION_TABLES",    "Function tables for operation are insufficient" } },
    //{ 0x81380301,{ "SCE_CUSTOM_MUSIC_CORE_ERROR_CLIENT_NOT_ACTIVE",   "Client is not active" } },
    //{ 0x81380302,{ "SCE_CUSTOM_MUSIC_CORE_ERROR_INVALID_CLIENT_ID",   "Client ID is invalid" } },
    //{ 0x81390000,{ "SCE_SHADER_PERF_ERROR_INVALID_ARGUMENT",  "An error occurred because a supplied argument was not valid." } },
    //{ 0x81390001,{ "SCE_SHADER_PERF_ERROR_INVALID_SHADER_BINARY", "An error occurred because the shader binary was not valid." } },
    //{ 0x81390002,{ "SCE_SHADER_PERF_ERROR_INVALID_MICROCODE_FORMAT",  "An error occurred because an invalid instruction microcode format was detected." } },
    //{ 0x81390003,{ "SCE_SHADER_PERF_ERROR_INVALID_OPCODE",    "An error occurred because an invalid instruction opcode was detected." } },
    //{ 0x81390004,{ "SCE_SHADER_PERF_ERROR_INVALID_OPERAND",   "An error occurred because an invalid instruction operand was detected." } },
    //{ 0x81390005,{ "SCE_SHADER_PERF_ERROR_BINARY_TRUNCATED",  "An error occurred because the shader binary appears to be truncated." } },
    //{ 0x81390006,{ "SCE_SHADER_PERF_ERROR_IO",    "An error occurred because an I/O operation on a stream writer failed." } },
    //{ 0x81390007,{ "SCE_SHADER_PERF_ERROR_OUT_OF_MEMORY", "An error occurred because the system has run out of memory." } },
    //{ 0x81390008,{ "SCE_SHADER_PERF_ERROR_INTERNAL",  "An error occurred because an internal assertion failed." } },
    //{ 0x81390009,{ "SCE_SHADER_PERF_ERROR_INVALID_SDB_FILE",  "An error occurred because the provided SDB file was not valid." } },
    //{ 0x8139000A,{ "SCE_SHADER_PERF_ERROR_UNKNOWN_BINARY_FORMAT", "An error occurred because the shader binary format could not be recognized." } },
    //{ 0x8139000B,{ "SCE_SHADER_PERF_ERROR_NO_MORE_ELEMENTS",  "An error occurred because an enumeration contains no more elements." } },
    //{ 0x813A0001,{ "SCE_LOGIN_SERVICE_ERROR_NOT_INITIALIZED", "Not initialized" } },
    //{ 0x813A0002,{ "SCE_LOGIN_SERVICE_ERROR_ALREADY_INITIALIZED", "Already initialized" } },
    //{ 0x813A0003,{ "SCE_LOGIN_SERVICE_ERROR_PARAM_INVALID",   "It is an invalid parameter" } },
    //{ 0x813A0004,{ "SCE_LOGIN_SERVICE_ERROR_UNEXPECTED_FATAL",    "Unexpected fatal error occurred" } },
    //{ 0x813A0005,{ "SCE_LOGIN_SERVICE_ERROR_SERVICE_BUSY",    "It's the service state that is unable to call the API." } },
    //{ 0x813A0006,{ "SCE_LOGIN_SERVICE_ERROR_INVALID_USER_ID", "Invalid user ID was specified." } },
    //{ 0x813A0007,{ "SCE_LOGIN_SERVICE_ERROR_DEVICE_TYPE_HMD_SPECIFIED_MORE_THAN_ONE", "SCE_LOGIN_SERVICE_USER_ASSIGNED_DEVICE_TYPE_HMD is specified more than one." } },
    //{ 0x813C0001,{ "SCE_WK_FONT_CONFIG_ERROR_INVALID_ARGUMENT", "" } },
    //{ 0x813C0002,{ "SCE_WK_FONT_CONFIG_ERROR_INSUFFICIENT_BUFFER", "" } },
    //{ 0x813C0003,{ "SCE_WK_FONT_CONFIG_ERROR_FONT_NOT_FOUND", "" } },
    //{ 0x81440001,{ "SCE_SOCIAL_SCREEN_ERROR_NOT_INITIALIZED", "this library isn't initialized" } },
    //{ 0x81440002,{ "SCE_SOCIAL_SCREEN_ERROR_ALREADY_INITIALIZED", "this library is already initialized" } },
    //{ 0x81440003,{ "SCE_SOCIAL_SCREEN_ERROR_INVALID_ARGS",    "invalid argument" } },
    //{ 0x81440004,{ "SCE_SOCIAL_SCREEN_ERROR_OUT_OF_MEMORY",   "memory allocation error" } },
    //{ 0x81440005,{ "SCE_SOCIAL_SCREEN_ERROR_FATAL",   "fatal error" } },
    //{ 0x81440006,{ "SCE_SOCIAL_SCREEN_ERROR_NOT_OPEN_SEPARATE_MODE",  "SeparateMode not started" } },
    //{ 0x81440007,{ "SCE_SOCIAL_SCREEN_ERROR_ALREADY_OPEN_SEPARATE_MODE",  "SeparateMode already started" } },
    //{ 0x81440008,{ "SCE_SOCIAL_SCREEN_ERROR_NOT_SUPPORT", "not support" } },
    //{ 0x81460001,{ "SCE_NET_CTL_AP_DIALOG_ERROR_INTERNAL",    "An internal error occurred in the utility." } },
    //{ 0x81490001,{ "SCE_TEXT_TO_SPEECH_ERROR_NO_MEMORY", "" } },
    //{ 0x81490002,{ "SCE_TEXT_TO_SPEECH_ERROR_NO_RESOURCE", "" } },
    //{ 0x81490003,{ "SCE_TEXT_TO_SPEECH_ERROR_INITIALIZE_FAILED", "" } },
    //{ 0x81490004,{ "SCE_TEXT_TO_SPEECH_ERROR_ALREADY_INITIALIZED", "" } },
    //{ 0x81490005,{ "SCE_TEXT_TO_SPEECH_ERROR_NOT_PERMITTED", "" } },
    //{ 0x81490006,{ "SCE_TEXT_TO_SPEECH_ERROR_TEXT_SIZE", "" } },
    //{ 0x81490007,{ "SCE_TEXT_TO_SPEECH_ERROR_TOO_FAST_INPUT", "" } },
    //{ 0x81490010,{ "SCE_TEXT_TO_SPEECH_ERROR_INVALID_CONFIG", "" } },
    //{ 0x81490011,{ "SCE_TEXT_TO_SPEECH_ERROR_INVALID_SPEECH_ID", "" } },
    //{ 0x81490012,{ "SCE_TEXT_TO_SPEECH_ERROR_INVALID_PARAM", "" } },
    //{ 0x81490013,{ "SCE_TEXT_TO_SPEECH_ERROR_INVALID_TEXT", "" } },
    //{ 0x81490016,{ "SCE_TEXT_TO_SPEECH_ERROR_INVALID_POS", "" } },
    //{ 0x81490020,{ "SCE_TEXT_TO_SPEECH_ERROR_NOT_INITIALIZED", "" } },
    //{ 0x81490021,{ "SCE_TEXT_TO_SPEECH_ERROR_NOT_OPENED", "" } },
    //{ 0x81490022,{ "SCE_TEXT_TO_SPEECH_ERROR_NOT_CLOSED", "" } },
    //{ 0x814900FF,{ "SCE_TEXT_TO_SPEECH_ERROR_INTERNAL", "" } },
    //{ 0x814B0001,{ "SCE_EDIT_MP4_ERROR_OUT_OF_MEMORY",    "memory allocation error" } },
    //{ 0x814B0002,{ "SCE_EDIT_MP4_ERROR_INVALID_PARAMS",   "invalid parameter" } },
    //{ 0x814B0003,{ "SCE_EDIT_MP4_ERROR_INVALID_HANDLE",   "invalid handle" } },
    //{ 0x814B0004,{ "SCE_EDIT_MP4_ERROR_INPUT_FILE_OPEN",  "input file open error" } },
    //{ 0x814B0005,{ "SCE_EDIT_MP4_ERROR_INPUT_FILE_FORMAT",    "input file format error" } },
    //{ 0x814B0006,{ "SCE_EDIT_MP4_ERROR_INPUT_FILE_READ",  "input file read error" } },
    //{ 0x814B0007,{ "SCE_EDIT_MP4_ERROR_OUTPUT_FILE_CREATE",   "output file create error" } },
    //{ 0x814B0008,{ "SCE_EDIT_MP4_ERROR_OUTPUT_FILE_WRITE",    "output file write error" } },
    //{ 0x814B0009,{ "SCE_EDIT_MP4_ERROR_OUTPUT_FILE_OVERWRITE",    "output file already exist" } },
    //{ 0x814B000A,{ "SCE_EDIT_MP4_ERROR_OUTPUT_FILE_NO_SPACE", "output file no space" } },
    //{ 0x814B000B,{ "SCE_EDIT_MP4_ERROR_INVALID_EDIT_POINT",   "invalid edit point" } },
    //{ 0x814B000C,{ "SCE_EDIT_MP4_ERROR_NOT_INITIALIZED",  "not initialized" } },
    //{ 0x814B000D,{ "SCE_EDIT_MP4_ERROR_ABORT",    "edit process is aborted" } },
    //{ 0x814B000E,{ "SCE_EDIT_MP4_ERROR_BUSY", "edit process is busy" } },
    //{ 0x814B000F,{ "SCE_EDIT_MP4_ERROR_FATAL",    "fatal error" } },
    //{ 0x814E0001,{ "SCE_CUSTOM_MUSIC_SERVICE_ERROR_FATAL",    "Fatal error" } },
    //{ 0x814E0002,{ "SCE_CUSTOM_MUSIC_SERVICE_ERROR_INVALID_ARGUMENT", "Invalid argument" } },
    //{ 0x814E0003,{ "SCE_CUSTOM_MUSIC_SERVICE_ERROR_NOT_INITIALIZED",  "CustomMusicService is not initialized." } },
    //{ 0x814E0004,{ "SCE_CUSTOM_MUSIC_SERVICE_ERROR_ALREADY_INITIALIZED",  "CustomMusicService is already initialized." } },
    //{ 0x814E0005,{ "SCE_CUSTOM_MUSIC_SERVICE_ERROR_BUSY", "Cannot execute because CustomMusicService is running another processing." } },
    //{ 0x814E0101,{ "SCE_CUSTOM_MUSIC_SERVICE_ERROR_PROHIBITED",   "Using CustomMusicService is prohibited." } },
    //{ 0x814F0001,{ "SCE_CL_SYS_CALL_WRAPPER_ERROR_INVALID_PARAM", "The parameters are invalid." } },
    //{ 0x814F0002,{ "SCE_CL_SYS_CALL_WRAPPER_ERROR_TOO_MANY",  "The number exceeded the maximum." } },
    //{ 0x81510100,{ "SCE_VDECSW_ERROR_API_FAIL",   "Failed to calling decoder API" } },
    //{ 0x81510101,{ "SCE_VDECSW_ERROR_STRUCT_SIZE",    "Invalid struct size specified in thisSize" } },
    //{ 0x81510102,{ "SCE_VDECSW_ERROR_ARGUMENT_POINTER",   "Argument pointer is invalid" } },
    //{ 0x81510103,{ "SCE_VDECSW_ERROR_DECODER_INSTANCE",   "Decoder instance is invalid" } },
    //{ 0x81510104,{ "SCE_VDECSW_ERROR_MEMORY_SIZE",    "Necessary memory size is insufficient" } },
    //{ 0x81510105,{ "SCE_VDECSW_ERROR_MEMORY_POINTER", "Invalid memory pointer" } },
    //{ 0x81510106,{ "SCE_VDECSW_ERROR_FRAME_BUFFER_SIZE",  "Invalid frame buffer size" } },
    //{ 0x81510107,{ "SCE_VDECSW_ERROR_FRAME_BUFFER_POINTER",   "Invalid pointer for frame buffer" } },
    //{ 0x81510108,{ "SCE_VDECSW_ERROR_FRAME_BUFFER_ALIGNMENT", "Invalid frame buffer alignment" } },
    //{ 0x81510109,{ "SCE_VDECSW_ERROR_NOT_ONION_MEMORY",   "Improper memory that must be WB Onion" } },
    //{ 0x8151010A,{ "SCE_VDECSW_ERROR_NOT_GARLIC_MEMORY",  "Improper memory that must be WC Garlic" } },
    //{ 0x8151010B,{ "SCE_VDECSW_ERROR_NOT_DIRECT_MEMORY",  "Improper memory that must be direct memory" } },
    //{ 0x8151010C,{ "SCE_VDECSW_ERROR_MEMORY_INFO",    "Error due to improper MemoryInfo setting" } },
    //{ 0x8151010D,{ "SCE_VDECSW_ERROR_ACCESS_UNIT_SIZE",   "Invalid access unit size" } },
    //{ 0x8151010E,{ "SCE_VDECSW_ERROR_ACCESS_UNIT_POINTER",    "Invalid pointer for access unit" } },
    //{ 0x8151010F,{ "SCE_VDECSW_ERROR_OUTPUT_INFO",    "Error due to improper OutputInfo setting" } },
    //{ 0x81510110,{ "SCE_VDECSW_ERROR_COMPUTE_QUEUE",  "Invalid computeQueue" } },
    //{ 0x81510111,{ "SCE_VDECSW_ERROR_FATAL_STATE",    "Decoder is fatal state needed to delete decoder" } },
    //{ 0x81510112,{ "SCE_VDECSW_ERROR_PRESET_VALUE",   "Invalid preset value" } },
    //{ 0x81510113,{ "SCE_VDECSW_ERROR_INPUT_QUEUE_FULL",   "Input queue full" } },
    //{ 0x81510114,{ "SCE_VDECSW_ERROR_OUTPUT_BUFFER_FULL", "Output buffer full" } },
    //{ 0x81510115,{ "SCE_VDECSW_ERROR_OUTPUT_PENDING", "Output process is still pending" } },
    //{ 0x81510116,{ "SCE_VDECSW_ERROR_INPUT_QUEUE_EMPTY",  "Input queue empty" } },
    //{ 0x81510117,{ "SCE_VDECSW_ERROR_DECODE_PENDING", "Decode process is still pending" } },
    //{ 0x81510118,{ "SCE_VDECSW_ERROR_OUTPUT_BUFFER_EMPTY",    "Output buffer empty" } },
    //{ 0x81510200,{ "SCE_VDECSW_ERROR_CONFIG_INFO",    "Error due to improper ConfigInfo setting" } },
    //{ 0x81510201,{ "SCE_VDECSW_ERROR_COMPUTE_PIPE_ID",    "Invalid computePipeId" } },
    //{ 0x81510202,{ "SCE_VDECSW_ERROR_COMPUTE_QUEUE_ID",   "Invalid computeQueueId" } },
    //{ 0x81510203,{ "SCE_VDECSW_ERROR_RESOURCE_TYPE",  "Invalid resourceType" } },
    //{ 0x81510204,{ "SCE_VDECSW_ERROR_CODEC_TYPE", "Invalid codecType" } },
    //{ 0x81510205,{ "SCE_VDECSW_ERROR_PROFILE_LEVEL",  "Invalid profile or level" } },
    //{ 0x81510206,{ "SCE_VDECSW_ERROR_PIPELINE_DEPTH", "Invalid decodePipelineDepth" } },
    //{ 0x81510207,{ "SCE_VDECSW_ERROR_AFFINITY_MASK",  "Invalid cpuAffinityMask" } },
    //{ 0x81510208,{ "SCE_VDECSW_ERROR_THREAD_PRIORITY",    "Invalid cpuThreadPriority" } },
    //{ 0x81510209,{ "SCE_VDECSW_ERROR_DPB_FRAME_COUNT",    "Invalid maxDpbFrameCount" } },
    //{ 0x8151020A,{ "SCE_VDECSW_ERROR_FRAME_WIDTH_HEIGHT", "Invalid maxFrameWidth or maxFrameHeight" } },
    //{ 0x8151020B,{ "SCE_VDECSW_ERROR_EXTRA_CONFIG_INFO",  "Invalid extraConfigInfo" } },
    //{ 0x81510300,{ "SCE_VDECSW_ERROR_NEW_SEQUENCE",   "New sequence that needs to reset decoder" } },
    //{ 0x81510301,{ "SCE_VDECSW_ERROR_ACCESS_UNIT",    "Decode error in an input access unit" } },
    //{ 0x81510302,{ "SCE_VDECSW_ERROR_OVERSIZE_DECODE",    "Decode process is too big for the current instance" } },
    //{ 0x81510303,{ "SCE_VDECSW_ERROR_INVALID_SEQUENCE",   "No valid sequence found in input stream" } },
    //{ 0x81510304,{ "SCE_VDECSW_ERROR_FATAL_STREAM",   "Fatal stream that needs to reset decoder" } },
    //{ 0x81540001,{ "SCE_BLUETOOTH_HID_ERROR_INVALID_PARAMETER",   "invalid argument" } },
    //{ 0x81540002,{ "SCE_BLUETOOTH_HID_ERROR_INVALID_VID_PID", "invalid vid/pid" } },
    //{ 0x81540003,{ "SCE_BLUETOOTH_HID_ERROR_DEVICE_NOT_REGISTERED",   "not registered the device" } },
    //{ 0x81540004,{ "SCE_BLUETOOTH_HID_ERROR_NOT_INITIALIZED", "library uninitialized" } },
    //{ 0x81540005,{ "SCE_BLUETOOTH_HID_ERROR_NOT_PAIRED",  "not paired the device" } },
    //{ 0x81540006,{ "SCE_BLUETOOTH_HID_ERROR_CALLBACK_NOT_REGISTERED", "unregistered call back function" } },
    //{ 0x81540007,{ "SCE_BLUETOOTH_HID_ERROR_NOT_CONNECTED",   "device is not connected" } },
    //{ 0x81540008,{ "SCE_BLUETOOTH_HID_ERROR_TRANSFER_BUSY",   "the transfer is busy" } },
    //{ 0x81540009,{ "SCE_BLUETOOTH_HID_ERROR_TOO_SHORT",   "the size is too short" } },
    //{ 0x8154000A,{ "SCE_BLUETOOTH_HID_ERROR_TRANSFER_NOT_READY",  "transfer not ready" } },
    //{ 0x8154000B,{ "SCE_BLUETOOTH_HID_ERROR_MISSING_REPORT_ID",   "missing report id" } },
    //{ 0x8154000C,{ "SCE_BLUETOOTH_HID_ERROR_TOO_BIG", "data size is too big" } },
    //{ 0x8154000D,{ "SCE_BLUETOOTH_HID_ERROR_DEVICE_NOT_ALLOCATED",    "not allocated the device" } },
    //{ 0x8154000E,{ "SCE_BLUETOOTH_HID_ERROR_CONNECTION_NOT_COMPLETED",    "Connection is not completed yet" } },
    //{ 0x8154000F,{ "SCE_BLUETOOTH_HID_ERROR_FATAL",   "fatal error" } },
    //{ 0x81570001,{ "SCE_VIDEO_DECODER_ARBITRATION_ERROR_INVALID_PARAM",   "invalid argument" } },
    //{ 0x81570002,{ "SCE_VIDEO_DECODER_ARBITRATION_ERROR_INVALID_STATUS",  "invalid status" } },
    //{ 0x81570003,{ "SCE_VIDEO_DECODER_ARBITRATION_ERROR_CONNECTION_FAILED",   "inter process communication error" } },
    //{ 0x81570004,{ "SCE_VIDEO_DECODER_ARBITRATION_ERROR_SCE_FUNCTION",    "sce function error" } },
    //{ 0x815700FF,{ "SCE_VIDEO_DECODER_ARBITRATION_ERROR_INTERNAL",    "internal program error" } },
    //{ 0x81580000,{ "SCE_JOB_ERROR_INVALID_VALUE", "The call failed because a parameter has an invalid value." } },
    //{ 0x81580001,{ "SCE_JOB_ERROR_INVALID_POINTER",   "The call failed because a parameter was an invalid pointer." } },
    //{ 0x81580002,{ "SCE_JOB_ERROR_OUT_OF_MEMORY", "The call failed because a memory allocation failed." } },
    //{ 0x81580003,{ "SCE_JOB_ERROR_BUSY",  "The call failed because internal resources was busy." } },
    //{ 0x81580004,{ "SCE_JOB_ERROR_AGAIN", "The call failed because internal resources was temporarily unavailable." } },
    //{ 0x81580005,{ "SCE_JOB_ERROR_TIMEOUT",   "The call failed because a operation timed out." } },
    //{ 0x81580006,{ "SCE_JOB_ERROR_OUT_OF_SEQUENCE_INTERFACES",    "The call failed because the maximum number of sequence interfaces have already been created." } },
    //{ 0x81580007,{ "SCE_JOB_ERROR_INVALID_SEQUENCE_INTERFACE",    "The call failed because an invalid sequence interface pointer was supplied." } },
    //{ 0x81581000,{ "SCE_JOB_MANAGER_ERROR_INVALID_VALUE", "The call failed because a parameter has an invalid value." } },
    //{ 0x81581001,{ "SCE_JOB_MANAGER_ERROR_INVALID_POINTER",   "The call failed because a parameter was an invalid pointer." } },
    //{ 0x81581002,{ "SCE_JOB_MANAGER_ERROR_OUT_OF_MEMORY", "The call failed because a memory allocation failed." } },
    //{ 0x81581010,{ "SCE_JOB_MANAGER_ERROR_UNINITIALIZED", "The call failed because the library is uninitialized." } },
    //{ 0x81581020,{ "SCE_JOB_MANAGER_ERROR_ALREADY_INITIALIZED",   "The call failed because the library is already initialized." } },
    //{ 0x81581030,{ "SCE_JOB_MANAGER_ERROR_INVALID_ALIGNMENT", "The call failed because a parameter is incorrectly aligned." } },
    //{ 0x8158F000,{ "SCE_JOB_MANAGER_TEST_ERROR_INVALID_VALUE",    "The call failed because a parameter has an invalid value." } },
    //{ 0x8158F002,{ "SCE_JOB_MANAGER_TEST_ERROR_OUT_OF_MEMORY",    "The call failed because a memory allocation failed." } },
    //{ 0x8158F010,{ "SCE_JOB_MANAGER_TEST_ERROR_UNINITIALIZED",    "The call failed because the library is uninitialized." } },
    //{ 0x8158F020,{ "SCE_JOB_MANAGER_TEST_ERROR_ALREADY_INITIALIZED",  "The call failed because the library is already initialized." } },
    //{ 0x815C0000,{ "SCE_MAT_ERROR_UNKNOWN",   "Undefined error" } },
    //{ 0x815C0001,{ "SCE_MAT_ERROR_COMMS_INIT",    "Failed to initialize communications" } },
    //{ 0x815C0002,{ "SCE_MAT_ERROR_THREAD_CREATE", "Failed to create libMat threads" } },
    //{ 0x815C0003,{ "SCE_MAT_ERROR_INVALID_ARGUMENT",  "Invalid argument passed" } },
    //{ 0x815E0001,{ "SCE_SUBDIV_ERROR_UNKNOWN",    "Unknown error" } },
    //{ 0x815E0002,{ "SCE_SUBDIV_ERROR_INVALID_NULL_INPUT", "Null parameter passed to function when non-null parameter is required" } },
    //{ 0x815E0003,{ "SCE_SUBDIV_ERROR_INVALID_VERTEX", "Vertex index does not refer to a valid vertex" } },
    //{ 0x815E0004,{ "SCE_SUBDIV_ERROR_INVALID_EDGE",   "Edge indices do not refer to a valid edge" } },
    //{ 0x815E0005,{ "SCE_SUBDIV_ERROR_INVALID_FACE",   "Face index does not refer to a valid face" } },
    //{ 0x815E0006,{ "SCE_SUBDIV_ERROR_INSUFFICIENT_MEMORY",    "Unable to allocate memory" } },
    //{ 0x815E0007,{ "SCE_SUBDIV_ERROR_END_CAP_CREATION",   "Error creating end-caps" } },
    //{ 0x815E0008,{ "SCE_SUBDIV_ERROR_COMPACT_TABLE_CREATION", "Error compacting stencil table" } },
    //{ 0x815E0009,{ "SCE_SUBDIV_ERROR_MISSING_EDGE_FACES", "Invalid topology (missing edge face indices)" } },
    //{ 0x815E000A,{ "SCE_SUBDIV_ERROR_MISSING_EDGE_VERTS", "Invalid topology (missing edge vertex indices)" } },
    //{ 0x815E000B,{ "SCE_SUBDIV_ERROR_MISSING_FACE_EDGES", "Invalid topology (missing face edge indices)" } },
    //{ 0x815E000C,{ "SCE_SUBDIV_ERROR_MISSING_FACE_VERTS", "Invalid topology (missing face vertex indices)" } },
    //{ 0x815E000D,{ "SCE_SUBDIV_ERROR_MISSING_VERT_FACES", "Invalid topology (missing vertex face indices)" } },
    //{ 0x815E000E,{ "SCE_SUBDIV_ERROR_MISSING_VERT_EDGES", "Invalid topology (missing vertex edge indices)" } },
    //{ 0x815E000F,{ "SCE_SUBDIV_ERROR_FAILED_CORRELATION_EDGE_FACE",   "Invalid topology (edge/face mismatch)" } },
    //{ 0x815E0010,{ "SCE_SUBDIV_ERROR_FAILED_CORRELATION_FACE_VERT",   "Invalid topology (face/vertex mismatch)" } },
    //{ 0x815E0011,{ "SCE_SUBDIV_ERROR_FAILED_CORRELATION_FACE_EDGE",   "Invalid topology (face/edge mismatch)" } },
    //{ 0x815E0012,{ "SCE_SUBDIV_ERROR_FAILED_ORIENTATION_INCIDENT_EDGE",   "Invalid topology (inconsistent edge orientation)" } },
    //{ 0x815E0013,{ "SCE_SUBDIV_ERROR_FAILED_ORIENTATION_INCIDENT_FACE",   "Invalid topology (inconsistent face orientation)" } },
    //{ 0x815E0014,{ "SCE_SUBDIV_ERROR_FAILED_ORIENTATION_INCIDENT_FACES_EDGES",    "Invalid topology (inconsistent face/edge orientation)" } },
    //{ 0x815E0015,{ "SCE_SUBDIV_ERROR_DEGENERATE_EDGE",    "Edge marked manifold is degenerate (start and end vertex is the same)" } },
    //{ 0x815E0016,{ "SCE_SUBDIV_ERROR_NON_MANIFOLD_EDGE",  "Edge marked manifold is actually non-manifold" } },
    //{ 0x815E0017,{ "SCE_SUBDIV_ERROR_INVALID_CREASE_EDGE",    "Invalid edge crease strength" } },
    //{ 0x815E0018,{ "SCE_SUBDIV_ERROR_INVALID_CREASE_VERT",    "Invalid vertex crease strength" } },
    //{ 0x815E0019,{ "SCE_SUBDIV_ERROR_NO_MAX_VALENCE", "Unable to determine maximum valence of mesh" } },
    //{ 0x815E001A,{ "SCE_SUBDIV_ERROR_INVALID_VALENCE",    "Vertex valence exceeds maximum supported valence" } },
    //{ 0x815E001B,{ "SCE_SUBDIV_ERROR_BASE_LEVEL_UNINITIALIZED",   "Topology not specified" } },
    //{ 0x815E001C,{ "SCE_SUBDIV_ERROR_INVALID_INPUT_TOPOLOGY", "Invalid input topology (missing faces/edges/vertices)" } },
    //{ 0x815E001D,{ "SCE_SUBDIV_ERROR_INVALID_TOPOLOGY_FOR_SCHEME",    "Subdivision scheme does not support specified topology" } },
    //{ 0x815E001E,{ "SCE_SUBDIV_ERROR_FACE_VARYING_CHANNEL_ORDER", "Face-varying channels out of order (face-varying index channels must be specified in order starting from 0)" } },
    //{ 0x815E001F,{ "SCE_SUBDIV_ERROR_INVALID_FACE_VARYING_CHANNEL",   "Indices for face-varying channel were not set" } },
    //{ 0x815E0020,{ "SCE_SUBDIV_ERROR_POSITION_ALREADY_SET",   "Position data already set" } },
    //{ 0x815E0021,{ "SCE_SUBDIV_ERROR_POSITION_NOT_SET",   "Position data needed but was not set" } },
    //{ 0x815E0022,{ "SCE_SUBDIV_ERROR_FACE_VARYING_INDEX_DATA_MISMATCH",   "Face-varying index points past the end of the face-varying data" } },
    //{ 0x815E0023,{ "SCE_SUBDIV_ERROR_INVALID_FACE_VARYING_COMPONENT_COUNT",   "Face-varying data does not have between 1 and 4 components" } },
    //{ 0x815E0024,{ "SCE_SUBDIV_ERROR_INVALID_OUTPUT_MASK",    "Output mask is empty or contains an invalid combination of flags" } },
    //{ 0x815E0025,{ "SCE_SUBDIV_ERROR_INVALID_SUBDIVISION_LEVEL",  "Subdivision level is not between 1 and 10" } },
    //{ 0x815E0026,{ "SCE_SUBDIV_ERROR_INVALID_VERSION_NUMBER", "Version not supported" } },
    //{ 0x815E0027,{ "SCE_SUBDIV_ERROR_INVALID_BINARY", "Binary not well-formed" } },
    //{ 0x815E0028,{ "SCE_SUBDIV_ERROR_SECTION_NOT_FOUND",  "Requested data does not exist within binary" } },
    //{ 0x82000001,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_1_ERROR_BAD_REQUEST", "Bad Request (JSON error code: 1)" } },
    //{ 0x82000002,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_2_ERROR_UNKNOWN_ERROR",   "Unknown Error (JSON error code: 2)" } },
    //{ 0x82000003,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_3_ERROR_TIMEOUT_ERROR",   "Timeout Error (JSON error code: 3)" } },
    //{ 0x82000004,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_4_ERROR_NO_DATA_FOUND",   "No Data Found (JSON error code: 4)" } },
    //{ 0x82000005,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_5_ERROR_SESSION_EXPIRED", "Session Expired (JSON error code: 5)" } },
    //{ 0x82000006,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_6_ERROR_VERSION_NOT_SUPPORTED",   "Version Not Supported (JSON error code: 6)" } },
    //{ 0x82000007,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_7_ERROR_ACCESS_PERMISSION_DENIED",    "Access Permission Denied (JSON error code: 7)" } },
    //{ 0x82000010,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_10_ERROR_CATEGORY_DOES_NOT_EXIST",    "No Such Category (JSON error code: 16)" } },
    //{ 0x82000011,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_11_ERROR_PRODUCT_DOES_NOT_EXIST", "No Such Product (JSON error code: 17)" } },
    //{ 0x82000012,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_12_ERROR_REQUIRES_PASSWORD",  "Requires Password (JSON error code: 18)" } },
    //{ 0x82000013,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_13_ERROR_NOT_ELIGIBLE",   "Not Eligible (JSON error code: 19)" } },
    //{ 0x82000014,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_14_ERROR_INVALID_LOGIN",  "Invalid Login (JSON error code: 20)" } },
    //{ 0x82000015,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_15_ERROR_CURRENCY_DOES_NOT_EXIST",    "No Such Currency (JSON error code: 21)" } },
    //{ 0x82000016,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_16_ERROR_NO_PAYMENT_INFO",    "No Payment Info (JSON error code: 22)" } },
    //{ 0x82000017,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_17_ERROR_CART_FULL",  "Cart Full (JSON error code: 23)" } },
    //{ 0x82000018,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_18_ERROR_INVALID_QUANTITY",   "Invalid Quantity (JSON error code: 24)" } },
    //{ 0x82000019,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_19_ERROR_ITEM_ALREADY_IN_CART",   "Item Already in Cart (JSON error code: 25)" } },
    //{ 0x8200001A,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_1A_ERROR_INVALID_SKU",    "Invalid SKU (JSON error code: 26)" } },
    //{ 0x8200001B,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_1B_ERROR_INACTIVE_ACCOUNT",   "Inactive Account (JSON error code: 27)" } },
    //{ 0x8200001C,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_1C_ERROR_SUSPENDED_ACCOUNT",  "Account banned or suspended (JSON error code: 28)" } },
    //{ 0x8200001D,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_1D_ERROR_SUSPENDED_CONSOLE",  "Console banned or suspended (JSON error code: 29)" } },
    //{ 0x8200001E,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_1E_ERROR_NO_SUCH_TITLE",  "No Such Title (JSON error code: 30)" } },
    //{ 0x8200001F,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_1F_ERROR_EXCEEDS_MAX_WALLET_PURCHASE",    "Exceeds Max Wallet Purchase (JSON error code: 31)" } },
    //{ 0x82000020,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_20_ERROR_OVER_SPENDING_LIMIT",    "Over Spending Limit (JSON error code: 32)" } },
    //{ 0x82000021,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_21_ERROR_AUTO_TOPUP_FAILED",  "Auto Topup Failed (JSON error code: 33)" } },
    //{ 0x82000022,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_22_ERROR_INSUFFICIENT_FUNDS", "Insufficient Funds (JSON error code: 34)" } },
    //{ 0x82000023,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_23_ERROR_CART_LOAD_FAILURE",  "Cart Load Failure (JSON error code: 35)" } },
    //{ 0x82000024,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_24_ERROR_PURCHASE_FAILED",    "Purchase Failed (JSON error code: 36)" } },
    //{ 0x82000025,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_25_ERROR_INVALID_PURCHASE",   "Invalid Purchase (JSON error code: 37)" } },
    //{ 0x82000026,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_26_ERROR_CART_EMPTY", "Cart Empty (JSON error code: 38)" } },
    //{ 0x82000027,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_27_ERROR_PAYMENT_ALREADY_EXIST",  "Payment Already Exist (JSON error code: 39)" } },
    //{ 0x82000028,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_28_ERROR_INVALID_CC_NUMBER",  "Invalid CreditCard Number (JSON error code: 40)" } },
    //{ 0x82000029,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_29_ERROR_INVALID_CC_SECURITY",    "Invalid CreditCard Security (JSON error code: 41)" } },
    //{ 0x8200002A,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_2A_ERROR_INVALID_CC_ADDRESS", "Invalid CreditCard Address (JSON error code: 42)" } },
    //{ 0x8200002B,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_2B_ERROR_INVALID_PAYMENT_ERROR",  "Invalid Payment Error (JSON error code: 43)" } },
    //{ 0x8200002C,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_2C_ERROR_EXPIRED_CC", "Expired CreditCard (JSON error code: 44)" } },
    //{ 0x8200002D,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_2D_ERROR_ACTION_NOT_ALLOWED", "Temporary Error (Action not allowed) (JSON error code: 45)" } },
    //{ 0x8200002E,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_2E_ERROR_NO_WALLET_INFO", "No Wallet Info (JSON error code: 46)" } },
    //{ 0x8200002F,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_2F_ERROR_INVALID_VOUCHER",    "Invalid Voucher (JSON error code: 47)" } },
    //{ 0x82000030,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_30_ERROR_VOUCHER_ALREADY_CONSUMED",   "Voucher Already Consumed (JSON error code: 48)" } },
    //{ 0x82000031,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_31_ERROR_VOUCHER_TRANSACTION_OVER_LIMIT", "Voucher Transaction Over Limit (JSON error code: 49)" } },
    //{ 0x82000032,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_32_ERROR_FAILED_AGE_REQUIREMENT", "Failed Age Requirement (JSON error code: 50)" } },
    //{ 0x82000033,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_33_ERROR_VOUCHER_EXPIRED",    "Voucher Expired (JSON error code: 51)" } },
    //{ 0x82000034,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_34_ERROR_VOUCHER_SKU_REGION_MISMATCH",    "Voucher Sku Region Mismatch (JSON error code: 52)" } },
    //{ 0x82000035,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_35_ERROR_VOUCHER_SKU_PRICE_NOT_FOUND",    "Voucher SKU Price Not Found (JSON error code: 53)" } },
    //{ 0x82000036,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_36_ERROR_DEPOSIT_IN_PROGRESS_ERROR",  "Deposit In Progress Error (JSON error code: 54)" } },
    //{ 0x82000037,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_37_ERROR_EDY_TRANSACTION_FAILED", "Edy Transaction Failed (JSON error code: 55)" } },
    //{ 0x82000038,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_38_ERROR_DDEPOSIT_FAILED",    "Deposit Failed (JSON error code: 56)" } },
    //{ 0x82000039,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_39_ERROR_EXCEEDS_AGE_LIMIT_IN_BROWSING",  "Exceeds Age Limit In Browsing (JSON error code: 57)" } },
    //{ 0x8200003D,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_3D_ERROR_COUPON_ALREADY_CONSUMED",    "Coupon Already Consumed (JSON error code: 61)" } },
    //{ 0x8200003E,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_3E_ERROR_COUPON_EXHAUSTED",   "Coupon Exhausted (JSON error code: 62)" } },
    //{ 0x8200003F,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_3F_ERROR_CVV_VERIFICATION_REQUIRED",  "CVV Verification Required (JSON error code: 63)" } },
    //{ 0x82000040,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_40_ERROR_INVALID_EULA_VERSION",   "invalid eula version (JSON error code: 64)" } },
    //{ 0x82000041,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_41_ERROR_INVALID_ADDRESS",    "invalid address (JSON error code: 65)" } },
    //{ 0x82000042,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_42_ERROR_INVALID_PASSWORD",   "invalid password (JSON error code: 66)" } },
    //{ 0x82000043,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_43_ERROR_SAME_LOGIN_ID",  "same loginid (JSON error code: 67)" } },
    //{ 0x82000044,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_44_ERROR_LOGIN_ID_EXISTS",    "loginid exists (JSON error code: 68)" } },
    //{ 0x82000045,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_45_ERROR_INVALID_SUB_ACCOUNT",    "invalid sub account (JSON error code: 69)" } },
    //{ 0x82000046,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_46_ERROR_INVALID_BIRTH_DATE", "invalid birth date (JSON error code: 70)" } },
    //{ 0x82000047,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_47_ERROR_INVALID_COUNTRY",    "invalid country (JSON error code: 71)" } },
    //{ 0x82000048,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_48_ERROR_ONLINE_ID_EXISTS",   "onlineid exists (JSON error code: 72)" } },
    //{ 0x82000049,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_49_ERROR_INVALID_ONLINE_ID",  "invalid onlineid (JSON error code: 73)" } },
    //{ 0x8200004A,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_4A_ERROR_CORRUPTED_DATA", "corrupted data (JSON error code: 74)" } },
    //{ 0x8200004B,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_4B_ERROR_TOO_MANY_SUBACCOUNTS",   "too many sub accounts (JSON error code: 75)" } },
    //{ 0x8200004C,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_4C_ERROR_CONSOLE_REG_EXCEEDED",   "console reg exceeded (JSON error code: 76)" } },
    //{ 0x8200004D,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_4D_ERROR_ACCOUNT_BINDING_DISABLED",   "account binding disabled (JSON error code: 77)" } },
    //{ 0x8200004E,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_4E_ERROR_INVALID_KOREAN_RRN", "Invalid Korean RRN (JSON error code: 78)" } },
    //{ 0x8200004F,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_4F_ERROR_INVALID_LOGIN_DOB",  "invalid login or Dob (JSON error code: 79)" } },
    //{ 0x82000050,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_50_ERROR_INVALID_SECURITY_ANSWER",    "invalid security answer (JSON error code: 80)" } },
    //{ 0x82000051,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_51_ERROR_INVALID_PARENT", "invalid parent (JSON error code: 81)" } },
    //{ 0x82000052,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_52_ERROR_INCORRECT_REGION",   "incorrect region (JSON error code: 82)" } },
    //{ 0x82000053,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_53_ERROR_CHILD_NOT_ALLOWED",  "child not allowed (JSON error code: 83)" } },
    //{ 0x82000054,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_54_ERROR_INVALID_CONSOLE_ID", "invalid console id (JSON error code: 84)" } },
    //{ 0x82000055,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_55_ERROR_CC_VERIFICATION_REQUIRED",   "credit card verification required (JSON error code: 85)" } },
    //{ 0x82000056,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_56_ERROR_RATE_LIMIT_EXCEEDED",    "Rate limit exceeded (JSON error code: 86)" } },
    //{ 0x82000057,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_57_ERROR_NO_ACTIVE_REWARD",   "no active reward (JSON error code: 87)" } },
    //{ 0x82000058,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_58_ERROR_UPGRADE_REQUIRED",   "upgrade required (JSON error code: 88)" } },
    //{ 0x82000059,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_59_ERROR_SUBACC_NEEDS_UPGRADE",   "subaccount need to be upgraded (JSON error code: 89)" } },
    //{ 0x8200005A,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_5A_ERROR_NO_OF_CC_LIMIT_EXCEEDED",    "Exceeded the max number of accounts this credit card can be registered with? (JSON error code: 90)" } },
    //{ 0x8200005B,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_5B_ERROR_REQUIRE_CC_REACTIVATION",    "credit card re-verification required (JSON error code: 91)" } },
    //{ 0x8200005C,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_5C_ERROR_INVALID_DOMAIN", "Invalid domain provided (JSON error code: 92)" } },
    //{ 0x8200005D,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_5D_ERROR_CONTENT_FILEID_NOT_FOUND",   "No content/file ID Found (GetProductIds) (JSON error code: 93)" } },
    //{ 0x8200005E,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_5E_ERROR_UNIFIED_ID_ACC_NEEDS_IMPORT",    "Unified ID account needs import (JSON error code: 94)" } },
    //{ 0x8200005F,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_5F_ERROR_AUTO_DEPOSIT_FLAG_REQUIRED", "auto deposit flag required (JSON error code: 95)" } },
    //{ 0x82000060,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_60_ERROR_INVALID_TICKET", "invalid ticket (JSON error code: 96)" } },
    //{ 0x82000061,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_61_ERROR_EXPIRED_TICKET", "expired ticket (JSON error code: 97)" } },
    //{ 0x82000062,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_62_ERROR_CC_REQUIRED",    "credit card required (JSON error code: 98)" } },
    //{ 0x82000063,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_63_ERROR_ADDL_ATTRIBUTES_REQUIRED_FOR_TAX_CALC",  "Additional Attribute Required for Tax Calculations (JSON error code: 99)" } },
    //{ 0x82000064,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_64_ERROR_PWD_EXPIRED",    "Password expired (JSON error code: 100)" } },
    //{ 0x82000065,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_65_ERROR_REDIRECT_TO_PC", "redirect to PC (JSON error code: 101)" } },
    //{ 0x82000066,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_66_ERROR_ORDER_ITEM_CHARGE_ALREADY_PROCESSED",    "order item charge already processed  (JSON error code: 102)" } },
    //{ 0x82000067,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_67_ERROR_MUST_REACCEPT_EULA", "must re-accept EULA (JSON error code: 103)" } },
    //{ 0x82000068,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_68_ERROR_INVALID_USE_COUNT",  "Invalid use count (JSON error code: 104)" } },
    //{ 0x82000069,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_69_ERROR_ENTITLEMENT_EXPIRED",    "Entitlement expire (JSON error code: 105)" } },
    //{ 0x8200006A,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_6A_ERROR_COUPON_CODE_WRONG_COUNTRY",  "Coupon Code Wrong Country (JSON error code: 106)" } },
    //{ 0x8200006B,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_6B_ERROR_COUPON_EXPIRED", "Coupon Expired (JSON error code: 107)" } },
    //{ 0x8200006C,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_6C_ERROR_COUPON_INVALID_FOR_PRODUCT", "Coupon invalid for product (JSON error code: 108)" } },
    //{ 0x8200006D,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_6D_ERROR_COUPON_INVALID_FOR_PLATFORM",    "Coupon invalid for platform (JSON error code: 109)" } },
    //{ 0x82000070,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_70_ERROR_INVALID_ESN",    "Invalid ESN (JSON error code: 112)" } },
    //{ 0x82000071,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_71_ERROR_FRAUD_ERROR_INVALID_CC", "Fraud Error Invalid Credit Card (JSON error code: 113)" } },
    //{ 0x82000072,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_72_ERROR_EMAIL_VERIFICATION_REQUIRED",    "OK, email verification required (JSON error code: 114)" } },
    //{ 0x82000073,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_73_ERROR_EMAIL_ALREADY_VERIFIED", "Email already verified (JSON error code: 115)" } },
    //{ 0x82000074,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_74_ERROR_INVALID_USER_LOCALE",    "Invalid user locale (JSON error code: 116)" } },
    //{ 0x82000075,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_75_ERROR_INVALID_EMAIL",  "Invalid email provided (JSON error code: 117)" } },
    //{ 0x82000076,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_76_ERROR_INVALID_AFFILIATION_TOKEN",  "Invalid/Incorrect affiliation token (JSON error code: 118)" } },
    //{ 0x82000077,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_77_ERROR_REG_CODE_FAILED",    "Registration code fail (JSON error code: 119)" } },
    //{ 0x82000078,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_78_ERROR_ACCOUNT_VERIFICATION_FAILED",    "Account verification fail (JSON error code: 120)" } },
    //{ 0x82000079,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_79_ERROR_MAILSERVICE_FAILED", "Mailservice fail (JSON error code: 121)" } },
    //{ 0x8200007A,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_7A_ERROR_IMMEDIATE_CHARGE_REQUIRED",  "Immediate Charge Required (JSON error code: 122)" } },
    //{ 0x8200007B,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_7B_ERROR_COUPON_MIN_SPENDING_NOT_MET",    "Coupon Minimum Spend Not Met (JSON error code: 123)" } },
    //{ 0x8200007C,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_7C_ERROR_INVALID_LANGUAGE",   "Invalid Language (JSON error code: 124)" } },
    //{ 0x8200007D,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_7D_ERROR_SERVICE_NOT_AVAILABLE_IN_REGION",    "Service Not Available In Region (JSON error code: 125)" } },
    //{ 0x8200007E,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_7E_ERROR_INVALID_COUPON_CODE",    "Invalid Coupon Code (JSON error code: 126)" } },
    //{ 0x8200007F,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_7F_ERROR_MULTIPLE_COUPONS_NOT_ALLOWED",   "Multiple Coupons Not Allowed (JSON error code: 127)" } },
    //{ 0x82000080,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_80_ERROR_NO_PAYMENT_INSTRUMENT_ON_FILE",  "No payment instrument on file (JSON error code: 128)" } },
    //{ 0x82000102,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_102_ERROR_102_UNKNOWN_ERROR", "Unknown Error (JSON error code: 258)" } },
    //{ 0x82000103,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_103_ERROR_103_TIMEOUT",   "Timeout Error.?Web application's communication with backend timed out (JSON error code: 259)" } },
    //{ 0x82000105,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_105_ERROR_104_SESSION_EXPIRED",   "Session Expired (JSON error code: 261)" } },
    //{ 0x82000107,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_107_ERROR_107_PERMISSION_DENIED", "Permission Denied???? (JSON error code: 263)" } },
    //{ 0x82000112,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_112_ERROR_PASSWORD_REQUIRED", "Requires Password???? (JSON error code: 274)" } },
    //{ 0x82000113,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_113_ERROR_AGAINST_ELIGIBILITY_RULE",  "Against Eligibility Rule (JSON error code: 275)" } },
    //{ 0x82000114,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_114_ERROR_INVALID_LOGIN", "Invalid Login (JSON error code: 276)" } },
    //{ 0x82000119,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_119_ERROR_ITEM_ALREADY_IN_CART",  "Item already in cart (JSON error code: 281)" } },
    //{ 0x8200011A,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_11A_ERROR_INVALID_SKU",   "Invalid SKU (JSON error code: 282)" } },
    //{ 0x8200011B,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_11B_ERROR_INACTIVE_ACCOUNT",  "Cart Load Failure or Account is not active (JSON error code: 283)" } },
    //{ 0x8200011F,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_11F_ERROR_EXCEEDED_MAS_WALLET_PURCHASE",  "Exceeds Max Wallet Purchase?? (JSON error code: 287)" } },
    //{ 0x82000120,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_120_ERROR_OVER_SPENDING_LIMIT",   "Over Spending Limit. Cart total is greater than account's spending limit (JSON error code: 288)" } },
    //{ 0x82000121,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_121_ERROR_AUTO_TOP_UP_FAILED",    "Auto Topup (quick purchase) failed (JSON error code: 289)" } },
    //{ 0x82000122,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_122_ERROR_INSUFFICIENT_FUNDS",    "Insufficient Funds (JSON error code: 290)" } },
    //{ 0x82000125,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_125_ERROR_INVALID_PURCHASE",  "Invalid Purchase. SKU eligibility violation at purchase time (JSON error code: 293)" } },
    //{ 0x82000126,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_126_ERROR_CART_EMPTY",    "Cart Empty (JSON error code: 294)" } },
    //{ 0x8200012F,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_12F_ERROR_INVALID_VOUCHER_CODE",  "Invalid Voucher Code (JSON error code: 303)" } },
    //{ 0x82000130,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_130_ERROR_VOUCHER_ALREADY_CONSUMED",  "Voucher consumed Voucher max consumption has already been reached (JSON error code: 304)" } },
    //{ 0x82000131,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_131_ERROR_VOUCHER_TRANSACTION_OVER_LIMIT",    "Voucher Transaction Over Limit. Money Voucher exceeds transaction limit (JSON error code: 305)" } },
    //{ 0x82000132,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_132_ERROR_FAILED_AGE_REQUIREMENT",    "Failed Age Requirement (JSON error code: 306)" } },
    //{ 0x82000133,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_133_ERROR_VOUCHER_EXPIRED",   "Voucher ia expired (JSON error code: 307)" } },
    //{ 0x82000134,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_134_ERROR_VOUCHER_SKU_REGION_MISMATCH",   "Voucher Sku Region Mismatch. Product Voucher region does match the Account's region (JSON error code: 308)" } },
    //{ 0x82000138,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_138_ERROR_DEPOSIT_FAILED",    "Deposit Failed (JSON error code: 312)" } },
    //{ 0x82000156,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_156_ERROR_RATE_LIMIT_EXCEEDED",   "Rate limit exceeded (JSON error code: 342)" } },
    //{ 0x82000157,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_157_ERROR_NO_ACTIVE_REWARD",  "No Active Reward (JSON error code: 343)" } },
    //{ 0x8200015F,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_15F_ERROR_AUTO_DEPOSIT_FLAG_REQUIRED",    "Auto deposit flag required (JSON error code: 351)" } },
    //{ 0x82000162,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_162_ERROR_CREDIT_CARD_REQUIRED",  "Credit card required for purchase (JSON error code: 354)" } },
    //{ 0x82000171,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_171_ERROR_FRAUD_ERROR_INVALID_CREDIT_CARD",   "Fraud Error. Invalid Credit Card (JSON error code: 369)" } },
    //{ 0x820001F7,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_1F7_ERROR_HTTP_STATUS_CODE_503",  "Got HTTP response 503 (JSON error code: 503)" } },
    //{ 0x82000302,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_302_ERROR_UNKNOWN_ERROR_RDST",    "Unknown Error. Unexpected error from Roadster server. (JSON error code: 770)" } },
    //{ 0x82000304,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_KMJ_SERVER_304_ERROR_PROFILE_NOT_FOUND_RDST",    "Profile not found. User does not have a community profile. (JSON error code: 772)" } },
    //{ 0x82020000,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_SERVICE_ENDED", "Service ended" } },
    //{ 0x82020001,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_BAD_REQUEST",   "Bad Request (JSON error code: 1)" } },
    //{ 0x82020002,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_UNKNOWN_ERROR", "Unknown error (JSON error code: 2)" } },
    //{ 0x82020004,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_NO_DATA_FOUND", "No data found (JSON error code: 4)" } },
    //{ 0x82020005,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_UNKNOWN_RESOURCE",  "Unknown resource (JSON error code: 5)" } },
    //{ 0x82020012,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_FW_UPGRADE_REQ",    "Firmware upgrade required (JSON error code: 18)" } },
    //{ 0x82020014,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_INVALID_LOGIN", "Invalid Login (JSON error code: 20)" } },
    //{ 0x8202001B,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_INACTIVE_ACCOUNT",  "Inactive Account (JSON error code: 27)" } },
    //{ 0x8202001C,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_SUSPENDED_ACCOUNT", "Suspended Account (JSON error code: 28)" } },
    //{ 0x8202001D,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_SUSPENDED_DEVICE",  "Suspended Device (JSON error code: 29)" } },
    //{ 0x82020032,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_FAILED_AGE_REQD",   "Failed Age Requirement (JSON error code: 50)" } },
    //{ 0x82020033,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_EMAIL_VERIFICATION_REQD",   "Email verification required (JSON error code: 51)" } },
    //{ 0x82020040,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_WRONG_TOSUA_VERSION",   "Wrong tosua version presented (JSON error code: 64)" } },
    //{ 0x82020042,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_INSECURE_PWD",  "Insecure password (JSON error code: 66)" } },
    //{ 0x82020046,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_INVALID_BIRTHDATE", "Invalid birth date (JSON error code: 70)" } },
    //{ 0x82020047,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_INVALID_COUNTRY",   "Invalid Country (JSON error code: 71)" } },
    //{ 0x82020053,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_UNDER_AGE_ACC", "Under age account (JSON error code: 83)" } },
    //{ 0x82020054,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_INVALID_DEVICEID",  "Invalid Device ID (JSON error code: 84)" } },
    //{ 0x82020064,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_PWD_EXPIRED",   "Password expired (JSON error code: 100)" } },
    //{ 0x82020067,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_TOSUA_BE_REACCEPTED",   "ToSUA must be re-accepted (JSON error code: 103)" } },
    //{ 0x82020FFF,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_PARAMETER_X_DUP",   "Parameter \"X\" is duplicated (JSON error code: 4095)" } },
    //{ 0x82021000,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_SKU_NOT_AVAILABLE", "SKU Not Available (JSON error code: 4096)" } },
    //{ 0x82021001,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_INVALID_TOKEN", "Invalid token (JSON error code: 4097)" } },
    //{ 0x82021002,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_MANDATORY_PARAM_MISSING",   "Mandatory parameter 'XXXXXX' is missing (JSON error code: 4098)" } },
    //{ 0x82021003,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_PARAM_MALFORMED",   "Parameter ‘XXXXXX' is malformed (JSON error code: 4099)" } },
    //{ 0x82021004,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_ACCOUNT_NOT_FOUND", "Account could not be found (JSON error code: 4100)" } },
    //{ 0x82021005,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_DEVICE_NOT_FOUND",  "Device could not be found (JSON error code: 4101)" } },
    //{ 0x82021006,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_INVALID_CREDENTIALS",   "Invalid client credentials (JSON error code: 4102)" } },
    //{ 0x82021007,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_INVALID_SERVICE_ENTITY",    "Invalid Service Entity (JSON error code: 4103)" } },
    //{ 0x82021008,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_MAX_DEVICES_EXCEEDED",  "Maximum number of devices for this device exceeded (JSON error code: 4104)" } },
    //{ 0x82021009,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_MAX_ACC_EXCEEDED",  "Maximum number of accounts for this account exceeded (JSON error code: 4105)" } },
    //{ 0x8202100A,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_PAYMENT_INSTRUMENT_FAILED", "Payment instrument validation failed (JSON error code: 4106)" } },
    //{ 0x8202100B,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_PSN_HANDLE_IN_USE", "Specified Online ID is already in use (JSON error code: 4107)" } },
    //{ 0x8202100C,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_LOGIN_IN_USE",  "Specified Sign-in ID is already in use (JSON error code: 4108)" } },
    //{ 0x8202100D,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_COUNTRY_DIFF_ON_SUB_MASTER_ACC",    "Country specified for sub-account is different from country on the specified master account (JSON error code: 4109)" } },
    //{ 0x8202100E,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_REACHED_MAX_SUB_ACC",   "Master account has reached maximum number of allowed sub-accounts (JSON error code: 4110)" } },
    //{ 0x8202100F,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_DEVICE_NOT_SUPPORTED",  "This device is not supported in this country (JSON error code: 4111)" } },
    //{ 0x82021010,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_LANGUAGE_NOT_AVAILABLE",    "Language is not available in country (JSON error code: 4112)" } },
    //{ 0x82021011,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_INVALID_COUNTRY_ID",    "Invalid Country ID (JSON error code: 4113)" } },
    //{ 0x82021012,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_CLIENT_MISSING_SCOPE",  "Client does not have any of the scope(s): [\"XXX\"] (JSON error code: 4114)" } },
    //{ 0x82021013,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_INACTIVE_PRODUCT",  "Product not active (JSON error code: 4115)" } },
    //{ 0x82021014,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_PAYMENT_CHARGE_FAILED", "Payment instrument charge failed (JSON error code: 4116)" } },
    //{ 0x82021015,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_PAYMENT_INSTRUMENT_EXPIRED",    "Payment instrument expired (JSON error code: 4117)" } },
    //{ 0x82021016,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_EXCEEDS_SPENDING_LIMIT",    "Exceeds spending limit (JSON error code: 4118)" } },
    //{ 0x82021017,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_EXCEEDS_WALLET_BALANCE",    "Exceeds wallet balance (JSON error code: 4119)" } },
    //{ 0x82021018,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_ALREADY_SUBSCRIBED",    "Already subscribed (JSON error code: 4120)" } },
    //{ 0x82021019,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_NOT_SUBSCRIBABLE",  "Not subscribable (JSON error code: 4121)" } },
    //{ 0x8202101A,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_UNKNOWN_DEVICE_TYPE",   "Unknown device type (JSON error code: 4122)" } },
    //{ 0x8202101B,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_MIN_CHARGE_NOT_MET",    "Minimum charge amount not met (JSON error code: 4123)" } },
    //{ 0x8202101C,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_EXCEEDS_MAX_PURCHASE",  "Exceeds maximum wallet purchase (JSON error code: 4124)" } },
    //{ 0x8202101D,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_INSUFFICIENT_FUNDS",    "Insufficient funds in wallet (JSON error code: 4125)" } },
    //{ 0x8202101E,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_COUNTRY_NOT_FOUND_ESN", "Country not found for ESN (JSON error code: 4126)" } },
    //{ 0x8202101F,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_COUNTRY_NOT_SUPPORTED", "Unsupported country (JSON error code: 4127)" } },
    //{ 0x82021020,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_INVALID_ESN",   "Invalid ESN (JSON error code: 4128)" } },
    //{ 0x82021021,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_ESN_NOT_IN_DB", "ESN not found in DB (JSON error code: 4129)" } },
    //{ 0x82021022,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_QUERY_PARAMS_NOT_ALLOWED",  "Query parameters not allowed for POST (JSON error code: 4130)" } },
    //{ 0x82021023,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_CART_EMPTY",    "Cart empty (JSON error code: 4131)" } },
    //{ 0x82021024,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_MALFORMED_BODY",    "Malformed body (JSON error code: 4132)" } },
    //{ 0x82021025,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_EXTN_CONTENTTYPE_MISMATCH", "Extension does not match Content Type (JSON error code: 4133)" } },
    //{ 0x82021026,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_DEVICE_ALREADY_ADDED",  "Device already added (JSON error code: 4134)" } },
    //{ 0x82021027,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_MANDATORY_ACC_ATTRIBUTES_MISSING",  "Missing mandatory account attributes (JSON error code: 4135)" } },
    //{ 0x82021028,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_INVALID_DEVICE_NAME",   "Invalid device name (JSON error code: 4136)" } },
    //{ 0x82021029,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_RESERVATION_NOT_FOUND", "Reservation was not found (JSON error code: 4137)" } },
    //{ 0x8202102A,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_IMPROPER_ONLINE_ID",    "Improper Online ID (JSON error code: 4138)" } },
    //{ 0x8202102B,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_PARAM_CANNOT_BE_UPDATED",   "Parameter cannot be updated (JSON error code: 4139)" } },
    //{ 0x8202102C,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_PROVINCE_ID_NOT_FOUND", "Province ID could not be found (JSON error code: 4140)" } },
    //{ 0x8202102D,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_CC_ID_NOT_FOUND",   "Credit card ID could not be found (JSON error code: 4141)" } },
    //{ 0x8202102E,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_TRANSACTION_ID_NOT_FOUND",  "Transaction ID could not be found (JSON error code: 4142)" } },
    //{ 0x8202102F,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_STORE_ID_NOT_FOUND",    "Store ID could not be found (JSON error code: 4143)" } },
    //{ 0x82021030,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_ADDRESS_ID_NOT_FOUND",  "Address ID could not be found (JSON error code: 4144)" } },
    //{ 0x82021031,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_SKU_CANNOT_BE_ENTITLED",    "SKU cannot be entitled (JSON error code: 4145)" } },
    //{ 0x82021032,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_SKU_ALREADY_IN_CART",   "SKU is already in cart (JSON error code: 4146)" } },
    //{ 0x82021033,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_RESOURCE_ID_NOT_FOUND", "<resource> ID could not be found (JSON error code: 4147)" } },
    //{ 0x82021034,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_PARAM_VALUE_NOT_SUPPORTED", "Given value for parameter '<p>' is not supported (JSON error code: 4148)" } },
    //{ 0x82021035,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_CC_ALREADY_EXISTS", "Credit card already exists (JSON error code: 4149)" } },
    //{ 0x82021036,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_INVALID_REQUEST",   "Invalid request (JSON error code: 4150)" } },
    //{ 0x82021037,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_NO_GRANT_TYPE", "Client does not have grant type: [\"XXX\"] (JSON error code: 4151)" } },
    //{ 0x82021038,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_GRANT_TYPE_NOT_SUPPORTED",  "Unsupported grant type (JSON error code: 4152)" } },
    //{ 0x82021039,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_INVALID_SCOPE", "Invalid scope (JSON error code: 4153)" } },
    //{ 0x8202103A,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_INVALID_CONSOLE_TOKEN", "Invalid console token (JSON error code: 4154)" } },
    //{ 0x8202103B,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_TOKEN_NOT_FOUND",   "Token not found (JSON error code: 4155)" } },
    //{ 0x8202103F,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_INVALID_REFRESH_TOKEN", "Invalid refresh token (JSON error code: 4159)" } },
    //{ 0x82021041,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_CLIENT_NOT_FOUND_401",  "Client not found (JSON error code: 4161)" } },
    //{ 0x82021042,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_REACCEPT_TOSUA_FOR_SUBACC", "ToSUA must be re-accepted for sub account (JSON error code: 4162)" } },
    //{ 0x82021043,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_CLIENT_ALREADY_EXISTS", "Client already exists (JSON error code: 4163)" } },
    //{ 0x82021044,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_CLIENT_NOT_FOUND_404",  "Client not found (JSON error code: 4164)" } },
    //{ 0x82021045,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_USER_NOT_AUTHENTICATED",    "User is not authenticated (JSON error code: 4165)" } },
    //{ 0x82021046,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_SCOPE_NOT_FOUND",   "Scope was not found (JSON error code: 4166)" } },
    //{ 0x82021049,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_QUERY_EXECUTION_FAIL",  "Dynamic query execution fail (JSON error code: 4169)" } },
    //{ 0x8202104A,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_ACCESS_DENIED", "Access denied (JSON error code: 4170)" } },
    //{ 0x8202104B,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_TOKEN_EXPIRED", "Token is expired (JSON error code: 4171)" } },
    //{ 0x8202104C,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_TOKEN_INVALID", "Token is invalid (JSON error code: 4172)" } },
    //{ 0x8202104D,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_INVALID_CLIENT",    "Invalid client (JSON error code: 4173)" } },
    //{ 0x8202104E,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_REDIRECT_URI_MISMATCH", "Redirect URI mismatch (JSON error code: 4174)" } },
    //{ 0x8202104F,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_METHOD_NOT_ALLOWED",    "Method not allowed (JSON error code: 4175)" } },
    //{ 0x82021050,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_BANNED_ACCOUNT",    "Banned account (JSON error code: 4176)" } },
    //{ 0x82021051,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_ADDRESS_VERIFICATION",  "Address verification error (JSON error code: 4177)" } },
    //{ 0x82021052,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_RATE_LIMIT_EXCEEDED",   "Rate limit exceeded (JSON error code: 4178)" } },
    //{ 0x82021053,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_CC_EXPIRED",    "Credit card expired (JSON error code: 4179)" } },
    //{ 0x82021054,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_CC_INVALID",    "Invalid credit card (JSON error code: 4180)" } },
    //{ 0x82021055,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_BACKEND_TIMEOUT",   "Back-end timeout (JSON error code: 4181)" } },
    //{ 0x82021056,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_NOT_MASTER_ACC",    "Not a master account (JSON error code: 4182)" } },
    //{ 0x82021057,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_ACTIVATION_TYPE_UNSUPPORTED",   "Activation type '<activation>' is not supported for the '<device_type>'  (JSON error code: 4183)" } },
    //{ 0x82021058,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_INACTIVE_VOUCHER",  "Voucher is inactive (JSON error code: 4184)" } },
    //{ 0x82021059,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_VOUCHER_NOT_CONSUMABLE",    "Voucher is not consumable (JSON error code: 4185)" } },
    //{ 0x8202105A,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_VOUCHER_COUNTRY_MISMATCH",  "Voucher country mismatch (JSON error code: 4186)" } },
    //{ 0x8202105B,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_PURCHASE_RESULT_UNKNOWN",   "Purchase result unknown (JSON error code: 4187)" } },
    //{ 0x8202105C,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_VOUCHER_TRANSACTION_OVER_LIMIT",    "Voucher transaction over limit (JSON error code: 4188)" } },
    //{ 0x8202105D,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_INVALID_VOUCHER",   "Invalid voucher (JSON error code: 4189)" } },
    //{ 0x8202105E,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_VOUCHER_ALREADY_CONSUMED",  "Voucher is already consumed (JSON error code: 4190)" } },
    //{ 0x8202105F,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_VOUCHER_EXPIRED",   "Voucher expired (JSON error code: 4191)" } },
    //{ 0x82021060,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_UNEXPECTED_PARAM",  "Unexpected parameter '%s' (JSON error code: 4192)" } },
    //{ 0x82021061,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_INACTIVE_SKU",  "Inactive SKU (JSON error code: 4193)" } },
    //{ 0x82021062,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_DEVICE_NOT_ACTIVATED",  "Device is not activated for this account (JSON error code: 4194)" } },
    //{ 0x82021063,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_VOUCHER_START_DAY_IN_FUTURE",   "Voucher start day in the future (JSON error code: 4195)" } },
    //{ 0x82021064,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_VOUNCHER_AGE_UNAPPROVED",   "Voucher age not approved (JSON error code: 4196)" } },
    //{ 0x82021065,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_TAX_INFO_REQD", "Tax info required (JSON error code: 4197)" } },
    //{ 0x82021066,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_VOUCHER_SKU_REGION_MISMATCH",   "Voucher SKU region mismatch (JSON error code: 4198)" } },
    //{ 0x82021067,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_INVALID_SKU",   "Invalid SKU (JSON error code: 4199)" } },
    //{ 0x82021068,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_MINFIRMWAREVERSION_NOT_FOUND",  "The minFirmwareVersion was not found (JSON error code: 4200)" } },
    //{ 0x82021069,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_INVALID_DEVICE_TYPE",   "Invalid device type (JSON error code: 4201)" } },
    //{ 0x8202106B,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_MAX_CC_REGISTRATION",   "Max credit card registrations reached (JSON error code: 4203)" } },
    //{ 0x82021071,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_BACKEND_ERROR", "Backend error (JSON error code: 4209)" } },
    //{ 0x82021072,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_PARAM_EXPIRED", "'X' expired (JSON error code: 4210)" } },
    //{ 0x82021073,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_GCIM_ACCOUNT",  "GCIM only account (JSON error code: 4211)" } },
    //{ 0x82021074,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_VOUCHER_CONSUMPTION_FAILED",    "Voucher consumption failed (JSON error code: 4212)" } },
    //{ 0x82021075,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_NOT_MONEY_VOUCHER", "Voucher is not a money voucher (JSON error code: 4213)" } },
    //{ 0x82021076,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_VOUCHER_ALREADY_CANCELLED", "Voucher is already cancelled (JSON error code: 4214)" } },
    //{ 0x82021077,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_NOT_A_PRODUCT_VOUCHER", "Voucher is not a product voucher (JSON error code: 4215)" } },
    //{ 0x82021078,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_RESOURCE_NOT_SUPPORTED",    "Support for this resource is not yet implemented (JSON error code: 4216)" } },
    //{ 0x82021079,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_SECURITY_CODE_REQUIRED",    "Security code required (JSON error code: 4217)" } },
    //{ 0x8202107A,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_SKU_SHOULD_BE_BOUGHT_ALONE",    "SKU that needs to be charged immediately must be bought alone (JSON error code: 4218)" } },
    //{ 0x8202107B,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_SKU_REQUIRES_CC",   "SKU that needs to be charged immediately requires a credit card (JSON error code: 4219)" } },
    //{ 0x8202107C,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_SKU_REQUIRES_AUTO_DEPOSIT", "SKU that needs to be charged immediately requires autoDeposit (JSON error code: 4220)" } },
    //{ 0x8202107D,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_INVALID_PASSWORD",  "Invalid password (JSON error code: 4221)" } },
    //{ 0x8202107E,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_SUBACC_SHOULD_REACCEPT_TOSUA",  "ToSUA must be re-accepted for sub account by sub account (JSON error code: 4222)" } },
    //{ 0x8202107F,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_SUBSCOPE_CANNOT_BE_USED",   "Subscope cannot be used to update fields 'X'. (JSON error code: 4223)" } },
    //{ 0x82021080,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_UNSUPPORTED_OPERATION", "Unsupported operation (JSON error code: 4224)" } },
    //{ 0x82021081,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_PAYMENT_INSTRUMENT_NOT_FOUND",  "No payment instrument found (JSON error code: 4225)" } },
    //{ 0x82021082,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_PREVIEW_FAILED",    "Preview failed. (JSON error code: 4226)" } },
    //{ 0x82021083,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_SCOPE_DOES_NOT_EXIST",  "Scope(s): [\"XXX\"] do not exist (JSON error code: 4227)" } },
    //{ 0x82021084,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_NOT_A_SUBACCOUNT",  "Account is not a sub account (JSON error code: 4228)" } },
    //{ 0x82021085,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_INELIGIBLE_SKU",    "Ineligible SKU (JSON error code: 4229)" } },
    //{ 0x82021086,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_SUBSCRIPTION_CONFLICT", "Subscription conflict (JSON error code: 4230)" } },
    //{ 0x82021087,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_UNKNOWN_BACKEND_ERROR", "Unknown backend error (JSON error code: 4231)" } },
    //{ 0x82021088,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_PAYMENT_INSTRUMENT_DUPLICATED", "Payment instrument duplicated (JSON error code: 4232)" } },
    //{ 0x82021089,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_PAYMENT_INSTRUMENT_BANNED", "Payment instrument banned (JSON error code: 4233)" } },
    //{ 0x8202108A,{ "SCE_NP_WEB_CLIENT_ERROR_COMMERCE_REGCAM_ERROR_PAYMENT_INSTRUMENT_FIELD_BANNED",   "Payment instrument field banned (JSON error code: 4234)" } },
    //{ 0x82200001,{ "SCE_NP_WEBAPI_SERVER_ERROR_ASM_BAD_REQUEST",  "Details are unknown, but an invalid value was included in request (header, body, query string, etc.) (JSON error code: 2097153)" } },
    //{ 0x82200002,{ "SCE_NP_WEBAPI_SERVER_ERROR_ASM_UNSUPPORTED_API_VERSION",  "Unsupported API version (JSON error code: 2097154)" } },
    //{ 0x82200004,{ "SCE_NP_WEBAPI_SERVER_ERROR_ASM_INVALID_NP_ENVIRONMENT",   "Environment name is invalid (JSON error code: 2097156)" } },
    //{ 0x82200005,{ "SCE_NP_WEBAPI_SERVER_ERROR_ASM_INVALID_NP_TITLE_ID",  "NP Title ID is invalid (JSON error code: 2097157)" } },
    //{ 0x8220000A,{ "SCE_NP_WEBAPI_SERVER_ERROR_ASM_INVALID_OAUTH_CLIENT_ID",  "OAuth client ID is invalid (JSON error code: 2097162)" } },
    //{ 0x82200200,{ "SCE_NP_WEBAPI_SERVER_ERROR_ASM_ACCESS_TOKEN_REQUIRED",    "No access token (JSON error code: 2097664)" } },
    //{ 0x82200201,{ "SCE_NP_WEBAPI_SERVER_ERROR_ASM_INVALID_ACCESS_TOKEN", "Access token is an invalid value or is corrupted (JSON error code: 2097665)" } },
    //{ 0x82200202,{ "SCE_NP_WEBAPI_SERVER_ERROR_ASM_EXPIRED_ACCESS_TOKEN", "Access token is expired (JSON error code: 2097666)" } },
    //{ 0x82200206,{ "SCE_NP_WEBAPI_SERVER_ERROR_ASM_NOT_AUTHORIZED",   "Not authorized to access specified resource or use query parameter (JSON error code: 2097670)" } },
    //{ 0x82200208,{ "SCE_NP_WEBAPI_SERVER_ERROR_ASM_BANNED_USER",  "Banned user (JSON error code: 2097672)" } },
    //{ 0x8220020B,{ "SCE_NP_WEBAPI_SERVER_ERROR_ASM_RATE_LIMIT_EXCEEDED",  "API rate limit was exceeded (JSON error code: 2097675)" } },
    //{ 0x8220020D,{ "SCE_NP_WEBAPI_SERVER_ERROR_ASM_NOT_AUTHORIZED_ACCESS_TOKEN",  "Access token was obtained with an invalid procedure (JSON error code: 2097677)" } },
    //{ 0x8220020E,{ "SCE_NP_WEBAPI_SERVER_ERROR_ASM_NEED_TO_UPGRADE",  "Account needs to upgrade (JSON error code: 2097678)" } },
    //{ 0x82200280,{ "SCE_NP_WEBAPI_SERVER_ERROR_ASM_UNKNOWN_CLIENT",   "Client ID for access token is invalid (JSON error code: 2097792)" } },
    //{ 0x82200281,{ "SCE_NP_WEBAPI_SERVER_ERROR_ASM_NP_TITLE_ID_NOT_FOUND",    "Title does not exist (JSON error code: 2097793)" } },
    //{ 0x82200284,{ "SCE_NP_WEBAPI_SERVER_ERROR_ASM_NP_COMMUNICATION_ID_NOT_FOUND",    "NP Communication ID does not exist (JSON error code: 2097796)" } },
    //{ 0x82200300,{ "SCE_NP_WEBAPI_SERVER_ERROR_ASM_UNEXPECTED_ERROR", "Unexpected error (JSON error code: 2097920)" } },
    //{ 0x82200301,{ "SCE_NP_WEBAPI_SERVER_ERROR_ASM_INTERNAL_SERVER_ERROR",    "Internal error of the server (JSON error code: 2097921)" } },
    //{ 0x82200302,{ "SCE_NP_WEBAPI_SERVER_ERROR_ASM_SERVICE_TEMPORARILY_UNAVAILABLE",  "Service has been temporarily stopped (JSON error code: 2097922)" } },
    //{ 0x82200303,{ "SCE_NP_WEBAPI_SERVER_ERROR_ASM_SERVER_BUSY",  "Server overload (JSON error code: 2097923)" } },
    //{ 0x82200304,{ "SCE_NP_WEBAPI_SERVER_ERROR_ASM_AUTHORIZATION_SERVER_ERROR",   "Authentication/authorization server error  (JSON error code: 2097924)" } },
    //{ 0x82200340,{ "SCE_NP_WEBAPI_SERVER_ERROR_ASM_UNDER_MAINTENANCE",    "Server is under maintenance (JSON error code: 2097984)" } },
    //{ 0x82200341,{ "SCE_NP_WEBAPI_SERVER_ERROR_ASM_SERVICE_CLOSED",   "Service has closed (JSON error code: 2097985)" } },
    //{ 0x82200380,{ "SCE_NP_WEBAPI_SERVER_ERROR_ASM_UNKNOWN_ERROR",    "Unknown error (JSON error code: 2098048)" } },
    //{ 0x82200400,{ "SCE_NP_WEBAPI_SERVER_ERROR_ASM_INVALID_API_GROUP",    "Invalid API group (JSON error code: 2098176)" } },
    //{ 0x82200401,{ "SCE_NP_WEBAPI_SERVER_ERROR_ASM_BASE_URL_UNDEFINED",   "The API Group that is not available in the environment accessed by the user (JSON error code: 2098177)" } },
    //{ 0x82200401,{ "SCE_NP_WEBAPI_SERVER_ERROR_ASM_NOT_AUTHORIZED_APPLICATION_TO_USE_THE_API_GROUP",  "[obsolete]API group that cannot be used in the environment it was accessed by (JSON error code: 2098177)" } },
    //{ 0x82201001,{ "SCE_NP_WEBAPI_SERVER_ERROR_PUSH_NOTIFICATION_BAD_REQUEST",    "Details are unknown, but an invalid value was included in request (header, body, query string, etc.) (JSON error code: 2101249)" } },
    //{ 0x82201002,{ "SCE_NP_WEBAPI_SERVER_ERROR_PUSH_NOTIFICATION_UNSUPPORTED_API_VERSION",    "Unsupported API version (JSON error code: 2101250)" } },
    //{ 0x82201003,{ "SCE_NP_WEBAPI_SERVER_ERROR_PUSH_NOTIFICATION_TOO_LARGE_BODY", "Request body is too long (JSON error code: 2101251)" } },
    //{ 0x82201004,{ "SCE_NP_WEBAPI_SERVER_ERROR_PUSH_NOTIFICATION_INVALID_NP_ENVIRONMENT", "Environment name is invalid (JSON error code: 2101252)" } },
    //{ 0x82201005,{ "SCE_NP_WEBAPI_SERVER_ERROR_PUSH_NOTIFICATION_INVALID_NP_TITLE_ID",    "NP Title ID is invalid (JSON error code: 2101253)" } },
    //{ 0x8220100A,{ "SCE_NP_WEBAPI_SERVER_ERROR_PUSH_NOTIFICATION_INVALID_OAUTH_CLIENT_ID",    "OAuth client ID is invalid (JSON error code: 2101258)" } },
    //{ 0x8220100C,{ "SCE_NP_WEBAPI_SERVER_ERROR_PUSH_NOTIFICATION_USER_NOT_FOUND", "Target user does not exist (JSON error code: 2101260)" } },
    //{ 0x8220100D,{ "SCE_NP_WEBAPI_SERVER_ERROR_PUSH_NOTIFICATION_RESOURCE_NOT_FOUND", "Target resource does not exist (JSON error code: 2101261)" } },
    //{ 0x82201200,{ "SCE_NP_WEBAPI_SERVER_ERROR_PUSH_NOTIFICATION_ACCESS_TOKEN_REQUIRED",  "No access token (JSON error code: 2101760)" } },
    //{ 0x82201201,{ "SCE_NP_WEBAPI_SERVER_ERROR_PUSH_NOTIFICATION_INVALID_ACCESS_TOKEN",   "Access token is an invalid value or is corrupted (JSON error code: 2101761)" } },
    //{ 0x82201202,{ "SCE_NP_WEBAPI_SERVER_ERROR_PUSH_NOTIFICATION_EXPIRED_ACCESS_TOKEN",   "Access token is expired (JSON error code: 2101762)" } },
    //{ 0x82201208,{ "SCE_NP_WEBAPI_SERVER_ERROR_PUSH_NOTIFICATION_BANNED_USER",    "Banned user (JSON error code: 2101768)" } },
    //{ 0x82201209,{ "SCE_NP_WEBAPI_SERVER_ERROR_PUSH_NOTIFICATION_BANNED_DEVICE",  "Banned device (JSON error code: 2101769)" } },
    //{ 0x8220120D,{ "SCE_NP_WEBAPI_SERVER_ERROR_PUSH_NOTIFICATION_NOT_AUTHORIZED_ACCESS_TOKEN",    "Access token was obtained with an invalid procedure (JSON error code: 2101773)" } },
    //{ 0x82201210,{ "SCE_NP_WEBAPI_SERVER_ERROR_PUSH_NOTIFICATION_USERS_ACCESS_TOKEN_REQUIRED",    "The API which doesn't permit an access with access token authenticated only with client credential. (JSON error code: 2101776)" } },
    //{ 0x82201300,{ "SCE_NP_WEBAPI_SERVER_ERROR_PUSH_NOTIFICATION_UNEXPECTED_ERROR",   "Unexpected error (JSON error code: 2102016)" } },
    //{ 0x82201301,{ "SCE_NP_WEBAPI_SERVER_ERROR_PUSH_NOTIFICATION_INTERNAL_SERVER_ERROR",  "Internal error of the server (JSON error code: 2102017)" } },
    //{ 0x82201302,{ "SCE_NP_WEBAPI_SERVER_ERROR_PUSH_NOTIFICATION_SERVICE_TEMPORARILY_UNAVAILABLE",    "Service has been temporarily stopped (JSON error code: 2102018)" } },
    //{ 0x82201303,{ "SCE_NP_WEBAPI_SERVER_ERROR_PUSH_NOTIFICATION_SERVER_BUSY",    "Server overload (JSON error code: 2102019)" } },
    //{ 0x82201304,{ "SCE_NP_WEBAPI_SERVER_ERROR_PUSH_NOTIFICATION_AUTHORIZATION_SERVER_ERROR", "Authentication/authorization server error  (JSON error code: 2102020)" } },
    //{ 0x82201340,{ "SCE_NP_WEBAPI_SERVER_ERROR_PUSH_NOTIFICATION_UNDER_MAINTENANCE",  "Server is under maintenance (JSON error code: 2102080)" } },
    //{ 0x82201341,{ "SCE_NP_WEBAPI_SERVER_ERROR_PUSH_NOTIFICATION_SERVICE_CLOSED", "Service has closed (JSON error code: 2102081)" } },
    //{ 0x82201380,{ "SCE_NP_WEBAPI_SERVER_ERROR_PUSH_NOTIFICATION_UNKNOWN_ERROR",  "Unknown error (JSON error code: 2102144)" } },
    //{ 0x82201403,{ "SCE_NP_WEBAPI_SERVER_ERROR_PUSH_NOTIFICATION_THE_USER_IS_NOT_BIND_USER",  "The sender is not online (JSON error code: 2102275)" } },
    //{ 0x82201501,{ "SCE_NP_WEBAPI_SERVER_ERROR_PUSH_NOTIFICATION_FAILED_TO_DELIVER_NO_SUCH_USER", "Failed to deliver (no such user) (JSON error code: 2102529)" } },
    //{ 0x82201502,{ "SCE_NP_WEBAPI_SERVER_ERROR_PUSH_NOTIFICATION_FAILED_TO_DELIVER_THE_USER_IS_NOT_BIND_USER",    "Failed to deliver (user status of the target is not online) (JSON error code: 2102530)" } },
    //{ 0x82201503,{ "SCE_NP_WEBAPI_SERVER_ERROR_PUSH_NOTIFICATION_FAILED_TO_DELIVER_USER_STATUS_IS_NOT_ACTIVE",    "Failed to deliver (user status of the target is not online) (JSON error code: 2102531)" } },
    //{ 0x82202001,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_BAD_REQUEST", "Details are unknown, but an invalid value was included in request (header, body, query string, etc.) (JSON error code: 2105345)" } },
    //{ 0x82202002,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_UNSUPPORTED_API_VERSION", "Unsupported API version (JSON error code: 2105346)" } },
    //{ 0x82202003,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_TOO_LARGE_BODY",  "Request body is too long (JSON error code: 2105347)" } },
    //{ 0x82202004,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_INVALID_NP_ENVIRONMENT",  "Environment name is invalid (JSON error code: 2105348)" } },
    //{ 0x82202005,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_INVALID_NP_TITLE_ID", "NP Title ID is invalid (JSON error code: 2105349)" } },
    //{ 0x8220200A,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_INVALID_OAUTH_CLIENT_ID", "OAuth client ID is invalid (JSON error code: 2105354)" } },
    //{ 0x8220200C,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_USER_NOT_FOUND",  "Target user does not exist (JSON error code: 2105356)" } },
    //{ 0x8220200D,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_RESOURCE_NOT_FOUND",  "Target resource does not exist (JSON error code: 2105357)" } },
    //{ 0x8220200E,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_ACCESS_DENIED_BY_RESOURCE_OWNERSHIP", "Access attempted by a non-owner for a resource that only the resource owner can access. For example, attempted to obtain a friend list with presence information of another user. (JSON error code: 2105358)" } },
    //{ 0x82202100,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_INVALID_QUERY_STRING",    "Details are unknown, but an value in query string is invalid (JSON error code: 2105600)" } },
    //{ 0x82202101,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_INVALID_QUERY_PARAMETER", "Query parameter value in query string is invalid (JSON error code: 2105601)" } },
    //{ 0x82202102,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_INVALID_QUERY_PARAMETER_COMBINATION", "Query parameter combination in query string is invalid (JSON error code: 2105602)" } },
    //{ 0x82202103,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_UNAVAILABLE_QUERY_PARAMETER_FOR_RESOURCE",    "Specified query parameter cannot be used for the specified resource (JSON error code: 2105603)" } },
    //{ 0x82202104,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_INVALID_PARAMETER_IN_URL",    "Parameter section value included in URL is invalid (JSON error code: 2105604)" } },
    //{ 0x82202105,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_MANDATORY_QUERY_PARAMETER_MISSING",   "Query parameter required for query string does not exist (JSON error code: 2105605)" } },
    //{ 0x82202140,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_INVALID_HEADER",  "Header value for request header is invalid (JSON error code: 2105664)" } },
    //{ 0x82202141,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_HEADER_REQUIRED", "Header required for request header does not exist (JSON error code: 2105665)" } },
    //{ 0x82202180,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_INVALID_BODY",    "Details are unknown, but request body value is invalid (JSON error code: 2105728)" } },
    //{ 0x82202181,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_NULL_VALUE_NOT_ALLOWED",  "A member with a null value in request body exists (JSON error code: 2105729)" } },
    //{ 0x82202182,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_INVALID_BODY_PARAMETER",  "Request body member value is invalid (JSON error code: 2105730)" } },
    //{ 0x82202183,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_INVALID_BODY_PARAMETER_LIST_LENGTH",  "Number of elements for request body array type members is invalid (JSON error code: 2105731)" } },
    //{ 0x82202184,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_INVALID_BODY_PARAMETER_COMBINATION",  "Request body member combination is invalid (JSON error code: 2105732)" } },
    //{ 0x82202185,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_BLOCKED_USER_EXISTS", "Blocked user can't be specified (JSON error code: 2105733)" } },
    //{ 0x82202186,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_MANDATORY_BODY_PARAMETER_MISSING",    "Member required for request body does not exist (JSON error code: 2105734)" } },
    //{ 0x82202200,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_ACCESS_TOKEN_REQUIRED",   "No access token (JSON error code: 2105856)" } },
    //{ 0x82202201,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_INVALID_ACCESS_TOKEN",    "Access token is an invalid value or is corrupted (JSON error code: 2105857)" } },
    //{ 0x82202202,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_EXPIRED_ACCESS_TOKEN",    "Access token is expired (JSON error code: 2105858)" } },
    //{ 0x82202206,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_NOT_AUTHORIZED",  "Not authorized to access specified resource or use query parameter (JSON error code: 2105862)" } },
    //{ 0x82202207,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_BANNED_APPLICATION",  "Banned title (JSON error code: 2105863)" } },
    //{ 0x82202208,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_BANNED_USER", "Banned user (JSON error code: 2105864)" } },
    //{ 0x82202209,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_BANNED_DEVICE",   "Banned device (JSON error code: 2105865)" } },
    //{ 0x8220220A,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_ACCESS_DENIED_DUE_TO_TITILE_MISMATCH",    "Access to resource not possible since title set for the presence information does not match (JSON error code: 2105866)" } },
    //{ 0x8220220B,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_RATE_LIMIT_EXCEEDED", "API rate limit was exceeded (JSON error code: 2105867)" } },
    //{ 0x8220220C,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_ACCESS_DENIED_BY_PRIVACY_LEVEL",  "Access was denied due to target user privacy setting (JSON error code: 2105868)" } },
    //{ 0x8220220D,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_NOT_AUTHORIZED_ACCESS_TOKEN", "Access token was obtained with an invalid procedure (JSON error code: 2105869)" } },
    //{ 0x8220220E,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_NEED_TO_UPGRADE", "Account needs to upgrade (JSON error code: 2105870)" } },
    //{ 0x8220220F,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_NOT_AUTHORIZED_ON_PLATFORM",  "Parameter which is not available on the platform is specified (JSON error code: 2105871)" } },
    //{ 0x82202210,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_USERS_ACCESS_TOKEN_REQUIRED", "The API which doesn't permit an access with access token authenticated only with client credential. (JSON error code: 2105872)" } },
    //{ 0x82202211,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_ACCESS_DENIED_DUE_TO_PARENTAL_CONTROL_SETTINGS",  "Access denied due to parental control settings (JSON error code: 2105873)" } },
    //{ 0x82202280,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_UNKNOWN_CLIENT",  "Client ID for access token is invalid (JSON error code: 2105984)" } },
    //{ 0x82202281,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_NP_TITLE_ID_NOT_FOUND",   "Title does not exist (JSON error code: 2105985)" } },
    //{ 0x82202283,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_NOT_AUTHORIZED_APPLICATION",  "This title cannot be used for the inGamePresence service (JSON error code: 2105987)" } },
    //{ 0x82202300,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_UNEXPECTED_ERROR",    "Unexpected error (JSON error code: 2106112)" } },
    //{ 0x82202301,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_INTERNAL_SERVER_ERROR",   "Internal error of the server (JSON error code: 2106113)" } },
    //{ 0x82202302,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_SERVICE_TEMPORARILY_UNAVAILABLE", "Service has been temporarily stopped (JSON error code: 2106114)" } },
    //{ 0x82202303,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_SERVER_BUSY", "Server overload (JSON error code: 2106115)" } },
    //{ 0x82202304,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_AUTHORIZATION_SERVER_ERROR",  "Authentication/authorization server error  (JSON error code: 2106116)" } },
    //{ 0x82202340,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_UNDER_MAINTENANCE",   "Server is under maintenance (JSON error code: 2106176)" } },
    //{ 0x82202341,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_SERVICE_CLOSED",  "Service has closed (JSON error code: 2106177)" } },
    //{ 0x82202380,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_UNKNOWN_ERROR",   "Unknown error (JSON error code: 2106240)" } },
    //{ 0x82202400,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_REQUEST_NOT_ALLOWED_DUE_TO_ONLINE_STATUS",    "Request not allowed during offline state (JSON error code: 2106368)" } },
    //{ 0x82202401,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_CANNOT_ADD_YOUR_OWN_SELF",    "Cannot add/remove your own self to friend list or block list (JSON error code: 2106369)" } },
    //{ 0x82202900,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_FRIEND_REQUEST_NOT_FOUND",    "Friend request does not exist (JSON error code: 2107648)" } },
    //{ 0x82202901,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_NOT_IN_FRIEND_LIST",  "User does not exist in friends list (JSON error code: 2107649)" } },
    //{ 0x82202902,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_ALREADY_FRIEND",  "Already be friends (JSON error code: 2107650)" } },
    //{ 0x82202903,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_ALREADY_FRIEND_REQUESTED",    "Already friend-requested (JSON error code: 2107651)" } },
    //{ 0x82202904,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_REQUESTERS_FRIEND_LIST_FULL", "Requester's friend list is full. (JSON error code: 2107652)" } },
    //{ 0x82202905,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_REQUESTED_USERS_FRIEND_LIST_FULL",    "Requested user's friend list is full. (JSON error code: 2107653)" } },
    //{ 0x82202906,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_NAME_ALREADY_SHARED", "Already shared their name (JSON error code: 2107654)" } },
    //{ 0x82202907,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_BLOCKED_USER",    "Blocked user (JSON error code: 2107655)" } },
    //{ 0x82202908,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_NAME_SHARING_REQUEST_NOT_FOUND",  "Name-sharing request does not exist (JSON error code: 2107656)" } },
    //{ 0x82202909,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_ALREADY_NAME_SHARING_REQUESTED",  "Already requested to share their name (JSON error code: 2107657)" } },
    //{ 0x8220290A,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_NAME_REGISTRATION_REQUIRED",  "Name registaration of the user is needed (JSON error code: 2107658)" } },
    //{ 0x8220290B,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_TARGET_USER_NOT_REGISTERED_NAME", "Name registaration of the target user is needed (JSON error code: 2107659)" } },
    //{ 0x8220290C,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_CANNOT_SPECIFY_YOUR_OWN_SELF",    "Target must not be yourself (JSON error code: 2107660)" } },
    //{ 0x82202A00,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_NON_FRIEND_NOT_ALLOWED",  "Access was attempted by a non-resource owner or non-friend (JSON error code: 2107904)" } },
    //{ 0x82202A01,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_DEVICE_ID_NOT_MATCHED",   "Online device set in presence information does not match (JSON error code: 2107905)" } },
    //{ 0x82202A02,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_NP_TITLE_ID_NOT_MATCHED", "NP Title ID set in presence information does not match (JSON error code: 2107906)" } },
    //{ 0x82202B00,{ "SCE_NP_WEBAPI_SERVER_ERROR_USER_PROFILE_BLOCK_LIST_FULL", "Block list is full (JSON error code: 2108160)" } },
    //{ 0x82204001,{ "SCE_NP_WEBAPI_SERVER_ERROR_SESSION_INVITATION_BAD_REQUEST",   "Details are unknown, but an invalid value was included in request (header, body, query string, etc.) (JSON error code: 2113537)" } },
    //{ 0x82204002,{ "SCE_NP_WEBAPI_SERVER_ERROR_SESSION_INVITATION_UNSUPPORTED_API_VERSION",   "Unsupported API version (JSON error code: 2113538)" } },
    //{ 0x82204003,{ "SCE_NP_WEBAPI_SERVER_ERROR_SESSION_INVITATION_TOO_LARGE_BODY",    "Request body is too long (JSON error code: 2113539)" } },
    //{ 0x82204004,{ "SCE_NP_WEBAPI_SERVER_ERROR_SESSION_INVITATION_INVALID_NP_ENVIRONMENT",    "Environment name is invalid (JSON error code: 2113540)" } },
    //{ 0x82204005,{ "SCE_NP_WEBAPI_SERVER_ERROR_SESSION_INVITATION_INVALID_NP_TITLE_ID",   "NP Title ID is invalid (JSON error code: 2113541)" } },
    //{ 0x82204007,{ "SCE_NP_WEBAPI_SERVER_ERROR_SESSION_INVITATION_INVALID_NP_COMMUNICATION_ID",   "NP Communication ID is invalid (JSON error code: 2113543)" } },
    //{ 0x8220400A,{ "SCE_NP_WEBAPI_SERVER_ERROR_SESSION_INVITATION_INVALID_OAUTH_CLIENT_ID",   "OAuth client ID is invalid (JSON error code: 2113546)" } },
    //{ 0x8220400C,{ "SCE_NP_WEBAPI_SERVER_ERROR_SESSION_INVITATION_USER_NOT_FOUND",    "Target user does not exist (JSON error code: 2113548)" } },
    //{ 0x8220400D,{ "SCE_NP_WEBAPI_SERVER_ERROR_SESSION_INVITATION_RESOURCE_NOT_FOUND",    "Target resource does not exist (JSON error code: 2113549)" } },
    //{ 0x8220400E,{ "SCE_NP_WEBAPI_SERVER_ERROR_SESSION_INVITATION_ACCESS_DENIED_BY_RESOURCE_OWNERSHIP",   "Access attempted by a non-owner for a resource that only the resource owner can access. For example, attempted to obtain a friend list with presence information of another user. (JSON error code: 2113550)" } },
    //{ 0x82204100,{ "SCE_NP_WEBAPI_SERVER_ERROR_SESSION_INVITATION_INVALID_QUERY_STRING",  "Details are unknown, but an value in query string is invalid (JSON error code: 2113792)" } },
    //{ 0x82204101,{ "SCE_NP_WEBAPI_SERVER_ERROR_SESSION_INVITATION_INVALID_QUERY_PARAMETER",   "Query parameter value in query string is invalid (JSON error code: 2113793)" } },
    //{ 0x82204102,{ "SCE_NP_WEBAPI_SERVER_ERROR_SESSION_INVITATION_INVALID_QUERY_PARAMETER_COMBINATION",   "Query parameter combination in query string is invalid (JSON error code: 2113794)" } },
    //{ 0x82204103,{ "SCE_NP_WEBAPI_SERVER_ERROR_SESSION_INVITATION_UNAVAILABLE_QUERY_PARAMETER_FOR_RESOURCE",  "Specified query parameter cannot be used for the specified resource (JSON error code: 2113795)" } },
    //{ 0x82204104,{ "SCE_NP_WEBAPI_SERVER_ERROR_SESSION_INVITATION_INVALID_PARAMETER_IN_URL",  "Parameter section value included in URL is invalid (JSON error code: 2113796)" } },
    //{ 0x82204105,{ "SCE_NP_WEBAPI_SERVER_ERROR_SESSION_INVITATION_MANDATORY_QUERY_PARAMETER_MISSING", "Query parameter required for query string does not exist (JSON error code: 2113797)" } },
    //{ 0x82204140,{ "SCE_NP_WEBAPI_SERVER_ERROR_SESSION_INVITATION_INVALID_HEADER",    "Header value for request header is invalid (JSON error code: 2113856)" } },
    //{ 0x82204141,{ "SCE_NP_WEBAPI_SERVER_ERROR_SESSION_INVITATION_HEADER_REQUIRED",   "Header required for request header does not exist (JSON error code: 2113857)" } },
    //{ 0x82204180,{ "SCE_NP_WEBAPI_SERVER_ERROR_SESSION_INVITATION_INVALID_BODY",  "Details are unknown, but request body value is invalid (JSON error code: 2113920)" } },
    //{ 0x82204181,{ "SCE_NP_WEBAPI_SERVER_ERROR_SESSION_INVITATION_NULL_VALUE_NOT_ALLOWED",    "A member with a null value in request body exists (JSON error code: 2113921)" } },
    //{ 0x82204182,{ "SCE_NP_WEBAPI_SERVER_ERROR_SESSION_INVITATION_INVALID_BODY_PARAMETER",    "Request body member value is invalid (JSON error code: 2113922)" } },
    //{ 0x82204183,{ "SCE_NP_WEBAPI_SERVER_ERROR_SESSION_INVITATION_INVALID_BODY_PARAMETER_LIST_LENGTH",    "Number of elements for request body array type members is invalid (JSON error code: 2113923)" } },
    //{ 0x82204184,{ "SCE_NP_WEBAPI_SERVER_ERROR_SESSION_INVITATION_INVALID_BODY_PARAMETER_COMBINATION",    "Request body member combination is invalid (JSON error code: 2113924)" } },
    //{ 0x82204185,{ "SCE_NP_WEBAPI_SERVER_ERROR_SESSION_INVITATION_BLOCKED_USER_EXISTS",   "Blocked user can't be specified (JSON error code: 2113925)" } },
    //{ 0x82204186,{ "SCE_NP_WEBAPI_SERVER_ERROR_SESSION_INVITATION_MANDATORY_BODY_PARAMETER_MISSING",  "Member required for request body does not exist (JSON error code: 2113926)" } },
    //{ 0x82204187,{ "SCE_NP_WEBAPI_SERVER_ERROR_SESSION_INVITATION_INVALID_MULTIPART_HEADER",  "Parameter for multipart header in request body is invalid (JSON error code: 2113927)" } },
    //{ 0x82204188,{ "SCE_NP_WEBAPI_SERVER_ERROR_SESSION_INVITATION_MANDATORY_MULTIPART_HEADER_MISSING",    "Member required for multipart header parameter in request body does not exist (JSON error code: 2113928)" } },
    //{ 0x82204200,{ "SCE_NP_WEBAPI_SERVER_ERROR_SESSION_INVITATION_ACCESS_TOKEN_REQUIRED", "No access token (JSON error code: 2114048)" } },
    //{ 0x82204201,{ "SCE_NP_WEBAPI_SERVER_ERROR_SESSION_INVITATION_INVALID_ACCESS_TOKEN",  "Access token is an invalid value or is corrupted (JSON error code: 2114049)" } },
    //{ 0x82204202,{ "SCE_NP_WEBAPI_SERVER_ERROR_SESSION_INVITATION_EXPIRED_ACCESS_TOKEN",  "Access token is expired (JSON error code: 2114050)" } },
    //{ 0x82204206,{ "SCE_NP_WEBAPI_SERVER_ERROR_SESSION_INVITATION_NOT_AUTHORIZED",    "Not authorized to access specified resource or use query parameter (JSON error code: 2114054)" } },
    //{ 0x82204207,{ "SCE_NP_WEBAPI_SERVER_ERROR_SESSION_INVITATION_BANNED_APPLICATION",    "Banned title (JSON error code: 2114055)" } },
    //{ 0x82204208,{ "SCE_NP_WEBAPI_SERVER_ERROR_SESSION_INVITATION_BANNED_USER",   "Banned user (JSON error code: 2114056)" } },
    //{ 0x82204209,{ "SCE_NP_WEBAPI_SERVER_ERROR_SESSION_INVITATION_BANNED_DEVICE", "Banned device (JSON error code: 2114057)" } },
    //{ 0x8220420A,{ "SCE_NP_WEBAPI_SERVER_ERROR_SESSION_INVITATION_ACCESS_DENIED_DUE_TO_TITILE_MISMATCH",  "Access to resource not possible since title does not match (JSON error code: 2114058)" } },
    //{ 0x8220420B,{ "SCE_NP_WEBAPI_SERVER_ERROR_SESSION_INVITATION_RATE_LIMIT_EXCEEDED",   "API rate limit was exceeded (JSON error code: 2114059)" } },
    //{ 0x8220420C,{ "SCE_NP_WEBAPI_SERVER_ERROR_SESSION_INVITATION_ACCESS_DENIED_BY_PRIVACY_LEVEL",    "Access was denied due to target user privacy setting (JSON error code: 2114060)" } },
    //{ 0x8220420D,{ "SCE_NP_WEBAPI_SERVER_ERROR_SESSION_INVITATION_NOT_AUTHORIZED_ACCESS_TOKEN",   "Access token was obtained with an invalid procedure (JSON error code: 2114061)" } },
    //{ 0x8220420E,{ "SCE_NP_WEBAPI_SERVER_ERROR_SESSION_INVITATION_NEED_TO_UPGRADE",   "Account needs to upgrade (JSON error code: 2114062)" } },
    //{ 0x8220420F,{ "SCE_NP_WEBAPI_SERVER_ERROR_SESSION_INVITATION_NOT_AUTHORIZED_ON_PLATFORM",    "Parameter which is not available on the platform is specified (JSON error code: 2114063)" } },
    //{ 0x82204210,{ "SCE_NP_WEBAPI_SERVER_ERROR_SESSION_INVITATION_USERS_ACCESS_TOKEN_REQUIRED",   "The API which doesn't permit an access with access token authenticated only with client credential. (JSON error code: 2114064)" } },
    //{ 0x82204280,{ "SCE_NP_WEBAPI_SERVER_ERROR_SESSION_INVITATION_UNKNOWN_CLIENT",    "Client ID for access token is invalid (JSON error code: 2114176)" } },
    //{ 0x82204281,{ "SCE_NP_WEBAPI_SERVER_ERROR_SESSION_INVITATION_NP_TITLE_ID_NOT_FOUND", "Title does not exist (JSON error code: 2114177)" } },
    //{ 0x82204283,{ "SCE_NP_WEBAPI_SERVER_ERROR_SESSION_INVITATION_NOT_AUTHORIZED_APPLICATION",    "This title cannot be used for the sessionInvitation service (JSON error code: 2114179)" } },
    //{ 0x82204284,{ "SCE_NP_WEBAPI_SERVER_ERROR_SESSION_INVITATION_NP_COMMUNICATION_ID_NOT_FOUND", "NP Communication ID does not exist (JSON error code: 2114180)" } },
    //{ 0x82204300,{ "SCE_NP_WEBAPI_SERVER_ERROR_SESSION_INVITATION_UNEXPECTED_ERROR",  "Unexpected error (JSON error code: 2114304)" } },
    //{ 0x82204301,{ "SCE_NP_WEBAPI_SERVER_ERROR_SESSION_INVITATION_INTERNAL_SERVER_ERROR", "Internal error of the server (JSON error code: 2114305)" } },
    //{ 0x82204302,{ "SCE_NP_WEBAPI_SERVER_ERROR_SESSION_INVITATION_SERVICE_TEMPORARILY_UNAVAILABLE",   "Service has been temporarily stopped (JSON error code: 2114306)" } },
    //{ 0x82204303,{ "SCE_NP_WEBAPI_SERVER_ERROR_SESSION_INVITATION_SERVER_BUSY",   "Server overload (JSON error code: 2114307)" } },
    //{ 0x82204304,{ "SCE_NP_WEBAPI_SERVER_ERROR_SESSION_INVITATION_AUTHORIZATION_SERVER_ERROR",    "Authentication/authorization server error  (JSON error code: 2114308)" } },
    //{ 0x82204340,{ "SCE_NP_WEBAPI_SERVER_ERROR_SESSION_INVITATION_UNDER_MAINTENANCE", "Server is under maintenance (JSON error code: 2114368)" } },
    //{ 0x82204341,{ "SCE_NP_WEBAPI_SERVER_ERROR_SESSION_INVITATION_SERVICE_CLOSED",    "Service has closed (JSON error code: 2114369)" } },
    //{ 0x82204380,{ "SCE_NP_WEBAPI_SERVER_ERROR_SESSION_INVITATION_UNKNOWN_ERROR", "Unknown error (JSON error code: 2114432)" } },
    //{ 0x82204400,{ "SCE_NP_WEBAPI_SERVER_ERROR_SESSION_INVITATION_NOT_PERMIT_TO_ACCESS_THE_SESSION",  "Not permitted to access the session (JSON error code: 2114560)" } },
    //{ 0x82204401,{ "SCE_NP_WEBAPI_SERVER_ERROR_SESSION_INVITATION_THE_SESSION_IS_FULL",   "The session is already full (JSON error code: 2114561)" } },
    //{ 0x82204402,{ "SCE_NP_WEBAPI_SERVER_ERROR_SESSION_INVITATION_ONLY_SESSION_CREATOR_PERMITTED",    "Only the session creator is permitted to perform this operation (JSON error code: 2114562)" } },
    //{ 0x82204403,{ "SCE_NP_WEBAPI_SERVER_ERROR_SESSION_INVITATION_ONLY_SESSION_MEMBER_PERMITTED", "Only session members are permitted to perform this operation (JSON error code: 2114563)" } },
    //{ 0x82204404,{ "SCE_NP_WEBAPI_SERVER_ERROR_SESSION_INVITATION_USER_NOT_ONLINE",   "User is not online (JSON error code: 2114564)" } },
    //{ 0x82204800,{ "SCE_NP_WEBAPI_SERVER_ERROR_SESSION_INVITATION_EXPIRED_INVITATION",    "Invitation is expired or data has been used (JSON error code: 2115584)" } },
    //{ 0x82205001,{ "SCE_NP_WEBAPI_SERVER_ERROR_GAME_CUSTOM_DATA_BAD_REQUEST", "Details are unknown, but an invalid value was included in request (header, body, query string, etc.) (JSON error code: 2117633)" } },
    //{ 0x82205002,{ "SCE_NP_WEBAPI_SERVER_ERROR_GAME_CUSTOM_DATA_UNSUPPORTED_API_VERSION", "Unsupported API version (JSON error code: 2117634)" } },
    //{ 0x82205003,{ "SCE_NP_WEBAPI_SERVER_ERROR_GAME_CUSTOM_DATA_TOO_LARGE_BODY",  "Request body is too long (JSON error code: 2117635)" } },
    //{ 0x82205004,{ "SCE_NP_WEBAPI_SERVER_ERROR_GAME_CUSTOM_DATA_INVALID_NP_ENVIRONMENT",  "Environment name is invalid (JSON error code: 2117636)" } },
    //{ 0x8220500A,{ "SCE_NP_WEBAPI_SERVER_ERROR_GAME_CUSTOM_DATA_INVALID_OAUTH_CLIENT_ID", "OAuth client ID is invalid (JSON error code: 2117642)" } },
    //{ 0x8220500C,{ "SCE_NP_WEBAPI_SERVER_ERROR_GAME_CUSTOM_DATA_USER_NOT_FOUND",  "Target user does not exist (JSON error code: 2117644)" } },
    //{ 0x8220500D,{ "SCE_NP_WEBAPI_SERVER_ERROR_GAME_CUSTOM_DATA_RESOURCE_NOT_FOUND",  "Target resource does not exist (JSON error code: 2117645)" } },
    //{ 0x8220500E,{ "SCE_NP_WEBAPI_SERVER_ERROR_GAME_CUSTOM_DATA_ACCESS_DENIED_BY_RESOURCE_OWNERSHIP", "Access attempted by a non-owner for a resource that only the resource owner can access. For example, attempted to obtain a friend list with presence information of another user. (JSON error code: 2117646)" } },
    //{ 0x82205100,{ "SCE_NP_WEBAPI_SERVER_ERROR_GAME_CUSTOM_DATA_INVALID_QUERY_STRING",    "Details are unknown, but an value in query string is invalid (JSON error code: 2117888)" } },
    //{ 0x82205101,{ "SCE_NP_WEBAPI_SERVER_ERROR_GAME_CUSTOM_DATA_INVALID_QUERY_PARAMETER", "Query parameter value in query string is invalid (JSON error code: 2117889)" } },
    //{ 0x82205102,{ "SCE_NP_WEBAPI_SERVER_ERROR_GAME_CUSTOM_DATA_INVALID_QUERY_PARAMETER_COMBINATION", "Query parameter combination in query string is invalid (JSON error code: 2117890)" } },
    //{ 0x82205103,{ "SCE_NP_WEBAPI_SERVER_ERROR_GAME_CUSTOM_DATA_UNAVAILABLE_QUERY_PARAMETER_FOR_RESOURCE",    "Specified query parameter cannot be used for the specified resource (JSON error code: 2117891)" } },
    //{ 0x82205104,{ "SCE_NP_WEBAPI_SERVER_ERROR_GAME_CUSTOM_DATA_INVALID_PARAMETER_IN_URL",    "Parameter section value included in URL is invalid (JSON error code: 2117892)" } },
    //{ 0x82205105,{ "SCE_NP_WEBAPI_SERVER_ERROR_GAME_CUSTOM_DATA_MANDATORY_QUERY_PARAMETER_MISSING",   "Query parameter required for query string does not exist (JSON error code: 2117893)" } },
    //{ 0x82205140,{ "SCE_NP_WEBAPI_SERVER_ERROR_GAME_CUSTOM_DATA_INVALID_HEADER",  "Header value for request header is invalid (JSON error code: 2117952)" } },
    //{ 0x82205141,{ "SCE_NP_WEBAPI_SERVER_ERROR_GAME_CUSTOM_DATA_HEADER_REQUIRED", "Header required for request header does not exist (JSON error code: 2117953)" } },
    //{ 0x82205180,{ "SCE_NP_WEBAPI_SERVER_ERROR_GAME_CUSTOM_DATA_INVALID_BODY",    "Details are unknown, but request body value is invalid (JSON error code: 2118016)" } },
    //{ 0x82205181,{ "SCE_NP_WEBAPI_SERVER_ERROR_GAME_CUSTOM_DATA_NULL_VALUE_NOT_ALLOWED",  "A member with a null value in request body exists (JSON error code: 2118017)" } },
    //{ 0x82205182,{ "SCE_NP_WEBAPI_SERVER_ERROR_GAME_CUSTOM_DATA_INVALID_BODY_PARAMETER",  "Request body member value is invalid (JSON error code: 2118018)" } },
    //{ 0x82205183,{ "SCE_NP_WEBAPI_SERVER_ERROR_GAME_CUSTOM_DATA_INVALID_BODY_PARAMETER_LIST_LENGTH",  "Number of elements for request body array type members is invalid (JSON error code: 2118019)" } },
    //{ 0x82205184,{ "SCE_NP_WEBAPI_SERVER_ERROR_GAME_CUSTOM_DATA_INVALID_BODY_PARAMETER_COMBINATION",  "Request body member combination is invalid (JSON error code: 2118020)" } },
    //{ 0x82205185,{ "SCE_NP_WEBAPI_SERVER_ERROR_GAME_CUSTOM_DATA_BLOCKED_USER_EXISTS", "Blocked user can't be specified (JSON error code: 2118021)" } },
    //{ 0x82205186,{ "SCE_NP_WEBAPI_SERVER_ERROR_GAME_CUSTOM_DATA_MANDATORY_BODY_PARAMETER_MISSING",    "Member required for request body does not exist (JSON error code: 2118022)" } },
    //{ 0x82205187,{ "SCE_NP_WEBAPI_SERVER_ERROR_GAME_CUSTOM_DATA_INVALID_MULTIPART_HEADER",    "Parameter for multipart header in request body is invalid (JSON error code: 2118023)" } },
    //{ 0x82205188,{ "SCE_NP_WEBAPI_SERVER_ERROR_GAME_CUSTOM_DATA_MANDATORY_MULTIPART_HEADER_MISSING",  "Member required for multipart header parameter in request body does not exist (JSON error code: 2118024)" } },
    //{ 0x82205200,{ "SCE_NP_WEBAPI_SERVER_ERROR_GAME_CUSTOM_DATA_ACCESS_TOKEN_REQUIRED",   "No access token (JSON error code: 2118144)" } },
    //{ 0x82205201,{ "SCE_NP_WEBAPI_SERVER_ERROR_GAME_CUSTOM_DATA_INVALID_ACCESS_TOKEN",    "Access token is an invalid value or is corrupted (JSON error code: 2118145)" } },
    //{ 0x82205202,{ "SCE_NP_WEBAPI_SERVER_ERROR_GAME_CUSTOM_DATA_EXPIRED_ACCESS_TOKEN",    "Access token is expired (JSON error code: 2118146)" } },
    //{ 0x82205206,{ "SCE_NP_WEBAPI_SERVER_ERROR_GAME_CUSTOM_DATA_NOT_AUTHORIZED",  "Not authorized to access specified resource or use query parameter (JSON error code: 2118150)" } },
    //{ 0x82205207,{ "SCE_NP_WEBAPI_SERVER_ERROR_GAME_CUSTOM_DATA_BANNED_APPLICATION",  "Banned title (JSON error code: 2118151)" } },
    //{ 0x82205208,{ "SCE_NP_WEBAPI_SERVER_ERROR_GAME_CUSTOM_DATA_BANNED_USER", "Banned user (JSON error code: 2118152)" } },
    //{ 0x82205209,{ "SCE_NP_WEBAPI_SERVER_ERROR_GAME_CUSTOM_DATA_BANNED_DEVICE",   "Banned device (JSON error code: 2118153)" } },
    //{ 0x8220520A,{ "SCE_NP_WEBAPI_SERVER_ERROR_GAME_CUSTOM_DATA_ACCESS_DENIED_DUE_TO_TITILE_MISMATCH",    "Access to resource not possible since title does not match (JSON error code: 2118154)" } },
    //{ 0x8220520B,{ "SCE_NP_WEBAPI_SERVER_ERROR_GAME_CUSTOM_DATA_RATE_LIMIT_EXCEEDED", "API rate limit was exceeded (JSON error code: 2118155)" } },
    //{ 0x8220520D,{ "SCE_NP_WEBAPI_SERVER_ERROR_GAME_CUSTOM_DATA_NOT_AUTHORIZED_ACCESS_TOKEN", "Access token was obtained with an invalid procedure (JSON error code: 2118157)" } },
    //{ 0x82205210,{ "SCE_NP_WEBAPI_SERVER_ERROR_GAME_CUSTOM_DATA_USERS_ACCESS_TOKEN_REQUIRED", "The API which doesn't permit an access with access token authenticated only with client credential. (JSON error code: 2118160)" } },
    //{ 0x82205280,{ "SCE_NP_WEBAPI_SERVER_ERROR_GAME_CUSTOM_DATA_UNKNOWN_CLIENT",  "Client ID for access token is invalid (JSON error code: 2118272)" } },
    //{ 0x82205281,{ "SCE_NP_WEBAPI_SERVER_ERROR_GAME_CUSTOM_DATA_NP_TITLE_ID_NOT_FOUND",   "Title does not exist (JSON error code: 2118273)" } },
    //{ 0x82205283,{ "SCE_NP_WEBAPI_SERVER_ERROR_GAME_CUSTOM_DATA_NOT_AUTHORIZED_APPLICATION",  "This title cannot be used for the gameCustomData service (JSON error code: 2118275)" } },
    //{ 0x82205284,{ "SCE_NP_WEBAPI_SERVER_ERROR_GAME_CUSTOM_DATA_NP_COMMUNICATION_ID_NOT_FOUND",   "NP Communication ID does not exist (JSON error code: 2118276)" } },
    //{ 0x82205300,{ "SCE_NP_WEBAPI_SERVER_ERROR_GAME_CUSTOM_DATA_UNEXPECTED_ERROR",    "Unexpected error (JSON error code: 2118400)" } },
    //{ 0x82205301,{ "SCE_NP_WEBAPI_SERVER_ERROR_GAME_CUSTOM_DATA_INTERNAL_SERVER_ERROR",   "Internal error of the server (JSON error code: 2118401)" } },
    //{ 0x82205302,{ "SCE_NP_WEBAPI_SERVER_ERROR_GAME_CUSTOM_DATA_SERVICE_TEMPORARILY_UNAVAILABLE", "Service has been temporarily stopped (JSON error code: 2118402)" } },
    //{ 0x82205303,{ "SCE_NP_WEBAPI_SERVER_ERROR_GAME_CUSTOM_DATA_SERVER_BUSY", "Server overload (JSON error code: 2118403)" } },
    //{ 0x82205304,{ "SCE_NP_WEBAPI_SERVER_ERROR_GAME_CUSTOM_DATA_AUTHORIZATION_SERVER_ERROR",  "Authentication/authorization server error  (JSON error code: 2118404)" } },
    //{ 0x82205340,{ "SCE_NP_WEBAPI_SERVER_ERROR_GAME_CUSTOM_DATA_UNDER_MAINTENANCE",   "Server is under maintenance (JSON error code: 2118464)" } },
    //{ 0x82205341,{ "SCE_NP_WEBAPI_SERVER_ERROR_GAME_CUSTOM_DATA_SERVICE_CLOSED",  "Service has closed (JSON error code: 2118465)" } },
    //{ 0x82205380,{ "SCE_NP_WEBAPI_SERVER_ERROR_GAME_CUSTOM_DATA_UNKNOWN_ERROR",   "Unknown error (JSON error code: 2118528)" } },
    //{ 0x82205400,{ "SCE_NP_WEBAPI_SERVER_ERROR_GAME_CUSTOM_DATA_TOO_LARGE_IMAGE_DATA",    "Image data size is too large (JSON error code: 2118656)" } },
    //{ 0x82205800,{ "SCE_NP_WEBAPI_SERVER_ERROR_GAME_CUSTOM_DATA_EXPIRED_GAME_CUSTOM_DATA",    "Expired game custom data (JSON error code: 2119680)" } },
    //{ 0x82205801,{ "SCE_NP_WEBAPI_SERVER_ERROR_GAME_CUSTOM_DATA_ALREADY_USED_GAME_CUSTOM_DATA",   "Already used game custom data (JSON error code: 2119681)" } },
    //{ 0x82206001,{ "SCE_NP_WEBAPI_SERVER_ERROR_GROUP_MESSAGING_BAD_REQUEST",  "Details are unknown, but an invalid value was included in request (header, body, query string, etc.) (JSON error code: 2121729)" } },
    //{ 0x82206002,{ "SCE_NP_WEBAPI_SERVER_ERROR_GROUP_MESSAGING_UNSUPPORTED_API_VERSION",  "Unsupported API version (JSON error code: 2121730)" } },
    //{ 0x82206003,{ "SCE_NP_WEBAPI_SERVER_ERROR_GROUP_MESSAGING_TOO_LARGE_BODY",   "Request body is too long (JSON error code: 2121731)" } },
    //{ 0x82206004,{ "SCE_NP_WEBAPI_SERVER_ERROR_GROUP_MESSAGING_INVALID_NP_ENVIRONMENT",   "Environment name is invalid (JSON error code: 2121732)" } },
    //{ 0x8220600A,{ "SCE_NP_WEBAPI_SERVER_ERROR_GROUP_MESSAGING_INVALID_OAUTH_CLIENT_ID",  "OAuth client ID is invalid (JSON error code: 2121738)" } },
    //{ 0x8220600C,{ "SCE_NP_WEBAPI_SERVER_ERROR_GROUP_MESSAGING_USER_NOT_FOUND",   "Target user does not exist (JSON error code: 2121740)" } },
    //{ 0x8220600D,{ "SCE_NP_WEBAPI_SERVER_ERROR_GROUP_MESSAGING_RESOURCE_NOT_FOUND",   "Target resource does not exist (JSON error code: 2121741)" } },
    //{ 0x8220600E,{ "SCE_NP_WEBAPI_SERVER_ERROR_GROUP_MESSAGING_ACCESS_DENIED_BY_RESOURCE_OWNERSHIP",  "Access attempted by a non-owner for a resource that only the resource owner can access. For example, attempted to obtain a friend list with presence information of another user. (JSON error code: 2121742)" } },
    //{ 0x82206100,{ "SCE_NP_WEBAPI_SERVER_ERROR_GROUP_MESSAGING_INVALID_QUERY_STRING", "Details are unknown, but an value in query string is invalid (JSON error code: 2121984)" } },
    //{ 0x82206101,{ "SCE_NP_WEBAPI_SERVER_ERROR_GROUP_MESSAGING_INVALID_QUERY_PARAMETER",  "Query parameter value in query string is invalid (JSON error code: 2121985)" } },
    //{ 0x82206102,{ "SCE_NP_WEBAPI_SERVER_ERROR_GROUP_MESSAGING_INVALID_QUERY_PARAMETER_COMBINATION",  "Query parameter combination in query string is invalid (JSON error code: 2121986)" } },
    //{ 0x82206103,{ "SCE_NP_WEBAPI_SERVER_ERROR_GROUP_MESSAGING_UNAVAILABLE_QUERY_PARAMETER_FOR_RESOURCE", "Specified query parameter cannot be used for the specified resource (JSON error code: 2121987)" } },
    //{ 0x82206104,{ "SCE_NP_WEBAPI_SERVER_ERROR_GROUP_MESSAGING_INVALID_PARAMETER_IN_URL", "Parameter section value included in URL is invalid (JSON error code: 2121988)" } },
    //{ 0x82206105,{ "SCE_NP_WEBAPI_SERVER_ERROR_GROUP_MESSAGING_MANDATORY_QUERY_PARAMETER_MISSING",    "Query parameter required for query string does not exist (JSON error code: 2121989)" } },
    //{ 0x82206140,{ "SCE_NP_WEBAPI_SERVER_ERROR_GROUP_MESSAGING_INVALID_HEADER",   "Header value for request header is invalid (JSON error code: 2122048)" } },
    //{ 0x82206141,{ "SCE_NP_WEBAPI_SERVER_ERROR_GROUP_MESSAGING_HEADER_REQUIRED",  "Header required for request header does not exist (JSON error code: 2122049)" } },
    //{ 0x82206180,{ "SCE_NP_WEBAPI_SERVER_ERROR_GROUP_MESSAGING_INVALID_BODY", "Details are unknown, but request body value is invalid (JSON error code: 2122112)" } },
    //{ 0x82206181,{ "SCE_NP_WEBAPI_SERVER_ERROR_GROUP_MESSAGING_NULL_VALUE_NOT_ALLOWED",   "A member with a null value in request body exists (JSON error code: 2122113)" } },
    //{ 0x82206182,{ "SCE_NP_WEBAPI_SERVER_ERROR_GROUP_MESSAGING_INVALID_BODY_PARAMETER",   "Request body member value is invalid (JSON error code: 2122114)" } },
    //{ 0x82206183,{ "SCE_NP_WEBAPI_SERVER_ERROR_GROUP_MESSAGING_INVALID_BODY_PARAMETER_LIST_LENGTH",   "Number of elements for request body array type members is invalid (JSON error code: 2122115)" } },
    //{ 0x82206184,{ "SCE_NP_WEBAPI_SERVER_ERROR_GROUP_MESSAGING_INVALID_BODY_PARAMETER_COMBINATION",   "Request body member combination is invalid (JSON error code: 2122116)" } },
    //{ 0x82206185,{ "SCE_NP_WEBAPI_SERVER_ERROR_GROUP_MESSAGING_BLOCKED_USER_EXISTS",  "Blocked user can't be specified (JSON error code: 2122117)" } },
    //{ 0x82206186,{ "SCE_NP_WEBAPI_SERVER_ERROR_GROUP_MESSAGING_MANDATORY_BODY_PARAMETER_MISSING", "Member required for request body does not exist (JSON error code: 2122118)" } },
    //{ 0x82206187,{ "SCE_NP_WEBAPI_SERVER_ERROR_GROUP_MESSAGING_INVALID_MULTIPART_HEADER", "Parameter for multipart header in request body is invalid (JSON error code: 2122119)" } },
    //{ 0x82206188,{ "SCE_NP_WEBAPI_SERVER_ERROR_GROUP_MESSAGING_MANDATORY_MULTIPART_HEADER_MISSING",   "Member required for multipart header parameter in request body does not exist (JSON error code: 2122120)" } },
    //{ 0x82206200,{ "SCE_NP_WEBAPI_SERVER_ERROR_GROUP_MESSAGING_ACCESS_TOKEN_REQUIRED",    "No access token (JSON error code: 2122240)" } },
    //{ 0x82206201,{ "SCE_NP_WEBAPI_SERVER_ERROR_GROUP_MESSAGING_INVALID_ACCESS_TOKEN", "Access token is an invalid value or is corrupted (JSON error code: 2122241)" } },
    //{ 0x82206202,{ "SCE_NP_WEBAPI_SERVER_ERROR_GROUP_MESSAGING_EXPIRED_ACCESS_TOKEN", "Access token is expired (JSON error code: 2122242)" } },
    //{ 0x82206206,{ "SCE_NP_WEBAPI_SERVER_ERROR_GROUP_MESSAGING_NOT_AUTHORIZED",   "Not authorized to access specified resource or use query parameter (JSON error code: 2122246)" } },
    //{ 0x82206208,{ "SCE_NP_WEBAPI_SERVER_ERROR_GROUP_MESSAGING_BANNED_USER",  "Banned user (JSON error code: 2122248)" } },
    //{ 0x82206209,{ "SCE_NP_WEBAPI_SERVER_ERROR_GROUP_MESSAGING_BANNED_DEVICE",    "Banned device (JSON error code: 2122249)" } },
    //{ 0x8220620B,{ "SCE_NP_WEBAPI_SERVER_ERROR_GROUP_MESSAGING_RATE_LIMIT_EXCEEDED",  "API rate limit was exceeded (JSON error code: 2122251)" } },
    //{ 0x8220620D,{ "SCE_NP_WEBAPI_SERVER_ERROR_GROUP_MESSAGING_NOT_AUTHORIZED_ACCESS_TOKEN",  "Access token was obtained with an invalid procedure (JSON error code: 2122253)" } },
    //{ 0x8220620E,{ "SCE_NP_WEBAPI_SERVER_ERROR_GROUP_MESSAGING_NEED_TO_UPGRADE",  "Account needs to upgrade (JSON error code: 2122254)" } },
    //{ 0x82206210,{ "SCE_NP_WEBAPI_SERVER_ERROR_GROUP_MESSAGING_USERS_ACCESS_TOKEN_REQUIRED",  "The API which doesn't permit an access with access token authenticated only with client credential. (JSON error code: 2122256)" } },
    //{ 0x82206211,{ "SCE_NP_WEBAPI_SERVER_ERROR_GROUP_MESSAGING_ACCESS_DENIED_DUE_TO_PARENTAL_CONTROL_SETTINGS",   "Access denied due to parental control settings (JSON error code: 2122257)" } },
    //{ 0x82206300,{ "SCE_NP_WEBAPI_SERVER_ERROR_GROUP_MESSAGING_UNEXPECTED_ERROR", "Unexpected error (JSON error code: 2122496)" } },
    //{ 0x82206301,{ "SCE_NP_WEBAPI_SERVER_ERROR_GROUP_MESSAGING_INTERNAL_SERVER_ERROR",    "Internal error of the server (JSON error code: 2122497)" } },
    //{ 0x82206302,{ "SCE_NP_WEBAPI_SERVER_ERROR_GROUP_MESSAGING_SERVICE_TEMPORARILY_UNAVAILABLE",  "Service has been temporarily stopped (JSON error code: 2122498)" } },
    //{ 0x82206303,{ "SCE_NP_WEBAPI_SERVER_ERROR_GROUP_MESSAGING_SERVER_BUSY",  "Server overload (JSON error code: 2122499)" } },
    //{ 0x82206304,{ "SCE_NP_WEBAPI_SERVER_ERROR_GROUP_MESSAGING_AUTHORIZATION_SERVER_ERROR",   "Authentication/authorization server error  (JSON error code: 2122500)" } },
    //{ 0x82206340,{ "SCE_NP_WEBAPI_SERVER_ERROR_GROUP_MESSAGING_UNDER_MAINTENANCE",    "Server is under maintenance (JSON error code: 2122560)" } },
    //{ 0x82206341,{ "SCE_NP_WEBAPI_SERVER_ERROR_GROUP_MESSAGING_SERVICE_CLOSED",   "Service has closed (JSON error code: 2122561)" } },
    //{ 0x82206342,{ "SCE_NP_WEBAPI_SERVER_ERROR_GROUP_MESSAGING_SERVICE_NOT_READY",    "Service is not ready (JSON error code: 2122562)" } },
    //{ 0x82206380,{ "SCE_NP_WEBAPI_SERVER_ERROR_GROUP_MESSAGING_UNKNOWN_ERROR",    "Unknown error (JSON error code: 2122624)" } },
    //{ 0x82206400,{ "SCE_NP_WEBAPI_SERVER_ERROR_GROUP_MESSAGING_TOO_LARGE_IMAGE_DATA", "Image data size is too large (JSON error code: 2122752)" } },
    //{ 0x82206802,{ "SCE_NP_WEBAPI_SERVER_ERROR_GROUP_MESSAGING_TOO_LARGE_VOICE_DATA", "Voice data size is too large (JSON error code: 2123778)" } },
    //{ 0x82206803,{ "SCE_NP_WEBAPI_SERVER_ERROR_GROUP_MESSAGING_ALREADY_GROUP_MEMBER", "Already member of the message group (JSON error code: 2123779)" } },
    //{ 0x82206804,{ "SCE_NP_WEBAPI_SERVER_ERROR_GROUP_MESSAGING_EXCEEDED_GROUP_MEMBERS_LIMIT", "Limit of message group members was exceeded (JSON error code: 2123780)" } },
    //{ 0x82207001,{ "SCE_NP_WEBAPI_SERVER_ERROR_NOTIFICATION_LIST_BAD_REQUEST",    "Details are unknown, but an invalid value was included in request (header, body, query string, etc.) (JSON error code: 2125825)" } },
    //{ 0x82207002,{ "SCE_NP_WEBAPI_SERVER_ERROR_NOTIFICATION_LIST_UNSUPPORTED_API_VERSION",    "Unsupported API version (JSON error code: 2125826)" } },
    //{ 0x82207003,{ "SCE_NP_WEBAPI_SERVER_ERROR_NOTIFICATION_LIST_TOO_LARGE_BODY", "Request body is too long (JSON error code: 2125827)" } },
    //{ 0x82207004,{ "SCE_NP_WEBAPI_SERVER_ERROR_NOTIFICATION_LIST_INVALID_NP_ENVIRONMENT", "Environment name is invalid (JSON error code: 2125828)" } },
    //{ 0x8220700A,{ "SCE_NP_WEBAPI_SERVER_ERROR_NOTIFICATION_LIST_INVALID_OAUTH_CLIENT_ID",    "OAuth client ID is invalid (JSON error code: 2125834)" } },
    //{ 0x8220700C,{ "SCE_NP_WEBAPI_SERVER_ERROR_NOTIFICATION_LIST_USER_NOT_FOUND", "Target user does not exist (JSON error code: 2125836)" } },
    //{ 0x8220700D,{ "SCE_NP_WEBAPI_SERVER_ERROR_NOTIFICATION_LIST_RESOURCE_NOT_FOUND", "Target resource does not exist (JSON error code: 2125837)" } },
    //{ 0x8220700E,{ "SCE_NP_WEBAPI_SERVER_ERROR_NOTIFICATION_LIST_ACCESS_DENIED_BY_RESOURCE_OWNERSHIP",    "Access attempted by a non-owner for a resource that only the resource owner can access. For example, attempted to obtain a friend list with presence information of another user. (JSON error code: 2125838)" } },
    //{ 0x82207100,{ "SCE_NP_WEBAPI_SERVER_ERROR_NOTIFICATION_LIST_INVALID_QUERY_STRING",   "Details are unknown, but an value in query string is invalid (JSON error code: 2126080)" } },
    //{ 0x82207101,{ "SCE_NP_WEBAPI_SERVER_ERROR_NOTIFICATION_LIST_INVALID_QUERY_PARAMETER",    "Query parameter value in query string is invalid (JSON error code: 2126081)" } },
    //{ 0x82207102,{ "SCE_NP_WEBAPI_SERVER_ERROR_NOTIFICATION_LIST_INVALID_QUERY_PARAMETER_COMBINATION",    "Query parameter combination in query string is invalid (JSON error code: 2126082)" } },
    //{ 0x82207103,{ "SCE_NP_WEBAPI_SERVER_ERROR_NOTIFICATION_LIST_UNAVAILABLE_QUERY_PARAMETER_FOR_RESOURCE",   "Specified query parameter cannot be used for the specified resource (JSON error code: 2126083)" } },
    //{ 0x82207104,{ "SCE_NP_WEBAPI_SERVER_ERROR_NOTIFICATION_LIST_INVALID_PARAMETER_IN_URL",   "Parameter section value included in URL is invalid (JSON error code: 2126084)" } },
    //{ 0x82207105,{ "SCE_NP_WEBAPI_SERVER_ERROR_NOTIFICATION_LIST_MANDATORY_QUERY_PARAMETER_MISSING",  "Query parameter required for query string does not exist (JSON error code: 2126085)" } },
    //{ 0x82207140,{ "SCE_NP_WEBAPI_SERVER_ERROR_NOTIFICATION_LIST_INVALID_HEADER", "Header value for request header is invalid (JSON error code: 2126144)" } },
    //{ 0x82207141,{ "SCE_NP_WEBAPI_SERVER_ERROR_NOTIFICATION_LIST_HEADER_REQUIRED",    "Header required for request header does not exist (JSON error code: 2126145)" } },
    //{ 0x82207180,{ "SCE_NP_WEBAPI_SERVER_ERROR_NOTIFICATION_LIST_INVALID_BODY",   "Details are unknown, but request body value is invalid (JSON error code: 2126208)" } },
    //{ 0x82207181,{ "SCE_NP_WEBAPI_SERVER_ERROR_NOTIFICATION_LIST_NULL_VALUE_NOT_ALLOWED", "A member with a null value in request body exists (JSON error code: 2126209)" } },
    //{ 0x82207182,{ "SCE_NP_WEBAPI_SERVER_ERROR_NOTIFICATION_LIST_INVALID_BODY_PARAMETER", "Request body member value is invalid (JSON error code: 2126210)" } },
    //{ 0x82207183,{ "SCE_NP_WEBAPI_SERVER_ERROR_NOTIFICATION_LIST_INVALID_BODY_PARAMETER_LIST_LENGTH", "Number of elements for request body array type members is invalid (JSON error code: 2126211)" } },
    //{ 0x82207184,{ "SCE_NP_WEBAPI_SERVER_ERROR_NOTIFICATION_LIST_INVALID_BODY_PARAMETER_COMBINATION", "Request body member combination is invalid (JSON error code: 2126212)" } },
    //{ 0x82207186,{ "SCE_NP_WEBAPI_SERVER_ERROR_NOTIFICATION_LIST_MANDATORY_BODY_PARAMETER_MISSING",   "Member required for request body does not exist (JSON error code: 2126214)" } },
    //{ 0x82207200,{ "SCE_NP_WEBAPI_SERVER_ERROR_NOTIFICATION_LIST_ACCESS_TOKEN_REQUIRED",  "No access token (JSON error code: 2126336)" } },
    //{ 0x82207201,{ "SCE_NP_WEBAPI_SERVER_ERROR_NOTIFICATION_LIST_INVALID_ACCESS_TOKEN",   "Access token is an invalid value or is corrupted (JSON error code: 2126337)" } },
    //{ 0x82207202,{ "SCE_NP_WEBAPI_SERVER_ERROR_NOTIFICATION_LIST_EXPIRED_ACCESS_TOKEN",   "Access token is expired (JSON error code: 2126338)" } },
    //{ 0x82207206,{ "SCE_NP_WEBAPI_SERVER_ERROR_NOTIFICATION_LIST_NOT_AUTHORIZED", "Not authorized to access specified resource or use query parameter (JSON error code: 2126342)" } },
    //{ 0x82207208,{ "SCE_NP_WEBAPI_SERVER_ERROR_NOTIFICATION_LIST_BANNED_USER",    "Banned user (JSON error code: 2126344)" } },
    //{ 0x82207209,{ "SCE_NP_WEBAPI_SERVER_ERROR_NOTIFICATION_LIST_BANNED_DEVICE",  "Banned device (JSON error code: 2126345)" } },
    //{ 0x8220720B,{ "SCE_NP_WEBAPI_SERVER_ERROR_NOTIFICATION_LIST_RATE_LIMIT_EXCEEDED",    "API rate limit was exceeded (JSON error code: 2126347)" } },
    //{ 0x8220720D,{ "SCE_NP_WEBAPI_SERVER_ERROR_NOTIFICATION_LIST_NOT_AUTHORIZED_ACCESS_TOKEN",    "Access token was obtained with an invalid procedure (JSON error code: 2126349)" } },
    //{ 0x8220720E,{ "SCE_NP_WEBAPI_SERVER_ERROR_NOTIFICATION_LIST_NEED_TO_UPGRADE",    "Account needs to upgrade (JSON error code: 2126350)" } },
    //{ 0x82207210,{ "SCE_NP_WEBAPI_SERVER_ERROR_NOTIFICATION_LIST_USERS_ACCESS_TOKEN_REQUIRED",    "The API which doesn't permit an access with access token authenticated only with client credential. (JSON error code: 2126352)" } },
    //{ 0x82207300,{ "SCE_NP_WEBAPI_SERVER_ERROR_NOTIFICATION_LIST_UNEXPECTED_ERROR",   "Unexpected error (JSON error code: 2126592)" } },
    //{ 0x82207301,{ "SCE_NP_WEBAPI_SERVER_ERROR_NOTIFICATION_LIST_INTERNAL_SERVER_ERROR",  "Internal error of the server (JSON error code: 2126593)" } },
    //{ 0x82207302,{ "SCE_NP_WEBAPI_SERVER_ERROR_NOTIFICATION_LIST_SERVICE_TEMPORARILY_UNAVAILABLE",    "Service has been temporarily stopped (JSON error code: 2126594)" } },
    //{ 0x82207303,{ "SCE_NP_WEBAPI_SERVER_ERROR_NOTIFICATION_LIST_SERVER_BUSY",    "Server overload (JSON error code: 2126595)" } },
    //{ 0x82207304,{ "SCE_NP_WEBAPI_SERVER_ERROR_NOTIFICATION_LIST_AUTHORIZATION_SERVER_ERROR", "Authentication/authorization server error  (JSON error code: 2126596)" } },
    //{ 0x82207340,{ "SCE_NP_WEBAPI_SERVER_ERROR_NOTIFICATION_LIST_UNDER_MAINTENANCE",  "Server is under maintenance (JSON error code: 2126656)" } },
    //{ 0x82207341,{ "SCE_NP_WEBAPI_SERVER_ERROR_NOTIFICATION_LIST_SERVICE_CLOSED", "Service has closed (JSON error code: 2126657)" } },
    //{ 0x82207380,{ "SCE_NP_WEBAPI_SERVER_ERROR_NOTIFICATION_LIST_UNKNOWN_ERROR",  "Unknown error (JSON error code: 2126720)" } },
    //{ 0x8220A001,{ "SCE_NP_WEBAPI_SERVER_ERROR_TROPHY_BAD_REQUEST",   "Details are unknown, but an invalid value was included in request (header, body, query string, etc.) (JSON error code: 2138113)" } },
    //{ 0x8220A002,{ "SCE_NP_WEBAPI_SERVER_ERROR_TROPHY_UNSUPPORTED_API_VERSION",   "Unsupported API version (JSON error code: 2138114)" } },
    //{ 0x8220A003,{ "SCE_NP_WEBAPI_SERVER_ERROR_TROPHY_TOO_LARGE_BODY",    "Request body is too long (JSON error code: 2138115)" } },
    //{ 0x8220A004,{ "SCE_NP_WEBAPI_SERVER_ERROR_TROPHY_INVALID_NP_ENVIRONMENT",    "Environment name is invalid (JSON error code: 2138116)" } },
    //{ 0x8220A005,{ "SCE_NP_WEBAPI_SERVER_ERROR_TROPHY_INVALID_NP_TITLE_ID",   "NP Title ID is invalid (JSON error code: 2138117)" } },
    //{ 0x8220A006,{ "SCE_NP_WEBAPI_SERVER_ERROR_TROPHY_INVALID_NP_SERVICE_LABEL",  "NP Service Label is invalid (JSON error code: 2138118)" } },
    //{ 0x8220A007,{ "SCE_NP_WEBAPI_SERVER_ERROR_TROPHY_INVALID_NP_COMMUNICATION_ID",   "NP Communication ID is invalid (JSON error code: 2138119)" } },
    //{ 0x8220A00A,{ "SCE_NP_WEBAPI_SERVER_ERROR_TROPHY_INVALID_OAUTH_CLIENT_ID",   "OAuth client ID is invalid (JSON error code: 2138122)" } },
    //{ 0x8220A00C,{ "SCE_NP_WEBAPI_SERVER_ERROR_TROPHY_USER_NOT_FOUND",    "Target user does not exist (JSON error code: 2138124)" } },
    //{ 0x8220A00D,{ "SCE_NP_WEBAPI_SERVER_ERROR_TROPHY_RESOURCE_NOT_FOUND",    "Target resource does not exist (JSON error code: 2138125)" } },
    //{ 0x8220A00E,{ "SCE_NP_WEBAPI_SERVER_ERROR_TROPHY_ACCESS_DENIED_BY_RESOURCE_OWNERSHIP",   "Access attempted by a non-owner for a resource that only the resource owner can access. For example, attempted to obtain a friend list with presence information of another user. (JSON error code: 2138126)" } },
    //{ 0x8220A100,{ "SCE_NP_WEBAPI_SERVER_ERROR_TROPHY_INVALID_QUERY_STRING",  "Details are unknown, but an value in query string is invalid (JSON error code: 2138368)" } },
    //{ 0x8220A101,{ "SCE_NP_WEBAPI_SERVER_ERROR_TROPHY_INVALID_QUERY_PARAMETER",   "Query parameter value in query string is invalid (JSON error code: 2138369)" } },
    //{ 0x8220A102,{ "SCE_NP_WEBAPI_SERVER_ERROR_TROPHY_INVALID_QUERY_PARAMETER_COMBINATION",   "Query parameter combination in query string is invalid (JSON error code: 2138370)" } },
    //{ 0x8220A103,{ "SCE_NP_WEBAPI_SERVER_ERROR_TROPHY_UNAVAILABLE_QUERY_PARAMETER_FOR_RESOURCE",  "Specified query parameter cannot be used for the specified resource (JSON error code: 2138371)" } },
    //{ 0x8220A104,{ "SCE_NP_WEBAPI_SERVER_ERROR_TROPHY_INVALID_PARAMETER_IN_URL",  "Parameter section value included in URL is invalid (JSON error code: 2138372)" } },
    //{ 0x8220A105,{ "SCE_NP_WEBAPI_SERVER_ERROR_TROPHY_MANDATORY_QUERY_PARAMETER_MISSING", "Query parameter required for query string does not exist (JSON error code: 2138373)" } },
    //{ 0x8220A140,{ "SCE_NP_WEBAPI_SERVER_ERROR_TROPHY_INVALID_HEADER",    "Header value for request header is invalid (JSON error code: 2138432)" } },
    //{ 0x8220A141,{ "SCE_NP_WEBAPI_SERVER_ERROR_TROPHY_HEADER_REQUIRED",   "Header required for request header does not exist (JSON error code: 2138433)" } },
    //{ 0x8220A180,{ "SCE_NP_WEBAPI_SERVER_ERROR_TROPHY_INVALID_BODY",  "Details are unknown, but request body value is invalid (JSON error code: 2138496)" } },
    //{ 0x8220A181,{ "SCE_NP_WEBAPI_SERVER_ERROR_TROPHY_NULL_VALUE_NOT_ALLOWED",    "A member with a null value in request body exists (JSON error code: 2138497)" } },
    //{ 0x8220A182,{ "SCE_NP_WEBAPI_SERVER_ERROR_TROPHY_INVALID_BODY_PARAMETER",    "Request body member value is invalid (JSON error code: 2138498)" } },
    //{ 0x8220A183,{ "SCE_NP_WEBAPI_SERVER_ERROR_TROPHY_INVALID_BODY_PARAMETER_LIST_LENGTH",    "Number of elements for request body array type members is invalid (JSON error code: 2138499)" } },
    //{ 0x8220A184,{ "SCE_NP_WEBAPI_SERVER_ERROR_TROPHY_INVALID_BODY_PARAMETER_COMBINATION",    "Request body member combination is invalid (JSON error code: 2138500)" } },
    //{ 0x8220A185,{ "SCE_NP_WEBAPI_SERVER_ERROR_TROPHY_BLOCKED_USER_EXISTS",   "Blocked user can't be specified (JSON error code: 2138501)" } },
    //{ 0x8220A186,{ "SCE_NP_WEBAPI_SERVER_ERROR_TROPHY_MANDATORY_BODY_PARAMETER_MISSING",  "Member required for request body does not exist (JSON error code: 2138502)" } },
    //{ 0x8220A187,{ "SCE_NP_WEBAPI_SERVER_ERROR_TROPHY_INVALID_MULTIPART_HEADER",  "Parameter for multipart header in request body is invalid (JSON error code: 2138503)" } },
    //{ 0x8220A188,{ "SCE_NP_WEBAPI_SERVER_ERROR_TROPHY_MANDATORY_MULTIPART_HEADER_MISSING",    "Member required for multipart header parameter in request body does not exist (JSON error code: 2138504)" } },
    //{ 0x8220A200,{ "SCE_NP_WEBAPI_SERVER_ERROR_TROPHY_ACCESS_TOKEN_REQUIRED", "No access token (JSON error code: 2138624)" } },
    //{ 0x8220A201,{ "SCE_NP_WEBAPI_SERVER_ERROR_TROPHY_INVALID_ACCESS_TOKEN",  "Access token is an invalid value or is corrupted (JSON error code: 2138625)" } },
    //{ 0x8220A202,{ "SCE_NP_WEBAPI_SERVER_ERROR_TROPHY_EXPIRED_ACCESS_TOKEN",  "Access token is expired (JSON error code: 2138626)" } },
    //{ 0x8220A206,{ "SCE_NP_WEBAPI_SERVER_ERROR_TROPHY_NOT_AUTHORIZED",    "Not authorized to access specified resource or use query parameter (JSON error code: 2138630)" } },
    //{ 0x8220A207,{ "SCE_NP_WEBAPI_SERVER_ERROR_TROPHY_BANNED_APPLICATION",    "Banned title (JSON error code: 2138631)" } },
    //{ 0x8220A208,{ "SCE_NP_WEBAPI_SERVER_ERROR_TROPHY_BANNED_USER",   "Banned user (JSON error code: 2138632)" } },
    //{ 0x8220A209,{ "SCE_NP_WEBAPI_SERVER_ERROR_TROPHY_BANNED_DEVICE", "Banned device (JSON error code: 2138633)" } },
    //{ 0x8220A20A,{ "SCE_NP_WEBAPI_SERVER_ERROR_TROPHY_ACCESS_DENIED_DUE_TO_TITILE_MISMATCH",  "Access to resource not possible since title set for the presence information does not match (JSON error code: 2138634)" } },
    //{ 0x8220A20B,{ "SCE_NP_WEBAPI_SERVER_ERROR_TROPHY_RATE_LIMIT_EXCEEDED",   "API rate limit was exceeded (JSON error code: 2138635)" } },
    //{ 0x8220A20C,{ "SCE_NP_WEBAPI_SERVER_ERROR_TROPHY_ACCESS_DENIED_BY_PRIVACY_LEVEL",    "Access was denied due to target user privacy setting (JSON error code: 2138636)" } },
    //{ 0x8220A20D,{ "SCE_NP_WEBAPI_SERVER_ERROR_TROPHY_NOT_AUTHORIZED_ACCESS_TOKEN",   "Access token was obtained with an invalid procedure (JSON error code: 2138637)" } },
    //{ 0x8220A20E,{ "SCE_NP_WEBAPI_SERVER_ERROR_TROPHY_NEED_TO_UPGRADE",   "Account needs to upgrade (JSON error code: 2138638)" } },
    //{ 0x8220A210,{ "SCE_NP_WEBAPI_SERVER_ERROR_TROPHY_USERS_ACCESS_TOKEN_REQUIRED",   "The API which doesn't permit an access with access token authenticated only with client credential. (JSON error code: 2138640)" } },
    //{ 0x8220A280,{ "SCE_NP_WEBAPI_SERVER_ERROR_TROPHY_UNKNOWN_CLIENT",    "Client ID for access token is invalid (JSON error code: 2138752)" } },
    //{ 0x8220A281,{ "SCE_NP_WEBAPI_SERVER_ERROR_TROPHY_NP_TITLE_ID_NOT_FOUND", "Title does not exist (JSON error code: 2138753)" } },
    //{ 0x8220A282,{ "SCE_NP_WEBAPI_SERVER_ERROR_TROPHY_NP_SERVICE_LABEL_NOT_FOUND",    "NP Service Label does not exist (JSON error code: 2138754)" } },
    //{ 0x8220A283,{ "SCE_NP_WEBAPI_SERVER_ERROR_TROPHY_NOT_AUTHORIZED_APPLICATION",    "This title cannot be used for the trophy service (JSON error code: 2138755)" } },
    //{ 0x8220A284,{ "SCE_NP_WEBAPI_SERVER_ERROR_TROPHY_NP_COMMUNICATION_ID_NOT_FOUND", "NP Communication ID does not exist (JSON error code: 2138756)" } },
    //{ 0x8220A300,{ "SCE_NP_WEBAPI_SERVER_ERROR_TROPHY_UNEXPECTED_ERROR",  "Unexpected error (JSON error code: 2138880)" } },
    //{ 0x8220A301,{ "SCE_NP_WEBAPI_SERVER_ERROR_TROPHY_INTERNAL_SERVER_ERROR", "Internal error of the server (JSON error code: 2138881)" } },
    //{ 0x8220A302,{ "SCE_NP_WEBAPI_SERVER_ERROR_TROPHY_SERVICE_TEMPORARILY_UNAVAILABLE",   "Service has been temporarily stopped (JSON error code: 2138882)" } },
    //{ 0x8220A303,{ "SCE_NP_WEBAPI_SERVER_ERROR_TROPHY_SERVER_BUSY",   "Server overload (JSON error code: 2138883)" } },
    //{ 0x8220A304,{ "SCE_NP_WEBAPI_SERVER_ERROR_TROPHY_AUTHORIZATION_SERVER_ERROR",    "Authentication/authorization server error  (JSON error code: 2138884)" } },
    //{ 0x8220A340,{ "SCE_NP_WEBAPI_SERVER_ERROR_TROPHY_UNDER_MAINTENANCE", "Server is under maintenance (JSON error code: 2138944)" } },
    //{ 0x8220A341,{ "SCE_NP_WEBAPI_SERVER_ERROR_TROPHY_SERVICE_CLOSED",    "Service has closed (JSON error code: 2138945)" } },
    //{ 0x8220A380,{ "SCE_NP_WEBAPI_SERVER_ERROR_TROPHY_UNKNOWN_ERROR", "Unknown error (JSON error code: 2139008)" } },
    //{ 0x8220C001,{ "SCE_NP_WEBAPI_SERVER_ERROR_TSS_BAD_REQUEST",  "Details are unknown, but an invalid value was included in request (header, body, query string, etc.) (JSON error code: 2146305)" } },
    //{ 0x8220C002,{ "SCE_NP_WEBAPI_SERVER_ERROR_TSS_UNSUPPORTED_API_VERSION",  "Unsupported API version (JSON error code: 2146306)" } },
    //{ 0x8220C003,{ "SCE_NP_WEBAPI_SERVER_ERROR_TSS_TOO_LARGE_BODY",   "Request body is too long (JSON error code: 2146307)" } },
    //{ 0x8220C004,{ "SCE_NP_WEBAPI_SERVER_ERROR_TSS_INVALID_NP_ENVIRONMENT",   "Environment name is invalid (JSON error code: 2146308)" } },
    //{ 0x8220C005,{ "SCE_NP_WEBAPI_SERVER_ERROR_TSS_INVALID_NP_TITLE_ID",  "NP Title ID is invalid (JSON error code: 2146309)" } },
    //{ 0x8220C006,{ "SCE_NP_WEBAPI_SERVER_ERROR_TSS_INVALID_NP_SERVICE_LABEL", "NP Service Label is invalid (JSON error code: 2146310)" } },
    //{ 0x8220C00A,{ "SCE_NP_WEBAPI_SERVER_ERROR_TSS_INVALID_OAUTH_CLIENT_ID",  "OAuth client ID is invalid (JSON error code: 2146314)" } },
    //{ 0x8220C00D,{ "SCE_NP_WEBAPI_SERVER_ERROR_TSS_RESOURCE_NOT_FOUND",   "Target resource does not exist (JSON error code: 2146317)" } },
    //{ 0x8220C00E,{ "SCE_NP_WEBAPI_SERVER_ERROR_TSS_ACCESS_DENIED_BY_RESOURCE_OWNERSHIP",  "Access attempted by a non-owner for a resource that only the resource owner can access. For example, attempted to obtain a friend list with presence information of another user. (JSON error code: 2146318)" } },
    //{ 0x8220C100,{ "SCE_NP_WEBAPI_SERVER_ERROR_TSS_INVALID_QUERY_STRING", "Details are unknown, but an value in query string is invalid (JSON error code: 2146560)" } },
    //{ 0x8220C101,{ "SCE_NP_WEBAPI_SERVER_ERROR_TSS_INVALID_QUERY_PARAMETER",  "Query parameter value in query string is invalid (JSON error code: 2146561)" } },
    //{ 0x8220C102,{ "SCE_NP_WEBAPI_SERVER_ERROR_TSS_INVALID_QUERY_PARAMETER_COMBINATION",  "Query parameter combination in query string is invalid (JSON error code: 2146562)" } },
    //{ 0x8220C103,{ "SCE_NP_WEBAPI_SERVER_ERROR_TSS_UNAVAILABLE_QUERY_PARAMETER_FOR_RESOURCE", "Specified query parameter cannot be used for the specified resource (JSON error code: 2146563)" } },
    //{ 0x8220C104,{ "SCE_NP_WEBAPI_SERVER_ERROR_TSS_INVALID_PARAMETER_IN_URL", "Parameter section value included in URL is invalid (JSON error code: 2146564)" } },
    //{ 0x8220C105,{ "SCE_NP_WEBAPI_SERVER_ERROR_TSS_MANDATORY_QUERY_PARAMETER_MISSING",    "Query parameter required for query string does not exist (JSON error code: 2146565)" } },
    //{ 0x8220C140,{ "SCE_NP_WEBAPI_SERVER_ERROR_TSS_INVALID_HEADER",   "Header value for request header is invalid (JSON error code: 2146624)" } },
    //{ 0x8220C141,{ "SCE_NP_WEBAPI_SERVER_ERROR_TSS_HEADER_REQUIRED",  "Header required for request header does not exist (JSON error code: 2146625)" } },
    //{ 0x8220C180,{ "SCE_NP_WEBAPI_SERVER_ERROR_TSS_INVALID_BODY", "Details are unknown, but request body value is invalid (JSON error code: 2146688)" } },
    //{ 0x8220C181,{ "SCE_NP_WEBAPI_SERVER_ERROR_TSS_NULL_VALUE_NOT_ALLOWED",   "A member with a null value in request body exists (JSON error code: 2146689)" } },
    //{ 0x8220C182,{ "SCE_NP_WEBAPI_SERVER_ERROR_TSS_INVALID_BODY_PARAMETER",   "Request body member value is invalid (JSON error code: 2146690)" } },
    //{ 0x8220C183,{ "SCE_NP_WEBAPI_SERVER_ERROR_TSS_INVALID_BODY_PARAMETER_LIST_LENGTH",   "Number of elements for request body array type members is invalid (JSON error code: 2146691)" } },
    //{ 0x8220C184,{ "SCE_NP_WEBAPI_SERVER_ERROR_TSS_INVALID_BODY_PARAMETER_COMBINATION",   "Request body member combination is invalid (JSON error code: 2146692)" } },
    //{ 0x8220C185,{ "SCE_NP_WEBAPI_SERVER_ERROR_TSS_BLOCKED_USER_EXISTS",  "Blocked user can't be specified (JSON error code: 2146693)" } },
    //{ 0x8220C186,{ "SCE_NP_WEBAPI_SERVER_ERROR_TSS_MANDATORY_BODY_PARAMETER_MISSING", "Member required for request body does not exist (JSON error code: 2146694)" } },
    //{ 0x8220C200,{ "SCE_NP_WEBAPI_SERVER_ERROR_TSS_ACCESS_TOKEN_REQUIRED",    "No access token (JSON error code: 2146816)" } },
    //{ 0x8220C201,{ "SCE_NP_WEBAPI_SERVER_ERROR_TSS_INVALID_ACCESS_TOKEN", "Access token is an invalid value or is corrupted (JSON error code: 2146817)" } },
    //{ 0x8220C202,{ "SCE_NP_WEBAPI_SERVER_ERROR_TSS_EXPIRED_ACCESS_TOKEN", "Access token is expired (JSON error code: 2146818)" } },
    //{ 0x8220C206,{ "SCE_NP_WEBAPI_SERVER_ERROR_TSS_NOT_AUTHORIZED",   "Not authorized to access specified resource or use query parameter (JSON error code: 2146822)" } },
    //{ 0x8220C207,{ "SCE_NP_WEBAPI_SERVER_ERROR_TSS_BANNED_APPLICATION",   "Banned title (JSON error code: 2146823)" } },
    //{ 0x8220C208,{ "SCE_NP_WEBAPI_SERVER_ERROR_TSS_BANNED_USER",  "Banned user (JSON error code: 2146824)" } },
    //{ 0x8220C209,{ "SCE_NP_WEBAPI_SERVER_ERROR_TSS_BANNED_DEVICE",    "Banned device (JSON error code: 2146825)" } },
    //{ 0x8220C20A,{ "SCE_NP_WEBAPI_SERVER_ERROR_TSS_ACCESS_DENIED_DUE_TO_TITILE_MISMATCH", "Access to resource not possible since title set for the presence information does not match (JSON error code: 2146826)" } },
    //{ 0x8220C20B,{ "SCE_NP_WEBAPI_SERVER_ERROR_TSS_RATE_LIMIT_EXCEEDED",  "API rate limit was exceeded (JSON error code: 2146827)" } },
    //{ 0x8220C20D,{ "SCE_NP_WEBAPI_SERVER_ERROR_TSS_NOT_AUTHORIZED_ACCESS_TOKEN",  "Access token was obtained with an invalid procedure (JSON error code: 2146829)" } },
    //{ 0x8220C20E,{ "SCE_NP_WEBAPI_SERVER_ERROR_TSS_NEED_TO_UPGRADE",  "Account needs to upgrade (JSON error code: 2146830)" } },
    //{ 0x8220C210,{ "SCE_NP_WEBAPI_SERVER_ERROR_TSS_USERS_ACCESS_TOKEN_REQUIRED",  "The API which doesn't permit an access with access token authenticated only with client credential. (JSON error code: 2146832)" } },
    //{ 0x8220C280,{ "SCE_NP_WEBAPI_SERVER_ERROR_TSS_UNKNOWN_CLIENT",   "Client ID for access token is invalid (JSON error code: 2146944)" } },
    //{ 0x8220C281,{ "SCE_NP_WEBAPI_SERVER_ERROR_TSS_NP_TITLE_ID_NOT_FOUND",    "Title does not exist (JSON error code: 2146945)" } },
    //{ 0x8220C282,{ "SCE_NP_WEBAPI_SERVER_ERROR_TSS_NP_SERVICE_LABEL_NOT_FOUND",   "NP Service Label does not exist (JSON error code: 2146946)" } },
    //{ 0x8220C283,{ "SCE_NP_WEBAPI_SERVER_ERROR_TSS_NOT_AUTHORIZED_APPLICATION",   "This title cannot be used for the tss (JSON error code: 2146947)" } },
    //{ 0x8220C284,{ "SCE_NP_WEBAPI_SERVER_ERROR_TSS_NP_COMMUNICATION_ID_NOT_FOUND",    "NP Communication ID does not exist (JSON error code: 2146948)" } },
    //{ 0x8220C300,{ "SCE_NP_WEBAPI_SERVER_ERROR_TSS_UNEXPECTED_ERROR", "Unexpected error (JSON error code: 2147072)" } },
    //{ 0x8220C301,{ "SCE_NP_WEBAPI_SERVER_ERROR_TSS_INTERNAL_SERVER_ERROR",    "Internal error of the server (JSON error code: 2147073)" } },
    //{ 0x8220C302,{ "SCE_NP_WEBAPI_SERVER_ERROR_TSS_SERVICE_TEMPORARILY_UNAVAILABLE",  "Service has been temporarily stopped (JSON error code: 2147074)" } },
    //{ 0x8220C303,{ "SCE_NP_WEBAPI_SERVER_ERROR_TSS_SERVER_BUSY",  "Server overload (JSON error code: 2147075)" } },
    //{ 0x8220C304,{ "SCE_NP_WEBAPI_SERVER_ERROR_TSS_AUTHORIZATION_SERVER_ERROR",   "Authentication/authorization server error  (JSON error code: 2147076)" } },
    //{ 0x8220C340,{ "SCE_NP_WEBAPI_SERVER_ERROR_TSS_UNDER_MAINTENANCE",    "Server is under maintenance (JSON error code: 2147136)" } },
    //{ 0x8220C341,{ "SCE_NP_WEBAPI_SERVER_ERROR_TSS_SERVICE_CLOSED",   "Service has closed (JSON error code: 2147137)" } },
    //{ 0x8220C380,{ "SCE_NP_WEBAPI_SERVER_ERROR_TSS_UNKNOWN_ERROR",    "Unknown error (JSON error code: 2147200)" } },
    //{ 0x8220C400,{ "SCE_NP_WEBAPI_SERVER_ERROR_TSS_TOO_LARGE_TSS_FILE",   "Size of tss file exceed limit (JSON error code: 2147328)" } },
    //{ 0x82211001,{ "SCE_NP_WEBAPI_SERVER_ERROR_WORD_FILTER_BAD_REQUEST",  "Details are unknown, but an invalid value was included in request (header, body, query string, etc.) (JSON error code: 2166785)" } },
    //{ 0x82211002,{ "SCE_NP_WEBAPI_SERVER_ERROR_WORD_FILTER_UNSUPPORTED_API_VERSION",  "Unsupported API version (JSON error code: 2166786)" } },
    //{ 0x82211003,{ "SCE_NP_WEBAPI_SERVER_ERROR_WORD_FILTER_TOO_LARGE_BODY",   "Request body is too long (JSON error code: 2166787)" } },
    //{ 0x82211004,{ "SCE_NP_WEBAPI_SERVER_ERROR_WORD_FILTER_INVALID_NP_ENVIRONMENT",   "Environment name is invalid (JSON error code: 2166788)" } },
    //{ 0x82211005,{ "SCE_NP_WEBAPI_SERVER_ERROR_WORD_FILTER_INVALID_NP_TITLE_ID",  "NP Title ID is invalid (JSON error code: 2166789)" } },
    //{ 0x8221100A,{ "SCE_NP_WEBAPI_SERVER_ERROR_WORD_FILTER_INVALID_OAUTH_CLIENT_ID",  "OAuth client ID is invalid (JSON error code: 2166794)" } },
    //{ 0x8221100D,{ "SCE_NP_WEBAPI_SERVER_ERROR_WORD_FILTER_RESOURCE_NOT_FOUND",   "Target resource does not exist (JSON error code: 2166797)" } },
    //{ 0x82211100,{ "SCE_NP_WEBAPI_SERVER_ERROR_WORD_FILTER_INVALID_QUERY_STRING", "Details are unknown, but an value in query string is invalid (JSON error code: 2167040)" } },
    //{ 0x82211101,{ "SCE_NP_WEBAPI_SERVER_ERROR_WORD_FILTER_INVALID_QUERY_PARAMETER",  "Query parameter value in query string is invalid (JSON error code: 2167041)" } },
    //{ 0x82211102,{ "SCE_NP_WEBAPI_SERVER_ERROR_WORD_FILTER_INVALID_QUERY_PARAMETER_COMBINATION",  "Query parameter combination in query string is invalid (JSON error code: 2167042)" } },
    //{ 0x82211103,{ "SCE_NP_WEBAPI_SERVER_ERROR_WORD_FILTER_UNAVAILABLE_QUERY_PARAMETER_FOR_RESOURCE", "Specified query parameter cannot be used for the specified resource (JSON error code: 2167043)" } },
    //{ 0x82211104,{ "SCE_NP_WEBAPI_SERVER_ERROR_WORD_FILTER_INVALID_PARAMETER_IN_URL", "Parameter section value included in URL is invalid (JSON error code: 2167044)" } },
    //{ 0x82211105,{ "SCE_NP_WEBAPI_SERVER_ERROR_WORD_FILTER_MANDATORY_QUERY_PARAMETER_MISSING",    "Query parameter required for query string does not exist (JSON error code: 2167045)" } },
    //{ 0x82211140,{ "SCE_NP_WEBAPI_SERVER_ERROR_WORD_FILTER_INVALID_HEADER",   "Header value for request header is invalid (JSON error code: 2167104)" } },
    //{ 0x82211141,{ "SCE_NP_WEBAPI_SERVER_ERROR_WORD_FILTER_HEADER_REQUIRED",  "Header required for request header does not exist (JSON error code: 2167105)" } },
    //{ 0x82211180,{ "SCE_NP_WEBAPI_SERVER_ERROR_WORD_FILTER_INVALID_BODY", "Details are unknown, but request body value is invalid (JSON error code: 2167168)" } },
    //{ 0x82211181,{ "SCE_NP_WEBAPI_SERVER_ERROR_WORD_FILTER_NULL_VALUE_NOT_ALLOWED",   "A member with a null value in request body exists (JSON error code: 2167169)" } },
    //{ 0x82211182,{ "SCE_NP_WEBAPI_SERVER_ERROR_WORD_FILTER_INVALID_BODY_PARAMETER",   "Request body member value is invalid (JSON error code: 2167170)" } },
    //{ 0x82211183,{ "SCE_NP_WEBAPI_SERVER_ERROR_WORD_FILTER_INVALID_BODY_PARAMETER_LIST_LENGTH",   "Number of elements for request body array type members is invalid (JSON error code: 2167171)" } },
    //{ 0x82211184,{ "SCE_NP_WEBAPI_SERVER_ERROR_WORD_FILTER_INVALID_BODY_PARAMETER_COMBINATION",   "Request body member combination is invalid (JSON error code: 2167172)" } },
    //{ 0x82211186,{ "SCE_NP_WEBAPI_SERVER_ERROR_WORD_FILTER_MANDATORY_BODY_PARAMETER_MISSING", "Member required for request body does not exist (JSON error code: 2167174)" } },
    //{ 0x82211200,{ "SCE_NP_WEBAPI_SERVER_ERROR_WORD_FILTER_ACCESS_TOKEN_REQUIRED",    "No access token (JSON error code: 2167296)" } },
    //{ 0x82211201,{ "SCE_NP_WEBAPI_SERVER_ERROR_WORD_FILTER_INVALID_ACCESS_TOKEN", "Access token is an invalid value or is corrupted (JSON error code: 2167297)" } },
    //{ 0x82211202,{ "SCE_NP_WEBAPI_SERVER_ERROR_WORD_FILTER_EXPIRED_ACCESS_TOKEN", "Access token is expired (JSON error code: 2167298)" } },
    //{ 0x82211206,{ "SCE_NP_WEBAPI_SERVER_ERROR_WORD_FILTER_NOT_AUTHORIZED",   "Not authorized to access specified resource or use query parameter (JSON error code: 2167302)" } },
    //{ 0x82211207,{ "SCE_NP_WEBAPI_SERVER_ERROR_WORD_FILTER_BANNED_APPLICATION",   "Banned title (JSON error code: 2167303)" } },
    //{ 0x82211208,{ "SCE_NP_WEBAPI_SERVER_ERROR_WORD_FILTER_BANNED_USER",  "Banned user (JSON error code: 2167304)" } },
    //{ 0x82211209,{ "SCE_NP_WEBAPI_SERVER_ERROR_WORD_FILTER_BANNED_DEVICE",    "Banned device (JSON error code: 2167305)" } },
    //{ 0x8221120B,{ "SCE_NP_WEBAPI_SERVER_ERROR_WORD_FILTER_RATE_LIMIT_EXCEEDED",  "API rate limit was exceeded (JSON error code: 2167307)" } },
    //{ 0x8221120D,{ "SCE_NP_WEBAPI_SERVER_ERROR_WORD_FILTER_NOT_AUTHORIZED_ACCESS_TOKEN",  "Access token was obtained with an invalid procedure (JSON error code: 2167309)" } },
    //{ 0x8221120E,{ "SCE_NP_WEBAPI_SERVER_ERROR_WORD_FILTER_NEED_TO_UPGRADE",  "Account needs to upgrade (JSON error code: 2167310)" } },
    //{ 0x82211210,{ "SCE_NP_WEBAPI_SERVER_ERROR_WORD_FILTER_USERS_ACCESS_TOKEN_REQUIRED",  "The API which doesn't permit an access with access token authenticated only with client credential. (JSON error code: 2167312)" } },
    //{ 0x82211280,{ "SCE_NP_WEBAPI_SERVER_ERROR_WORD_FILTER_UNKNOWN_CLIENT",   "Client ID for access token is invalid (JSON error code: 2167424)" } },
    //{ 0x82211300,{ "SCE_NP_WEBAPI_SERVER_ERROR_WORD_FILTER_UNEXPECTED_ERROR", "Unexpected error (JSON error code: 2167552)" } },
    //{ 0x82211301,{ "SCE_NP_WEBAPI_SERVER_ERROR_WORD_FILTER_INTERNAL_SERVER_ERROR",    "Internal error of the server (JSON error code: 2167553)" } },
    //{ 0x82211302,{ "SCE_NP_WEBAPI_SERVER_ERROR_WORD_FILTER_SERVICE_TEMPORARILY_UNAVAILABLE",  "Service has been temporarily stopped (JSON error code: 2167554)" } },
    //{ 0x82211303,{ "SCE_NP_WEBAPI_SERVER_ERROR_WORD_FILTER_SERVER_BUSY",  "Server overload (JSON error code: 2167555)" } },
    //{ 0x82211304,{ "SCE_NP_WEBAPI_SERVER_ERROR_WORD_FILTER_AUTHORIZATION_SERVER_ERROR",   "Authentication/authorization server error  (JSON error code: 2167556)" } },
    //{ 0x82211340,{ "SCE_NP_WEBAPI_SERVER_ERROR_WORD_FILTER_UNDER_MAINTENANCE",    "Server is under maintenance (JSON error code: 2167616)" } },
    //{ 0x82211341,{ "SCE_NP_WEBAPI_SERVER_ERROR_WORD_FILTER_SERVICE_CLOSED",   "Service has closed (JSON error code: 2167617)" } },
    //{ 0x82211380,{ "SCE_NP_WEBAPI_SERVER_ERROR_WORD_FILTER_UNKNOWN_ERROR",    "Unknown error (JSON error code: 2167680)" } },
    //{ 0x82212001,{ "SCE_NP_WEBAPI_SERVER_ERROR_SCORE_RANKING_BAD_REQUEST",    "Details are unknown, but an invalid value was included in request (header, body, query string, etc.) (JSON error code: 2170881)" } },
    //{ 0x82212002,{ "SCE_NP_WEBAPI_SERVER_ERROR_SCORE_RANKING_UNSUPPORTED_API_VERSION",    "Unsupported API version (JSON error code: 2170882)" } },
    //{ 0x82212003,{ "SCE_NP_WEBAPI_SERVER_ERROR_SCORE_RANKING_TOO_LARGE_BODY", "Request body is too long (JSON error code: 2170883)" } },
    //{ 0x82212004,{ "SCE_NP_WEBAPI_SERVER_ERROR_SCORE_RANKING_INVALID_NP_ENVIRONMENT", "Environment name is invalid (JSON error code: 2170884)" } },
    //{ 0x82212005,{ "SCE_NP_WEBAPI_SERVER_ERROR_SCORE_RANKING_INVALID_NP_TITLE_ID",    "NP Title ID is invalid (JSON error code: 2170885)" } },
    //{ 0x82212006,{ "SCE_NP_WEBAPI_SERVER_ERROR_SCORE_RANKING_INVALID_NP_SERVICE_LABEL",   "NP Service Label is invalid (JSON error code: 2170886)" } },
    //{ 0x82212007,{ "SCE_NP_WEBAPI_SERVER_ERROR_SCORE_RANKING_INVALID_NP_COMMUNICATION_ID",    "NP Communication ID is invalid (JSON error code: 2170887)" } },
    //{ 0x8221200A,{ "SCE_NP_WEBAPI_SERVER_ERROR_SCORE_RANKING_INVALID_OAUTH_CLIENT_ID",    "OAuth client ID is invalid (JSON error code: 2170890)" } },
    //{ 0x8221200C,{ "SCE_NP_WEBAPI_SERVER_ERROR_SCORE_RANKING_USER_NOT_FOUND", "Target user does not exist (JSON error code: 2170892)" } },
    //{ 0x8221200D,{ "SCE_NP_WEBAPI_SERVER_ERROR_SCORE_RANKING_RESOURCE_NOT_FOUND", "Target resource does not exist (JSON error code: 2170893)" } },
    //{ 0x8221200E,{ "SCE_NP_WEBAPI_SERVER_ERROR_SCORE_RANKING_ACCESS_DENIED_BY_RESOURCE_OWNERSHIP",    "Access attempted by a non-owner for a resource that only the resource owner can access. For example, attempted to obtain a friend list with presence information of another user. (JSON error code: 2170894)" } },
    //{ 0x82212100,{ "SCE_NP_WEBAPI_SERVER_ERROR_SCORE_RANKING_INVALID_QUERY_STRING",   "Details are unknown, but an value in query string is invalid (JSON error code: 2171136)" } },
    //{ 0x82212101,{ "SCE_NP_WEBAPI_SERVER_ERROR_SCORE_RANKING_INVALID_QUERY_PARAMETER",    "Query parameter value in query string is invalid (JSON error code: 2171137)" } },
    //{ 0x82212102,{ "SCE_NP_WEBAPI_SERVER_ERROR_SCORE_RANKING_INVALID_QUERY_PARAMETER_COMBINATION",    "Query parameter combination in query string is invalid (JSON error code: 2171138)" } },
    //{ 0x82212103,{ "SCE_NP_WEBAPI_SERVER_ERROR_SCORE_RANKING_UNAVAILABLE_QUERY_PARAMETER_FOR_RESOURCE",   "Specified query parameter cannot be used for the specified resource (JSON error code: 2171139)" } },
    //{ 0x82212104,{ "SCE_NP_WEBAPI_SERVER_ERROR_SCORE_RANKING_INVALID_PARAMETER_IN_URL",   "Parameter section value included in URL is invalid (JSON error code: 2171140)" } },
    //{ 0x82212105,{ "SCE_NP_WEBAPI_SERVER_ERROR_SCORE_RANKING_MANDATORY_QUERY_PARAMETER_MISSING",  "Query parameter required for query string does not exist (JSON error code: 2171141)" } },
    //{ 0x82212140,{ "SCE_NP_WEBAPI_SERVER_ERROR_SCORE_RANKING_INVALID_HEADER", "Header value for request header is invalid (JSON error code: 2171200)" } },
    //{ 0x82212141,{ "SCE_NP_WEBAPI_SERVER_ERROR_SCORE_RANKING_HEADER_REQUIRED",    "Header required for request header does not exist (JSON error code: 2171201)" } },
    //{ 0x82212180,{ "SCE_NP_WEBAPI_SERVER_ERROR_SCORE_RANKING_INVALID_BODY",   "Details are unknown, but request body value is invalid (JSON error code: 2171264)" } },
    //{ 0x82212181,{ "SCE_NP_WEBAPI_SERVER_ERROR_SCORE_RANKING_NULL_VALUE_NOT_ALLOWED", "A member with a null value in request body exists (JSON error code: 2171265)" } },
    //{ 0x82212182,{ "SCE_NP_WEBAPI_SERVER_ERROR_SCORE_RANKING_INVALID_BODY_PARAMETER", "Request body member value is invalid (JSON error code: 2171266)" } },
    //{ 0x82212183,{ "SCE_NP_WEBAPI_SERVER_ERROR_SCORE_RANKING_INVALID_BODY_PARAMETER_LIST_LENGTH", "Number of elements for request body array type members is invalid (JSON error code: 2171267)" } },
    //{ 0x82212184,{ "SCE_NP_WEBAPI_SERVER_ERROR_SCORE_RANKING_INVALID_BODY_PARAMETER_COMBINATION", "Request body member combination is invalid (JSON error code: 2171268)" } },
    //{ 0x82212185,{ "SCE_NP_WEBAPI_SERVER_ERROR_SCORE_RANKING_BLOCKED_USER_EXISTS",    "Blocked user can't be specified (JSON error code: 2171269)" } },
    //{ 0x82212186,{ "SCE_NP_WEBAPI_SERVER_ERROR_SCORE_RANKING_MANDATORY_BODY_PARAMETER_MISSING",   "Member required for request body does not exist (JSON error code: 2171270)" } },
    //{ 0x82212200,{ "SCE_NP_WEBAPI_SERVER_ERROR_SCORE_RANKING_ACCESS_TOKEN_REQUIRED",  "No access token (JSON error code: 2171392)" } },
    //{ 0x82212201,{ "SCE_NP_WEBAPI_SERVER_ERROR_SCORE_RANKING_INVALID_ACCESS_TOKEN",   "Access token is an invalid value or is corrupted (JSON error code: 2171393)" } },
    //{ 0x82212202,{ "SCE_NP_WEBAPI_SERVER_ERROR_SCORE_RANKING_EXPIRED_ACCESS_TOKEN",   "Access token is expired (JSON error code: 2171394)" } },
    //{ 0x82212206,{ "SCE_NP_WEBAPI_SERVER_ERROR_SCORE_RANKING_NOT_AUTHORIZED", "Not authorized to access specified resource or use query parameter (JSON error code: 2171398)" } },
    //{ 0x82212207,{ "SCE_NP_WEBAPI_SERVER_ERROR_SCORE_RANKING_BANNED_APPLICATION", "Banned title (JSON error code: 2171399)" } },
    //{ 0x82212208,{ "SCE_NP_WEBAPI_SERVER_ERROR_SCORE_RANKING_BANNED_USER",    "Banned user (JSON error code: 2171400)" } },
    //{ 0x82212209,{ "SCE_NP_WEBAPI_SERVER_ERROR_SCORE_RANKING_BANNED_DEVICE",  "Banned device (JSON error code: 2171401)" } },
    //{ 0x8221220A,{ "SCE_NP_WEBAPI_SERVER_ERROR_SCORE_RANKING_ACCESS_DENIED_DUE_TO_TITILE_MISMATCH",   "Access to resource not possible since title set for the presence information does not match (JSON error code: 2171402)" } },
    //{ 0x8221220B,{ "SCE_NP_WEBAPI_SERVER_ERROR_SCORE_RANKING_RATE_LIMIT_EXCEEDED",    "API rate limit was exceeded (JSON error code: 2171403)" } },
    //{ 0x8221220D,{ "SCE_NP_WEBAPI_SERVER_ERROR_SCORE_RANKING_NOT_AUTHORIZED_ACCESS_TOKEN",    "Access token was obtained with an invalid procedure (JSON error code: 2171405)" } },
    //{ 0x8221220E,{ "SCE_NP_WEBAPI_SERVER_ERROR_SCORE_RANKING_NEED_TO_UPGRADE",    "Account needs to upgrade (JSON error code: 2171406)" } },
    //{ 0x82212210,{ "SCE_NP_WEBAPI_SERVER_ERROR_SCORE_RANKING_USERS_ACCESS_TOKEN_REQUIRED",    "The API which doesn't permit an access with access token authenticated only with client credential. (JSON error code: 2171408)" } },
    //{ 0x82212280,{ "SCE_NP_WEBAPI_SERVER_ERROR_SCORE_RANKING_UNKNOWN_CLIENT", "Client ID for access token is invalid (JSON error code: 2171520)" } },
    //{ 0x82212281,{ "SCE_NP_WEBAPI_SERVER_ERROR_SCORE_RANKING_NP_TITLE_ID_NOT_FOUND",  "Title does not exist (JSON error code: 2171521)" } },
    //{ 0x82212282,{ "SCE_NP_WEBAPI_SERVER_ERROR_SCORE_RANKING_NP_SERVICE_LABEL_NOT_FOUND", "NP Service Label does not exist (JSON error code: 2171522)" } },
    //{ 0x82212283,{ "SCE_NP_WEBAPI_SERVER_ERROR_SCORE_RANKING_NOT_AUTHORIZED_APPLICATION", "This title cannot be used for the scoreRanking service (JSON error code: 2171523)" } },
    //{ 0x82212284,{ "SCE_NP_WEBAPI_SERVER_ERROR_SCORE_RANKING_NP_COMMUNICATION_ID_NOT_FOUND",  "NP Communication ID does not exist (JSON error code: 2171524)" } },
    //{ 0x82212300,{ "SCE_NP_WEBAPI_SERVER_ERROR_SCORE_RANKING_UNEXPECTED_ERROR",   "Unexpected error (JSON error code: 2171648)" } },
    //{ 0x82212301,{ "SCE_NP_WEBAPI_SERVER_ERROR_SCORE_RANKING_INTERNAL_SERVER_ERROR",  "Internal error of the server (JSON error code: 2171649)" } },
    //{ 0x82212302,{ "SCE_NP_WEBAPI_SERVER_ERROR_SCORE_RANKING_SERVICE_TEMPORARILY_UNAVAILABLE",    "Service has been temporarily stopped (JSON error code: 2171650)" } },
    //{ 0x82212303,{ "SCE_NP_WEBAPI_SERVER_ERROR_SCORE_RANKING_SERVER_BUSY",    "Server overload (JSON error code: 2171651)" } },
    //{ 0x82212304,{ "SCE_NP_WEBAPI_SERVER_ERROR_SCORE_RANKING_AUTHORIZATION_SERVER_ERROR", "Authentication/authorization server error  (JSON error code: 2171652)" } },
    //{ 0x82212340,{ "SCE_NP_WEBAPI_SERVER_ERROR_SCORE_RANKING_UNDER_MAINTENANCE",  "Server is under maintenance (JSON error code: 2171712)" } },
    //{ 0x82212341,{ "SCE_NP_WEBAPI_SERVER_ERROR_SCORE_RANKING_SERVICE_CLOSED", "Service has closed (JSON error code: 2171713)" } },
    //{ 0x82212342,{ "SCE_NP_WEBAPI_SERVER_ERROR_SCORE_RANKING_SERVICE_NOT_READY",  "Service is not ready (JSON error code: 2171714)" } },
    //{ 0x82212380,{ "SCE_NP_WEBAPI_SERVER_ERROR_SCORE_RANKING_UNKNOWN_ERROR",  "Unknown error (JSON error code: 2171776)" } },
    //{ 0x82213001,{ "SCE_NP_WEBAPI_SERVER_ERROR_TUS_BAD_REQUEST",  "Details are unknown, but an invalid value was included in request (header, body, query string, etc.) (JSON error code: 2174977)" } },
    //{ 0x82213002,{ "SCE_NP_WEBAPI_SERVER_ERROR_TUS_UNSUPPORTED_API_VERSION",  "Unsupported API version (JSON error code: 2174978)" } },
    //{ 0x82213003,{ "SCE_NP_WEBAPI_SERVER_ERROR_TUS_TOO_LARGE_BODY",   "Request body is too long (JSON error code: 2174979)" } },
    //{ 0x82213004,{ "SCE_NP_WEBAPI_SERVER_ERROR_TUS_INVALID_NP_ENVIRONMENT",   "Environment name is invalid (JSON error code: 2174980)" } },
    //{ 0x82213005,{ "SCE_NP_WEBAPI_SERVER_ERROR_TUS_INVALID_NP_TITLE_ID",  "NP Title ID is invalid (JSON error code: 2174981)" } },
    //{ 0x82213006,{ "SCE_NP_WEBAPI_SERVER_ERROR_TUS_INVALID_NP_SERVICE_LABEL", "NP Service Label is invalid (JSON error code: 2174982)" } },
    //{ 0x82213007,{ "SCE_NP_WEBAPI_SERVER_ERROR_TUS_INVALID_NP_COMMUNICATION_ID",  "NP Communication ID is invalid (JSON error code: 2174983)" } },
    //{ 0x8221300A,{ "SCE_NP_WEBAPI_SERVER_ERROR_TUS_INVALID_OAUTH_CLIENT_ID",  "OAuth client ID is invalid (JSON error code: 2174986)" } },
    //{ 0x8221300C,{ "SCE_NP_WEBAPI_SERVER_ERROR_TUS_USER_NOT_FOUND",   "Target user does not exist (JSON error code: 2174988)" } },
    //{ 0x8221300D,{ "SCE_NP_WEBAPI_SERVER_ERROR_TUS_RESOURCE_NOT_FOUND",   "Target resource does not exist (JSON error code: 2174989)" } },
    //{ 0x8221300E,{ "SCE_NP_WEBAPI_SERVER_ERROR_TUS_ACCESS_DENIED_BY_RESOURCE_OWNERSHIP",  "Access attempted by a non-owner for a resource that only the resource owner can access. For example, attempted to obtain a friend list with presence information of another user. (JSON error code: 2174990)" } },
    //{ 0x82213100,{ "SCE_NP_WEBAPI_SERVER_ERROR_TUS_INVALID_QUERY_STRING", "Details are unknown, but an value in query string is invalid (JSON error code: 2175232)" } },
    //{ 0x82213101,{ "SCE_NP_WEBAPI_SERVER_ERROR_TUS_INVALID_QUERY_PARAMETER",  "Query parameter value in query string is invalid (JSON error code: 2175233)" } },
    //{ 0x82213102,{ "SCE_NP_WEBAPI_SERVER_ERROR_TUS_INVALID_QUERY_PARAMETER_COMBINATION",  "Query parameter combination in query string is invalid (JSON error code: 2175234)" } },
    //{ 0x82213103,{ "SCE_NP_WEBAPI_SERVER_ERROR_TUS_UNAVAILABLE_QUERY_PARAMETER_FOR_RESOURCE", "Specified query parameter cannot be used for the specified resource (JSON error code: 2175235)" } },
    //{ 0x82213104,{ "SCE_NP_WEBAPI_SERVER_ERROR_TUS_INVALID_PARAMETER_IN_URL", "Parameter section value included in URL is invalid (JSON error code: 2175236)" } },
    //{ 0x82213105,{ "SCE_NP_WEBAPI_SERVER_ERROR_TUS_MANDATORY_QUERY_PARAMETER_MISSING",    "Query parameter required for query string does not exist (JSON error code: 2175237)" } },
    //{ 0x82213140,{ "SCE_NP_WEBAPI_SERVER_ERROR_TUS_INVALID_HEADER",   "Header value for request header is invalid (JSON error code: 2175296)" } },
    //{ 0x82213141,{ "SCE_NP_WEBAPI_SERVER_ERROR_TUS_HEADER_REQUIRED",  "Header required for request header does not exist (JSON error code: 2175297)" } },
    //{ 0x82213180,{ "SCE_NP_WEBAPI_SERVER_ERROR_TUS_INVALID_BODY", "Details are unknown, but request body value is invalid (JSON error code: 2175360)" } },
    //{ 0x82213181,{ "SCE_NP_WEBAPI_SERVER_ERROR_TUS_NULL_VALUE_NOT_ALLOWED",   "A member with a null value in request body exists (JSON error code: 2175361)" } },
    //{ 0x82213182,{ "SCE_NP_WEBAPI_SERVER_ERROR_TUS_INVALID_BODY_PARAMETER",   "Request body member value is invalid (JSON error code: 2175362)" } },
    //{ 0x82213183,{ "SCE_NP_WEBAPI_SERVER_ERROR_TUS_INVALID_BODY_PARAMETER_LIST_LENGTH",   "Number of elements for request body array type members is invalid (JSON error code: 2175363)" } },
    //{ 0x82213184,{ "SCE_NP_WEBAPI_SERVER_ERROR_TUS_INVALID_BODY_PARAMETER_COMBINATION",   "Request body member combination is invalid (JSON error code: 2175364)" } },
    //{ 0x82213185,{ "SCE_NP_WEBAPI_SERVER_ERROR_TUS_BLOCKED_USER_EXISTS",  "Blocked user can't be specified (JSON error code: 2175365)" } },
    //{ 0x82213186,{ "SCE_NP_WEBAPI_SERVER_ERROR_TUS_MANDATORY_BODY_PARAMETER_MISSING", "Member required for request body does not exist (JSON error code: 2175366)" } },
    //{ 0x82213187,{ "SCE_NP_WEBAPI_SERVER_ERROR_TUS_INVALID_MULTIPART_HEADER", "Parameter for multipart header in request body is invalid (JSON error code: 2175367)" } },
    //{ 0x82213188,{ "SCE_NP_WEBAPI_SERVER_ERROR_TUS_MANDATORY_MULTIPART_HEADER_MISSING",   "Member required for multipart header parameter in request body does not exist (JSON error code: 2175368)" } },
    //{ 0x82213200,{ "SCE_NP_WEBAPI_SERVER_ERROR_TUS_ACCESS_TOKEN_REQUIRED",    "No access token (JSON error code: 2175488)" } },
    //{ 0x82213201,{ "SCE_NP_WEBAPI_SERVER_ERROR_TUS_INVALID_ACCESS_TOKEN", "Access token is an invalid value or is corrupted (JSON error code: 2175489)" } },
    //{ 0x82213202,{ "SCE_NP_WEBAPI_SERVER_ERROR_TUS_EXPIRED_ACCESS_TOKEN", "Access token is expired (JSON error code: 2175490)" } },
    //{ 0x82213206,{ "SCE_NP_WEBAPI_SERVER_ERROR_TUS_NOT_AUTHORIZED",   "Not authorized to access specified resource or use query parameter (JSON error code: 2175494)" } },
    //{ 0x82213207,{ "SCE_NP_WEBAPI_SERVER_ERROR_TUS_BANNED_APPLICATION",   "Banned title (JSON error code: 2175495)" } },
    //{ 0x82213208,{ "SCE_NP_WEBAPI_SERVER_ERROR_TUS_BANNED_USER",  "Banned user (JSON error code: 2175496)" } },
    //{ 0x82213209,{ "SCE_NP_WEBAPI_SERVER_ERROR_TUS_BANNED_DEVICE",    "Banned device (JSON error code: 2175497)" } },
    //{ 0x8221320B,{ "SCE_NP_WEBAPI_SERVER_ERROR_TUS_RATE_LIMIT_EXCEEDED",  "API rate limit was exceeded (JSON error code: 2175499)" } },
    //{ 0x8221320D,{ "SCE_NP_WEBAPI_SERVER_ERROR_TUS_NOT_AUTHORIZED_ACCESS_TOKEN",  "Access token was obtained with an invalid procedure (JSON error code: 2175501)" } },
    //{ 0x8221320E,{ "SCE_NP_WEBAPI_SERVER_ERROR_TUS_NEED_TO_UPGRADE",  "Account needs to upgrade (JSON error code: 2175502)" } },
    //{ 0x82213210,{ "SCE_NP_WEBAPI_SERVER_ERROR_TUS_USERS_ACCESS_TOKEN_REQUIRED",  "The API which doesn't permit an access with access token authenticated only with client credential. (JSON error code: 2175504)" } },
    //{ 0x82213280,{ "SCE_NP_WEBAPI_SERVER_ERROR_TUS_UNKNOWN_CLIENT",   "Client ID for access token is invalid (JSON error code: 2175616)" } },
    //{ 0x82213281,{ "SCE_NP_WEBAPI_SERVER_ERROR_TUS_NP_TITLE_ID_NOT_FOUND",    "Title does not exist (JSON error code: 2175617)" } },
    //{ 0x82213282,{ "SCE_NP_WEBAPI_SERVER_ERROR_TUS_NP_SERVICE_LABEL_NOT_FOUND",   "NP Service Label does not exist (JSON error code: 2175618)" } },
    //{ 0x82213283,{ "SCE_NP_WEBAPI_SERVER_ERROR_TUS_NOT_AUTHORIZED_APPLICATION",   "This title cannot be used for the Management service (JSON error code: 2175619)" } },
    //{ 0x82213284,{ "SCE_NP_WEBAPI_SERVER_ERROR_TUS_NP_COMMUNICATION_ID_NOT_FOUND",    "NP Communication ID does not exist (JSON error code: 2175620)" } },
    //{ 0x82213300,{ "SCE_NP_WEBAPI_SERVER_ERROR_TUS_UNEXPECTED_ERROR", "Unexpected error (JSON error code: 2175744)" } },
    //{ 0x82213301,{ "SCE_NP_WEBAPI_SERVER_ERROR_TUS_INTERNAL_SERVER_ERROR",    "Internal error of the server (JSON error code: 2175745)" } },
    //{ 0x82213302,{ "SCE_NP_WEBAPI_SERVER_ERROR_TUS_SERVICE_TEMPORARILY_UNAVAILABLE",  "Service has been temporarily stopped (JSON error code: 2175746)" } },
    //{ 0x82213303,{ "SCE_NP_WEBAPI_SERVER_ERROR_TUS_SERVER_BUSY",  "Server overload (JSON error code: 2175747)" } },
    //{ 0x82213304,{ "SCE_NP_WEBAPI_SERVER_ERROR_TUS_AUTHORIZATION_SERVER_ERROR",   "Authentication/authorization server error  (JSON error code: 2175748)" } },
    //{ 0x82213340,{ "SCE_NP_WEBAPI_SERVER_ERROR_TUS_UNDER_MAINTENANCE",    "Server is under maintenance (JSON error code: 2175808)" } },
    //{ 0x82213341,{ "SCE_NP_WEBAPI_SERVER_ERROR_TUS_SERVICE_CLOSED",   "Service has closed (JSON error code: 2175809)" } },
    //{ 0x82213342,{ "SCE_NP_WEBAPI_SERVER_ERROR_TUS_SERVICE_NOT_READY",    "Service is not ready (JSON error code: 2175810)" } },
    //{ 0x82213380,{ "SCE_NP_WEBAPI_SERVER_ERROR_TUS_UNKNOWN_ERROR",    "Unknown error (JSON error code: 2175872)" } },
    //{ 0x82213400,{ "SCE_NP_WEBAPI_SERVER_ERROR_TUS_CONDITIONS_NOT_FULFILLED", "Update conditions not fulfilled (JSON error code: 2176000)" } },
    //{ 0x82214001,{ "SCE_NP_WEBAPI_SERVER_ERROR_MANAGEMENT_BAD_REQUEST",   "Details are unknown, but an invalid value was included in request (header, body, query string, etc.) (JSON error code: 2179073)" } },
    //{ 0x82214002,{ "SCE_NP_WEBAPI_SERVER_ERROR_MANAGEMENT_UNSUPPORTED_API_VERSION",   "Unsupported API version (JSON error code: 2179074)" } },
    //{ 0x82214003,{ "SCE_NP_WEBAPI_SERVER_ERROR_MANAGEMENT_TOO_LARGE_BODY",    "Request body is too long (JSON error code: 2179075)" } },
    //{ 0x82214004,{ "SCE_NP_WEBAPI_SERVER_ERROR_MANAGEMENT_INVALID_NP_ENVIRONMENT",    "Environment name is invalid (JSON error code: 2179076)" } },
    //{ 0x82214005,{ "SCE_NP_WEBAPI_SERVER_ERROR_MANAGEMENT_INVALID_NP_TITLE_ID",   "NP Title ID is invalid (JSON error code: 2179077)" } },
    //{ 0x82214006,{ "SCE_NP_WEBAPI_SERVER_ERROR_MANAGEMENT_INVALID_NP_SERVICE_LABEL",  "NP Service Label is invalid (JSON error code: 2179078)" } },
    //{ 0x8221400A,{ "SCE_NP_WEBAPI_SERVER_ERROR_MANAGEMENT_INVALID_OAUTH_CLIENT_ID",   "OAuth client ID is invalid (JSON error code: 2179082)" } },
    //{ 0x8221400C,{ "SCE_NP_WEBAPI_SERVER_ERROR_MANAGEMENT_USER_NOT_FOUND",    "Target user does not exist (JSON error code: 2179084)" } },
    //{ 0x8221400D,{ "SCE_NP_WEBAPI_SERVER_ERROR_MANAGEMENT_RESOURCE_NOT_FOUND",    "Target resource does not exist (JSON error code: 2179085)" } },
    //{ 0x8221400E,{ "SCE_NP_WEBAPI_SERVER_ERROR_MANAGEMENT_ACCESS_DENIED_BY_RESOURCE_OWNERSHIP",   "Access attempted by a non-owner for a resource that only the resource owner can access. For example, attempted to obtain a friend list with presence information of another user. (JSON error code: 2179086)" } },
    //{ 0x82214100,{ "SCE_NP_WEBAPI_SERVER_ERROR_MANAGEMENT_INVALID_QUERY_STRING",  "Details are unknown, but an value in query string is invalid (JSON error code: 2179328)" } },
    //{ 0x82214101,{ "SCE_NP_WEBAPI_SERVER_ERROR_MANAGEMENT_INVALID_QUERY_PARAMETER",   "Query parameter value in query string is invalid (JSON error code: 2179329)" } },
    //{ 0x82214102,{ "SCE_NP_WEBAPI_SERVER_ERROR_MANAGEMENT_INVALID_QUERY_PARAMETER_COMBINATION",   "Query parameter combination in query string is invalid (JSON error code: 2179330)" } },
    //{ 0x82214103,{ "SCE_NP_WEBAPI_SERVER_ERROR_MANAGEMENT_UNAVAILABLE_QUERY_PARAMETER_FOR_RESOURCE",  "Specified query parameter cannot be used for the specified resource (JSON error code: 2179331)" } },
    //{ 0x82214104,{ "SCE_NP_WEBAPI_SERVER_ERROR_MANAGEMENT_INVALID_PARAMETER_IN_URL",  "Parameter section value included in URL is invalid (JSON error code: 2179332)" } },
    //{ 0x82214105,{ "SCE_NP_WEBAPI_SERVER_ERROR_MANAGEMENT_MANDATORY_QUERY_PARAMETER_MISSING", "Query parameter required for query string does not exist (JSON error code: 2179333)" } },
    //{ 0x82214140,{ "SCE_NP_WEBAPI_SERVER_ERROR_MANAGEMENT_INVALID_HEADER",    "Header value for request header is invalid (JSON error code: 2179392)" } },
    //{ 0x82214141,{ "SCE_NP_WEBAPI_SERVER_ERROR_MANAGEMENT_HEADER_REQUIRED",   "Header required for request header does not exist (JSON error code: 2179393)" } },
    //{ 0x82214180,{ "SCE_NP_WEBAPI_SERVER_ERROR_MANAGEMENT_INVALID_BODY",  "Details are unknown, but request body value is invalid (JSON error code: 2179456)" } },
    //{ 0x82214181,{ "SCE_NP_WEBAPI_SERVER_ERROR_MANAGEMENT_NULL_VALUE_NOT_ALLOWED",    "A member with a null value in request body exists (JSON error code: 2179457)" } },
    //{ 0x82214182,{ "SCE_NP_WEBAPI_SERVER_ERROR_MANAGEMENT_INVALID_BODY_PARAMETER",    "Request body member value is invalid (JSON error code: 2179458)" } },
    //{ 0x82214183,{ "SCE_NP_WEBAPI_SERVER_ERROR_MANAGEMENT_INVALID_BODY_PARAMETER_LIST_LENGTH",    "Number of elements for request body array type members is invalid (JSON error code: 2179459)" } },
    //{ 0x82214184,{ "SCE_NP_WEBAPI_SERVER_ERROR_MANAGEMENT_INVALID_BODY_PARAMETER_COMBINATION",    "Request body member combination is invalid (JSON error code: 2179460)" } },
    //{ 0x82214185,{ "SCE_NP_WEBAPI_SERVER_ERROR_MANAGEMENT_BLOCKED_USER_EXISTS",   "Blocked user can't be specified (JSON error code: 2179461)" } },
    //{ 0x82214186,{ "SCE_NP_WEBAPI_SERVER_ERROR_MANAGEMENT_MANDATORY_BODY_PARAMETER_MISSING",  "Member required for request body does not exist (JSON error code: 2179462)" } },
    //{ 0x82214187,{ "SCE_NP_WEBAPI_SERVER_ERROR_MANAGEMENT_INVALID_MULTIPART_HEADER",  "Parameter for multipart header in request body is invalid (JSON error code: 2179463)" } },
    //{ 0x82214188,{ "SCE_NP_WEBAPI_SERVER_ERROR_MANAGEMENT_MANDATORY_MULTIPART_HEADER_MISSING",    "Member required for multipart header parameter in request body does not exist (JSON error code: 2179464)" } },
    //{ 0x82214200,{ "SCE_NP_WEBAPI_SERVER_ERROR_MANAGEMENT_ACCESS_TOKEN_REQUIRED", "No access token (JSON error code: 2179584)" } },
    //{ 0x82214201,{ "SCE_NP_WEBAPI_SERVER_ERROR_MANAGEMENT_INVALID_ACCESS_TOKEN",  "Access token is an invalid value or is corrupted (JSON error code: 2179585)" } },
    //{ 0x82214202,{ "SCE_NP_WEBAPI_SERVER_ERROR_MANAGEMENT_EXPIRED_ACCESS_TOKEN",  "Access token is expired (JSON error code: 2179586)" } },
    //{ 0x82214206,{ "SCE_NP_WEBAPI_SERVER_ERROR_MANAGEMENT_NOT_AUTHORIZED",    "Not authorized to access specified resource or use query parameter (JSON error code: 2179590)" } },
    //{ 0x82214207,{ "SCE_NP_WEBAPI_SERVER_ERROR_MANAGEMENT_BANNED_APPLICATION",    "Banned title (JSON error code: 2179591)" } },
    //{ 0x82214208,{ "SCE_NP_WEBAPI_SERVER_ERROR_MANAGEMENT_BANNED_USER",   "Banned user (JSON error code: 2179592)" } },
    //{ 0x82214209,{ "SCE_NP_WEBAPI_SERVER_ERROR_MANAGEMENT_BANNED_DEVICE", "Banned device (JSON error code: 2179593)" } },
    //{ 0x8221420B,{ "SCE_NP_WEBAPI_SERVER_ERROR_MANAGEMENT_RATE_LIMIT_EXCEEDED",   "API rate limit was exceeded (JSON error code: 2179595)" } },
    //{ 0x8221420D,{ "SCE_NP_WEBAPI_SERVER_ERROR_MANAGEMENT_NOT_AUTHORIZED_ACCESS_TOKEN",   "Access token was obtained with an invalid procedure (JSON error code: 2179597)" } },
    //{ 0x8221420E,{ "SCE_NP_WEBAPI_SERVER_ERROR_MANAGEMENT_NEED_TO_UPGRADE",   "Account needs to upgrade (JSON error code: 2179598)" } },
    //{ 0x82214210,{ "SCE_NP_WEBAPI_SERVER_ERROR_MANAGEMENT_USERS_ACCESS_TOKEN_REQUIRED",   "The API which doesn't permit an access with access token authenticated only with client credential. (JSON error code: 2179600)" } },
    //{ 0x82214280,{ "SCE_NP_WEBAPI_SERVER_ERROR_MANAGEMENT_UNKNOWN_CLIENT",    "Client ID for access token is invalid (JSON error code: 2179712)" } },
    //{ 0x82214281,{ "SCE_NP_WEBAPI_SERVER_ERROR_MANAGEMENT_NP_TITLE_ID_NOT_FOUND", "Title does not exist (JSON error code: 2179713)" } },
    //{ 0x82214282,{ "SCE_NP_WEBAPI_SERVER_ERROR_MANAGEMENT_NP_SERVICE_LABEL_NOT_FOUND",    "NP Service Label does not exist (JSON error code: 2179714)" } },
    //{ 0x82214283,{ "SCE_NP_WEBAPI_SERVER_ERROR_MANAGEMENT_NOT_AUTHORIZED_APPLICATION",    "This title cannot be used for the Management service (JSON error code: 2179715)" } },
    //{ 0x82214300,{ "SCE_NP_WEBAPI_SERVER_ERROR_MANAGEMENT_UNEXPECTED_ERROR",  "Unexpected error (JSON error code: 2179840)" } },
    //{ 0x82214301,{ "SCE_NP_WEBAPI_SERVER_ERROR_MANAGEMENT_INTERNAL_SERVER_ERROR", "Internal error of the server (JSON error code: 2179841)" } },
    //{ 0x82214302,{ "SCE_NP_WEBAPI_SERVER_ERROR_MANAGEMENT_SERVICE_TEMPORARILY_UNAVAILABLE",   "Service has been temporarily stopped (JSON error code: 2179842)" } },
    //{ 0x82214303,{ "SCE_NP_WEBAPI_SERVER_ERROR_MANAGEMENT_SERVER_BUSY",   "Server overload (JSON error code: 2179843)" } },
    //{ 0x82214304,{ "SCE_NP_WEBAPI_SERVER_ERROR_MANAGEMENT_AUTHORIZATION_SERVER_ERROR",    "Authentication/authorization server error  (JSON error code: 2179844)" } },
    //{ 0x82214340,{ "SCE_NP_WEBAPI_SERVER_ERROR_MANAGEMENT_UNDER_MAINTENANCE", "Server is under maintenance (JSON error code: 2179904)" } },
    //{ 0x82214341,{ "SCE_NP_WEBAPI_SERVER_ERROR_MANAGEMENT_SERVICE_CLOSED",    "Service has closed (JSON error code: 2179905)" } },
    //{ 0x82214342,{ "SCE_NP_WEBAPI_SERVER_ERROR_MANAGEMENT_SERVICE_NOT_READY", "Service is not ready (JSON error code: 2179906)" } },
    //{ 0x82214380,{ "SCE_NP_WEBAPI_SERVER_ERROR_MANAGEMENT_UNKNOWN_ERROR", "Unknown error (JSON error code: 2179968)" } },
    //{ 0x82214400,{ "SCE_NP_WEBAPI_SERVER_ERROR_MANAGEMENT_IP_ADDRESS_IS_ALREADY_REGISTERED",  "IP address is already registered (JSON error code: 2180096)" } },
    //{ 0x82214401,{ "SCE_NP_WEBAPI_SERVER_ERROR_MANAGEMENT_ACCESS_SOURCE_IP_ADDRESS_IS_SPECIFIED_FOR_DELETION",    "Access source IP address is specified for deletion (JSON error code: 2180097)" } },
    //{ 0x82214402,{ "SCE_NP_WEBAPI_SERVER_ERROR_MANAGEMENT_EXCEED_REGISTRATION_LIMIT", "Exceed registration limit (JSON error code: 2180098)" } },
    //{ 0x82214403,{ "SCE_NP_WEBAPI_SERVER_ERROR_MANAGEMENT_CANNOT_DELETE_LAST_IP_ADDRESS_ENTRY",   "Cannot delete last IP adress entry (JSON error code: 2180099)" } },
    //{ 0x82214404,{ "SCE_NP_WEBAPI_SERVER_ERROR_MANAGEMENT_MANAGEMENT_TARGET_SERVICE_NOT_READY_IN_THE_ENVIRONMENT",    "Management target service not ready in the environment (JSON error code: 2180100)" } },
    //{ 0x82214500,{ "SCE_NP_WEBAPI_SERVER_ERROR_MANAGEMENT_CONDITIONS_NOT_FULFILLED",  "Update conditions not fulfilled (JSON error code: 2180352)" } },
    //{ 0x82214501,{ "SCE_NP_WEBAPI_SERVER_ERROR_MANAGEMENT_SETTERID_USER_NOT_FOUND",   "SetterID user not found (JSON error code: 2180353)" } },
    //{ 0x82214580,{ "SCE_NP_WEBAPI_SERVER_ERROR_MANAGEMENT_OVER_THE_GAME_DATA_LIMIT",  "Over the game data limit (JSON error code: 2180480)" } },
    //{ 0x82214581,{ "SCE_NP_WEBAPI_SERVER_ERROR_MANAGEMENT_RANKING_GAME_DATA_ALREADY_EXISTS",  "Ranking game data already exists (JSON error code: 2180481)" } },
    //{ 0x82217001,{ "SCE_NP_WEBAPI_SERVER_ERROR_FOLLOW_BAD_REQUEST",   "Details are unknown, but an invalid value was included in request (header, body, query string, etc.) (JSON error code: 2191361)" } },
    //{ 0x82217002,{ "SCE_NP_WEBAPI_SERVER_ERROR_FOLLOW_UNSUPPORTED_API_VERSION",   "Unsupported API version (JSON error code: 2191362)" } },
    //{ 0x82217003,{ "SCE_NP_WEBAPI_SERVER_ERROR_FOLLOW_TOO_LARGE_BODY",    "Request body is too long (JSON error code: 2191363)" } },
    //{ 0x82217004,{ "SCE_NP_WEBAPI_SERVER_ERROR_FOLLOW_INVALID_NP_ENVIRONMENT",    "Environment name is invalid (JSON error code: 2191364)" } },
    //{ 0x8221700A,{ "SCE_NP_WEBAPI_SERVER_ERROR_FOLLOW_INVALID_OAUTH_CLIENT_ID",   "OAuth client ID is invalid (JSON error code: 2191370)" } },
    //{ 0x8221700C,{ "SCE_NP_WEBAPI_SERVER_ERROR_FOLLOW_USER_NOT_FOUND",    "Target user does not exist (JSON error code: 2191372)" } },
    //{ 0x8221700D,{ "SCE_NP_WEBAPI_SERVER_ERROR_FOLLOW_RESOURCE_NOT_FOUND",    "Target resource does not exist (JSON error code: 2191373)" } },
    //{ 0x8221700E,{ "SCE_NP_WEBAPI_SERVER_ERROR_FOLLOW_ACCESS_DENIED_BY_RESOURCE_OWNERSHIP",   "Access attempted by a non-owner for a resource that only the resource owner can access. For example, attempted to obtain a friend list with presence information of another user. (JSON error code: 2191374)" } },
    //{ 0x82217100,{ "SCE_NP_WEBAPI_SERVER_ERROR_FOLLOW_INVALID_QUERY_STRING",  "Details are unknown, but an value in query string is invalid (JSON error code: 2191616)" } },
    //{ 0x82217101,{ "SCE_NP_WEBAPI_SERVER_ERROR_FOLLOW_INVALID_QUERY_PARAMETER",   "Query parameter value in query string is invalid (JSON error code: 2191617)" } },
    //{ 0x82217102,{ "SCE_NP_WEBAPI_SERVER_ERROR_FOLLOW_INVALID_QUERY_PARAMETER_COMBINATION",   "Query parameter combination in query string is invalid (JSON error code: 2191618)" } },
    //{ 0x82217103,{ "SCE_NP_WEBAPI_SERVER_ERROR_FOLLOW_UNAVAILABLE_QUERY_PARAMETER_FOR_RESOURCE",  "Specified query parameter cannot be used for the specified resource (JSON error code: 2191619)" } },
    //{ 0x82217104,{ "SCE_NP_WEBAPI_SERVER_ERROR_FOLLOW_INVALID_PARAMETER_IN_URL",  "Parameter section value included in URL is invalid (JSON error code: 2191620)" } },
    //{ 0x82217105,{ "SCE_NP_WEBAPI_SERVER_ERROR_FOLLOW_MANDATORY_QUERY_PARAMETER_MISSING", "Query parameter required for query string does not exist (JSON error code: 2191621)" } },
    //{ 0x82217140,{ "SCE_NP_WEBAPI_SERVER_ERROR_FOLLOW_INVALID_HEADER",    "Header value for request header is invalid (JSON error code: 2191680)" } },
    //{ 0x82217141,{ "SCE_NP_WEBAPI_SERVER_ERROR_FOLLOW_HEADER_REQUIRED",   "Header required for request header does not exist (JSON error code: 2191681)" } },
    //{ 0x82217180,{ "SCE_NP_WEBAPI_SERVER_ERROR_FOLLOW_INVALID_BODY",  "Details are unknown, but request body value is invalid (JSON error code: 2191744)" } },
    //{ 0x82217181,{ "SCE_NP_WEBAPI_SERVER_ERROR_FOLLOW_NULL_VALUE_NOT_ALLOWED",    "A member with a null value in request body exists (JSON error code: 2191745)" } },
    //{ 0x82217182,{ "SCE_NP_WEBAPI_SERVER_ERROR_FOLLOW_INVALID_BODY_PARAMETER",    "Request body member value is invalid (JSON error code: 2191746)" } },
    //{ 0x82217183,{ "SCE_NP_WEBAPI_SERVER_ERROR_FOLLOW_INVALID_BODY_PARAMETER_LIST_LENGTH",    "Number of elements for request body array type members is invalid (JSON error code: 2191747)" } },
    //{ 0x82217184,{ "SCE_NP_WEBAPI_SERVER_ERROR_FOLLOW_INVALID_BODY_PARAMETER_COMBINATION",    "Request body member combination is invalid (JSON error code: 2191748)" } },
    //{ 0x82217185,{ "SCE_NP_WEBAPI_SERVER_ERROR_FOLLOW_BLOCKED_USER_EXISTS",   "Blocked user can't be specified (JSON error code: 2191749)" } },
    //{ 0x82217186,{ "SCE_NP_WEBAPI_SERVER_ERROR_FOLLOW_MANDATORY_BODY_PARAMETER_MISSING",  "Member required for request body does not exist (JSON error code: 2191750)" } },
    //{ 0x82217200,{ "SCE_NP_WEBAPI_SERVER_ERROR_FOLLOW_ACCESS_TOKEN_REQUIRED", "No access token (JSON error code: 2191872)" } },
    //{ 0x82217201,{ "SCE_NP_WEBAPI_SERVER_ERROR_FOLLOW_INVALID_ACCESS_TOKEN",  "Access token is an invalid value or is corrupted (JSON error code: 2191873)" } },
    //{ 0x82217202,{ "SCE_NP_WEBAPI_SERVER_ERROR_FOLLOW_EXPIRED_ACCESS_TOKEN",  "Access token is expired (JSON error code: 2191874)" } },
    //{ 0x82217206,{ "SCE_NP_WEBAPI_SERVER_ERROR_FOLLOW_NOT_AUTHORIZED",    "Not authorized to access specified resource or use query parameter (JSON error code: 2191878)" } },
    //{ 0x82217207,{ "SCE_NP_WEBAPI_SERVER_ERROR_FOLLOW_BANNED_APPLICATION",    "Banned title (JSON error code: 2191879)" } },
    //{ 0x82217208,{ "SCE_NP_WEBAPI_SERVER_ERROR_FOLLOW_BANNED_USER",   "Banned user (JSON error code: 2191880)" } },
    //{ 0x82217209,{ "SCE_NP_WEBAPI_SERVER_ERROR_FOLLOW_BANNED_DEVICE", "Banned device (JSON error code: 2191881)" } },
    //{ 0x8221720B,{ "SCE_NP_WEBAPI_SERVER_ERROR_FOLLOW_RATE_LIMIT_EXCEEDED",   "API rate limit was exceeded (JSON error code: 2191883)" } },
    //{ 0x8221720C,{ "SCE_NP_WEBAPI_SERVER_ERROR_FOLLOW_ACCESS_DENIED_BY_PRIVACY_LEVEL",    "Access was denied due to target user privacy setting (JSON error code: 2191884)" } },
    //{ 0x8221720D,{ "SCE_NP_WEBAPI_SERVER_ERROR_FOLLOW_NOT_AUTHORIZED_ACCESS_TOKEN",   "Access token was obtained with an invalid procedure (JSON error code: 2191885)" } },
    //{ 0x8221720E,{ "SCE_NP_WEBAPI_SERVER_ERROR_FOLLOW_NEED_TO_UPGRADE",   "Account needs to upgrade (JSON error code: 2191886)" } },
    //{ 0x8221720F,{ "SCE_NP_WEBAPI_SERVER_ERROR_FOLLOW_NOT_AUTHORIZED_ON_PLATFORM",    "Parameter which is not available on the platform is specified (JSON error code: 2191887)" } },
    //{ 0x82217210,{ "SCE_NP_WEBAPI_SERVER_ERROR_FOLLOW_USERS_ACCESS_TOKEN_REQUIRED",   "The API which doesn't permit an access with access token authenticated only with client credential. (JSON error code: 2191888)" } },
    //{ 0x82217280,{ "SCE_NP_WEBAPI_SERVER_ERROR_FOLLOW_UNKNOWN_CLIENT",    "Client ID for access token is invalid (JSON error code: 2192000)" } },
    //{ 0x82217281,{ "SCE_NP_WEBAPI_SERVER_ERROR_FOLLOW_NP_TITLE_ID_NOT_FOUND", "Title does not exist (JSON error code: 2192001)" } },
    //{ 0x82217300,{ "SCE_NP_WEBAPI_SERVER_ERROR_FOLLOW_UNEXPECTED_ERROR",  "Unexpected error (JSON error code: 2192128)" } },
    //{ 0x82217301,{ "SCE_NP_WEBAPI_SERVER_ERROR_FOLLOW_INTERNAL_SERVER_ERROR", "Internal error of the server (JSON error code: 2192129)" } },
    //{ 0x82217302,{ "SCE_NP_WEBAPI_SERVER_ERROR_FOLLOW_SERVICE_TEMPORARILY_UNAVAILABLE",   "Service has been temporarily stopped (JSON error code: 2192130)" } },
    //{ 0x82217303,{ "SCE_NP_WEBAPI_SERVER_ERROR_FOLLOW_SERVER_BUSY",   "Server overload (JSON error code: 2192131)" } },
    //{ 0x82217304,{ "SCE_NP_WEBAPI_SERVER_ERROR_FOLLOW_AUTHORIZATION_SERVER_ERROR",    "Authentication/authorization server error  (JSON error code: 2192132)" } },
    //{ 0x82217340,{ "SCE_NP_WEBAPI_SERVER_ERROR_FOLLOW_UNDER_MAINTENANCE", "Server is under maintenance (JSON error code: 2192192)" } },
    //{ 0x82217341,{ "SCE_NP_WEBAPI_SERVER_ERROR_FOLLOW_SERVICE_CLOSED",    "Service has closed (JSON error code: 2192193)" } },
    //{ 0x82217380,{ "SCE_NP_WEBAPI_SERVER_ERROR_FOLLOW_UNKNOWN_ERROR", "Unknown error (JSON error code: 2192256)" } },
    //{ 0x82217400,{ "SCE_NP_WEBAPI_SERVER_ERROR_FOLLOW_RESOURCE_BEING_LOCKED", "The resource is being locked (JSON error code: 2192384)" } },
    //{ 0x82217401,{ "SCE_NP_WEBAPI_SERVER_ERROR_FOLLOW_FOLLOWING_FULL",    "Following list reached its limit (JSON error code: 2192385)" } },
    //{ 0x82217403,{ "SCE_NP_WEBAPI_SERVER_ERROR_FOLLOW_FOLLOWERS_FULL",    "Follower list reached its limit (JSON error code: 2192387)" } },
    //{ 0x82218001,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_BAD_REQUEST",   "Details are unknown, but an invalid value was included in request (header, body, query string, etc.) (JSON error code: 2195457)" } },
    //{ 0x82218002,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_UNSUPPORTED_API_VERSION",   "Unsupported API version (JSON error code: 2195458)" } },
    //{ 0x82218003,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_TOO_LARGE_BODY",    "Request body is too long (JSON error code: 2195459)" } },
    //{ 0x82218004,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_INVALID_NP_ENVIRONMENT",    "Environment name is invalid (JSON error code: 2195460)" } },
    //{ 0x82218005,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_INVALID_NP_TITLE_ID",   "NP Title ID is invalid (JSON error code: 2195461)" } },
    //{ 0x82218006,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_INVALID_NP_SERVICE_LABEL",  "NP Service Label is invalid (JSON error code: 2195462)" } },
    //{ 0x82218007,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_INVALID_NP_COMMUNICATION_ID",   "NP Communication ID is invalid (JSON error code: 2195463)" } },
    //{ 0x8221800A,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_INVALID_OAUTH_CLIENT_ID",   "OAuth client ID is invalid (JSON error code: 2195466)" } },
    //{ 0x8221800C,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_USER_NOT_FOUND",    "Target user does not exist (JSON error code: 2195468)" } },
    //{ 0x8221800D,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_RESOURCE_NOT_FOUND",    "Target resource does not exist (JSON error code: 2195469)" } },
    //{ 0x8221800E,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_ACCESS_DENIED_BY_RESOURCE_OWNERSHIP",   "Access attempted by a non-owner for a resource that only the resource owner can access. For example, attempted to obtain a friend list with presence information of another user. (JSON error code: 2195470)" } },
    //{ 0x82218100,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_INVALID_QUERY_STRING",  "Details are unknown, but an value in query string is invalid (JSON error code: 2195712)" } },
    //{ 0x82218101,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_INVALID_QUERY_PARAMETER",   "Query parameter value in query string is invalid (JSON error code: 2195713)" } },
    //{ 0x82218102,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_INVALID_QUERY_PARAMETER_COMBINATION",   "Query parameter combination in query string is invalid (JSON error code: 2195714)" } },
    //{ 0x82218103,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_UNAVAILABLE_QUERY_PARAMETER_FOR_RESOURCE",  "Specified query parameter cannot be used for the specified resource (JSON error code: 2195715)" } },
    //{ 0x82218104,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_INVALID_PARAMETER_IN_URL",  "Parameter section value included in URL is invalid (JSON error code: 2195716)" } },
    //{ 0x82218105,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_MANDATORY_QUERY_PARAMETER_MISSING", "Query parameter required for query string does not exist (JSON error code: 2195717)" } },
    //{ 0x82218140,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_INVALID_HEADER",    "Header value for request header is invalid (JSON error code: 2195776)" } },
    //{ 0x82218141,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_HEADER_REQUIRED",   "Header required for request header does not exist (JSON error code: 2195777)" } },
    //{ 0x82218180,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_INVALID_BODY",  "Details are unknown, but request body value is invalid (JSON error code: 2195840)" } },
    //{ 0x82218181,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_NULL_VALUE_NOT_ALLOWED",    "A member with a null value in request body exists (JSON error code: 2195841)" } },
    //{ 0x82218182,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_INVALID_BODY_PARAMETER",    "Request body member value is invalid (JSON error code: 2195842)" } },
    //{ 0x82218183,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_INVALID_BODY_PARAMETER_LIST_LENGTH",    "Number of elements for request body array type members is invalid (JSON error code: 2195843)" } },
    //{ 0x82218184,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_INVALID_BODY_PARAMETER_COMBINATION",    "Request body member combination is invalid (JSON error code: 2195844)" } },
    //{ 0x82218185,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_BLOCKED_USER_EXISTS",   "Blocked user can't be specified (JSON error code: 2195845)" } },
    //{ 0x82218186,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_MANDATORY_BODY_PARAMETER_MISSING",  "Member required for request body does not exist (JSON error code: 2195846)" } },
    //{ 0x82218187,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_INVALID_MULTIPART_HEADER",  "Parameter for multipart header in request body is invalid (JSON error code: 2195847)" } },
    //{ 0x82218188,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_MANDATORY_MULTIPART_HEADER_MISSING",    "Member required for multipart header parameter in request body does not exist (JSON error code: 2195848)" } },
    //{ 0x82218200,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_ACCESS_TOKEN_REQUIRED", "No access token (JSON error code: 2195968)" } },
    //{ 0x82218201,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_INVALID_ACCESS_TOKEN",  "Access token is an invalid value or is corrupted (JSON error code: 2195969)" } },
    //{ 0x82218202,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_EXPIRED_ACCESS_TOKEN",  "Access token is expired (JSON error code: 2195970)" } },
    //{ 0x82218206,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_NOT_AUTHORIZED",    "Not authorized to access specified resource or use query parameter (JSON error code: 2195974)" } },
    //{ 0x82218207,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_BANNED_APPLICATION",    "Banned title (JSON error code: 2195975)" } },
    //{ 0x82218208,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_BANNED_USER",   "Banned user (JSON error code: 2195976)" } },
    //{ 0x82218209,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_BANNED_DEVICE", "Banned device (JSON error code: 2195977)" } },
    //{ 0x8221820A,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_ACCESS_DENIED_DUE_TO_TITILE_MISMATCH",  "Access to resource not possible since title set for the presence information does not match (JSON error code: 2195978)" } },
    //{ 0x8221820B,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_RATE_LIMIT_EXCEEDED",   "API rate limit was exceeded (JSON error code: 2195979)" } },
    //{ 0x8221820D,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_NOT_AUTHORIZED_ACCESS_TOKEN",   "Access token was obtained with an invalid procedure (JSON error code: 2195981)" } },
    //{ 0x8221820E,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_NEED_TO_UPGRADE",   "Account needs to upgrade (JSON error code: 2195982)" } },
    //{ 0x8221820F,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_NOT_AUTHORIZED_ON_PLATFORM",    "Parameter which is not available on the platform is specified (JSON error code: 2195983)" } },
    //{ 0x82218210,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_USERS_ACCESS_TOKEN_REQUIRED",   "The API which doesn't permit an access with access token authenticated only with client credential. (JSON error code: 2195984)" } },
    //{ 0x82218211,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_ACCESS_DENIED_DUE_TO_PARENTAL_CONTROL_SETTINGS",    "Access denied due to parental control settings (JSON error code: 2195985)" } },
    //{ 0x82218280,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_UNKNOWN_CLIENT",    "Client ID for access token is invalid (JSON error code: 2196096)" } },
    //{ 0x82218281,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_NP_TITLE_ID_NOT_FOUND", "Title does not exist (JSON error code: 2196097)" } },
    //{ 0x82218282,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_NP_SERVICE_LABEL_NOT_FOUND",    "NP Service Label does not exist (JSON error code: 2196098)" } },
    //{ 0x82218283,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_NOT_AUTHORIZED_APPLICATION",    "This title cannot be used for the Events service (JSON error code: 2196099)" } },
    //{ 0x82218284,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_NP_COMMUNICATION_ID_NOT_FOUND", "NP Communication ID does not exist (JSON error code: 2196100)" } },
    //{ 0x82218300,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_UNEXPECTED_ERROR",  "Unexpected error (JSON error code: 2196224)" } },
    //{ 0x82218301,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_INTERNAL_SERVER_ERROR", "Internal error of the server (JSON error code: 2196225)" } },
    //{ 0x82218302,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_SERVICE_TEMPORARILY_UNAVAILABLE",   "Service has been temporarily stopped (JSON error code: 2196226)" } },
    //{ 0x82218303,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_SERVER_BUSY",   "Server overload (JSON error code: 2196227)" } },
    //{ 0x82218304,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_AUTHORIZATION_SERVER_ERROR",    "Authentication/authorization server error  (JSON error code: 2196228)" } },
    //{ 0x82218340,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_UNDER_MAINTENANCE", "Server is under maintenance (JSON error code: 2196288)" } },
    //{ 0x82218341,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_SERVICE_CLOSED",    "Service has closed (JSON error code: 2196289)" } },
    //{ 0x82218342,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_SERVICE_NOT_READY", "Service is not ready (JSON error code: 2196290)" } },
    //{ 0x82218380,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_UNKNOWN_ERROR", "Unknown error (JSON error code: 2196352)" } },
    //{ 0x82218800,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_IP_ADDRESS_IS_ALREADY_REGISTERED",  "IP address is already registered (JSON error code: 2197504)" } },
    //{ 0x82218801,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_ACCESS_SOURCE_IP_ADDRESS_IS_SPECIFIED_FOR_DELETION",    "Access source IP address is specified for deletion (JSON error code: 2197505)" } },
    //{ 0x82218802,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_EXCEED_REGISTRATION_LIMIT", "Exceeded the maximum number of IP addresses in ACL (JSON error code: 2197506)" } },
    //{ 0x82218803,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_CANNOT_DELETE_LAST_IP_ADDRESS_ENTRY",   "Cannot delete all of the IP address entries (JSON error code: 2197507)" } },
    //{ 0x82218810,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_ONLINEID_IS_ALREADY_REGISTERED_IN_ACL", "The OnlineID has already been registered (JSON error code: 2197520)" } },
    //{ 0x82218811,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_EXCEED_REGISTRATION_LIMIT_OF_ONLINEID_ACL", "Exceeded the maximum number of Online IDs in ACL (JSON error code: 2197521)" } },
    //{ 0x82218820,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_DURATION_SETTINGS_IS_INVALID",  "Invalid duration of event (JSON error code: 2197536)" } },
    //{ 0x82218821,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_EVENT_IS_ALREADY_PROMOTED", "The event has already been promoted (JSON error code: 2197537)" } },
    //{ 0x82218822,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_TOTAL_SEARCHABLE_EVENTS_COUNT_EXCEED_THE_LIMIT",    "Exceeded the max number of searchable events (JSON error code: 2197538)" } },
    //{ 0x82218823,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_SAME_COUNTRY_CODE_CANNOT_BE_REUSED_IN_MULTIPLE_COUNTRIES_PARAMETER",    "Same country code cannot be reused in multiple countries parameter (JSON error code: 2197539)" } },
    //{ 0x82218824,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_THE_TARGET_EVENT_IS_CURRENTLY_BEING_UPDATED_BY_OTHER_REQUESTS", "The event is currently being updated by other requests (JSON error code: 2197540)" } },
    //{ 0x82218825,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_PROCESS_OF_UPDATING_DID_NOT_COMPLETE",  "Updating the resource failed. Please retry. (JSON error code: 2197541)" } },
    //{ 0x82218826,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_PARAMETER_IN_BODY_CONFLICT_WITH_THE_TARGET_EVENT_TYPE", "The parameter specified cannot be used for the event type (JSON error code: 2197542)" } },
    //{ 0x82218900,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_DOES_NOT_MEET_THE_EVENT_PARTICIPATION_CONDITIONS",  "Cannot access the event because of country and age restriction (JSON error code: 2197760)" } },
    //{ 0x82218901,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_EXPIRATION_OF_PARTICIPATION_DATA_AND_TIME", "Participation date has passed (JSON error code: 2197761)" } },
    //{ 0x82218902,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_REACHED_THE_MAXIMUM_NUMBER_OF_REGISTERED_EVENTS",   "Exceeded the maximum number of events a user can register (JSON error code: 2197762)" } },
    //{ 0x82218903,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_CANNOT_UNREGISTER_BECAUSE_EVENT_HAS_ALREADY_FINISHED",  "Cannot unregister events have already finished (JSON error code: 2197763)" } },
    //{ 0x82218904,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_EVENT_HAS_BEEN_CANCELED",   "Cannot register events have already canceled. (JSON error code: 2197764)" } },
    //{ 0x82218905,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_REACHED_THE_MAXIMUM_NUMBER_OF_CREATED_EVENTS",  "User cannot create new events by reached the maximum number (JSON error code: 2197765)" } },
    //{ 0x82218906,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_CANNOT_UPDATE_BECAUSE_EVENT_HAS_ALREADY_FINISHED",  "Cannot update because event has already finished (JSON error code: 2197766)" } },
    //{ 0x82218907,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_CANNOT_SET_THE_MAXIMUM_NUMBER_OF_MEMBERS_SMALLER_THAN_CURRENT_PARTICIPANTS",    "User cannot set number of \"players who can join\"smaller than current number of \"Registered Players\" (JSON error code: 2197767)" } },
    //{ 0x82218908,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_REACHED_THE_MAXIMUM_NUMBER_OF_PARTICIPANTS",    "Cannot register events because it reached number of \"players who can join\" (JSON error code: 2197768)" } },
    //{ 0x82218909,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_CANNOT_REGISTER_DUE_TO_EVENT_OWNER",    "Event owner cannot unregister event which is created by own. (JSON error code: 2197769)" } },
    //{ 0x8221890A,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_CANNOT_UPDATE_BECAUSE_EVENT_HAS_ALREADY_STARTED",   "Cannot update because event has already started (JSON error code: 2197770)" } },
    //{ 0x8221890B,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_CANNOT_UPDATE_BECAUSE_EVENT_HAS_NOT_BEEN_HELD", "Cannot update because event hasn't been held (JSON error code: 2197771)" } },
    //{ 0x8221890C,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_CANNOT_REGISTER_EVENT_HAVING_MEMBER_BLOCKED",   "Since the participants are included block user , you will not be able to register the event . (JSON error code: 2197772)" } },
    //{ 0x8221890D,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_NOT_ALLOWED_TO_REGISTER",   "You cannot register the event by privacy setting of participants. (JSON error code: 2197773)" } },
    //{ 0x8221890E,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_ALREADY_REGISTERED_EVENT",  "Already registered to the event (JSON error code: 2197774)" } },
    //{ 0x8221890F,{ "SCE_NP_WEBAPI_SERVER_ERROR_EVENTS_EVENT_HAS_ALREADY_FINISHED",    "The event already finished (JSON error code: 2197775)" } },
    //{ 0x82302F01,{ "SCE_NP_WEBAPI_SERVER_ERROR_ACTIVITY_FEED_INVALID_REQUEST",    "The specified target type was invalid or the story type wasn't specified in the POST json (JSON error code: 3157761)" } },
    //{ 0x82302F02,{ "SCE_NP_WEBAPI_SERVER_ERROR_ACTIVITY_FEED_INTERNAL_ERROR", "Internal error occurred (JSON error code: 3157762)" } },
    //{ 0x82302F03,{ "SCE_NP_WEBAPI_SERVER_ERROR_ACTIVITY_FEED_SERVICE_UNAVAILABLE",    "Server is undergoing maintenance (JSON error code: 3157763)" } },
    //{ 0x82302F05,{ "SCE_NP_WEBAPI_SERVER_ERROR_ACTIVITY_FEED_INVALID_PARAMETER",  "The JSON parameter was invalid (JSON error code: 3157765)" } },
    //{ 0x82302F07,{ "SCE_NP_WEBAPI_SERVER_ERROR_ACTIVITY_FEED_NOT_IMPLEMENTED",    "Method not implemented (JSON error code: 3157767)" } },
    //{ 0x82302F0A,{ "SCE_NP_WEBAPI_SERVER_ERROR_ACTIVITY_FEED_UNSUPPORTED_MEDIA_TYPE", "Standard 415 media type error (JSON error code: 3157770)" } },
    //{ 0x82302F12,{ "SCE_NP_WEBAPI_SERVER_ERROR_ACTIVITY_FEED_INVALID_PSN_ACCESS_TOKEN",   "Access token is invalid (JSON error code: 3157778)" } },
    //{ 0x82302F14,{ "SCE_NP_WEBAPI_SERVER_ERROR_ACTIVITY_FEED_PRIVACY_VIOLATION",  "Privacy violation - user cannot see feed because there are no privacy settings (JSON error code: 3157780)" } },
    //{ 0x82302F31,{ "SCE_NP_WEBAPI_SERVER_ERROR_ACTIVITY_FEED_POST_RATE_LIMIT_EXCEEDED",   "Rate limit was exceeded (JSON error code: 3157809)" } },
    //{ 0x82302F32,{ "SCE_NP_WEBAPI_SERVER_ERROR_ACTIVITY_FEED_NO_FEED_CONTENT",    "The activity feed is empty (i.e. not POSTs ever occurred for this user) (JSON error code: 3157810)" } },
    //{ 0x82302F33,{ "SCE_NP_WEBAPI_SERVER_ERROR_ACTIVITY_FEED_SOURCE_ID_DOES_NOT_MATCH",   "Source ID does not match (JSON error code: 3157811)" } },
    //{ 0x82302F35,{ "SCE_NP_WEBAPI_SERVER_ERROR_ACTIVITY_FEED_TITLE_ID_DOES_NOT_MATCH",    "Title ID does not match the title token (JSON error code: 3157813)" } },
    //{ 0x82302F36,{ "SCE_NP_WEBAPI_SERVER_ERROR_ACTIVITY_FEED_USER_PRIVACY_DOESNT_ALLOW_SHARING",  "User privacy does not allow sharing (JSON error code: 3157814)" } },
    //{ 0x82302F38,{ "SCE_NP_WEBAPI_SERVER_ERROR_ACTIVITY_FEED_INVALID_JSON",   "The JSON was invalid (JSON error code: 3157816)" } },
    //{ 0x82302F39,{ "SCE_NP_WEBAPI_SERVER_ERROR_ACTIVITY_FEED_INVALID_ASPECT_RATIO",   "The specified aspect ratio is not allowed (JSON error code: 3157817)" } },
    //{ 0x82302F3A,{ "SCE_NP_WEBAPI_SERVER_ERROR_ACTIVITY_FEED_ONLINE_ID_NOT_SET",  "The online id was not set (JSON error code: 3157818)" } },
    //{ 0x82302F3B,{ "SCE_NP_WEBAPI_SERVER_ERROR_ACTIVITY_FEED_INVALID_POST_OR_STORY",  "The specified story post was invalid (JSON error code: 3157819)" } },
    //{ 0x82302F64,{ "SCE_NP_WEBAPI_SERVER_ERROR_ACTIVITY_FEED_NOT_AUTHORIZED", "The user is not authorized to call this API (JSON error code: 3157860)" } },
    //{ 0x82302F67,{ "SCE_NP_WEBAPI_SERVER_ERROR_ACTIVITY_FEED_REQUEST_TOO_LONG",   "Standard 413 request too long error (JSON error code: 3157863)" } },
    //{ 0x82302F68,{ "SCE_NP_WEBAPI_SERVER_ERROR_ACTIVITY_FEED_REQUEST_URI_TOO_LONG",   "Standard 414 uri too long error (JSON error code: 3157864)" } },
    //{ 0x82302F69,{ "SCE_NP_WEBAPI_SERVER_ERROR_ACTIVITY_FEED_HTTP_NOT_IMPLEMENTED",   "HTTP is not implemented (JSON error code: 3157865)" } },
    //{ 0x82302F98,{ "SCE_NP_WEBAPI_SERVER_ERROR_ACTIVITY_FEED_COMMENT_EXCEEDED_CHARACTER_LIMIT",   "Comment exceeded maximum character limit (JSON error code: 3157912)" } },
    //{ 0x82302F99,{ "SCE_NP_WEBAPI_SERVER_ERROR_ACTIVITY_FEED_COMMENT_EXCEEDED_POST_LIMIT",    "Comment exceeded maximum number of comments per story (JSON error code: 3157913)" } },
    //{ 0x82303112,{ "SCE_NP_WEBAPI_SERVER_ERROR_ENTITLEMENTS_INVALID_PSN_ACCESS_TOKEN_2",  "Access token is invalid (JSON error code: 3158290)" } },
    //{ 0x82303F01,{ "SCE_NP_WEBAPI_SERVER_ERROR_ENTITLEMENTS_INVALID_REQUEST", "The request sent was not valid (JSON error code: 3161857)" } },
    //{ 0x82303F02,{ "SCE_NP_WEBAPI_SERVER_ERROR_ENTITLEMENTS_INTERNAL_ERROR",  "Internal error occurred (JSON error code: 3161858)" } },
    //{ 0x82303F03,{ "SCE_NP_WEBAPI_SERVER_ERROR_ENTITLEMENTS_SERVICE_UNAVAILABLE", "Service is undergoing maintenance (JSON error code: 3161859)" } },
    //{ 0x82303F04,{ "SCE_NP_WEBAPI_SERVER_ERROR_ENTITLEMENTS_RESOURCE_NOT_FOUND",  "Resource was not found (JSON error code: 3161860)" } },
    //{ 0x82303F05,{ "SCE_NP_WEBAPI_SERVER_ERROR_ENTITLEMENTS_INVALID_PARAMETER",   "Parameter was invalid (JSON error code: 3161861)" } },
    //{ 0x82303F07,{ "SCE_NP_WEBAPI_SERVER_ERROR_ENTITLEMENTS_NOT_IMPLEMENTED", "Method not implemented (JSON error code: 3161863)" } },
    //{ 0x82303F08,{ "SCE_NP_WEBAPI_SERVER_ERROR_ENTITLEMENTS_SERVER_ERROR",    "Unexpected error from the server (JSON error code: 3161864)" } },
    //{ 0x82303F12,{ "SCE_NP_WEBAPI_SERVER_ERROR_ENTITLEMENTS_INVALID_PSN_ACCESS_TOKEN",    "Access token is invalid (JSON error code: 3161874)" } },
    //{ 0x82303F31,{ "SCE_NP_WEBAPI_SERVER_ERROR_ENTITLEMENTS_RATE_LIMIT_EXCEEDED", "Rate limit was exceeded (JSON error code: 3161905)" } },
    //{ 0x82303F64,{ "SCE_NP_WEBAPI_SERVER_ERROR_ENTITLEMENTS_NOT_AUTHORIZED",  "The user is not authorized to call this API (JSON error code: 3161956)" } },
    //{ 0x82303F65,{ "SCE_NP_WEBAPI_SERVER_ERROR_ENTITLEMENTS_NOT_ALLOWED", "HTTP method is not allowed (JSON error code: 3161957)" } },
    //{ 0x82303F66,{ "SCE_NP_WEBAPI_SERVER_ERROR_ENTITLEMENTS_FORBIDDEN",   "The user is forbidden to access the API (JSON error code: 3161958)" } },
    //{ 0x82303F67,{ "SCE_NP_WEBAPI_SERVER_ERROR_ENTITLEMENTS_REQUEST_TOO_LONG",    "Standard 413 request too long error (JSON error code: 3161959)" } },
    //{ 0x82303F68,{ "SCE_NP_WEBAPI_SERVER_ERROR_ENTITLEMENTS_REQUEST_URI_TOO_LONG",    "Standard 414 uri too long error (JSON error code: 3161960)" } },
    //{ 0x82303F69,{ "SCE_NP_WEBAPI_SERVER_ERROR_ENTITLEMENTS_HTTP_NOT_IMPLEMENTED",    "HTTP is not implemented (JSON error code: 3161961)" } },
    //{ 0x82304112,{ "SCE_NP_WEBAPI_SERVER_ERROR_COMMERCE_INVALID_PSN_ACCESS_TOKEN_2",  "Access token is invalid (JSON error code: 3162386)" } },
    //{ 0x82304F01,{ "SCE_NP_WEBAPI_SERVER_ERROR_COMMERCE_INVALID_REQUEST", "The request sent was not valid (JSON error code: 3165953)" } },
    //{ 0x82304F02,{ "SCE_NP_WEBAPI_SERVER_ERROR_COMMERCE_INTERNAL_ERROR",  "Internal error occurred (JSON error code: 3165954)" } },
    //{ 0x82304F03,{ "SCE_NP_WEBAPI_SERVER_ERROR_COMMERCE_SERVICE_UNAVAILABLE", "Service is undergoing maintenance (JSON error code: 3165955)" } },
    //{ 0x82304F04,{ "SCE_NP_WEBAPI_SERVER_ERROR_COMMERCE_RESOURCE_NOT_FOUND",  "Resource was not found (JSON error code: 3165956)" } },
    //{ 0x82304F05,{ "SCE_NP_WEBAPI_SERVER_ERROR_COMMERCE_INVALID_PARAMETER",   "Parameter was invalid (JSON error code: 3165957)" } },
    //{ 0x82304F07,{ "SCE_NP_WEBAPI_SERVER_ERROR_COMMERCE_NOT_IMPLEMENTED", "Method not implemented (JSON error code: 3165959)" } },
    //{ 0x82304F08,{ "SCE_NP_WEBAPI_SERVER_ERROR_COMMERCE_SERVER_ERROR",    "Unexpected error from the server (JSON error code: 3165960)" } },
    //{ 0x82304F0A,{ "SCE_NP_WEBAPI_SERVER_ERROR_COMMERCE_UNSUPPORTED_MEDIA_TYPE",  "Standard 415 media type error (JSON error code: 3165962)" } },
    //{ 0x82304F12,{ "SCE_NP_WEBAPI_SERVER_ERROR_COMMERCE_INVALID_PSN_ACCESS_TOKEN",    "Access token is invalid (JSON error code: 3165970)" } },
    //{ 0x82304F31,{ "SCE_NP_WEBAPI_SERVER_ERROR_COMMERCE_RATE_LIMIT_EXCEEDED", "Rate limit was exceeded (JSON error code: 3166001)" } },
    //{ 0x82304F61,{ "SCE_NP_WEBAPI_SERVER_ERROR_COMMERCE_CONTAINER_NOT_FOUND", "Multiple PS4 Representative products found (JSON error code: 3166049)" } },
    //{ 0x82304F63,{ "SCE_NP_WEBAPI_SERVER_ERROR_COMMERCE_CONTENT_NOT_FOUND",   "Content not found for entitlementid, country code, language code combination. No entitlementId is found for specific content. PlayGo Manifest not found for title. (JSON error code: 3166051)" } },
    //{ 0x82304F64,{ "SCE_NP_WEBAPI_SERVER_ERROR_COMMERCE_NOT_AUTHORIZED",  "The user is not authorized to call this API (JSON error code: 3166052)" } },
    //{ 0x82304F65,{ "SCE_NP_WEBAPI_SERVER_ERROR_COMMERCE_NOT_ALLOWED", "HTTP method is not allowed (JSON error code: 3166053)" } },
    //{ 0x82304F66,{ "SCE_NP_WEBAPI_SERVER_ERROR_COMMERCE_FORBIDDEN",   "The user is forbidden to access the api (JSON error code: 3166054)" } },
    //{ 0x82304F67,{ "SCE_NP_WEBAPI_SERVER_ERROR_COMMERCE_REQUEST_TOO_LONG",    "Standard 413 request too long error (JSON error code: 3166055)" } },
    //{ 0x82304F68,{ "SCE_NP_WEBAPI_SERVER_ERROR_COMMERCE_REQUEST_URI_TOO_LONG",    "Standard 414 uri too long error (JSON error code: 3166056)" } },
    //{ 0x82304F69,{ "SCE_NP_WEBAPI_SERVER_ERROR_COMMERCE_HTTP_NOT_IMPLEMENTED",    "HTTP is not implemented (JSON error code: 3166057)" } },
    //{ 0x82304F6C,{ "SCE_NP_WEBAPI_SERVER_ERROR_COMMERCE_PASSWORD_REQUIRED",   "During purchase, missing or incorrect password (JSON error code: 3166060)" } },
    //{ 0x82304F6D,{ "SCE_NP_WEBAPI_SERVER_ERROR_COMMERCE_CREDIT_CARD_INFO_REQUIRED",   "During purchase, missing or incorrect credit card information (JSON error code: 3166061)" } },
    //{ 0x82304F6E,{ "SCE_NP_WEBAPI_SERVER_ERROR_COMMERCE_NOT_ELIGIBLE",    "User is not eligible to rate a specific content (JSON error code: 3166062)" } },
    //{ 0x82305F01,{ "SCE_NP_WEBAPI_SERVER_ERROR_SOCIAL_NETWORK_INVALID_REQUEST",   "The request sent was not valid (JSON error code: 3170049)" } },
    //{ 0x82305F02,{ "SCE_NP_WEBAPI_SERVER_ERROR_SOCIAL_NETWORK_INTERNAL_ERROR",    "Internal error occurred (JSON error code: 3170050)" } },
    //{ 0x82305F03,{ "SCE_NP_WEBAPI_SERVER_ERROR_SOCIAL_NETWORK_SERVICE_UNAVAILABLE",   "Service is undergoing maintenance (JSON error code: 3170051)" } },
    //{ 0x82305F04,{ "SCE_NP_WEBAPI_SERVER_ERROR_SOCIAL_NETWORK_RESOURCE_NOT_FOUND",    "Resource was not found (JSON error code: 3170052)" } },
    //{ 0x82305F05,{ "SCE_NP_WEBAPI_SERVER_ERROR_SOCIAL_NETWORK_INVALID_PARAMETER", "Parameter was invalid (JSON error code: 3170053)" } },
    //{ 0x82305F07,{ "SCE_NP_WEBAPI_SERVER_ERROR_SOCIAL_NETWORK_NOT_IMPLEMENTED",   "Method not implemented (JSON error code: 3170055)" } },
    //{ 0x82305F08,{ "SCE_NP_WEBAPI_SERVER_ERROR_SOCIAL_NETWORK_SERVER_ERROR",  "Unexpected error from the server (JSON error code: 3170056)" } },
    //{ 0x82305F0A,{ "SCE_NP_WEBAPI_SERVER_ERROR_SOCIAL_NETWORK_UNSUPPORTED_MEDIA_TYPE",    "Standard 415 media type error (JSON error code: 3170058)" } },
    //{ 0x82305F0C,{ "SCE_NP_WEBAPI_SERVER_ERROR_SOCIAL_NETWORK_3RD_PARTY_RATE_LIMIT_EXCEEDED", "Rate limt of 3rd party service such as Twitter was exceeded (JSON error code: 3170060)" } },
    //{ 0x82305F12,{ "SCE_NP_WEBAPI_SERVER_ERROR_SOCIAL_NETWORK_INVALID_PSN_ACCESS_TOKEN",  "Access token is invalid (JSON error code: 3170066)" } },
    //{ 0x82305F13,{ "SCE_NP_WEBAPI_SERVER_ERROR_SOCIAL_NETWORK_INVALID_3RD_PARTY_TOKEN",   "Facebook/twitter token is invalid (JSON error code: 3170067)" } },
    //{ 0x82305F21,{ "SCE_NP_WEBAPI_SERVER_ERROR_SOCIAL_NETWORK_REQUIRE_PROFILE_UPDATE",    "The user's account needs to be updated (JSON error code: 3170081)" } },
    //{ 0x82305F22,{ "SCE_NP_WEBAPI_SERVER_ERROR_SOCIAL_NETWORK_REQUIRE_AUTHORIZATION", "The user's account needs to be relinked. (JSON error code: 3170082)" } },
    //{ 0x82305F38,{ "SCE_NP_WEBAPI_SERVER_ERROR_SOCIAL_NETWORK_INVALID_JSON",  "Invalid JSON was supplied (JSON error code: 3170104)" } },
    //{ 0x82305F43,{ "SCE_NP_WEBAPI_SERVER_ERROR_SOCIAL_NETWORK_PROXY_AUTH_FAILURE",    "Error occurred when trying to retrieve the proxy auth token from Facebook (JSON error code: 3170115)" } },
    //{ 0x82305F45,{ "SCE_NP_WEBAPI_SERVER_ERROR_SOCIAL_NETWORK_NON_REGISTERED_TITLE_ID",   "Supplied title id was invalid when trying to retrieve the proxy auth token from Facebook (JSON error code: 3170117)" } },
    //{ 0x82305F64,{ "SCE_NP_WEBAPI_SERVER_ERROR_SOCIAL_NETWORK_NOT_AUTHORIZED",    "The user is not authorized to call this API (JSON error code: 3170148)" } },
    //{ 0x82305F65,{ "SCE_NP_WEBAPI_SERVER_ERROR_SOCIAL_NETWORK_NOT_ALLOWED",   "HTTP method is not allowed (JSON error code: 3170149)" } },
    //{ 0x82305F66,{ "SCE_NP_WEBAPI_SERVER_ERROR_SOCIAL_NETWORK_FORBIDDEN", "The user is forbidden to access the API (JSON error code: 3170150)" } },
    //{ 0x82305F67,{ "SCE_NP_WEBAPI_SERVER_ERROR_SOCIAL_NETWORK_REQUEST_TOO_LONG",  "Standard 413 request too long error (JSON error code: 3170151)" } },
    //{ 0x82305F68,{ "SCE_NP_WEBAPI_SERVER_ERROR_SOCIAL_NETWORK_REQUEST_URI_TOO_LONG",  "Standard 414 uri too long error (JSON error code: 3170152)" } },
    //{ 0x82305F69,{ "SCE_NP_WEBAPI_SERVER_ERROR_SOCIAL_NETWORK_HTTP_NOT_IMPLEMENTED",  "HTTP is not implemented (JSON error code: 3170153)" } },
    //{ 0x82307201,{ "SCE_NP_WEBAPI_SERVER_ERROR_AUTH_ACCOUNT_UNAUTHORIZED",    "Invalid access token (JSON error code: 3174913)" } },
    //{ 0x82307842,{ "SCE_NP_WEBAPI_SERVER_ERROR_AUTH_ACCOUNT_BAD_REQUEST", "Details are unknown, but an invalid value was included in request (header, body, query string, etc.) (JSON error code: 3176514)" } },
    //{ 0x82307845,{ "SCE_NP_WEBAPI_SERVER_ERROR_AUTH_ACCOUNT_MANDATORY_ACCOUNT_ATTRIBUTE_MISSING", "Access was performed with an account that has not been upgraded (only for access from companion applications/application servers/websites) (JSON error code: 3176517)" } },
    //{ 0x82307850,{ "SCE_NP_WEBAPI_SERVER_ERROR_AUTH_ACCOUNT_INTERNAL_SERVER_ERROR",   "Internal error of the server (JSON error code: 3176528)" } },
    //{ 0x8230CF01,{ "SCE_NP_WEBAPI_SERVER_ERROR_FRIEND_FINDER_INVALID_REQUEST",    "The request sent was not valid (JSON error code: 3198721)" } },
    //{ 0x8230CF02,{ "SCE_NP_WEBAPI_SERVER_ERROR_FRIEND_FINDER_INTERNAL_ERROR", "Internal error occurred (JSON error code: 3198722)" } },
    //{ 0x8230CF03,{ "SCE_NP_WEBAPI_SERVER_ERROR_FRIEND_FINDER_SERVICE_UNAVAILABLE",    "Server is undergoing maintenance (JSON error code: 3198723)" } },
    //{ 0x8230CF04,{ "SCE_NP_WEBAPI_SERVER_ERROR_FRIEND_FINDER_RESOURCE_NOT_FOUND", "Resource was not found (JSON error code: 3198724)" } },
    //{ 0x8230CF05,{ "SCE_NP_WEBAPI_SERVER_ERROR_FRIEND_FINDER_INVALID_PARAMETER",  "Parameter was invalid (JSON error code: 3198725)" } },
    //{ 0x8230CF08,{ "SCE_NP_WEBAPI_SERVER_ERROR_FRIEND_FINDER_SERVER_ERROR",   "Unexpected error from the server (JSON error code: 3198728)" } },
    //{ 0x8230CF12,{ "SCE_NP_WEBAPI_SERVER_ERROR_FRIEND_FINDER_INVALID_PSN_ACCESS_TOKEN",   "Access token is invalid (JSON error code: 3198738)" } },
    //{ 0x8230CF38,{ "SCE_NP_WEBAPI_SERVER_ERROR_FRIEND_FINDER_INVALID_JSON",   "Invalid JSON was supplied (JSON error code: 3198776)" } },
    //{ 0x8230CF3E,{ "SCE_NP_WEBAPI_SERVER_ERROR_FRIEND_FINDER_GET_RATE_LIMIT_EXCEEDED",    "Rate limit was exceeded (JSON error code: 3198782)" } },
    //{ 0x8230CF66,{ "SCE_NP_WEBAPI_SERVER_ERROR_FRIEND_FINDER_FORBIDDEN",  "The user is forbidden to access the API (JSON error code: 3198822)" } },
    //{ 0x8230DF01,{ "SCE_NP_WEBAPI_SERVER_ERROR_COMMUNITY_INVALID_REQUEST",    "Bad Parameter (JSON error code: 3202817)" } },
    //{ 0x8230DF02,{ "SCE_NP_WEBAPI_SERVER_ERROR_COMMUNITY_INTERNAL_ERROR", "Internal Server Error (JSON error code: 3202818)" } },
    //{ 0x8230DF03,{ "SCE_NP_WEBAPI_SERVER_ERROR_COMMUNITY_SERVICE_UNAVAILABLE",    "Server is under maintenance (JSON error code: 3202819)" } },
    //{ 0x8230DF05,{ "SCE_NP_WEBAPI_SERVER_ERROR_COMMUNITY_INVALID_PARAMETER",  "Invalid parameter (JSON error code: 3202821)" } },
    //{ 0x8230DF06,{ "SCE_NP_WEBAPI_SERVER_ERROR_COMMUNITY_DATA_ACCESS_ERROR",  "Internal Database Error (JSON error code: 3202822)" } },
    //{ 0x8230DF08,{ "SCE_NP_WEBAPI_SERVER_ERROR_COMMUNITY_SERVER_ERROR",   "Internal Server Error (JSON error code: 3202824)" } },
    //{ 0x8230DF09,{ "SCE_NP_WEBAPI_SERVER_ERROR_COMMUNITY_CLIENT_ERROR",   "Internal Communication Error (JSON error code: 3202825)" } },
    //{ 0x8230DF0C,{ "SCE_NP_WEBAPI_SERVER_ERROR_COMMUNITY_RATE_LIMIT_EXCEEDED",    "Rate Limit Exceeded (JSON error code: 3202828)" } },
    //{ 0x8230DF12,{ "SCE_NP_WEBAPI_SERVER_ERROR_COMMUNITY_INVALID_PSN_ACCESS_TOKEN",   "Expired Oauth Access Token (JSON error code: 3202834)" } },
    //{ 0x8230DF81,{ "SCE_NP_WEBAPI_SERVER_ERROR_COMMUNITY_DATA_NOT_FOUND", "No Data Found (JSON error code: 3202945)" } },
    //{ 0x8230DF83,{ "SCE_NP_WEBAPI_SERVER_ERROR_COMMUNITY_UNAVAILABLE_FOR_LEGAL_REASONS",  "Feature is not available in your country (JSON error code: 3202947)" } },
    //{ 0x8230DFA0,{ "SCE_NP_WEBAPI_SERVER_ERROR_COMMUNITY_UNABLE_TO_DELETE_DEFAULT_LIVE_THREAD",   "General Discussion Wall Thread cannot be deleted. (JSON error code: 3202976)" } },
    //{ 0x8230DFA1,{ "SCE_NP_WEBAPI_SERVER_ERROR_COMMUNITY_LIVE_THREAD_NOT_FOUND",  "Discussion Wall Thread is not found. (JSON error code: 3202977)" } },
    //{ 0x8230DFA2,{ "SCE_NP_WEBAPI_SERVER_ERROR_COMMUNITY_LIVE_THREAD_LIMIT_REACHED",  "Maximum number of threads have been created. (JSON error code: 3202978)" } },
    //{ 0x8230DFA3,{ "SCE_NP_WEBAPI_SERVER_ERROR_COMMUNITY_AGE_RESTRICTED_TITLE",   "Community's Title Content Rating exceeds User's Age (JSON error code: 3202979)" } },
    //{ 0x8230DFA4,{ "SCE_NP_WEBAPI_SERVER_ERROR_COMMUNITY_COMMUNITY_TYPE_REQUIRED",    "Community Type is not set (JSON error code: 3202980)" } },
    //{ 0x8230DFA5,{ "SCE_NP_WEBAPI_SERVER_ERROR_COMMUNITY_DESCRIPTION_EXCEEDS_CHARACTER_LIMIT",    "Community Description exceeds max character limit. (JSON error code: 3202981)" } },
    //{ 0x8230DFA6,{ "SCE_NP_WEBAPI_SERVER_ERROR_COMMUNITY_EMPTY_MESSAGE",  "Wall message is empty (JSON error code: 3202982)" } },
    //{ 0x8230DFA7,{ "SCE_NP_WEBAPI_SERVER_ERROR_COMMUNITY_INAPPROPRIATE_DESCRIPTION",  "Community Description contains profanity. (JSON error code: 3202983)" } },
    //{ 0x8230DFA8,{ "SCE_NP_WEBAPI_SERVER_ERROR_COMMUNITY_INAPPROPRIATE_MESSAGE",  "Community Wall Message contains profanity. (JSON error code: 3202984)" } },
    //{ 0x8230DFA9,{ "SCE_NP_WEBAPI_SERVER_ERROR_COMMUNITY_INAPPROPRIATE_NAME", "Community Name contains profanity. (JSON error code: 3202985)" } },
    //{ 0x8230DFAA,{ "SCE_NP_WEBAPI_SERVER_ERROR_COMMUNITY_INVALID_LANGUAGE_CODE",  "Community language is invalid (JSON error code: 3202986)" } },
    //{ 0x8230DFAB,{ "SCE_NP_WEBAPI_SERVER_ERROR_COMMUNITY_INVALID_STATE",  "Community creation flow is in an invalid state. (JSON error code: 3202987)" } },
    //{ 0x8230DFAC,{ "SCE_NP_WEBAPI_SERVER_ERROR_COMMUNITY_UNAVAILABLE_TITLE",  "Title chosen is no longer unavailable. (JSON error code: 3202988)" } },
    //{ 0x8230DFAE,{ "SCE_NP_WEBAPI_SERVER_ERROR_COMMUNITY_INVALID_NAME",   "Community name contains unsupported characters. (JSON error code: 3202990)" } },
    //{ 0x82317F02,{ "SCE_NP_WEBAPI_SERVER_ERROR_GAME_LIST_INTERNAL_ERROR", "Internal Server Error (JSON error code: 3243778)" } },
    //{ 0x82317F05,{ "SCE_NP_WEBAPI_SERVER_ERROR_GAME_LIST_INVALID_PARAMETER",  "Invalid parameter (JSON error code: 3243781)" } },
    //{ 0x82317F12,{ "SCE_NP_WEBAPI_SERVER_ERROR_GAME_LIST_INVALID_PSN_ACCESS_TOKEN",   "Expired Oauth Access Token (JSON error code: 3243794)" } },
    //{ 0x82317F65,{ "SCE_NP_WEBAPI_SERVER_ERROR_GAME_LIST_NOT_ALLOWED",    "HTTP method is not allowed (JSON error code: 3243877)" } },
    //{ 0x82317F66,{ "SCE_NP_WEBAPI_SERVER_ERROR_GAME_LIST_FORBIDDEN",  "The user is forbidden to access the API (JSON error code: 3243878)" } },
    //{ 0x82318502,{ "SCE_NP_WEBAPI_SERVER_ERROR_SHARED_MEDIA_INVALID_TITLE_ID_LOOKUP", "Internal error occurred while looking up title ID (JSON error code: 3245314)" } },
    //{ 0x82318F01,{ "SCE_NP_WEBAPI_SERVER_ERROR_SHARED_MEDIA_INVALID_ONLINE_ID",   "PSN Online Id of the request is invalid  (JSON error code: 3247873)" } },
    //{ 0x82318F44,{ "SCE_NP_WEBAPI_SERVER_ERROR_SHARED_MEDIA_INVALID_APP_ID",  "App Id of the requester is invalid (JSON error code: 3247940)" } },
    //{ 0x82E00002,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_2_UNKNOWN_ERROR_HAS_OCCURRED",   "An unknown error has occurred (JSON error code: 2)" } },
    //{ 0x82E00012,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_18_NEEDS_SOFTWARE_UPDATE",   "Needs software update. A Version check of Nav server blocked the client. (JSON error code: 18)" } },
    //{ 0x82E00014,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_20_UNMATCH_SIGN_IN_ID_OR_PASSWORD",  "Unmatch sign-in ID or password (JSON error code: 20)" } },
    //{ 0x82E0001B,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_27_ACCOUNT_HAS_BEEN_REMOVED_LOGICALLY",  "The account has been removed logically. (JSON error code: 27)" } },
    //{ 0x82E0001C,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_28_ACCOUNT_HAS_BEEN_BANNED", "The account has been banned. (JSON error code: 28)" } },
    //{ 0x82E0001D,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_29_CONSOLE_HAS_BEEN_BANNED", "The console has been banned (JSON error code: 29)" } },
    //{ 0x82E00033,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_51_NEEDS_EMAIL_VERIFICATION",    "The user needs E-mail verification in order to complete account registration (JSON error code: 51)" } },
    //{ 0x82E00033,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_51_ERROR_CODE_RESERVED_FOR_FUTURE_USE",  "[obsolete]Error code reserved for future use (JSON error code: 51)" } },
    //{ 0x82E00064,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_100_PASSWORD_WAS_RESET_BY_SERVER",   "Password was reset by server. (JSON error code: 100)" } },
    //{ 0x82E00067,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_103_NEEDS_EULA_RE_AGREEMENT",    "Needs eula re-agreement (JSON error code: 103)" } },
    //{ 0x82E01027,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_4135_NEEDS_UPGRADE_TO_USE_PSN_SERVICE",  "Needs upgrade to use PSN service (JSON error code: 4135)" } },
    //{ 0x82E01039,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_4153_INVALID_SCOPE", "Invalid scope. This will be returned when a title uses wrong scope to get the authorization code via NpAuth library. (JSON error code: 4153)" } },
    //{ 0x82E0103D,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_4157_SERVER_ERROR",  "server_error (JSON error code: 4157)" } },
    //{ 0x82E0103E,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_4158_TEMPORARILY_UNAVAILABLE",   "temporarily_unavailable (JSON error code: 4158)" } },
    //{ 0x82E01040,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_4160_NO_DETAILS_AVAILABLE",  "No details available (JSON error code: 4160)" } },
    //{ 0x82E01041,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_4161_CLIENT_WAS_NOT_FOUND",  "The client was not found (JSON error code: 4161)" } },
    //{ 0x82E01042,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_4162_ACCOUNT_MUST_BE_SUBACCOUNT_AND_NEEDS_EULA_RE_AGREEMENT",    "The account must be subaccount and needs eula re-agreement (JSON error code: 4162)" } },
    //{ 0x82E01045,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_4165_PASSWORD_WAS_PROBABLY_CHANGED", "Password was probably changed. (JSON error code: 4165)" } },
    //{ 0x82E0104D,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_4173_INVALID_CLIENT",    "Invalid client. This will be returned when a title uses wrong client id to get the authorization code via NpAuth library. (JSON error code: 4173)" } },
    //{ 0x82E01050,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_4176_ACCOUNT_HAS_BEEN_BANNED",   "The account has been banned. (JSON error code: 4176)" } },
    //{ 0x82E01067,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_4199_SERVICE_HAS_ENDED", "Service has ended. (JSON error code: 4199)" } },
    //{ 0x82E0106A,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_4202_SERVICE_IS_UNDER_MAINTENANCE",  "Service is under maintenance. (JSON error code: 4202)" } },
    //{ 0x82E10064,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_100_CONTINUE",  "HTTP status code 100 was returned (HTTP status code: 100)" } },
    //{ 0x82E10065,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_101_SWITCHING_PROTOCOLS",   "HTTP status code 101 was returned (HTTP status code: 101)" } },
    //{ 0x82E10066,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_102_PROCESSING",    "HTTP status code 102 was returned (HTTP status code: 102)" } },
    //{ 0x82E100C8,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_200_OK",    "Request was successful (HTTP status code: 200)" } },
    //{ 0x82E100C9,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_201_CREATED",   "Request was successful (HTTP status code: 201)" } },
    //{ 0x82E100CA,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_202_ACCEPTED",  "Request was successful (HTTP status code: 202)" } },
    //{ 0x82E100CB,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_203_NON_AUTHORITATIVE_INFORMATION", "Request was successful (HTTP status code: 203)" } },
    //{ 0x82E100CC,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_204_NO_CONTENT",    "Request was successful (HTTP status code: 204)" } },
    //{ 0x82E100CD,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_205_RESET_CONTENT", "Request was successful (HTTP status code: 205)" } },
    //{ 0x82E100CE,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_206_PARTIAL_CONTENT",   "Request was successful (HTTP status code: 206)" } },
    //{ 0x82E100CF,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_207_MULTI_STATUS",  "Request was successful (HTTP status code: 207)" } },
    //{ 0x82E100D0,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_208_ALREADY_REPORTED",  "Request was successful (HTTP status code: 208)" } },
    //{ 0x82E100E2,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_226_IM_USED",   "Request was successful (HTTP status code: 226)" } },
    //{ 0x82E1012C,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_300_MULTIPLE_CHOICES",  "HTTP status code 300 was returned (HTTP status code: 300)" } },
    //{ 0x82E1012D,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_301_MOVED_PERMANENTLY", "HTTP status code 301 was returned (HTTP status code: 301)" } },
    //{ 0x82E1012E,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_302_FOUND", "HTTP status code 302 was returned (HTTP status code: 302)" } },
    //{ 0x82E1012F,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_303_SEE_OTHER", "HTTP status code 303 was returned (HTTP status code: 303)" } },
    //{ 0x82E10130,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_304_NOT_MODIFIED",  "HTTP status code 304 was returned (HTTP status code: 304)" } },
    //{ 0x82E10131,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_305_USE_PROXY", "HTTP status code 305 was returned (HTTP status code: 305)" } },
    //{ 0x82E10132,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_306_SWITCH_PROXY",  "HTTP status code 306 was returned (HTTP status code: 306)" } },
    //{ 0x82E10133,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_307_TEMPORARY_REDIRECT",    "HTTP status code 307 was returned (HTTP status code: 307)" } },
    //{ 0x82E10134,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_308_PERMANENT_REDIRECT",    "HTTP status code 308 was returned (HTTP status code: 308)" } },
    //{ 0x82E10190,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_400_BAD_REQUEST",   "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 400)" } },
    //{ 0x82E10191,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_401_UNAUTHORIZED",  "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 401)" } },
    //{ 0x82E10192,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_402_PAYMENT_REQUIRED",  "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 402)" } },
    //{ 0x82E10193,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_403_FORBIDDEN", "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 403)" } },
    //{ 0x82E10194,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_404_NOT_FOUND", "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 404)" } },
    //{ 0x82E10195,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_405_METHOD_NOT_ALLOWED",    "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 405)" } },
    //{ 0x82E10196,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_406_NOT_ACCEPTABLE",    "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 406)" } },
    //{ 0x82E10197,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_407_PROXY_AUTHENTICATION_REQUIRED", "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 407)" } },
    //{ 0x82E10198,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_408_REQUEST_TIMEOUT",   "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 408)" } },
    //{ 0x82E10199,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_409_CONFLICT",  "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 409)" } },
    //{ 0x82E1019A,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_410_GONE",  "PSN service has closed (HTTP status code: 410)" } },
    //{ 0x82E1019B,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_411_LENGTH_REQUIRED",   "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 411)" } },
    //{ 0x82E1019C,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_412_PRECONDITION_FAILED",   "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 412)" } },
    //{ 0x82E1019D,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_413_REQUEST_ENTITY_TOO_LARGE",  "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 413)" } },
    //{ 0x82E1019E,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_414_REQUEST_URI_TOO_LONG",  "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 414)" } },
    //{ 0x82E1019F,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_415_UNSUPPORTED_MEDIA_TYPE",    "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 415)" } },
    //{ 0x82E101A0,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_416_REQUESTED_RANGE_NOT_SATISFIABLE",   "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 416)" } },
    //{ 0x82E101A1,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_417_EXPECTATION_FAILED",    "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 417)" } },
    //{ 0x82E101A2,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_418_I_M_A_TEAPOT",  "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 418)" } },
    //{ 0x82E101A3,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_419_AUTHENTICATION_TIMEOUT",    "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 419)" } },
    //{ 0x82E101A4,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_420_METHOD_FAILURE_ENHANCE_YOUR_CALM",  "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 420)" } },
    //{ 0x82E101A6,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_422_UNPROCESSABLE_ENTITY",  "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 422)" } },
    //{ 0x82E101A7,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_423_LOCKED",    "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 423)" } },
    //{ 0x82E101A8,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_424_FAILED_DEPENDENCY", "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 424)" } },
    //{ 0x82E101A9,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_425_METHOD_FAILURE",    "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 425)" } },
    //{ 0x82E101AA,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_426_UNORDERED_COLLECTION",  "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 426)" } },
    //{ 0x82E101AB,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_427_UPGRADE_REQUIRED",  "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 427)" } },
    //{ 0x82E101AC,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_428_PRECONDITION_REQUIRED", "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 428)" } },
    //{ 0x82E101AD,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_429_TOO_MANY_REQUESTS", "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 429)" } },
    //{ 0x82E101AF,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_431_REQUEST_HEADER_FIELDS_TOO_LARGE",   "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 431)" } },
    //{ 0x82E101BC,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_444_NO_RESPONSE",   "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 444)" } },
    //{ 0x82E101C1,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_449_RETRY_WITH",    "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 449)" } },
    //{ 0x82E101C2,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_450_BLOCKED_BY_WINDOWS_PARENTAL_CONTROLS",  "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 450)" } },
    //{ 0x82E101C3,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_451_UNAVAILABLE_FOR_LEGAL_REASONS", "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 451)" } },
    //{ 0x82E101F3,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_499_CLIENT_CLOSED_REQUEST", "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 499)" } },
    //{ 0x82E101F4,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_500_INTERNAL_SERVER_ERROR", "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 500)" } },
    //{ 0x82E101F5,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_501_NOT_IMPLEMENTED",   "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 501)" } },
    //{ 0x82E101F6,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_502_BAD_GATEWAY",   "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 502)" } },
    //{ 0x82E101F7,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_503_SERVICE_UNAVAILABLE",   "Server is under maintenance (HTTP status code: 503)" } },
    //{ 0x82E101F8,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_504_GATEWAY_TIMEOUT",   "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 504)" } },
    //{ 0x82E101F9,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_505_HTTP_VERSION_NOT_SUPPORTED",    "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 505)" } },
    //{ 0x82E101FA,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_506_VARIANT_ALSO_NEGOTIATES",   "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 506)" } },
    //{ 0x82E101FB,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_507_INSUFFICIENT_STORAGE",  "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 507)" } },
    //{ 0x82E101FC,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_508_LOOP_DETECTED", "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 508)" } },
    //{ 0x82E101FD,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_509_BANDWIDTH_LIMIT_EXCEEDED",  "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 509)" } },
    //{ 0x82E101FE,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_510_NOT_EXTENDED",  "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 510)" } },
    //{ 0x82E101FF,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_511_NETWORK_AUTHENTICATION_REQUIRED",   "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 511)" } },
    //{ 0x82E1020A,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_522_CONNECTION_TIMED_OUT",  "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 522)" } },
    //{ 0x82E10256,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_598_NETWORK_READ_TIMEOUT_ERROR",    "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 598)" } },
    //{ 0x82E10257,{ "SCE_NP_WEBAPI_SERVER_ERROR_OAUTH_HTTP_STATUS_CODE_599_NETWORK_CONNECT_TIMEOUT_ERROR", "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 599)" } },
    //{ 0x82F00064,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_100_CONTINUE",    "HTTP status code 100 was returned (HTTP status code: 100)" } },
    //{ 0x82F00065,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_101_SWITCHING_PROTOCOLS", "HTTP status code 101 was returned (HTTP status code: 101)" } },
    //{ 0x82F00066,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_102_PROCESSING",  "HTTP status code 102 was returned (HTTP status code: 102)" } },
    //{ 0x82F000C8,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_200_OK",  "Request was successful (HTTP status code: 200)" } },
    //{ 0x82F000C9,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_201_CREATED", "Request was successful (HTTP status code: 201)" } },
    //{ 0x82F000CA,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_202_ACCEPTED",    "Request was successful (HTTP status code: 202)" } },
    //{ 0x82F000CB,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_203_NON_AUTHORITATIVE_INFORMATION",   "Request was successful (HTTP status code: 203)" } },
    //{ 0x82F000CC,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_204_NO_CONTENT",  "Request was successful (HTTP status code: 204)" } },
    //{ 0x82F000CD,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_205_RESET_CONTENT",   "Request was successful (HTTP status code: 205)" } },
    //{ 0x82F000CE,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_206_PARTIAL_CONTENT", "Request was successful (HTTP status code: 206)" } },
    //{ 0x82F000CF,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_207_MULTI_STATUS",    "Request was successful (HTTP status code: 207)" } },
    //{ 0x82F000D0,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_208_ALREADY_REPORTED",    "Request was successful (HTTP status code: 208)" } },
    //{ 0x82F000E2,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_226_IM_USED", "Request was successful (HTTP status code: 226)" } },
    //{ 0x82F0012C,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_300_MULTIPLE_CHOICES",    "HTTP status code 300 was returned (HTTP status code: 300)" } },
    //{ 0x82F0012D,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_301_MOVED_PERMANENTLY",   "HTTP status code 301 was returned (HTTP status code: 301)" } },
    //{ 0x82F0012E,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_302_FOUND",   "HTTP status code 302 was returned (HTTP status code: 302)" } },
    //{ 0x82F0012F,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_303_SEE_OTHER",   "HTTP status code 303 was returned (HTTP status code: 303)" } },
    //{ 0x82F00130,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_304_NOT_MODIFIED",    "HTTP status code 304 was returned (HTTP status code: 304)" } },
    //{ 0x82F00131,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_305_USE_PROXY",   "HTTP status code 305 was returned (HTTP status code: 305)" } },
    //{ 0x82F00132,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_306_SWITCH_PROXY",    "HTTP status code 306 was returned (HTTP status code: 306)" } },
    //{ 0x82F00133,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_307_TEMPORARY_REDIRECT",  "HTTP status code 307 was returned (HTTP status code: 307)" } },
    //{ 0x82F00134,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_308_PERMANENT_REDIRECT",  "HTTP status code 308 was returned (HTTP status code: 308)" } },
    //{ 0x82F00190,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_400_BAD_REQUEST", "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 400)" } },
    //{ 0x82F00191,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_401_UNAUTHORIZED",    "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 401)" } },
    //{ 0x82F00192,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_402_PAYMENT_REQUIRED",    "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 402)" } },
    //{ 0x82F00193,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_403_FORBIDDEN",   "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 403)" } },
    //{ 0x82F00194,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_404_NOT_FOUND",   "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 404)" } },
    //{ 0x82F00195,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_405_METHOD_NOT_ALLOWED",  "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 405)" } },
    //{ 0x82F00196,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_406_NOT_ACCEPTABLE",  "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 406)" } },
    //{ 0x82F00197,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_407_PROXY_AUTHENTICATION_REQUIRED",   "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 407)" } },
    //{ 0x82F00198,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_408_REQUEST_TIMEOUT", "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 408)" } },
    //{ 0x82F00199,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_409_CONFLICT",    "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 409)" } },
    //{ 0x82F0019A,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_410_GONE",    "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 410)" } },
    //{ 0x82F0019B,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_411_LENGTH_REQUIRED", "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 411)" } },
    //{ 0x82F0019C,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_412_PRECONDITION_FAILED", "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 412)" } },
    //{ 0x82F0019D,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_413_REQUEST_ENTITY_TOO_LARGE",    "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 413)" } },
    //{ 0x82F0019E,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_414_REQUEST_URI_TOO_LONG",    "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 414)" } },
    //{ 0x82F0019F,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_415_UNSUPPORTED_MEDIA_TYPE",  "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 415)" } },
    //{ 0x82F001A0,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_416_REQUESTED_RANGE_NOT_SATISFIABLE", "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 416)" } },
    //{ 0x82F001A1,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_417_EXPECTATION_FAILED",  "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 417)" } },
    //{ 0x82F001A2,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_418_I_M_A_TEAPOT",    "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 418)" } },
    //{ 0x82F001A3,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_419_AUTHENTICATION_TIMEOUT",  "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 419)" } },
    //{ 0x82F001A4,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_420_METHOD_FAILURE_ENHANCE_YOUR_CALM",    "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 420)" } },
    //{ 0x82F001A6,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_422_UNPROCESSABLE_ENTITY",    "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 422)" } },
    //{ 0x82F001A7,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_423_LOCKED",  "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 423)" } },
    //{ 0x82F001A8,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_424_FAILED_DEPENDENCY",   "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 424)" } },
    //{ 0x82F001A9,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_425_METHOD_FAILURE",  "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 425)" } },
    //{ 0x82F001AA,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_426_UNORDERED_COLLECTION",    "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 426)" } },
    //{ 0x82F001AB,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_427_UPGRADE_REQUIRED",    "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 427)" } },
    //{ 0x82F001AC,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_428_PRECONDITION_REQUIRED",   "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 428)" } },
    //{ 0x82F001AD,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_429_TOO_MANY_REQUESTS",   "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 429)" } },
    //{ 0x82F001AF,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_431_REQUEST_HEADER_FIELDS_TOO_LARGE", "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 431)" } },
    //{ 0x82F001BC,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_444_NO_RESPONSE", "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 444)" } },
    //{ 0x82F001C1,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_449_RETRY_WITH",  "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 449)" } },
    //{ 0x82F001C2,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_450_BLOCKED_BY_WINDOWS_PARENTAL_CONTROLS",    "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 450)" } },
    //{ 0x82F001C3,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_451_UNAVAILABLE_FOR_LEGAL_REASONS",   "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 451)" } },
    //{ 0x82F001F3,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_499_CLIENT_CLOSED_REQUEST",   "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 499)" } },
    //{ 0x82F001F4,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_500_INTERNAL_SERVER_ERROR",   "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 500)" } },
    //{ 0x82F001F5,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_501_NOT_IMPLEMENTED", "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 501)" } },
    //{ 0x82F001F6,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_502_BAD_GATEWAY", "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 502)" } },
    //{ 0x82F001F7,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_503_SERVICE_UNAVAILABLE", "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 503)" } },
    //{ 0x82F001F8,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_504_GATEWAY_TIMEOUT", "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 504)" } },
    //{ 0x82F001F9,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_505_HTTP_VERSION_NOT_SUPPORTED",  "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 505)" } },
    //{ 0x82F001FA,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_506_VARIANT_ALSO_NEGOTIATES", "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 506)" } },
    //{ 0x82F001FB,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_507_INSUFFICIENT_STORAGE",    "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 507)" } },
    //{ 0x82F001FC,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_508_LOOP_DETECTED",   "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 508)" } },
    //{ 0x82F001FD,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_509_BANDWIDTH_LIMIT_EXCEEDED",    "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 509)" } },
    //{ 0x82F001FE,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_510_NOT_EXTENDED",    "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 510)" } },
    //{ 0x82F001FF,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_511_NETWORK_AUTHENTICATION_REQUIRED", "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 511)" } },
    //{ 0x82F0020A,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_522_CONNECTION_TIMED_OUT",    "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 522)" } },
    //{ 0x82F00256,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_598_NETWORK_READ_TIMEOUT_ERROR",  "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 598)" } },
    //{ 0x82F00257,{ "SCE_NP_WEBAPI_SERVER_ERROR_HTTP_STATUS_CODE_599_NETWORK_CONNECT_TIMEOUT_ERROR",   "Error occurred and the HTTP status code with or without non-JSON body was returned (HTTP status code: 599)" } },
    { 0x82FFFFFF, { "SCE_NP_WEBAPI_SERVER_ERROR_UNEXPECTED_ERROR",   "Unexpected Error" } },
};

void PS4Platform::sceErrorToString(int errorCode, std::string &canonical, std::string &description)
{
    Ps4ErrorMap::const_iterator it = ps4Errors.find(errorCode);

    if (it == ps4Errors.end()) {
        std::stringstream stream;
        stream << "0x" << std::hex << errorCode;
        canonical = std::string(stream.str());
        description = "Generic: " + std::string(stream.str());
        return;
    }

    canonical = (*it).second.first;
    description = (*it).second.second;
}
