// Code based on PS4 3.500 SDK Sony Samples

#pragma once

#include "AudioSystem.hpp"
#include "RingBuffer.hpp"
#include <stdint.h>

namespace twitch {
namespace ps4 {
    class Stream {
    public:
        Stream(uint32_t size, uint32_t sizeHead)
            : m_buffer(new RingBuffer(size, sizeHead))
        {
        }
        virtual ~Stream(void) {}
        virtual int open(const char* path, const char* mode) = 0;
        virtual int open(int32_t grain, int32_t sampleRate, int32_t param, float volume) = 0;
        virtual int close(void) = 0;
        virtual uint32_t size(void) { return 0; }
        uint32_t bufferSize(void) { return m_buffer->size(); }

        const RingBuffer& getRingBuffer() const { return *m_buffer; }
        RingBuffer& getRingBuffer() { return *m_buffer; }

        virtual void start() { }
        virtual void stop() {}

    protected:
        std::unique_ptr<RingBuffer> m_buffer;
    };

    class OutputStream : public Stream {
    public:
        OutputStream(uint32_t size, uint32_t sizeHead)
            : Stream(size, sizeHead)
        {
        }
        virtual ~OutputStream(void) {}
        virtual int output(uint32_t size = 0) = 0;
        uint8_t* lock(uint32_t size = 0) { return m_buffer->lockWritingRoom(size); }
        int unlock(uint32_t size) { return m_buffer->unlockWritingRoom(size); }
        uint32_t writingSize(void) { return m_buffer->writingSize(); }
    };
}
}