#include "VideoFrame.hpp"
#include "VideoSample.hpp"

namespace twitch {
namespace ps4 {

    VideoFrame::VideoFrame(Listener& listener, const std::shared_ptr<const VideoSample>& sample)
        : m_listener(listener)
        , m_sample(sample)
    {
    }

    VideoFrame::~VideoFrame()
    {
        if (!m_finished) {
            // TRACE_DEBUG("~VideoFrame: Dropped frame ID %ld", m_sample->id);
        }
    }

    const SceVideodec2OutputInfo& VideoFrame::getOutputInfo() const
    {
        return m_sample->outputInfo;
    }

    const SceVideodec2AvcPictureInfo& VideoFrame::getPictureInfo() const
    {
        return m_sample->getPicture(0);
    }

    bool VideoFrame::isFinished() const
    {
        return m_finished;
    }

    void VideoFrame::finish()
    {
        // Check to see if finish() has been called yet to prevent multiple
        // invocations on our callback
        if (m_finished) {
            //TRACE_DEBUG("VideoFrame::finish() rendering twice for PTS: %f", m_sample->getPresentationTime().seconds());
            return;
        } else {
            m_finished = true;
        }

        m_listener.onFrameRendered(*this);
    }

    void VideoFrame::flush()
    {
        // Don't allow callback to update render time
        m_finished = true;
    }
}
}
